/* search.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from search.vala, do not modify */

/* SPDX-FileCopyrightText: 2010-2025 Sébastien Wilmet
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtex.h>
#include <gtksourceview/gtksource.h>
#include <glib.h>
#include <tepl/tepl.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SEARCH_AND_REPLACE (search_and_replace_get_type ())
#define SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplace))
#define SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))
#define IS_SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_AND_REPLACE))
#define IS_SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_AND_REPLACE))
#define SEARCH_AND_REPLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))

typedef struct _SearchAndReplace SearchAndReplace;
typedef struct _SearchAndReplaceClass SearchAndReplaceClass;
typedef struct _SearchAndReplacePrivate SearchAndReplacePrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
enum  {
	SEARCH_AND_REPLACE_0_PROPERTY,
	SEARCH_AND_REPLACE_NUM_PROPERTIES
};
static GParamSpec* search_and_replace_properties[SEARCH_AND_REPLACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DocumentPrivate DocumentPrivate;

struct _SearchAndReplace {
	GObject parent_instance;
	SearchAndReplacePrivate * priv;
};

struct _SearchAndReplaceClass {
	GObjectClass parent_class;
};

struct _SearchAndReplacePrivate {
	MainWindow* _main_window;
	GtexFindBar* _find_bar;
	GtkSourceSearchSettings* _search_settings;
	GtkSourceSearchContext* _search_context;
};

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

static gint SearchAndReplace_private_offset;
static gpointer search_and_replace_parent_class = NULL;

VALA_EXTERN GType search_and_replace_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchAndReplace, g_object_unref)
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN SearchAndReplace* search_and_replace_new (MainWindow* main_window);
VALA_EXTERN SearchAndReplace* search_and_replace_construct (GType object_type,
                                                MainWindow* main_window);
VALA_EXTERN void search_and_replace_hide (SearchAndReplace* self);
static void _search_and_replace_hide_gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self);
static void search_and_replace_search_forward (SearchAndReplace* self);
static void _search_and_replace_search_forward_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self);
static void _search_and_replace_search_forward_gtk_entry_activate (GtkEntry* _sender,
                                                            gpointer self);
static void _search_and_replace_search_forward_gtk_search_entry_next_match (GtkSearchEntry* _sender,
                                                                     gpointer self);
static void search_and_replace_search_backward (SearchAndReplace* self);
static void _search_and_replace_search_backward_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void _search_and_replace_search_backward_gtk_search_entry_previous_match (GtkSearchEntry* _sender,
                                                                          gpointer self);
static void __lambda74_ (SearchAndReplace* self);
static void ___lambda74__gtk_editable_changed (GtkEditable* _sender,
                                        gpointer self);
static void search_and_replace_replace (SearchAndReplace* self);
static void _search_and_replace_replace_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static void _search_and_replace_replace_gtk_entry_activate (GtkEntry* _sender,
                                                     gpointer self);
static void __lambda75_ (SearchAndReplace* self);
VALA_EXTERN GType document_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
VALA_EXTERN DocumentView* main_window_get_active_view (MainWindow* self);
VALA_EXTERN GtkSourceCompletion* gtk_source_view_get_completion (GtkSourceView* self);
static void ___lambda75__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void _search_and_replace_hide_gtk_search_entry_stop_search (GtkSearchEntry* _sender,
                                                            gpointer self);
static gboolean __lambda76_ (SearchAndReplace* self,
                      GdkEventKey* event);
VALA_EXTERN void search_and_replace_show_search_and_replace (SearchAndReplace* self);
static gboolean ___lambda76__gtk_widget_key_press_event (GtkWidget* _sender,
                                                  GdkEventKey* event,
                                                  gpointer self);
VALA_EXTERN GtkWidget* search_and_replace_get_widget (SearchAndReplace* self);
VALA_EXTERN void search_and_replace_show_search (SearchAndReplace* self);
static void search_and_replace_show (SearchAndReplace* self);
VALA_EXTERN GType document_tab_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
VALA_EXTERN DocumentTab* main_window_get_active_tab (MainWindow* self);
VALA_EXTERN GType document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
VALA_EXTERN Document* main_window_get_active_document (MainWindow* self);
static void search_and_replace_connect_active_document (SearchAndReplace* self);
static void _search_and_replace_connect_active_document_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self);
static void search_and_replace_destroy_search_context (SearchAndReplace* self);
static void search_and_replace_mark_set_cb (SearchAndReplace* self,
                                     GtkTextBuffer* buffer,
                                     GtkTextIter* location,
                                     GtkTextMark* mark);
static void _search_and_replace_mark_set_cb_gtk_text_buffer_mark_set (GtkTextBuffer* _sender,
                                                               GtkTextIter* location,
                                                               GtkTextMark* mark,
                                                               gpointer self);
static void __lambda73_ (SearchAndReplace* self);
VALA_EXTERN gint gtk_source_search_context_get_occurrences_count (GtkSourceSearchContext* self);
static void search_and_replace_update_info_label (SearchAndReplace* self);
static void ___lambda73__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN gboolean document_get_readonly (Document* self);
VALA_EXTERN TeplView* tepl_tab_get_view (TeplTab* self);
static void search_and_replace_finalize (GObject * obj);
static GType search_and_replace_get_type_once (void);

static inline gpointer
search_and_replace_get_instance_private (SearchAndReplace* self)
{
	return G_STRUCT_MEMBER_P (self, SearchAndReplace_private_offset);
}

static void
_search_and_replace_hide_gtk_button_clicked (GtkButton* _sender,
                                             gpointer self)
{
	search_and_replace_hide ((SearchAndReplace*) self);
}

static void
_search_and_replace_search_forward_gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self)
{
	search_and_replace_search_forward ((SearchAndReplace*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_search_and_replace_search_forward_gtk_entry_activate (GtkEntry* _sender,
                                                       gpointer self)
{
	search_and_replace_search_forward ((SearchAndReplace*) self);
}

static void
_search_and_replace_search_forward_gtk_search_entry_next_match (GtkSearchEntry* _sender,
                                                                gpointer self)
{
	search_and_replace_search_forward ((SearchAndReplace*) self);
}

static void
_search_and_replace_search_backward_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
	search_and_replace_search_backward ((SearchAndReplace*) self);
}

static void
_search_and_replace_search_backward_gtk_search_entry_previous_match (GtkSearchEntry* _sender,
                                                                     gpointer self)
{
	search_and_replace_search_backward ((SearchAndReplace*) self);
}

static void
__lambda74_ (SearchAndReplace* self)
{
	gboolean sensitive = FALSE;
	GtexFindBar* _tmp0_;
	GtkSearchEntry* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	GtexFindBar* _tmp4_;
	GtkButton* _tmp5_;
	GtexFindBar* _tmp6_;
	GtkButton* _tmp7_;
	GtexFindBar* _tmp8_;
	GtkButton* _tmp9_;
	GtexFindBar* _tmp10_;
	GtkButton* _tmp11_;
	_tmp0_ = self->priv->_find_bar;
	_tmp1_ = gtex_find_bar_get_find_entry (_tmp0_);
	_tmp2_ = gtk_entry_get_text_length ((GtkEntry*) _tmp1_);
	_tmp3_ = _tmp2_;
	sensitive = _tmp3_ > ((guint) 0);
	_tmp4_ = self->priv->_find_bar;
	_tmp5_ = gtex_find_bar_get_previous_button (_tmp4_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, sensitive);
	_tmp6_ = self->priv->_find_bar;
	_tmp7_ = gtex_find_bar_get_next_button (_tmp6_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, sensitive);
	_tmp8_ = self->priv->_find_bar;
	_tmp9_ = gtex_find_bar_get_replace_button (_tmp8_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, sensitive);
	_tmp10_ = self->priv->_find_bar;
	_tmp11_ = gtex_find_bar_get_replace_all_button (_tmp10_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, sensitive);
}

static void
___lambda74__gtk_editable_changed (GtkEditable* _sender,
                                   gpointer self)
{
	__lambda74_ ((SearchAndReplace*) self);
}

static void
_search_and_replace_replace_gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	search_and_replace_replace ((SearchAndReplace*) self);
}

static void
_search_and_replace_replace_gtk_entry_activate (GtkEntry* _sender,
                                                gpointer self)
{
	search_and_replace_replace ((SearchAndReplace*) self);
}

static void
__lambda75_ (SearchAndReplace* self)
{
	GtkSourceSearchContext* _tmp0_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ != NULL) {
		MainWindow* _tmp1_;
		DocumentView* _tmp2_;
		DocumentView* _tmp3_;
		GtkSourceCompletion* _tmp4_;
		GtkSourceCompletion* _tmp5_;
		MainWindow* _tmp11_;
		DocumentView* _tmp12_;
		DocumentView* _tmp13_;
		GtkSourceCompletion* _tmp14_;
		GtkSourceCompletion* _tmp15_;
		_tmp1_ = self->priv->_main_window;
		_tmp2_ = main_window_get_active_view (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp3_);
		_tmp5_ = _tmp4_;
		gtk_source_completion_block_interactive (_tmp5_);
		{
			GtkSourceSearchContext* _tmp6_;
			GtexFindBar* _tmp7_;
			GtkSearchEntry* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp6_ = self->priv->_search_context;
			_tmp7_ = self->priv->_find_bar;
			_tmp8_ = gtex_find_bar_get_replace_entry (_tmp7_);
			_tmp9_ = gtk_entry_get_text ((GtkEntry*) _tmp8_);
			_tmp10_ = _tmp9_;
			gtk_source_search_context_replace_all (_tmp6_, _tmp10_, -1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp11_ = self->priv->_main_window;
		_tmp12_ = main_window_get_active_view (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp13_);
		_tmp15_ = _tmp14_;
		gtk_source_completion_unblock_interactive (_tmp15_);
	}
}

static void
___lambda75__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda75_ ((SearchAndReplace*) self);
}

static void
_search_and_replace_hide_gtk_search_entry_stop_search (GtkSearchEntry* _sender,
                                                       gpointer self)
{
	search_and_replace_hide ((SearchAndReplace*) self);
}

static gboolean
__lambda76_ (SearchAndReplace* self,
             GdkEventKey* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	switch (event->keyval) {
		case GDK_KEY_Tab:
		{
			GtexFindBar* _tmp0_;
			GtkSearchEntry* _tmp1_;
			search_and_replace_show_search_and_replace (self);
			_tmp0_ = self->priv->_find_bar;
			_tmp1_ = gtex_find_bar_get_replace_entry (_tmp0_);
			gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gboolean
___lambda76__gtk_widget_key_press_event (GtkWidget* _sender,
                                         GdkEventKey* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda76_ ((SearchAndReplace*) self, event);
	return result;
}

SearchAndReplace*
search_and_replace_construct (GType object_type,
                              MainWindow* main_window)
{
	SearchAndReplace * self = NULL;
	GtkSourceSearchSettings* _tmp0_;
	GtkSourceSearchSettings* _tmp1_;
	GtexFindBar* _tmp2_;
	GtexFindBar* _tmp3_;
	GtkSearchEntry* _tmp4_;
	GtkSourceSearchSettings* _tmp5_;
	GtexFindBar* _tmp6_;
	GtkCheckMenuItem* _tmp7_;
	GtkSourceSearchSettings* _tmp8_;
	GtexFindBar* _tmp9_;
	GtkCheckMenuItem* _tmp10_;
	GtkSourceSearchSettings* _tmp11_;
	GtexFindBar* _tmp12_;
	GtkButton* _tmp13_;
	GtexFindBar* _tmp14_;
	GtkButton* _tmp15_;
	GtexFindBar* _tmp16_;
	GtkButton* _tmp17_;
	GtexFindBar* _tmp18_;
	GtkButton* _tmp19_;
	GtexFindBar* _tmp20_;
	GtkButton* _tmp21_;
	GtexFindBar* _tmp22_;
	GtkButton* _tmp23_;
	GtkSearchEntry* find_entry = NULL;
	GtexFindBar* _tmp24_;
	GtkSearchEntry* _tmp25_;
	GtkSearchEntry* _tmp26_;
	GtexFindBar* _tmp27_;
	GtkButton* _tmp28_;
	GtexFindBar* _tmp29_;
	GtkButton* _tmp30_;
	GtexFindBar* _tmp31_;
	GtkSearchEntry* _tmp32_;
	GtexFindBar* _tmp33_;
	GtkButton* _tmp34_;
	GtexFindBar* _tmp35_;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (SearchAndReplace*) g_object_new (object_type, NULL);
	self->priv->_main_window = main_window;
	_tmp0_ = gtk_source_search_settings_new ();
	_g_object_unref0 (self->priv->_search_settings);
	self->priv->_search_settings = _tmp0_;
	_tmp1_ = self->priv->_search_settings;
	gtk_source_search_settings_set_wrap_around (_tmp1_, TRUE);
	_tmp2_ = gtex_find_bar_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->_find_bar);
	self->priv->_find_bar = _tmp2_;
	_tmp3_ = self->priv->_find_bar;
	_tmp4_ = gtex_find_bar_get_find_entry (_tmp3_);
	_tmp5_ = self->priv->_search_settings;
	g_object_bind_property_with_closures ((GObject*) _tmp4_, "text", (GObject*) _tmp5_, "search-text", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp6_ = self->priv->_find_bar;
	_tmp7_ = gtex_find_bar_get_check_menu_item (_tmp6_, "case-sensitive");
	_tmp8_ = self->priv->_search_settings;
	g_object_bind_property_with_closures ((GObject*) _tmp7_, "active", (GObject*) _tmp8_, "case-sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp9_ = self->priv->_find_bar;
	_tmp10_ = gtex_find_bar_get_check_menu_item (_tmp9_, "entire-words");
	_tmp11_ = self->priv->_search_settings;
	g_object_bind_property_with_closures ((GObject*) _tmp10_, "active", (GObject*) _tmp11_, "at-word-boundaries", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp12_ = self->priv->_find_bar;
	_tmp13_ = gtex_find_bar_get_previous_button (_tmp12_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, FALSE);
	_tmp14_ = self->priv->_find_bar;
	_tmp15_ = gtex_find_bar_get_next_button (_tmp14_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, FALSE);
	_tmp16_ = self->priv->_find_bar;
	_tmp17_ = gtex_find_bar_get_replace_button (_tmp16_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp17_, FALSE);
	_tmp18_ = self->priv->_find_bar;
	_tmp19_ = gtex_find_bar_get_replace_all_button (_tmp18_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, FALSE);
	_tmp20_ = self->priv->_find_bar;
	_tmp21_ = gtex_find_bar_get_close_button (_tmp20_);
	g_signal_connect_object (_tmp21_, "clicked", (GCallback) _search_and_replace_hide_gtk_button_clicked, self, 0);
	_tmp22_ = self->priv->_find_bar;
	_tmp23_ = gtex_find_bar_get_next_button (_tmp22_);
	g_signal_connect_object (_tmp23_, "clicked", (GCallback) _search_and_replace_search_forward_gtk_button_clicked, self, 0);
	_tmp24_ = self->priv->_find_bar;
	_tmp25_ = gtex_find_bar_get_find_entry (_tmp24_);
	_tmp26_ = _g_object_ref0 (_tmp25_);
	find_entry = _tmp26_;
	g_signal_connect_object ((GtkEntry*) find_entry, "activate", (GCallback) _search_and_replace_search_forward_gtk_entry_activate, self, 0);
	g_signal_connect_object (find_entry, "next-match", (GCallback) _search_and_replace_search_forward_gtk_search_entry_next_match, self, 0);
	_tmp27_ = self->priv->_find_bar;
	_tmp28_ = gtex_find_bar_get_previous_button (_tmp27_);
	g_signal_connect_object (_tmp28_, "clicked", (GCallback) _search_and_replace_search_backward_gtk_button_clicked, self, 0);
	g_signal_connect_object (find_entry, "previous-match", (GCallback) _search_and_replace_search_backward_gtk_search_entry_previous_match, self, 0);
	g_signal_connect_object ((GtkEditable*) find_entry, "changed", (GCallback) ___lambda74__gtk_editable_changed, self, 0);
	_tmp29_ = self->priv->_find_bar;
	_tmp30_ = gtex_find_bar_get_replace_button (_tmp29_);
	g_signal_connect_object (_tmp30_, "clicked", (GCallback) _search_and_replace_replace_gtk_button_clicked, self, 0);
	_tmp31_ = self->priv->_find_bar;
	_tmp32_ = gtex_find_bar_get_replace_entry (_tmp31_);
	g_signal_connect_object ((GtkEntry*) _tmp32_, "activate", (GCallback) _search_and_replace_replace_gtk_entry_activate, self, 0);
	_tmp33_ = self->priv->_find_bar;
	_tmp34_ = gtex_find_bar_get_replace_all_button (_tmp33_);
	g_signal_connect_object (_tmp34_, "clicked", (GCallback) ___lambda75__gtk_button_clicked, self, 0);
	g_signal_connect_object (find_entry, "stop-search", (GCallback) _search_and_replace_hide_gtk_search_entry_stop_search, self, 0);
	g_signal_connect_object ((GtkWidget*) find_entry, "key-press-event", (GCallback) ___lambda76__gtk_widget_key_press_event, self, 0);
	_tmp35_ = self->priv->_find_bar;
	gtk_widget_hide ((GtkWidget*) _tmp35_);
	_g_object_unref0 (find_entry);
	return self;
}

SearchAndReplace*
search_and_replace_new (MainWindow* main_window)
{
	return search_and_replace_construct (TYPE_SEARCH_AND_REPLACE, main_window);
}

GtkWidget*
search_and_replace_get_widget (SearchAndReplace* self)
{
	GtexFindBar* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_find_bar;
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _tmp0_);
	result = _tmp1_;
	return result;
}

void
search_and_replace_show_search (SearchAndReplace* self)
{
	GtexFindBar* _tmp0_;
	g_return_if_fail (self != NULL);
	search_and_replace_show (self);
	_tmp0_ = self->priv->_find_bar;
	gtex_find_bar_set_mode (_tmp0_, GTEX_FIND_BAR_MODE_FIND_ONLY);
}

void
search_and_replace_show_search_and_replace (SearchAndReplace* self)
{
	GtexFindBar* _tmp0_;
	g_return_if_fail (self != NULL);
	search_and_replace_show (self);
	_tmp0_ = self->priv->_find_bar;
	gtex_find_bar_set_mode (_tmp0_, GTEX_FIND_BAR_MODE_FIND_AND_REPLACE);
}

static void
_search_and_replace_connect_active_document_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self)
{
	search_and_replace_connect_active_document ((SearchAndReplace*) self);
}

static void
search_and_replace_show (SearchAndReplace* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	GtexFindBar* _tmp3_;
	GtexFindBar* _tmp4_;
	GtkSearchEntry* _tmp5_;
	Document* doc = NULL;
	MainWindow* _tmp6_;
	Document* _tmp7_;
	Document* _tmp8_;
	Document* _tmp9_;
	Document* _tmp10_;
	MainWindow* _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_find_bar;
	gtk_widget_show_all ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->_find_bar;
	_tmp5_ = gtex_find_bar_get_find_entry (_tmp4_);
	gtk_widget_grab_focus ((GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->_main_window;
	_tmp7_ = main_window_get_active_document (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	doc = _tmp9_;
	_tmp10_ = doc;
	if (tepl_buffer_get_selection_type ((TeplBuffer*) _tmp10_) == TEPL_SELECTION_TYPE_ON_SAME_LINE) {
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		Document* _tmp11_;
		GtkTextIter _tmp12_ = {0};
		GtkTextIter _tmp13_ = {0};
		GtexFindBar* _tmp14_;
		GtkSearchEntry* _tmp15_;
		Document* _tmp16_;
		GtkTextIter _tmp17_;
		GtkTextIter _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp11_ = doc;
		gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp11_, &_tmp12_, &_tmp13_);
		start = _tmp12_;
		end = _tmp13_;
		_tmp14_ = self->priv->_find_bar;
		_tmp15_ = gtex_find_bar_get_find_entry (_tmp14_);
		_tmp16_ = doc;
		_tmp17_ = start;
		_tmp18_ = end;
		_tmp19_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp16_, &_tmp17_, &_tmp18_, FALSE);
		_tmp20_ = _tmp19_;
		gtk_entry_set_text ((GtkEntry*) _tmp15_, _tmp20_);
		_g_free0 (_tmp20_);
	}
	_tmp21_ = self->priv->_main_window;
	g_signal_connect_object ((GObject*) _tmp21_, "notify::active-document", (GCallback) _search_and_replace_connect_active_document_g_object_notify, self, 0);
	search_and_replace_connect_active_document (self);
	_g_object_unref0 (doc);
}

void
search_and_replace_hide (SearchAndReplace* self)
{
	MainWindow* _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	GtexFindBar* _tmp3_;
	MainWindow* _tmp4_;
	DocumentView* _tmp5_;
	DocumentView* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	g_signal_parse_name ("notify::active-document", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _search_and_replace_connect_active_document_g_object_notify, self);
	search_and_replace_destroy_search_context (self);
	_tmp3_ = self->priv->_find_bar;
	gtk_widget_hide ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->_main_window;
	_tmp5_ = main_window_get_active_view (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		MainWindow* _tmp7_;
		DocumentView* _tmp8_;
		DocumentView* _tmp9_;
		_tmp7_ = self->priv->_main_window;
		_tmp8_ = main_window_get_active_view (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_widget_grab_focus ((GtkWidget*) _tmp9_);
	}
}

static void
_search_and_replace_mark_set_cb_gtk_text_buffer_mark_set (GtkTextBuffer* _sender,
                                                          GtkTextIter* location,
                                                          GtkTextMark* mark,
                                                          gpointer self)
{
	search_and_replace_mark_set_cb ((SearchAndReplace*) self, _sender, location, mark);
}

static void
search_and_replace_destroy_search_context (SearchAndReplace* self)
{
	GtkSourceSearchContext* _tmp0_;
	GtkSourceBuffer* buffer = NULL;
	GtkSourceSearchContext* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	GtkSourceBuffer* _tmp3_;
	GtkSourceBuffer* _tmp4_;
	guint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_search_context;
	_tmp2_ = gtk_source_search_context_get_buffer (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	buffer = _tmp3_;
	_tmp4_ = buffer;
	g_signal_parse_name ("mark-set", gtk_text_buffer_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkTextBuffer*) _tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _search_and_replace_mark_set_cb_gtk_text_buffer_mark_set, self);
	_g_object_unref0 (self->priv->_search_context);
	self->priv->_search_context = NULL;
	_g_object_unref0 (buffer);
}

static void
__lambda73_ (SearchAndReplace* self)
{
	GtkStyleContext* style_context = NULL;
	GtexFindBar* _tmp0_;
	GtkSearchEntry* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GtkSourceSearchContext* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	_tmp0_ = self->priv->_find_bar;
	_tmp1_ = gtex_find_bar_get_find_entry (_tmp0_);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	style_context = _tmp3_;
	_tmp5_ = self->priv->_search_context;
	_tmp6_ = gtk_source_search_context_get_occurrences_count (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == 0) {
		GtkSourceSearchSettings* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = self->priv->_search_settings;
		_tmp9_ = gtk_source_search_settings_get_search_text (_tmp8_);
		_tmp4_ = _tmp9_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GtkStyleContext* _tmp10_;
		_tmp10_ = style_context;
		gtk_style_context_add_class (_tmp10_, GTK_STYLE_CLASS_ERROR);
	} else {
		GtkSourceSearchContext* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp11_ = self->priv->_search_context;
		_tmp12_ = gtk_source_search_context_get_occurrences_count (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_ >= 0) {
			GtkStyleContext* _tmp14_;
			_tmp14_ = style_context;
			gtk_style_context_remove_class (_tmp14_, GTK_STYLE_CLASS_ERROR);
		}
	}
	search_and_replace_update_info_label (self);
	_g_object_unref0 (style_context);
}

static void
___lambda73__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda73_ ((SearchAndReplace*) self);
}

static void
search_and_replace_connect_active_document (SearchAndReplace* self)
{
	Document* doc = NULL;
	MainWindow* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	Document* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	GtkSourceSearchSettings* _tmp6_;
	GtkSourceSearchContext* _tmp7_;
	GtkSourceSearchContext* _tmp8_;
	gboolean readonly = FALSE;
	MainWindow* _tmp9_;
	Document* _tmp10_;
	Document* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GtexFindBar* _tmp14_;
	GtkGrid* _tmp15_;
	Document* _tmp16_;
	g_return_if_fail (self != NULL);
	search_and_replace_destroy_search_context (self);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_document (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	doc = _tmp3_;
	_tmp4_ = doc;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (doc);
		return;
	}
	_tmp5_ = doc;
	_tmp6_ = self->priv->_search_settings;
	_tmp7_ = gtk_source_search_context_new ((GtkSourceBuffer*) _tmp5_, _tmp6_);
	_g_object_unref0 (self->priv->_search_context);
	self->priv->_search_context = _tmp7_;
	_tmp8_ = self->priv->_search_context;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::occurrences-count", (GCallback) ___lambda73__g_object_notify, self, 0);
	_tmp9_ = self->priv->_main_window;
	_tmp10_ = main_window_get_active_document (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = document_get_readonly (_tmp11_);
	_tmp13_ = _tmp12_;
	readonly = _tmp13_;
	_tmp14_ = self->priv->_find_bar;
	_tmp15_ = gtex_find_bar_get_replace_grid (_tmp14_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, !readonly);
	_tmp16_ = doc;
	g_signal_connect_object ((GtkTextBuffer*) _tmp16_, "mark-set", (GCallback) _search_and_replace_mark_set_cb_gtk_text_buffer_mark_set, self, 0);
	_g_object_unref0 (doc);
}

static void
search_and_replace_mark_set_cb (SearchAndReplace* self,
                                GtkTextBuffer* buffer,
                                GtkTextIter* location,
                                GtkTextMark* mark)
{
	gboolean _tmp0_ = FALSE;
	GtkTextMark* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buffer != NULL);
	g_return_if_fail (location != NULL);
	g_return_if_fail (mark != NULL);
	_tmp1_ = gtk_text_buffer_get_insert (buffer);
	if (mark == _tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GtkTextMark* _tmp2_;
		_tmp2_ = gtk_text_buffer_get_selection_bound (buffer);
		_tmp0_ = mark == _tmp2_;
	}
	if (_tmp0_) {
		search_and_replace_update_info_label (self);
	}
}

static void
search_and_replace_update_info_label (SearchAndReplace* self)
{
	gboolean _tmp0_ = FALSE;
	GtkSourceSearchContext* _tmp1_;
	gint count = 0;
	GtkSourceSearchContext* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GtkTextBuffer* buffer = NULL;
	GtkSourceSearchContext* _tmp11_;
	GtkSourceBuffer* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp14_;
	GtkTextIter _tmp15_ = {0};
	GtkTextIter _tmp16_ = {0};
	gint pos = 0;
	GtkSourceSearchContext* _tmp17_;
	GtkTextIter _tmp18_;
	GtkTextIter _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_search_context;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GtkSourceSearchSettings* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->priv->_search_settings;
		_tmp3_ = gtk_source_search_settings_get_search_text (_tmp2_);
		_tmp0_ = _tmp3_ == NULL;
	}
	if (_tmp0_) {
		GtexFindBar* _tmp4_;
		GtkLabel* _tmp5_;
		_tmp4_ = self->priv->_find_bar;
		_tmp5_ = gtex_find_bar_get_info_label (_tmp4_);
		gtk_label_set_text (_tmp5_, "");
		return;
	}
	_tmp6_ = self->priv->_search_context;
	_tmp7_ = gtk_source_search_context_get_occurrences_count (_tmp6_);
	_tmp8_ = _tmp7_;
	count = _tmp8_;
	if (count == -1) {
		return;
	}
	if (count == 0) {
		GtexFindBar* _tmp9_;
		GtkLabel* _tmp10_;
		_tmp9_ = self->priv->_find_bar;
		_tmp10_ = gtex_find_bar_get_info_label (_tmp9_);
		gtk_label_set_text (_tmp10_, _ ("Not found"));
		return;
	}
	_tmp11_ = self->priv->_search_context;
	_tmp12_ = gtk_source_search_context_get_buffer (_tmp11_);
	_tmp13_ = _g_object_ref0 ((GtkTextBuffer*) _tmp12_);
	buffer = _tmp13_;
	_tmp14_ = buffer;
	gtk_text_buffer_get_selection_bounds (_tmp14_, &_tmp15_, &_tmp16_);
	start = _tmp15_;
	end = _tmp16_;
	_tmp17_ = self->priv->_search_context;
	_tmp18_ = start;
	_tmp19_ = end;
	pos = gtk_source_search_context_get_occurrence_position (_tmp17_, &_tmp18_, &_tmp19_);
	if (pos > 0) {
		GtexFindBar* _tmp20_;
		GtkLabel* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp20_ = self->priv->_find_bar;
		_tmp21_ = gtex_find_bar_get_info_label (_tmp20_);
		_tmp22_ = g_strdup_printf (_ ("Match %d of %d"), pos, count);
		_tmp23_ = _tmp22_;
		gtk_label_set_text (_tmp21_, _tmp23_);
		_g_free0 (_tmp23_);
	} else {
		gchar* text = NULL;
		gchar* _tmp24_;
		GtexFindBar* _tmp25_;
		GtkLabel* _tmp26_;
		const gchar* _tmp27_;
		_tmp24_ = g_strdup_printf (ngettext ("%d match", "%d matches", (gulong) count), count);
		text = _tmp24_;
		_tmp25_ = self->priv->_find_bar;
		_tmp26_ = gtex_find_bar_get_info_label (_tmp25_);
		_tmp27_ = text;
		gtk_label_set_text (_tmp26_, _tmp27_);
		_g_free0 (text);
	}
	_g_object_unref0 (buffer);
}

static void
search_and_replace_search_forward (SearchAndReplace* self)
{
	GtkSourceSearchContext* _tmp0_;
	GtkTextIter iter = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	Document* doc = NULL;
	GtkSourceSearchContext* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	Document* _tmp3_;
	Document* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkSourceSearchContext* _tmp6_;
	GtkTextIter _tmp7_;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_search_context;
	_tmp2_ = gtk_source_search_context_get_buffer (_tmp1_);
	_tmp3_ = _g_object_ref0 (IS_DOCUMENT (_tmp2_) ? ((Document*) _tmp2_) : NULL);
	doc = _tmp3_;
	_tmp4_ = doc;
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp4_, NULL, &_tmp5_);
	iter = _tmp5_;
	_tmp6_ = self->priv->_search_context;
	_tmp7_ = iter;
	_tmp10_ = gtk_source_search_context_forward (_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, NULL);
	match_start = _tmp8_;
	match_end = _tmp9_;
	if (_tmp10_) {
		Document* _tmp11_;
		GtkTextIter _tmp12_;
		GtkTextIter _tmp13_;
		Document* _tmp14_;
		DocumentTab* _tmp15_;
		TeplView* _tmp16_;
		TeplView* _tmp17_;
		_tmp11_ = doc;
		_tmp12_ = match_start;
		_tmp13_ = match_end;
		gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp11_, &_tmp12_, &_tmp13_);
		_tmp14_ = doc;
		_tmp15_ = _tmp14_->tab;
		_tmp16_ = tepl_tab_get_view ((TeplTab*) _tmp15_);
		_tmp17_ = _tmp16_;
		tepl_view_scroll_to_cursor (_tmp17_);
	}
	_g_object_unref0 (doc);
}

static void
search_and_replace_search_backward (SearchAndReplace* self)
{
	GtkSourceSearchContext* _tmp0_;
	GtkTextIter iter = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	Document* doc = NULL;
	GtkSourceSearchContext* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	Document* _tmp3_;
	Document* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkSourceSearchContext* _tmp6_;
	GtkTextIter _tmp7_;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_search_context;
	_tmp2_ = gtk_source_search_context_get_buffer (_tmp1_);
	_tmp3_ = _g_object_ref0 (IS_DOCUMENT (_tmp2_) ? ((Document*) _tmp2_) : NULL);
	doc = _tmp3_;
	_tmp4_ = doc;
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp4_, &_tmp5_, NULL);
	iter = _tmp5_;
	_tmp6_ = self->priv->_search_context;
	_tmp7_ = iter;
	_tmp10_ = gtk_source_search_context_backward (_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, NULL);
	match_start = _tmp8_;
	match_end = _tmp9_;
	if (_tmp10_) {
		Document* _tmp11_;
		GtkTextIter _tmp12_;
		GtkTextIter _tmp13_;
		Document* _tmp14_;
		DocumentTab* _tmp15_;
		TeplView* _tmp16_;
		TeplView* _tmp17_;
		_tmp11_ = doc;
		_tmp12_ = match_start;
		_tmp13_ = match_end;
		gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp11_, &_tmp12_, &_tmp13_);
		_tmp14_ = doc;
		_tmp15_ = _tmp14_->tab;
		_tmp16_ = tepl_tab_get_view ((TeplTab*) _tmp15_);
		_tmp17_ = _tmp16_;
		tepl_view_scroll_to_cursor (_tmp17_);
	}
	_g_object_unref0 (doc);
}

static void
search_and_replace_replace (SearchAndReplace* self)
{
	GtkSourceSearchContext* _tmp0_;
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	GtkSourceBuffer* buffer = NULL;
	GtkSourceSearchContext* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	GtkSourceBuffer* _tmp3_;
	GtkSourceBuffer* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	MainWindow* _tmp7_;
	DocumentView* _tmp8_;
	DocumentView* _tmp9_;
	GtkSourceCompletion* _tmp10_;
	GtkSourceCompletion* _tmp11_;
	MainWindow* _tmp20_;
	DocumentView* _tmp21_;
	DocumentView* _tmp22_;
	GtkSourceCompletion* _tmp23_;
	GtkSourceCompletion* _tmp24_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_search_context;
	_tmp2_ = gtk_source_search_context_get_buffer (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	buffer = _tmp3_;
	_tmp4_ = buffer;
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp4_, &_tmp5_, &_tmp6_);
	match_start = _tmp5_;
	match_end = _tmp6_;
	_tmp7_ = self->priv->_main_window;
	_tmp8_ = main_window_get_active_view (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp9_);
	_tmp11_ = _tmp10_;
	gtk_source_completion_block_interactive (_tmp11_);
	{
		gboolean _tmp12_ = FALSE;
		GtkSourceSearchContext* _tmp13_;
		GtkTextIter _tmp14_;
		GtkTextIter _tmp15_;
		GtexFindBar* _tmp16_;
		GtkSearchEntry* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp13_ = self->priv->_search_context;
		_tmp14_ = match_start;
		_tmp15_ = match_end;
		_tmp16_ = self->priv->_find_bar;
		_tmp17_ = gtex_find_bar_get_replace_entry (_tmp16_);
		_tmp18_ = gtk_entry_get_text ((GtkEntry*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp12_ = gtk_source_search_context_replace (_tmp13_, &_tmp14_, &_tmp15_, _tmp19_, -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (!_tmp12_) {
			search_and_replace_search_forward (self);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (buffer);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp20_ = self->priv->_main_window;
	_tmp21_ = main_window_get_active_view (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp22_);
	_tmp24_ = _tmp23_;
	gtk_source_completion_unblock_interactive (_tmp24_);
	_g_object_unref0 (buffer);
}

static void
search_and_replace_class_init (SearchAndReplaceClass * klass,
                               gpointer klass_data)
{
	search_and_replace_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SearchAndReplace_private_offset);
	G_OBJECT_CLASS (klass)->finalize = search_and_replace_finalize;
}

static void
search_and_replace_instance_init (SearchAndReplace * self,
                                  gpointer klass)
{
	self->priv = search_and_replace_get_instance_private (self);
	self->priv->_search_context = NULL;
}

static void
search_and_replace_finalize (GObject * obj)
{
	SearchAndReplace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_AND_REPLACE, SearchAndReplace);
	_g_object_unref0 (self->priv->_find_bar);
	_g_object_unref0 (self->priv->_search_settings);
	_g_object_unref0 (self->priv->_search_context);
	G_OBJECT_CLASS (search_and_replace_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
search_and_replace_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchAndReplaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_and_replace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchAndReplace), 0, (GInstanceInitFunc) search_and_replace_instance_init, NULL };
	GType search_and_replace_type_id;
	search_and_replace_type_id = g_type_register_static (G_TYPE_OBJECT, "SearchAndReplace", &g_define_type_info, 0);
	SearchAndReplace_private_offset = g_type_add_instance_private (search_and_replace_type_id, sizeof (SearchAndReplacePrivate));
	return search_and_replace_type_id;
}

GType
search_and_replace_get_type (void)
{
	static gsize search_and_replace_type_id__once = 0;
	if (g_once_init_enter (&search_and_replace_type_id__once)) {
		GType search_and_replace_type_id;
		search_and_replace_type_id = search_and_replace_get_type_once ();
		g_once_init_leave (&search_and_replace_type_id__once, search_and_replace_type_id);
	}
	return search_and_replace_type_id__once;
}

