/* contacts-contact-pane.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from contacts-contact-pane.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 * Copyright (C) 2021 Niels De Graef <nielsdegraef@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <glib.h>
#include <adwaita.h>
#include <glib-object.h>
#include "contacts.h"
#include "contactscore.h"
#include <gtk/gtk.h>
#include <folks/folks.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#define PROFILE_SIZE 128
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_CONTACT_PANE (contacts_contact_pane_get_type ())
#define CONTACTS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane))
#define CONTACTS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))
#define CONTACTS_IS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_IS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_CONTACT_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))

typedef struct _ContactsContactPane ContactsContactPane;
typedef struct _ContactsContactPaneClass ContactsContactPaneClass;
typedef struct _ContactsContactPanePrivate ContactsContactPanePrivate;

#define CONTACTS_TYPE_CONTACT_SELECTION_MODEL (contacts_contact_selection_model_get_type ())
#define CONTACTS_CONTACT_SELECTION_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_SELECTION_MODEL, ContactsContactSelectionModel))
#define CONTACTS_CONTACT_SELECTION_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_SELECTION_MODEL, ContactsContactSelectionModelClass))
#define CONTACTS_IS_CONTACT_SELECTION_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_SELECTION_MODEL))
#define CONTACTS_IS_CONTACT_SELECTION_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_SELECTION_MODEL))
#define CONTACTS_CONTACT_SELECTION_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_SELECTION_MODEL, ContactsContactSelectionModelClass))

typedef struct _ContactsContactSelectionModel ContactsContactSelectionModel;
typedef struct _ContactsContactSelectionModelClass ContactsContactSelectionModelClass;

#define CONTACTS_TYPE_CONTACT_SHEET (contacts_contact_sheet_get_type ())
#define CONTACTS_CONTACT_SHEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheet))
#define CONTACTS_CONTACT_SHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheetClass))
#define CONTACTS_IS_CONTACT_SHEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_SHEET))
#define CONTACTS_IS_CONTACT_SHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_SHEET))
#define CONTACTS_CONTACT_SHEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheetClass))

typedef struct _ContactsContactSheet ContactsContactSheet;
typedef struct _ContactsContactSheetClass ContactsContactSheetClass;

#define CONTACTS_TYPE_CONTACT_EDITOR (contacts_contact_editor_get_type ())
#define CONTACTS_CONTACT_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditor))
#define CONTACTS_CONTACT_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditorClass))
#define CONTACTS_IS_CONTACT_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_EDITOR))
#define CONTACTS_IS_CONTACT_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_EDITOR))
#define CONTACTS_CONTACT_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditorClass))

typedef struct _ContactsContactEditor ContactsContactEditor;
typedef struct _ContactsContactEditorClass ContactsContactEditorClass;

#define CONTACTS_TYPE_LINK_SUGGESTION_GRID (contacts_link_suggestion_grid_get_type ())
#define CONTACTS_LINK_SUGGESTION_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_LINK_SUGGESTION_GRID, ContactsLinkSuggestionGrid))
#define CONTACTS_LINK_SUGGESTION_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_LINK_SUGGESTION_GRID, ContactsLinkSuggestionGridClass))
#define CONTACTS_IS_LINK_SUGGESTION_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_LINK_SUGGESTION_GRID))
#define CONTACTS_IS_LINK_SUGGESTION_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_LINK_SUGGESTION_GRID))
#define CONTACTS_LINK_SUGGESTION_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_LINK_SUGGESTION_GRID, ContactsLinkSuggestionGridClass))

typedef struct _ContactsLinkSuggestionGrid ContactsLinkSuggestionGrid;
typedef struct _ContactsLinkSuggestionGridClass ContactsLinkSuggestionGridClass;
enum  {
	CONTACTS_CONTACT_PANE_0_PROPERTY,
	CONTACTS_CONTACT_PANE_STORE_PROPERTY,
	CONTACTS_CONTACT_PANE_SELECTION_MODEL_PROPERTY,
	CONTACTS_CONTACT_PANE_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_pane_properties[CONTACTS_CONTACT_PANE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block15Data Block15Data;
typedef struct _Block16Data Block16Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ContactsContactPaneApplyChangesData ContactsContactPaneApplyChangesData;
enum  {
	CONTACTS_CONTACT_PANE_CONTACTS_LINKED_SIGNAL,
	CONTACTS_CONTACT_PANE_NUM_SIGNALS
};
static guint contacts_contact_pane_signals[CONTACTS_CONTACT_PANE_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ContactsContactPane {
	AdwBin parent_instance;
	ContactsContactPanePrivate * priv;
	gboolean on_edit_mode;
};

struct _ContactsContactPaneClass {
	AdwBinClass parent_class;
};

struct _ContactsContactPanePrivate {
	ContactsStore* _store;
	ContactsContactSelectionModel* _selection_model;
	ContactsContact* contact;
	GtkStack* stack;
	AdwClamp* contact_sheet_clamp;
	ContactsContactSheet* sheet;
	GtkBox* contact_editor_box;
	ContactsContactEditor* editor;
	ContactsLinkSuggestionGrid* suggestion_grid;
};

struct _Block15Data {
	int _ref_count_;
	ContactsContactPane* self;
	FolksIndividual* individual;
	FolksIndividual* other;
};

struct _Block16Data {
	int _ref_count_;
	ContactsContactPane* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _ContactsContactPaneApplyChangesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsContactPane* self;
	ContactsContact* contact;
	ContactsStore* _tmp0_;
	FolksIndividualAggregator* _tmp1_;
	FolksIndividualAggregator* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	Block16Data* _data16_;
	gulong signal_id;
	ContactsStore* _tmp5_;
	gulong _tmp6_;
	FolksIndividual* individual;
	ContactsStore* _tmp7_;
	FolksIndividualAggregator* _tmp8_;
	FolksIndividualAggregator* _tmp9_;
	FolksPersonaStore* _tmp10_;
	FolksPersonaStore* _tmp11_;
	FolksIndividual* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	guint pos;
	ContactsStore* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	ContactsContactSelectionModel* _tmp19_;
	GtkSingleSelection* _tmp20_;
	GtkSingleSelection* _tmp21_;
	GError* err;
	GError* _tmp22_;
	const gchar* _tmp23_;
	GError* _inner_error0_;
};

static gint ContactsContactPane_private_offset;
static gpointer contacts_contact_pane_parent_class = NULL;

VALA_EXTERN GType contacts_contact_pane_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactPane, g_object_unref)
VALA_EXTERN GType contacts_contact_selection_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactSelectionModel, g_object_unref)
VALA_EXTERN GType contacts_contact_sheet_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactSheet, g_object_unref)
VALA_EXTERN GType contacts_contact_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactEditor, g_object_unref)
VALA_EXTERN GType contacts_link_suggestion_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsLinkSuggestionGrid, g_object_unref)
VALA_EXTERN ContactsContactPane* contacts_contact_pane_new (ContactsContactSelectionModel* selection_model,
                                                ContactsStore* contacts_store);
VALA_EXTERN ContactsContactPane* contacts_contact_pane_construct (GType object_type,
                                                      ContactsContactSelectionModel* selection_model,
                                                      ContactsStore* contacts_store);
VALA_EXTERN void contacts_contact_pane_add_suggestion (ContactsContactPane* self,
                                           FolksIndividual* individual,
                                           FolksIndividual* other);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static void contacts_contact_pane_remove_suggestion_grid (ContactsContactPane* self);
VALA_EXTERN ContactsLinkSuggestionGrid* contacts_link_suggestion_grid_new (FolksIndividual* individual);
VALA_EXTERN ContactsLinkSuggestionGrid* contacts_link_suggestion_grid_construct (GType object_type,
                                                                     FolksIndividual* individual);
static void __lambda35_ (Block15Data* _data15_);
VALA_EXTERN ContactsStore* contacts_contact_pane_get_store (ContactsContactPane* self);
static void ___lambda35__contacts_link_suggestion_grid_suggestion_accepted (ContactsLinkSuggestionGrid* _sender,
                                                                     gpointer self);
static void __lambda36_ (Block15Data* _data15_);
static void ___lambda36__contacts_link_suggestion_grid_suggestion_rejected (ContactsLinkSuggestionGrid* _sender,
                                                                     gpointer self);
VALA_EXTERN void contacts_contact_pane_show_contact (ContactsContactPane* self,
                                         FolksIndividual* individual);
static void contacts_contact_pane_remove_contact_sheet (ContactsContactPane* self);
static void contacts_contact_pane_show_contact_sheet (ContactsContactPane* self,
                                               ContactsContact* contact);
VALA_EXTERN ContactsContactSheet* contacts_contact_sheet_new (ContactsContact* contact);
VALA_EXTERN ContactsContactSheet* contacts_contact_sheet_construct (GType object_type,
                                                        ContactsContact* contact);
static void contacts_contact_pane_create_contact_editor (ContactsContactPane* self);
static void contacts_contact_pane_remove_contact_editor (ContactsContactPane* self);
VALA_EXTERN ContactsContactEditor* contacts_contact_editor_new (ContactsContact* contact);
VALA_EXTERN ContactsContactEditor* contacts_contact_editor_construct (GType object_type,
                                                          ContactsContact* contact);
VALA_EXTERN void contacts_contact_pane_stop_editing (ContactsContactPane* self,
                                         gboolean cancel);
static void contacts_contact_pane_apply_changes (ContactsContactPane* self,
                                          ContactsContact* contact,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void contacts_contact_pane_apply_changes_finish (ContactsContactPane* self,
                                                 GAsyncResult* _res_);
static void contacts_contact_pane_apply_changes_data_free (gpointer _data);
static gboolean contacts_contact_pane_apply_changes_co (ContactsContactPaneApplyChangesData* _data_);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static gboolean _contacts_contact_pane_apply_changes_co_gsource_func (gpointer self);
static void ___lambda37_ (Block16Data* _data16_);
static void ____lambda37__contacts_store_quiescent (ContactsStore* _sender,
                                             gpointer self);
static void contacts_contact_pane_apply_changes_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
VALA_EXTERN ContactsContactSelectionModel* contacts_contact_pane_get_selection_model (ContactsContactPane* self);
VALA_EXTERN GtkSingleSelection* contacts_contact_selection_model_get_selected (ContactsContactSelectionModel* self);
VALA_EXTERN void contacts_contact_pane_edit_contact (ContactsContactPane* self);
VALA_EXTERN void contacts_contact_pane_new_contact (ContactsContactPane* self);
VALA_EXTERN void contacts_contact_pane_set_store (ContactsContactPane* self,
                                      ContactsStore* value);
VALA_EXTERN void contacts_contact_pane_set_selection_model (ContactsContactPane* self,
                                                ContactsContactSelectionModel* value);
static void contacts_contact_pane_finalize (GObject * obj);
static GType contacts_contact_pane_get_type_once (void);
static void _vala_contacts_contact_pane_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_contacts_contact_pane_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
contacts_contact_pane_get_instance_private (ContactsContactPane* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsContactPane_private_offset);
}

ContactsContactPane*
contacts_contact_pane_construct (GType object_type,
                                 ContactsContactSelectionModel* selection_model,
                                 ContactsStore* contacts_store)
{
	ContactsContactPane * self = NULL;
	g_return_val_if_fail (selection_model != NULL, NULL);
	g_return_val_if_fail (contacts_store != NULL, NULL);
	self = (ContactsContactPane*) g_object_new (object_type, "selection-model", selection_model, "store", contacts_store, NULL);
	return self;
}

ContactsContactPane*
contacts_contact_pane_new (ContactsContactSelectionModel* selection_model,
                           ContactsStore* contacts_store)
{
	return contacts_contact_pane_construct (CONTACTS_TYPE_CONTACT_PANE, selection_model, contacts_store);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		ContactsContactPane* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->individual);
		_g_object_unref0 (_data15_->other);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static void
__lambda35_ (Block15Data* _data15_)
{
	ContactsContactPane* self;
	GeeLinkedList* to_link = NULL;
	GeeLinkedList* _tmp0_;
	ContactsLinkOperation* operation = NULL;
	ContactsStore* _tmp1_;
	ContactsLinkOperation* _tmp2_;
	self = _data15_->self;
	_tmp0_ = gee_linked_list_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	to_link = _tmp0_;
	gee_abstract_collection_add ((GeeAbstractCollection*) to_link, _data15_->individual);
	gee_abstract_collection_add ((GeeAbstractCollection*) to_link, _data15_->other);
	_tmp1_ = self->priv->_store;
	_tmp2_ = contacts_link_operation_new (_tmp1_, to_link);
	operation = _tmp2_;
	g_signal_emit (self, contacts_contact_pane_signals[CONTACTS_CONTACT_PANE_CONTACTS_LINKED_SIGNAL], 0, operation);
	contacts_contact_pane_remove_suggestion_grid (self);
	_g_object_unref0 (operation);
	_g_object_unref0 (to_link);
}

static void
___lambda35__contacts_link_suggestion_grid_suggestion_accepted (ContactsLinkSuggestionGrid* _sender,
                                                                gpointer self)
{
	__lambda35_ (self);
}

static void
__lambda36_ (Block15Data* _data15_)
{
	ContactsContactPane* self;
	ContactsStore* _tmp0_;
	self = _data15_->self;
	_tmp0_ = self->priv->_store;
	contacts_store_add_no_suggest_link (_tmp0_, _data15_->individual, _data15_->other);
	contacts_contact_pane_remove_suggestion_grid (self);
}

static void
___lambda36__contacts_link_suggestion_grid_suggestion_rejected (ContactsLinkSuggestionGrid* _sender,
                                                                gpointer self)
{
	__lambda36_ (self);
}

void
contacts_contact_pane_add_suggestion (ContactsContactPane* self,
                                      FolksIndividual* individual,
                                      FolksIndividual* other)
{
	Block15Data* _data15_;
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp1_;
	AdwToolbarView* parent_toolbar = NULL;
	GtkWidget* _tmp2_;
	ContactsLinkSuggestionGrid* _tmp3_;
	ContactsLinkSuggestionGrid* _tmp4_;
	ContactsLinkSuggestionGrid* _tmp5_;
	ContactsLinkSuggestionGrid* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual != NULL);
	g_return_if_fail (other != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (individual);
	_g_object_unref0 (_data15_->individual);
	_data15_->individual = _tmp0_;
	_tmp1_ = _g_object_ref0 (other);
	_g_object_unref0 (_data15_->other);
	_data15_->other = _tmp1_;
	_tmp2_ = gtk_widget_get_parent ((GtkWidget*) self);
	parent_toolbar = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, adw_toolbar_view_get_type ()) ? ((AdwToolbarView*) _tmp2_) : NULL;
	contacts_contact_pane_remove_suggestion_grid (self);
	_tmp3_ = contacts_link_suggestion_grid_new (_data15_->other);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->suggestion_grid);
	self->priv->suggestion_grid = _tmp3_;
	_tmp4_ = self->priv->suggestion_grid;
	adw_toolbar_view_add_bottom_bar (parent_toolbar, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->suggestion_grid;
	g_signal_connect_data (_tmp5_, "suggestion-accepted", (GCallback) ___lambda35__contacts_link_suggestion_grid_suggestion_accepted, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	_tmp6_ = self->priv->suggestion_grid;
	g_signal_connect_data (_tmp6_, "suggestion-rejected", (GCallback) ___lambda36__contacts_link_suggestion_grid_suggestion_rejected, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	block15_data_unref (_data15_);
	_data15_ = NULL;
}

void
contacts_contact_pane_show_contact (ContactsContactPane* self,
                                    FolksIndividual* individual)
{
	gboolean _tmp1_ = FALSE;
	ContactsContact* _tmp2_;
	ContactsContact* _tmp7_;
	g_return_if_fail (self != NULL);
	if (individual == NULL) {
		GtkStack* _tmp0_;
		_g_object_unref0 (self->priv->contact);
		self->priv->contact = NULL;
		contacts_contact_pane_remove_contact_sheet (self);
		_tmp0_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp0_, "none-selected-page");
		return;
	}
	_tmp2_ = self->priv->contact;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ContactsContact* _tmp3_;
		FolksIndividual* _tmp4_;
		FolksIndividual* _tmp5_;
		_tmp3_ = self->priv->contact;
		_tmp4_ = contacts_contact_get_individual (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ != individual;
	}
	if (_tmp1_) {
		ContactsContact* _tmp6_;
		_tmp6_ = contacts_contact_new_for_individual (individual);
		_g_object_unref0 (self->priv->contact);
		self->priv->contact = _tmp6_;
	}
	_tmp7_ = self->priv->contact;
	contacts_contact_pane_show_contact_sheet (self, _tmp7_);
}

static void
contacts_contact_pane_show_contact_sheet (ContactsContactPane* self,
                                          ContactsContact* contact)
{
	ContactsContact* _tmp0_;
	ContactsContactSheet* contacts_sheet = NULL;
	ContactsContactSheet* _tmp1_;
	ContactsContactSheet* _tmp2_;
	ContactsContactSheet* _tmp3_;
	AdwClamp* _tmp4_;
	ContactsContactSheet* _tmp5_;
	GtkStack* _tmp6_;
	FolksIndividual* _tmp7_;
	FolksIndividual* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	_tmp0_ = self->priv->contact;
	_vala_return_if_fail (_tmp0_ != NULL, "this.contact != null");
	contacts_contact_pane_remove_contact_sheet (self);
	_tmp1_ = contacts_contact_sheet_new (contact);
	g_object_ref_sink (_tmp1_);
	contacts_sheet = _tmp1_;
	_tmp2_ = contacts_sheet;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = contacts_sheet;
	self->priv->sheet = _tmp3_;
	_tmp4_ = self->priv->contact_sheet_clamp;
	_tmp5_ = self->priv->sheet;
	adw_clamp_set_child (_tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp6_, "contact-sheet-page");
	_tmp7_ = contacts_contact_get_individual (contact);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		GeeMap* matches = NULL;
		ContactsStore* _tmp9_;
		FolksIndividualAggregator* _tmp10_;
		FolksIndividualAggregator* _tmp11_;
		FolksIndividual* _tmp12_;
		FolksIndividual* _tmp13_;
		GeeMap* _tmp14_;
		_tmp9_ = self->priv->_store;
		_tmp10_ = contacts_store_get_aggregator (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = contacts_contact_get_individual (contact);
		_tmp13_ = _tmp12_;
		_tmp14_ = folks_individual_aggregator_get_potential_matches (_tmp11_, _tmp13_, FOLKS_MATCH_RESULT_HIGH);
		matches = _tmp14_;
		{
			GeeIterator* _i_it = NULL;
			GeeMap* _tmp15_;
			GeeSet* _tmp16_;
			GeeSet* _tmp17_;
			GeeSet* _tmp18_;
			GeeIterator* _tmp19_;
			GeeIterator* _tmp20_;
			_tmp15_ = matches;
			_tmp16_ = gee_map_get_keys (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = _tmp17_;
			_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
			_tmp20_ = _tmp19_;
			_g_object_unref0 (_tmp18_);
			_i_it = _tmp20_;
			while (TRUE) {
				GeeIterator* _tmp21_;
				FolksIndividual* i = NULL;
				GeeIterator* _tmp22_;
				gpointer _tmp23_;
				gboolean _tmp24_ = FALSE;
				FolksIndividual* _tmp25_;
				_tmp21_ = _i_it;
				if (!gee_iterator_next (_tmp21_)) {
					break;
				}
				_tmp22_ = _i_it;
				_tmp23_ = gee_iterator_get (_tmp22_);
				i = (FolksIndividual*) _tmp23_;
				_tmp25_ = i;
				if (_tmp25_ != NULL) {
					ContactsStore* _tmp26_;
					FolksIndividual* _tmp27_;
					FolksIndividual* _tmp28_;
					FolksIndividual* _tmp29_;
					_tmp26_ = self->priv->_store;
					_tmp27_ = contacts_contact_get_individual (contact);
					_tmp28_ = _tmp27_;
					_tmp29_ = i;
					_tmp24_ = contacts_store_suggest_link_to (_tmp26_, _tmp28_, _tmp29_);
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					FolksIndividual* _tmp30_;
					FolksIndividual* _tmp31_;
					FolksIndividual* _tmp32_;
					_tmp30_ = contacts_contact_get_individual (contact);
					_tmp31_ = _tmp30_;
					_tmp32_ = i;
					contacts_contact_pane_add_suggestion (self, _tmp31_, _tmp32_);
					_g_object_unref0 (i);
					break;
				}
				_g_object_unref0 (i);
			}
			_g_object_unref0 (_i_it);
		}
		_g_object_unref0 (matches);
	}
	_g_object_unref0 (contacts_sheet);
}

static void
contacts_contact_pane_remove_contact_sheet (ContactsContactPane* self)
{
	ContactsContactSheet* _tmp0_;
	AdwClamp* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sheet;
	if (_tmp0_ == NULL) {
		return;
	}
	contacts_contact_pane_remove_suggestion_grid (self);
	_tmp1_ = self->priv->contact_sheet_clamp;
	adw_clamp_set_child (_tmp1_, NULL);
	self->priv->sheet = NULL;
}

static void
contacts_contact_pane_create_contact_editor (ContactsContactPane* self)
{
	ContactsContact* _tmp0_;
	ContactsContactEditor* contact_editor = NULL;
	ContactsContact* _tmp1_;
	ContactsContactEditor* _tmp2_;
	GtkBox* _tmp3_;
	ContactsContactEditor* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contact;
	_vala_return_if_fail (_tmp0_ != NULL, "this.contact != null");
	contacts_contact_pane_remove_contact_editor (self);
	_tmp1_ = self->priv->contact;
	_tmp2_ = contacts_contact_editor_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	contact_editor = _tmp2_;
	gtk_widget_set_hexpand ((GtkWidget*) contact_editor, TRUE);
	self->priv->editor = contact_editor;
	_tmp3_ = self->priv->contact_editor_box;
	_tmp4_ = self->priv->editor;
	gtk_box_append (_tmp3_, (GtkWidget*) _tmp4_);
	_g_object_unref0 (contact_editor);
}

static void
contacts_contact_pane_remove_contact_editor (ContactsContactPane* self)
{
	ContactsContactEditor* _tmp0_;
	GtkBox* _tmp1_;
	ContactsContactEditor* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->editor;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->contact_editor_box;
	_tmp2_ = self->priv->editor;
	gtk_box_remove (_tmp1_, (GtkWidget*) _tmp2_);
	self->priv->editor = NULL;
}

void
contacts_contact_pane_stop_editing (ContactsContactPane* self,
                                    gboolean cancel)
{
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->on_edit_mode, "this.on_edit_mode");
	self->on_edit_mode = FALSE;
	contacts_contact_pane_remove_contact_editor (self);
	if (cancel) {
		ContactsContact* _tmp0_;
		_tmp0_ = self->priv->contact;
		if (_tmp0_ != NULL) {
			GtkStack* _tmp1_;
			_tmp1_ = self->priv->stack;
			gtk_stack_set_visible_child_name (_tmp1_, "contact-sheet-page");
		} else {
			GtkStack* _tmp2_;
			_tmp2_ = self->priv->stack;
			gtk_stack_set_visible_child_name (_tmp2_, "none-selected-page");
		}
	} else {
		ContactsContact* _tmp3_;
		_tmp3_ = self->priv->contact;
		contacts_contact_pane_apply_changes (self, _tmp3_, NULL, NULL);
	}
}

static void
contacts_contact_pane_apply_changes_data_free (gpointer _data)
{
	ContactsContactPaneApplyChangesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->contact);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsContactPaneApplyChangesData, _data_);
}

static void
contacts_contact_pane_apply_changes (ContactsContactPane* self,
                                     ContactsContact* contact,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	ContactsContactPaneApplyChangesData* _data_;
	ContactsContactPane* _tmp0_;
	ContactsContact* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	_data_ = g_slice_new0 (ContactsContactPaneApplyChangesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_contact_pane_apply_changes_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (contact);
	_g_object_unref0 (_data_->contact);
	_data_->contact = _tmp1_;
	contacts_contact_pane_apply_changes_co (_data_);
}

static void
contacts_contact_pane_apply_changes_finish (ContactsContactPane* self,
                                            GAsyncResult* _res_)
{
	ContactsContactPaneApplyChangesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		ContactsContactPane* self;
		self = _data16_->self;
		(_data16_->callback_target_destroy_notify == NULL) ? NULL : (_data16_->callback_target_destroy_notify (_data16_->callback_target), NULL);
		_data16_->callback = NULL;
		_data16_->callback_target = NULL;
		_data16_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static gboolean
_contacts_contact_pane_apply_changes_co_gsource_func (gpointer self)
{
	gboolean result;
	result = contacts_contact_pane_apply_changes_co (self);
	return result;
}

static void
___lambda37_ (Block16Data* _data16_)
{
	ContactsContactPane* self;
	GSourceFunc _tmp0_;
	gpointer _tmp0__target;
	self = _data16_->self;
	_tmp0_ = _data16_->callback;
	_tmp0__target = _data16_->callback_target;
	_tmp0_ (_tmp0__target);
}

static void
____lambda37__contacts_store_quiescent (ContactsStore* _sender,
                                        gpointer self)
{
	___lambda37_ (self);
}

static void
contacts_contact_pane_apply_changes_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	ContactsContactPaneApplyChangesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_contact_pane_apply_changes_co (_data_);
}

static gboolean
contacts_contact_pane_apply_changes_co (ContactsContactPaneApplyChangesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	contacts_contact_pane_show_contact_sheet (_data_->self, _data_->contact);
	_data_->_tmp0_ = _data_->self->priv->_store;
	_data_->_tmp1_ = contacts_store_get_aggregator (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = folks_individual_aggregator_get_is_quiescent (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	if (!_data_->_tmp4_) {
		_data_->_data16_ = g_slice_new0 (Block16Data);
		_data_->_data16_->_ref_count_ = 1;
		_data_->_data16_->self = g_object_ref (_data_->self);
		_data_->_data16_->callback = _contacts_contact_pane_apply_changes_co_gsource_func;
		_data_->_data16_->callback_target = _data_;
		_data_->_data16_->callback_target_destroy_notify = NULL;
		_data_->_tmp5_ = _data_->self->priv->_store;
		_data_->_tmp6_ = g_signal_connect_data (_data_->_tmp5_, "quiescent", (GCallback) ____lambda37__contacts_store_quiescent, block16_data_ref (_data_->_data16_), (GClosureNotify) block16_data_unref, 0);
		_data_->signal_id = _data_->_tmp6_;
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		g_signal_handler_disconnect ((GObject*) _data_->self, _data_->signal_id);
		block16_data_unref (_data_->_data16_);
		_data_->_data16_ = NULL;
	}
	{
		_data_->_tmp7_ = _data_->self->priv->_store;
		_data_->_tmp8_ = contacts_store_get_aggregator (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = folks_individual_aggregator_get_primary_store (_data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_state_ = 2;
		contacts_contact_apply_changes (_data_->contact, _data_->_tmp11_, contacts_contact_pane_apply_changes_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp12_ = contacts_contact_apply_changes_finish (_data_->contact, _data_->_res_, &_data_->_inner_error0_);
		_data_->individual = _data_->_tmp12_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_data_->individual != NULL) {
			_data_->_tmp14_ = folks_individual_get_id (_data_->individual);
			_data_->_tmp15_ = _data_->_tmp14_;
			_data_->_tmp13_ = _data_->_tmp15_;
		} else {
			_data_->_tmp13_ = "null";
		}
		g_debug ("contacts-contact-pane.vala:173: Applied changes resulted in individual" \
" (%s)", _data_->_tmp13_);
		if (_data_->individual != NULL) {
			_data_->_tmp16_ = _data_->self->priv->_store;
			_data_->_tmp17_ = folks_individual_get_id (_data_->individual);
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->_state_ = 3;
			contacts_store_find_individual_for_id (_data_->_tmp16_, _data_->_tmp18_, contacts_contact_pane_apply_changes_ready, _data_);
			return FALSE;
			_state_3:
			_data_->pos = contacts_store_find_individual_for_id_finish (_data_->_tmp16_, _data_->_res_);
			if (_data_->pos != GTK_INVALID_LIST_POSITION) {
				_data_->_tmp19_ = _data_->self->priv->_selection_model;
				_data_->_tmp20_ = contacts_contact_selection_model_get_selected (_data_->_tmp19_);
				_data_->_tmp21_ = _data_->_tmp20_;
				gtk_single_selection_set_selected (_data_->_tmp21_, _data_->pos);
			}
		}
		_g_object_unref0 (_data_->individual);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp22_ = _data_->err;
		_data_->_tmp23_ = _data_->_tmp22_->message;
		g_warning ("contacts-contact-pane.vala:182: Couldn't save changes: %s", _data_->_tmp23_);
		contacts_contact_pane_show_contact (_data_->self, NULL);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
contacts_contact_pane_edit_contact (ContactsContactPane* self)
{
	ContactsContact* _tmp0_;
	GtkStack* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contact;
	_vala_return_if_fail (_tmp0_ != NULL, "this.contact != null");
	if (self->on_edit_mode) {
		return;
	}
	self->on_edit_mode = TRUE;
	contacts_contact_pane_create_contact_editor (self);
	_tmp1_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp1_, "contact-editor-page");
}

void
contacts_contact_pane_new_contact (ContactsContactPane* self)
{
	ContactsContact* _tmp0_;
	GtkStack* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = contacts_contact_new_empty ();
	_g_object_unref0 (self->priv->contact);
	self->priv->contact = _tmp0_;
	if (self->on_edit_mode) {
		return;
	}
	self->on_edit_mode = TRUE;
	contacts_contact_pane_create_contact_editor (self);
	_tmp1_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp1_, "contact-editor-page");
}

static void
contacts_contact_pane_remove_suggestion_grid (ContactsContactPane* self)
{
	ContactsLinkSuggestionGrid* _tmp0_;
	AdwToolbarView* parent_toolbar = NULL;
	GtkWidget* _tmp1_;
	AdwToolbarView* _tmp2_;
	ContactsLinkSuggestionGrid* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->suggestion_grid;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = gtk_widget_get_parent ((GtkWidget*) self);
	parent_toolbar = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, adw_toolbar_view_get_type ()) ? ((AdwToolbarView*) _tmp1_) : NULL;
	_tmp2_ = parent_toolbar;
	_tmp3_ = self->priv->suggestion_grid;
	adw_toolbar_view_remove (_tmp2_, (GtkWidget*) _tmp3_);
	_g_object_unref0 (self->priv->suggestion_grid);
	self->priv->suggestion_grid = NULL;
}

ContactsStore*
contacts_contact_pane_get_store (ContactsContactPane* self)
{
	ContactsStore* result;
	ContactsStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_store;
	result = _tmp0_;
	return result;
}

void
contacts_contact_pane_set_store (ContactsContactPane* self,
                                 ContactsStore* value)
{
	ContactsStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_contact_pane_get_store (self);
	if (old_value != value) {
		self->priv->_store = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_contact_pane_properties[CONTACTS_CONTACT_PANE_STORE_PROPERTY]);
	}
}

ContactsContactSelectionModel*
contacts_contact_pane_get_selection_model (ContactsContactPane* self)
{
	ContactsContactSelectionModel* result;
	ContactsContactSelectionModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selection_model;
	result = _tmp0_;
	return result;
}

void
contacts_contact_pane_set_selection_model (ContactsContactPane* self,
                                           ContactsContactSelectionModel* value)
{
	ContactsContactSelectionModel* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_contact_pane_get_selection_model (self);
	if (old_value != value) {
		self->priv->_selection_model = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_contact_pane_properties[CONTACTS_CONTACT_PANE_SELECTION_MODEL_PROPERTY]);
	}
}

static void
contacts_contact_pane_class_init (ContactsContactPaneClass * klass,
                                  gpointer klass_data)
{
	contacts_contact_pane_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsContactPane_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_contact_pane_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_contact_pane_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_pane_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_PANE_STORE_PROPERTY, contacts_contact_pane_properties[CONTACTS_CONTACT_PANE_STORE_PROPERTY] = g_param_spec_object ("store", "store", "store", CONTACTS_TYPE_STORE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_PANE_SELECTION_MODEL_PROPERTY, contacts_contact_pane_properties[CONTACTS_CONTACT_PANE_SELECTION_MODEL_PROPERTY] = g_param_spec_object ("selection-model", "selection-model", "selection-model", CONTACTS_TYPE_CONTACT_SELECTION_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Contacts/ui/contacts-contact-pane.ui");
	contacts_contact_pane_signals[CONTACTS_CONTACT_PANE_CONTACTS_LINKED_SIGNAL] = g_signal_new ("contacts-linked", CONTACTS_TYPE_CONTACT_PANE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CONTACTS_TYPE_LINK_OPERATION);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, ContactsContactPane_private_offset + G_STRUCT_OFFSET (ContactsContactPanePrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_sheet_clamp", FALSE, ContactsContactPane_private_offset + G_STRUCT_OFFSET (ContactsContactPanePrivate, contact_sheet_clamp));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_editor_box", FALSE, ContactsContactPane_private_offset + G_STRUCT_OFFSET (ContactsContactPanePrivate, contact_editor_box));
}

static void
contacts_contact_pane_instance_init (ContactsContactPane * self,
                                     gpointer klass)
{
	self->priv = contacts_contact_pane_get_instance_private (self);
	self->priv->contact = NULL;
	self->priv->sheet = NULL;
	self->priv->editor = NULL;
	self->on_edit_mode = FALSE;
	self->priv->suggestion_grid = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
contacts_contact_pane_finalize (GObject * obj)
{
	ContactsContactPane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane);
	_g_object_unref0 (self->priv->contact);
	_g_object_unref0 (self->priv->suggestion_grid);
	G_OBJECT_CLASS (contacts_contact_pane_parent_class)->finalize (obj);
}

/**
 * The ContactPage is the right pane. It consists of 3 possible pages:
 * a page if nothing is selected, a ContactSheet to view contact information,
 * and a ContactEditor to edit contact information.
 */
 G_GNUC_NO_INLINE static GType
contacts_contact_pane_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactPaneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_pane_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactPane), 0, (GInstanceInitFunc) contacts_contact_pane_instance_init, NULL };
	GType contacts_contact_pane_type_id;
	contacts_contact_pane_type_id = g_type_register_static (adw_bin_get_type (), "ContactsContactPane", &g_define_type_info, 0);
	ContactsContactPane_private_offset = g_type_add_instance_private (contacts_contact_pane_type_id, sizeof (ContactsContactPanePrivate));
	return contacts_contact_pane_type_id;
}

GType
contacts_contact_pane_get_type (void)
{
	static volatile gsize contacts_contact_pane_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_pane_type_id__once)) {
		GType contacts_contact_pane_type_id;
		contacts_contact_pane_type_id = contacts_contact_pane_get_type_once ();
		g_once_init_leave (&contacts_contact_pane_type_id__once, contacts_contact_pane_type_id);
	}
	return contacts_contact_pane_type_id__once;
}

static void
_vala_contacts_contact_pane_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ContactsContactPane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane);
	switch (property_id) {
		case CONTACTS_CONTACT_PANE_STORE_PROPERTY:
		g_value_set_object (value, contacts_contact_pane_get_store (self));
		break;
		case CONTACTS_CONTACT_PANE_SELECTION_MODEL_PROPERTY:
		g_value_set_object (value, contacts_contact_pane_get_selection_model (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_contact_pane_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	ContactsContactPane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane);
	switch (property_id) {
		case CONTACTS_CONTACT_PANE_STORE_PROPERTY:
		contacts_contact_pane_set_store (self, g_value_get_object (value));
		break;
		case CONTACTS_CONTACT_PANE_SELECTION_MODEL_PROPERTY:
		contacts_contact_pane_set_selection_model (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

