{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.TestConfig
    ( 

-- * Exported types
    TestConfig(..)                          ,
    newZeroTestConfig                       ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveTestConfigMethod                 ,
#endif



 -- * Properties


-- ** testInitialized #attr:testInitialized#
-- | /No description available in the introspection data./

    getTestConfigTestInitialized            ,
    setTestConfigTestInitialized            ,
#if defined(ENABLE_OVERLOADING)
    testConfig_testInitialized              ,
#endif


-- ** testPerf #attr:testPerf#
-- | /No description available in the introspection data./

    getTestConfigTestPerf                   ,
    setTestConfigTestPerf                   ,
#if defined(ENABLE_OVERLOADING)
    testConfig_testPerf                     ,
#endif


-- ** testQuick #attr:testQuick#
-- | /No description available in the introspection data./

    getTestConfigTestQuick                  ,
    setTestConfigTestQuick                  ,
#if defined(ENABLE_OVERLOADING)
    testConfig_testQuick                    ,
#endif


-- ** testQuiet #attr:testQuiet#
-- | /No description available in the introspection data./

    getTestConfigTestQuiet                  ,
    setTestConfigTestQuiet                  ,
#if defined(ENABLE_OVERLOADING)
    testConfig_testQuiet                    ,
#endif


-- ** testUndefined #attr:testUndefined#
-- | /No description available in the introspection data./

    getTestConfigTestUndefined              ,
    setTestConfigTestUndefined              ,
#if defined(ENABLE_OVERLOADING)
    testConfig_testUndefined                ,
#endif


-- ** testVerbose #attr:testVerbose#
-- | /No description available in the introspection data./

    getTestConfigTestVerbose                ,
    setTestConfigTestVerbose                ,
#if defined(ENABLE_OVERLOADING)
    testConfig_testVerbose                  ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype TestConfig = TestConfig (SP.ManagedPtr TestConfig)
    deriving (Eq)

instance SP.ManagedPtrNewtype TestConfig where
    toManagedPtr (TestConfig p) = p

instance BoxedPtr TestConfig where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr TestConfig)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr TestConfig where
    boxedPtrCalloc = callocBytes 24


-- | Construct a t'TestConfig' struct initialized to zero.
newZeroTestConfig :: MonadIO m => m TestConfig
newZeroTestConfig = liftIO $ boxedPtrCalloc >>= wrapPtr TestConfig

instance tag ~ 'AttrSet => Constructible TestConfig tag where
    new _ attrs = do
        o <- newZeroTestConfig
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@test_initialized@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' testConfig #testInitialized
-- @
getTestConfigTestInitialized :: MonadIO m => TestConfig -> m Bool
getTestConfigTestInitialized s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (/= 0) val
    return val'

-- | Set the value of the “@test_initialized@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' testConfig [ #testInitialized 'Data.GI.Base.Attributes.:=' value ]
-- @
setTestConfigTestInitialized :: MonadIO m => TestConfig -> Bool -> m ()
setTestConfigTestInitialized s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (P.fromIntegral . P.fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data TestConfigTestInitializedFieldInfo
instance AttrInfo TestConfigTestInitializedFieldInfo where
    type AttrBaseTypeConstraint TestConfigTestInitializedFieldInfo = (~) TestConfig
    type AttrAllowedOps TestConfigTestInitializedFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TestConfigTestInitializedFieldInfo = (~) Bool
    type AttrTransferTypeConstraint TestConfigTestInitializedFieldInfo = (~)Bool
    type AttrTransferType TestConfigTestInitializedFieldInfo = Bool
    type AttrGetType TestConfigTestInitializedFieldInfo = Bool
    type AttrLabel TestConfigTestInitializedFieldInfo = "test_initialized"
    type AttrOrigin TestConfigTestInitializedFieldInfo = TestConfig
    attrGet = getTestConfigTestInitialized
    attrSet = setTestConfigTestInitialized
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TestConfig.testInitialized"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-TestConfig.html#g:attr:testInitialized"
        })

testConfig_testInitialized :: AttrLabelProxy "testInitialized"
testConfig_testInitialized = AttrLabelProxy

#endif


-- | Get the value of the “@test_quick@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' testConfig #testQuick
-- @
getTestConfigTestQuick :: MonadIO m => TestConfig -> m Bool
getTestConfigTestQuick s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO CInt
    let val' = (/= 0) val
    return val'

-- | Set the value of the “@test_quick@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' testConfig [ #testQuick 'Data.GI.Base.Attributes.:=' value ]
-- @
setTestConfigTestQuick :: MonadIO m => TestConfig -> Bool -> m ()
setTestConfigTestQuick s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (P.fromIntegral . P.fromEnum) val
    poke (ptr `plusPtr` 4) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data TestConfigTestQuickFieldInfo
instance AttrInfo TestConfigTestQuickFieldInfo where
    type AttrBaseTypeConstraint TestConfigTestQuickFieldInfo = (~) TestConfig
    type AttrAllowedOps TestConfigTestQuickFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TestConfigTestQuickFieldInfo = (~) Bool
    type AttrTransferTypeConstraint TestConfigTestQuickFieldInfo = (~)Bool
    type AttrTransferType TestConfigTestQuickFieldInfo = Bool
    type AttrGetType TestConfigTestQuickFieldInfo = Bool
    type AttrLabel TestConfigTestQuickFieldInfo = "test_quick"
    type AttrOrigin TestConfigTestQuickFieldInfo = TestConfig
    attrGet = getTestConfigTestQuick
    attrSet = setTestConfigTestQuick
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TestConfig.testQuick"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-TestConfig.html#g:attr:testQuick"
        })

testConfig_testQuick :: AttrLabelProxy "testQuick"
testConfig_testQuick = AttrLabelProxy

#endif


-- | Get the value of the “@test_perf@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' testConfig #testPerf
-- @
getTestConfigTestPerf :: MonadIO m => TestConfig -> m Bool
getTestConfigTestPerf s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CInt
    let val' = (/= 0) val
    return val'

-- | Set the value of the “@test_perf@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' testConfig [ #testPerf 'Data.GI.Base.Attributes.:=' value ]
-- @
setTestConfigTestPerf :: MonadIO m => TestConfig -> Bool -> m ()
setTestConfigTestPerf s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (P.fromIntegral . P.fromEnum) val
    poke (ptr `plusPtr` 8) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data TestConfigTestPerfFieldInfo
instance AttrInfo TestConfigTestPerfFieldInfo where
    type AttrBaseTypeConstraint TestConfigTestPerfFieldInfo = (~) TestConfig
    type AttrAllowedOps TestConfigTestPerfFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TestConfigTestPerfFieldInfo = (~) Bool
    type AttrTransferTypeConstraint TestConfigTestPerfFieldInfo = (~)Bool
    type AttrTransferType TestConfigTestPerfFieldInfo = Bool
    type AttrGetType TestConfigTestPerfFieldInfo = Bool
    type AttrLabel TestConfigTestPerfFieldInfo = "test_perf"
    type AttrOrigin TestConfigTestPerfFieldInfo = TestConfig
    attrGet = getTestConfigTestPerf
    attrSet = setTestConfigTestPerf
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TestConfig.testPerf"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-TestConfig.html#g:attr:testPerf"
        })

testConfig_testPerf :: AttrLabelProxy "testPerf"
testConfig_testPerf = AttrLabelProxy

#endif


-- | Get the value of the “@test_verbose@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' testConfig #testVerbose
-- @
getTestConfigTestVerbose :: MonadIO m => TestConfig -> m Bool
getTestConfigTestVerbose s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO CInt
    let val' = (/= 0) val
    return val'

-- | Set the value of the “@test_verbose@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' testConfig [ #testVerbose 'Data.GI.Base.Attributes.:=' value ]
-- @
setTestConfigTestVerbose :: MonadIO m => TestConfig -> Bool -> m ()
setTestConfigTestVerbose s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (P.fromIntegral . P.fromEnum) val
    poke (ptr `plusPtr` 12) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data TestConfigTestVerboseFieldInfo
instance AttrInfo TestConfigTestVerboseFieldInfo where
    type AttrBaseTypeConstraint TestConfigTestVerboseFieldInfo = (~) TestConfig
    type AttrAllowedOps TestConfigTestVerboseFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TestConfigTestVerboseFieldInfo = (~) Bool
    type AttrTransferTypeConstraint TestConfigTestVerboseFieldInfo = (~)Bool
    type AttrTransferType TestConfigTestVerboseFieldInfo = Bool
    type AttrGetType TestConfigTestVerboseFieldInfo = Bool
    type AttrLabel TestConfigTestVerboseFieldInfo = "test_verbose"
    type AttrOrigin TestConfigTestVerboseFieldInfo = TestConfig
    attrGet = getTestConfigTestVerbose
    attrSet = setTestConfigTestVerbose
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TestConfig.testVerbose"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-TestConfig.html#g:attr:testVerbose"
        })

testConfig_testVerbose :: AttrLabelProxy "testVerbose"
testConfig_testVerbose = AttrLabelProxy

#endif


-- | Get the value of the “@test_quiet@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' testConfig #testQuiet
-- @
getTestConfigTestQuiet :: MonadIO m => TestConfig -> m Bool
getTestConfigTestQuiet s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CInt
    let val' = (/= 0) val
    return val'

-- | Set the value of the “@test_quiet@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' testConfig [ #testQuiet 'Data.GI.Base.Attributes.:=' value ]
-- @
setTestConfigTestQuiet :: MonadIO m => TestConfig -> Bool -> m ()
setTestConfigTestQuiet s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (P.fromIntegral . P.fromEnum) val
    poke (ptr `plusPtr` 16) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data TestConfigTestQuietFieldInfo
instance AttrInfo TestConfigTestQuietFieldInfo where
    type AttrBaseTypeConstraint TestConfigTestQuietFieldInfo = (~) TestConfig
    type AttrAllowedOps TestConfigTestQuietFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TestConfigTestQuietFieldInfo = (~) Bool
    type AttrTransferTypeConstraint TestConfigTestQuietFieldInfo = (~)Bool
    type AttrTransferType TestConfigTestQuietFieldInfo = Bool
    type AttrGetType TestConfigTestQuietFieldInfo = Bool
    type AttrLabel TestConfigTestQuietFieldInfo = "test_quiet"
    type AttrOrigin TestConfigTestQuietFieldInfo = TestConfig
    attrGet = getTestConfigTestQuiet
    attrSet = setTestConfigTestQuiet
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TestConfig.testQuiet"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-TestConfig.html#g:attr:testQuiet"
        })

testConfig_testQuiet :: AttrLabelProxy "testQuiet"
testConfig_testQuiet = AttrLabelProxy

#endif


-- | Get the value of the “@test_undefined@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' testConfig #testUndefined
-- @
getTestConfigTestUndefined :: MonadIO m => TestConfig -> m Bool
getTestConfigTestUndefined s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO CInt
    let val' = (/= 0) val
    return val'

-- | Set the value of the “@test_undefined@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' testConfig [ #testUndefined 'Data.GI.Base.Attributes.:=' value ]
-- @
setTestConfigTestUndefined :: MonadIO m => TestConfig -> Bool -> m ()
setTestConfigTestUndefined s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (P.fromIntegral . P.fromEnum) val
    poke (ptr `plusPtr` 20) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data TestConfigTestUndefinedFieldInfo
instance AttrInfo TestConfigTestUndefinedFieldInfo where
    type AttrBaseTypeConstraint TestConfigTestUndefinedFieldInfo = (~) TestConfig
    type AttrAllowedOps TestConfigTestUndefinedFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TestConfigTestUndefinedFieldInfo = (~) Bool
    type AttrTransferTypeConstraint TestConfigTestUndefinedFieldInfo = (~)Bool
    type AttrTransferType TestConfigTestUndefinedFieldInfo = Bool
    type AttrGetType TestConfigTestUndefinedFieldInfo = Bool
    type AttrLabel TestConfigTestUndefinedFieldInfo = "test_undefined"
    type AttrOrigin TestConfigTestUndefinedFieldInfo = TestConfig
    attrGet = getTestConfigTestUndefined
    attrSet = setTestConfigTestUndefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TestConfig.testUndefined"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-TestConfig.html#g:attr:testUndefined"
        })

testConfig_testUndefined :: AttrLabelProxy "testUndefined"
testConfig_testUndefined = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TestConfig
type instance O.AttributeList TestConfig = TestConfigAttributeList
type TestConfigAttributeList = ('[ '("testInitialized", TestConfigTestInitializedFieldInfo), '("testQuick", TestConfigTestQuickFieldInfo), '("testPerf", TestConfigTestPerfFieldInfo), '("testVerbose", TestConfigTestVerboseFieldInfo), '("testQuiet", TestConfigTestQuietFieldInfo), '("testUndefined", TestConfigTestUndefinedFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTestConfigMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTestConfigMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTestConfigMethod t TestConfig, O.OverloadedMethod info TestConfig p) => OL.IsLabel t (TestConfig -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTestConfigMethod t TestConfig, O.OverloadedMethod info TestConfig p, R.HasField t TestConfig p) => R.HasField t TestConfig p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTestConfigMethod t TestConfig, O.OverloadedMethodInfo info TestConfig) => OL.IsLabel t (O.MethodProxy info TestConfig) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


