{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node for an outset shadow.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.OutsetShadowNode
    ( 

-- * Exported types
    OutsetShadowNode(..)                    ,
    IsOutsetShadowNode                      ,
    toOutsetShadowNode                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBlurRadius]("GI.Gsk.Objects.OutsetShadowNode#g:method:getBlurRadius"), [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getColor]("GI.Gsk.Objects.OutsetShadowNode#g:method:getColor"), [getDx]("GI.Gsk.Objects.OutsetShadowNode#g:method:getDx"), [getDy]("GI.Gsk.Objects.OutsetShadowNode#g:method:getDy"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect"), [getOutline]("GI.Gsk.Objects.OutsetShadowNode#g:method:getOutline"), [getSpread]("GI.Gsk.Objects.OutsetShadowNode#g:method:getSpread").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveOutsetShadowNodeMethod           ,
#endif

-- ** getBlurRadius #method:getBlurRadius#

#if defined(ENABLE_OVERLOADING)
    OutsetShadowNodeGetBlurRadiusMethodInfo ,
#endif
    outsetShadowNodeGetBlurRadius           ,


-- ** getColor #method:getColor#

#if defined(ENABLE_OVERLOADING)
    OutsetShadowNodeGetColorMethodInfo      ,
#endif
    outsetShadowNodeGetColor                ,


-- ** getDx #method:getDx#

#if defined(ENABLE_OVERLOADING)
    OutsetShadowNodeGetDxMethodInfo         ,
#endif
    outsetShadowNodeGetDx                   ,


-- ** getDy #method:getDy#

#if defined(ENABLE_OVERLOADING)
    OutsetShadowNodeGetDyMethodInfo         ,
#endif
    outsetShadowNodeGetDy                   ,


-- ** getOutline #method:getOutline#

#if defined(ENABLE_OVERLOADING)
    OutsetShadowNodeGetOutlineMethodInfo    ,
#endif
    outsetShadowNodeGetOutline              ,


-- ** getSpread #method:getSpread#

#if defined(ENABLE_OVERLOADING)
    OutsetShadowNodeGetSpreadMethodInfo     ,
#endif
    outsetShadowNodeGetSpread               ,


-- ** new #method:new#

    outsetShadowNodeNew                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect

#else
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect

#endif

-- | Memory-managed wrapper type.
newtype OutsetShadowNode = OutsetShadowNode (SP.ManagedPtr OutsetShadowNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype OutsetShadowNode where
    toManagedPtr (OutsetShadowNode p) = p

foreign import ccall "gsk_outset_shadow_node_get_type"
    c_gsk_outset_shadow_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject OutsetShadowNode where
    glibType = c_gsk_outset_shadow_node_get_type

-- | Type class for types which can be safely cast to t'OutsetShadowNode', for instance with `toOutsetShadowNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf OutsetShadowNode o) => IsOutsetShadowNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf OutsetShadowNode o) => IsOutsetShadowNode o

instance O.HasParentTypes OutsetShadowNode
type instance O.ParentTypes OutsetShadowNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'OutsetShadowNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toOutsetShadowNode :: (MIO.MonadIO m, IsOutsetShadowNode o) => o -> m OutsetShadowNode
toOutsetShadowNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo OutsetShadowNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveOutsetShadowNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveOutsetShadowNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveOutsetShadowNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveOutsetShadowNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveOutsetShadowNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveOutsetShadowNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveOutsetShadowNodeMethod "getBlurRadius" o = OutsetShadowNodeGetBlurRadiusMethodInfo
    ResolveOutsetShadowNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveOutsetShadowNodeMethod "getColor" o = OutsetShadowNodeGetColorMethodInfo
    ResolveOutsetShadowNodeMethod "getDx" o = OutsetShadowNodeGetDxMethodInfo
    ResolveOutsetShadowNodeMethod "getDy" o = OutsetShadowNodeGetDyMethodInfo
    ResolveOutsetShadowNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveOutsetShadowNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveOutsetShadowNodeMethod "getOutline" o = OutsetShadowNodeGetOutlineMethodInfo
    ResolveOutsetShadowNodeMethod "getSpread" o = OutsetShadowNodeGetSpreadMethodInfo
    ResolveOutsetShadowNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveOutsetShadowNodeMethod t OutsetShadowNode, O.OverloadedMethod info OutsetShadowNode p) => OL.IsLabel t (OutsetShadowNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveOutsetShadowNodeMethod t OutsetShadowNode, O.OverloadedMethod info OutsetShadowNode p, R.HasField t OutsetShadowNode p) => R.HasField t OutsetShadowNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveOutsetShadowNodeMethod t OutsetShadowNode, O.OverloadedMethodInfo info OutsetShadowNode) => OL.IsLabel t (O.MethodProxy info OutsetShadowNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr OutsetShadowNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method OutsetShadowNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "outline"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RoundedRect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "outline of the region surrounded by shadow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color"
--           , argType = TInterface Name { namespace = "Gdk" , name = "RGBA" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "color of the shadow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dx"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "horizontal offset of shadow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dy"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "vertical offset of shadow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "spread"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "how far the shadow spreads towards the inside"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blur_radius"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "how much blur to apply to the shadow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gsk" , name = "OutsetShadowNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_outset_shadow_node_new" gsk_outset_shadow_node_new :: 
    Ptr Gsk.RoundedRect.RoundedRect ->      -- outline : TInterface (Name {namespace = "Gsk", name = "RoundedRect"})
    Ptr Gdk.RGBA.RGBA ->                    -- color : TInterface (Name {namespace = "Gdk", name = "RGBA"})
    CFloat ->                               -- dx : TBasicType TFloat
    CFloat ->                               -- dy : TBasicType TFloat
    CFloat ->                               -- spread : TBasicType TFloat
    CFloat ->                               -- blur_radius : TBasicType TFloat
    IO (Ptr OutsetShadowNode)

-- | Creates a @GskRenderNode@ that will render an outset shadow
-- around the box given by /@outline@/.
outsetShadowNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gsk.RoundedRect.RoundedRect
    -- ^ /@outline@/: outline of the region surrounded by shadow
    -> Gdk.RGBA.RGBA
    -- ^ /@color@/: color of the shadow
    -> Float
    -- ^ /@dx@/: horizontal offset of shadow
    -> Float
    -- ^ /@dy@/: vertical offset of shadow
    -> Float
    -- ^ /@spread@/: how far the shadow spreads towards the inside
    -> Float
    -- ^ /@blurRadius@/: how much blur to apply to the shadow
    -> m OutsetShadowNode
    -- ^ __Returns:__ A new @GskRenderNode@
outsetShadowNodeNew outline color dx dy spread blurRadius = liftIO $ do
    outline' <- unsafeManagedPtrGetPtr outline
    color' <- unsafeManagedPtrGetPtr color
    let dx' = realToFrac dx
    let dy' = realToFrac dy
    let spread' = realToFrac spread
    let blurRadius' = realToFrac blurRadius
    result <- gsk_outset_shadow_node_new outline' color' dx' dy' spread' blurRadius'
    checkUnexpectedReturnNULL "outsetShadowNodeNew" result
    result' <- (wrapPtr OutsetShadowNode) result
    touchManagedPtr outline
    touchManagedPtr color
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method OutsetShadowNode::get_blur_radius
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "OutsetShadowNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for an outset shadow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_outset_shadow_node_get_blur_radius" gsk_outset_shadow_node_get_blur_radius :: 
    Ptr OutsetShadowNode ->                 -- node : TInterface (Name {namespace = "Gsk", name = "OutsetShadowNode"})
    IO CFloat

-- | Retrieves the blur radius of the shadow.
outsetShadowNodeGetBlurRadius ::
    (B.CallStack.HasCallStack, MonadIO m, IsOutsetShadowNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for an outset shadow
    -> m Float
    -- ^ __Returns:__ the blur radius, in pixels
outsetShadowNodeGetBlurRadius node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_outset_shadow_node_get_blur_radius node'
    let result' = realToFrac result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data OutsetShadowNodeGetBlurRadiusMethodInfo
instance (signature ~ (m Float), MonadIO m, IsOutsetShadowNode a) => O.OverloadedMethod OutsetShadowNodeGetBlurRadiusMethodInfo a signature where
    overloadedMethod = outsetShadowNodeGetBlurRadius

instance O.OverloadedMethodInfo OutsetShadowNodeGetBlurRadiusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.OutsetShadowNode.outsetShadowNodeGetBlurRadius",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-OutsetShadowNode.html#v:outsetShadowNodeGetBlurRadius"
        })


#endif

-- method OutsetShadowNode::get_color
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "OutsetShadowNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for an outset shadow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "RGBA" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_outset_shadow_node_get_color" gsk_outset_shadow_node_get_color :: 
    Ptr OutsetShadowNode ->                 -- node : TInterface (Name {namespace = "Gsk", name = "OutsetShadowNode"})
    IO (Ptr Gdk.RGBA.RGBA)

-- | Retrieves the color of the outset shadow.
-- 
-- The value returned by this function will not be correct
-- if the render node was created for a non-sRGB color.
outsetShadowNodeGetColor ::
    (B.CallStack.HasCallStack, MonadIO m, IsOutsetShadowNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for an outset shadow
    -> m Gdk.RGBA.RGBA
    -- ^ __Returns:__ a color
outsetShadowNodeGetColor node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_outset_shadow_node_get_color node'
    checkUnexpectedReturnNULL "outsetShadowNodeGetColor" result
    result' <- (newBoxed Gdk.RGBA.RGBA) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data OutsetShadowNodeGetColorMethodInfo
instance (signature ~ (m Gdk.RGBA.RGBA), MonadIO m, IsOutsetShadowNode a) => O.OverloadedMethod OutsetShadowNodeGetColorMethodInfo a signature where
    overloadedMethod = outsetShadowNodeGetColor

instance O.OverloadedMethodInfo OutsetShadowNodeGetColorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.OutsetShadowNode.outsetShadowNodeGetColor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-OutsetShadowNode.html#v:outsetShadowNodeGetColor"
        })


#endif

-- method OutsetShadowNode::get_dx
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "OutsetShadowNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for an outset shadow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_outset_shadow_node_get_dx" gsk_outset_shadow_node_get_dx :: 
    Ptr OutsetShadowNode ->                 -- node : TInterface (Name {namespace = "Gsk", name = "OutsetShadowNode"})
    IO CFloat

-- | Retrieves the horizontal offset of the outset shadow.
outsetShadowNodeGetDx ::
    (B.CallStack.HasCallStack, MonadIO m, IsOutsetShadowNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for an outset shadow
    -> m Float
    -- ^ __Returns:__ an offset, in pixels
outsetShadowNodeGetDx node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_outset_shadow_node_get_dx node'
    let result' = realToFrac result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data OutsetShadowNodeGetDxMethodInfo
instance (signature ~ (m Float), MonadIO m, IsOutsetShadowNode a) => O.OverloadedMethod OutsetShadowNodeGetDxMethodInfo a signature where
    overloadedMethod = outsetShadowNodeGetDx

instance O.OverloadedMethodInfo OutsetShadowNodeGetDxMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.OutsetShadowNode.outsetShadowNodeGetDx",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-OutsetShadowNode.html#v:outsetShadowNodeGetDx"
        })


#endif

-- method OutsetShadowNode::get_dy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "OutsetShadowNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for an outset shadow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_outset_shadow_node_get_dy" gsk_outset_shadow_node_get_dy :: 
    Ptr OutsetShadowNode ->                 -- node : TInterface (Name {namespace = "Gsk", name = "OutsetShadowNode"})
    IO CFloat

-- | Retrieves the vertical offset of the outset shadow.
outsetShadowNodeGetDy ::
    (B.CallStack.HasCallStack, MonadIO m, IsOutsetShadowNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for an outset shadow
    -> m Float
    -- ^ __Returns:__ an offset, in pixels
outsetShadowNodeGetDy node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_outset_shadow_node_get_dy node'
    let result' = realToFrac result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data OutsetShadowNodeGetDyMethodInfo
instance (signature ~ (m Float), MonadIO m, IsOutsetShadowNode a) => O.OverloadedMethod OutsetShadowNodeGetDyMethodInfo a signature where
    overloadedMethod = outsetShadowNodeGetDy

instance O.OverloadedMethodInfo OutsetShadowNodeGetDyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.OutsetShadowNode.outsetShadowNodeGetDy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-OutsetShadowNode.html#v:outsetShadowNodeGetDy"
        })


#endif

-- method OutsetShadowNode::get_outline
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "OutsetShadowNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for an outset shadow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RoundedRect" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_outset_shadow_node_get_outline" gsk_outset_shadow_node_get_outline :: 
    Ptr OutsetShadowNode ->                 -- node : TInterface (Name {namespace = "Gsk", name = "OutsetShadowNode"})
    IO (Ptr Gsk.RoundedRect.RoundedRect)

-- | Retrieves the outline rectangle of the outset shadow.
outsetShadowNodeGetOutline ::
    (B.CallStack.HasCallStack, MonadIO m, IsOutsetShadowNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for an outset shadow
    -> m Gsk.RoundedRect.RoundedRect
    -- ^ __Returns:__ a rounded rectangle
outsetShadowNodeGetOutline node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_outset_shadow_node_get_outline node'
    checkUnexpectedReturnNULL "outsetShadowNodeGetOutline" result
    result' <- (newPtr Gsk.RoundedRect.RoundedRect) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data OutsetShadowNodeGetOutlineMethodInfo
instance (signature ~ (m Gsk.RoundedRect.RoundedRect), MonadIO m, IsOutsetShadowNode a) => O.OverloadedMethod OutsetShadowNodeGetOutlineMethodInfo a signature where
    overloadedMethod = outsetShadowNodeGetOutline

instance O.OverloadedMethodInfo OutsetShadowNodeGetOutlineMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.OutsetShadowNode.outsetShadowNodeGetOutline",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-OutsetShadowNode.html#v:outsetShadowNodeGetOutline"
        })


#endif

-- method OutsetShadowNode::get_spread
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "OutsetShadowNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for an outset shadow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_outset_shadow_node_get_spread" gsk_outset_shadow_node_get_spread :: 
    Ptr OutsetShadowNode ->                 -- node : TInterface (Name {namespace = "Gsk", name = "OutsetShadowNode"})
    IO CFloat

-- | Retrieves how much the shadow spreads outwards.
outsetShadowNodeGetSpread ::
    (B.CallStack.HasCallStack, MonadIO m, IsOutsetShadowNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for an outset shadow
    -> m Float
    -- ^ __Returns:__ the size of the shadow, in pixels
outsetShadowNodeGetSpread node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_outset_shadow_node_get_spread node'
    let result' = realToFrac result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data OutsetShadowNodeGetSpreadMethodInfo
instance (signature ~ (m Float), MonadIO m, IsOutsetShadowNode a) => O.OverloadedMethod OutsetShadowNodeGetSpreadMethodInfo a signature where
    overloadedMethod = outsetShadowNodeGetSpread

instance O.OverloadedMethodInfo OutsetShadowNodeGetSpreadMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.OutsetShadowNode.outsetShadowNodeGetSpread",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-OutsetShadowNode.html#v:outsetShadowNodeGetSpread"
        })


#endif


