{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Collects the arguments that are needed to present a message to the user.
-- 
-- The message is shown with the 'GI.Gtk.Objects.AlertDialog.alertDialogChoose'
-- function.
-- 
-- If you don\'t need to wait for a button to be clicked, you can use
-- 'GI.Gtk.Objects.AlertDialog.alertDialogShow'.
-- 
-- /Since: 4.10/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.AlertDialog
    ( 

-- * Exported types
    AlertDialog(..)                         ,
    IsAlertDialog                           ,
    toAlertDialog                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [choose]("GI.Gtk.Objects.AlertDialog#g:method:choose"), [chooseFinish]("GI.Gtk.Objects.AlertDialog#g:method:chooseFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [show]("GI.Gtk.Objects.AlertDialog#g:method:show"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getButtons]("GI.Gtk.Objects.AlertDialog#g:method:getButtons"), [getCancelButton]("GI.Gtk.Objects.AlertDialog#g:method:getCancelButton"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDefaultButton]("GI.Gtk.Objects.AlertDialog#g:method:getDefaultButton"), [getDetail]("GI.Gtk.Objects.AlertDialog#g:method:getDetail"), [getMessage]("GI.Gtk.Objects.AlertDialog#g:method:getMessage"), [getModal]("GI.Gtk.Objects.AlertDialog#g:method:getModal"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setButtons]("GI.Gtk.Objects.AlertDialog#g:method:setButtons"), [setCancelButton]("GI.Gtk.Objects.AlertDialog#g:method:setCancelButton"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDefaultButton]("GI.Gtk.Objects.AlertDialog#g:method:setDefaultButton"), [setDetail]("GI.Gtk.Objects.AlertDialog#g:method:setDetail"), [setMessage]("GI.Gtk.Objects.AlertDialog#g:method:setMessage"), [setModal]("GI.Gtk.Objects.AlertDialog#g:method:setModal"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveAlertDialogMethod                ,
#endif

-- ** choose #method:choose#

#if defined(ENABLE_OVERLOADING)
    AlertDialogChooseMethodInfo             ,
#endif
    alertDialogChoose                       ,


-- ** chooseFinish #method:chooseFinish#

#if defined(ENABLE_OVERLOADING)
    AlertDialogChooseFinishMethodInfo       ,
#endif
    alertDialogChooseFinish                 ,


-- ** getButtons #method:getButtons#

#if defined(ENABLE_OVERLOADING)
    AlertDialogGetButtonsMethodInfo         ,
#endif
    alertDialogGetButtons                   ,


-- ** getCancelButton #method:getCancelButton#

#if defined(ENABLE_OVERLOADING)
    AlertDialogGetCancelButtonMethodInfo    ,
#endif
    alertDialogGetCancelButton              ,


-- ** getDefaultButton #method:getDefaultButton#

#if defined(ENABLE_OVERLOADING)
    AlertDialogGetDefaultButtonMethodInfo   ,
#endif
    alertDialogGetDefaultButton             ,


-- ** getDetail #method:getDetail#

#if defined(ENABLE_OVERLOADING)
    AlertDialogGetDetailMethodInfo          ,
#endif
    alertDialogGetDetail                    ,


-- ** getMessage #method:getMessage#

#if defined(ENABLE_OVERLOADING)
    AlertDialogGetMessageMethodInfo         ,
#endif
    alertDialogGetMessage                   ,


-- ** getModal #method:getModal#

#if defined(ENABLE_OVERLOADING)
    AlertDialogGetModalMethodInfo           ,
#endif
    alertDialogGetModal                     ,


-- ** setButtons #method:setButtons#

#if defined(ENABLE_OVERLOADING)
    AlertDialogSetButtonsMethodInfo         ,
#endif
    alertDialogSetButtons                   ,


-- ** setCancelButton #method:setCancelButton#

#if defined(ENABLE_OVERLOADING)
    AlertDialogSetCancelButtonMethodInfo    ,
#endif
    alertDialogSetCancelButton              ,


-- ** setDefaultButton #method:setDefaultButton#

#if defined(ENABLE_OVERLOADING)
    AlertDialogSetDefaultButtonMethodInfo   ,
#endif
    alertDialogSetDefaultButton             ,


-- ** setDetail #method:setDetail#

#if defined(ENABLE_OVERLOADING)
    AlertDialogSetDetailMethodInfo          ,
#endif
    alertDialogSetDetail                    ,


-- ** setMessage #method:setMessage#

#if defined(ENABLE_OVERLOADING)
    AlertDialogSetMessageMethodInfo         ,
#endif
    alertDialogSetMessage                   ,


-- ** setModal #method:setModal#

#if defined(ENABLE_OVERLOADING)
    AlertDialogSetModalMethodInfo           ,
#endif
    alertDialogSetModal                     ,


-- ** show #method:show#

#if defined(ENABLE_OVERLOADING)
    AlertDialogShowMethodInfo               ,
#endif
    alertDialogShow                         ,




 -- * Properties


-- ** buttons #attr:buttons#
-- | Labels for buttons to show in the alert.
-- 
-- The labels should be translated and may contain
-- a @_@ character to indicate the mnemonic character.
-- 
-- If this property is not set, then a \'Close\' button is
-- automatically created.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    AlertDialogButtonsPropertyInfo          ,
#endif
#if defined(ENABLE_OVERLOADING)
    alertDialogButtons                      ,
#endif
    constructAlertDialogButtons             ,
    getAlertDialogButtons                   ,
    setAlertDialogButtons                   ,


-- ** cancelButton #attr:cancelButton#
-- | Determines what happens when the \<kbd>Escape\<\/kbd> key is pressed
-- while the alert is shown.
-- 
-- If this property holds the index of a button in [AlertDialog:buttons]("GI.Gtk.Objects.AlertDialog#g:attr:buttons"),
-- then pressing Escape is treated as if that button was pressed. If it is -1
-- or not a valid index for the @buttons@ array, then an error is returned.
-- 
-- If @buttons@ is @NULL@, then the automatically created \'Close\' button
-- is treated as both cancel and default button, so 0 is returned.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    AlertDialogCancelButtonPropertyInfo     ,
#endif
#if defined(ENABLE_OVERLOADING)
    alertDialogCancelButton                 ,
#endif
    constructAlertDialogCancelButton        ,
    getAlertDialogCancelButton              ,
    setAlertDialogCancelButton              ,


-- ** defaultButton #attr:defaultButton#
-- | Determines what happens when the \<kbd>Return\<\/kbd> key is pressed
-- while the alert is shown.
-- 
-- If this property holds the index of a button in [AlertDialog:buttons]("GI.Gtk.Objects.AlertDialog#g:attr:buttons"),
-- then pressing Return is treated as if that button was pressed. If it is -1
-- or not a valid index for the @buttons@ array, then nothing happens.
-- 
-- If @buttons@ is @NULL@, then the automatically created \'Close\' button
-- is treated as both cancel and default button, so 0 is returned.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    AlertDialogDefaultButtonPropertyInfo    ,
#endif
#if defined(ENABLE_OVERLOADING)
    alertDialogDefaultButton                ,
#endif
    constructAlertDialogDefaultButton       ,
    getAlertDialogDefaultButton             ,
    setAlertDialogDefaultButton             ,


-- ** detail #attr:detail#
-- | The detail text for the alert.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    AlertDialogDetailPropertyInfo           ,
#endif
#if defined(ENABLE_OVERLOADING)
    alertDialogDetail                       ,
#endif
    constructAlertDialogDetail              ,
    getAlertDialogDetail                    ,
    setAlertDialogDetail                    ,


-- ** message #attr:message#
-- | The message for the alert.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    AlertDialogMessagePropertyInfo          ,
#endif
#if defined(ENABLE_OVERLOADING)
    alertDialogMessage                      ,
#endif
    constructAlertDialogMessage             ,
    getAlertDialogMessage                   ,
    setAlertDialogMessage                   ,


-- ** modal #attr:modal#
-- | Whether the alert is modal.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    AlertDialogModalPropertyInfo            ,
#endif
#if defined(ENABLE_OVERLOADING)
    alertDialogModal                        ,
#endif
    constructAlertDialogModal               ,
    getAlertDialogModal                     ,
    setAlertDialogModal                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Flags as Gio.Flags
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.Application as Gio.Application
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.Menu as Gio.Menu
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window
import {-# SOURCE #-} qualified GI.Gtk.Objects.WindowGroup as Gtk.WindowGroup
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window

#endif

-- | Memory-managed wrapper type.
newtype AlertDialog = AlertDialog (SP.ManagedPtr AlertDialog)
    deriving (Eq)

instance SP.ManagedPtrNewtype AlertDialog where
    toManagedPtr (AlertDialog p) = p

foreign import ccall "gtk_alert_dialog_get_type"
    c_gtk_alert_dialog_get_type :: IO B.Types.GType

instance B.Types.TypedObject AlertDialog where
    glibType = c_gtk_alert_dialog_get_type

instance B.Types.GObject AlertDialog

-- | Type class for types which can be safely cast to t'AlertDialog', for instance with `toAlertDialog`.
class (SP.GObject o, O.IsDescendantOf AlertDialog o) => IsAlertDialog o
instance (SP.GObject o, O.IsDescendantOf AlertDialog o) => IsAlertDialog o

instance O.HasParentTypes AlertDialog
type instance O.ParentTypes AlertDialog = '[GObject.Object.Object]

-- | Cast to t'AlertDialog', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toAlertDialog :: (MIO.MonadIO m, IsAlertDialog o) => o -> m AlertDialog
toAlertDialog = MIO.liftIO . B.ManagedPtr.unsafeCastTo AlertDialog

-- | Convert t'AlertDialog' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe AlertDialog) where
    gvalueGType_ = c_gtk_alert_dialog_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr AlertDialog)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr AlertDialog)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject AlertDialog ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveAlertDialogMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAlertDialogMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveAlertDialogMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveAlertDialogMethod "choose" o = AlertDialogChooseMethodInfo
    ResolveAlertDialogMethod "chooseFinish" o = AlertDialogChooseFinishMethodInfo
    ResolveAlertDialogMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveAlertDialogMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveAlertDialogMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveAlertDialogMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveAlertDialogMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveAlertDialogMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveAlertDialogMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveAlertDialogMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveAlertDialogMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveAlertDialogMethod "show" o = AlertDialogShowMethodInfo
    ResolveAlertDialogMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveAlertDialogMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveAlertDialogMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveAlertDialogMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveAlertDialogMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveAlertDialogMethod "getButtons" o = AlertDialogGetButtonsMethodInfo
    ResolveAlertDialogMethod "getCancelButton" o = AlertDialogGetCancelButtonMethodInfo
    ResolveAlertDialogMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveAlertDialogMethod "getDefaultButton" o = AlertDialogGetDefaultButtonMethodInfo
    ResolveAlertDialogMethod "getDetail" o = AlertDialogGetDetailMethodInfo
    ResolveAlertDialogMethod "getMessage" o = AlertDialogGetMessageMethodInfo
    ResolveAlertDialogMethod "getModal" o = AlertDialogGetModalMethodInfo
    ResolveAlertDialogMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveAlertDialogMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveAlertDialogMethod "setButtons" o = AlertDialogSetButtonsMethodInfo
    ResolveAlertDialogMethod "setCancelButton" o = AlertDialogSetCancelButtonMethodInfo
    ResolveAlertDialogMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveAlertDialogMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveAlertDialogMethod "setDefaultButton" o = AlertDialogSetDefaultButtonMethodInfo
    ResolveAlertDialogMethod "setDetail" o = AlertDialogSetDetailMethodInfo
    ResolveAlertDialogMethod "setMessage" o = AlertDialogSetMessageMethodInfo
    ResolveAlertDialogMethod "setModal" o = AlertDialogSetModalMethodInfo
    ResolveAlertDialogMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveAlertDialogMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAlertDialogMethod t AlertDialog, O.OverloadedMethod info AlertDialog p) => OL.IsLabel t (AlertDialog -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAlertDialogMethod t AlertDialog, O.OverloadedMethod info AlertDialog p, R.HasField t AlertDialog p) => R.HasField t AlertDialog p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAlertDialogMethod t AlertDialog, O.OverloadedMethodInfo info AlertDialog) => OL.IsLabel t (O.MethodProxy info AlertDialog) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "buttons"
   -- Type: TCArray True (-1) (-1) (TBasicType TUTF8)
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@buttons@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' alertDialog #buttons
-- @
getAlertDialogButtons :: (MonadIO m, IsAlertDialog o) => o -> m (Maybe [T.Text])
getAlertDialogButtons obj = MIO.liftIO $ B.Properties.getObjectPropertyStringArray obj "buttons"

-- | Set the value of the “@buttons@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' alertDialog [ #buttons 'Data.GI.Base.Attributes.:=' value ]
-- @
setAlertDialogButtons :: (MonadIO m, IsAlertDialog o) => o -> [T.Text] -> m ()
setAlertDialogButtons obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyStringArray obj "buttons" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@buttons@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAlertDialogButtons :: (IsAlertDialog o, MIO.MonadIO m) => [T.Text] -> m (GValueConstruct o)
constructAlertDialogButtons val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyStringArray "buttons" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data AlertDialogButtonsPropertyInfo
instance AttrInfo AlertDialogButtonsPropertyInfo where
    type AttrAllowedOps AlertDialogButtonsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint AlertDialogButtonsPropertyInfo = IsAlertDialog
    type AttrSetTypeConstraint AlertDialogButtonsPropertyInfo = (~) [T.Text]
    type AttrTransferTypeConstraint AlertDialogButtonsPropertyInfo = (~) [T.Text]
    type AttrTransferType AlertDialogButtonsPropertyInfo = [T.Text]
    type AttrGetType AlertDialogButtonsPropertyInfo = (Maybe [T.Text])
    type AttrLabel AlertDialogButtonsPropertyInfo = "buttons"
    type AttrOrigin AlertDialogButtonsPropertyInfo = AlertDialog
    attrGet = getAlertDialogButtons
    attrSet = setAlertDialogButtons
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructAlertDialogButtons
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.buttons"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#g:attr:buttons"
        })
#endif

-- VVV Prop "cancel-button"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@cancel-button@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' alertDialog #cancelButton
-- @
getAlertDialogCancelButton :: (MonadIO m, IsAlertDialog o) => o -> m Int32
getAlertDialogCancelButton obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "cancel-button"

-- | Set the value of the “@cancel-button@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' alertDialog [ #cancelButton 'Data.GI.Base.Attributes.:=' value ]
-- @
setAlertDialogCancelButton :: (MonadIO m, IsAlertDialog o) => o -> Int32 -> m ()
setAlertDialogCancelButton obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "cancel-button" val

-- | Construct a t'GValueConstruct' with valid value for the “@cancel-button@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAlertDialogCancelButton :: (IsAlertDialog o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructAlertDialogCancelButton val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "cancel-button" val

#if defined(ENABLE_OVERLOADING)
data AlertDialogCancelButtonPropertyInfo
instance AttrInfo AlertDialogCancelButtonPropertyInfo where
    type AttrAllowedOps AlertDialogCancelButtonPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint AlertDialogCancelButtonPropertyInfo = IsAlertDialog
    type AttrSetTypeConstraint AlertDialogCancelButtonPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint AlertDialogCancelButtonPropertyInfo = (~) Int32
    type AttrTransferType AlertDialogCancelButtonPropertyInfo = Int32
    type AttrGetType AlertDialogCancelButtonPropertyInfo = Int32
    type AttrLabel AlertDialogCancelButtonPropertyInfo = "cancel-button"
    type AttrOrigin AlertDialogCancelButtonPropertyInfo = AlertDialog
    attrGet = getAlertDialogCancelButton
    attrSet = setAlertDialogCancelButton
    attrPut = setAlertDialogCancelButton
    attrTransfer _ v = do
        return v
    attrConstruct = constructAlertDialogCancelButton
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.cancelButton"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#g:attr:cancelButton"
        })
#endif

-- VVV Prop "default-button"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@default-button@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' alertDialog #defaultButton
-- @
getAlertDialogDefaultButton :: (MonadIO m, IsAlertDialog o) => o -> m Int32
getAlertDialogDefaultButton obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "default-button"

-- | Set the value of the “@default-button@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' alertDialog [ #defaultButton 'Data.GI.Base.Attributes.:=' value ]
-- @
setAlertDialogDefaultButton :: (MonadIO m, IsAlertDialog o) => o -> Int32 -> m ()
setAlertDialogDefaultButton obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "default-button" val

-- | Construct a t'GValueConstruct' with valid value for the “@default-button@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAlertDialogDefaultButton :: (IsAlertDialog o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructAlertDialogDefaultButton val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "default-button" val

#if defined(ENABLE_OVERLOADING)
data AlertDialogDefaultButtonPropertyInfo
instance AttrInfo AlertDialogDefaultButtonPropertyInfo where
    type AttrAllowedOps AlertDialogDefaultButtonPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint AlertDialogDefaultButtonPropertyInfo = IsAlertDialog
    type AttrSetTypeConstraint AlertDialogDefaultButtonPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint AlertDialogDefaultButtonPropertyInfo = (~) Int32
    type AttrTransferType AlertDialogDefaultButtonPropertyInfo = Int32
    type AttrGetType AlertDialogDefaultButtonPropertyInfo = Int32
    type AttrLabel AlertDialogDefaultButtonPropertyInfo = "default-button"
    type AttrOrigin AlertDialogDefaultButtonPropertyInfo = AlertDialog
    attrGet = getAlertDialogDefaultButton
    attrSet = setAlertDialogDefaultButton
    attrPut = setAlertDialogDefaultButton
    attrTransfer _ v = do
        return v
    attrConstruct = constructAlertDialogDefaultButton
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.defaultButton"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#g:attr:defaultButton"
        })
#endif

-- VVV Prop "detail"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@detail@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' alertDialog #detail
-- @
getAlertDialogDetail :: (MonadIO m, IsAlertDialog o) => o -> m T.Text
getAlertDialogDetail obj = MIO.liftIO $ checkUnexpectedNothing "getAlertDialogDetail" $ B.Properties.getObjectPropertyString obj "detail"

-- | Set the value of the “@detail@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' alertDialog [ #detail 'Data.GI.Base.Attributes.:=' value ]
-- @
setAlertDialogDetail :: (MonadIO m, IsAlertDialog o) => o -> T.Text -> m ()
setAlertDialogDetail obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "detail" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@detail@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAlertDialogDetail :: (IsAlertDialog o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructAlertDialogDetail val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "detail" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data AlertDialogDetailPropertyInfo
instance AttrInfo AlertDialogDetailPropertyInfo where
    type AttrAllowedOps AlertDialogDetailPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint AlertDialogDetailPropertyInfo = IsAlertDialog
    type AttrSetTypeConstraint AlertDialogDetailPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint AlertDialogDetailPropertyInfo = (~) T.Text
    type AttrTransferType AlertDialogDetailPropertyInfo = T.Text
    type AttrGetType AlertDialogDetailPropertyInfo = T.Text
    type AttrLabel AlertDialogDetailPropertyInfo = "detail"
    type AttrOrigin AlertDialogDetailPropertyInfo = AlertDialog
    attrGet = getAlertDialogDetail
    attrSet = setAlertDialogDetail
    attrPut = setAlertDialogDetail
    attrTransfer _ v = do
        return v
    attrConstruct = constructAlertDialogDetail
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.detail"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#g:attr:detail"
        })
#endif

-- VVV Prop "message"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@message@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' alertDialog #message
-- @
getAlertDialogMessage :: (MonadIO m, IsAlertDialog o) => o -> m T.Text
getAlertDialogMessage obj = MIO.liftIO $ checkUnexpectedNothing "getAlertDialogMessage" $ B.Properties.getObjectPropertyString obj "message"

-- | Set the value of the “@message@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' alertDialog [ #message 'Data.GI.Base.Attributes.:=' value ]
-- @
setAlertDialogMessage :: (MonadIO m, IsAlertDialog o) => o -> T.Text -> m ()
setAlertDialogMessage obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "message" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@message@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAlertDialogMessage :: (IsAlertDialog o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructAlertDialogMessage val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "message" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data AlertDialogMessagePropertyInfo
instance AttrInfo AlertDialogMessagePropertyInfo where
    type AttrAllowedOps AlertDialogMessagePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint AlertDialogMessagePropertyInfo = IsAlertDialog
    type AttrSetTypeConstraint AlertDialogMessagePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint AlertDialogMessagePropertyInfo = (~) T.Text
    type AttrTransferType AlertDialogMessagePropertyInfo = T.Text
    type AttrGetType AlertDialogMessagePropertyInfo = T.Text
    type AttrLabel AlertDialogMessagePropertyInfo = "message"
    type AttrOrigin AlertDialogMessagePropertyInfo = AlertDialog
    attrGet = getAlertDialogMessage
    attrSet = setAlertDialogMessage
    attrPut = setAlertDialogMessage
    attrTransfer _ v = do
        return v
    attrConstruct = constructAlertDialogMessage
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.message"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#g:attr:message"
        })
#endif

-- VVV Prop "modal"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@modal@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' alertDialog #modal
-- @
getAlertDialogModal :: (MonadIO m, IsAlertDialog o) => o -> m Bool
getAlertDialogModal obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "modal"

-- | Set the value of the “@modal@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' alertDialog [ #modal 'Data.GI.Base.Attributes.:=' value ]
-- @
setAlertDialogModal :: (MonadIO m, IsAlertDialog o) => o -> Bool -> m ()
setAlertDialogModal obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "modal" val

-- | Construct a t'GValueConstruct' with valid value for the “@modal@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAlertDialogModal :: (IsAlertDialog o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructAlertDialogModal val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "modal" val

#if defined(ENABLE_OVERLOADING)
data AlertDialogModalPropertyInfo
instance AttrInfo AlertDialogModalPropertyInfo where
    type AttrAllowedOps AlertDialogModalPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint AlertDialogModalPropertyInfo = IsAlertDialog
    type AttrSetTypeConstraint AlertDialogModalPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint AlertDialogModalPropertyInfo = (~) Bool
    type AttrTransferType AlertDialogModalPropertyInfo = Bool
    type AttrGetType AlertDialogModalPropertyInfo = Bool
    type AttrLabel AlertDialogModalPropertyInfo = "modal"
    type AttrOrigin AlertDialogModalPropertyInfo = AlertDialog
    attrGet = getAlertDialogModal
    attrSet = setAlertDialogModal
    attrPut = setAlertDialogModal
    attrTransfer _ v = do
        return v
    attrConstruct = constructAlertDialogModal
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.modal"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#g:attr:modal"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AlertDialog
type instance O.AttributeList AlertDialog = AlertDialogAttributeList
type AlertDialogAttributeList = ('[ '("buttons", AlertDialogButtonsPropertyInfo), '("cancelButton", AlertDialogCancelButtonPropertyInfo), '("defaultButton", AlertDialogDefaultButtonPropertyInfo), '("detail", AlertDialogDetailPropertyInfo), '("message", AlertDialogMessagePropertyInfo), '("modal", AlertDialogModalPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
alertDialogButtons :: AttrLabelProxy "buttons"
alertDialogButtons = AttrLabelProxy

alertDialogCancelButton :: AttrLabelProxy "cancelButton"
alertDialogCancelButton = AttrLabelProxy

alertDialogDefaultButton :: AttrLabelProxy "defaultButton"
alertDialogDefaultButton = AttrLabelProxy

alertDialogDetail :: AttrLabelProxy "detail"
alertDialogDetail = AttrLabelProxy

alertDialogMessage :: AttrLabelProxy "message"
alertDialogMessage = AttrLabelProxy

alertDialogModal :: AttrLabelProxy "modal"
alertDialogModal = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList AlertDialog = AlertDialogSignalList
type AlertDialogSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method AlertDialog::choose
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AlertDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an alert dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the parent window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cancellable to cancel the operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a callback to call\n  when the operation is complete"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 4
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_alert_dialog_choose" gtk_alert_dialog_choose :: 
    Ptr AlertDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AlertDialog"})
    Ptr Gtk.Window.Window ->                -- parent : TInterface (Name {namespace = "Gtk", name = "Window"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Shows the alert to the user.
-- 
-- It is ok to pass @NULL@ for the callback if the alert
-- does not have more than one button. A simpler API for
-- this case is 'GI.Gtk.Objects.AlertDialog.alertDialogShow'.
-- 
-- /Since: 4.10/
alertDialogChoose ::
    (B.CallStack.HasCallStack, MonadIO m, IsAlertDialog a, Gtk.Window.IsWindow b, Gio.Cancellable.IsCancellable c) =>
    a
    -- ^ /@self@/: an alert dialog
    -> Maybe (b)
    -- ^ /@parent@/: the parent window
    -> Maybe (c)
    -- ^ /@cancellable@/: a cancellable to cancel the operation
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a callback to call
    --   when the operation is complete
    -> m ()
alertDialogChoose self parent cancellable callback = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeParent <- case parent of
        Nothing -> return FP.nullPtr
        Just jParent -> do
            jParent' <- unsafeManagedPtrCastPtr jParent
            return jParent'
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    gtk_alert_dialog_choose self' maybeParent maybeCancellable maybeCallback userData
    touchManagedPtr self
    whenJust parent touchManagedPtr
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data AlertDialogChooseMethodInfo
instance (signature ~ (Maybe (b) -> Maybe (c) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsAlertDialog a, Gtk.Window.IsWindow b, Gio.Cancellable.IsCancellable c) => O.OverloadedMethod AlertDialogChooseMethodInfo a signature where
    overloadedMethod = alertDialogChoose

instance O.OverloadedMethodInfo AlertDialogChooseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.alertDialogChoose",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#v:alertDialogChoose"
        })


#endif

-- method AlertDialog::choose_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AlertDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an alert dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the result" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : True
-- Skip return : False

foreign import ccall "gtk_alert_dialog_choose_finish" gtk_alert_dialog_choose_finish :: 
    Ptr AlertDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AlertDialog"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO Int32

-- | Finishes the 'GI.Gtk.Objects.AlertDialog.alertDialogChoose' call.
-- 
-- /Since: 4.10/
alertDialogChooseFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsAlertDialog a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@self@/: an alert dialog
    -> b
    -- ^ /@result@/: the result
    -> m Int32
    -- ^ __Returns:__ the index of the button that was clicked, or -1 if
    --   the dialog was cancelled and [AlertDialog:cancelButton]("GI.Gtk.Objects.AlertDialog#g:attr:cancelButton")
    --   is not set /(Can throw 'Data.GI.Base.GError.GError')/
alertDialogChooseFinish self result_ = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ gtk_alert_dialog_choose_finish self' result_'
        touchManagedPtr self
        touchManagedPtr result_
        return result
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data AlertDialogChooseFinishMethodInfo
instance (signature ~ (b -> m Int32), MonadIO m, IsAlertDialog a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod AlertDialogChooseFinishMethodInfo a signature where
    overloadedMethod = alertDialogChooseFinish

instance O.OverloadedMethodInfo AlertDialogChooseFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.alertDialogChooseFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#v:alertDialogChooseFinish"
        })


#endif

-- method AlertDialog::get_buttons
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AlertDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an alert dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "gtk_alert_dialog_get_buttons" gtk_alert_dialog_get_buttons :: 
    Ptr AlertDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AlertDialog"})
    IO (Ptr CString)

-- | Returns the button labels for the alert.
-- 
-- /Since: 4.10/
alertDialogGetButtons ::
    (B.CallStack.HasCallStack, MonadIO m, IsAlertDialog a) =>
    a
    -- ^ /@self@/: an alert dialog
    -> m (Maybe [T.Text])
    -- ^ __Returns:__ the button labels
alertDialogGetButtons self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_alert_dialog_get_buttons self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- unpackZeroTerminatedUTF8CArray result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AlertDialogGetButtonsMethodInfo
instance (signature ~ (m (Maybe [T.Text])), MonadIO m, IsAlertDialog a) => O.OverloadedMethod AlertDialogGetButtonsMethodInfo a signature where
    overloadedMethod = alertDialogGetButtons

instance O.OverloadedMethodInfo AlertDialogGetButtonsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.alertDialogGetButtons",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#v:alertDialogGetButtons"
        })


#endif

-- method AlertDialog::get_cancel_button
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AlertDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an alert dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_alert_dialog_get_cancel_button" gtk_alert_dialog_get_cancel_button :: 
    Ptr AlertDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AlertDialog"})
    IO Int32

-- | Returns the index of the cancel button.
-- 
-- /Since: 4.10/
alertDialogGetCancelButton ::
    (B.CallStack.HasCallStack, MonadIO m, IsAlertDialog a) =>
    a
    -- ^ /@self@/: an alert dialog
    -> m Int32
    -- ^ __Returns:__ the index of the cancel button, or -1
alertDialogGetCancelButton self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_alert_dialog_get_cancel_button self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data AlertDialogGetCancelButtonMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsAlertDialog a) => O.OverloadedMethod AlertDialogGetCancelButtonMethodInfo a signature where
    overloadedMethod = alertDialogGetCancelButton

instance O.OverloadedMethodInfo AlertDialogGetCancelButtonMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.alertDialogGetCancelButton",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#v:alertDialogGetCancelButton"
        })


#endif

-- method AlertDialog::get_default_button
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AlertDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an alert dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_alert_dialog_get_default_button" gtk_alert_dialog_get_default_button :: 
    Ptr AlertDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AlertDialog"})
    IO Int32

-- | Returns the index of the default button.
-- 
-- /Since: 4.10/
alertDialogGetDefaultButton ::
    (B.CallStack.HasCallStack, MonadIO m, IsAlertDialog a) =>
    a
    -- ^ /@self@/: an alert dialog
    -> m Int32
    -- ^ __Returns:__ the index of the default button, or -1
alertDialogGetDefaultButton self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_alert_dialog_get_default_button self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data AlertDialogGetDefaultButtonMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsAlertDialog a) => O.OverloadedMethod AlertDialogGetDefaultButtonMethodInfo a signature where
    overloadedMethod = alertDialogGetDefaultButton

instance O.OverloadedMethodInfo AlertDialogGetDefaultButtonMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.alertDialogGetDefaultButton",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#v:alertDialogGetDefaultButton"
        })


#endif

-- method AlertDialog::get_detail
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AlertDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an alert dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_alert_dialog_get_detail" gtk_alert_dialog_get_detail :: 
    Ptr AlertDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AlertDialog"})
    IO CString

-- | Returns the detail text that will be shown in the alert.
-- 
-- /Since: 4.10/
alertDialogGetDetail ::
    (B.CallStack.HasCallStack, MonadIO m, IsAlertDialog a) =>
    a
    -- ^ /@self@/: an alert dialog
    -> m T.Text
    -- ^ __Returns:__ the detail text
alertDialogGetDetail self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_alert_dialog_get_detail self'
    checkUnexpectedReturnNULL "alertDialogGetDetail" result
    result' <- cstringToText result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data AlertDialogGetDetailMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsAlertDialog a) => O.OverloadedMethod AlertDialogGetDetailMethodInfo a signature where
    overloadedMethod = alertDialogGetDetail

instance O.OverloadedMethodInfo AlertDialogGetDetailMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.alertDialogGetDetail",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#v:alertDialogGetDetail"
        })


#endif

-- method AlertDialog::get_message
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AlertDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an alert dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_alert_dialog_get_message" gtk_alert_dialog_get_message :: 
    Ptr AlertDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AlertDialog"})
    IO CString

-- | Returns the message that will be shown in the alert.
-- 
-- /Since: 4.10/
alertDialogGetMessage ::
    (B.CallStack.HasCallStack, MonadIO m, IsAlertDialog a) =>
    a
    -- ^ /@self@/: an alert dialog
    -> m T.Text
    -- ^ __Returns:__ the message
alertDialogGetMessage self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_alert_dialog_get_message self'
    checkUnexpectedReturnNULL "alertDialogGetMessage" result
    result' <- cstringToText result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data AlertDialogGetMessageMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsAlertDialog a) => O.OverloadedMethod AlertDialogGetMessageMethodInfo a signature where
    overloadedMethod = alertDialogGetMessage

instance O.OverloadedMethodInfo AlertDialogGetMessageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.alertDialogGetMessage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#v:alertDialogGetMessage"
        })


#endif

-- method AlertDialog::get_modal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AlertDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an alert dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_alert_dialog_get_modal" gtk_alert_dialog_get_modal :: 
    Ptr AlertDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AlertDialog"})
    IO CInt

-- | Returns whether the alert blocks interaction
-- with the parent window while it is presented.
-- 
-- /Since: 4.10/
alertDialogGetModal ::
    (B.CallStack.HasCallStack, MonadIO m, IsAlertDialog a) =>
    a
    -- ^ /@self@/: an alert dialog
    -> m Bool
    -- ^ __Returns:__ true if the alert is modal
alertDialogGetModal self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_alert_dialog_get_modal self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data AlertDialogGetModalMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsAlertDialog a) => O.OverloadedMethod AlertDialogGetModalMethodInfo a signature where
    overloadedMethod = alertDialogGetModal

instance O.OverloadedMethodInfo AlertDialogGetModalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.alertDialogGetModal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#v:alertDialogGetModal"
        })


#endif

-- method AlertDialog::set_buttons
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AlertDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an alert dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "labels"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new button labels"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_alert_dialog_set_buttons" gtk_alert_dialog_set_buttons :: 
    Ptr AlertDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AlertDialog"})
    Ptr CString ->                          -- labels : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO ()

-- | Sets the button labels for the alert.
-- 
-- /Since: 4.10/
alertDialogSetButtons ::
    (B.CallStack.HasCallStack, MonadIO m, IsAlertDialog a) =>
    a
    -- ^ /@self@/: an alert dialog
    -> [T.Text]
    -- ^ /@labels@/: the new button labels
    -> m ()
alertDialogSetButtons self labels = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    labels' <- packZeroTerminatedUTF8CArray labels
    gtk_alert_dialog_set_buttons self' labels'
    touchManagedPtr self
    mapZeroTerminatedCArray freeMem labels'
    freeMem labels'
    return ()

#if defined(ENABLE_OVERLOADING)
data AlertDialogSetButtonsMethodInfo
instance (signature ~ ([T.Text] -> m ()), MonadIO m, IsAlertDialog a) => O.OverloadedMethod AlertDialogSetButtonsMethodInfo a signature where
    overloadedMethod = alertDialogSetButtons

instance O.OverloadedMethodInfo AlertDialogSetButtonsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.alertDialogSetButtons",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#v:alertDialogSetButtons"
        })


#endif

-- method AlertDialog::set_cancel_button
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AlertDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an alert dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "button"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new cancel button"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_alert_dialog_set_cancel_button" gtk_alert_dialog_set_cancel_button :: 
    Ptr AlertDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AlertDialog"})
    Int32 ->                                -- button : TBasicType TInt
    IO ()

-- | Sets the index of the cancel button.
-- 
-- See [AlertDialog:cancelButton]("GI.Gtk.Objects.AlertDialog#g:attr:cancelButton") for
-- details of how this value is used.
-- 
-- /Since: 4.10/
alertDialogSetCancelButton ::
    (B.CallStack.HasCallStack, MonadIO m, IsAlertDialog a) =>
    a
    -- ^ /@self@/: an alert dialog
    -> Int32
    -- ^ /@button@/: the new cancel button
    -> m ()
alertDialogSetCancelButton self button = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_alert_dialog_set_cancel_button self' button
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AlertDialogSetCancelButtonMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsAlertDialog a) => O.OverloadedMethod AlertDialogSetCancelButtonMethodInfo a signature where
    overloadedMethod = alertDialogSetCancelButton

instance O.OverloadedMethodInfo AlertDialogSetCancelButtonMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.alertDialogSetCancelButton",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#v:alertDialogSetCancelButton"
        })


#endif

-- method AlertDialog::set_default_button
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AlertDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an alert dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "button"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new default button"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_alert_dialog_set_default_button" gtk_alert_dialog_set_default_button :: 
    Ptr AlertDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AlertDialog"})
    Int32 ->                                -- button : TBasicType TInt
    IO ()

-- | Sets the index of the default button.
-- 
-- See [AlertDialog:defaultButton]("GI.Gtk.Objects.AlertDialog#g:attr:defaultButton") for
-- details of how this value is used.
-- 
-- /Since: 4.10/
alertDialogSetDefaultButton ::
    (B.CallStack.HasCallStack, MonadIO m, IsAlertDialog a) =>
    a
    -- ^ /@self@/: an alert dialog
    -> Int32
    -- ^ /@button@/: the new default button
    -> m ()
alertDialogSetDefaultButton self button = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_alert_dialog_set_default_button self' button
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AlertDialogSetDefaultButtonMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsAlertDialog a) => O.OverloadedMethod AlertDialogSetDefaultButtonMethodInfo a signature where
    overloadedMethod = alertDialogSetDefaultButton

instance O.OverloadedMethodInfo AlertDialogSetDefaultButtonMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.alertDialogSetDefaultButton",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#v:alertDialogSetDefaultButton"
        })


#endif

-- method AlertDialog::set_detail
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AlertDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an alert dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "detail"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new detail text"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_alert_dialog_set_detail" gtk_alert_dialog_set_detail :: 
    Ptr AlertDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AlertDialog"})
    CString ->                              -- detail : TBasicType TUTF8
    IO ()

-- | Sets the detail text that will be shown in the alert.
-- 
-- /Since: 4.10/
alertDialogSetDetail ::
    (B.CallStack.HasCallStack, MonadIO m, IsAlertDialog a) =>
    a
    -- ^ /@self@/: an alert dialog
    -> T.Text
    -- ^ /@detail@/: the new detail text
    -> m ()
alertDialogSetDetail self detail = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    detail' <- textToCString detail
    gtk_alert_dialog_set_detail self' detail'
    touchManagedPtr self
    freeMem detail'
    return ()

#if defined(ENABLE_OVERLOADING)
data AlertDialogSetDetailMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsAlertDialog a) => O.OverloadedMethod AlertDialogSetDetailMethodInfo a signature where
    overloadedMethod = alertDialogSetDetail

instance O.OverloadedMethodInfo AlertDialogSetDetailMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.alertDialogSetDetail",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#v:alertDialogSetDetail"
        })


#endif

-- method AlertDialog::set_message
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AlertDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an alert dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "message"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new message" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_alert_dialog_set_message" gtk_alert_dialog_set_message :: 
    Ptr AlertDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AlertDialog"})
    CString ->                              -- message : TBasicType TUTF8
    IO ()

-- | Sets the message that will be shown in the alert.
-- 
-- /Since: 4.10/
alertDialogSetMessage ::
    (B.CallStack.HasCallStack, MonadIO m, IsAlertDialog a) =>
    a
    -- ^ /@self@/: an alert dialog
    -> T.Text
    -- ^ /@message@/: the new message
    -> m ()
alertDialogSetMessage self message = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    message' <- textToCString message
    gtk_alert_dialog_set_message self' message'
    touchManagedPtr self
    freeMem message'
    return ()

#if defined(ENABLE_OVERLOADING)
data AlertDialogSetMessageMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsAlertDialog a) => O.OverloadedMethod AlertDialogSetMessageMethodInfo a signature where
    overloadedMethod = alertDialogSetMessage

instance O.OverloadedMethodInfo AlertDialogSetMessageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.alertDialogSetMessage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#v:alertDialogSetMessage"
        })


#endif

-- method AlertDialog::set_modal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AlertDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an alert dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "modal"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_alert_dialog_set_modal" gtk_alert_dialog_set_modal :: 
    Ptr AlertDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AlertDialog"})
    CInt ->                                 -- modal : TBasicType TBoolean
    IO ()

-- | Sets whether the alert blocks interaction
-- with the parent window while it is presented.
-- 
-- /Since: 4.10/
alertDialogSetModal ::
    (B.CallStack.HasCallStack, MonadIO m, IsAlertDialog a) =>
    a
    -- ^ /@self@/: an alert dialog
    -> Bool
    -- ^ /@modal@/: the new value
    -> m ()
alertDialogSetModal self modal = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let modal' = (P.fromIntegral . P.fromEnum) modal
    gtk_alert_dialog_set_modal self' modal'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data AlertDialogSetModalMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsAlertDialog a) => O.OverloadedMethod AlertDialogSetModalMethodInfo a signature where
    overloadedMethod = alertDialogSetModal

instance O.OverloadedMethodInfo AlertDialogSetModalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.alertDialogSetModal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#v:alertDialogSetModal"
        })


#endif

-- method AlertDialog::show
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AlertDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an alert dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the parent window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_alert_dialog_show" gtk_alert_dialog_show :: 
    Ptr AlertDialog ->                      -- self : TInterface (Name {namespace = "Gtk", name = "AlertDialog"})
    Ptr Gtk.Window.Window ->                -- parent : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO ()

-- | Shows the alert to the user.
-- 
-- This function is a simpler version of 'GI.Gtk.Objects.AlertDialog.alertDialogChoose'
-- intended for dialogs with a single button.
-- 
-- If you want to cancel the dialog or if the alert has more than one
-- button, you should use that function instead and provide it with a
-- t'GI.Gio.Objects.Cancellable.Cancellable' and callback respectively.
-- 
-- /Since: 4.10/
alertDialogShow ::
    (B.CallStack.HasCallStack, MonadIO m, IsAlertDialog a, Gtk.Window.IsWindow b) =>
    a
    -- ^ /@self@/: an alert dialog
    -> Maybe (b)
    -- ^ /@parent@/: the parent window
    -> m ()
alertDialogShow self parent = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeParent <- case parent of
        Nothing -> return FP.nullPtr
        Just jParent -> do
            jParent' <- unsafeManagedPtrCastPtr jParent
            return jParent'
    gtk_alert_dialog_show self' maybeParent
    touchManagedPtr self
    whenJust parent touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data AlertDialogShowMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsAlertDialog a, Gtk.Window.IsWindow b) => O.OverloadedMethod AlertDialogShowMethodInfo a signature where
    overloadedMethod = alertDialogShow

instance O.OverloadedMethodInfo AlertDialogShowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlertDialog.alertDialogShow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlertDialog.html#v:alertDialogShow"
        })


#endif


