{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Manages up to three children.
-- 
-- The start widget is allocated at the start of the layout (left in
-- left-to-right locales and right in right-to-left ones), and the end
-- widget at the end.
-- 
-- The center widget is centered regarding the full width of the layout\'s.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.CenterLayout
    ( 

-- * Exported types
    CenterLayout(..)                        ,
    IsCenterLayout                          ,
    toCenterLayout                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [allocate]("GI.Gtk.Objects.LayoutManager#g:method:allocate"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [layoutChanged]("GI.Gtk.Objects.LayoutManager#g:method:layoutChanged"), [measure]("GI.Gtk.Objects.LayoutManager#g:method:measure"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBaselinePosition]("GI.Gtk.Objects.CenterLayout#g:method:getBaselinePosition"), [getCenterWidget]("GI.Gtk.Objects.CenterLayout#g:method:getCenterWidget"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getEndWidget]("GI.Gtk.Objects.CenterLayout#g:method:getEndWidget"), [getLayoutChild]("GI.Gtk.Objects.LayoutManager#g:method:getLayoutChild"), [getOrientation]("GI.Gtk.Objects.CenterLayout#g:method:getOrientation"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRequestMode]("GI.Gtk.Objects.LayoutManager#g:method:getRequestMode"), [getShrinkCenterLast]("GI.Gtk.Objects.CenterLayout#g:method:getShrinkCenterLast"), [getStartWidget]("GI.Gtk.Objects.CenterLayout#g:method:getStartWidget"), [getWidget]("GI.Gtk.Objects.LayoutManager#g:method:getWidget").
-- 
-- ==== Setters
-- [setBaselinePosition]("GI.Gtk.Objects.CenterLayout#g:method:setBaselinePosition"), [setCenterWidget]("GI.Gtk.Objects.CenterLayout#g:method:setCenterWidget"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setEndWidget]("GI.Gtk.Objects.CenterLayout#g:method:setEndWidget"), [setOrientation]("GI.Gtk.Objects.CenterLayout#g:method:setOrientation"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setShrinkCenterLast]("GI.Gtk.Objects.CenterLayout#g:method:setShrinkCenterLast"), [setStartWidget]("GI.Gtk.Objects.CenterLayout#g:method:setStartWidget").

#if defined(ENABLE_OVERLOADING)
    ResolveCenterLayoutMethod               ,
#endif

-- ** getBaselinePosition #method:getBaselinePosition#

#if defined(ENABLE_OVERLOADING)
    CenterLayoutGetBaselinePositionMethodInfo,
#endif
    centerLayoutGetBaselinePosition         ,


-- ** getCenterWidget #method:getCenterWidget#

#if defined(ENABLE_OVERLOADING)
    CenterLayoutGetCenterWidgetMethodInfo   ,
#endif
    centerLayoutGetCenterWidget             ,


-- ** getEndWidget #method:getEndWidget#

#if defined(ENABLE_OVERLOADING)
    CenterLayoutGetEndWidgetMethodInfo      ,
#endif
    centerLayoutGetEndWidget                ,


-- ** getOrientation #method:getOrientation#

#if defined(ENABLE_OVERLOADING)
    CenterLayoutGetOrientationMethodInfo    ,
#endif
    centerLayoutGetOrientation              ,


-- ** getShrinkCenterLast #method:getShrinkCenterLast#

#if defined(ENABLE_OVERLOADING)
    CenterLayoutGetShrinkCenterLastMethodInfo,
#endif
    centerLayoutGetShrinkCenterLast         ,


-- ** getStartWidget #method:getStartWidget#

#if defined(ENABLE_OVERLOADING)
    CenterLayoutGetStartWidgetMethodInfo    ,
#endif
    centerLayoutGetStartWidget              ,


-- ** new #method:new#

    centerLayoutNew                         ,


-- ** setBaselinePosition #method:setBaselinePosition#

#if defined(ENABLE_OVERLOADING)
    CenterLayoutSetBaselinePositionMethodInfo,
#endif
    centerLayoutSetBaselinePosition         ,


-- ** setCenterWidget #method:setCenterWidget#

#if defined(ENABLE_OVERLOADING)
    CenterLayoutSetCenterWidgetMethodInfo   ,
#endif
    centerLayoutSetCenterWidget             ,


-- ** setEndWidget #method:setEndWidget#

#if defined(ENABLE_OVERLOADING)
    CenterLayoutSetEndWidgetMethodInfo      ,
#endif
    centerLayoutSetEndWidget                ,


-- ** setOrientation #method:setOrientation#

#if defined(ENABLE_OVERLOADING)
    CenterLayoutSetOrientationMethodInfo    ,
#endif
    centerLayoutSetOrientation              ,


-- ** setShrinkCenterLast #method:setShrinkCenterLast#

#if defined(ENABLE_OVERLOADING)
    CenterLayoutSetShrinkCenterLastMethodInfo,
#endif
    centerLayoutSetShrinkCenterLast         ,


-- ** setStartWidget #method:setStartWidget#

#if defined(ENABLE_OVERLOADING)
    CenterLayoutSetStartWidgetMethodInfo    ,
#endif
    centerLayoutSetStartWidget              ,




 -- * Properties


-- ** shrinkCenterLast #attr:shrinkCenterLast#
-- | Whether to shrink the center widget after other children.
-- 
-- By default, when there\'s no space to give all three children their
-- natural widths, the start and end widgets start shrinking and the
-- center child keeps natural width until they reach minimum width.
-- 
-- If set to @FALSE@, start and end widgets keep natural width and the
-- center widget starts shrinking instead.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    CenterLayoutShrinkCenterLastPropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    centerLayoutShrinkCenterLast            ,
#endif
    constructCenterLayoutShrinkCenterLast   ,
    getCenterLayoutShrinkCenterLast         ,
    setCenterLayoutShrinkCenterLast         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype CenterLayout = CenterLayout (SP.ManagedPtr CenterLayout)
    deriving (Eq)

instance SP.ManagedPtrNewtype CenterLayout where
    toManagedPtr (CenterLayout p) = p

foreign import ccall "gtk_center_layout_get_type"
    c_gtk_center_layout_get_type :: IO B.Types.GType

instance B.Types.TypedObject CenterLayout where
    glibType = c_gtk_center_layout_get_type

instance B.Types.GObject CenterLayout

-- | Type class for types which can be safely cast to t'CenterLayout', for instance with `toCenterLayout`.
class (SP.GObject o, O.IsDescendantOf CenterLayout o) => IsCenterLayout o
instance (SP.GObject o, O.IsDescendantOf CenterLayout o) => IsCenterLayout o

instance O.HasParentTypes CenterLayout
type instance O.ParentTypes CenterLayout = '[Gtk.LayoutManager.LayoutManager, GObject.Object.Object]

-- | Cast to t'CenterLayout', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toCenterLayout :: (MIO.MonadIO m, IsCenterLayout o) => o -> m CenterLayout
toCenterLayout = MIO.liftIO . B.ManagedPtr.unsafeCastTo CenterLayout

-- | Convert t'CenterLayout' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe CenterLayout) where
    gvalueGType_ = c_gtk_center_layout_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr CenterLayout)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr CenterLayout)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject CenterLayout ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveCenterLayoutMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCenterLayoutMethod "allocate" o = Gtk.LayoutManager.LayoutManagerAllocateMethodInfo
    ResolveCenterLayoutMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveCenterLayoutMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveCenterLayoutMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveCenterLayoutMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveCenterLayoutMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveCenterLayoutMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveCenterLayoutMethod "layoutChanged" o = Gtk.LayoutManager.LayoutManagerLayoutChangedMethodInfo
    ResolveCenterLayoutMethod "measure" o = Gtk.LayoutManager.LayoutManagerMeasureMethodInfo
    ResolveCenterLayoutMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveCenterLayoutMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveCenterLayoutMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveCenterLayoutMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveCenterLayoutMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveCenterLayoutMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveCenterLayoutMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveCenterLayoutMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveCenterLayoutMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveCenterLayoutMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveCenterLayoutMethod "getBaselinePosition" o = CenterLayoutGetBaselinePositionMethodInfo
    ResolveCenterLayoutMethod "getCenterWidget" o = CenterLayoutGetCenterWidgetMethodInfo
    ResolveCenterLayoutMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveCenterLayoutMethod "getEndWidget" o = CenterLayoutGetEndWidgetMethodInfo
    ResolveCenterLayoutMethod "getLayoutChild" o = Gtk.LayoutManager.LayoutManagerGetLayoutChildMethodInfo
    ResolveCenterLayoutMethod "getOrientation" o = CenterLayoutGetOrientationMethodInfo
    ResolveCenterLayoutMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveCenterLayoutMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveCenterLayoutMethod "getRequestMode" o = Gtk.LayoutManager.LayoutManagerGetRequestModeMethodInfo
    ResolveCenterLayoutMethod "getShrinkCenterLast" o = CenterLayoutGetShrinkCenterLastMethodInfo
    ResolveCenterLayoutMethod "getStartWidget" o = CenterLayoutGetStartWidgetMethodInfo
    ResolveCenterLayoutMethod "getWidget" o = Gtk.LayoutManager.LayoutManagerGetWidgetMethodInfo
    ResolveCenterLayoutMethod "setBaselinePosition" o = CenterLayoutSetBaselinePositionMethodInfo
    ResolveCenterLayoutMethod "setCenterWidget" o = CenterLayoutSetCenterWidgetMethodInfo
    ResolveCenterLayoutMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveCenterLayoutMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveCenterLayoutMethod "setEndWidget" o = CenterLayoutSetEndWidgetMethodInfo
    ResolveCenterLayoutMethod "setOrientation" o = CenterLayoutSetOrientationMethodInfo
    ResolveCenterLayoutMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveCenterLayoutMethod "setShrinkCenterLast" o = CenterLayoutSetShrinkCenterLastMethodInfo
    ResolveCenterLayoutMethod "setStartWidget" o = CenterLayoutSetStartWidgetMethodInfo
    ResolveCenterLayoutMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCenterLayoutMethod t CenterLayout, O.OverloadedMethod info CenterLayout p) => OL.IsLabel t (CenterLayout -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCenterLayoutMethod t CenterLayout, O.OverloadedMethod info CenterLayout p, R.HasField t CenterLayout p) => R.HasField t CenterLayout p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCenterLayoutMethod t CenterLayout, O.OverloadedMethodInfo info CenterLayout) => OL.IsLabel t (O.MethodProxy info CenterLayout) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "shrink-center-last"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@shrink-center-last@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' centerLayout #shrinkCenterLast
-- @
getCenterLayoutShrinkCenterLast :: (MonadIO m, IsCenterLayout o) => o -> m Bool
getCenterLayoutShrinkCenterLast obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "shrink-center-last"

-- | Set the value of the “@shrink-center-last@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' centerLayout [ #shrinkCenterLast 'Data.GI.Base.Attributes.:=' value ]
-- @
setCenterLayoutShrinkCenterLast :: (MonadIO m, IsCenterLayout o) => o -> Bool -> m ()
setCenterLayoutShrinkCenterLast obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "shrink-center-last" val

-- | Construct a t'GValueConstruct' with valid value for the “@shrink-center-last@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCenterLayoutShrinkCenterLast :: (IsCenterLayout o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructCenterLayoutShrinkCenterLast val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "shrink-center-last" val

#if defined(ENABLE_OVERLOADING)
data CenterLayoutShrinkCenterLastPropertyInfo
instance AttrInfo CenterLayoutShrinkCenterLastPropertyInfo where
    type AttrAllowedOps CenterLayoutShrinkCenterLastPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint CenterLayoutShrinkCenterLastPropertyInfo = IsCenterLayout
    type AttrSetTypeConstraint CenterLayoutShrinkCenterLastPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint CenterLayoutShrinkCenterLastPropertyInfo = (~) Bool
    type AttrTransferType CenterLayoutShrinkCenterLastPropertyInfo = Bool
    type AttrGetType CenterLayoutShrinkCenterLastPropertyInfo = Bool
    type AttrLabel CenterLayoutShrinkCenterLastPropertyInfo = "shrink-center-last"
    type AttrOrigin CenterLayoutShrinkCenterLastPropertyInfo = CenterLayout
    attrGet = getCenterLayoutShrinkCenterLast
    attrSet = setCenterLayoutShrinkCenterLast
    attrPut = setCenterLayoutShrinkCenterLast
    attrTransfer _ v = do
        return v
    attrConstruct = constructCenterLayoutShrinkCenterLast
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterLayout.shrinkCenterLast"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CenterLayout.html#g:attr:shrinkCenterLast"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList CenterLayout
type instance O.AttributeList CenterLayout = CenterLayoutAttributeList
type CenterLayoutAttributeList = ('[ '("shrinkCenterLast", CenterLayoutShrinkCenterLastPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
centerLayoutShrinkCenterLast :: AttrLabelProxy "shrinkCenterLast"
centerLayoutShrinkCenterLast = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList CenterLayout = CenterLayoutSignalList
type CenterLayoutSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method CenterLayout::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "CenterLayout" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_layout_new" gtk_center_layout_new :: 
    IO (Ptr CenterLayout)

-- | Creates a new @GtkCenterLayout@.
centerLayoutNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m CenterLayout
    -- ^ __Returns:__ the newly created @GtkCenterLayout@
centerLayoutNew  = liftIO $ do
    result <- gtk_center_layout_new
    checkUnexpectedReturnNULL "centerLayoutNew" result
    result' <- (wrapObject CenterLayout) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method CenterLayout::get_baseline_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCenterLayout`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "BaselinePosition" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_layout_get_baseline_position" gtk_center_layout_get_baseline_position :: 
    Ptr CenterLayout ->                     -- self : TInterface (Name {namespace = "Gtk", name = "CenterLayout"})
    IO CUInt

-- | Returns the baseline position of the layout.
centerLayoutGetBaselinePosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterLayout a) =>
    a
    -- ^ /@self@/: a @GtkCenterLayout@
    -> m Gtk.Enums.BaselinePosition
    -- ^ __Returns:__ The current baseline position of /@self@/.
centerLayoutGetBaselinePosition self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_center_layout_get_baseline_position self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data CenterLayoutGetBaselinePositionMethodInfo
instance (signature ~ (m Gtk.Enums.BaselinePosition), MonadIO m, IsCenterLayout a) => O.OverloadedMethod CenterLayoutGetBaselinePositionMethodInfo a signature where
    overloadedMethod = centerLayoutGetBaselinePosition

instance O.OverloadedMethodInfo CenterLayoutGetBaselinePositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterLayout.centerLayoutGetBaselinePosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CenterLayout.html#v:centerLayoutGetBaselinePosition"
        })


#endif

-- method CenterLayout::get_center_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCenterLayout`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_layout_get_center_widget" gtk_center_layout_get_center_widget :: 
    Ptr CenterLayout ->                     -- self : TInterface (Name {namespace = "Gtk", name = "CenterLayout"})
    IO (Ptr Gtk.Widget.Widget)

-- | Returns the center widget of the layout.
centerLayoutGetCenterWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterLayout a) =>
    a
    -- ^ /@self@/: a @GtkCenterLayout@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the current center widget of /@self@/
centerLayoutGetCenterWidget self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_center_layout_get_center_widget self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data CenterLayoutGetCenterWidgetMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsCenterLayout a) => O.OverloadedMethod CenterLayoutGetCenterWidgetMethodInfo a signature where
    overloadedMethod = centerLayoutGetCenterWidget

instance O.OverloadedMethodInfo CenterLayoutGetCenterWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterLayout.centerLayoutGetCenterWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CenterLayout.html#v:centerLayoutGetCenterWidget"
        })


#endif

-- method CenterLayout::get_end_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCenterLayout`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_layout_get_end_widget" gtk_center_layout_get_end_widget :: 
    Ptr CenterLayout ->                     -- self : TInterface (Name {namespace = "Gtk", name = "CenterLayout"})
    IO (Ptr Gtk.Widget.Widget)

-- | Returns the end widget of the layout.
centerLayoutGetEndWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterLayout a) =>
    a
    -- ^ /@self@/: a @GtkCenterLayout@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the current end widget of /@self@/
centerLayoutGetEndWidget self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_center_layout_get_end_widget self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data CenterLayoutGetEndWidgetMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsCenterLayout a) => O.OverloadedMethod CenterLayoutGetEndWidgetMethodInfo a signature where
    overloadedMethod = centerLayoutGetEndWidget

instance O.OverloadedMethodInfo CenterLayoutGetEndWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterLayout.centerLayoutGetEndWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CenterLayout.html#v:centerLayoutGetEndWidget"
        })


#endif

-- method CenterLayout::get_orientation
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCenterLayout`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Orientation" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_layout_get_orientation" gtk_center_layout_get_orientation :: 
    Ptr CenterLayout ->                     -- self : TInterface (Name {namespace = "Gtk", name = "CenterLayout"})
    IO CUInt

-- | Gets the current orienration of the layout manager.
centerLayoutGetOrientation ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterLayout a) =>
    a
    -- ^ /@self@/: a @GtkCenterLayout@
    -> m Gtk.Enums.Orientation
    -- ^ __Returns:__ The current orientation of /@self@/
centerLayoutGetOrientation self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_center_layout_get_orientation self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data CenterLayoutGetOrientationMethodInfo
instance (signature ~ (m Gtk.Enums.Orientation), MonadIO m, IsCenterLayout a) => O.OverloadedMethod CenterLayoutGetOrientationMethodInfo a signature where
    overloadedMethod = centerLayoutGetOrientation

instance O.OverloadedMethodInfo CenterLayoutGetOrientationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterLayout.centerLayoutGetOrientation",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CenterLayout.html#v:centerLayoutGetOrientation"
        })


#endif

-- method CenterLayout::get_shrink_center_last
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCenterLayout`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_layout_get_shrink_center_last" gtk_center_layout_get_shrink_center_last :: 
    Ptr CenterLayout ->                     -- self : TInterface (Name {namespace = "Gtk", name = "CenterLayout"})
    IO CInt

-- | Gets whether /@self@/ shrinks the center widget after other children.
-- 
-- /Since: 4.12/
centerLayoutGetShrinkCenterLast ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterLayout a) =>
    a
    -- ^ /@self@/: a @GtkCenterLayout@
    -> m Bool
    -- ^ __Returns:__ whether to shrink the center widget after others
centerLayoutGetShrinkCenterLast self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_center_layout_get_shrink_center_last self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data CenterLayoutGetShrinkCenterLastMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsCenterLayout a) => O.OverloadedMethod CenterLayoutGetShrinkCenterLastMethodInfo a signature where
    overloadedMethod = centerLayoutGetShrinkCenterLast

instance O.OverloadedMethodInfo CenterLayoutGetShrinkCenterLastMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterLayout.centerLayoutGetShrinkCenterLast",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CenterLayout.html#v:centerLayoutGetShrinkCenterLast"
        })


#endif

-- method CenterLayout::get_start_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCenterLayout`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_layout_get_start_widget" gtk_center_layout_get_start_widget :: 
    Ptr CenterLayout ->                     -- self : TInterface (Name {namespace = "Gtk", name = "CenterLayout"})
    IO (Ptr Gtk.Widget.Widget)

-- | Returns the start widget of the layout.
centerLayoutGetStartWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterLayout a) =>
    a
    -- ^ /@self@/: a @GtkCenterLayout@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ The current start widget of /@self@/
centerLayoutGetStartWidget self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_center_layout_get_start_widget self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data CenterLayoutGetStartWidgetMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsCenterLayout a) => O.OverloadedMethod CenterLayoutGetStartWidgetMethodInfo a signature where
    overloadedMethod = centerLayoutGetStartWidget

instance O.OverloadedMethodInfo CenterLayoutGetStartWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterLayout.centerLayoutGetStartWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CenterLayout.html#v:centerLayoutGetStartWidget"
        })


#endif

-- method CenterLayout::set_baseline_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCenterLayout`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "baseline_position"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BaselinePosition" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new baseline position"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_layout_set_baseline_position" gtk_center_layout_set_baseline_position :: 
    Ptr CenterLayout ->                     -- self : TInterface (Name {namespace = "Gtk", name = "CenterLayout"})
    CUInt ->                                -- baseline_position : TInterface (Name {namespace = "Gtk", name = "BaselinePosition"})
    IO ()

-- | Sets the new baseline position of /@self@/
centerLayoutSetBaselinePosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterLayout a) =>
    a
    -- ^ /@self@/: a @GtkCenterLayout@
    -> Gtk.Enums.BaselinePosition
    -- ^ /@baselinePosition@/: the new baseline position
    -> m ()
centerLayoutSetBaselinePosition self baselinePosition = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let baselinePosition' = (fromIntegral . fromEnum) baselinePosition
    gtk_center_layout_set_baseline_position self' baselinePosition'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data CenterLayoutSetBaselinePositionMethodInfo
instance (signature ~ (Gtk.Enums.BaselinePosition -> m ()), MonadIO m, IsCenterLayout a) => O.OverloadedMethod CenterLayoutSetBaselinePositionMethodInfo a signature where
    overloadedMethod = centerLayoutSetBaselinePosition

instance O.OverloadedMethodInfo CenterLayoutSetBaselinePositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterLayout.centerLayoutSetBaselinePosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CenterLayout.html#v:centerLayoutSetBaselinePosition"
        })


#endif

-- method CenterLayout::set_center_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCenterLayout`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new center widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_layout_set_center_widget" gtk_center_layout_set_center_widget :: 
    Ptr CenterLayout ->                     -- self : TInterface (Name {namespace = "Gtk", name = "CenterLayout"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the new center widget of /@self@/.
-- 
-- To remove the existing center widget, pass 'P.Nothing'.
centerLayoutSetCenterWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterLayout a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@self@/: a @GtkCenterLayout@
    -> Maybe (b)
    -- ^ /@widget@/: the new center widget
    -> m ()
centerLayoutSetCenterWidget self widget = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeWidget <- case widget of
        Nothing -> return FP.nullPtr
        Just jWidget -> do
            jWidget' <- unsafeManagedPtrCastPtr jWidget
            return jWidget'
    gtk_center_layout_set_center_widget self' maybeWidget
    touchManagedPtr self
    whenJust widget touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data CenterLayoutSetCenterWidgetMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsCenterLayout a, Gtk.Widget.IsWidget b) => O.OverloadedMethod CenterLayoutSetCenterWidgetMethodInfo a signature where
    overloadedMethod = centerLayoutSetCenterWidget

instance O.OverloadedMethodInfo CenterLayoutSetCenterWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterLayout.centerLayoutSetCenterWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CenterLayout.html#v:centerLayoutSetCenterWidget"
        })


#endif

-- method CenterLayout::set_end_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCenterLayout`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new end widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_layout_set_end_widget" gtk_center_layout_set_end_widget :: 
    Ptr CenterLayout ->                     -- self : TInterface (Name {namespace = "Gtk", name = "CenterLayout"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the new end widget of /@self@/.
-- 
-- To remove the existing center widget, pass 'P.Nothing'.
centerLayoutSetEndWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterLayout a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@self@/: a @GtkCenterLayout@
    -> Maybe (b)
    -- ^ /@widget@/: the new end widget
    -> m ()
centerLayoutSetEndWidget self widget = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeWidget <- case widget of
        Nothing -> return FP.nullPtr
        Just jWidget -> do
            jWidget' <- unsafeManagedPtrCastPtr jWidget
            return jWidget'
    gtk_center_layout_set_end_widget self' maybeWidget
    touchManagedPtr self
    whenJust widget touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data CenterLayoutSetEndWidgetMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsCenterLayout a, Gtk.Widget.IsWidget b) => O.OverloadedMethod CenterLayoutSetEndWidgetMethodInfo a signature where
    overloadedMethod = centerLayoutSetEndWidget

instance O.OverloadedMethodInfo CenterLayoutSetEndWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterLayout.centerLayoutSetEndWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CenterLayout.html#v:centerLayoutSetEndWidget"
        })


#endif

-- method CenterLayout::set_orientation
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCenterLayout`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "orientation"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Orientation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new orientation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_layout_set_orientation" gtk_center_layout_set_orientation :: 
    Ptr CenterLayout ->                     -- self : TInterface (Name {namespace = "Gtk", name = "CenterLayout"})
    CUInt ->                                -- orientation : TInterface (Name {namespace = "Gtk", name = "Orientation"})
    IO ()

-- | Sets the orientation of /@self@/.
centerLayoutSetOrientation ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterLayout a) =>
    a
    -- ^ /@self@/: a @GtkCenterLayout@
    -> Gtk.Enums.Orientation
    -- ^ /@orientation@/: the new orientation
    -> m ()
centerLayoutSetOrientation self orientation = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let orientation' = (fromIntegral . fromEnum) orientation
    gtk_center_layout_set_orientation self' orientation'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data CenterLayoutSetOrientationMethodInfo
instance (signature ~ (Gtk.Enums.Orientation -> m ()), MonadIO m, IsCenterLayout a) => O.OverloadedMethod CenterLayoutSetOrientationMethodInfo a signature where
    overloadedMethod = centerLayoutSetOrientation

instance O.OverloadedMethodInfo CenterLayoutSetOrientationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterLayout.centerLayoutSetOrientation",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CenterLayout.html#v:centerLayoutSetOrientation"
        })


#endif

-- method CenterLayout::set_shrink_center_last
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCenterLayout`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "shrink_center_last"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether to shrink the center widget after others"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_layout_set_shrink_center_last" gtk_center_layout_set_shrink_center_last :: 
    Ptr CenterLayout ->                     -- self : TInterface (Name {namespace = "Gtk", name = "CenterLayout"})
    CInt ->                                 -- shrink_center_last : TBasicType TBoolean
    IO ()

-- | Sets whether to shrink the center widget after other children.
-- 
-- By default, when there\'s no space to give all three children their
-- natural widths, the start and end widgets start shrinking and the
-- center child keeps natural width until they reach minimum width.
-- 
-- If set to @FALSE@, start and end widgets keep natural width and the
-- center widget starts shrinking instead.
-- 
-- /Since: 4.12/
centerLayoutSetShrinkCenterLast ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterLayout a) =>
    a
    -- ^ /@self@/: a @GtkCenterLayout@
    -> Bool
    -- ^ /@shrinkCenterLast@/: whether to shrink the center widget after others
    -> m ()
centerLayoutSetShrinkCenterLast self shrinkCenterLast = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let shrinkCenterLast' = (P.fromIntegral . P.fromEnum) shrinkCenterLast
    gtk_center_layout_set_shrink_center_last self' shrinkCenterLast'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data CenterLayoutSetShrinkCenterLastMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsCenterLayout a) => O.OverloadedMethod CenterLayoutSetShrinkCenterLastMethodInfo a signature where
    overloadedMethod = centerLayoutSetShrinkCenterLast

instance O.OverloadedMethodInfo CenterLayoutSetShrinkCenterLastMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterLayout.centerLayoutSetShrinkCenterLast",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CenterLayout.html#v:centerLayoutSetShrinkCenterLast"
        })


#endif

-- method CenterLayout::set_start_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CenterLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCenterLayout`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new start widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_center_layout_set_start_widget" gtk_center_layout_set_start_widget :: 
    Ptr CenterLayout ->                     -- self : TInterface (Name {namespace = "Gtk", name = "CenterLayout"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the new start widget of /@self@/.
-- 
-- To remove the existing start widget, pass 'P.Nothing'.
centerLayoutSetStartWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsCenterLayout a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@self@/: a @GtkCenterLayout@
    -> Maybe (b)
    -- ^ /@widget@/: the new start widget
    -> m ()
centerLayoutSetStartWidget self widget = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeWidget <- case widget of
        Nothing -> return FP.nullPtr
        Just jWidget -> do
            jWidget' <- unsafeManagedPtrCastPtr jWidget
            return jWidget'
    gtk_center_layout_set_start_widget self' maybeWidget
    touchManagedPtr self
    whenJust widget touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data CenterLayoutSetStartWidgetMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsCenterLayout a, Gtk.Widget.IsWidget b) => O.OverloadedMethod CenterLayoutSetStartWidgetMethodInfo a signature where
    overloadedMethod = centerLayoutSetStartWidget

instance O.OverloadedMethodInfo CenterLayoutSetStartWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CenterLayout.centerLayoutSetStartWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CenterLayout.html#v:centerLayoutSetStartWidget"
        })


#endif


