{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @PangoCoverage@ structure is a map from Unicode characters
-- to t'GI.Pango.Enums.CoverageLevel' values.
-- 
-- It is often necessary in Pango to determine if a particular
-- font can represent a particular character, and also how well
-- it can represent that character. The @PangoCoverage@ is a data
-- structure that is used to represent that information. It is an
-- opaque structure with no public fields.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Objects.Coverage
    ( 

-- * Exported types
    Coverage(..)                            ,
    IsCoverage                              ,
    toCoverage                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [copy]("GI.Pango.Objects.Coverage#g:method:copy"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [get]("GI.Pango.Objects.Coverage#g:method:get"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [max]("GI.Pango.Objects.Coverage#g:method:max"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.Pango.Objects.Coverage#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [set]("GI.Pango.Objects.Coverage#g:method:set"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toBytes]("GI.Pango.Objects.Coverage#g:method:toBytes"), [unref]("GI.Pango.Objects.Coverage#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveCoverageMethod                   ,
#endif

-- ** copy #method:copy#

#if defined(ENABLE_OVERLOADING)
    CoverageCopyMethodInfo                  ,
#endif
    coverageCopy                            ,


-- ** fromBytes #method:fromBytes#

    coverageFromBytes                       ,


-- ** get #method:get#

#if defined(ENABLE_OVERLOADING)
    CoverageGetMethodInfo                   ,
#endif
    coverageGet                             ,


-- ** max #method:max#

#if defined(ENABLE_OVERLOADING)
    CoverageMaxMethodInfo                   ,
#endif
    coverageMax                             ,


-- ** new #method:new#

    coverageNew                             ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    CoverageRefMethodInfo                   ,
#endif
    coverageRef                             ,


-- ** set #method:set#

#if defined(ENABLE_OVERLOADING)
    CoverageSetMethodInfo                   ,
#endif
    coverageSet                             ,


-- ** toBytes #method:toBytes#

#if defined(ENABLE_OVERLOADING)
    CoverageToBytesMethodInfo               ,
#endif
    coverageToBytes                         ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    CoverageUnrefMethodInfo                 ,
#endif
    coverageUnref                           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums

#endif

-- | Memory-managed wrapper type.
newtype Coverage = Coverage (SP.ManagedPtr Coverage)
    deriving (Eq)

instance SP.ManagedPtrNewtype Coverage where
    toManagedPtr (Coverage p) = p

foreign import ccall "pango_coverage_get_type"
    c_pango_coverage_get_type :: IO B.Types.GType

instance B.Types.TypedObject Coverage where
    glibType = c_pango_coverage_get_type

instance B.Types.GObject Coverage

-- | Type class for types which can be safely cast to t'Coverage', for instance with `toCoverage`.
class (SP.GObject o, O.IsDescendantOf Coverage o) => IsCoverage o
instance (SP.GObject o, O.IsDescendantOf Coverage o) => IsCoverage o

instance O.HasParentTypes Coverage
type instance O.ParentTypes Coverage = '[GObject.Object.Object]

-- | Cast to t'Coverage', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toCoverage :: (MIO.MonadIO m, IsCoverage o) => o -> m Coverage
toCoverage = MIO.liftIO . B.ManagedPtr.unsafeCastTo Coverage

-- | Convert t'Coverage' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Coverage) where
    gvalueGType_ = c_pango_coverage_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Coverage)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Coverage)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Coverage ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveCoverageMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCoverageMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveCoverageMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveCoverageMethod "copy" o = CoverageCopyMethodInfo
    ResolveCoverageMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveCoverageMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveCoverageMethod "get" o = CoverageGetMethodInfo
    ResolveCoverageMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveCoverageMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveCoverageMethod "max" o = CoverageMaxMethodInfo
    ResolveCoverageMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveCoverageMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveCoverageMethod "ref" o = CoverageRefMethodInfo
    ResolveCoverageMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveCoverageMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveCoverageMethod "set" o = CoverageSetMethodInfo
    ResolveCoverageMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveCoverageMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveCoverageMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveCoverageMethod "toBytes" o = CoverageToBytesMethodInfo
    ResolveCoverageMethod "unref" o = CoverageUnrefMethodInfo
    ResolveCoverageMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveCoverageMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveCoverageMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveCoverageMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveCoverageMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveCoverageMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveCoverageMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveCoverageMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCoverageMethod t Coverage, O.OverloadedMethod info Coverage p) => OL.IsLabel t (Coverage -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCoverageMethod t Coverage, O.OverloadedMethod info Coverage p, R.HasField t Coverage p) => R.HasField t Coverage p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCoverageMethod t Coverage, O.OverloadedMethodInfo info Coverage) => OL.IsLabel t (O.MethodProxy info Coverage) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Coverage
type instance O.AttributeList Coverage = CoverageAttributeList
type CoverageAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Coverage = CoverageSignalList
type CoverageSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Coverage::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Coverage" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_coverage_new" pango_coverage_new :: 
    IO (Ptr Coverage)

-- | Create a new @PangoCoverage@
coverageNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Coverage
    -- ^ __Returns:__ the newly allocated @PangoCoverage@, initialized
    --   to 'GI.Pango.Enums.CoverageLevelNone' with a reference count of one, which
    --   should be freed with 'GI.Pango.Objects.Coverage.coverageUnref'.
coverageNew  = liftIO $ do
    result <- pango_coverage_new
    checkUnexpectedReturnNULL "coverageNew" result
    result' <- (wrapObject Coverage) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Coverage::copy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "coverage"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Coverage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoCoverage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Coverage" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_coverage_copy" pango_coverage_copy :: 
    Ptr Coverage ->                         -- coverage : TInterface (Name {namespace = "Pango", name = "Coverage"})
    IO (Ptr Coverage)

-- | Copy an existing @PangoCoverage@.
coverageCopy ::
    (B.CallStack.HasCallStack, MonadIO m, IsCoverage a) =>
    a
    -- ^ /@coverage@/: a @PangoCoverage@
    -> m Coverage
    -- ^ __Returns:__ the newly allocated @PangoCoverage@,
    --   with a reference count of one, which should be freed with
    --   'GI.Pango.Objects.Coverage.coverageUnref'.
coverageCopy coverage = liftIO $ do
    coverage' <- unsafeManagedPtrCastPtr coverage
    result <- pango_coverage_copy coverage'
    checkUnexpectedReturnNULL "coverageCopy" result
    result' <- (wrapObject Coverage) result
    touchManagedPtr coverage
    return result'

#if defined(ENABLE_OVERLOADING)
data CoverageCopyMethodInfo
instance (signature ~ (m Coverage), MonadIO m, IsCoverage a) => O.OverloadedMethod CoverageCopyMethodInfo a signature where
    overloadedMethod = coverageCopy

instance O.OverloadedMethodInfo CoverageCopyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Coverage.coverageCopy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Coverage.html#v:coverageCopy"
        })


#endif

-- method Coverage::get
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "coverage"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Coverage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoCoverage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the index to check" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Pango" , name = "CoverageLevel" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_coverage_get" pango_coverage_get :: 
    Ptr Coverage ->                         -- coverage : TInterface (Name {namespace = "Pango", name = "Coverage"})
    Int32 ->                                -- index_ : TBasicType TInt
    IO CUInt

-- | Determine whether a particular index is covered by /@coverage@/.
coverageGet ::
    (B.CallStack.HasCallStack, MonadIO m, IsCoverage a) =>
    a
    -- ^ /@coverage@/: a @PangoCoverage@
    -> Int32
    -- ^ /@index_@/: the index to check
    -> m Pango.Enums.CoverageLevel
    -- ^ __Returns:__ the coverage level of /@coverage@/ for character /@index_@/.
coverageGet coverage index_ = liftIO $ do
    coverage' <- unsafeManagedPtrCastPtr coverage
    result <- pango_coverage_get coverage' index_
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr coverage
    return result'

#if defined(ENABLE_OVERLOADING)
data CoverageGetMethodInfo
instance (signature ~ (Int32 -> m Pango.Enums.CoverageLevel), MonadIO m, IsCoverage a) => O.OverloadedMethod CoverageGetMethodInfo a signature where
    overloadedMethod = coverageGet

instance O.OverloadedMethodInfo CoverageGetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Coverage.coverageGet",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Coverage.html#v:coverageGet"
        })


#endif

-- method Coverage::max
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "coverage"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Coverage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoCoverage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "other"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Coverage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another `PangoCoverage`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_coverage_max" pango_coverage_max :: 
    Ptr Coverage ->                         -- coverage : TInterface (Name {namespace = "Pango", name = "Coverage"})
    Ptr Coverage ->                         -- other : TInterface (Name {namespace = "Pango", name = "Coverage"})
    IO ()

{-# DEPRECATED coverageMax ["(Since version 1.44)","This function does nothing"] #-}
-- | Set the coverage for each index in /@coverage@/ to be the max (better)
-- value of the current coverage for the index and the coverage for
-- the corresponding index in /@other@/.
coverageMax ::
    (B.CallStack.HasCallStack, MonadIO m, IsCoverage a, IsCoverage b) =>
    a
    -- ^ /@coverage@/: a @PangoCoverage@
    -> b
    -- ^ /@other@/: another @PangoCoverage@
    -> m ()
coverageMax coverage other = liftIO $ do
    coverage' <- unsafeManagedPtrCastPtr coverage
    other' <- unsafeManagedPtrCastPtr other
    pango_coverage_max coverage' other'
    touchManagedPtr coverage
    touchManagedPtr other
    return ()

#if defined(ENABLE_OVERLOADING)
data CoverageMaxMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsCoverage a, IsCoverage b) => O.OverloadedMethod CoverageMaxMethodInfo a signature where
    overloadedMethod = coverageMax

instance O.OverloadedMethodInfo CoverageMaxMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Coverage.coverageMax",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Coverage.html#v:coverageMax"
        })


#endif

-- method Coverage::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "coverage"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Coverage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoCoverage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Coverage" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_coverage_ref" pango_coverage_ref :: 
    Ptr Coverage ->                         -- coverage : TInterface (Name {namespace = "Pango", name = "Coverage"})
    IO (Ptr Coverage)

{-# DEPRECATED coverageRef ["(Since version 1.52)","Use g_object_ref instead"] #-}
-- | Increase the reference count on the @PangoCoverage@ by one.
coverageRef ::
    (B.CallStack.HasCallStack, MonadIO m, IsCoverage a) =>
    a
    -- ^ /@coverage@/: a @PangoCoverage@
    -> m Coverage
    -- ^ __Returns:__ /@coverage@/
coverageRef coverage = liftIO $ do
    coverage' <- unsafeManagedPtrCastPtr coverage
    result <- pango_coverage_ref coverage'
    checkUnexpectedReturnNULL "coverageRef" result
    result' <- (wrapObject Coverage) result
    touchManagedPtr coverage
    return result'

#if defined(ENABLE_OVERLOADING)
data CoverageRefMethodInfo
instance (signature ~ (m Coverage), MonadIO m, IsCoverage a) => O.OverloadedMethod CoverageRefMethodInfo a signature where
    overloadedMethod = coverageRef

instance O.OverloadedMethodInfo CoverageRefMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Coverage.coverageRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Coverage.html#v:coverageRef"
        })


#endif

-- method Coverage::set
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "coverage"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Coverage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoCoverage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the index to modify"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "level"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "CoverageLevel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new level for @index_"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_coverage_set" pango_coverage_set :: 
    Ptr Coverage ->                         -- coverage : TInterface (Name {namespace = "Pango", name = "Coverage"})
    Int32 ->                                -- index_ : TBasicType TInt
    CUInt ->                                -- level : TInterface (Name {namespace = "Pango", name = "CoverageLevel"})
    IO ()

-- | Modify a particular index within /@coverage@/
coverageSet ::
    (B.CallStack.HasCallStack, MonadIO m, IsCoverage a) =>
    a
    -- ^ /@coverage@/: a @PangoCoverage@
    -> Int32
    -- ^ /@index_@/: the index to modify
    -> Pango.Enums.CoverageLevel
    -- ^ /@level@/: the new level for /@index_@/
    -> m ()
coverageSet coverage index_ level = liftIO $ do
    coverage' <- unsafeManagedPtrCastPtr coverage
    let level' = (fromIntegral . fromEnum) level
    pango_coverage_set coverage' index_ level'
    touchManagedPtr coverage
    return ()

#if defined(ENABLE_OVERLOADING)
data CoverageSetMethodInfo
instance (signature ~ (Int32 -> Pango.Enums.CoverageLevel -> m ()), MonadIO m, IsCoverage a) => O.OverloadedMethod CoverageSetMethodInfo a signature where
    overloadedMethod = coverageSet

instance O.OverloadedMethodInfo CoverageSetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Coverage.coverageSet",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Coverage.html#v:coverageSet"
        })


#endif

-- method Coverage::to_bytes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "coverage"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Coverage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoCoverage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bytes"
--           , argType = TCArray False (-1) 2 (TBasicType TUInt8)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "\n  location to store result (must be freed with g_free())"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "n_bytes"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store size of result"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_bytes"
--              , argType = TBasicType TInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "location to store size of result"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_coverage_to_bytes" pango_coverage_to_bytes :: 
    Ptr Coverage ->                         -- coverage : TInterface (Name {namespace = "Pango", name = "Coverage"})
    Ptr (Ptr Word8) ->                      -- bytes : TCArray False (-1) 2 (TBasicType TUInt8)
    Ptr Int32 ->                            -- n_bytes : TBasicType TInt
    IO ()

{-# DEPRECATED coverageToBytes ["(Since version 1.44)","This returns 'P.Nothing'"] #-}
-- | Convert a @PangoCoverage@ structure into a flat binary format.
coverageToBytes ::
    (B.CallStack.HasCallStack, MonadIO m, IsCoverage a) =>
    a
    -- ^ /@coverage@/: a @PangoCoverage@
    -> m (ByteString)
coverageToBytes coverage = liftIO $ do
    coverage' <- unsafeManagedPtrCastPtr coverage
    bytes <- callocMem :: IO (Ptr (Ptr Word8))
    nBytes <- allocMem :: IO (Ptr Int32)
    pango_coverage_to_bytes coverage' bytes nBytes
    nBytes' <- peek nBytes
    bytes' <- peek bytes
    bytes'' <- (unpackByteStringWithLength nBytes') bytes'
    freeMem bytes'
    touchManagedPtr coverage
    freeMem bytes
    freeMem nBytes
    return bytes''

#if defined(ENABLE_OVERLOADING)
data CoverageToBytesMethodInfo
instance (signature ~ (m (ByteString)), MonadIO m, IsCoverage a) => O.OverloadedMethod CoverageToBytesMethodInfo a signature where
    overloadedMethod = coverageToBytes

instance O.OverloadedMethodInfo CoverageToBytesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Coverage.coverageToBytes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Coverage.html#v:coverageToBytes"
        })


#endif

-- method Coverage::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "coverage"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Coverage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoCoverage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_coverage_unref" pango_coverage_unref :: 
    Ptr Coverage ->                         -- coverage : TInterface (Name {namespace = "Pango", name = "Coverage"})
    IO ()

{-# DEPRECATED coverageUnref ["(Since version 1.52)","Use g_object_unref instead"] #-}
-- | Decrease the reference count on the @PangoCoverage@ by one.
-- 
-- If the result is zero, free the coverage and all associated memory.
coverageUnref ::
    (B.CallStack.HasCallStack, MonadIO m, IsCoverage a) =>
    a
    -- ^ /@coverage@/: a @PangoCoverage@
    -> m ()
coverageUnref coverage = liftIO $ do
    coverage' <- B.ManagedPtr.disownObject coverage
    pango_coverage_unref coverage'
    touchManagedPtr coverage
    return ()

#if defined(ENABLE_OVERLOADING)
data CoverageUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m, IsCoverage a) => O.OverloadedMethod CoverageUnrefMethodInfo a signature where
    overloadedMethod = coverageUnref

instance O.OverloadedMethodInfo CoverageUnrefMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Objects.Coverage.coverageUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Objects-Coverage.html#v:coverageUnref"
        })


#endif

-- method Coverage::from_bytes
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "bytes"
--           , argType = TCArray False (-1) 1 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "binary data\n  representing a `PangoCoverage`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_bytes"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the size of @bytes in bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_bytes"
--              , argType = TBasicType TInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the size of @bytes in bytes"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Coverage" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_coverage_from_bytes" pango_coverage_from_bytes :: 
    Ptr Word8 ->                            -- bytes : TCArray False (-1) 1 (TBasicType TUInt8)
    Int32 ->                                -- n_bytes : TBasicType TInt
    IO (Ptr Coverage)

{-# DEPRECATED coverageFromBytes ["(Since version 1.44)","This returns 'P.Nothing'"] #-}
-- | Convert data generated from 'GI.Pango.Objects.Coverage.coverageToBytes'
-- back to a @PangoCoverage@.
coverageFromBytes ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ByteString
    -- ^ /@bytes@/: binary data
    --   representing a @PangoCoverage@
    -> m (Maybe Coverage)
    -- ^ __Returns:__ a newly allocated @PangoCoverage@
coverageFromBytes bytes = liftIO $ do
    let nBytes = fromIntegral $ B.length bytes
    bytes' <- packByteString bytes
    result <- pango_coverage_from_bytes bytes' nBytes
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Coverage) result'
        return result''
    freeMem bytes'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif


