{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @PangoMatrix@ specifies a transformation between user-space
-- and device coordinates.
-- 
-- The transformation is given by
-- 
-- 
-- 	
-- >x_device = x_user * matrix->xx + y_user * matrix->xy + matrix->x0;
-- >y_device = x_user * matrix->yx + y_user * matrix->yy + matrix->y0;
-- 
-- 
-- /Since: 1.6/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.Matrix
    ( 

-- * Exported types
    Matrix(..)                              ,
    newZeroMatrix                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [concat]("GI.Pango.Structs.Matrix#g:method:concat"), [copy]("GI.Pango.Structs.Matrix#g:method:copy"), [free]("GI.Pango.Structs.Matrix#g:method:free"), [rotate]("GI.Pango.Structs.Matrix#g:method:rotate"), [scale]("GI.Pango.Structs.Matrix#g:method:scale"), [transformDistance]("GI.Pango.Structs.Matrix#g:method:transformDistance"), [transformPixelRectangle]("GI.Pango.Structs.Matrix#g:method:transformPixelRectangle"), [transformPoint]("GI.Pango.Structs.Matrix#g:method:transformPoint"), [translate]("GI.Pango.Structs.Matrix#g:method:translate").
-- 
-- ==== Getters
-- [getFontScaleFactor]("GI.Pango.Structs.Matrix#g:method:getFontScaleFactor"), [getFontScaleFactors]("GI.Pango.Structs.Matrix#g:method:getFontScaleFactors"), [getSlantRatio]("GI.Pango.Structs.Matrix#g:method:getSlantRatio").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveMatrixMethod                     ,
#endif

-- ** concat #method:concat#

#if defined(ENABLE_OVERLOADING)
    MatrixConcatMethodInfo                  ,
#endif
    matrixConcat                            ,


-- ** copy #method:copy#

#if defined(ENABLE_OVERLOADING)
    MatrixCopyMethodInfo                    ,
#endif
    matrixCopy                              ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    MatrixFreeMethodInfo                    ,
#endif
    matrixFree                              ,


-- ** getFontScaleFactor #method:getFontScaleFactor#

#if defined(ENABLE_OVERLOADING)
    MatrixGetFontScaleFactorMethodInfo      ,
#endif
    matrixGetFontScaleFactor                ,


-- ** getFontScaleFactors #method:getFontScaleFactors#

#if defined(ENABLE_OVERLOADING)
    MatrixGetFontScaleFactorsMethodInfo     ,
#endif
    matrixGetFontScaleFactors               ,


-- ** getSlantRatio #method:getSlantRatio#

#if defined(ENABLE_OVERLOADING)
    MatrixGetSlantRatioMethodInfo           ,
#endif
    matrixGetSlantRatio                     ,


-- ** rotate #method:rotate#

#if defined(ENABLE_OVERLOADING)
    MatrixRotateMethodInfo                  ,
#endif
    matrixRotate                            ,


-- ** scale #method:scale#

#if defined(ENABLE_OVERLOADING)
    MatrixScaleMethodInfo                   ,
#endif
    matrixScale                             ,


-- ** transformDistance #method:transformDistance#

#if defined(ENABLE_OVERLOADING)
    MatrixTransformDistanceMethodInfo       ,
#endif
    matrixTransformDistance                 ,


-- ** transformPixelRectangle #method:transformPixelRectangle#

#if defined(ENABLE_OVERLOADING)
    MatrixTransformPixelRectangleMethodInfo ,
#endif
    matrixTransformPixelRectangle           ,


-- ** transformPoint #method:transformPoint#

#if defined(ENABLE_OVERLOADING)
    MatrixTransformPointMethodInfo          ,
#endif
    matrixTransformPoint                    ,


-- ** translate #method:translate#

#if defined(ENABLE_OVERLOADING)
    MatrixTranslateMethodInfo               ,
#endif
    matrixTranslate                         ,




 -- * Properties


-- ** x0 #attr:x0#
-- | x translation

    getMatrixX0                             ,
#if defined(ENABLE_OVERLOADING)
    matrix_x0                               ,
#endif
    setMatrixX0                             ,


-- ** xx #attr:xx#
-- | 1st component of the transformation matrix

    getMatrixXx                             ,
#if defined(ENABLE_OVERLOADING)
    matrix_xx                               ,
#endif
    setMatrixXx                             ,


-- ** xy #attr:xy#
-- | 2nd component of the transformation matrix

    getMatrixXy                             ,
#if defined(ENABLE_OVERLOADING)
    matrix_xy                               ,
#endif
    setMatrixXy                             ,


-- ** y0 #attr:y0#
-- | y translation

    getMatrixY0                             ,
#if defined(ENABLE_OVERLOADING)
    matrix_y0                               ,
#endif
    setMatrixY0                             ,


-- ** yx #attr:yx#
-- | 3rd component of the transformation matrix

    getMatrixYx                             ,
#if defined(ENABLE_OVERLOADING)
    matrix_yx                               ,
#endif
    setMatrixYx                             ,


-- ** yy #attr:yy#
-- | 4th component of the transformation matrix

    getMatrixYy                             ,
#if defined(ENABLE_OVERLOADING)
    matrix_yy                               ,
#endif
    setMatrixYy                             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#endif

-- | Memory-managed wrapper type.
newtype Matrix = Matrix (SP.ManagedPtr Matrix)
    deriving (Eq)

instance SP.ManagedPtrNewtype Matrix where
    toManagedPtr (Matrix p) = p

foreign import ccall "pango_matrix_get_type" c_pango_matrix_get_type :: 
    IO GType

type instance O.ParentTypes Matrix = '[]
instance O.HasParentTypes Matrix

instance B.Types.TypedObject Matrix where
    glibType = c_pango_matrix_get_type

instance B.Types.GBoxed Matrix

-- | Convert t'Matrix' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Matrix) where
    gvalueGType_ = c_pango_matrix_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Matrix)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Matrix)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Matrix ptr
        else return P.Nothing
        
    

-- | Construct a t'Matrix' struct initialized to zero.
newZeroMatrix :: MonadIO m => m Matrix
newZeroMatrix = liftIO $ callocBoxedBytes 48 >>= wrapBoxed Matrix

instance tag ~ 'AttrSet => Constructible Matrix tag where
    new _ attrs = do
        o <- newZeroMatrix
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@xx@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' matrix #xx
-- @
getMatrixXx :: MonadIO m => Matrix -> m Double
getMatrixXx s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@xx@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' matrix [ #xx 'Data.GI.Base.Attributes.:=' value ]
-- @
setMatrixXx :: MonadIO m => Matrix -> Double -> m ()
setMatrixXx s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 0) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data MatrixXxFieldInfo
instance AttrInfo MatrixXxFieldInfo where
    type AttrBaseTypeConstraint MatrixXxFieldInfo = (~) Matrix
    type AttrAllowedOps MatrixXxFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint MatrixXxFieldInfo = (~) Double
    type AttrTransferTypeConstraint MatrixXxFieldInfo = (~)Double
    type AttrTransferType MatrixXxFieldInfo = Double
    type AttrGetType MatrixXxFieldInfo = Double
    type AttrLabel MatrixXxFieldInfo = "xx"
    type AttrOrigin MatrixXxFieldInfo = Matrix
    attrGet = getMatrixXx
    attrSet = setMatrixXx
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Matrix.xx"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Matrix.html#g:attr:xx"
        })

matrix_xx :: AttrLabelProxy "xx"
matrix_xx = AttrLabelProxy

#endif


-- | Get the value of the “@xy@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' matrix #xy
-- @
getMatrixXy :: MonadIO m => Matrix -> m Double
getMatrixXy s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@xy@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' matrix [ #xy 'Data.GI.Base.Attributes.:=' value ]
-- @
setMatrixXy :: MonadIO m => Matrix -> Double -> m ()
setMatrixXy s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 8) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data MatrixXyFieldInfo
instance AttrInfo MatrixXyFieldInfo where
    type AttrBaseTypeConstraint MatrixXyFieldInfo = (~) Matrix
    type AttrAllowedOps MatrixXyFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint MatrixXyFieldInfo = (~) Double
    type AttrTransferTypeConstraint MatrixXyFieldInfo = (~)Double
    type AttrTransferType MatrixXyFieldInfo = Double
    type AttrGetType MatrixXyFieldInfo = Double
    type AttrLabel MatrixXyFieldInfo = "xy"
    type AttrOrigin MatrixXyFieldInfo = Matrix
    attrGet = getMatrixXy
    attrSet = setMatrixXy
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Matrix.xy"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Matrix.html#g:attr:xy"
        })

matrix_xy :: AttrLabelProxy "xy"
matrix_xy = AttrLabelProxy

#endif


-- | Get the value of the “@yx@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' matrix #yx
-- @
getMatrixYx :: MonadIO m => Matrix -> m Double
getMatrixYx s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@yx@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' matrix [ #yx 'Data.GI.Base.Attributes.:=' value ]
-- @
setMatrixYx :: MonadIO m => Matrix -> Double -> m ()
setMatrixYx s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 16) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data MatrixYxFieldInfo
instance AttrInfo MatrixYxFieldInfo where
    type AttrBaseTypeConstraint MatrixYxFieldInfo = (~) Matrix
    type AttrAllowedOps MatrixYxFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint MatrixYxFieldInfo = (~) Double
    type AttrTransferTypeConstraint MatrixYxFieldInfo = (~)Double
    type AttrTransferType MatrixYxFieldInfo = Double
    type AttrGetType MatrixYxFieldInfo = Double
    type AttrLabel MatrixYxFieldInfo = "yx"
    type AttrOrigin MatrixYxFieldInfo = Matrix
    attrGet = getMatrixYx
    attrSet = setMatrixYx
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Matrix.yx"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Matrix.html#g:attr:yx"
        })

matrix_yx :: AttrLabelProxy "yx"
matrix_yx = AttrLabelProxy

#endif


-- | Get the value of the “@yy@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' matrix #yy
-- @
getMatrixYy :: MonadIO m => Matrix -> m Double
getMatrixYy s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@yy@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' matrix [ #yy 'Data.GI.Base.Attributes.:=' value ]
-- @
setMatrixYy :: MonadIO m => Matrix -> Double -> m ()
setMatrixYy s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 24) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data MatrixYyFieldInfo
instance AttrInfo MatrixYyFieldInfo where
    type AttrBaseTypeConstraint MatrixYyFieldInfo = (~) Matrix
    type AttrAllowedOps MatrixYyFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint MatrixYyFieldInfo = (~) Double
    type AttrTransferTypeConstraint MatrixYyFieldInfo = (~)Double
    type AttrTransferType MatrixYyFieldInfo = Double
    type AttrGetType MatrixYyFieldInfo = Double
    type AttrLabel MatrixYyFieldInfo = "yy"
    type AttrOrigin MatrixYyFieldInfo = Matrix
    attrGet = getMatrixYy
    attrSet = setMatrixYy
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Matrix.yy"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Matrix.html#g:attr:yy"
        })

matrix_yy :: AttrLabelProxy "yy"
matrix_yy = AttrLabelProxy

#endif


-- | Get the value of the “@x0@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' matrix #x0
-- @
getMatrixX0 :: MonadIO m => Matrix -> m Double
getMatrixX0 s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x0@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' matrix [ #x0 'Data.GI.Base.Attributes.:=' value ]
-- @
setMatrixX0 :: MonadIO m => Matrix -> Double -> m ()
setMatrixX0 s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 32) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data MatrixX0FieldInfo
instance AttrInfo MatrixX0FieldInfo where
    type AttrBaseTypeConstraint MatrixX0FieldInfo = (~) Matrix
    type AttrAllowedOps MatrixX0FieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint MatrixX0FieldInfo = (~) Double
    type AttrTransferTypeConstraint MatrixX0FieldInfo = (~)Double
    type AttrTransferType MatrixX0FieldInfo = Double
    type AttrGetType MatrixX0FieldInfo = Double
    type AttrLabel MatrixX0FieldInfo = "x0"
    type AttrOrigin MatrixX0FieldInfo = Matrix
    attrGet = getMatrixX0
    attrSet = setMatrixX0
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Matrix.x0"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Matrix.html#g:attr:x0"
        })

matrix_x0 :: AttrLabelProxy "x0"
matrix_x0 = AttrLabelProxy

#endif


-- | Get the value of the “@y0@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' matrix #y0
-- @
getMatrixY0 :: MonadIO m => Matrix -> m Double
getMatrixY0 s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y0@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' matrix [ #y0 'Data.GI.Base.Attributes.:=' value ]
-- @
setMatrixY0 :: MonadIO m => Matrix -> Double -> m ()
setMatrixY0 s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 40) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data MatrixY0FieldInfo
instance AttrInfo MatrixY0FieldInfo where
    type AttrBaseTypeConstraint MatrixY0FieldInfo = (~) Matrix
    type AttrAllowedOps MatrixY0FieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint MatrixY0FieldInfo = (~) Double
    type AttrTransferTypeConstraint MatrixY0FieldInfo = (~)Double
    type AttrTransferType MatrixY0FieldInfo = Double
    type AttrGetType MatrixY0FieldInfo = Double
    type AttrLabel MatrixY0FieldInfo = "y0"
    type AttrOrigin MatrixY0FieldInfo = Matrix
    attrGet = getMatrixY0
    attrSet = setMatrixY0
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Matrix.y0"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Matrix.html#g:attr:y0"
        })

matrix_y0 :: AttrLabelProxy "y0"
matrix_y0 = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Matrix
type instance O.AttributeList Matrix = MatrixAttributeList
type MatrixAttributeList = ('[ '("xx", MatrixXxFieldInfo), '("xy", MatrixXyFieldInfo), '("yx", MatrixYxFieldInfo), '("yy", MatrixYyFieldInfo), '("x0", MatrixX0FieldInfo), '("y0", MatrixY0FieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method Matrix::concat
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "matrix"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Matrix" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoMatrix`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "new_matrix"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Matrix" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoMatrix`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_matrix_concat" pango_matrix_concat :: 
    Ptr Matrix ->                           -- matrix : TInterface (Name {namespace = "Pango", name = "Matrix"})
    Ptr Matrix ->                           -- new_matrix : TInterface (Name {namespace = "Pango", name = "Matrix"})
    IO ()

-- | Changes the transformation represented by /@matrix@/ to be the
-- transformation given by first applying transformation
-- given by /@newMatrix@/ then applying the original transformation.
-- 
-- /Since: 1.6/
matrixConcat ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Matrix
    -- ^ /@matrix@/: a @PangoMatrix@
    -> Matrix
    -- ^ /@newMatrix@/: a @PangoMatrix@
    -> m ()
matrixConcat matrix newMatrix = liftIO $ do
    matrix' <- unsafeManagedPtrGetPtr matrix
    newMatrix' <- unsafeManagedPtrGetPtr newMatrix
    pango_matrix_concat matrix' newMatrix'
    touchManagedPtr matrix
    touchManagedPtr newMatrix
    return ()

#if defined(ENABLE_OVERLOADING)
data MatrixConcatMethodInfo
instance (signature ~ (Matrix -> m ()), MonadIO m) => O.OverloadedMethod MatrixConcatMethodInfo Matrix signature where
    overloadedMethod = matrixConcat

instance O.OverloadedMethodInfo MatrixConcatMethodInfo Matrix where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Matrix.matrixConcat",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Matrix.html#v:matrixConcat"
        })


#endif

-- method Matrix::copy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "matrix"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Matrix" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoMatrix`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Matrix" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_matrix_copy" pango_matrix_copy :: 
    Ptr Matrix ->                           -- matrix : TInterface (Name {namespace = "Pango", name = "Matrix"})
    IO (Ptr Matrix)

-- | Copies a @PangoMatrix@.
-- 
-- /Since: 1.6/
matrixCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (Matrix)
    -- ^ /@matrix@/: a @PangoMatrix@
    -> m (Maybe Matrix)
    -- ^ __Returns:__ the newly allocated @PangoMatrix@
matrixCopy matrix = liftIO $ do
    maybeMatrix <- case matrix of
        Nothing -> return FP.nullPtr
        Just jMatrix -> do
            jMatrix' <- unsafeManagedPtrGetPtr jMatrix
            return jMatrix'
    result <- pango_matrix_copy maybeMatrix
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed Matrix) result'
        return result''
    whenJust matrix touchManagedPtr
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MatrixCopyMethodInfo
instance (signature ~ (m (Maybe Matrix)), MonadIO m) => O.OverloadedMethod MatrixCopyMethodInfo Matrix signature where
    overloadedMethod i = matrixCopy (Just i)

instance O.OverloadedMethodInfo MatrixCopyMethodInfo Matrix where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Matrix.matrixCopy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Matrix.html#v:matrixCopy"
        })


#endif

-- method Matrix::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "matrix"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Matrix" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoMatrix`, may be %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_matrix_free" pango_matrix_free :: 
    Ptr Matrix ->                           -- matrix : TInterface (Name {namespace = "Pango", name = "Matrix"})
    IO ()

-- | Free a @PangoMatrix@.
-- 
-- /Since: 1.6/
matrixFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (Matrix)
    -- ^ /@matrix@/: a @PangoMatrix@, may be 'P.Nothing'
    -> m ()
matrixFree matrix = liftIO $ do
    maybeMatrix <- case matrix of
        Nothing -> return FP.nullPtr
        Just jMatrix -> do
            jMatrix' <- unsafeManagedPtrGetPtr jMatrix
            return jMatrix'
    pango_matrix_free maybeMatrix
    whenJust matrix touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MatrixFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod MatrixFreeMethodInfo Matrix signature where
    overloadedMethod i = matrixFree (Just i)

instance O.OverloadedMethodInfo MatrixFreeMethodInfo Matrix where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Matrix.matrixFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Matrix.html#v:matrixFree"
        })


#endif

-- method Matrix::get_font_scale_factor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "matrix"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Matrix" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoMatrix`, may be %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "pango_matrix_get_font_scale_factor" pango_matrix_get_font_scale_factor :: 
    Ptr Matrix ->                           -- matrix : TInterface (Name {namespace = "Pango", name = "Matrix"})
    IO CDouble

-- | Returns the scale factor of a matrix on the height of the font.
-- 
-- That is, the scale factor in the direction perpendicular to the
-- vector that the X coordinate is mapped to.  If the scale in the X
-- coordinate is needed as well, use 'GI.Pango.Structs.Matrix.matrixGetFontScaleFactors'.
-- 
-- /Since: 1.12/
matrixGetFontScaleFactor ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (Matrix)
    -- ^ /@matrix@/: a @PangoMatrix@, may be 'P.Nothing'
    -> m Double
    -- ^ __Returns:__ the scale factor of /@matrix@/ on the height of the font,
    --   or 1.0 if /@matrix@/ is 'P.Nothing'.
matrixGetFontScaleFactor matrix = liftIO $ do
    maybeMatrix <- case matrix of
        Nothing -> return FP.nullPtr
        Just jMatrix -> do
            jMatrix' <- unsafeManagedPtrGetPtr jMatrix
            return jMatrix'
    result <- pango_matrix_get_font_scale_factor maybeMatrix
    let result' = realToFrac result
    whenJust matrix touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data MatrixGetFontScaleFactorMethodInfo
instance (signature ~ (m Double), MonadIO m) => O.OverloadedMethod MatrixGetFontScaleFactorMethodInfo Matrix signature where
    overloadedMethod i = matrixGetFontScaleFactor (Just i)

instance O.OverloadedMethodInfo MatrixGetFontScaleFactorMethodInfo Matrix where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Matrix.matrixGetFontScaleFactor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Matrix.html#v:matrixGetFontScaleFactor"
        })


#endif

-- method Matrix::get_font_scale_factors
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "matrix"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Matrix" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoMatrix`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "xscale"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "output scale factor in the x direction"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "yscale"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "output scale factor perpendicular to the x direction"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_matrix_get_font_scale_factors" pango_matrix_get_font_scale_factors :: 
    Ptr Matrix ->                           -- matrix : TInterface (Name {namespace = "Pango", name = "Matrix"})
    Ptr CDouble ->                          -- xscale : TBasicType TDouble
    Ptr CDouble ->                          -- yscale : TBasicType TDouble
    IO ()

-- | Calculates the scale factor of a matrix on the width and height of the font.
-- 
-- That is, /@xscale@/ is the scale factor in the direction of the X coordinate,
-- and /@yscale@/ is the scale factor in the direction perpendicular to the
-- vector that the X coordinate is mapped to.
-- 
-- Note that output numbers will always be non-negative.
-- 
-- /Since: 1.38/
matrixGetFontScaleFactors ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (Matrix)
    -- ^ /@matrix@/: a @PangoMatrix@
    -> m ((Double, Double))
matrixGetFontScaleFactors matrix = liftIO $ do
    maybeMatrix <- case matrix of
        Nothing -> return FP.nullPtr
        Just jMatrix -> do
            jMatrix' <- unsafeManagedPtrGetPtr jMatrix
            return jMatrix'
    xscale <- allocMem :: IO (Ptr CDouble)
    yscale <- allocMem :: IO (Ptr CDouble)
    pango_matrix_get_font_scale_factors maybeMatrix xscale yscale
    xscale' <- peek xscale
    let xscale'' = realToFrac xscale'
    yscale' <- peek yscale
    let yscale'' = realToFrac yscale'
    whenJust matrix touchManagedPtr
    freeMem xscale
    freeMem yscale
    return (xscale'', yscale'')

#if defined(ENABLE_OVERLOADING)
data MatrixGetFontScaleFactorsMethodInfo
instance (signature ~ (m ((Double, Double))), MonadIO m) => O.OverloadedMethod MatrixGetFontScaleFactorsMethodInfo Matrix signature where
    overloadedMethod i = matrixGetFontScaleFactors (Just i)

instance O.OverloadedMethodInfo MatrixGetFontScaleFactorsMethodInfo Matrix where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Matrix.matrixGetFontScaleFactors",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Matrix.html#v:matrixGetFontScaleFactors"
        })


#endif

-- method Matrix::get_slant_ratio
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "matrix"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Matrix" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoMatrix`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "pango_matrix_get_slant_ratio" pango_matrix_get_slant_ratio :: 
    Ptr Matrix ->                           -- matrix : TInterface (Name {namespace = "Pango", name = "Matrix"})
    IO CDouble

-- | Gets the slant ratio of a matrix.
-- 
-- For a simple shear matrix in the form:
-- 
--     1 λ
--     0 1
-- 
-- this is simply λ.
-- 
-- /Since: 1.50/
matrixGetSlantRatio ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Matrix
    -- ^ /@matrix@/: a @PangoMatrix@
    -> m Double
    -- ^ __Returns:__ the slant ratio of /@matrix@/
matrixGetSlantRatio matrix = liftIO $ do
    matrix' <- unsafeManagedPtrGetPtr matrix
    result <- pango_matrix_get_slant_ratio matrix'
    let result' = realToFrac result
    touchManagedPtr matrix
    return result'

#if defined(ENABLE_OVERLOADING)
data MatrixGetSlantRatioMethodInfo
instance (signature ~ (m Double), MonadIO m) => O.OverloadedMethod MatrixGetSlantRatioMethodInfo Matrix signature where
    overloadedMethod = matrixGetSlantRatio

instance O.OverloadedMethodInfo MatrixGetSlantRatioMethodInfo Matrix where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Matrix.matrixGetSlantRatio",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Matrix.html#v:matrixGetSlantRatio"
        })


#endif

-- method Matrix::rotate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "matrix"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Matrix" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoMatrix`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "degrees"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "degrees to rotate counter-clockwise"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_matrix_rotate" pango_matrix_rotate :: 
    Ptr Matrix ->                           -- matrix : TInterface (Name {namespace = "Pango", name = "Matrix"})
    CDouble ->                              -- degrees : TBasicType TDouble
    IO ()

-- | Changes the transformation represented by /@matrix@/ to be the
-- transformation given by first rotating by /@degrees@/ degrees
-- counter-clockwise then applying the original transformation.
-- 
-- /Since: 1.6/
matrixRotate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Matrix
    -- ^ /@matrix@/: a @PangoMatrix@
    -> Double
    -- ^ /@degrees@/: degrees to rotate counter-clockwise
    -> m ()
matrixRotate matrix degrees = liftIO $ do
    matrix' <- unsafeManagedPtrGetPtr matrix
    let degrees' = realToFrac degrees
    pango_matrix_rotate matrix' degrees'
    touchManagedPtr matrix
    return ()

#if defined(ENABLE_OVERLOADING)
data MatrixRotateMethodInfo
instance (signature ~ (Double -> m ()), MonadIO m) => O.OverloadedMethod MatrixRotateMethodInfo Matrix signature where
    overloadedMethod = matrixRotate

instance O.OverloadedMethodInfo MatrixRotateMethodInfo Matrix where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Matrix.matrixRotate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Matrix.html#v:matrixRotate"
        })


#endif

-- method Matrix::scale
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "matrix"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Matrix" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoMatrix`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scale_x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "amount to scale by in X direction"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scale_y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "amount to scale by in Y direction"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_matrix_scale" pango_matrix_scale :: 
    Ptr Matrix ->                           -- matrix : TInterface (Name {namespace = "Pango", name = "Matrix"})
    CDouble ->                              -- scale_x : TBasicType TDouble
    CDouble ->                              -- scale_y : TBasicType TDouble
    IO ()

-- | Changes the transformation represented by /@matrix@/ to be the
-- transformation given by first scaling by /@sx@/ in the X direction
-- and /@sy@/ in the Y direction then applying the original
-- transformation.
-- 
-- /Since: 1.6/
matrixScale ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Matrix
    -- ^ /@matrix@/: a @PangoMatrix@
    -> Double
    -- ^ /@scaleX@/: amount to scale by in X direction
    -> Double
    -- ^ /@scaleY@/: amount to scale by in Y direction
    -> m ()
matrixScale matrix scaleX scaleY = liftIO $ do
    matrix' <- unsafeManagedPtrGetPtr matrix
    let scaleX' = realToFrac scaleX
    let scaleY' = realToFrac scaleY
    pango_matrix_scale matrix' scaleX' scaleY'
    touchManagedPtr matrix
    return ()

#if defined(ENABLE_OVERLOADING)
data MatrixScaleMethodInfo
instance (signature ~ (Double -> Double -> m ()), MonadIO m) => O.OverloadedMethod MatrixScaleMethodInfo Matrix signature where
    overloadedMethod = matrixScale

instance O.OverloadedMethodInfo MatrixScaleMethodInfo Matrix where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Matrix.matrixScale",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Matrix.html#v:matrixScale"
        })


#endif

-- method Matrix::transform_distance
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "matrix"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Matrix" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoMatrix`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dx"
--           , argType = TBasicType TDouble
--           , direction = DirectionInout
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "in/out X component of a distance vector"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "dy"
--           , argType = TBasicType TDouble
--           , direction = DirectionInout
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "in/out Y component of a distance vector"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_matrix_transform_distance" pango_matrix_transform_distance :: 
    Ptr Matrix ->                           -- matrix : TInterface (Name {namespace = "Pango", name = "Matrix"})
    Ptr CDouble ->                          -- dx : TBasicType TDouble
    Ptr CDouble ->                          -- dy : TBasicType TDouble
    IO ()

-- | Transforms the distance vector (/@dx@/,/@dy@/) by /@matrix@/.
-- 
-- This is similar to 'GI.Pango.Structs.Matrix.matrixTransformPoint',
-- except that the translation components of the transformation
-- are ignored. The calculation of the returned vector is as follows:
-- 
-- 
-- 	
-- >dx2 = dx1 * xx + dy1 * xy;
-- >dy2 = dx1 * yx + dy1 * yy;
-- 
-- 
-- Affine transformations are position invariant, so the same vector
-- always transforms to the same vector. If (/@x1@/,/@y1@/) transforms
-- to (/@x2@/,/@y2@/) then (/@x1@/+/@dx1@/,/@y1@/+/@dy1@/) will transform to
-- (/@x1@/+/@dx2@/,/@y1@/+/@dy2@/) for all values of /@x1@/ and /@x2@/.
-- 
-- /Since: 1.16/
matrixTransformDistance ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (Matrix)
    -- ^ /@matrix@/: a @PangoMatrix@
    -> Double
    -- ^ /@dx@/: in\/out X component of a distance vector
    -> Double
    -- ^ /@dy@/: in\/out Y component of a distance vector
    -> m ((Double, Double))
matrixTransformDistance matrix dx dy = liftIO $ do
    maybeMatrix <- case matrix of
        Nothing -> return FP.nullPtr
        Just jMatrix -> do
            jMatrix' <- unsafeManagedPtrGetPtr jMatrix
            return jMatrix'
    let dx' = realToFrac dx
    dx'' <- allocMem :: IO (Ptr CDouble)
    poke dx'' dx'
    let dy' = realToFrac dy
    dy'' <- allocMem :: IO (Ptr CDouble)
    poke dy'' dy'
    pango_matrix_transform_distance maybeMatrix dx'' dy''
    dx''' <- peek dx''
    let dx'''' = realToFrac dx'''
    dy''' <- peek dy''
    let dy'''' = realToFrac dy'''
    whenJust matrix touchManagedPtr
    freeMem dx''
    freeMem dy''
    return (dx'''', dy'''')

#if defined(ENABLE_OVERLOADING)
data MatrixTransformDistanceMethodInfo
instance (signature ~ (Double -> Double -> m ((Double, Double))), MonadIO m) => O.OverloadedMethod MatrixTransformDistanceMethodInfo Matrix signature where
    overloadedMethod i = matrixTransformDistance (Just i)

instance O.OverloadedMethodInfo MatrixTransformDistanceMethodInfo Matrix where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Matrix.matrixTransformDistance",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Matrix.html#v:matrixTransformDistance"
        })


#endif

-- method Matrix::transform_pixel_rectangle
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "matrix"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Matrix" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoMatrix`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "in/out bounding box in device units"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_matrix_transform_pixel_rectangle" pango_matrix_transform_pixel_rectangle :: 
    Ptr Matrix ->                           -- matrix : TInterface (Name {namespace = "Pango", name = "Matrix"})
    Ptr Pango.Rectangle.Rectangle ->        -- rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    IO ()

-- | First transforms the /@rect@/ using /@matrix@/, then calculates the bounding box
-- of the transformed rectangle.
-- 
-- This function is useful for example when you want to draw a rotated
-- /@pangoLayout@/ to an image buffer, and want to know how large the image
-- should be and how much you should shift the layout when rendering.
-- 
-- For better accuracy, you should use 'GI.Pango.Structs.Matrix.matrixTransformRectangle'
-- on original rectangle in Pango units and convert to pixels afterward
-- using [func/@extentsToPixels@/]\'s first argument.
-- 
-- /Since: 1.16/
matrixTransformPixelRectangle ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (Matrix)
    -- ^ /@matrix@/: a @PangoMatrix@
    -> Maybe (Pango.Rectangle.Rectangle)
    -- ^ /@rect@/: in\/out bounding box in device units
    -> m ()
matrixTransformPixelRectangle matrix rect = liftIO $ do
    maybeMatrix <- case matrix of
        Nothing -> return FP.nullPtr
        Just jMatrix -> do
            jMatrix' <- unsafeManagedPtrGetPtr jMatrix
            return jMatrix'
    maybeRect <- case rect of
        Nothing -> return FP.nullPtr
        Just jRect -> do
            jRect' <- unsafeManagedPtrGetPtr jRect
            return jRect'
    pango_matrix_transform_pixel_rectangle maybeMatrix maybeRect
    whenJust matrix touchManagedPtr
    whenJust rect touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MatrixTransformPixelRectangleMethodInfo
instance (signature ~ (Maybe (Pango.Rectangle.Rectangle) -> m ()), MonadIO m) => O.OverloadedMethod MatrixTransformPixelRectangleMethodInfo Matrix signature where
    overloadedMethod i = matrixTransformPixelRectangle (Just i)

instance O.OverloadedMethodInfo MatrixTransformPixelRectangleMethodInfo Matrix where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Matrix.matrixTransformPixelRectangle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Matrix.html#v:matrixTransformPixelRectangle"
        })


#endif

-- method Matrix::transform_point
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "matrix"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Matrix" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoMatrix`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionInout
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "in/out X position" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionInout
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "in/out Y position" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_matrix_transform_point" pango_matrix_transform_point :: 
    Ptr Matrix ->                           -- matrix : TInterface (Name {namespace = "Pango", name = "Matrix"})
    Ptr CDouble ->                          -- x : TBasicType TDouble
    Ptr CDouble ->                          -- y : TBasicType TDouble
    IO ()

-- | Transforms the point (/@x@/, /@y@/) by /@matrix@/.
-- 
-- /Since: 1.16/
matrixTransformPoint ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (Matrix)
    -- ^ /@matrix@/: a @PangoMatrix@
    -> Double
    -- ^ /@x@/: in\/out X position
    -> Double
    -- ^ /@y@/: in\/out Y position
    -> m ((Double, Double))
matrixTransformPoint matrix x y = liftIO $ do
    maybeMatrix <- case matrix of
        Nothing -> return FP.nullPtr
        Just jMatrix -> do
            jMatrix' <- unsafeManagedPtrGetPtr jMatrix
            return jMatrix'
    let x' = realToFrac x
    x'' <- allocMem :: IO (Ptr CDouble)
    poke x'' x'
    let y' = realToFrac y
    y'' <- allocMem :: IO (Ptr CDouble)
    poke y'' y'
    pango_matrix_transform_point maybeMatrix x'' y''
    x''' <- peek x''
    let x'''' = realToFrac x'''
    y''' <- peek y''
    let y'''' = realToFrac y'''
    whenJust matrix touchManagedPtr
    freeMem x''
    freeMem y''
    return (x'''', y'''')

#if defined(ENABLE_OVERLOADING)
data MatrixTransformPointMethodInfo
instance (signature ~ (Double -> Double -> m ((Double, Double))), MonadIO m) => O.OverloadedMethod MatrixTransformPointMethodInfo Matrix signature where
    overloadedMethod i = matrixTransformPoint (Just i)

instance O.OverloadedMethodInfo MatrixTransformPointMethodInfo Matrix where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Matrix.matrixTransformPoint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Matrix.html#v:matrixTransformPoint"
        })


#endif

-- XXX Could not generate method Matrix::transform_rectangle
-- Not implemented: Nullable inout structs not supported
-- method Matrix::translate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "matrix"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Matrix" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoMatrix`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tx"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "amount to translate in the X direction"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ty"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "amount to translate in the Y direction"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_matrix_translate" pango_matrix_translate :: 
    Ptr Matrix ->                           -- matrix : TInterface (Name {namespace = "Pango", name = "Matrix"})
    CDouble ->                              -- tx : TBasicType TDouble
    CDouble ->                              -- ty : TBasicType TDouble
    IO ()

-- | Changes the transformation represented by /@matrix@/ to be the
-- transformation given by first translating by (/@tx@/, /@ty@/)
-- then applying the original transformation.
-- 
-- /Since: 1.6/
matrixTranslate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Matrix
    -- ^ /@matrix@/: a @PangoMatrix@
    -> Double
    -- ^ /@tx@/: amount to translate in the X direction
    -> Double
    -- ^ /@ty@/: amount to translate in the Y direction
    -> m ()
matrixTranslate matrix tx ty = liftIO $ do
    matrix' <- unsafeManagedPtrGetPtr matrix
    let tx' = realToFrac tx
    let ty' = realToFrac ty
    pango_matrix_translate matrix' tx' ty'
    touchManagedPtr matrix
    return ()

#if defined(ENABLE_OVERLOADING)
data MatrixTranslateMethodInfo
instance (signature ~ (Double -> Double -> m ()), MonadIO m) => O.OverloadedMethod MatrixTranslateMethodInfo Matrix signature where
    overloadedMethod = matrixTranslate

instance O.OverloadedMethodInfo MatrixTranslateMethodInfo Matrix where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Matrix.matrixTranslate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Matrix.html#v:matrixTranslate"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveMatrixMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMatrixMethod "concat" o = MatrixConcatMethodInfo
    ResolveMatrixMethod "copy" o = MatrixCopyMethodInfo
    ResolveMatrixMethod "free" o = MatrixFreeMethodInfo
    ResolveMatrixMethod "rotate" o = MatrixRotateMethodInfo
    ResolveMatrixMethod "scale" o = MatrixScaleMethodInfo
    ResolveMatrixMethod "transformDistance" o = MatrixTransformDistanceMethodInfo
    ResolveMatrixMethod "transformPixelRectangle" o = MatrixTransformPixelRectangleMethodInfo
    ResolveMatrixMethod "transformPoint" o = MatrixTransformPointMethodInfo
    ResolveMatrixMethod "translate" o = MatrixTranslateMethodInfo
    ResolveMatrixMethod "getFontScaleFactor" o = MatrixGetFontScaleFactorMethodInfo
    ResolveMatrixMethod "getFontScaleFactors" o = MatrixGetFontScaleFactorsMethodInfo
    ResolveMatrixMethod "getSlantRatio" o = MatrixGetSlantRatioMethodInfo
    ResolveMatrixMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMatrixMethod t Matrix, O.OverloadedMethod info Matrix p) => OL.IsLabel t (Matrix -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMatrixMethod t Matrix, O.OverloadedMethod info Matrix p, R.HasField t Matrix p) => R.HasField t Matrix p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMatrixMethod t Matrix, O.OverloadedMethodInfo info Matrix) => OL.IsLabel t (O.MethodProxy info Matrix) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


