/* expr.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from expr.vala, do not modify */

/*
 * Copyright (C) 2011-2026 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2026 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <config.h>
#include "libskk/libskk.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef enum  {
	SKK_EXPR_NODE_TYPE_ARRAY,
	SKK_EXPR_NODE_TYPE_SYMBOL,
	SKK_EXPR_NODE_TYPE_STRING
} SkkExprNodeType;

#define SKK_TYPE_EXPR_NODE_TYPE (skk_expr_node_type_get_type ())

#define SKK_TYPE_EXPR_NODE (skk_expr_node_get_type ())
typedef struct _SkkExprNode SkkExprNode;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SKK_TYPE_EXPR_READER (skk_expr_reader_get_type ())
#define SKK_EXPR_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_EXPR_READER, SkkExprReader))
#define SKK_EXPR_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_EXPR_READER, SkkExprReaderClass))
#define SKK_IS_EXPR_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_EXPR_READER))
#define SKK_IS_EXPR_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_EXPR_READER))
#define SKK_EXPR_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_EXPR_READER, SkkExprReaderClass))

typedef struct _SkkExprReader SkkExprReader;
typedef struct _SkkExprReaderClass SkkExprReaderClass;
typedef struct _SkkExprReaderPrivate SkkExprReaderPrivate;
enum  {
	SKK_EXPR_READER_0_PROPERTY,
	SKK_EXPR_READER_NUM_PROPERTIES
};
static GParamSpec* skk_expr_reader_properties[SKK_EXPR_READER_NUM_PROPERTIES];
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _skk_expr_node_free0(var) ((var == NULL) ? NULL : (var = (skk_expr_node_free (var), NULL)))

#define SKK_TYPE_EXPR_EVALUATOR (skk_expr_evaluator_get_type ())
#define SKK_EXPR_EVALUATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_EXPR_EVALUATOR, SkkExprEvaluator))
#define SKK_EXPR_EVALUATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_EXPR_EVALUATOR, SkkExprEvaluatorClass))
#define SKK_IS_EXPR_EVALUATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_EXPR_EVALUATOR))
#define SKK_IS_EXPR_EVALUATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_EXPR_EVALUATOR))
#define SKK_EXPR_EVALUATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_EXPR_EVALUATOR, SkkExprEvaluatorClass))

typedef struct _SkkExprEvaluator SkkExprEvaluator;
typedef struct _SkkExprEvaluatorClass SkkExprEvaluatorClass;
typedef struct _SkkExprEvaluatorPrivate SkkExprEvaluatorPrivate;
enum  {
	SKK_EXPR_EVALUATOR_0_PROPERTY,
	SKK_EXPR_EVALUATOR_NUM_PROPERTIES
};
static GParamSpec* skk_expr_evaluator_properties[SKK_EXPR_EVALUATOR_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _SkkExprNode {
	SkkExprNodeType type;
	GeeLinkedList* nodes;
	gchar* data;
};

struct _SkkExprReader {
	GObject parent_instance;
	SkkExprReaderPrivate * priv;
};

struct _SkkExprReaderClass {
	GObjectClass parent_class;
};

struct _SkkExprEvaluator {
	GObject parent_instance;
	SkkExprEvaluatorPrivate * priv;
};

struct _SkkExprEvaluatorClass {
	GObjectClass parent_class;
};

static gpointer skk_expr_reader_parent_class = NULL;
static gpointer skk_expr_evaluator_parent_class = NULL;

VALA_EXTERN GType skk_expr_node_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType skk_expr_node_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SkkExprNode* skk_expr_node_dup (const SkkExprNode* self);
VALA_EXTERN void skk_expr_node_free (SkkExprNode* self);
VALA_EXTERN void skk_expr_node_copy (const SkkExprNode* self,
                         SkkExprNode* dest);
VALA_EXTERN void skk_expr_node_destroy (SkkExprNode* self);
VALA_EXTERN void skk_expr_node_init (SkkExprNode *self,
                         SkkExprNodeType type);
VALA_EXTERN GType skk_expr_reader_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void skk_expr_reader_read_symbol (SkkExprReader* self,
                                  const gchar* expr,
                                  gint* index,
                                  SkkExprNode* result);
VALA_EXTERN SkkExprNode* skk_expr_reader_read_string (SkkExprReader* self,
                                          const gchar* expr,
                                          gint* index);
VALA_EXTERN SkkExprNode* skk_expr_reader_read_expr (SkkExprReader* self,
                                        const gchar* expr,
                                        gint* index);
VALA_EXTERN SkkExprReader* skk_expr_reader_new (void);
VALA_EXTERN SkkExprReader* skk_expr_reader_construct (GType object_type);
static GType skk_expr_reader_get_type_once (void);
VALA_EXTERN GType skk_expr_evaluator_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* skk_expr_evaluator_eval (SkkExprEvaluator* self,
                                SkkExprNode* node);
VALA_EXTERN SkkExprEvaluator* skk_expr_evaluator_new (void);
VALA_EXTERN SkkExprEvaluator* skk_expr_evaluator_construct (GType object_type);
static GType skk_expr_evaluator_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
skk_expr_node_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SKK_EXPR_NODE_TYPE_ARRAY, "SKK_EXPR_NODE_TYPE_ARRAY", "array"}, {SKK_EXPR_NODE_TYPE_SYMBOL, "SKK_EXPR_NODE_TYPE_SYMBOL", "symbol"}, {SKK_EXPR_NODE_TYPE_STRING, "SKK_EXPR_NODE_TYPE_STRING", "string"}, {0, NULL, NULL}};
	GType skk_expr_node_type_type_id;
	skk_expr_node_type_type_id = g_enum_register_static ("SkkExprNodeType", values);
	return skk_expr_node_type_type_id;
}

GType
skk_expr_node_type_get_type (void)
{
	static volatile gsize skk_expr_node_type_type_id__once = 0;
	if (g_once_init_enter (&skk_expr_node_type_type_id__once)) {
		GType skk_expr_node_type_type_id;
		skk_expr_node_type_type_id = skk_expr_node_type_get_type_once ();
		g_once_init_leave (&skk_expr_node_type_type_id__once, skk_expr_node_type_type_id);
	}
	return skk_expr_node_type_type_id__once;
}

void
skk_expr_node_init (SkkExprNode *self,
                    SkkExprNodeType type)
{
	memset (self, 0, sizeof (SkkExprNode));
	(*self).type = type;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
skk_expr_node_copy (const SkkExprNode* self,
                    SkkExprNode* dest)
{
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	(*dest).type = (*self).type;
	_tmp0_ = (*self).nodes;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).nodes);
	(*dest).nodes = _tmp1_;
	_tmp2_ = (*self).data;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).data);
	(*dest).data = _tmp3_;
}

void
skk_expr_node_destroy (SkkExprNode* self)
{
	_g_object_unref0 ((*self).nodes);
	_g_free0 ((*self).data);
}

SkkExprNode*
skk_expr_node_dup (const SkkExprNode* self)
{
	SkkExprNode* dup;
	dup = g_new0 (SkkExprNode, 1);
	skk_expr_node_copy (self, dup);
	return dup;
}

void
skk_expr_node_free (SkkExprNode* self)
{
	skk_expr_node_destroy (self);
	g_free (self);
}

static GType
skk_expr_node_get_type_once (void)
{
	GType skk_expr_node_type_id;
	skk_expr_node_type_id = g_boxed_type_register_static ("SkkExprNode", (GBoxedCopyFunc) skk_expr_node_dup, (GBoxedFreeFunc) skk_expr_node_free);
	return skk_expr_node_type_id;
}

GType
skk_expr_node_get_type (void)
{
	static volatile gsize skk_expr_node_type_id__once = 0;
	if (g_once_init_enter (&skk_expr_node_type_id__once)) {
		GType skk_expr_node_type_id;
		skk_expr_node_type_id = skk_expr_node_get_type_once ();
		g_once_init_leave (&skk_expr_node_type_id__once, skk_expr_node_type_id);
	}
	return skk_expr_node_type_id__once;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

void
skk_expr_reader_read_symbol (SkkExprReader* self,
                             const gchar* expr,
                             gint* index,
                             SkkExprNode* result)
{
	GString* builder = NULL;
	GString* _tmp0_;
	gboolean stop = FALSE;
	gunichar uc = 0U;
	SkkExprNode node = {0};
	GString* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	stop = FALSE;
	uc = (gunichar) '\0';
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		if (!stop) {
			gunichar _tmp2_ = 0U;
			gboolean _tmp3_;
			_tmp3_ = string_get_next_char (expr, index, &_tmp2_);
			uc = _tmp2_;
			_tmp1_ = _tmp3_;
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		switch (uc) {
			case '\\':
			{
				gunichar _tmp4_ = 0U;
				gboolean _tmp5_;
				_tmp5_ = string_get_next_char (expr, index, &_tmp4_);
				uc = _tmp4_;
				if (_tmp5_) {
					GString* _tmp6_;
					_tmp6_ = builder;
					g_string_append_unichar (_tmp6_, uc);
				}
				break;
			}
			case '(':
			case ')':
			case '"':
			case ' ':
			{
				stop = TRUE;
				break;
			}
			default:
			{
				GString* _tmp7_;
				_tmp7_ = builder;
				g_string_append_unichar (_tmp7_, uc);
				break;
			}
		}
	}
	skk_expr_node_init (&node, SKK_EXPR_NODE_TYPE_SYMBOL);
	_tmp8_ = builder;
	_tmp9_ = _tmp8_->str;
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (node.data);
	node.data = _tmp10_;
	*result = node;
	_g_string_free0 (builder);
	return;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gpointer
_skk_expr_node_dup0 (gpointer self)
{
	return self ? skk_expr_node_dup (self) : NULL;
}

SkkExprNode*
skk_expr_reader_read_string (SkkExprReader* self,
                             const gchar* expr,
                             gint* index)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	GString* builder = NULL;
	GString* _tmp3_;
	gint _tmp4_;
	gboolean stop = FALSE;
	gunichar uc = 0U;
	SkkExprNode node = {0};
	GString* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	SkkExprNode _tmp24_;
	SkkExprNode* _tmp25_;
	SkkExprNode* _tmp26_;
	SkkExprNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	_tmp1_ = strlen (expr);
	_tmp2_ = _tmp1_;
	if ((*index) < _tmp2_) {
		_tmp0_ = string_get (expr, (glong) (*index)) == '"';
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, NULL);
	_tmp3_ = g_string_new ("");
	builder = _tmp3_;
	_tmp4_ = *index;
	*index = _tmp4_ + 1;
	stop = FALSE;
	uc = (gunichar) '\0';
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		if (!stop) {
			gunichar _tmp6_ = 0U;
			gboolean _tmp7_;
			_tmp7_ = string_get_next_char (expr, index, &_tmp6_);
			uc = _tmp6_;
			_tmp5_ = _tmp7_;
		} else {
			_tmp5_ = FALSE;
		}
		if (!_tmp5_) {
			break;
		}
		switch (uc) {
			case '\\':
			{
				gunichar _tmp8_ = 0U;
				gboolean _tmp9_;
				_tmp9_ = string_get_next_char (expr, index, &_tmp8_);
				uc = _tmp8_;
				if (_tmp9_) {
					GString* _tmp19_;
					switch (uc) {
						case '0':
						case '1':
						case '2':
						case '3':
						case '4':
						case '5':
						case '6':
						case '7':
						{
							gint start = 0;
							gint advance = 0;
							gint num = 0;
							start = *index;
							advance = 0;
							num = ((gint) uc) - '0';
							while (TRUE) {
								gunichar _tmp10_ = 0U;
								gboolean _tmp11_;
								gboolean _tmp12_ = FALSE;
								gint _tmp13_;
								_tmp11_ = string_get_next_char (expr, index, &_tmp10_);
								uc = _tmp10_;
								if (!_tmp11_) {
									break;
								}
								if (((*index) - start) == 3) {
									break;
								}
								if (uc < ((gunichar) '0')) {
									_tmp12_ = TRUE;
								} else {
									_tmp12_ = uc > ((gunichar) '7');
								}
								if (_tmp12_) {
									break;
								}
								num <<= 3;
								num += ((gint) uc) - '0';
								_tmp13_ = advance;
								advance = _tmp13_ + 1;
							}
							*index = start + advance;
							uc = (gunichar) num;
							break;
						}
						case 'x':
						{
							gint start = 0;
							gint advance = 0;
							gint num = 0;
							start = *index;
							advance = 0;
							num = 0;
							while (TRUE) {
								gunichar _tmp14_ = 0U;
								gboolean _tmp15_;
								gboolean _tmp16_ = FALSE;
								gint _tmp18_;
								_tmp15_ = string_get_next_char (expr, index, &_tmp14_);
								uc = _tmp14_;
								if (!_tmp15_) {
									break;
								}
								uc = g_unichar_tolower (uc);
								if (((gunichar) '0') <= uc) {
									_tmp16_ = uc <= ((gunichar) '9');
								} else {
									_tmp16_ = FALSE;
								}
								if (_tmp16_) {
									num <<= 4;
									num += ((gint) uc) - '0';
								} else {
									gboolean _tmp17_ = FALSE;
									if (((gunichar) 'a') <= uc) {
										_tmp17_ = uc <= ((gunichar) 'f');
									} else {
										_tmp17_ = FALSE;
									}
									if (_tmp17_) {
										num <<= 4;
										num += (((gint) uc) - 'a') + 10;
									} else {
										break;
									}
								}
								_tmp18_ = advance;
								advance = _tmp18_ + 1;
							}
							*index = start + advance;
							uc = (gunichar) num;
							break;
						}
						default:
						{
							break;
						}
					}
					_tmp19_ = builder;
					g_string_append_unichar (_tmp19_, uc);
				}
				break;
			}
			case '\"':
			{
				stop = TRUE;
				break;
			}
			default:
			{
				GString* _tmp20_;
				_tmp20_ = builder;
				g_string_append_unichar (_tmp20_, uc);
				break;
			}
		}
	}
	skk_expr_node_init (&node, SKK_EXPR_NODE_TYPE_STRING);
	_tmp21_ = builder;
	_tmp22_ = _tmp21_->str;
	_tmp23_ = g_strdup (_tmp22_);
	_g_free0 (node.data);
	node.data = _tmp23_;
	_tmp24_ = node;
	_tmp25_ = _skk_expr_node_dup0 (&_tmp24_);
	_tmp26_ = _tmp25_;
	skk_expr_node_destroy (&_tmp24_);
	result = _tmp26_;
	_g_string_free0 (builder);
	return result;
}

SkkExprNode*
skk_expr_reader_read_expr (SkkExprReader* self,
                           const gchar* expr,
                           gint* index)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	GeeLinkedList* nodes = NULL;
	GeeLinkedList* _tmp3_;
	gboolean stop = FALSE;
	gint _tmp4_;
	gunichar uc = 0U;
	SkkExprNode node = {0};
	GeeLinkedList* _tmp22_;
	GeeLinkedList* _tmp23_;
	SkkExprNode _tmp24_;
	SkkExprNode* _tmp25_;
	SkkExprNode* _tmp26_;
	SkkExprNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	_tmp1_ = strlen (expr);
	_tmp2_ = _tmp1_;
	if ((*index) < _tmp2_) {
		_tmp0_ = string_get (expr, (glong) (*index)) == '(';
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, NULL);
	_tmp3_ = gee_linked_list_new (SKK_TYPE_EXPR_NODE, (GBoxedCopyFunc) skk_expr_node_dup, (GDestroyNotify) skk_expr_node_free, NULL, NULL, NULL);
	nodes = _tmp3_;
	stop = FALSE;
	_tmp4_ = *index;
	*index = _tmp4_ + 1;
	uc = (gunichar) '\0';
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		if (!stop) {
			gunichar _tmp6_ = 0U;
			gboolean _tmp7_;
			_tmp7_ = string_get_next_char (expr, index, &_tmp6_);
			uc = _tmp6_;
			_tmp5_ = _tmp7_;
		} else {
			_tmp5_ = FALSE;
		}
		if (!_tmp5_) {
			break;
		}
		switch (uc) {
			case ' ':
			{
				break;
			}
			case ')':
			{
				gint _tmp8_;
				_tmp8_ = *index;
				*index = _tmp8_ + 1;
				stop = TRUE;
				break;
			}
			case '(':
			{
				gint _tmp9_;
				GeeLinkedList* _tmp10_;
				SkkExprNode* _tmp11_;
				SkkExprNode* _tmp12_;
				_tmp9_ = *index;
				*index = _tmp9_ - 1;
				_tmp10_ = nodes;
				_tmp11_ = skk_expr_reader_read_expr (self, expr, index);
				_tmp12_ = _tmp11_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp12_);
				_skk_expr_node_free0 (_tmp12_);
				break;
			}
			case '"':
			{
				gint _tmp13_;
				GeeLinkedList* _tmp14_;
				SkkExprNode* _tmp15_;
				SkkExprNode* _tmp16_;
				_tmp13_ = *index;
				*index = _tmp13_ - 1;
				_tmp14_ = nodes;
				_tmp15_ = skk_expr_reader_read_string (self, expr, index);
				_tmp16_ = _tmp15_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp16_);
				_skk_expr_node_free0 (_tmp16_);
				break;
			}
			default:
			{
				gint _tmp17_;
				GeeLinkedList* _tmp18_;
				SkkExprNode _tmp19_ = {0};
				SkkExprNode _tmp20_;
				SkkExprNode _tmp21_;
				_tmp17_ = *index;
				*index = _tmp17_ - 1;
				_tmp18_ = nodes;
				skk_expr_reader_read_symbol (self, expr, index, &_tmp19_);
				_tmp20_ = _tmp19_;
				_tmp21_ = _tmp20_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, &_tmp21_);
				skk_expr_node_destroy (&_tmp20_);
				break;
			}
		}
	}
	skk_expr_node_init (&node, SKK_EXPR_NODE_TYPE_ARRAY);
	_tmp22_ = nodes;
	_tmp23_ = _g_object_ref0 (_tmp22_);
	_g_object_unref0 (node.nodes);
	node.nodes = _tmp23_;
	_tmp24_ = node;
	_tmp25_ = _skk_expr_node_dup0 (&_tmp24_);
	_tmp26_ = _tmp25_;
	skk_expr_node_destroy (&_tmp24_);
	result = _tmp26_;
	_g_object_unref0 (nodes);
	return result;
}

SkkExprReader*
skk_expr_reader_construct (GType object_type)
{
	SkkExprReader * self = NULL;
	self = (SkkExprReader*) g_object_new (object_type, NULL);
	return self;
}

SkkExprReader*
skk_expr_reader_new (void)
{
	return skk_expr_reader_construct (SKK_TYPE_EXPR_READER);
}

static void
skk_expr_reader_class_init (SkkExprReaderClass * klass,
                            gpointer klass_data)
{
	skk_expr_reader_parent_class = g_type_class_peek_parent (klass);
}

static void
skk_expr_reader_instance_init (SkkExprReader * self,
                               gpointer klass)
{
}

static GType
skk_expr_reader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkExprReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_expr_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkExprReader), 0, (GInstanceInitFunc) skk_expr_reader_instance_init, NULL };
	GType skk_expr_reader_type_id;
	skk_expr_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkExprReader", &g_define_type_info, 0);
	return skk_expr_reader_type_id;
}

GType
skk_expr_reader_get_type (void)
{
	static volatile gsize skk_expr_reader_type_id__once = 0;
	if (g_once_init_enter (&skk_expr_reader_type_id__once)) {
		GType skk_expr_reader_type_id;
		skk_expr_reader_type_id = skk_expr_reader_get_type_once ();
		g_once_init_leave (&skk_expr_reader_type_id__once, skk_expr_reader_type_id);
	}
	return skk_expr_reader_type_id__once;
}

gchar*
skk_expr_evaluator_eval (SkkExprEvaluator* self,
                         SkkExprNode* node)
{
	SkkExprNode _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = *node;
	if (_tmp0_.type == SKK_EXPR_NODE_TYPE_ARRAY) {
		GeeListIterator* iter = NULL;
		SkkExprNode _tmp1_;
		GeeLinkedList* _tmp2_;
		GeeListIterator* _tmp3_;
		GeeListIterator* _tmp4_;
		_tmp1_ = *node;
		_tmp2_ = _tmp1_.nodes;
		_tmp3_ = gee_abstract_list_list_iterator ((GeeAbstractList*) _tmp2_);
		iter = _tmp3_;
		_tmp4_ = iter;
		if (gee_iterator_next ((GeeIterator*) _tmp4_)) {
			SkkExprNode* funcall = NULL;
			GeeListIterator* _tmp5_;
			gpointer _tmp6_;
			SkkExprNode* _tmp7_;
			_tmp5_ = iter;
			_tmp6_ = gee_iterator_get ((GeeIterator*) _tmp5_);
			funcall = (SkkExprNode*) _tmp6_;
			_tmp7_ = funcall;
			if ((*_tmp7_).type == SKK_EXPR_NODE_TYPE_SYMBOL) {
				SkkExprNode* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = funcall;
				_tmp9_ = (*_tmp8_).data;
				if (g_strcmp0 (_tmp9_, "concat") == 0) {
					GString* builder = NULL;
					GString* _tmp10_;
					GString* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp10_ = g_string_new ("");
					builder = _tmp10_;
					while (TRUE) {
						GeeListIterator* _tmp11_;
						SkkExprNode* arg = NULL;
						GeeListIterator* _tmp12_;
						gpointer _tmp13_;
						SkkExprNode* _tmp14_;
						_tmp11_ = iter;
						if (!gee_iterator_next ((GeeIterator*) _tmp11_)) {
							break;
						}
						_tmp12_ = iter;
						_tmp13_ = gee_iterator_get ((GeeIterator*) _tmp12_);
						arg = (SkkExprNode*) _tmp13_;
						_tmp14_ = arg;
						if ((*_tmp14_).type == SKK_EXPR_NODE_TYPE_STRING) {
							GString* _tmp15_;
							SkkExprNode* _tmp16_;
							const gchar* _tmp17_;
							_tmp15_ = builder;
							_tmp16_ = arg;
							_tmp17_ = (*_tmp16_).data;
							g_string_append (_tmp15_, _tmp17_);
						}
						_skk_expr_node_free0 (arg);
					}
					_tmp18_ = builder;
					_tmp19_ = _tmp18_->str;
					_tmp20_ = g_strdup (_tmp19_);
					result = _tmp20_;
					_g_string_free0 (builder);
					_skk_expr_node_free0 (funcall);
					_g_object_unref0 (iter);
					return result;
				} else {
					SkkExprNode* _tmp21_;
					const gchar* _tmp22_;
					_tmp21_ = funcall;
					_tmp22_ = (*_tmp21_).data;
					if (g_strcmp0 (_tmp22_, "current-time-string") == 0) {
						GDateTime* datetime = NULL;
						GDateTime* _tmp23_;
						GDateTime* _tmp24_;
						gchar* _tmp25_;
						_tmp23_ = g_date_time_new_now_local ();
						datetime = _tmp23_;
						_tmp24_ = datetime;
						_tmp25_ = g_date_time_format (_tmp24_, "%a, %d %b %Y %T %z");
						result = _tmp25_;
						_g_date_time_unref0 (datetime);
						_skk_expr_node_free0 (funcall);
						_g_object_unref0 (iter);
						return result;
					} else {
						SkkExprNode* _tmp26_;
						const gchar* _tmp27_;
						_tmp26_ = funcall;
						_tmp27_ = (*_tmp26_).data;
						if (g_strcmp0 (_tmp27_, "pwd") == 0) {
							gchar* _tmp28_;
							_tmp28_ = g_get_current_dir ();
							result = _tmp28_;
							_skk_expr_node_free0 (funcall);
							_g_object_unref0 (iter);
							return result;
						} else {
							SkkExprNode* _tmp29_;
							const gchar* _tmp30_;
							_tmp29_ = funcall;
							_tmp30_ = (*_tmp29_).data;
							if (g_strcmp0 (_tmp30_, "skk-version") == 0) {
								gchar* _tmp31_;
								_tmp31_ = g_strdup_printf ("%s/%s", PACKAGE_NAME, PACKAGE_VERSION);
								result = _tmp31_;
								_skk_expr_node_free0 (funcall);
								_g_object_unref0 (iter);
								return result;
							}
						}
					}
				}
			}
			_skk_expr_node_free0 (funcall);
		}
		_g_object_unref0 (iter);
	}
	result = NULL;
	return result;
}

SkkExprEvaluator*
skk_expr_evaluator_construct (GType object_type)
{
	SkkExprEvaluator * self = NULL;
	self = (SkkExprEvaluator*) g_object_new (object_type, NULL);
	return self;
}

SkkExprEvaluator*
skk_expr_evaluator_new (void)
{
	return skk_expr_evaluator_construct (SKK_TYPE_EXPR_EVALUATOR);
}

static void
skk_expr_evaluator_class_init (SkkExprEvaluatorClass * klass,
                               gpointer klass_data)
{
	skk_expr_evaluator_parent_class = g_type_class_peek_parent (klass);
}

static void
skk_expr_evaluator_instance_init (SkkExprEvaluator * self,
                                  gpointer klass)
{
}

static GType
skk_expr_evaluator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkExprEvaluatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_expr_evaluator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkExprEvaluator), 0, (GInstanceInitFunc) skk_expr_evaluator_instance_init, NULL };
	GType skk_expr_evaluator_type_id;
	skk_expr_evaluator_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkExprEvaluator", &g_define_type_info, 0);
	return skk_expr_evaluator_type_id;
}

GType
skk_expr_evaluator_get_type (void)
{
	static volatile gsize skk_expr_evaluator_type_id__once = 0;
	if (g_once_init_enter (&skk_expr_evaluator_type_id__once)) {
		GType skk_expr_evaluator_type_id;
		skk_expr_evaluator_type_id = skk_expr_evaluator_get_type_once ();
		g_once_init_leave (&skk_expr_evaluator_type_id__once, skk_expr_evaluator_type_id);
	}
	return skk_expr_evaluator_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

