/* map-file.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from map-file.vala, do not modify */

/*
 * Copyright (C) 2011-2026 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2026 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <json-glib/json-glib.h>
#include "libskk/libskk.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SKK_TYPE_MAP_FILE (skk_map_file_get_type ())
#define SKK_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_MAP_FILE, SkkMapFile))
#define SKK_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_MAP_FILE, SkkMapFileClass))
#define SKK_IS_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_MAP_FILE))
#define SKK_IS_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_MAP_FILE))
#define SKK_MAP_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_MAP_FILE, SkkMapFileClass))

typedef struct _SkkMapFile SkkMapFile;
typedef struct _SkkMapFileClass SkkMapFileClass;
typedef struct _SkkMapFilePrivate SkkMapFilePrivate;
enum  {
	SKK_MAP_FILE_0_PROPERTY,
	SKK_MAP_FILE_NUM_PROPERTIES
};
static GParamSpec* skk_map_file_properties[SKK_MAP_FILE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _skk_rule_metadata_free0(var) ((var == NULL) ? NULL : (var = (skk_rule_metadata_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

struct _SkkMapFile {
	GObject parent_instance;
	SkkMapFilePrivate * priv;
};

struct _SkkMapFileClass {
	GObjectClass parent_class;
};

struct _SkkMapFilePrivate {
	GeeMap* maps;
};

static gint SkkMapFile_private_offset;
static gpointer skk_map_file_parent_class = NULL;

VALA_EXTERN GType skk_map_file_get_type (void) G_GNUC_CONST ;
static void skk_map_file_load_map (SkkMapFile* self,
                            GeeMap* map,
                            JsonObject* object);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void _vala_JsonNode_free (JsonNode* self);
static void skk_map_file_load (SkkMapFile* self,
                        SkkRuleMetadata* metadata,
                        const gchar* type,
                        const gchar* name,
                        GeeSet* included,
                        GError** error);
VALA_EXTERN SkkMapFile* skk_map_file_construct (GType object_type,
                                    SkkRuleMetadata* metadata,
                                    const gchar* type,
                                    const gchar* name,
                                    GError** error);
VALA_EXTERN gboolean skk_map_file_has_map (SkkMapFile* self,
                               const gchar* name);
VALA_EXTERN GeeMap* skk_map_file_get (SkkMapFile* self,
                          const gchar* name);
static void skk_map_file_finalize (GObject * obj);
static GType skk_map_file_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
skk_map_file_get_instance_private (SkkMapFile* self)
{
	return G_STRUCT_MEMBER_P (self, SkkMapFile_private_offset);
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static void
skk_map_file_load_map (SkkMapFile* self,
                       GeeMap* map,
                       JsonObject* object)
{
	GList* keys = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (map != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = json_object_get_members (object);
	keys = _tmp0_;
	_tmp1_ = keys;
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
		key_collection = _tmp1_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			const gchar* key = NULL;
			key = (const gchar*) key_it->data;
			{
				JsonNode* value = NULL;
				const gchar* _tmp2_;
				JsonNode* _tmp3_;
				JsonNode* _tmp4_;
				JsonNode* _tmp5_;
				_tmp2_ = key;
				_tmp3_ = json_object_get_member (object, _tmp2_);
				_tmp4_ = __vala_JsonNode_copy0 (_tmp3_);
				value = _tmp4_;
				_tmp5_ = value;
				if (json_node_get_node_type (_tmp5_) == JSON_NODE_NULL) {
					const gchar* _tmp6_;
					_tmp6_ = key;
					gee_map_unset (map, _tmp6_, NULL);
				} else {
					const gchar* _tmp7_;
					JsonNode* _tmp8_;
					_tmp7_ = key;
					_tmp8_ = value;
					gee_map_set (map, _tmp7_, _tmp8_);
				}
				__vala_JsonNode_free0 (value);
			}
		}
	}
	(keys == NULL) ? NULL : (keys = (g_list_free (keys), NULL));
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
skk_map_file_load (SkkMapFile* self,
                   SkkRuleMetadata* metadata,
                   const gchar* type,
                   const gchar* name,
                   GeeSet* included,
                   GError** error)
{
	gchar* filename = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	JsonParser* parser = NULL;
	JsonParser* _tmp4_;
	JsonNode* root = NULL;
	JsonParser* _tmp16_;
	JsonNode* _tmp17_;
	JsonNode* _tmp18_;
	JsonNode* _tmp19_;
	JsonObject* object = NULL;
	JsonNode* _tmp21_;
	JsonObject* _tmp22_;
	JsonObject* _tmp23_;
	JsonNode* member = NULL;
	JsonObject* _tmp24_;
	JsonObject* _tmp62_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (included != NULL);
	_tmp0_ = skk_rule_metadata_locate_map_file (metadata, type, name);
	filename = _tmp0_;
	_tmp1_ = filename;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		GError* _tmp3_;
		_tmp2_ = filename;
		_tmp3_ = g_error_new (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "no such file %s", _tmp2_);
		_inner_error0_ = _tmp3_;
		if (_inner_error0_->domain == SKK_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (filename);
			return;
		} else {
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp4_ = json_parser_new ();
	parser = _tmp4_;
	{
		gboolean _tmp5_ = FALSE;
		JsonParser* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = parser;
		_tmp7_ = filename;
		_tmp5_ = json_parser_load_from_file (_tmp6_, _tmp7_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (!_tmp5_) {
			GError* _tmp8_;
			_tmp8_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "");
			_inner_error0_ = _tmp8_;
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GError* _tmp14_;
		GError* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = filename;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		_tmp12_ = g_strdup_printf ("can't load %s: %s", _tmp9_, _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, _tmp13_);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		_inner_error0_ = _tmp15_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == SKK_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (parser);
			_g_free0 (filename);
			return;
		} else {
			_g_object_unref0 (parser);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp16_ = parser;
	_tmp17_ = json_parser_get_root (_tmp16_);
	_tmp18_ = __vala_JsonNode_copy0 (_tmp17_);
	root = _tmp18_;
	_tmp19_ = root;
	if (json_node_get_node_type (_tmp19_) != JSON_NODE_OBJECT) {
		GError* _tmp20_;
		_tmp20_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "root element must be an object");
		_inner_error0_ = _tmp20_;
		if (_inner_error0_->domain == SKK_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			__vala_JsonNode_free0 (root);
			_g_object_unref0 (parser);
			_g_free0 (filename);
			return;
		} else {
			__vala_JsonNode_free0 (root);
			_g_object_unref0 (parser);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp21_ = root;
	_tmp22_ = json_node_get_object (_tmp21_);
	_tmp23_ = _json_object_ref0 (_tmp22_);
	object = _tmp23_;
	_tmp24_ = object;
	if (json_object_has_member (_tmp24_, "include")) {
		JsonObject* _tmp25_;
		JsonNode* _tmp26_;
		JsonNode* _tmp27_;
		JsonNode* _tmp28_;
		JsonArray* include = NULL;
		JsonNode* _tmp30_;
		JsonArray* _tmp31_;
		JsonArray* _tmp32_;
		GList* elements = NULL;
		JsonArray* _tmp33_;
		GList* _tmp34_;
		GList* _tmp35_;
		_tmp25_ = object;
		_tmp26_ = json_object_get_member (_tmp25_, "include");
		_tmp27_ = __vala_JsonNode_copy0 (_tmp26_);
		__vala_JsonNode_free0 (member);
		member = _tmp27_;
		_tmp28_ = member;
		if (json_node_get_node_type (_tmp28_) != JSON_NODE_ARRAY) {
			GError* _tmp29_;
			_tmp29_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "\"include\" element must be an array");
			_inner_error0_ = _tmp29_;
			if (_inner_error0_->domain == SKK_RULE_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				__vala_JsonNode_free0 (member);
				_json_object_unref0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				return;
			} else {
				__vala_JsonNode_free0 (member);
				_json_object_unref0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp30_ = member;
		_tmp31_ = json_node_get_array (_tmp30_);
		_tmp32_ = _json_array_ref0 (_tmp31_);
		include = _tmp32_;
		_tmp33_ = include;
		_tmp34_ = json_array_get_elements (_tmp33_);
		elements = _tmp34_;
		_tmp35_ = elements;
		{
			GList* element_collection = NULL;
			GList* element_it = NULL;
			element_collection = _tmp35_;
			for (element_it = element_collection; element_it != NULL; element_it = element_it->next) {
				JsonNode* element = NULL;
				element = (JsonNode*) element_it->data;
				{
					gchar* parent = NULL;
					JsonNode* _tmp36_;
					const gchar* _tmp37_;
					gchar* _tmp38_;
					const gchar* _tmp39_;
					gchar* parent_rule = NULL;
					gchar* parent_name = NULL;
					gint index = 0;
					const gchar* _tmp40_;
					SkkRuleMetadata* parent_metadata = NULL;
					const gchar* _tmp53_;
					SkkRuleMetadata* _tmp54_;
					SkkRuleMetadata* _tmp55_;
					SkkRuleMetadata* _tmp58_;
					const gchar* _tmp59_;
					SkkRuleMetadata _tmp60_;
					const gchar* _tmp61_;
					_tmp36_ = element;
					_tmp37_ = json_node_get_string (_tmp36_);
					_tmp38_ = g_strdup (_tmp37_);
					parent = _tmp38_;
					_tmp39_ = parent;
					if (gee_collection_contains ((GeeCollection*) included, _tmp39_)) {
						_g_free0 (parent);
						continue;
					}
					_tmp40_ = parent;
					index = string_index_of (_tmp40_, "/", 0);
					if (index < 0) {
						SkkRuleMetadata _tmp41_;
						const gchar* _tmp42_;
						gchar* _tmp43_;
						const gchar* _tmp44_;
						gchar* _tmp45_;
						_tmp41_ = *metadata;
						_tmp42_ = _tmp41_.name;
						_tmp43_ = g_strdup (_tmp42_);
						_g_free0 (parent_rule);
						parent_rule = _tmp43_;
						_tmp44_ = parent;
						_tmp45_ = g_strdup (_tmp44_);
						_g_free0 (parent_name);
						parent_name = _tmp45_;
					} else {
						const gchar* _tmp46_;
						gchar* _tmp47_;
						const gchar* _tmp48_;
						const gchar* _tmp49_;
						gint _tmp50_;
						gint _tmp51_;
						gchar* _tmp52_;
						_tmp46_ = parent;
						_tmp47_ = string_slice (_tmp46_, (glong) 0, (glong) index);
						_g_free0 (parent_rule);
						parent_rule = _tmp47_;
						_tmp48_ = parent;
						_tmp49_ = parent;
						_tmp50_ = strlen (_tmp49_);
						_tmp51_ = _tmp50_;
						_tmp52_ = string_slice (_tmp48_, (glong) (index + 1), (glong) _tmp51_);
						_g_free0 (parent_name);
						parent_name = _tmp52_;
					}
					_tmp53_ = parent_rule;
					_tmp54_ = skk_rule_find_rule (_tmp53_);
					parent_metadata = _tmp54_;
					_tmp55_ = parent_metadata;
					if (_tmp55_ == NULL) {
						const gchar* _tmp56_;
						GError* _tmp57_;
						_tmp56_ = parent_rule;
						_tmp57_ = g_error_new (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "can't find rule %s", _tmp56_);
						_inner_error0_ = _tmp57_;
						if (_inner_error0_->domain == SKK_RULE_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_skk_rule_metadata_free0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							(elements == NULL) ? NULL : (elements = (g_list_free (elements), NULL));
							_json_array_unref0 (include);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							return;
						} else {
							_skk_rule_metadata_free0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							(elements == NULL) ? NULL : (elements = (g_list_free (elements), NULL));
							_json_array_unref0 (include);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					_tmp58_ = parent_metadata;
					_tmp59_ = parent_name;
					_tmp60_ = *_tmp58_;
					skk_map_file_load (self, &_tmp60_, type, _tmp59_, included, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == SKK_RULE_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_skk_rule_metadata_free0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							(elements == NULL) ? NULL : (elements = (g_list_free (elements), NULL));
							_json_array_unref0 (include);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							return;
						} else {
							_skk_rule_metadata_free0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							(elements == NULL) ? NULL : (elements = (g_list_free (elements), NULL));
							_json_array_unref0 (include);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					_tmp61_ = parent;
					gee_collection_add ((GeeCollection*) included, _tmp61_);
					_skk_rule_metadata_free0 (parent_metadata);
					_g_free0 (parent_name);
					_g_free0 (parent_rule);
					_g_free0 (parent);
				}
			}
		}
		(elements == NULL) ? NULL : (elements = (g_list_free (elements), NULL));
		_json_array_unref0 (include);
	}
	_tmp62_ = object;
	if (json_object_has_member (_tmp62_, "define")) {
		JsonObject* _tmp63_;
		JsonNode* _tmp64_;
		JsonNode* _tmp65_;
		JsonNode* _tmp66_;
		JsonObject* define = NULL;
		JsonNode* _tmp68_;
		JsonObject* _tmp69_;
		JsonObject* _tmp70_;
		GList* keys = NULL;
		JsonObject* _tmp71_;
		GList* _tmp72_;
		GList* _tmp73_;
		_tmp63_ = object;
		_tmp64_ = json_object_get_member (_tmp63_, "define");
		_tmp65_ = __vala_JsonNode_copy0 (_tmp64_);
		__vala_JsonNode_free0 (member);
		member = _tmp65_;
		_tmp66_ = member;
		if (json_node_get_node_type (_tmp66_) != JSON_NODE_OBJECT) {
			GError* _tmp67_;
			_tmp67_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "\"define\" element must be an object");
			_inner_error0_ = _tmp67_;
			if (_inner_error0_->domain == SKK_RULE_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				__vala_JsonNode_free0 (member);
				_json_object_unref0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				return;
			} else {
				__vala_JsonNode_free0 (member);
				_json_object_unref0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp68_ = member;
		_tmp69_ = json_node_get_object (_tmp68_);
		_tmp70_ = _json_object_ref0 (_tmp69_);
		define = _tmp70_;
		_tmp71_ = define;
		_tmp72_ = json_object_get_members (_tmp71_);
		keys = _tmp72_;
		_tmp73_ = keys;
		{
			GList* key_collection = NULL;
			GList* key_it = NULL;
			key_collection = _tmp73_;
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
				const gchar* key = NULL;
				key = (const gchar*) key_it->data;
				{
					GeeMap* _tmp74_;
					const gchar* _tmp75_;
					JsonObject* _tmp80_;
					const gchar* _tmp81_;
					JsonNode* _tmp82_;
					JsonNode* _tmp83_;
					JsonNode* _tmp84_;
					GeeMap* _tmp86_;
					const gchar* _tmp87_;
					gpointer _tmp88_;
					GeeMap* _tmp89_;
					JsonNode* _tmp90_;
					JsonObject* _tmp91_;
					_tmp74_ = self->priv->maps;
					_tmp75_ = key;
					if (!gee_map_has_key (_tmp74_, _tmp75_)) {
						GeeHashMap* map = NULL;
						GeeHashMap* _tmp76_;
						GeeMap* _tmp77_;
						const gchar* _tmp78_;
						GeeHashMap* _tmp79_;
						_tmp76_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, json_node_get_type (), (GBoxedCopyFunc) _vala_JsonNode_copy, (GDestroyNotify) _vala_JsonNode_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
						map = _tmp76_;
						_tmp77_ = self->priv->maps;
						_tmp78_ = key;
						_tmp79_ = map;
						gee_map_set (_tmp77_, _tmp78_, (GeeMap*) _tmp79_);
						_g_object_unref0 (map);
					}
					_tmp80_ = define;
					_tmp81_ = key;
					_tmp82_ = json_object_get_member (_tmp80_, _tmp81_);
					_tmp83_ = __vala_JsonNode_copy0 (_tmp82_);
					__vala_JsonNode_free0 (member);
					member = _tmp83_;
					_tmp84_ = member;
					if (json_node_get_node_type (_tmp84_) != JSON_NODE_OBJECT) {
						GError* _tmp85_;
						_tmp85_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "map element must be an object");
						_inner_error0_ = _tmp85_;
						if (_inner_error0_->domain == SKK_RULE_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							(keys == NULL) ? NULL : (keys = (g_list_free (keys), NULL));
							_json_object_unref0 (define);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							return;
						} else {
							(keys == NULL) ? NULL : (keys = (g_list_free (keys), NULL));
							_json_object_unref0 (define);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					_tmp86_ = self->priv->maps;
					_tmp87_ = key;
					_tmp88_ = gee_map_get (_tmp86_, _tmp87_);
					_tmp89_ = (GeeMap*) _tmp88_;
					_tmp90_ = member;
					_tmp91_ = json_node_get_object (_tmp90_);
					skk_map_file_load_map (self, _tmp89_, _tmp91_);
					_g_object_unref0 (_tmp89_);
				}
			}
		}
		(keys == NULL) ? NULL : (keys = (g_list_free (keys), NULL));
		_json_object_unref0 (define);
	}
	__vala_JsonNode_free0 (member);
	_json_object_unref0 (object);
	__vala_JsonNode_free0 (root);
	_g_object_unref0 (parser);
	_g_free0 (filename);
}

SkkMapFile*
skk_map_file_construct (GType object_type,
                        SkkRuleMetadata* metadata,
                        const gchar* type,
                        const gchar* name,
                        GError** error)
{
	SkkMapFile * self = NULL;
	GeeSet* included = NULL;
	GeeHashSet* _tmp0_;
	SkkRuleMetadata _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (metadata != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (SkkMapFile*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	included = (GeeSet*) _tmp0_;
	_tmp1_ = *metadata;
	skk_map_file_load (self, &_tmp1_, type, name, included, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == SKK_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (included);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (included);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_g_object_unref0 (included);
	return self;
}

gboolean
skk_map_file_has_map (SkkMapFile* self,
                      const gchar* name)
{
	GeeMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->maps;
	result = gee_map_has_key (_tmp0_, name);
	return result;
}

GeeMap*
skk_map_file_get (SkkMapFile* self,
                  const gchar* name)
{
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	GeeMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->maps;
	_tmp1_ = gee_map_get (_tmp0_, name);
	result = (GeeMap*) _tmp1_;
	return result;
}

static void
skk_map_file_class_init (SkkMapFileClass * klass,
                         gpointer klass_data)
{
	skk_map_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SkkMapFile_private_offset);
	G_OBJECT_CLASS (klass)->finalize = skk_map_file_finalize;
}

static void
skk_map_file_instance_init (SkkMapFile * self,
                            gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = skk_map_file_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_MAP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->maps = (GeeMap*) _tmp0_;
}

static void
skk_map_file_finalize (GObject * obj)
{
	SkkMapFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_MAP_FILE, SkkMapFile);
	_g_object_unref0 (self->priv->maps);
	G_OBJECT_CLASS (skk_map_file_parent_class)->finalize (obj);
}

static GType
skk_map_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkMapFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_map_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkMapFile), 0, (GInstanceInitFunc) skk_map_file_instance_init, NULL };
	GType skk_map_file_type_id;
	skk_map_file_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkMapFile", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SkkMapFile_private_offset = g_type_add_instance_private (skk_map_file_type_id, sizeof (SkkMapFilePrivate));
	return skk_map_file_type_id;
}

GType
skk_map_file_get_type (void)
{
	static volatile gsize skk_map_file_type_id__once = 0;
	if (g_once_init_enter (&skk_map_file_type_id__once)) {
		GType skk_map_file_type_id;
		skk_map_file_type_id = skk_map_file_get_type_once ();
		g_once_init_leave (&skk_map_file_type_id__once, skk_map_file_type_id);
	}
	return skk_map_file_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

