// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

#[cfg(feature = "v4_18")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_18")))]
use crate::ListTabBehavior;
use crate::{
    Accessible, AccessibleRole, Adjustment, Align, Buildable, ConstraintTarget, LayoutManager,
    ListBoxRow, MovementStep, Overflow, SelectionMode, Widget, ffi,
};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkListBox")]
    pub struct ListBox(Object<ffi::GtkListBox>) @extends Widget, @implements Accessible, Buildable, ConstraintTarget;

    match fn {
        type_ => || ffi::gtk_list_box_get_type(),
    }
}

impl ListBox {
    #[doc(alias = "gtk_list_box_new")]
    pub fn new() -> ListBox {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_list_box_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`ListBox`] objects.
    ///
    /// This method returns an instance of [`ListBoxBuilder`](crate::builders::ListBoxBuilder) which can be used to create [`ListBox`] objects.
    pub fn builder() -> ListBoxBuilder {
        ListBoxBuilder::new()
    }

    #[doc(alias = "gtk_list_box_append")]
    pub fn append(&self, child: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_list_box_append(self.to_glib_none().0, child.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_list_box_bind_model")]
    pub fn bind_model<P: Fn(&glib::Object) -> Widget + 'static>(
        &self,
        model: Option<&impl IsA<gio::ListModel>>,
        create_widget_func: P,
    ) {
        let create_widget_func_data: Box_<P> = Box_::new(create_widget_func);
        unsafe extern "C" fn create_widget_func_func<P: Fn(&glib::Object) -> Widget + 'static>(
            item: *mut glib::gobject_ffi::GObject,
            user_data: glib::ffi::gpointer,
        ) -> *mut ffi::GtkWidget {
            unsafe {
                let item = from_glib_borrow(item);
                let callback = &*(user_data as *mut P);
                (*callback)(&item).to_glib_full()
            }
        }
        let create_widget_func = Some(create_widget_func_func::<P> as _);
        unsafe extern "C" fn user_data_free_func_func<P: Fn(&glib::Object) -> Widget + 'static>(
            data: glib::ffi::gpointer,
        ) {
            unsafe {
                let _callback = Box_::from_raw(data as *mut P);
            }
        }
        let destroy_call4 = Some(user_data_free_func_func::<P> as _);
        let super_callback0: Box_<P> = create_widget_func_data;
        unsafe {
            ffi::gtk_list_box_bind_model(
                self.to_glib_none().0,
                model.map(|p| p.as_ref()).to_glib_none().0,
                create_widget_func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call4,
            );
        }
    }

    #[doc(alias = "gtk_list_box_drag_highlight_row")]
    pub fn drag_highlight_row(&self, row: &impl IsA<ListBoxRow>) {
        unsafe {
            ffi::gtk_list_box_drag_highlight_row(
                self.to_glib_none().0,
                row.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_list_box_drag_unhighlight_row")]
    pub fn drag_unhighlight_row(&self) {
        unsafe {
            ffi::gtk_list_box_drag_unhighlight_row(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_list_box_get_activate_on_single_click")]
    #[doc(alias = "get_activate_on_single_click")]
    #[doc(alias = "activate-on-single-click")]
    pub fn activates_on_single_click(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_list_box_get_activate_on_single_click(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_list_box_get_adjustment")]
    #[doc(alias = "get_adjustment")]
    pub fn adjustment(&self) -> Option<Adjustment> {
        unsafe { from_glib_none(ffi::gtk_list_box_get_adjustment(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_list_box_get_row_at_index")]
    #[doc(alias = "get_row_at_index")]
    pub fn row_at_index(&self, index_: i32) -> Option<ListBoxRow> {
        unsafe {
            from_glib_none(ffi::gtk_list_box_get_row_at_index(
                self.to_glib_none().0,
                index_,
            ))
        }
    }

    #[doc(alias = "gtk_list_box_get_row_at_y")]
    #[doc(alias = "get_row_at_y")]
    pub fn row_at_y(&self, y: i32) -> Option<ListBoxRow> {
        unsafe { from_glib_none(ffi::gtk_list_box_get_row_at_y(self.to_glib_none().0, y)) }
    }

    #[doc(alias = "gtk_list_box_get_selected_row")]
    #[doc(alias = "get_selected_row")]
    pub fn selected_row(&self) -> Option<ListBoxRow> {
        unsafe { from_glib_none(ffi::gtk_list_box_get_selected_row(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_list_box_get_selected_rows")]
    #[doc(alias = "get_selected_rows")]
    pub fn selected_rows(&self) -> Vec<ListBoxRow> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_list_box_get_selected_rows(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_list_box_get_selection_mode")]
    #[doc(alias = "get_selection_mode")]
    #[doc(alias = "selection-mode")]
    pub fn selection_mode(&self) -> SelectionMode {
        unsafe { from_glib(ffi::gtk_list_box_get_selection_mode(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_list_box_get_show_separators")]
    #[doc(alias = "get_show_separators")]
    #[doc(alias = "show-separators")]
    pub fn shows_separators(&self) -> bool {
        unsafe { from_glib(ffi::gtk_list_box_get_show_separators(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v4_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_18")))]
    #[doc(alias = "gtk_list_box_get_tab_behavior")]
    #[doc(alias = "get_tab_behavior")]
    #[doc(alias = "tab-behavior")]
    pub fn tab_behavior(&self) -> ListTabBehavior {
        unsafe { from_glib(ffi::gtk_list_box_get_tab_behavior(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_list_box_insert")]
    pub fn insert(&self, child: &impl IsA<Widget>, position: i32) {
        unsafe {
            ffi::gtk_list_box_insert(
                self.to_glib_none().0,
                child.as_ref().to_glib_none().0,
                position,
            );
        }
    }

    #[doc(alias = "gtk_list_box_invalidate_filter")]
    pub fn invalidate_filter(&self) {
        unsafe {
            ffi::gtk_list_box_invalidate_filter(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_list_box_invalidate_headers")]
    pub fn invalidate_headers(&self) {
        unsafe {
            ffi::gtk_list_box_invalidate_headers(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_list_box_invalidate_sort")]
    pub fn invalidate_sort(&self) {
        unsafe {
            ffi::gtk_list_box_invalidate_sort(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_list_box_prepend")]
    pub fn prepend(&self, child: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_list_box_prepend(self.to_glib_none().0, child.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_list_box_remove")]
    pub fn remove(&self, child: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_list_box_remove(self.to_glib_none().0, child.as_ref().to_glib_none().0);
        }
    }

    #[cfg(feature = "v4_12")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_12")))]
    #[doc(alias = "gtk_list_box_remove_all")]
    pub fn remove_all(&self) {
        unsafe {
            ffi::gtk_list_box_remove_all(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_list_box_select_all")]
    pub fn select_all(&self) {
        unsafe {
            ffi::gtk_list_box_select_all(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_list_box_select_row")]
    pub fn select_row(&self, row: Option<&impl IsA<ListBoxRow>>) {
        unsafe {
            ffi::gtk_list_box_select_row(
                self.to_glib_none().0,
                row.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_list_box_selected_foreach")]
    pub fn selected_foreach<P: FnMut(&ListBox, &ListBoxRow)>(&self, func: P) {
        let mut func_data: P = func;
        unsafe extern "C" fn func_func<P: FnMut(&ListBox, &ListBoxRow)>(
            box_: *mut ffi::GtkListBox,
            row: *mut ffi::GtkListBoxRow,
            user_data: glib::ffi::gpointer,
        ) {
            unsafe {
                let box_ = from_glib_borrow(box_);
                let row = from_glib_borrow(row);
                let callback = user_data as *mut P;
                (*callback)(&box_, &row)
            }
        }
        let func = Some(func_func::<P> as _);
        let super_callback0: &mut P = &mut func_data;
        unsafe {
            ffi::gtk_list_box_selected_foreach(
                self.to_glib_none().0,
                func,
                super_callback0 as *mut _ as *mut _,
            );
        }
    }

    #[doc(alias = "gtk_list_box_set_activate_on_single_click")]
    #[doc(alias = "activate-on-single-click")]
    pub fn set_activate_on_single_click(&self, single: bool) {
        unsafe {
            ffi::gtk_list_box_set_activate_on_single_click(
                self.to_glib_none().0,
                single.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_list_box_set_adjustment")]
    pub fn set_adjustment(&self, adjustment: Option<&impl IsA<Adjustment>>) {
        unsafe {
            ffi::gtk_list_box_set_adjustment(
                self.to_glib_none().0,
                adjustment.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_list_box_set_filter_func")]
    pub fn set_filter_func<P: Fn(&ListBoxRow) -> bool + 'static>(&self, filter_func: P) {
        let filter_func_data: Box_<P> = Box_::new(filter_func);
        unsafe extern "C" fn filter_func_func<P: Fn(&ListBoxRow) -> bool + 'static>(
            row: *mut ffi::GtkListBoxRow,
            user_data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            unsafe {
                let row = from_glib_borrow(row);
                let callback = &*(user_data as *mut P);
                (*callback)(&row).into_glib()
            }
        }
        let filter_func = Some(filter_func_func::<P> as _);
        unsafe extern "C" fn destroy_func<P: Fn(&ListBoxRow) -> bool + 'static>(
            data: glib::ffi::gpointer,
        ) {
            unsafe {
                let _callback = Box_::from_raw(data as *mut P);
            }
        }
        let destroy_call3 = Some(destroy_func::<P> as _);
        let super_callback0: Box_<P> = filter_func_data;
        unsafe {
            ffi::gtk_list_box_set_filter_func(
                self.to_glib_none().0,
                filter_func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    #[doc(alias = "gtk_list_box_set_header_func")]
    pub fn set_header_func<P: Fn(&ListBoxRow, Option<&ListBoxRow>) + 'static>(
        &self,
        update_header: P,
    ) {
        let update_header_data: Box_<P> = Box_::new(update_header);
        unsafe extern "C" fn update_header_func<
            P: Fn(&ListBoxRow, Option<&ListBoxRow>) + 'static,
        >(
            row: *mut ffi::GtkListBoxRow,
            before: *mut ffi::GtkListBoxRow,
            user_data: glib::ffi::gpointer,
        ) {
            unsafe {
                let row = from_glib_borrow(row);
                let before: Borrowed<Option<ListBoxRow>> = from_glib_borrow(before);
                let callback = &*(user_data as *mut P);
                (*callback)(&row, before.as_ref().as_ref())
            }
        }
        let update_header = Some(update_header_func::<P> as _);
        unsafe extern "C" fn destroy_func<P: Fn(&ListBoxRow, Option<&ListBoxRow>) + 'static>(
            data: glib::ffi::gpointer,
        ) {
            unsafe {
                let _callback = Box_::from_raw(data as *mut P);
            }
        }
        let destroy_call3 = Some(destroy_func::<P> as _);
        let super_callback0: Box_<P> = update_header_data;
        unsafe {
            ffi::gtk_list_box_set_header_func(
                self.to_glib_none().0,
                update_header,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    #[doc(alias = "gtk_list_box_set_placeholder")]
    pub fn set_placeholder(&self, placeholder: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_list_box_set_placeholder(
                self.to_glib_none().0,
                placeholder.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_list_box_set_selection_mode")]
    #[doc(alias = "selection-mode")]
    pub fn set_selection_mode(&self, mode: SelectionMode) {
        unsafe {
            ffi::gtk_list_box_set_selection_mode(self.to_glib_none().0, mode.into_glib());
        }
    }

    #[doc(alias = "gtk_list_box_set_show_separators")]
    #[doc(alias = "show-separators")]
    pub fn set_show_separators(&self, show_separators: bool) {
        unsafe {
            ffi::gtk_list_box_set_show_separators(
                self.to_glib_none().0,
                show_separators.into_glib(),
            );
        }
    }

    #[cfg(feature = "v4_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_18")))]
    #[doc(alias = "gtk_list_box_set_tab_behavior")]
    #[doc(alias = "tab-behavior")]
    pub fn set_tab_behavior(&self, behavior: ListTabBehavior) {
        unsafe {
            ffi::gtk_list_box_set_tab_behavior(self.to_glib_none().0, behavior.into_glib());
        }
    }

    #[doc(alias = "gtk_list_box_unselect_all")]
    pub fn unselect_all(&self) {
        unsafe {
            ffi::gtk_list_box_unselect_all(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_list_box_unselect_row")]
    pub fn unselect_row(&self, row: &impl IsA<ListBoxRow>) {
        unsafe {
            ffi::gtk_list_box_unselect_row(self.to_glib_none().0, row.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "accept-unpaired-release")]
    pub fn accepts_unpaired_release(&self) -> bool {
        ObjectExt::property(self, "accept-unpaired-release")
    }

    #[doc(alias = "accept-unpaired-release")]
    pub fn set_accept_unpaired_release(&self, accept_unpaired_release: bool) {
        ObjectExt::set_property(self, "accept-unpaired-release", accept_unpaired_release)
    }

    #[doc(alias = "activate-cursor-row")]
    pub fn connect_activate_cursor_row<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn activate_cursor_row_trampoline<F: Fn(&ListBox) + 'static>(
            this: *mut ffi::GtkListBox,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"activate-cursor-row".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    activate_cursor_row_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_activate_cursor_row(&self) {
        self.emit_by_name::<()>("activate-cursor-row", &[]);
    }

    #[doc(alias = "move-cursor")]
    pub fn connect_move_cursor<F: Fn(&Self, MovementStep, i32, bool, bool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_cursor_trampoline<
            F: Fn(&ListBox, MovementStep, i32, bool, bool) + 'static,
        >(
            this: *mut ffi::GtkListBox,
            step: ffi::GtkMovementStep,
            count: std::ffi::c_int,
            extend: glib::ffi::gboolean,
            modify: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    &from_glib_borrow(this),
                    from_glib(step),
                    count,
                    from_glib(extend),
                    from_glib(modify),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"move-cursor".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    move_cursor_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_move_cursor(&self, step: MovementStep, count: i32, extend: bool, modify: bool) {
        self.emit_by_name::<()>("move-cursor", &[&step, &count, &extend, &modify]);
    }

    #[doc(alias = "row-activated")]
    pub fn connect_row_activated<F: Fn(&Self, &ListBoxRow) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn row_activated_trampoline<F: Fn(&ListBox, &ListBoxRow) + 'static>(
            this: *mut ffi::GtkListBox,
            row: *mut ffi::GtkListBoxRow,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this), &from_glib_borrow(row))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"row-activated".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    row_activated_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "row-selected")]
    pub fn connect_row_selected<F: Fn(&Self, Option<&ListBoxRow>) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn row_selected_trampoline<
            F: Fn(&ListBox, Option<&ListBoxRow>) + 'static,
        >(
            this: *mut ffi::GtkListBox,
            row: *mut ffi::GtkListBoxRow,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    &from_glib_borrow(this),
                    Option::<ListBoxRow>::from_glib_borrow(row)
                        .as_ref()
                        .as_ref(),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"row-selected".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    row_selected_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "select-all")]
    pub fn connect_select_all<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn select_all_trampoline<F: Fn(&ListBox) + 'static>(
            this: *mut ffi::GtkListBox,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"select-all".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    select_all_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_select_all(&self) {
        self.emit_by_name::<()>("select-all", &[]);
    }

    #[doc(alias = "selected-rows-changed")]
    pub fn connect_selected_rows_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn selected_rows_changed_trampoline<F: Fn(&ListBox) + 'static>(
            this: *mut ffi::GtkListBox,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"selected-rows-changed".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    selected_rows_changed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "toggle-cursor-row")]
    pub fn connect_toggle_cursor_row<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn toggle_cursor_row_trampoline<F: Fn(&ListBox) + 'static>(
            this: *mut ffi::GtkListBox,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"toggle-cursor-row".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    toggle_cursor_row_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_toggle_cursor_row(&self) {
        self.emit_by_name::<()>("toggle-cursor-row", &[]);
    }

    #[doc(alias = "unselect-all")]
    pub fn connect_unselect_all<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn unselect_all_trampoline<F: Fn(&ListBox) + 'static>(
            this: *mut ffi::GtkListBox,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"unselect-all".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    unselect_all_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_unselect_all(&self) {
        self.emit_by_name::<()>("unselect-all", &[]);
    }

    #[doc(alias = "accept-unpaired-release")]
    pub fn connect_accept_unpaired_release_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_accept_unpaired_release_trampoline<
            F: Fn(&ListBox) + 'static,
        >(
            this: *mut ffi::GtkListBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::accept-unpaired-release".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_accept_unpaired_release_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "activate-on-single-click")]
    pub fn connect_activate_on_single_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_activate_on_single_click_trampoline<
            F: Fn(&ListBox) + 'static,
        >(
            this: *mut ffi::GtkListBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::activate-on-single-click".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_activate_on_single_click_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "selection-mode")]
    pub fn connect_selection_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_selection_mode_trampoline<F: Fn(&ListBox) + 'static>(
            this: *mut ffi::GtkListBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::selection-mode".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_selection_mode_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "show-separators")]
    pub fn connect_show_separators_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_separators_trampoline<F: Fn(&ListBox) + 'static>(
            this: *mut ffi::GtkListBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::show-separators".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_show_separators_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_18")))]
    #[doc(alias = "tab-behavior")]
    pub fn connect_tab_behavior_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tab_behavior_trampoline<F: Fn(&ListBox) + 'static>(
            this: *mut ffi::GtkListBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::tab-behavior".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_tab_behavior_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for ListBox {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`ListBox`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct ListBoxBuilder {
    builder: glib::object::ObjectBuilder<'static, ListBox>,
}

impl ListBoxBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn accept_unpaired_release(self, accept_unpaired_release: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("accept-unpaired-release", accept_unpaired_release),
        }
    }

    pub fn activate_on_single_click(self, activate_on_single_click: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("activate-on-single-click", activate_on_single_click),
        }
    }

    pub fn selection_mode(self, selection_mode: SelectionMode) -> Self {
        Self {
            builder: self.builder.property("selection-mode", selection_mode),
        }
    }

    pub fn show_separators(self, show_separators: bool) -> Self {
        Self {
            builder: self.builder.property("show-separators", show_separators),
        }
    }

    #[cfg(feature = "v4_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_18")))]
    pub fn tab_behavior(self, tab_behavior: ListTabBehavior) -> Self {
        Self {
            builder: self.builder.property("tab-behavior", tab_behavior),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    #[cfg(feature = "v4_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_18")))]
    pub fn limit_events(self, limit_events: bool) -> Self {
        Self {
            builder: self.builder.property("limit-events", limit_events),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`ListBox`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> ListBox {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
