// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"math"
	"sync"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolSummaryDataPoint_ValueAtQuantile = sync.Pool{
		New: func() any {
			return &otlpmetrics.SummaryDataPoint_ValueAtQuantile{}
		},
	}
)

func NewOrigSummaryDataPoint_ValueAtQuantile() *otlpmetrics.SummaryDataPoint_ValueAtQuantile {
	if !UseProtoPooling.IsEnabled() {
		return &otlpmetrics.SummaryDataPoint_ValueAtQuantile{}
	}
	return protoPoolSummaryDataPoint_ValueAtQuantile.Get().(*otlpmetrics.SummaryDataPoint_ValueAtQuantile)
}

func DeleteOrigSummaryDataPoint_ValueAtQuantile(orig *otlpmetrics.SummaryDataPoint_ValueAtQuantile, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolSummaryDataPoint_ValueAtQuantile.Put(orig)
	}
}

func CopyOrigSummaryDataPoint_ValueAtQuantile(dest, src *otlpmetrics.SummaryDataPoint_ValueAtQuantile) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.Quantile = src.Quantile
	dest.Value = src.Value
}

func GenTestOrigSummaryDataPoint_ValueAtQuantile() *otlpmetrics.SummaryDataPoint_ValueAtQuantile {
	orig := NewOrigSummaryDataPoint_ValueAtQuantile()
	orig.Quantile = float64(3.1415926)
	orig.Value = float64(3.1415926)
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigSummaryDataPoint_ValueAtQuantile(orig *otlpmetrics.SummaryDataPoint_ValueAtQuantile, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.Quantile != float64(0) {
		dest.WriteObjectField("quantile")
		dest.WriteFloat64(orig.Quantile)
	}
	if orig.Value != float64(0) {
		dest.WriteObjectField("value")
		dest.WriteFloat64(orig.Value)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigSummaryDataPointValueAtQuantile unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigSummaryDataPoint_ValueAtQuantile(orig *otlpmetrics.SummaryDataPoint_ValueAtQuantile, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "quantile":
			orig.Quantile = iter.ReadFloat64()
		case "value":
			orig.Value = iter.ReadFloat64()
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigSummaryDataPoint_ValueAtQuantile(orig *otlpmetrics.SummaryDataPoint_ValueAtQuantile) int {
	var n int
	var l int
	_ = l
	if orig.Quantile != 0 {
		n += 9
	}
	if orig.Value != 0 {
		n += 9
	}
	return n
}

func MarshalProtoOrigSummaryDataPoint_ValueAtQuantile(orig *otlpmetrics.SummaryDataPoint_ValueAtQuantile, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.Quantile != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Quantile))
		pos--
		buf[pos] = 0x9
	}
	if orig.Value != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Value))
		pos--
		buf[pos] = 0x11
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigSummaryDataPoint_ValueAtQuantile(orig *otlpmetrics.SummaryDataPoint_ValueAtQuantile, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quantile", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.Quantile = math.Float64frombits(num)

		case 2:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.Value = math.Float64frombits(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
