#include "src/objects/templates-inl.h"

#include "torque-generated/class-verifiers.h"
#include "src/objects/objects-inl.h"

#include "src/objects/instance-type-inl.h"

namespace v8 {
namespace internal {

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/templates.tq?l=11&c=1
bool IsTemplateInfo_NonInline(Tagged<HeapObject> o) {
  return IsTemplateInfo(o);
}

#ifdef VERIFY_HEAP

template <>
void TorqueGeneratedTemplateInfo<TemplateInfo, HeapObject>::TemplateInfoVerify(Isolate* isolate) {
  TorqueGeneratedClassVerifiers::TemplateInfoVerify(TrustedCast<TemplateInfo>(*this), isolate);
}


#endif  // VERIFY_HEAP
// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/templates.tq?l=16&c=1
bool IsTemplateInfoWithProperties_NonInline(Tagged<HeapObject> o) {
  return IsTemplateInfoWithProperties(o);
}

#ifdef VERIFY_HEAP

template <>
void TorqueGeneratedTemplateInfoWithProperties<TemplateInfoWithProperties, TemplateInfo>::TemplateInfoWithPropertiesVerify(Isolate* isolate) {
  TorqueGeneratedClassVerifiers::TemplateInfoWithPropertiesVerify(TrustedCast<TemplateInfoWithProperties>(*this), isolate);
}


#endif  // VERIFY_HEAP
// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/templates.tq?l=54&c=1
bool IsFunctionTemplateInfo_NonInline(Tagged<HeapObject> o) {
  return IsFunctionTemplateInfo(o);
}

#ifdef VERIFY_HEAP

template <>
void TorqueGeneratedFunctionTemplateInfo<FunctionTemplateInfo, TemplateInfoWithProperties>::FunctionTemplateInfoVerify(Isolate* isolate) {
  TorqueGeneratedClassVerifiers::FunctionTemplateInfoVerify(TrustedCast<FunctionTemplateInfo>(*this), isolate);
}


#endif  // VERIFY_HEAP
// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/templates.tq?l=23&c=1
bool IsFunctionTemplateRareData_NonInline(Tagged<HeapObject> o) {
  return IsFunctionTemplateRareData(o);
}

#ifdef VERIFY_HEAP

template <>
void TorqueGeneratedFunctionTemplateRareData<FunctionTemplateRareData, Struct>::FunctionTemplateRareDataVerify(Isolate* isolate) {
  TorqueGeneratedClassVerifiers::FunctionTemplateRareDataVerify(TrustedCast<FunctionTemplateRareData>(*this), isolate);
}


#endif  // VERIFY_HEAP
// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/templates.tq?l=114&c=1
bool IsObjectTemplateInfo_NonInline(Tagged<HeapObject> o) {
  return IsObjectTemplateInfo(o);
}

#ifdef VERIFY_HEAP

template <>
void TorqueGeneratedObjectTemplateInfo<ObjectTemplateInfo, TemplateInfoWithProperties>::ObjectTemplateInfoVerify(Isolate* isolate) {
  TorqueGeneratedClassVerifiers::ObjectTemplateInfoVerify(TrustedCast<ObjectTemplateInfo>(*this), isolate);
}


#endif  // VERIFY_HEAP
// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/objects/templates.tq?l=120&c=1
bool IsDictionaryTemplateInfo_NonInline(Tagged<HeapObject> o) {
  return IsDictionaryTemplateInfo(o);
}

#ifdef VERIFY_HEAP

template <>
void TorqueGeneratedDictionaryTemplateInfo<DictionaryTemplateInfo, TemplateInfo>::DictionaryTemplateInfoVerify(Isolate* isolate) {
  TorqueGeneratedClassVerifiers::DictionaryTemplateInfoVerify(TrustedCast<DictionaryTemplateInfo>(*this), isolate);
}


#endif  // VERIFY_HEAP
} // namespace internal
} // namespace v8
