// python wrapper for vtkTransferFunctionBoxItem
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSmartPointer.h"
#include "vtkTransferFunctionBoxItem.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkTransferFunctionBoxItem(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkTransferFunctionBoxItem_ClassNew(); }


static PyObject *
PyvtkTransferFunctionBoxItem_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkTransferFunctionBoxItem::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionBoxItem_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkTransferFunctionBoxItem::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionBoxItem_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkTransferFunctionBoxItem *tempr = vtkTransferFunctionBoxItem::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionBoxItem_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkTransferFunctionBoxItem *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkTransferFunctionBoxItem::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionBoxItem_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkTransferFunctionBoxItem::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionBoxItem_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkTransferFunctionBoxItem::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionBoxItem_GetBox(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const vtkRectd *tempr = (ap.IsBound() ?
      &op->GetBox() :
      &op->vtkTransferFunctionBoxItem::GetBox());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(tempr, "vtkRectd");
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionBoxItem_SetBox(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetBox(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkTransferFunctionBoxItem::SetBox(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionBoxItem_GetTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSmartPointer<vtkImageData> tempr = (ap.IsBound() ?
      op->GetTexture() :
      op->vtkTransferFunctionBoxItem::GetTexture());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionBoxItem_SetValidBounds_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetValidBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetValidBounds(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkTransferFunctionBoxItem::SetValidBounds(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkTransferFunctionBoxItem_SetValidBounds_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetValidBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  const size_t size0 = 4;
  double temp0[4];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetValidBounds(temp0);
    }
    else
    {
      op->vtkTransferFunctionBoxItem::SetValidBounds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkTransferFunctionBoxItem_SetValidBounds(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 4:
      return PyvtkTransferFunctionBoxItem_SetValidBounds_s1(self, args);
    case 1:
      return PyvtkTransferFunctionBoxItem_SetValidBounds_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetValidBounds");
  return nullptr;
}


static PyObject *
PyvtkTransferFunctionBoxItem_SetSelected(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelected");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSelected(temp0);
    }
    else
    {
      op->vtkTransferFunctionBoxItem::SetSelected(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionBoxItem_GetSelected(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelected");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSelected() :
      op->vtkTransferFunctionBoxItem::GetSelected());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionBoxItem_SelectedOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectedOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SelectedOn();
    }
    else
    {
      op->vtkTransferFunctionBoxItem::SelectedOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionBoxItem_SelectedOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectedOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SelectedOff();
    }
    else
    {
      op->vtkTransferFunctionBoxItem::SelectedOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionBoxItem_SetBoxColor_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBoxColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetBoxColor(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkTransferFunctionBoxItem::SetBoxColor(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkTransferFunctionBoxItem_SetBoxColor_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBoxColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  const size_t size0 = 4;
  double temp0[4];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetBoxColor(temp0);
    }
    else
    {
      op->vtkTransferFunctionBoxItem::SetBoxColor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkTransferFunctionBoxItem_SetBoxColor(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 4:
      return PyvtkTransferFunctionBoxItem_SetBoxColor_s1(self, args);
    case 1:
      return PyvtkTransferFunctionBoxItem_SetBoxColor_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetBoxColor");
  return nullptr;
}


static PyObject *
PyvtkTransferFunctionBoxItem_GetBoxColor_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBoxColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  size_t sizer = 4;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetBoxColor() :
      op->vtkTransferFunctionBoxItem::GetBoxColor());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyObject *
PyvtkTransferFunctionBoxItem_GetBoxColor_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBoxColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->GetBoxColor(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkTransferFunctionBoxItem::GetBoxColor(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(0, temp0);
    }
    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(1, temp1);
    }
    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(2, temp2);
    }
    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(3, temp3);
    }
    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkTransferFunctionBoxItem_GetBoxColor_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBoxColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  const size_t size0 = 4;
  double temp0[4];
  double save0[4];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetBoxColor(temp0);
    }
    else
    {
      op->vtkTransferFunctionBoxItem::GetBoxColor(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkTransferFunctionBoxItem_GetBoxColor(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkTransferFunctionBoxItem_GetBoxColor_s1(self, args);
    case 4:
      return PyvtkTransferFunctionBoxItem_GetBoxColor_s2(self, args);
    case 1:
      return PyvtkTransferFunctionBoxItem_GetBoxColor_s3(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetBoxColor");
  return nullptr;
}


static PyObject *
PyvtkTransferFunctionBoxItem_SetTransferFunctionBox(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTransferFunctionBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  vtkPVTransferFunction2DBox *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVTransferFunction2DBox"))
  {
    if (ap.IsBound())
    {
      op->SetTransferFunctionBox(temp0);
    }
    else
    {
      op->vtkTransferFunctionBoxItem::SetTransferFunctionBox(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionBoxItem_GetTransferFunctionBox(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTransferFunctionBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVTransferFunction2DBox *tempr = (ap.IsBound() ?
      op->GetTransferFunctionBox() :
      op->vtkTransferFunctionBoxItem::GetTransferFunctionBox());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionBoxItem_SetID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetID(temp0);
    }
    else
    {
      op->vtkTransferFunctionBoxItem::SetID(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkTransferFunctionBoxItem_GetID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTransferFunctionBoxItem *op = static_cast<vtkTransferFunctionBoxItem *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetID() :
      op->vtkTransferFunctionBoxItem::GetID());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkTransferFunctionBoxItem_Methods[] = {
  {"IsTypeOf", PyvtkTransferFunctionBoxItem_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkTransferFunctionBoxItem_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkTransferFunctionBoxItem_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkTransferFunctionBoxItem\nC++: static vtkTransferFunctionBoxItem *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkTransferFunctionBoxItem_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkTransferFunctionBoxItem\nC++: vtkTransferFunctionBoxItem *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkTransferFunctionBoxItem_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkTransferFunctionBoxItem_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetBox", PyvtkTransferFunctionBoxItem_GetBox, METH_VARARGS,
   "GetBox(self) -> vtkRectd\nC++: const vtkRectd &GetBox()\n\nReturns the current box as [x0, y0, width, height].\n"},
  {"SetBox", PyvtkTransferFunctionBoxItem_SetBox, METH_VARARGS,
   "SetBox(self, x:float, y:float, width:float, height:float) -> None\nC++: void SetBox(double x, double y, double width, double height)\n\nSet position and width with respect to corner 0 (BOTTOM_LEFT).\n"},
  {"GetTexture", PyvtkTransferFunctionBoxItem_GetTexture, METH_VARARGS,
   "GetTexture(self) -> vtkImageData\nC++: vtkSmartPointer<vtkImageData> GetTexture()\n\nGet access to the texture of this box item\n"},
  {"SetValidBounds", PyvtkTransferFunctionBoxItem_SetValidBounds, METH_VARARGS,
   "SetValidBounds(self, x0:float, x1:float, y0:float, y1:float)\n    -> None\nC++: void SetValidBounds(double x0, double x1, double y0,\n    double y1) override;\nSetValidBounds(self, _arg:(float, float, float, float)) -> None\nC++: virtual void SetValidBounds(const double _arg[4])\n\nControls the valid range for the values. An invalid value (0, -1,\n0., -1, 0, -1.) indicates that the valid range is the current\nbounds. It is the default behavior.\n"},
  {"SetSelected", PyvtkTransferFunctionBoxItem_SetSelected, METH_VARARGS,
   "SetSelected(self, _arg:bool) -> None\nC++: virtual void SetSelected(bool _arg)\n\nSet/Get whether the box should be drawn selected.\n"},
  {"GetSelected", PyvtkTransferFunctionBoxItem_GetSelected, METH_VARARGS,
   "GetSelected(self) -> bool\nC++: virtual bool GetSelected()\n\n"},
  {"SelectedOn", PyvtkTransferFunctionBoxItem_SelectedOn, METH_VARARGS,
   "SelectedOn(self) -> None\nC++: virtual void SelectedOn()\n\n"},
  {"SelectedOff", PyvtkTransferFunctionBoxItem_SelectedOff, METH_VARARGS,
   "SelectedOff(self) -> None\nC++: virtual void SelectedOff()\n\n"},
  {"SetBoxColor", PyvtkTransferFunctionBoxItem_SetBoxColor, METH_VARARGS,
   "SetBoxColor(self, r:float, g:float, b:float, a:float) -> None\nC++: virtual void SetBoxColor(double r, double g, double b,\n    double a)\nSetBoxColor(self, c:(float, float, float, float)) -> None\nC++: virtual void SetBoxColor(const double c[4])\n\nSet/Get the color to be used for this box.\n"},
  {"GetBoxColor", PyvtkTransferFunctionBoxItem_GetBoxColor, METH_VARARGS,
   "GetBoxColor(self) -> (float, float, float, float)\nC++: double *GetBoxColor()\nGetBoxColor(self, r:float, g:float, b:float, a:float) -> None\nC++: virtual void GetBoxColor(double &r, double &g, double &b,\n    double &a)\nGetBoxColor(self, c:[float, float, float, float]) -> None\nC++: virtual void GetBoxColor(double c[4])\n\n"},
  {"SetTransferFunctionBox", PyvtkTransferFunctionBoxItem_SetTransferFunctionBox, METH_VARARGS,
   "SetTransferFunctionBox(self, b:vtkPVTransferFunction2DBox) -> None\nC++: void SetTransferFunctionBox(vtkPVTransferFunction2DBox *b)\n\nSet/Get the internal transfer function control box.\n"},
  {"GetTransferFunctionBox", PyvtkTransferFunctionBoxItem_GetTransferFunctionBox, METH_VARARGS,
   "GetTransferFunctionBox(self) -> vtkPVTransferFunction2DBox\nC++: vtkPVTransferFunction2DBox *GetTransferFunctionBox()\n\n"},
  {"SetID", PyvtkTransferFunctionBoxItem_SetID, METH_VARARGS,
   "SetID(self, _arg:int) -> None\nC++: virtual void SetID(int _arg)\n\nSet/Get an ID used to reference this item. This identifier is\nused by ParaView to update client/server proxy for the 2D\ntransfer function.\n"},
  {"GetID", PyvtkTransferFunctionBoxItem_GetID, METH_VARARGS,
   "GetID(self) -> int\nC++: virtual int GetID()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkTransferFunctionBoxItem_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("box"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkTransferFunctionBoxItem_SetBox(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkTransferFunctionBoxItem_SetBox(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBox\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("valid_bounds"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkTransferFunctionBoxItem_SetValidBounds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkTransferFunctionBoxItem_SetValidBounds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetValidBounds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("selected"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkTransferFunctionBoxItem_GetSelected(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkTransferFunctionBoxItem_SetSelected(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkTransferFunctionBoxItem_SetSelected(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSelected/SetSelected\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("box_color"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkTransferFunctionBoxItem_GetBoxColor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkTransferFunctionBoxItem_SetBoxColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkTransferFunctionBoxItem_SetBoxColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBoxColor/SetBoxColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("transfer_function_box"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkTransferFunctionBoxItem_GetTransferFunctionBox(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkTransferFunctionBoxItem_SetTransferFunctionBox(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkTransferFunctionBoxItem_SetTransferFunctionBox(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTransferFunctionBox/SetTransferFunctionBox\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkTransferFunctionBoxItem_GetID(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkTransferFunctionBoxItem_SetID(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkTransferFunctionBoxItem_SetID(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetID/SetID\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("box"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkTransferFunctionBoxItem_GetBox(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetBox\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("texture"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkTransferFunctionBoxItem_GetTexture(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTexture\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkTransferFunctionBoxItem_Doc =
  "vtkTransferFunctionBoxItem - no description provided.\n\n"
  "Superclass: vtkControlPointsItem\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkTransferFunctionBoxItem_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkTransferFunctionBoxItem", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkTransferFunctionBoxItem_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkTransferFunctionBoxItem_StaticNew()
{
  return vtkTransferFunctionBoxItem::New();
}

PyObject *PyvtkTransferFunctionBoxItem_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkTransferFunctionBoxItem_Type, PyvtkTransferFunctionBoxItem_Methods,
    "vtkTransferFunctionBoxItem",
 &PyvtkTransferFunctionBoxItem_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkControlPointsItem");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  for (int c = 0; c < 4; c++)
  {
    static const struct { const char *name; int value; }
      constants[4] = {
        { "BoxAddEvent", vtkTransferFunctionBoxItem::BoxAddEvent },
        { "BoxEditEvent", vtkTransferFunctionBoxItem::BoxEditEvent },
        { "BoxSelectEvent", vtkTransferFunctionBoxItem::BoxSelectEvent },
        { "BoxDeleteEvent", vtkTransferFunctionBoxItem::BoxDeleteEvent },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkTransferFunctionBoxItem_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkTransferFunctionBoxItem(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkTransferFunctionBoxItem_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkTransferFunctionBoxItem", o) != 0)
  {
    Py_DECREF(o);
  }

}

