
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_nbt.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
static PyTypeObject nbt_name_Type;
static PyTypeObject nbt_name_question_Type;
static PyTypeObject nbt_rdata_address_Type;
static PyTypeObject nbt_rdata_netbios_Type;
static PyTypeObject nbt_statistics_Type;
static PyTypeObject nbt_status_name_Type;
static PyTypeObject nbt_rdata_status_Type;
static PyTypeObject nbt_rdata_data_Type;
static PyTypeObject nbt_rdata_Type;
static PyTypeObject nbt_res_rec_Type;
static PyTypeObject nbt_name_packet_Type;
static PyTypeObject smb_trans_body_Type;
static PyTypeObject smb_body_Type;
static PyTypeObject dgram_smb_packet_Type;
static PyTypeObject dgram_message_body_Type;
static PyTypeObject dgram_message_Type;
static PyTypeObject dgram_data_Type;
static PyTypeObject nbt_dgram_packet_Type;
static PyTypeObject nbt_sockaddr_Type;
static PyTypeObject NETLOGON_SAM_LOGON_REQUEST_Type;
static PyTypeObject NETLOGON_LOGON_REQUEST_Type;
static PyTypeObject NETLOGON_SAM_LOGON_RESPONSE_NT40_Type;
static PyTypeObject NETLOGON_SAM_LOGON_RESPONSE_Type;
static PyTypeObject NETLOGON_SAM_LOGON_RESPONSE_EX_Type;
static PyTypeObject netlogon_samlogon_response_union_Type;
static PyTypeObject netlogon_samlogon_response_Type;
static PyTypeObject nbt_netlogon_query_for_pdc_Type;
static PyTypeObject nbt_netlogon_response_from_pdc_Type;
static PyTypeObject nbt_netlogon_response2_Type;
static PyTypeObject nbt_db_change_info_Type;
static PyTypeObject NETLOGON_DB_CHANGE_Type;
static PyTypeObject nbt_netlogon_request_Type;
static PyTypeObject nbt_netlogon_packet_Type;
static PyTypeObject nbt_browse_host_announcement_Type;
static PyTypeObject nbt_browse_announcement_request_Type;
static PyTypeObject nbt_browse_election_request_Type;
static PyTypeObject nbt_browse_backup_list_request_Type;
static PyTypeObject nbt_browse_backup_list_response_Type;
static PyTypeObject nbt_browse_become_backup_Type;
static PyTypeObject nbt_browse_domain_announcement_Type;
static PyTypeObject nbt_browse_master_announcement_Type;
static PyTypeObject nbt_browse_reset_state_Type;
static PyTypeObject nbt_browse_local_master_announcement_Type;
static PyTypeObject nbt_browse_payload_Type;
static PyTypeObject nbt_browse_packet_Type;
static PyTypeObject nbt_InterfaceType;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *GUID_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_nbt_name_get_name(PyObject *obj, void *closure)
{
	struct nbt_name *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = PyString_FromStringOrNULL(object->name);
	return py_name;
}

static int py_nbt_name_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->name = talloc_str;
	}
	return 0;
}

static PyObject *py_nbt_name_get_scope(PyObject *obj, void *closure)
{
	struct nbt_name *object = pytalloc_get_ptr(obj);
	PyObject *py_scope;
	py_scope = PyString_FromStringOrNULL(object->scope);
	return py_scope;
}

static int py_nbt_name_set_scope(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->scope");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->scope = talloc_str;
	}
	return 0;
}

static PyObject *py_nbt_name_get_type(PyObject *obj, void *closure)
{
	struct nbt_name *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromLong((uint16_t)(object->type));
	return py_type;
}

static int py_nbt_name_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_nbt_name_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_nbt_name_get_name,
		.set = py_nbt_name_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "scope"),
		.get = py_nbt_name_get_scope,
		.set = py_nbt_name_set_scope,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_nbt_name_get_type,
		.set = py_nbt_name_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_name_type")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_name_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_name, type);
}

static PyObject *py_nbt_name_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct nbt_name *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_nbt_name);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_nbt_name_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_name *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_name);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_name);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_nbt_name_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_name *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_name, "nbt_name", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_name, "nbt_name", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_nbt_name_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_nbt_name_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_name_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_name_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbt_name_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.name",
	.tp_getset = py_nbt_name_getsetters,
	.tp_methods = py_nbt_name_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_name_new,
};


static PyObject *py_nbt_name_question_get_name(PyObject *obj, void *closure)
{
	struct nbt_name_question *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&nbt_name_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_nbt_name_question_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_question *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	PY_CHECK_TYPE(&nbt_name_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct nbt_name *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_nbt_name_question_get_question_type(PyObject *obj, void *closure)
{
	struct nbt_name_question *object = pytalloc_get_ptr(obj);
	PyObject *py_question_type;
	py_question_type = PyLong_FromLong((uint16_t)(object->question_type));
	return py_question_type;
}

static int py_nbt_name_question_set_question_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_question *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->question_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->question_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->question_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_name_question_get_question_class(PyObject *obj, void *closure)
{
	struct nbt_name_question *object = pytalloc_get_ptr(obj);
	PyObject *py_question_class;
	py_question_class = PyLong_FromLong((uint16_t)(object->question_class));
	return py_question_class;
}

static int py_nbt_name_question_set_question_class(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_question *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->question_class");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->question_class));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->question_class = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_nbt_name_question_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_nbt_name_question_get_name,
		.set = py_nbt_name_question_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_name")
	},
	{
		.name = discard_const_p(char, "question_type"),
		.get = py_nbt_name_question_get_question_type,
		.set = py_nbt_name_question_set_question_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_qtype")
	},
	{
		.name = discard_const_p(char, "question_class"),
		.get = py_nbt_name_question_get_question_class,
		.set = py_nbt_name_question_set_question_class,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_qclass")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_name_question_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_name_question, type);
}


static PyTypeObject nbt_name_question_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.name_question",
	.tp_getset = py_nbt_name_question_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_name_question_new,
};


static PyObject *py_nbt_rdata_address_get_nb_flags(PyObject *obj, void *closure)
{
	struct nbt_rdata_address *object = pytalloc_get_ptr(obj);
	PyObject *py_nb_flags;
	py_nb_flags = PyLong_FromLong((uint16_t)(object->nb_flags));
	return py_nb_flags;
}

static int py_nbt_rdata_address_set_nb_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_address *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nb_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nb_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nb_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_rdata_address_get_ipaddr(PyObject *obj, void *closure)
{
	struct nbt_rdata_address *object = pytalloc_get_ptr(obj);
	PyObject *py_ipaddr;
	py_ipaddr = PyString_FromStringOrNULL(object->ipaddr);
	return py_ipaddr;
}

static int py_nbt_rdata_address_set_ipaddr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_address *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ipaddr");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ipaddr = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_nbt_rdata_address_getsetters[] = {
	{
		.name = discard_const_p(char, "nb_flags"),
		.get = py_nbt_rdata_address_get_nb_flags,
		.set = py_nbt_rdata_address_set_nb_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type nb_flags")
	},
	{
		.name = discard_const_p(char, "ipaddr"),
		.get = py_nbt_rdata_address_get_ipaddr,
		.set = py_nbt_rdata_address_set_ipaddr,
		.doc = discard_const_p(char, "PIDL-generated element of base type ipv4address")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_rdata_address_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_rdata_address, type);
}


static PyTypeObject nbt_rdata_address_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.rdata_address",
	.tp_getset = py_nbt_rdata_address_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_rdata_address_new,
};


static PyObject *py_nbt_rdata_netbios_get_length(PyObject *obj, void *closure)
{
	struct nbt_rdata_netbios *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_nbt_rdata_netbios_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_netbios *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_rdata_netbios_get_addresses(PyObject *obj, void *closure)
{
	struct nbt_rdata_netbios *object = pytalloc_get_ptr(obj);
	PyObject *py_addresses;
	py_addresses = PyList_New(object->length / 6);
	if (py_addresses == NULL) {
		return NULL;
	}
	{
		int addresses_cntr_0;
		for (addresses_cntr_0 = 0; addresses_cntr_0 < (object->length / 6); addresses_cntr_0++) {
			PyObject *py_addresses_0;
			py_addresses_0 = pytalloc_reference_ex(&nbt_rdata_address_Type, object->addresses, &(object->addresses)[addresses_cntr_0]);
			PyList_SetItem(py_addresses, addresses_cntr_0, py_addresses_0);
		}
	}
	return py_addresses;
}

static int py_nbt_rdata_netbios_set_addresses(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_netbios *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->addresses");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int addresses_cntr_0;
		object->addresses = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->addresses, PyList_GET_SIZE(value));
		if (!object->addresses) { return -1; }
		talloc_set_name_const(object->addresses, "ARRAY: object->addresses");
		for (addresses_cntr_0 = 0; addresses_cntr_0 < PyList_GET_SIZE(value); addresses_cntr_0++) {
			if (PyList_GET_ITEM(value, addresses_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->addresses)[addresses_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&nbt_rdata_address_Type, PyList_GET_ITEM(value, addresses_cntr_0), return -1;);
			if (talloc_reference(object->addresses, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, addresses_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->addresses)[addresses_cntr_0] = *(struct nbt_rdata_address *)pytalloc_get_ptr(PyList_GET_ITEM(value, addresses_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_nbt_rdata_netbios_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_nbt_rdata_netbios_get_length,
		.set = py_nbt_rdata_netbios_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "addresses"),
		.get = py_nbt_rdata_netbios_get_addresses,
		.set = py_nbt_rdata_netbios_set_addresses,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_rdata_address")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_rdata_netbios_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_rdata_netbios, type);
}


static PyTypeObject nbt_rdata_netbios_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.rdata_netbios",
	.tp_getset = py_nbt_rdata_netbios_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_rdata_netbios_new,
};


static PyObject *py_nbt_statistics_get_unit_id(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_unit_id;
	py_unit_id = PyList_New(6);
	if (py_unit_id == NULL) {
		return NULL;
	}
	{
		int unit_id_cntr_0;
		for (unit_id_cntr_0 = 0; unit_id_cntr_0 < (6); unit_id_cntr_0++) {
			PyObject *py_unit_id_0;
			py_unit_id_0 = PyLong_FromLong((uint16_t)((object->unit_id)[unit_id_cntr_0]));
			PyList_SetItem(py_unit_id, unit_id_cntr_0, py_unit_id_0);
		}
	}
	return py_unit_id;
}

static int py_nbt_statistics_set_unit_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unit_id");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int unit_id_cntr_0;
		if (ARRAY_SIZE(object->unit_id) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->unit_id),  PyList_GET_SIZE(value));
			return -1;
		}
		for (unit_id_cntr_0 = 0; unit_id_cntr_0 < PyList_GET_SIZE(value); unit_id_cntr_0++) {
			if (PyList_GET_ITEM(value, unit_id_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->unit_id)[unit_id_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->unit_id)[unit_id_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, unit_id_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, unit_id_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->unit_id)[unit_id_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_jumpers(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_jumpers;
	py_jumpers = PyLong_FromLong((uint16_t)(object->jumpers));
	return py_jumpers;
}

static int py_nbt_statistics_set_jumpers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->jumpers");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->jumpers));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->jumpers = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_test_result(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_test_result;
	py_test_result = PyLong_FromLong((uint16_t)(object->test_result));
	return py_test_result;
}

static int py_nbt_statistics_set_test_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->test_result");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->test_result));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->test_result = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_version_number(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_version_number;
	py_version_number = PyLong_FromLong((uint16_t)(object->version_number));
	return py_version_number;
}

static int py_nbt_statistics_set_version_number(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version_number");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version_number));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version_number = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_period_of_statistics(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_period_of_statistics;
	py_period_of_statistics = PyLong_FromLong((uint16_t)(object->period_of_statistics));
	return py_period_of_statistics;
}

static int py_nbt_statistics_set_period_of_statistics(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->period_of_statistics");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->period_of_statistics));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->period_of_statistics = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_number_of_crcs(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_number_of_crcs;
	py_number_of_crcs = PyLong_FromLong((uint16_t)(object->number_of_crcs));
	return py_number_of_crcs;
}

static int py_nbt_statistics_set_number_of_crcs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->number_of_crcs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->number_of_crcs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->number_of_crcs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_number_alignment_errors(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_number_alignment_errors;
	py_number_alignment_errors = PyLong_FromLong((uint16_t)(object->number_alignment_errors));
	return py_number_alignment_errors;
}

static int py_nbt_statistics_set_number_alignment_errors(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->number_alignment_errors");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->number_alignment_errors));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->number_alignment_errors = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_number_of_collisions(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_number_of_collisions;
	py_number_of_collisions = PyLong_FromLong((uint16_t)(object->number_of_collisions));
	return py_number_of_collisions;
}

static int py_nbt_statistics_set_number_of_collisions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->number_of_collisions");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->number_of_collisions));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->number_of_collisions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_number_send_aborts(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_number_send_aborts;
	py_number_send_aborts = PyLong_FromLong((uint16_t)(object->number_send_aborts));
	return py_number_send_aborts;
}

static int py_nbt_statistics_set_number_send_aborts(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->number_send_aborts");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->number_send_aborts));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->number_send_aborts = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_number_good_sends(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_number_good_sends;
	py_number_good_sends = PyLong_FromUnsignedLongLong((uint32_t)(object->number_good_sends));
	return py_number_good_sends;
}

static int py_nbt_statistics_set_number_good_sends(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->number_good_sends");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->number_good_sends));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->number_good_sends = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_number_good_receives(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_number_good_receives;
	py_number_good_receives = PyLong_FromUnsignedLongLong((uint32_t)(object->number_good_receives));
	return py_number_good_receives;
}

static int py_nbt_statistics_set_number_good_receives(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->number_good_receives");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->number_good_receives));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->number_good_receives = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_number_retransmits(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_number_retransmits;
	py_number_retransmits = PyLong_FromLong((uint16_t)(object->number_retransmits));
	return py_number_retransmits;
}

static int py_nbt_statistics_set_number_retransmits(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->number_retransmits");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->number_retransmits));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->number_retransmits = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_number_no_resource_conditions(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_number_no_resource_conditions;
	py_number_no_resource_conditions = PyLong_FromLong((uint16_t)(object->number_no_resource_conditions));
	return py_number_no_resource_conditions;
}

static int py_nbt_statistics_set_number_no_resource_conditions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->number_no_resource_conditions");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->number_no_resource_conditions));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->number_no_resource_conditions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_number_free_command_blocks(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_number_free_command_blocks;
	py_number_free_command_blocks = PyLong_FromLong((uint16_t)(object->number_free_command_blocks));
	return py_number_free_command_blocks;
}

static int py_nbt_statistics_set_number_free_command_blocks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->number_free_command_blocks");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->number_free_command_blocks));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->number_free_command_blocks = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_total_number_command_blocks(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_total_number_command_blocks;
	py_total_number_command_blocks = PyLong_FromLong((uint16_t)(object->total_number_command_blocks));
	return py_total_number_command_blocks;
}

static int py_nbt_statistics_set_total_number_command_blocks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->total_number_command_blocks");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->total_number_command_blocks));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->total_number_command_blocks = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_max_total_number_command_blocks(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_max_total_number_command_blocks;
	py_max_total_number_command_blocks = PyLong_FromLong((uint16_t)(object->max_total_number_command_blocks));
	return py_max_total_number_command_blocks;
}

static int py_nbt_statistics_set_max_total_number_command_blocks(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_total_number_command_blocks");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_total_number_command_blocks));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_total_number_command_blocks = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_number_pending_sessions(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_number_pending_sessions;
	py_number_pending_sessions = PyLong_FromLong((uint16_t)(object->number_pending_sessions));
	return py_number_pending_sessions;
}

static int py_nbt_statistics_set_number_pending_sessions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->number_pending_sessions");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->number_pending_sessions));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->number_pending_sessions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_max_number_pending_sessions(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_max_number_pending_sessions;
	py_max_number_pending_sessions = PyLong_FromLong((uint16_t)(object->max_number_pending_sessions));
	return py_max_number_pending_sessions;
}

static int py_nbt_statistics_set_max_number_pending_sessions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_number_pending_sessions");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_number_pending_sessions));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_number_pending_sessions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_max_total_sessions_possible(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_max_total_sessions_possible;
	py_max_total_sessions_possible = PyLong_FromLong((uint16_t)(object->max_total_sessions_possible));
	return py_max_total_sessions_possible;
}

static int py_nbt_statistics_set_max_total_sessions_possible(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_total_sessions_possible");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_total_sessions_possible));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_total_sessions_possible = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_statistics_get_session_data_packet_size(PyObject *obj, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_session_data_packet_size;
	py_session_data_packet_size = PyLong_FromLong((uint16_t)(object->session_data_packet_size));
	return py_session_data_packet_size;
}

static int py_nbt_statistics_set_session_data_packet_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->session_data_packet_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->session_data_packet_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->session_data_packet_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_nbt_statistics_getsetters[] = {
	{
		.name = discard_const_p(char, "unit_id"),
		.get = py_nbt_statistics_get_unit_id,
		.set = py_nbt_statistics_set_unit_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "jumpers"),
		.get = py_nbt_statistics_get_jumpers,
		.set = py_nbt_statistics_set_jumpers,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "test_result"),
		.get = py_nbt_statistics_get_test_result,
		.set = py_nbt_statistics_set_test_result,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "version_number"),
		.get = py_nbt_statistics_get_version_number,
		.set = py_nbt_statistics_set_version_number,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "period_of_statistics"),
		.get = py_nbt_statistics_get_period_of_statistics,
		.set = py_nbt_statistics_set_period_of_statistics,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "number_of_crcs"),
		.get = py_nbt_statistics_get_number_of_crcs,
		.set = py_nbt_statistics_set_number_of_crcs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "number_alignment_errors"),
		.get = py_nbt_statistics_get_number_alignment_errors,
		.set = py_nbt_statistics_set_number_alignment_errors,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "number_of_collisions"),
		.get = py_nbt_statistics_get_number_of_collisions,
		.set = py_nbt_statistics_set_number_of_collisions,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "number_send_aborts"),
		.get = py_nbt_statistics_get_number_send_aborts,
		.set = py_nbt_statistics_set_number_send_aborts,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "number_good_sends"),
		.get = py_nbt_statistics_get_number_good_sends,
		.set = py_nbt_statistics_set_number_good_sends,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "number_good_receives"),
		.get = py_nbt_statistics_get_number_good_receives,
		.set = py_nbt_statistics_set_number_good_receives,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "number_retransmits"),
		.get = py_nbt_statistics_get_number_retransmits,
		.set = py_nbt_statistics_set_number_retransmits,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "number_no_resource_conditions"),
		.get = py_nbt_statistics_get_number_no_resource_conditions,
		.set = py_nbt_statistics_set_number_no_resource_conditions,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "number_free_command_blocks"),
		.get = py_nbt_statistics_get_number_free_command_blocks,
		.set = py_nbt_statistics_set_number_free_command_blocks,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "total_number_command_blocks"),
		.get = py_nbt_statistics_get_total_number_command_blocks,
		.set = py_nbt_statistics_set_total_number_command_blocks,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "max_total_number_command_blocks"),
		.get = py_nbt_statistics_get_max_total_number_command_blocks,
		.set = py_nbt_statistics_set_max_total_number_command_blocks,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "number_pending_sessions"),
		.get = py_nbt_statistics_get_number_pending_sessions,
		.set = py_nbt_statistics_set_number_pending_sessions,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "max_number_pending_sessions"),
		.get = py_nbt_statistics_get_max_number_pending_sessions,
		.set = py_nbt_statistics_set_max_number_pending_sessions,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "max_total_sessions_possible"),
		.get = py_nbt_statistics_get_max_total_sessions_possible,
		.set = py_nbt_statistics_set_max_total_sessions_possible,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "session_data_packet_size"),
		.get = py_nbt_statistics_get_session_data_packet_size,
		.set = py_nbt_statistics_set_session_data_packet_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_statistics_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_statistics, type);
}


static PyTypeObject nbt_statistics_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.statistics",
	.tp_getset = py_nbt_statistics_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_statistics_new,
};


static PyObject *py_nbt_status_name_get_name(PyObject *obj, void *closure)
{
	struct nbt_status_name *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
	}
	return py_name;
}

static int py_nbt_status_name_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_status_name *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->name = talloc_str;
	}
	return 0;
}

static PyObject *py_nbt_status_name_get_type(PyObject *obj, void *closure)
{
	struct nbt_status_name *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromLong((uint16_t)(object->type));
	return py_type;
}

static int py_nbt_status_name_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_status_name *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_status_name_get_nb_flags(PyObject *obj, void *closure)
{
	struct nbt_status_name *object = pytalloc_get_ptr(obj);
	PyObject *py_nb_flags;
	py_nb_flags = PyLong_FromLong((uint16_t)(object->nb_flags));
	return py_nb_flags;
}

static int py_nbt_status_name_set_nb_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_status_name *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nb_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nb_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nb_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_nbt_status_name_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_nbt_status_name_get_name,
		.set = py_nbt_status_name_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_nbt_status_name_get_type,
		.set = py_nbt_status_name_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_name_type")
	},
	{
		.name = discard_const_p(char, "nb_flags"),
		.get = py_nbt_status_name_get_nb_flags,
		.set = py_nbt_status_name_set_nb_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type nb_flags")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_status_name_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_status_name, type);
}


static PyTypeObject nbt_status_name_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.status_name",
	.tp_getset = py_nbt_status_name_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_status_name_new,
};


static PyObject *py_nbt_rdata_status_get_length(PyObject *obj, void *closure)
{
	struct nbt_rdata_status *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_nbt_rdata_status_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_status *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_rdata_status_get_num_names(PyObject *obj, void *closure)
{
	struct nbt_rdata_status *object = pytalloc_get_ptr(obj);
	PyObject *py_num_names;
	py_num_names = PyLong_FromLong((uint16_t)(object->num_names));
	return py_num_names;
}

static int py_nbt_rdata_status_set_num_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_status *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_names");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_names));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_names = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_rdata_status_get_names(PyObject *obj, void *closure)
{
	struct nbt_rdata_status *object = pytalloc_get_ptr(obj);
	PyObject *py_names;
	py_names = PyList_New(object->num_names);
	if (py_names == NULL) {
		return NULL;
	}
	{
		int names_cntr_0;
		for (names_cntr_0 = 0; names_cntr_0 < (object->num_names); names_cntr_0++) {
			PyObject *py_names_0;
			py_names_0 = pytalloc_reference_ex(&nbt_status_name_Type, object->names, &(object->names)[names_cntr_0]);
			PyList_SetItem(py_names, names_cntr_0, py_names_0);
		}
	}
	return py_names;
}

static int py_nbt_rdata_status_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_status *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->names");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int names_cntr_0;
		object->names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->names, PyList_GET_SIZE(value));
		if (!object->names) { return -1; }
		talloc_set_name_const(object->names, "ARRAY: object->names");
		for (names_cntr_0 = 0; names_cntr_0 < PyList_GET_SIZE(value); names_cntr_0++) {
			if (PyList_GET_ITEM(value, names_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->names)[names_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&nbt_status_name_Type, PyList_GET_ITEM(value, names_cntr_0), return -1;);
			if (talloc_reference(object->names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, names_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->names)[names_cntr_0] = *(struct nbt_status_name *)pytalloc_get_ptr(PyList_GET_ITEM(value, names_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_nbt_rdata_status_get_statistics(PyObject *obj, void *closure)
{
	struct nbt_rdata_status *object = pytalloc_get_ptr(obj);
	PyObject *py_statistics;
	py_statistics = pytalloc_reference_ex(&nbt_statistics_Type, pytalloc_get_mem_ctx(obj), &object->statistics);
	return py_statistics;
}

static int py_nbt_rdata_status_set_statistics(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_status *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->statistics");
		return -1;
	}
	PY_CHECK_TYPE(&nbt_statistics_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->statistics = *(struct nbt_statistics *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_nbt_rdata_status_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_nbt_rdata_status_get_length,
		.set = py_nbt_rdata_status_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "num_names"),
		.get = py_nbt_rdata_status_get_num_names,
		.set = py_nbt_rdata_status_set_num_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "names"),
		.get = py_nbt_rdata_status_get_names,
		.set = py_nbt_rdata_status_set_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_status_name")
	},
	{
		.name = discard_const_p(char, "statistics"),
		.get = py_nbt_rdata_status_get_statistics,
		.set = py_nbt_rdata_status_set_statistics,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_statistics")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_rdata_status_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_rdata_status, type);
}


static PyTypeObject nbt_rdata_status_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.rdata_status",
	.tp_getset = py_nbt_rdata_status_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_rdata_status_new,
};


static PyObject *py_nbt_rdata_data_get_length(PyObject *obj, void *closure)
{
	struct nbt_rdata_data *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_nbt_rdata_data_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_data *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_rdata_data_get_data(PyObject *obj, void *closure)
{
	struct nbt_rdata_data *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(object->length);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < (object->length); data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_0]));
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_nbt_rdata_data_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_rdata_data *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
		if (!object->data) { return -1; }
		talloc_set_name_const(object->data, "ARRAY: object->data");
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			if (PyList_GET_ITEM(value, data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->data)[data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->data)[data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_nbt_rdata_data_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_nbt_rdata_data_get_length,
		.set = py_nbt_rdata_data_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_nbt_rdata_data_get_data,
		.set = py_nbt_rdata_data_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_rdata_data_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_rdata_data, type);
}


static PyTypeObject nbt_rdata_data_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.rdata_data",
	.tp_getset = py_nbt_rdata_data_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_rdata_data_new,
};

static PyObject *py_import_nbt_rdata(TALLOC_CTX *mem_ctx, int level, union nbt_rdata *in)
{
	PyObject *ret;

	switch (level) {
		case NBT_QTYPE_NETBIOS:
			ret = pytalloc_reference_ex(&nbt_rdata_netbios_Type, mem_ctx, &in->netbios);
			return ret;

		case NBT_QTYPE_STATUS:
			ret = pytalloc_reference_ex(&nbt_rdata_status_Type, mem_ctx, &in->status);
			return ret;

		default:
			ret = pytalloc_reference_ex(&nbt_rdata_data_Type, mem_ctx, &in->data);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union nbt_rdata *py_export_nbt_rdata(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union nbt_rdata *ret = talloc_zero(mem_ctx, union nbt_rdata);
	switch (level) {
		case NBT_QTYPE_NETBIOS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->netbios");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&nbt_rdata_netbios_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->netbios = *(struct nbt_rdata_netbios *)pytalloc_get_ptr(in);
			break;

		case NBT_QTYPE_STATUS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->status");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&nbt_rdata_status_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->status = *(struct nbt_rdata_status *)pytalloc_get_ptr(in);
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->data");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&nbt_rdata_data_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->data = *(struct nbt_rdata_data *)pytalloc_get_ptr(in);
			break;

	}

	return ret;
}

static PyObject *py_nbt_rdata_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union nbt_rdata *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union nbt_rdata *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union nbt_rdata!");
		return NULL;
	}

	return py_import_nbt_rdata(mem_ctx, level, in);
}

static PyObject *py_nbt_rdata_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union nbt_rdata *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_nbt_rdata(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_nbt_rdata_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_rdata_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_rdata_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_nbt_rdata_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject nbt_rdata_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.rdata",
	.tp_getset = NULL,
	.tp_methods = py_nbt_rdata_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_rdata_new,
};


static PyObject *py_nbt_res_rec_get_name(PyObject *obj, void *closure)
{
	struct nbt_res_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(&nbt_name_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_nbt_res_rec_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_res_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	PY_CHECK_TYPE(&nbt_name_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct nbt_name *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_nbt_res_rec_get_rr_type(PyObject *obj, void *closure)
{
	struct nbt_res_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_rr_type;
	py_rr_type = PyLong_FromLong((uint16_t)(object->rr_type));
	return py_rr_type;
}

static int py_nbt_res_rec_set_rr_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_res_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rr_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rr_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rr_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_res_rec_get_rr_class(PyObject *obj, void *closure)
{
	struct nbt_res_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_rr_class;
	py_rr_class = PyLong_FromLong((uint16_t)(object->rr_class));
	return py_rr_class;
}

static int py_nbt_res_rec_set_rr_class(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_res_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rr_class");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rr_class));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rr_class = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_res_rec_get_ttl(PyObject *obj, void *closure)
{
	struct nbt_res_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_ttl;
	py_ttl = PyLong_FromUnsignedLongLong((uint32_t)(object->ttl));
	return py_ttl;
}

static int py_nbt_res_rec_set_ttl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_res_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ttl");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ttl));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ttl = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_res_rec_get_rdata(PyObject *obj, void *closure)
{
	struct nbt_res_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_rdata;
	py_rdata = pyrpc_import_union(&nbt_rdata_Type, pytalloc_get_mem_ctx(obj), object->rr_type, &object->rdata, "union nbt_rdata");
	if (py_rdata == NULL) {
		return NULL;
	}
	return py_rdata;
}

static int py_nbt_res_rec_set_rdata(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_res_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rdata");
		return -1;
	}
	{
		union nbt_rdata *rdata_switch_0;
		rdata_switch_0 = (union nbt_rdata *)pyrpc_export_union(&nbt_rdata_Type, pytalloc_get_mem_ctx(py_obj), object->rr_type, value, "union nbt_rdata");
		if (rdata_switch_0 == NULL) {
			return -1;
		}
		object->rdata = *rdata_switch_0;
	}
	return 0;
}

static PyGetSetDef py_nbt_res_rec_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_nbt_res_rec_get_name,
		.set = py_nbt_res_rec_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_name")
	},
	{
		.name = discard_const_p(char, "rr_type"),
		.get = py_nbt_res_rec_get_rr_type,
		.set = py_nbt_res_rec_set_rr_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_qtype")
	},
	{
		.name = discard_const_p(char, "rr_class"),
		.get = py_nbt_res_rec_get_rr_class,
		.set = py_nbt_res_rec_set_rr_class,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_qclass")
	},
	{
		.name = discard_const_p(char, "ttl"),
		.get = py_nbt_res_rec_get_ttl,
		.set = py_nbt_res_rec_set_ttl,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "rdata"),
		.get = py_nbt_res_rec_get_rdata,
		.set = py_nbt_res_rec_set_rdata,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_rdata")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_res_rec_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_res_rec, type);
}


static PyTypeObject nbt_res_rec_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.res_rec",
	.tp_getset = py_nbt_res_rec_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_res_rec_new,
};


static PyObject *py_nbt_name_packet_get_name_trn_id(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_name_trn_id;
	py_name_trn_id = PyLong_FromLong((uint16_t)(object->name_trn_id));
	return py_name_trn_id;
}

static int py_nbt_name_packet_set_name_trn_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name_trn_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->name_trn_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->name_trn_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_name_packet_get_operation(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_operation;
	py_operation = PyLong_FromLong((uint16_t)(object->operation));
	return py_operation;
}

static int py_nbt_name_packet_set_operation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->operation");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->operation));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->operation = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_name_packet_get_qdcount(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_qdcount;
	py_qdcount = PyLong_FromLong((uint16_t)(object->qdcount));
	return py_qdcount;
}

static int py_nbt_name_packet_set_qdcount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->qdcount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->qdcount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->qdcount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_name_packet_get_ancount(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_ancount;
	py_ancount = PyLong_FromLong((uint16_t)(object->ancount));
	return py_ancount;
}

static int py_nbt_name_packet_set_ancount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ancount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ancount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ancount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_name_packet_get_nscount(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_nscount;
	py_nscount = PyLong_FromLong((uint16_t)(object->nscount));
	return py_nscount;
}

static int py_nbt_name_packet_set_nscount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nscount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nscount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nscount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_name_packet_get_arcount(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_arcount;
	py_arcount = PyLong_FromLong((uint16_t)(object->arcount));
	return py_arcount;
}

static int py_nbt_name_packet_set_arcount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->arcount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->arcount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->arcount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_name_packet_get_questions(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_questions;
	py_questions = PyList_New(object->qdcount);
	if (py_questions == NULL) {
		return NULL;
	}
	{
		int questions_cntr_0;
		for (questions_cntr_0 = 0; questions_cntr_0 < (object->qdcount); questions_cntr_0++) {
			PyObject *py_questions_0;
			py_questions_0 = pytalloc_reference_ex(&nbt_name_question_Type, object->questions, &(object->questions)[questions_cntr_0]);
			PyList_SetItem(py_questions, questions_cntr_0, py_questions_0);
		}
	}
	return py_questions;
}

static int py_nbt_name_packet_set_questions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->questions");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int questions_cntr_0;
		object->questions = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->questions, PyList_GET_SIZE(value));
		if (!object->questions) { return -1; }
		talloc_set_name_const(object->questions, "ARRAY: object->questions");
		for (questions_cntr_0 = 0; questions_cntr_0 < PyList_GET_SIZE(value); questions_cntr_0++) {
			if (PyList_GET_ITEM(value, questions_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->questions)[questions_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&nbt_name_question_Type, PyList_GET_ITEM(value, questions_cntr_0), return -1;);
			if (talloc_reference(object->questions, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, questions_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->questions)[questions_cntr_0] = *(struct nbt_name_question *)pytalloc_get_ptr(PyList_GET_ITEM(value, questions_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_nbt_name_packet_get_answers(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_answers;
	py_answers = PyList_New(object->ancount);
	if (py_answers == NULL) {
		return NULL;
	}
	{
		int answers_cntr_0;
		for (answers_cntr_0 = 0; answers_cntr_0 < (object->ancount); answers_cntr_0++) {
			PyObject *py_answers_0;
			py_answers_0 = pytalloc_reference_ex(&nbt_res_rec_Type, object->answers, &(object->answers)[answers_cntr_0]);
			PyList_SetItem(py_answers, answers_cntr_0, py_answers_0);
		}
	}
	return py_answers;
}

static int py_nbt_name_packet_set_answers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->answers");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int answers_cntr_0;
		object->answers = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->answers, PyList_GET_SIZE(value));
		if (!object->answers) { return -1; }
		talloc_set_name_const(object->answers, "ARRAY: object->answers");
		for (answers_cntr_0 = 0; answers_cntr_0 < PyList_GET_SIZE(value); answers_cntr_0++) {
			if (PyList_GET_ITEM(value, answers_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->answers)[answers_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&nbt_res_rec_Type, PyList_GET_ITEM(value, answers_cntr_0), return -1;);
			if (talloc_reference(object->answers, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, answers_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->answers)[answers_cntr_0] = *(struct nbt_res_rec *)pytalloc_get_ptr(PyList_GET_ITEM(value, answers_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_nbt_name_packet_get_nsrecs(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_nsrecs;
	py_nsrecs = PyList_New(object->nscount);
	if (py_nsrecs == NULL) {
		return NULL;
	}
	{
		int nsrecs_cntr_0;
		for (nsrecs_cntr_0 = 0; nsrecs_cntr_0 < (object->nscount); nsrecs_cntr_0++) {
			PyObject *py_nsrecs_0;
			py_nsrecs_0 = pytalloc_reference_ex(&nbt_res_rec_Type, object->nsrecs, &(object->nsrecs)[nsrecs_cntr_0]);
			PyList_SetItem(py_nsrecs, nsrecs_cntr_0, py_nsrecs_0);
		}
	}
	return py_nsrecs;
}

static int py_nbt_name_packet_set_nsrecs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nsrecs");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int nsrecs_cntr_0;
		object->nsrecs = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->nsrecs, PyList_GET_SIZE(value));
		if (!object->nsrecs) { return -1; }
		talloc_set_name_const(object->nsrecs, "ARRAY: object->nsrecs");
		for (nsrecs_cntr_0 = 0; nsrecs_cntr_0 < PyList_GET_SIZE(value); nsrecs_cntr_0++) {
			if (PyList_GET_ITEM(value, nsrecs_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->nsrecs)[nsrecs_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&nbt_res_rec_Type, PyList_GET_ITEM(value, nsrecs_cntr_0), return -1;);
			if (talloc_reference(object->nsrecs, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, nsrecs_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->nsrecs)[nsrecs_cntr_0] = *(struct nbt_res_rec *)pytalloc_get_ptr(PyList_GET_ITEM(value, nsrecs_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_nbt_name_packet_get_additional(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_additional;
	py_additional = PyList_New(object->arcount);
	if (py_additional == NULL) {
		return NULL;
	}
	{
		int additional_cntr_0;
		for (additional_cntr_0 = 0; additional_cntr_0 < (object->arcount); additional_cntr_0++) {
			PyObject *py_additional_0;
			py_additional_0 = pytalloc_reference_ex(&nbt_res_rec_Type, object->additional, &(object->additional)[additional_cntr_0]);
			PyList_SetItem(py_additional, additional_cntr_0, py_additional_0);
		}
	}
	return py_additional;
}

static int py_nbt_name_packet_set_additional(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->additional");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int additional_cntr_0;
		object->additional = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->additional, PyList_GET_SIZE(value));
		if (!object->additional) { return -1; }
		talloc_set_name_const(object->additional, "ARRAY: object->additional");
		for (additional_cntr_0 = 0; additional_cntr_0 < PyList_GET_SIZE(value); additional_cntr_0++) {
			if (PyList_GET_ITEM(value, additional_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->additional)[additional_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&nbt_res_rec_Type, PyList_GET_ITEM(value, additional_cntr_0), return -1;);
			if (talloc_reference(object->additional, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, additional_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->additional)[additional_cntr_0] = *(struct nbt_res_rec *)pytalloc_get_ptr(PyList_GET_ITEM(value, additional_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_nbt_name_packet_get_padding(PyObject *obj, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_padding;
	py_padding = PyBytes_FromStringAndSize((char *)(object->padding).data, (object->padding).length);
	return py_padding;
}

static int py_nbt_name_packet_set_padding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->padding");
		return -1;
	}
	object->padding = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_nbt_name_packet_getsetters[] = {
	{
		.name = discard_const_p(char, "name_trn_id"),
		.get = py_nbt_name_packet_get_name_trn_id,
		.set = py_nbt_name_packet_set_name_trn_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "operation"),
		.get = py_nbt_name_packet_get_operation,
		.set = py_nbt_name_packet_set_operation,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_operation")
	},
	{
		.name = discard_const_p(char, "qdcount"),
		.get = py_nbt_name_packet_get_qdcount,
		.set = py_nbt_name_packet_set_qdcount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "ancount"),
		.get = py_nbt_name_packet_get_ancount,
		.set = py_nbt_name_packet_set_ancount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "nscount"),
		.get = py_nbt_name_packet_get_nscount,
		.set = py_nbt_name_packet_set_nscount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "arcount"),
		.get = py_nbt_name_packet_get_arcount,
		.set = py_nbt_name_packet_set_arcount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "questions"),
		.get = py_nbt_name_packet_get_questions,
		.set = py_nbt_name_packet_set_questions,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_name_question")
	},
	{
		.name = discard_const_p(char, "answers"),
		.get = py_nbt_name_packet_get_answers,
		.set = py_nbt_name_packet_set_answers,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_res_rec")
	},
	{
		.name = discard_const_p(char, "nsrecs"),
		.get = py_nbt_name_packet_get_nsrecs,
		.set = py_nbt_name_packet_set_nsrecs,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_res_rec")
	},
	{
		.name = discard_const_p(char, "additional"),
		.get = py_nbt_name_packet_get_additional,
		.set = py_nbt_name_packet_set_additional,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_res_rec")
	},
	{
		.name = discard_const_p(char, "padding"),
		.get = py_nbt_name_packet_get_padding,
		.set = py_nbt_name_packet_set_padding,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_name_packet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_name_packet, type);
}

static PyObject *py_nbt_name_packet_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct nbt_name_packet *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_nbt_name_packet);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_nbt_name_packet_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_name_packet);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_name_packet);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_nbt_name_packet_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_name_packet *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_name_packet, "nbt_name_packet", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_name_packet, "nbt_name_packet", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_nbt_name_packet_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_nbt_name_packet_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_name_packet_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_name_packet_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbt_name_packet_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.name_packet",
	.tp_getset = py_nbt_name_packet_getsetters,
	.tp_methods = py_nbt_name_packet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_name_packet_new,
};


static PyObject *py_smb_trans_body_get_wct(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_wct;
	py_wct = PyLong_FromLong((uint16_t)(object->wct));
	return py_wct;
}

static int py_smb_trans_body_set_wct(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->wct");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->wct));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->wct = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_total_param_count(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_total_param_count;
	py_total_param_count = PyLong_FromLong((uint16_t)(object->total_param_count));
	return py_total_param_count;
}

static int py_smb_trans_body_set_total_param_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->total_param_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->total_param_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->total_param_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_total_data_count(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_total_data_count;
	py_total_data_count = PyLong_FromLong((uint16_t)(object->total_data_count));
	return py_total_data_count;
}

static int py_smb_trans_body_set_total_data_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->total_data_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->total_data_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->total_data_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_max_param_count(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_max_param_count;
	py_max_param_count = PyLong_FromLong((uint16_t)(object->max_param_count));
	return py_max_param_count;
}

static int py_smb_trans_body_set_max_param_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_param_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_param_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_param_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_max_data_count(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_max_data_count;
	py_max_data_count = PyLong_FromLong((uint16_t)(object->max_data_count));
	return py_max_data_count;
}

static int py_smb_trans_body_set_max_data_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_data_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_data_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_data_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_max_setup_count(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_max_setup_count;
	py_max_setup_count = PyLong_FromLong((uint16_t)(object->max_setup_count));
	return py_max_setup_count;
}

static int py_smb_trans_body_set_max_setup_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_setup_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_setup_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_setup_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_pad(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_pad;
	py_pad = PyLong_FromLong((uint16_t)(object->pad));
	return py_pad;
}

static int py_smb_trans_body_set_pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pad");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pad));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pad = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_trans_flags(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_trans_flags;
	py_trans_flags = PyLong_FromLong((uint16_t)(object->trans_flags));
	return py_trans_flags;
}

static int py_smb_trans_body_set_trans_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->trans_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->trans_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->trans_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_timeout(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_timeout;
	py_timeout = PyLong_FromUnsignedLongLong((uint32_t)(object->timeout));
	return py_timeout;
}

static int py_smb_trans_body_set_timeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->timeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->timeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->timeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_reserved(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromLong((uint16_t)(object->reserved));
	return py_reserved;
}

static int py_smb_trans_body_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_param_count(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_param_count;
	py_param_count = PyLong_FromLong((uint16_t)(object->param_count));
	return py_param_count;
}

static int py_smb_trans_body_set_param_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->param_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->param_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->param_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_param_offset(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_param_offset;
	py_param_offset = PyLong_FromLong((uint16_t)(object->param_offset));
	return py_param_offset;
}

static int py_smb_trans_body_set_param_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->param_offset");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->param_offset));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->param_offset = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_data_count(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_data_count;
	py_data_count = PyLong_FromLong((uint16_t)(object->data_count));
	return py_data_count;
}

static int py_smb_trans_body_set_data_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->data_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->data_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_data_offset(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_data_offset;
	py_data_offset = PyLong_FromLong((uint16_t)(object->data_offset));
	return py_data_offset;
}

static int py_smb_trans_body_set_data_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data_offset");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->data_offset));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->data_offset = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_setup_count(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_setup_count;
	py_setup_count = PyLong_FromLong((uint16_t)(object->setup_count));
	return py_setup_count;
}

static int py_smb_trans_body_set_setup_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->setup_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->setup_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->setup_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_pad2(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_pad2;
	py_pad2 = PyLong_FromLong((uint16_t)(object->pad2));
	return py_pad2;
}

static int py_smb_trans_body_set_pad2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pad2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pad2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pad2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_opcode(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_opcode;
	py_opcode = PyLong_FromLong((uint16_t)(object->opcode));
	return py_opcode;
}

static int py_smb_trans_body_set_opcode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->opcode");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->opcode));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->opcode = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_priority(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_priority;
	py_priority = PyLong_FromLong((uint16_t)(object->priority));
	return py_priority;
}

static int py_smb_trans_body_set_priority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->priority");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->priority));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->priority = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get__class(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py__class;
	py__class = PyLong_FromLong((uint16_t)(object->_class));
	return py__class;
}

static int py_smb_trans_body_set__class(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->_class");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->_class));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->_class = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_byte_count(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_byte_count;
	py_byte_count = PyLong_FromLong((uint16_t)(object->byte_count));
	return py_byte_count;
}

static int py_smb_trans_body_set_byte_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->byte_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->byte_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->byte_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_mailslot_name(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_mailslot_name;
	py_mailslot_name = PyString_FromStringOrNULL(object->mailslot_name);
	return py_mailslot_name;
}

static int py_smb_trans_body_set_mailslot_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->mailslot_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->mailslot_name = talloc_str;
	}
	return 0;
}

static PyObject *py_smb_trans_body_get_data(PyObject *obj, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyBytes_FromStringAndSize((char *)(object->data).data, (object->data).length);
	return py_data;
}

static int py_smb_trans_body_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_trans_body *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	object->data = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_smb_trans_body_getsetters[] = {
	{
		.name = discard_const_p(char, "wct"),
		.get = py_smb_trans_body_get_wct,
		.set = py_smb_trans_body_set_wct,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "total_param_count"),
		.get = py_smb_trans_body_get_total_param_count,
		.set = py_smb_trans_body_set_total_param_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "total_data_count"),
		.get = py_smb_trans_body_get_total_data_count,
		.set = py_smb_trans_body_set_total_data_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "max_param_count"),
		.get = py_smb_trans_body_get_max_param_count,
		.set = py_smb_trans_body_set_max_param_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "max_data_count"),
		.get = py_smb_trans_body_get_max_data_count,
		.set = py_smb_trans_body_set_max_data_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "max_setup_count"),
		.get = py_smb_trans_body_get_max_setup_count,
		.set = py_smb_trans_body_set_max_setup_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pad"),
		.get = py_smb_trans_body_get_pad,
		.set = py_smb_trans_body_set_pad,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "trans_flags"),
		.get = py_smb_trans_body_get_trans_flags,
		.set = py_smb_trans_body_set_trans_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "timeout"),
		.get = py_smb_trans_body_get_timeout,
		.set = py_smb_trans_body_set_timeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_smb_trans_body_get_reserved,
		.set = py_smb_trans_body_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "param_count"),
		.get = py_smb_trans_body_get_param_count,
		.set = py_smb_trans_body_set_param_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "param_offset"),
		.get = py_smb_trans_body_get_param_offset,
		.set = py_smb_trans_body_set_param_offset,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "data_count"),
		.get = py_smb_trans_body_get_data_count,
		.set = py_smb_trans_body_set_data_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "data_offset"),
		.get = py_smb_trans_body_get_data_offset,
		.set = py_smb_trans_body_set_data_offset,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "setup_count"),
		.get = py_smb_trans_body_get_setup_count,
		.set = py_smb_trans_body_set_setup_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pad2"),
		.get = py_smb_trans_body_get_pad2,
		.set = py_smb_trans_body_set_pad2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "opcode"),
		.get = py_smb_trans_body_get_opcode,
		.set = py_smb_trans_body_set_opcode,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "priority"),
		.get = py_smb_trans_body_get_priority,
		.set = py_smb_trans_body_set_priority,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "_class"),
		.get = py_smb_trans_body_get__class,
		.set = py_smb_trans_body_set__class,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "byte_count"),
		.get = py_smb_trans_body_get_byte_count,
		.set = py_smb_trans_body_set_byte_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "mailslot_name"),
		.get = py_smb_trans_body_get_mailslot_name,
		.set = py_smb_trans_body_set_mailslot_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_smb_trans_body_get_data,
		.set = py_smb_trans_body_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_smb_trans_body_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smb_trans_body, type);
}


static PyTypeObject smb_trans_body_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.smb_trans_body",
	.tp_getset = py_smb_trans_body_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smb_trans_body_new,
};

static PyObject *py_import_smb_body(TALLOC_CTX *mem_ctx, int level, union smb_body *in)
{
	PyObject *ret;

	switch (level) {
		case SMB_TRANSACTION:
			ret = pytalloc_reference_ex(&smb_trans_body_Type, mem_ctx, &in->trans);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union smb_body *py_export_smb_body(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union smb_body *ret = talloc_zero(mem_ctx, union smb_body);
	switch (level) {
		case SMB_TRANSACTION:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->trans");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&smb_trans_body_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->trans = *(struct smb_trans_body *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_smb_body_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union smb_body *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union smb_body *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union smb_body!");
		return NULL;
	}

	return py_import_smb_body(mem_ctx, level, in);
}

static PyObject *py_smb_body_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union smb_body *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_smb_body(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_smb_body_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smb_body_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smb_body_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_smb_body_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject smb_body_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.smb_body",
	.tp_getset = NULL,
	.tp_methods = py_smb_body_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smb_body_new,
};


static PyObject *py_dgram_smb_packet_get_smb_command(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_smb_command;
	py_smb_command = PyLong_FromLong((uint16_t)(object->smb_command));
	return py_smb_command;
}

static int py_dgram_smb_packet_set_smb_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->smb_command");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->smb_command));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->smb_command = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dgram_smb_packet_get_err_class(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_err_class;
	py_err_class = PyLong_FromLong((uint16_t)(object->err_class));
	return py_err_class;
}

static int py_dgram_smb_packet_set_err_class(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->err_class");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->err_class));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->err_class = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dgram_smb_packet_get_pad(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_pad;
	py_pad = PyLong_FromLong((uint16_t)(object->pad));
	return py_pad;
}

static int py_dgram_smb_packet_set_pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pad");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pad));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pad = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dgram_smb_packet_get_err_code(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_err_code;
	py_err_code = PyLong_FromLong((uint16_t)(object->err_code));
	return py_err_code;
}

static int py_dgram_smb_packet_set_err_code(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->err_code");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->err_code));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->err_code = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dgram_smb_packet_get_flags(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromLong((uint16_t)(object->flags));
	return py_flags;
}

static int py_dgram_smb_packet_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dgram_smb_packet_get_flags2(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_flags2;
	py_flags2 = PyLong_FromLong((uint16_t)(object->flags2));
	return py_flags2;
}

static int py_dgram_smb_packet_set_flags2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dgram_smb_packet_get_pid_high(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_pid_high;
	py_pid_high = PyLong_FromLong((uint16_t)(object->pid_high));
	return py_pid_high;
}

static int py_dgram_smb_packet_set_pid_high(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pid_high");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pid_high));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pid_high = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dgram_smb_packet_get_signature(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_signature;
	py_signature = PyList_New(8);
	if (py_signature == NULL) {
		return NULL;
	}
	{
		int signature_cntr_0;
		for (signature_cntr_0 = 0; signature_cntr_0 < (8); signature_cntr_0++) {
			PyObject *py_signature_0;
			py_signature_0 = PyLong_FromLong((uint16_t)((object->signature)[signature_cntr_0]));
			PyList_SetItem(py_signature, signature_cntr_0, py_signature_0);
		}
	}
	return py_signature;
}

static int py_dgram_smb_packet_set_signature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->signature");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int signature_cntr_0;
		if (ARRAY_SIZE(object->signature) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->signature),  PyList_GET_SIZE(value));
			return -1;
		}
		for (signature_cntr_0 = 0; signature_cntr_0 < PyList_GET_SIZE(value); signature_cntr_0++) {
			if (PyList_GET_ITEM(value, signature_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->signature)[signature_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->signature)[signature_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, signature_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, signature_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->signature)[signature_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_dgram_smb_packet_get_reserved(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromLong((uint16_t)(object->reserved));
	return py_reserved;
}

static int py_dgram_smb_packet_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dgram_smb_packet_get_tid(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_tid;
	py_tid = PyLong_FromLong((uint16_t)(object->tid));
	return py_tid;
}

static int py_dgram_smb_packet_set_tid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->tid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->tid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dgram_smb_packet_get_pid(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_pid;
	py_pid = PyLong_FromLong((uint16_t)(object->pid));
	return py_pid;
}

static int py_dgram_smb_packet_set_pid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dgram_smb_packet_get_vuid(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_vuid;
	py_vuid = PyLong_FromLong((uint16_t)(object->vuid));
	return py_vuid;
}

static int py_dgram_smb_packet_set_vuid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->vuid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->vuid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->vuid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dgram_smb_packet_get_mid(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_mid;
	py_mid = PyLong_FromLong((uint16_t)(object->mid));
	return py_mid;
}

static int py_dgram_smb_packet_set_mid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->mid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->mid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->mid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dgram_smb_packet_get_body(PyObject *obj, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_body;
	py_body = pyrpc_import_union(&smb_body_Type, pytalloc_get_mem_ctx(obj), object->smb_command, &object->body, "union smb_body");
	if (py_body == NULL) {
		return NULL;
	}
	return py_body;
}

static int py_dgram_smb_packet_set_body(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->body");
		return -1;
	}
	{
		union smb_body *body_switch_0;
		body_switch_0 = (union smb_body *)pyrpc_export_union(&smb_body_Type, pytalloc_get_mem_ctx(py_obj), object->smb_command, value, "union smb_body");
		if (body_switch_0 == NULL) {
			return -1;
		}
		object->body = *body_switch_0;
	}
	return 0;
}

static PyGetSetDef py_dgram_smb_packet_getsetters[] = {
	{
		.name = discard_const_p(char, "smb_command"),
		.get = py_dgram_smb_packet_get_smb_command,
		.set = py_dgram_smb_packet_set_smb_command,
		.doc = discard_const_p(char, "PIDL-generated element of base type smb_command")
	},
	{
		.name = discard_const_p(char, "err_class"),
		.get = py_dgram_smb_packet_get_err_class,
		.set = py_dgram_smb_packet_set_err_class,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pad"),
		.get = py_dgram_smb_packet_get_pad,
		.set = py_dgram_smb_packet_set_pad,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "err_code"),
		.get = py_dgram_smb_packet_get_err_code,
		.set = py_dgram_smb_packet_set_err_code,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_dgram_smb_packet_get_flags,
		.set = py_dgram_smb_packet_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "flags2"),
		.get = py_dgram_smb_packet_get_flags2,
		.set = py_dgram_smb_packet_set_flags2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "pid_high"),
		.get = py_dgram_smb_packet_get_pid_high,
		.set = py_dgram_smb_packet_set_pid_high,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "signature"),
		.get = py_dgram_smb_packet_get_signature,
		.set = py_dgram_smb_packet_set_signature,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_dgram_smb_packet_get_reserved,
		.set = py_dgram_smb_packet_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "tid"),
		.get = py_dgram_smb_packet_get_tid,
		.set = py_dgram_smb_packet_set_tid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "pid"),
		.get = py_dgram_smb_packet_get_pid,
		.set = py_dgram_smb_packet_set_pid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "vuid"),
		.get = py_dgram_smb_packet_get_vuid,
		.set = py_dgram_smb_packet_set_vuid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "mid"),
		.get = py_dgram_smb_packet_get_mid,
		.set = py_dgram_smb_packet_set_mid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "body"),
		.get = py_dgram_smb_packet_get_body,
		.set = py_dgram_smb_packet_set_body,
		.doc = discard_const_p(char, "PIDL-generated element of base type smb_body")
	},
	{ .name = NULL }
};

static PyObject *py_dgram_smb_packet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dgram_smb_packet, type);
}

static PyObject *py_dgram_smb_packet_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dgram_smb_packet);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dgram_smb_packet_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dgram_smb_packet);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dgram_smb_packet);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dgram_smb_packet_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dgram_smb_packet *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dgram_smb_packet, "dgram_smb_packet", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dgram_smb_packet, "dgram_smb_packet", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dgram_smb_packet_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dgram_smb_packet_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dgram_smb_packet_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dgram_smb_packet_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dgram_smb_packet_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.dgram_smb_packet",
	.tp_getset = py_dgram_smb_packet_getsetters,
	.tp_methods = py_dgram_smb_packet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dgram_smb_packet_new,
};

static PyObject *py_import_dgram_message_body(TALLOC_CTX *mem_ctx, int level, union dgram_message_body *in)
{
	PyObject *ret;

	switch (level) {
		case DGRAM_SMB:
			ret = pytalloc_reference_ex(&dgram_smb_packet_Type, mem_ctx, &in->smb);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union dgram_message_body *py_export_dgram_message_body(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dgram_message_body *ret = talloc_zero(mem_ctx, union dgram_message_body);
	switch (level) {
		case DGRAM_SMB:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->smb");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dgram_smb_packet_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->smb = *(struct dgram_smb_packet *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_dgram_message_body_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union dgram_message_body *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union dgram_message_body *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union dgram_message_body!");
		return NULL;
	}

	return py_import_dgram_message_body(mem_ctx, level, in);
}

static PyObject *py_dgram_message_body_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union dgram_message_body *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_dgram_message_body(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_dgram_message_body_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dgram_message_body_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dgram_message_body_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_dgram_message_body_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject dgram_message_body_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.dgram_message_body",
	.tp_getset = NULL,
	.tp_methods = py_dgram_message_body_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dgram_message_body_new,
};


static PyObject *py_dgram_message_get_length(PyObject *obj, void *closure)
{
	struct dgram_message *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_dgram_message_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_message *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dgram_message_get_offset(PyObject *obj, void *closure)
{
	struct dgram_message *object = pytalloc_get_ptr(obj);
	PyObject *py_offset;
	py_offset = PyLong_FromLong((uint16_t)(object->offset));
	return py_offset;
}

static int py_dgram_message_set_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_message *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->offset");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->offset));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->offset = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dgram_message_get_source_name(PyObject *obj, void *closure)
{
	struct dgram_message *object = pytalloc_get_ptr(obj);
	PyObject *py_source_name;
	py_source_name = pytalloc_reference_ex(&nbt_name_Type, pytalloc_get_mem_ctx(obj), &object->source_name);
	return py_source_name;
}

static int py_dgram_message_set_source_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_message *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->source_name");
		return -1;
	}
	PY_CHECK_TYPE(&nbt_name_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->source_name = *(struct nbt_name *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_dgram_message_get_dest_name(PyObject *obj, void *closure)
{
	struct dgram_message *object = pytalloc_get_ptr(obj);
	PyObject *py_dest_name;
	py_dest_name = pytalloc_reference_ex(&nbt_name_Type, pytalloc_get_mem_ctx(obj), &object->dest_name);
	return py_dest_name;
}

static int py_dgram_message_set_dest_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_message *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dest_name");
		return -1;
	}
	PY_CHECK_TYPE(&nbt_name_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dest_name = *(struct nbt_name *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_dgram_message_get_dgram_body_type(PyObject *obj, void *closure)
{
	struct dgram_message *object = pytalloc_get_ptr(obj);
	PyObject *py_dgram_body_type;
	py_dgram_body_type = PyLong_FromUnsignedLongLong((uint32_t)(object->dgram_body_type));
	return py_dgram_body_type;
}

static int py_dgram_message_set_dgram_body_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_message *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dgram_body_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dgram_body_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dgram_body_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dgram_message_get_body(PyObject *obj, void *closure)
{
	struct dgram_message *object = pytalloc_get_ptr(obj);
	PyObject *py_body;
	py_body = pyrpc_import_union(&dgram_message_body_Type, pytalloc_get_mem_ctx(obj), object->dgram_body_type, &object->body, "union dgram_message_body");
	if (py_body == NULL) {
		return NULL;
	}
	return py_body;
}

static int py_dgram_message_set_body(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dgram_message *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->body");
		return -1;
	}
	{
		union dgram_message_body *body_switch_0;
		body_switch_0 = (union dgram_message_body *)pyrpc_export_union(&dgram_message_body_Type, pytalloc_get_mem_ctx(py_obj), object->dgram_body_type, value, "union dgram_message_body");
		if (body_switch_0 == NULL) {
			return -1;
		}
		object->body = *body_switch_0;
	}
	return 0;
}

static PyGetSetDef py_dgram_message_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_dgram_message_get_length,
		.set = py_dgram_message_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "offset"),
		.get = py_dgram_message_get_offset,
		.set = py_dgram_message_set_offset,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "source_name"),
		.get = py_dgram_message_get_source_name,
		.set = py_dgram_message_set_source_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_name")
	},
	{
		.name = discard_const_p(char, "dest_name"),
		.get = py_dgram_message_get_dest_name,
		.set = py_dgram_message_set_dest_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_name")
	},
	{
		.name = discard_const_p(char, "dgram_body_type"),
		.get = py_dgram_message_get_dgram_body_type,
		.set = py_dgram_message_set_dgram_body_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "body"),
		.get = py_dgram_message_get_body,
		.set = py_dgram_message_set_body,
		.doc = discard_const_p(char, "PIDL-generated element of base type dgram_message_body")
	},
	{ .name = NULL }
};

static PyObject *py_dgram_message_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dgram_message, type);
}


static PyTypeObject dgram_message_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.dgram_message",
	.tp_getset = py_dgram_message_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dgram_message_new,
};

static PyObject *py_import_dgram_data(TALLOC_CTX *mem_ctx, int level, union dgram_data *in)
{
	PyObject *ret;

	switch (level) {
		case DGRAM_DIRECT_UNIQUE:
			ret = pytalloc_reference_ex(&dgram_message_Type, mem_ctx, &in->msg);
			return ret;

		case DGRAM_DIRECT_GROUP:
			ret = pytalloc_reference_ex(&dgram_message_Type, mem_ctx, &in->msg);
			return ret;

		case DGRAM_BCAST:
			ret = pytalloc_reference_ex(&dgram_message_Type, mem_ctx, &in->msg);
			return ret;

		case DGRAM_ERROR:
			ret = PyLong_FromLong((uint16_t)(in->error));
			return ret;

		case DGRAM_QUERY:
			ret = pytalloc_reference_ex(&nbt_name_Type, mem_ctx, &in->dest_name);
			return ret;

		case DGRAM_QUERY_POSITIVE:
			ret = pytalloc_reference_ex(&nbt_name_Type, mem_ctx, &in->dest_name);
			return ret;

		case DGRAM_QUERY_NEGATIVE:
			ret = pytalloc_reference_ex(&nbt_name_Type, mem_ctx, &in->dest_name);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union dgram_data *py_export_dgram_data(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dgram_data *ret = talloc_zero(mem_ctx, union dgram_data);
	switch (level) {
		case DGRAM_DIRECT_UNIQUE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->msg");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dgram_message_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->msg = *(struct dgram_message *)pytalloc_get_ptr(in);
			break;

		case DGRAM_DIRECT_GROUP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->msg");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dgram_message_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->msg = *(struct dgram_message *)pytalloc_get_ptr(in);
			break;

		case DGRAM_BCAST:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->msg");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dgram_message_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->msg = *(struct dgram_message *)pytalloc_get_ptr(in);
			break;

		case DGRAM_ERROR:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->error");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->error));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->error = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case DGRAM_QUERY:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->dest_name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&nbt_name_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->dest_name = *(struct nbt_name *)pytalloc_get_ptr(in);
			break;

		case DGRAM_QUERY_POSITIVE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->dest_name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&nbt_name_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->dest_name = *(struct nbt_name *)pytalloc_get_ptr(in);
			break;

		case DGRAM_QUERY_NEGATIVE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->dest_name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&nbt_name_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->dest_name = *(struct nbt_name *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_dgram_data_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union dgram_data *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union dgram_data *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union dgram_data!");
		return NULL;
	}

	return py_import_dgram_data(mem_ctx, level, in);
}

static PyObject *py_dgram_data_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union dgram_data *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_dgram_data(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_dgram_data_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dgram_data_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dgram_data_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_dgram_data_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject dgram_data_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.dgram_data",
	.tp_getset = NULL,
	.tp_methods = py_dgram_data_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dgram_data_new,
};


static PyObject *py_nbt_dgram_packet_get_msg_type(PyObject *obj, void *closure)
{
	struct nbt_dgram_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_msg_type;
	py_msg_type = PyLong_FromLong((uint16_t)(object->msg_type));
	return py_msg_type;
}

static int py_nbt_dgram_packet_set_msg_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_dgram_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->msg_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->msg_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->msg_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_dgram_packet_get_flags(PyObject *obj, void *closure)
{
	struct nbt_dgram_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromLong((uint16_t)(object->flags));
	return py_flags;
}

static int py_nbt_dgram_packet_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_dgram_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_dgram_packet_get_dgram_id(PyObject *obj, void *closure)
{
	struct nbt_dgram_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_dgram_id;
	py_dgram_id = PyLong_FromLong((uint16_t)(object->dgram_id));
	return py_dgram_id;
}

static int py_nbt_dgram_packet_set_dgram_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_dgram_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dgram_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->dgram_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->dgram_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_dgram_packet_get_src_addr(PyObject *obj, void *closure)
{
	struct nbt_dgram_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_src_addr;
	py_src_addr = PyString_FromStringOrNULL(object->src_addr);
	return py_src_addr;
}

static int py_nbt_dgram_packet_set_src_addr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_dgram_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->src_addr");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->src_addr = talloc_str;
	}
	return 0;
}

static PyObject *py_nbt_dgram_packet_get_src_port(PyObject *obj, void *closure)
{
	struct nbt_dgram_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_src_port;
	py_src_port = PyLong_FromLong((uint16_t)(object->src_port));
	return py_src_port;
}

static int py_nbt_dgram_packet_set_src_port(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_dgram_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->src_port");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->src_port));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->src_port = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_dgram_packet_get_data(PyObject *obj, void *closure)
{
	struct nbt_dgram_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = pyrpc_import_union(&dgram_data_Type, pytalloc_get_mem_ctx(obj), object->msg_type, &object->data, "union dgram_data");
	if (py_data == NULL) {
		return NULL;
	}
	return py_data;
}

static int py_nbt_dgram_packet_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_dgram_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	{
		union dgram_data *data_switch_0;
		data_switch_0 = (union dgram_data *)pyrpc_export_union(&dgram_data_Type, pytalloc_get_mem_ctx(py_obj), object->msg_type, value, "union dgram_data");
		if (data_switch_0 == NULL) {
			return -1;
		}
		object->data = *data_switch_0;
	}
	return 0;
}

static PyGetSetDef py_nbt_dgram_packet_getsetters[] = {
	{
		.name = discard_const_p(char, "msg_type"),
		.get = py_nbt_dgram_packet_get_msg_type,
		.set = py_nbt_dgram_packet_set_msg_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type dgram_msg_type")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_nbt_dgram_packet_get_flags,
		.set = py_nbt_dgram_packet_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type dgram_flags")
	},
	{
		.name = discard_const_p(char, "dgram_id"),
		.get = py_nbt_dgram_packet_get_dgram_id,
		.set = py_nbt_dgram_packet_set_dgram_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "src_addr"),
		.get = py_nbt_dgram_packet_get_src_addr,
		.set = py_nbt_dgram_packet_set_src_addr,
		.doc = discard_const_p(char, "PIDL-generated element of base type ipv4address")
	},
	{
		.name = discard_const_p(char, "src_port"),
		.get = py_nbt_dgram_packet_get_src_port,
		.set = py_nbt_dgram_packet_set_src_port,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_nbt_dgram_packet_get_data,
		.set = py_nbt_dgram_packet_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type dgram_data")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_dgram_packet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_dgram_packet, type);
}

static PyObject *py_nbt_dgram_packet_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct nbt_dgram_packet *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_nbt_dgram_packet);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_nbt_dgram_packet_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_dgram_packet *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_dgram_packet);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_dgram_packet);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_nbt_dgram_packet_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_dgram_packet *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_dgram_packet, "nbt_dgram_packet", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_dgram_packet, "nbt_dgram_packet", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_nbt_dgram_packet_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_nbt_dgram_packet_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_dgram_packet_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_dgram_packet_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbt_dgram_packet_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.dgram_packet",
	.tp_getset = py_nbt_dgram_packet_getsetters,
	.tp_methods = py_nbt_dgram_packet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_dgram_packet_new,
};


static PyObject *py_nbt_sockaddr_get_sockaddr_family(PyObject *obj, void *closure)
{
	struct nbt_sockaddr *object = pytalloc_get_ptr(obj);
	PyObject *py_sockaddr_family;
	py_sockaddr_family = PyLong_FromUnsignedLongLong((uint32_t)(object->sockaddr_family));
	return py_sockaddr_family;
}

static int py_nbt_sockaddr_set_sockaddr_family(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_sockaddr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sockaddr_family");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sockaddr_family));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sockaddr_family = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_sockaddr_get_pdc_ip(PyObject *obj, void *closure)
{
	struct nbt_sockaddr *object = pytalloc_get_ptr(obj);
	PyObject *py_pdc_ip;
	py_pdc_ip = PyString_FromStringOrNULL(object->pdc_ip);
	return py_pdc_ip;
}

static int py_nbt_sockaddr_set_pdc_ip(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_sockaddr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pdc_ip");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->pdc_ip = talloc_str;
	}
	return 0;
}

static PyObject *py_nbt_sockaddr_get_remaining(PyObject *obj, void *closure)
{
	struct nbt_sockaddr *object = pytalloc_get_ptr(obj);
	PyObject *py_remaining;
	py_remaining = PyBytes_FromStringAndSize((char *)(object->remaining).data, (object->remaining).length);
	return py_remaining;
}

static int py_nbt_sockaddr_set_remaining(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_sockaddr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->remaining");
		return -1;
	}
	object->remaining = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_nbt_sockaddr_getsetters[] = {
	{
		.name = discard_const_p(char, "sockaddr_family"),
		.get = py_nbt_sockaddr_get_sockaddr_family,
		.set = py_nbt_sockaddr_set_sockaddr_family,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pdc_ip"),
		.get = py_nbt_sockaddr_get_pdc_ip,
		.set = py_nbt_sockaddr_set_pdc_ip,
		.doc = discard_const_p(char, "PIDL-generated element of base type ipv4address")
	},
	{
		.name = discard_const_p(char, "remaining"),
		.get = py_nbt_sockaddr_get_remaining,
		.set = py_nbt_sockaddr_set_remaining,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_sockaddr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_sockaddr, type);
}

static PyObject *py_nbt_sockaddr_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct nbt_sockaddr *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_nbt_sockaddr);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_nbt_sockaddr_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_sockaddr *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_sockaddr);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_sockaddr);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_nbt_sockaddr_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_sockaddr *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_sockaddr, "nbt_sockaddr", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_sockaddr, "nbt_sockaddr", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_nbt_sockaddr_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_nbt_sockaddr_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_sockaddr_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_sockaddr_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbt_sockaddr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.sockaddr",
	.tp_getset = py_nbt_sockaddr_getsetters,
	.tp_methods = py_nbt_sockaddr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_sockaddr_new,
};


static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_request_count(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(obj);
	PyObject *py_request_count;
	py_request_count = PyLong_FromLong((uint16_t)(object->request_count));
	return py_request_count;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_request_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->request_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->request_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->request_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_computer_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(obj);
	PyObject *py_computer_name;
	py_computer_name = PyString_FromStringOrNULL(object->computer_name);
	return py_computer_name;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->computer_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->computer_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_user_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(obj);
	PyObject *py_user_name;
	py_user_name = PyString_FromStringOrNULL(object->user_name);
	return py_user_name;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_user_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->user_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_mailslot_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(obj);
	PyObject *py_mailslot_name;
	py_mailslot_name = PyString_FromStringOrNULL(object->mailslot_name);
	return py_mailslot_name;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_mailslot_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->mailslot_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->mailslot_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_acct_control(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_control;
	py_acct_control = PyLong_FromUnsignedLongLong((uint32_t)(object->acct_control));
	return py_acct_control;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_acct_control(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acct_control");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acct_control));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acct_control = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_sid_size(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(obj);
	PyObject *py_sid_size;
	py_sid_size = PyLong_FromUnsignedLongLong((uint32_t)(object->sid_size));
	return py_sid_size;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_sid_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sid_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sid_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sid_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get__pad(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyBytes_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->_pad");
		return -1;
	}
	object->_pad = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_sid(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	py_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->sid);
	return py_sid;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sid");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_nt_version(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(obj);
	PyObject *py_nt_version;
	py_nt_version = PyLong_FromUnsignedLongLong((uint32_t)(object->nt_version));
	return py_nt_version;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_nt_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nt_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nt_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nt_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_lmnt_token(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(obj);
	PyObject *py_lmnt_token;
	py_lmnt_token = PyLong_FromLong((uint16_t)(object->lmnt_token));
	return py_lmnt_token;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_lmnt_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lmnt_token");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lmnt_token));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lmnt_token = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_get_lm20_token(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(obj);
	PyObject *py_lm20_token;
	py_lm20_token = PyLong_FromLong((uint16_t)(object->lm20_token));
	return py_lm20_token;
}

static int py_NETLOGON_SAM_LOGON_REQUEST_set_lm20_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_REQUEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm20_token");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lm20_token));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lm20_token = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_NETLOGON_SAM_LOGON_REQUEST_getsetters[] = {
	{
		.name = discard_const_p(char, "request_count"),
		.get = py_NETLOGON_SAM_LOGON_REQUEST_get_request_count,
		.set = py_NETLOGON_SAM_LOGON_REQUEST_set_request_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "computer_name"),
		.get = py_NETLOGON_SAM_LOGON_REQUEST_get_computer_name,
		.set = py_NETLOGON_SAM_LOGON_REQUEST_set_computer_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "user_name"),
		.get = py_NETLOGON_SAM_LOGON_REQUEST_get_user_name,
		.set = py_NETLOGON_SAM_LOGON_REQUEST_set_user_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "mailslot_name"),
		.get = py_NETLOGON_SAM_LOGON_REQUEST_get_mailslot_name,
		.set = py_NETLOGON_SAM_LOGON_REQUEST_set_mailslot_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "acct_control"),
		.get = py_NETLOGON_SAM_LOGON_REQUEST_get_acct_control,
		.set = py_NETLOGON_SAM_LOGON_REQUEST_set_acct_control,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sid_size"),
		.get = py_NETLOGON_SAM_LOGON_REQUEST_get_sid_size,
		.set = py_NETLOGON_SAM_LOGON_REQUEST_set_sid_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "_pad"),
		.get = py_NETLOGON_SAM_LOGON_REQUEST_get__pad,
		.set = py_NETLOGON_SAM_LOGON_REQUEST_set__pad,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "sid"),
		.get = py_NETLOGON_SAM_LOGON_REQUEST_get_sid,
		.set = py_NETLOGON_SAM_LOGON_REQUEST_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid0")
	},
	{
		.name = discard_const_p(char, "nt_version"),
		.get = py_NETLOGON_SAM_LOGON_REQUEST_get_nt_version,
		.set = py_NETLOGON_SAM_LOGON_REQUEST_set_nt_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type netlogon_nt_version_flags")
	},
	{
		.name = discard_const_p(char, "lmnt_token"),
		.get = py_NETLOGON_SAM_LOGON_REQUEST_get_lmnt_token,
		.set = py_NETLOGON_SAM_LOGON_REQUEST_set_lmnt_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "lm20_token"),
		.get = py_NETLOGON_SAM_LOGON_REQUEST_get_lm20_token,
		.set = py_NETLOGON_SAM_LOGON_REQUEST_set_lm20_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_NETLOGON_SAM_LOGON_REQUEST_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NETLOGON_SAM_LOGON_REQUEST, type);
}


static PyTypeObject NETLOGON_SAM_LOGON_REQUEST_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.NETLOGON_SAM_LOGON_REQUEST",
	.tp_getset = py_NETLOGON_SAM_LOGON_REQUEST_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NETLOGON_SAM_LOGON_REQUEST_new,
};


static PyObject *py_NETLOGON_LOGON_REQUEST_get_computer_name(PyObject *obj, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = pytalloc_get_ptr(obj);
	PyObject *py_computer_name;
	py_computer_name = PyString_FromStringOrNULL(object->computer_name);
	return py_computer_name;
}

static int py_NETLOGON_LOGON_REQUEST_set_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->computer_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->computer_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_LOGON_REQUEST_get_user_name(PyObject *obj, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = pytalloc_get_ptr(obj);
	PyObject *py_user_name;
	py_user_name = PyString_FromStringOrNULL(object->user_name);
	return py_user_name;
}

static int py_NETLOGON_LOGON_REQUEST_set_user_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->user_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_LOGON_REQUEST_get_mailslot_name(PyObject *obj, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = pytalloc_get_ptr(obj);
	PyObject *py_mailslot_name;
	py_mailslot_name = PyString_FromStringOrNULL(object->mailslot_name);
	return py_mailslot_name;
}

static int py_NETLOGON_LOGON_REQUEST_set_mailslot_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->mailslot_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->mailslot_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_LOGON_REQUEST_get_request_count(PyObject *obj, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = pytalloc_get_ptr(obj);
	PyObject *py_request_count;
	py_request_count = PyLong_FromLong((uint16_t)(object->request_count));
	return py_request_count;
}

static int py_NETLOGON_LOGON_REQUEST_set_request_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->request_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->request_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->request_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_LOGON_REQUEST_get_lmnt_token(PyObject *obj, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = pytalloc_get_ptr(obj);
	PyObject *py_lmnt_token;
	py_lmnt_token = PyLong_FromLong((uint16_t)(object->lmnt_token));
	return py_lmnt_token;
}

static int py_NETLOGON_LOGON_REQUEST_set_lmnt_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lmnt_token");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lmnt_token));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lmnt_token = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_LOGON_REQUEST_get_lm20_token(PyObject *obj, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = pytalloc_get_ptr(obj);
	PyObject *py_lm20_token;
	py_lm20_token = PyLong_FromLong((uint16_t)(object->lm20_token));
	return py_lm20_token;
}

static int py_NETLOGON_LOGON_REQUEST_set_lm20_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_LOGON_REQUEST *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm20_token");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lm20_token));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lm20_token = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_NETLOGON_LOGON_REQUEST_getsetters[] = {
	{
		.name = discard_const_p(char, "computer_name"),
		.get = py_NETLOGON_LOGON_REQUEST_get_computer_name,
		.set = py_NETLOGON_LOGON_REQUEST_set_computer_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "user_name"),
		.get = py_NETLOGON_LOGON_REQUEST_get_user_name,
		.set = py_NETLOGON_LOGON_REQUEST_set_user_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "mailslot_name"),
		.get = py_NETLOGON_LOGON_REQUEST_get_mailslot_name,
		.set = py_NETLOGON_LOGON_REQUEST_set_mailslot_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "request_count"),
		.get = py_NETLOGON_LOGON_REQUEST_get_request_count,
		.set = py_NETLOGON_LOGON_REQUEST_set_request_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "lmnt_token"),
		.get = py_NETLOGON_LOGON_REQUEST_get_lmnt_token,
		.set = py_NETLOGON_LOGON_REQUEST_set_lmnt_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "lm20_token"),
		.get = py_NETLOGON_LOGON_REQUEST_get_lm20_token,
		.set = py_NETLOGON_LOGON_REQUEST_set_lm20_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_NETLOGON_LOGON_REQUEST_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NETLOGON_LOGON_REQUEST, type);
}


static PyTypeObject NETLOGON_LOGON_REQUEST_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.NETLOGON_LOGON_REQUEST",
	.tp_getset = py_NETLOGON_LOGON_REQUEST_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NETLOGON_LOGON_REQUEST_new,
};


static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_command(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = pytalloc_get_ptr(obj);
	PyObject *py_command;
	py_command = PyLong_FromLong((uint16_t)(object->command));
	return py_command;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->command");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->command));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->command = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_pdc_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = pytalloc_get_ptr(obj);
	PyObject *py_pdc_name;
	py_pdc_name = PyString_FromStringOrNULL(object->pdc_name);
	return py_pdc_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_pdc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pdc_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->pdc_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_user_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = pytalloc_get_ptr(obj);
	PyObject *py_user_name;
	py_user_name = PyString_FromStringOrNULL(object->user_name);
	return py_user_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_user_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->user_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_domain_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = PyString_FromStringOrNULL(object->domain_name);
	return py_domain_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->domain_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_nt_version(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = pytalloc_get_ptr(obj);
	PyObject *py_nt_version;
	py_nt_version = PyLong_FromUnsignedLongLong((uint32_t)(object->nt_version));
	return py_nt_version;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_nt_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nt_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nt_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nt_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_lmnt_token(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = pytalloc_get_ptr(obj);
	PyObject *py_lmnt_token;
	py_lmnt_token = PyLong_FromLong((uint16_t)(object->lmnt_token));
	return py_lmnt_token;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_lmnt_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lmnt_token");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lmnt_token));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lmnt_token = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_lm20_token(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = pytalloc_get_ptr(obj);
	PyObject *py_lm20_token;
	py_lm20_token = PyLong_FromLong((uint16_t)(object->lm20_token));
	return py_lm20_token;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_lm20_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm20_token");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lm20_token));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lm20_token = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_NETLOGON_SAM_LOGON_RESPONSE_NT40_getsetters[] = {
	{
		.name = discard_const_p(char, "command"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_command,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_command,
		.doc = discard_const_p(char, "PIDL-generated element of base type netlogon_command")
	},
	{
		.name = discard_const_p(char, "pdc_name"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_pdc_name,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_pdc_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "user_name"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_user_name,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_user_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_domain_name,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "nt_version"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_nt_version,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_nt_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type netlogon_nt_version_flags")
	},
	{
		.name = discard_const_p(char, "lmnt_token"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_lmnt_token,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_lmnt_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "lm20_token"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_get_lm20_token,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_set_lm20_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NETLOGON_SAM_LOGON_RESPONSE_NT40, type);
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_NETLOGON_SAM_LOGON_RESPONSE_NT40);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NETLOGON_SAM_LOGON_RESPONSE_NT40);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NETLOGON_SAM_LOGON_RESPONSE_NT40);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_NT40_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NETLOGON_SAM_LOGON_RESPONSE_NT40, "NETLOGON_SAM_LOGON_RESPONSE_NT40", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NETLOGON_SAM_LOGON_RESPONSE_NT40, "NETLOGON_SAM_LOGON_RESPONSE_NT40", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NETLOGON_SAM_LOGON_RESPONSE_NT40_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NETLOGON_SAM_LOGON_RESPONSE_NT40_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NETLOGON_SAM_LOGON_RESPONSE_NT40_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NETLOGON_SAM_LOGON_RESPONSE_NT40_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NETLOGON_SAM_LOGON_RESPONSE_NT40_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.NETLOGON_SAM_LOGON_RESPONSE_NT40",
	.tp_getset = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_getsetters,
	.tp_methods = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NETLOGON_SAM_LOGON_RESPONSE_NT40_new,
};


static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_command(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_command;
	py_command = PyLong_FromLong((uint16_t)(object->command));
	return py_command;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->command");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->command));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->command = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_pdc_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_pdc_name;
	py_pdc_name = PyString_FromStringOrNULL(object->pdc_name);
	return py_pdc_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_pdc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pdc_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->pdc_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_user_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_user_name;
	py_user_name = PyString_FromStringOrNULL(object->user_name);
	return py_user_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_user_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->user_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_domain_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = PyString_FromStringOrNULL(object->domain_name);
	return py_domain_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->domain_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_domain_uuid(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_uuid;
	py_domain_uuid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->domain_uuid);
	return py_domain_uuid;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_domain_uuid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_uuid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_uuid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_zero_uuid(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_zero_uuid;
	py_zero_uuid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->zero_uuid);
	return py_zero_uuid;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_zero_uuid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->zero_uuid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->zero_uuid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_forest(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_forest;
	py_forest = PyString_FromStringOrNULL(object->forest);
	return py_forest;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_forest(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->forest");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->forest = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_dns_domain(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_domain;
	py_dns_domain = PyString_FromStringOrNULL(object->dns_domain);
	return py_dns_domain;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_dns_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dns_domain");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->dns_domain = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_pdc_dns_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_pdc_dns_name;
	py_pdc_dns_name = PyString_FromStringOrNULL(object->pdc_dns_name);
	return py_pdc_dns_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_pdc_dns_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pdc_dns_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->pdc_dns_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_pdc_ip(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_pdc_ip;
	py_pdc_ip = PyString_FromStringOrNULL(object->pdc_ip);
	return py_pdc_ip;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_pdc_ip(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pdc_ip");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->pdc_ip = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_server_type(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_server_type;
	py_server_type = PyLong_FromUnsignedLongLong((uint32_t)(object->server_type));
	return py_server_type;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_server_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->server_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->server_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_nt_version(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_nt_version;
	py_nt_version = PyLong_FromUnsignedLongLong((uint32_t)(object->nt_version));
	return py_nt_version;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_nt_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nt_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nt_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nt_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_lmnt_token(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_lmnt_token;
	py_lmnt_token = PyLong_FromLong((uint16_t)(object->lmnt_token));
	return py_lmnt_token;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_lmnt_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lmnt_token");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lmnt_token));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lmnt_token = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_get_lm20_token(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(obj);
	PyObject *py_lm20_token;
	py_lm20_token = PyLong_FromLong((uint16_t)(object->lm20_token));
	return py_lm20_token;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_set_lm20_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm20_token");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lm20_token));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lm20_token = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_NETLOGON_SAM_LOGON_RESPONSE_getsetters[] = {
	{
		.name = discard_const_p(char, "command"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_get_command,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_set_command,
		.doc = discard_const_p(char, "PIDL-generated element of base type netlogon_command")
	},
	{
		.name = discard_const_p(char, "pdc_name"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_get_pdc_name,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_set_pdc_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "user_name"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_get_user_name,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_set_user_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_get_domain_name,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "domain_uuid"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_get_domain_uuid,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_set_domain_uuid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "zero_uuid"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_get_zero_uuid,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_set_zero_uuid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "forest"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_get_forest,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_set_forest,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_string")
	},
	{
		.name = discard_const_p(char, "dns_domain"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_get_dns_domain,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_set_dns_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_string")
	},
	{
		.name = discard_const_p(char, "pdc_dns_name"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_get_pdc_dns_name,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_set_pdc_dns_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_string")
	},
	{
		.name = discard_const_p(char, "pdc_ip"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_get_pdc_ip,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_set_pdc_ip,
		.doc = discard_const_p(char, "PIDL-generated element of base type ipv4address")
	},
	{
		.name = discard_const_p(char, "server_type"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_get_server_type,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_set_server_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_server_type")
	},
	{
		.name = discard_const_p(char, "nt_version"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_get_nt_version,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_set_nt_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type netlogon_nt_version_flags")
	},
	{
		.name = discard_const_p(char, "lmnt_token"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_get_lmnt_token,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_set_lmnt_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "lm20_token"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_get_lm20_token,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_set_lm20_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NETLOGON_SAM_LOGON_RESPONSE, type);
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_NETLOGON_SAM_LOGON_RESPONSE);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NETLOGON_SAM_LOGON_RESPONSE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NETLOGON_SAM_LOGON_RESPONSE);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NETLOGON_SAM_LOGON_RESPONSE *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NETLOGON_SAM_LOGON_RESPONSE, "NETLOGON_SAM_LOGON_RESPONSE", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NETLOGON_SAM_LOGON_RESPONSE, "NETLOGON_SAM_LOGON_RESPONSE", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NETLOGON_SAM_LOGON_RESPONSE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NETLOGON_SAM_LOGON_RESPONSE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NETLOGON_SAM_LOGON_RESPONSE_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NETLOGON_SAM_LOGON_RESPONSE_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NETLOGON_SAM_LOGON_RESPONSE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.NETLOGON_SAM_LOGON_RESPONSE",
	.tp_getset = py_NETLOGON_SAM_LOGON_RESPONSE_getsetters,
	.tp_methods = py_NETLOGON_SAM_LOGON_RESPONSE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NETLOGON_SAM_LOGON_RESPONSE_new,
};


static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_command(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(obj);
	PyObject *py_command;
	py_command = PyLong_FromLong((uint16_t)(object->command));
	return py_command;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->command");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->command));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->command = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_sbz(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(obj);
	PyObject *py_sbz;
	py_sbz = PyLong_FromLong((uint16_t)(object->sbz));
	return py_sbz;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_sbz(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sbz");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sbz));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sbz = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_server_type(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(obj);
	PyObject *py_server_type;
	py_server_type = PyLong_FromUnsignedLongLong((uint32_t)(object->server_type));
	return py_server_type;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_server_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->server_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->server_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_domain_uuid(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_uuid;
	py_domain_uuid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->domain_uuid);
	return py_domain_uuid;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_domain_uuid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_uuid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_uuid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_forest(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(obj);
	PyObject *py_forest;
	py_forest = PyString_FromStringOrNULL(object->forest);
	return py_forest;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_forest(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->forest");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->forest = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_dns_domain(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_domain;
	py_dns_domain = PyString_FromStringOrNULL(object->dns_domain);
	return py_dns_domain;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_dns_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dns_domain");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->dns_domain = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_pdc_dns_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(obj);
	PyObject *py_pdc_dns_name;
	py_pdc_dns_name = PyString_FromStringOrNULL(object->pdc_dns_name);
	return py_pdc_dns_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_pdc_dns_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pdc_dns_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->pdc_dns_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_domain_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = PyString_FromStringOrNULL(object->domain_name);
	return py_domain_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->domain_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_pdc_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(obj);
	PyObject *py_pdc_name;
	py_pdc_name = PyString_FromStringOrNULL(object->pdc_name);
	return py_pdc_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_pdc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pdc_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->pdc_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_user_name(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(obj);
	PyObject *py_user_name;
	py_user_name = PyString_FromStringOrNULL(object->user_name);
	return py_user_name;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_user_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->user_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_server_site(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(obj);
	PyObject *py_server_site;
	py_server_site = PyString_FromStringOrNULL(object->server_site);
	return py_server_site;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_server_site(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_site");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->server_site = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_client_site(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(obj);
	PyObject *py_client_site;
	py_client_site = PyString_FromStringOrNULL(object->client_site);
	return py_client_site;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_client_site(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_site");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->client_site = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_sockaddr_size(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(obj);
	PyObject *py_sockaddr_size;
	py_sockaddr_size = PyLong_FromLong((uint16_t)(object->sockaddr_size));
	return py_sockaddr_size;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_sockaddr_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sockaddr_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sockaddr_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sockaddr_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_sockaddr(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(obj);
	PyObject *py_sockaddr;
	py_sockaddr = pytalloc_reference_ex(&nbt_sockaddr_Type, pytalloc_get_mem_ctx(obj), &object->sockaddr);
	return py_sockaddr;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_sockaddr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sockaddr");
		return -1;
	}
	PY_CHECK_TYPE(&nbt_sockaddr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sockaddr = *(struct nbt_sockaddr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_next_closest_site(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(obj);
	PyObject *py_next_closest_site;
	py_next_closest_site = PyString_FromStringOrNULL(object->next_closest_site);
	return py_next_closest_site;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_next_closest_site(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->next_closest_site");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->next_closest_site = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_nt_version(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(obj);
	PyObject *py_nt_version;
	py_nt_version = PyLong_FromUnsignedLongLong((uint32_t)(object->nt_version));
	return py_nt_version;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_nt_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nt_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nt_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nt_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_lmnt_token(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(obj);
	PyObject *py_lmnt_token;
	py_lmnt_token = PyLong_FromLong((uint16_t)(object->lmnt_token));
	return py_lmnt_token;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_lmnt_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lmnt_token");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lmnt_token));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lmnt_token = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_lm20_token(PyObject *obj, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(obj);
	PyObject *py_lm20_token;
	py_lm20_token = PyLong_FromLong((uint16_t)(object->lm20_token));
	return py_lm20_token;
}

static int py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_lm20_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm20_token");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lm20_token));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lm20_token = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_NETLOGON_SAM_LOGON_RESPONSE_EX_getsetters[] = {
	{
		.name = discard_const_p(char, "command"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_command,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_command,
		.doc = discard_const_p(char, "PIDL-generated element of base type netlogon_command")
	},
	{
		.name = discard_const_p(char, "sbz"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_sbz,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_sbz,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "server_type"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_server_type,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_server_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_server_type")
	},
	{
		.name = discard_const_p(char, "domain_uuid"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_domain_uuid,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_domain_uuid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "forest"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_forest,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_forest,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_string")
	},
	{
		.name = discard_const_p(char, "dns_domain"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_dns_domain,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_dns_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_string")
	},
	{
		.name = discard_const_p(char, "pdc_dns_name"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_pdc_dns_name,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_pdc_dns_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_string")
	},
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_domain_name,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_string")
	},
	{
		.name = discard_const_p(char, "pdc_name"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_pdc_name,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_pdc_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_string")
	},
	{
		.name = discard_const_p(char, "user_name"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_user_name,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_user_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_string")
	},
	{
		.name = discard_const_p(char, "server_site"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_server_site,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_server_site,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_string")
	},
	{
		.name = discard_const_p(char, "client_site"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_client_site,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_client_site,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_string")
	},
	{
		.name = discard_const_p(char, "sockaddr_size"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_sockaddr_size,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_sockaddr_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "sockaddr"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_sockaddr,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_sockaddr,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_sockaddr")
	},
	{
		.name = discard_const_p(char, "next_closest_site"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_next_closest_site,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_next_closest_site,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_string")
	},
	{
		.name = discard_const_p(char, "nt_version"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_nt_version,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_nt_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type netlogon_nt_version_flags")
	},
	{
		.name = discard_const_p(char, "lmnt_token"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_lmnt_token,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_lmnt_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "lm20_token"),
		.get = py_NETLOGON_SAM_LOGON_RESPONSE_EX_get_lm20_token,
		.set = py_NETLOGON_SAM_LOGON_RESPONSE_EX_set_lm20_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NETLOGON_SAM_LOGON_RESPONSE_EX, type);
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_NETLOGON_SAM_LOGON_RESPONSE_EX);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NETLOGON_SAM_LOGON_RESPONSE_EX);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NETLOGON_SAM_LOGON_RESPONSE_EX);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NETLOGON_SAM_LOGON_RESPONSE_EX_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NETLOGON_SAM_LOGON_RESPONSE_EX *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NETLOGON_SAM_LOGON_RESPONSE_EX, "NETLOGON_SAM_LOGON_RESPONSE_EX", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NETLOGON_SAM_LOGON_RESPONSE_EX, "NETLOGON_SAM_LOGON_RESPONSE_EX", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NETLOGON_SAM_LOGON_RESPONSE_EX_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NETLOGON_SAM_LOGON_RESPONSE_EX_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NETLOGON_SAM_LOGON_RESPONSE_EX_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_NETLOGON_SAM_LOGON_RESPONSE_EX_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NETLOGON_SAM_LOGON_RESPONSE_EX_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.NETLOGON_SAM_LOGON_RESPONSE_EX",
	.tp_getset = py_NETLOGON_SAM_LOGON_RESPONSE_EX_getsetters,
	.tp_methods = py_NETLOGON_SAM_LOGON_RESPONSE_EX_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NETLOGON_SAM_LOGON_RESPONSE_EX_new,
};

static PyObject *py_import_netlogon_samlogon_response_union(TALLOC_CTX *mem_ctx, int level, union netlogon_samlogon_response_union *in)
{
	PyObject *ret;

	switch (level) {
		case NETLOGON_NT_VERSION_1:
			ret = pytalloc_reference_ex(&NETLOGON_SAM_LOGON_RESPONSE_NT40_Type, mem_ctx, &in->nt4);
			return ret;

		case NETLOGON_NT_VERSION_5:
			ret = pytalloc_reference_ex(&NETLOGON_SAM_LOGON_RESPONSE_Type, mem_ctx, &in->nt5);
			return ret;

		case NETLOGON_NT_VERSION_5EX:
			ret = pytalloc_reference_ex(&NETLOGON_SAM_LOGON_RESPONSE_EX_Type, mem_ctx, &in->nt5_ex);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union netlogon_samlogon_response_union *py_export_netlogon_samlogon_response_union(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netlogon_samlogon_response_union *ret = talloc_zero(mem_ctx, union netlogon_samlogon_response_union);
	switch (level) {
		case NETLOGON_NT_VERSION_1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->nt4");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&NETLOGON_SAM_LOGON_RESPONSE_NT40_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->nt4 = *(struct NETLOGON_SAM_LOGON_RESPONSE_NT40 *)pytalloc_get_ptr(in);
			break;

		case NETLOGON_NT_VERSION_5:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->nt5");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&NETLOGON_SAM_LOGON_RESPONSE_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->nt5 = *(struct NETLOGON_SAM_LOGON_RESPONSE *)pytalloc_get_ptr(in);
			break;

		case NETLOGON_NT_VERSION_5EX:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->nt5_ex");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&NETLOGON_SAM_LOGON_RESPONSE_EX_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->nt5_ex = *(struct NETLOGON_SAM_LOGON_RESPONSE_EX *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_netlogon_samlogon_response_union_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union netlogon_samlogon_response_union *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union netlogon_samlogon_response_union *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union netlogon_samlogon_response_union!");
		return NULL;
	}

	return py_import_netlogon_samlogon_response_union(mem_ctx, level, in);
}

static PyObject *py_netlogon_samlogon_response_union_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union netlogon_samlogon_response_union *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_netlogon_samlogon_response_union(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_netlogon_samlogon_response_union_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netlogon_samlogon_response_union_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netlogon_samlogon_response_union_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_netlogon_samlogon_response_union_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject netlogon_samlogon_response_union_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.netlogon_samlogon_response_union",
	.tp_getset = NULL,
	.tp_methods = py_netlogon_samlogon_response_union_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netlogon_samlogon_response_union_new,
};


static PyObject *py_netlogon_samlogon_response_get_ntver(PyObject *obj, void *closure)
{
	struct netlogon_samlogon_response *object = pytalloc_get_ptr(obj);
	PyObject *py_ntver;
	py_ntver = PyLong_FromUnsignedLongLong((uint32_t)(object->ntver));
	return py_ntver;
}

static int py_netlogon_samlogon_response_set_ntver(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_samlogon_response *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ntver");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ntver));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ntver = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netlogon_samlogon_response_get_data(PyObject *obj, void *closure)
{
	struct netlogon_samlogon_response *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = pyrpc_import_union(&netlogon_samlogon_response_union_Type, pytalloc_get_mem_ctx(obj), object->ntver, &object->data, "union netlogon_samlogon_response_union");
	if (py_data == NULL) {
		return NULL;
	}
	return py_data;
}

static int py_netlogon_samlogon_response_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netlogon_samlogon_response *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	{
		union netlogon_samlogon_response_union *data_switch_0;
		data_switch_0 = (union netlogon_samlogon_response_union *)pyrpc_export_union(&netlogon_samlogon_response_union_Type, pytalloc_get_mem_ctx(py_obj), object->ntver, value, "union netlogon_samlogon_response_union");
		if (data_switch_0 == NULL) {
			return -1;
		}
		object->data = *data_switch_0;
	}
	return 0;
}

static PyGetSetDef py_netlogon_samlogon_response_getsetters[] = {
	{
		.name = discard_const_p(char, "ntver"),
		.get = py_netlogon_samlogon_response_get_ntver,
		.set = py_netlogon_samlogon_response_set_ntver,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_netlogon_samlogon_response_get_data,
		.set = py_netlogon_samlogon_response_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type netlogon_samlogon_response_union")
	},
	{ .name = NULL }
};

static PyObject *py_netlogon_samlogon_response_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netlogon_samlogon_response, type);
}

static PyObject *py_netlogon_samlogon_response_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct netlogon_samlogon_response *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_netlogon_samlogon_response);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_netlogon_samlogon_response_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netlogon_samlogon_response *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netlogon_samlogon_response);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netlogon_samlogon_response);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netlogon_samlogon_response_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netlogon_samlogon_response *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netlogon_samlogon_response, "netlogon_samlogon_response", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netlogon_samlogon_response, "netlogon_samlogon_response", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netlogon_samlogon_response_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netlogon_samlogon_response_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netlogon_samlogon_response_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_netlogon_samlogon_response_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netlogon_samlogon_response_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.netlogon_samlogon_response",
	.tp_getset = py_netlogon_samlogon_response_getsetters,
	.tp_methods = py_netlogon_samlogon_response_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_netlogon_samlogon_response_new,
};


static PyObject *py_nbt_netlogon_query_for_pdc_get_computer_name(PyObject *obj, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = pytalloc_get_ptr(obj);
	PyObject *py_computer_name;
	py_computer_name = PyString_FromStringOrNULL(object->computer_name);
	return py_computer_name;
}

static int py_nbt_netlogon_query_for_pdc_set_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->computer_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->computer_name = talloc_str;
	}
	return 0;
}

static PyObject *py_nbt_netlogon_query_for_pdc_get_mailslot_name(PyObject *obj, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = pytalloc_get_ptr(obj);
	PyObject *py_mailslot_name;
	py_mailslot_name = PyString_FromStringOrNULL(object->mailslot_name);
	return py_mailslot_name;
}

static int py_nbt_netlogon_query_for_pdc_set_mailslot_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->mailslot_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->mailslot_name = talloc_str;
	}
	return 0;
}

static PyObject *py_nbt_netlogon_query_for_pdc_get__pad(PyObject *obj, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyBytes_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_nbt_netlogon_query_for_pdc_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->_pad");
		return -1;
	}
	object->_pad = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_nbt_netlogon_query_for_pdc_get_unicode_name(PyObject *obj, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = pytalloc_get_ptr(obj);
	PyObject *py_unicode_name;
	py_unicode_name = PyString_FromStringOrNULL(object->unicode_name);
	return py_unicode_name;
}

static int py_nbt_netlogon_query_for_pdc_set_unicode_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unicode_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->unicode_name = talloc_str;
	}
	return 0;
}

static PyObject *py_nbt_netlogon_query_for_pdc_get_nt_version(PyObject *obj, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = pytalloc_get_ptr(obj);
	PyObject *py_nt_version;
	py_nt_version = PyLong_FromUnsignedLongLong((uint32_t)(object->nt_version));
	return py_nt_version;
}

static int py_nbt_netlogon_query_for_pdc_set_nt_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nt_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nt_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nt_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_netlogon_query_for_pdc_get_lmnt_token(PyObject *obj, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = pytalloc_get_ptr(obj);
	PyObject *py_lmnt_token;
	py_lmnt_token = PyLong_FromLong((uint16_t)(object->lmnt_token));
	return py_lmnt_token;
}

static int py_nbt_netlogon_query_for_pdc_set_lmnt_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lmnt_token");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lmnt_token));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lmnt_token = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_netlogon_query_for_pdc_get_lm20_token(PyObject *obj, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = pytalloc_get_ptr(obj);
	PyObject *py_lm20_token;
	py_lm20_token = PyLong_FromLong((uint16_t)(object->lm20_token));
	return py_lm20_token;
}

static int py_nbt_netlogon_query_for_pdc_set_lm20_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_query_for_pdc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm20_token");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lm20_token));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lm20_token = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_nbt_netlogon_query_for_pdc_getsetters[] = {
	{
		.name = discard_const_p(char, "computer_name"),
		.get = py_nbt_netlogon_query_for_pdc_get_computer_name,
		.set = py_nbt_netlogon_query_for_pdc_set_computer_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "mailslot_name"),
		.get = py_nbt_netlogon_query_for_pdc_get_mailslot_name,
		.set = py_nbt_netlogon_query_for_pdc_set_mailslot_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "_pad"),
		.get = py_nbt_netlogon_query_for_pdc_get__pad,
		.set = py_nbt_netlogon_query_for_pdc_set__pad,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "unicode_name"),
		.get = py_nbt_netlogon_query_for_pdc_get_unicode_name,
		.set = py_nbt_netlogon_query_for_pdc_set_unicode_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "nt_version"),
		.get = py_nbt_netlogon_query_for_pdc_get_nt_version,
		.set = py_nbt_netlogon_query_for_pdc_set_nt_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type netlogon_nt_version_flags")
	},
	{
		.name = discard_const_p(char, "lmnt_token"),
		.get = py_nbt_netlogon_query_for_pdc_get_lmnt_token,
		.set = py_nbt_netlogon_query_for_pdc_set_lmnt_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "lm20_token"),
		.get = py_nbt_netlogon_query_for_pdc_get_lm20_token,
		.set = py_nbt_netlogon_query_for_pdc_set_lm20_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_netlogon_query_for_pdc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_netlogon_query_for_pdc, type);
}


static PyTypeObject nbt_netlogon_query_for_pdc_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.netlogon_query_for_pdc",
	.tp_getset = py_nbt_netlogon_query_for_pdc_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_netlogon_query_for_pdc_new,
};


static PyObject *py_nbt_netlogon_response_from_pdc_get_command(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(obj);
	PyObject *py_command;
	py_command = PyLong_FromLong((uint16_t)(object->command));
	return py_command;
}

static int py_nbt_netlogon_response_from_pdc_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->command");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->command));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->command = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_netlogon_response_from_pdc_get_pdc_name(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(obj);
	PyObject *py_pdc_name;
	py_pdc_name = PyString_FromStringOrNULL(object->pdc_name);
	return py_pdc_name;
}

static int py_nbt_netlogon_response_from_pdc_set_pdc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pdc_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->pdc_name = talloc_str;
	}
	return 0;
}

static PyObject *py_nbt_netlogon_response_from_pdc_get__pad(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyBytes_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_nbt_netlogon_response_from_pdc_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->_pad");
		return -1;
	}
	object->_pad = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_nbt_netlogon_response_from_pdc_get_unicode_pdc_name(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(obj);
	PyObject *py_unicode_pdc_name;
	py_unicode_pdc_name = PyString_FromStringOrNULL(object->unicode_pdc_name);
	return py_unicode_pdc_name;
}

static int py_nbt_netlogon_response_from_pdc_set_unicode_pdc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unicode_pdc_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->unicode_pdc_name = talloc_str;
	}
	return 0;
}

static PyObject *py_nbt_netlogon_response_from_pdc_get_domain_name(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = PyString_FromStringOrNULL(object->domain_name);
	return py_domain_name;
}

static int py_nbt_netlogon_response_from_pdc_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->domain_name = talloc_str;
	}
	return 0;
}

static PyObject *py_nbt_netlogon_response_from_pdc_get_nt_version(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(obj);
	PyObject *py_nt_version;
	py_nt_version = PyLong_FromUnsignedLongLong((uint32_t)(object->nt_version));
	return py_nt_version;
}

static int py_nbt_netlogon_response_from_pdc_set_nt_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nt_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nt_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nt_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_netlogon_response_from_pdc_get_lmnt_token(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(obj);
	PyObject *py_lmnt_token;
	py_lmnt_token = PyLong_FromLong((uint16_t)(object->lmnt_token));
	return py_lmnt_token;
}

static int py_nbt_netlogon_response_from_pdc_set_lmnt_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lmnt_token");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lmnt_token));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lmnt_token = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_netlogon_response_from_pdc_get_lm20_token(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(obj);
	PyObject *py_lm20_token;
	py_lm20_token = PyLong_FromLong((uint16_t)(object->lm20_token));
	return py_lm20_token;
}

static int py_nbt_netlogon_response_from_pdc_set_lm20_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm20_token");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lm20_token));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lm20_token = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_nbt_netlogon_response_from_pdc_getsetters[] = {
	{
		.name = discard_const_p(char, "command"),
		.get = py_nbt_netlogon_response_from_pdc_get_command,
		.set = py_nbt_netlogon_response_from_pdc_set_command,
		.doc = discard_const_p(char, "PIDL-generated element of base type netlogon_command")
	},
	{
		.name = discard_const_p(char, "pdc_name"),
		.get = py_nbt_netlogon_response_from_pdc_get_pdc_name,
		.set = py_nbt_netlogon_response_from_pdc_set_pdc_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "_pad"),
		.get = py_nbt_netlogon_response_from_pdc_get__pad,
		.set = py_nbt_netlogon_response_from_pdc_set__pad,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "unicode_pdc_name"),
		.get = py_nbt_netlogon_response_from_pdc_get_unicode_pdc_name,
		.set = py_nbt_netlogon_response_from_pdc_set_unicode_pdc_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_nbt_netlogon_response_from_pdc_get_domain_name,
		.set = py_nbt_netlogon_response_from_pdc_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "nt_version"),
		.get = py_nbt_netlogon_response_from_pdc_get_nt_version,
		.set = py_nbt_netlogon_response_from_pdc_set_nt_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type netlogon_nt_version_flags")
	},
	{
		.name = discard_const_p(char, "lmnt_token"),
		.get = py_nbt_netlogon_response_from_pdc_get_lmnt_token,
		.set = py_nbt_netlogon_response_from_pdc_set_lmnt_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "lm20_token"),
		.get = py_nbt_netlogon_response_from_pdc_get_lm20_token,
		.set = py_nbt_netlogon_response_from_pdc_set_lm20_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_netlogon_response_from_pdc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_netlogon_response_from_pdc, type);
}

static PyObject *py_nbt_netlogon_response_from_pdc_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_nbt_netlogon_response_from_pdc);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_nbt_netlogon_response_from_pdc_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_netlogon_response_from_pdc);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_netlogon_response_from_pdc);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_nbt_netlogon_response_from_pdc_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_netlogon_response_from_pdc *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_netlogon_response_from_pdc, "nbt_netlogon_response_from_pdc", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_netlogon_response_from_pdc, "nbt_netlogon_response_from_pdc", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_nbt_netlogon_response_from_pdc_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_nbt_netlogon_response_from_pdc_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_netlogon_response_from_pdc_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_netlogon_response_from_pdc_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbt_netlogon_response_from_pdc_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.netlogon_response_from_pdc",
	.tp_getset = py_nbt_netlogon_response_from_pdc_getsetters,
	.tp_methods = py_nbt_netlogon_response_from_pdc_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_netlogon_response_from_pdc_new,
};


static PyObject *py_nbt_netlogon_response2_get_command(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response2 *object = pytalloc_get_ptr(obj);
	PyObject *py_command;
	py_command = PyLong_FromLong((uint16_t)(object->command));
	return py_command;
}

static int py_nbt_netlogon_response2_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->command");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->command));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->command = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_netlogon_response2_get_pdc_name(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response2 *object = pytalloc_get_ptr(obj);
	PyObject *py_pdc_name;
	py_pdc_name = PyString_FromStringOrNULL(object->pdc_name);
	return py_pdc_name;
}

static int py_nbt_netlogon_response2_set_pdc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pdc_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->pdc_name = talloc_str;
	}
	return 0;
}

static PyObject *py_nbt_netlogon_response2_get_lm20_token(PyObject *obj, void *closure)
{
	struct nbt_netlogon_response2 *object = pytalloc_get_ptr(obj);
	PyObject *py_lm20_token;
	py_lm20_token = PyLong_FromLong((uint16_t)(object->lm20_token));
	return py_lm20_token;
}

static int py_nbt_netlogon_response2_set_lm20_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_response2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm20_token");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lm20_token));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lm20_token = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_nbt_netlogon_response2_getsetters[] = {
	{
		.name = discard_const_p(char, "command"),
		.get = py_nbt_netlogon_response2_get_command,
		.set = py_nbt_netlogon_response2_set_command,
		.doc = discard_const_p(char, "PIDL-generated element of base type netlogon_command")
	},
	{
		.name = discard_const_p(char, "pdc_name"),
		.get = py_nbt_netlogon_response2_get_pdc_name,
		.set = py_nbt_netlogon_response2_set_pdc_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "lm20_token"),
		.get = py_nbt_netlogon_response2_get_lm20_token,
		.set = py_nbt_netlogon_response2_set_lm20_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_netlogon_response2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_netlogon_response2, type);
}

static PyObject *py_nbt_netlogon_response2_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct nbt_netlogon_response2 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_nbt_netlogon_response2);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_nbt_netlogon_response2_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_netlogon_response2 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_netlogon_response2);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_netlogon_response2);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_nbt_netlogon_response2_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_netlogon_response2 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_netlogon_response2, "nbt_netlogon_response2", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_netlogon_response2, "nbt_netlogon_response2", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_nbt_netlogon_response2_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_nbt_netlogon_response2_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_netlogon_response2_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_netlogon_response2_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbt_netlogon_response2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.netlogon_response2",
	.tp_getset = py_nbt_netlogon_response2_getsetters,
	.tp_methods = py_nbt_netlogon_response2_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_netlogon_response2_new,
};


static PyObject *py_nbt_db_change_info_get_db_index(PyObject *obj, void *closure)
{
	struct nbt_db_change_info *object = pytalloc_get_ptr(obj);
	PyObject *py_db_index;
	py_db_index = PyLong_FromUnsignedLongLong((uint32_t)(object->db_index));
	return py_db_index;
}

static int py_nbt_db_change_info_set_db_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_db_change_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->db_index");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->db_index));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->db_index = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_db_change_info_get_serial(PyObject *obj, void *closure)
{
	struct nbt_db_change_info *object = pytalloc_get_ptr(obj);
	PyObject *py_serial;
	py_serial = PyLong_FromUnsignedLongLong(object->serial);
	return py_serial;
}

static int py_nbt_db_change_info_set_serial(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_db_change_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->serial");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->serial));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->serial = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_db_change_info_get_timestamp(PyObject *obj, void *closure)
{
	struct nbt_db_change_info *object = pytalloc_get_ptr(obj);
	PyObject *py_timestamp;
	py_timestamp = PyLong_FromUnsignedLongLong(object->timestamp);
	return py_timestamp;
}

static int py_nbt_db_change_info_set_timestamp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_db_change_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->timestamp");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->timestamp));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->timestamp = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_nbt_db_change_info_getsetters[] = {
	{
		.name = discard_const_p(char, "db_index"),
		.get = py_nbt_db_change_info_get_db_index,
		.set = py_nbt_db_change_info_set_db_index,
		.doc = discard_const_p(char, "PIDL-generated element of base type netr_SamDatabaseID")
	},
	{
		.name = discard_const_p(char, "serial"),
		.get = py_nbt_db_change_info_get_serial,
		.set = py_nbt_db_change_info_set_serial,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "timestamp"),
		.get = py_nbt_db_change_info_get_timestamp,
		.set = py_nbt_db_change_info_set_timestamp,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_db_change_info_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_db_change_info, type);
}


static PyTypeObject nbt_db_change_info_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.db_change_info",
	.tp_getset = py_nbt_db_change_info_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_db_change_info_new,
};


static PyObject *py_NETLOGON_DB_CHANGE_get_serial_lo(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(obj);
	PyObject *py_serial_lo;
	py_serial_lo = PyLong_FromUnsignedLongLong((uint32_t)(object->serial_lo));
	return py_serial_lo;
}

static int py_NETLOGON_DB_CHANGE_set_serial_lo(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->serial_lo");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->serial_lo));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->serial_lo = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_timestamp(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(obj);
	PyObject *py_timestamp;
	py_timestamp = PyLong_FromLong(object->timestamp);
	return py_timestamp;
}

static int py_NETLOGON_DB_CHANGE_set_timestamp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->timestamp");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->timestamp));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->timestamp = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_pulse(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(obj);
	PyObject *py_pulse;
	py_pulse = PyLong_FromUnsignedLongLong((uint32_t)(object->pulse));
	return py_pulse;
}

static int py_NETLOGON_DB_CHANGE_set_pulse(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pulse");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pulse));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pulse = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_random(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(obj);
	PyObject *py_random;
	py_random = PyLong_FromUnsignedLongLong((uint32_t)(object->random));
	return py_random;
}

static int py_NETLOGON_DB_CHANGE_set_random(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->random");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->random));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->random = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_pdc_name(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(obj);
	PyObject *py_pdc_name;
	py_pdc_name = PyString_FromStringOrNULL(object->pdc_name);
	return py_pdc_name;
}

static int py_NETLOGON_DB_CHANGE_set_pdc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pdc_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->pdc_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_domain(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(obj);
	PyObject *py_domain;
	py_domain = PyString_FromStringOrNULL(object->domain);
	return py_domain;
}

static int py_NETLOGON_DB_CHANGE_set_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->domain = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get__pad(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyBytes_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_NETLOGON_DB_CHANGE_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->_pad");
		return -1;
	}
	object->_pad = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_unicode_pdc_name(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(obj);
	PyObject *py_unicode_pdc_name;
	py_unicode_pdc_name = PyString_FromStringOrNULL(object->unicode_pdc_name);
	return py_unicode_pdc_name;
}

static int py_NETLOGON_DB_CHANGE_set_unicode_pdc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unicode_pdc_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->unicode_pdc_name = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_unicode_domain(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(obj);
	PyObject *py_unicode_domain;
	py_unicode_domain = PyString_FromStringOrNULL(object->unicode_domain);
	return py_unicode_domain;
}

static int py_NETLOGON_DB_CHANGE_set_unicode_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unicode_domain");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->unicode_domain = talloc_str;
	}
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_db_count(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(obj);
	PyObject *py_db_count;
	py_db_count = PyLong_FromUnsignedLongLong((uint32_t)(object->db_count));
	return py_db_count;
}

static int py_NETLOGON_DB_CHANGE_set_db_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->db_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->db_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->db_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_dbchange(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(obj);
	PyObject *py_dbchange;
	py_dbchange = PyList_New(object->db_count);
	if (py_dbchange == NULL) {
		return NULL;
	}
	{
		int dbchange_cntr_0;
		for (dbchange_cntr_0 = 0; dbchange_cntr_0 < (object->db_count); dbchange_cntr_0++) {
			PyObject *py_dbchange_0;
			py_dbchange_0 = pytalloc_reference_ex(&nbt_db_change_info_Type, object->dbchange, &(object->dbchange)[dbchange_cntr_0]);
			PyList_SetItem(py_dbchange, dbchange_cntr_0, py_dbchange_0);
		}
	}
	return py_dbchange;
}

static int py_NETLOGON_DB_CHANGE_set_dbchange(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dbchange");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dbchange_cntr_0;
		object->dbchange = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->dbchange, PyList_GET_SIZE(value));
		if (!object->dbchange) { return -1; }
		talloc_set_name_const(object->dbchange, "ARRAY: object->dbchange");
		for (dbchange_cntr_0 = 0; dbchange_cntr_0 < PyList_GET_SIZE(value); dbchange_cntr_0++) {
			if (PyList_GET_ITEM(value, dbchange_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->dbchange)[dbchange_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&nbt_db_change_info_Type, PyList_GET_ITEM(value, dbchange_cntr_0), return -1;);
			if (talloc_reference(object->dbchange, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, dbchange_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->dbchange)[dbchange_cntr_0] = *(struct nbt_db_change_info *)pytalloc_get_ptr(PyList_GET_ITEM(value, dbchange_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_sid_size(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(obj);
	PyObject *py_sid_size;
	py_sid_size = PyLong_FromUnsignedLongLong((uint32_t)(object->sid_size));
	return py_sid_size;
}

static int py_NETLOGON_DB_CHANGE_set_sid_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sid_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sid_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sid_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_sid(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	py_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->sid);
	return py_sid;
}

static int py_NETLOGON_DB_CHANGE_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sid");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_message_format_version(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(obj);
	PyObject *py_message_format_version;
	py_message_format_version = PyLong_FromUnsignedLongLong((uint32_t)(object->message_format_version));
	return py_message_format_version;
}

static int py_NETLOGON_DB_CHANGE_set_message_format_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->message_format_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->message_format_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->message_format_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NETLOGON_DB_CHANGE_get_message_token(PyObject *obj, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(obj);
	PyObject *py_message_token;
	py_message_token = PyLong_FromUnsignedLongLong((uint32_t)(object->message_token));
	return py_message_token;
}

static int py_NETLOGON_DB_CHANGE_set_message_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NETLOGON_DB_CHANGE *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->message_token");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->message_token));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->message_token = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_NETLOGON_DB_CHANGE_getsetters[] = {
	{
		.name = discard_const_p(char, "serial_lo"),
		.get = py_NETLOGON_DB_CHANGE_get_serial_lo,
		.set = py_NETLOGON_DB_CHANGE_set_serial_lo,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "timestamp"),
		.get = py_NETLOGON_DB_CHANGE_get_timestamp,
		.set = py_NETLOGON_DB_CHANGE_set_timestamp,
		.doc = discard_const_p(char, "PIDL-generated element of base type time_t")
	},
	{
		.name = discard_const_p(char, "pulse"),
		.get = py_NETLOGON_DB_CHANGE_get_pulse,
		.set = py_NETLOGON_DB_CHANGE_set_pulse,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "random"),
		.get = py_NETLOGON_DB_CHANGE_get_random,
		.set = py_NETLOGON_DB_CHANGE_set_random,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pdc_name"),
		.get = py_NETLOGON_DB_CHANGE_get_pdc_name,
		.set = py_NETLOGON_DB_CHANGE_set_pdc_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "domain"),
		.get = py_NETLOGON_DB_CHANGE_get_domain,
		.set = py_NETLOGON_DB_CHANGE_set_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "_pad"),
		.get = py_NETLOGON_DB_CHANGE_get__pad,
		.set = py_NETLOGON_DB_CHANGE_set__pad,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "unicode_pdc_name"),
		.get = py_NETLOGON_DB_CHANGE_get_unicode_pdc_name,
		.set = py_NETLOGON_DB_CHANGE_set_unicode_pdc_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "unicode_domain"),
		.get = py_NETLOGON_DB_CHANGE_get_unicode_domain,
		.set = py_NETLOGON_DB_CHANGE_set_unicode_domain,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "db_count"),
		.get = py_NETLOGON_DB_CHANGE_get_db_count,
		.set = py_NETLOGON_DB_CHANGE_set_db_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dbchange"),
		.get = py_NETLOGON_DB_CHANGE_get_dbchange,
		.set = py_NETLOGON_DB_CHANGE_set_dbchange,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_db_change_info")
	},
	{
		.name = discard_const_p(char, "sid_size"),
		.get = py_NETLOGON_DB_CHANGE_get_sid_size,
		.set = py_NETLOGON_DB_CHANGE_set_sid_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sid"),
		.get = py_NETLOGON_DB_CHANGE_get_sid,
		.set = py_NETLOGON_DB_CHANGE_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid0")
	},
	{
		.name = discard_const_p(char, "message_format_version"),
		.get = py_NETLOGON_DB_CHANGE_get_message_format_version,
		.set = py_NETLOGON_DB_CHANGE_set_message_format_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "message_token"),
		.get = py_NETLOGON_DB_CHANGE_get_message_token,
		.set = py_NETLOGON_DB_CHANGE_set_message_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_NETLOGON_DB_CHANGE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NETLOGON_DB_CHANGE, type);
}


static PyTypeObject NETLOGON_DB_CHANGE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.NETLOGON_DB_CHANGE",
	.tp_getset = py_NETLOGON_DB_CHANGE_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_NETLOGON_DB_CHANGE_new,
};

static PyObject *py_import_nbt_netlogon_request(TALLOC_CTX *mem_ctx, int level, union nbt_netlogon_request *in)
{
	PyObject *ret;

	switch (level) {
		case LOGON_REQUEST:
			ret = pytalloc_reference_ex(&NETLOGON_LOGON_REQUEST_Type, mem_ctx, &in->logon0);
			return ret;

		case LOGON_SAM_LOGON_REQUEST:
			ret = pytalloc_reference_ex(&NETLOGON_SAM_LOGON_REQUEST_Type, mem_ctx, &in->logon);
			return ret;

		case LOGON_PRIMARY_QUERY:
			ret = pytalloc_reference_ex(&nbt_netlogon_query_for_pdc_Type, mem_ctx, &in->pdc);
			return ret;

		case NETLOGON_ANNOUNCE_UAS:
			ret = pytalloc_reference_ex(&NETLOGON_DB_CHANGE_Type, mem_ctx, &in->uas);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union nbt_netlogon_request *py_export_nbt_netlogon_request(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union nbt_netlogon_request *ret = talloc_zero(mem_ctx, union nbt_netlogon_request);
	switch (level) {
		case LOGON_REQUEST:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->logon0");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&NETLOGON_LOGON_REQUEST_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->logon0 = *(struct NETLOGON_LOGON_REQUEST *)pytalloc_get_ptr(in);
			break;

		case LOGON_SAM_LOGON_REQUEST:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->logon");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&NETLOGON_SAM_LOGON_REQUEST_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->logon = *(struct NETLOGON_SAM_LOGON_REQUEST *)pytalloc_get_ptr(in);
			break;

		case LOGON_PRIMARY_QUERY:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->pdc");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&nbt_netlogon_query_for_pdc_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->pdc = *(struct nbt_netlogon_query_for_pdc *)pytalloc_get_ptr(in);
			break;

		case NETLOGON_ANNOUNCE_UAS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->uas");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&NETLOGON_DB_CHANGE_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->uas = *(struct NETLOGON_DB_CHANGE *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_nbt_netlogon_request_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union nbt_netlogon_request *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union nbt_netlogon_request *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union nbt_netlogon_request!");
		return NULL;
	}

	return py_import_nbt_netlogon_request(mem_ctx, level, in);
}

static PyObject *py_nbt_netlogon_request_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union nbt_netlogon_request *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_nbt_netlogon_request(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_nbt_netlogon_request_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_netlogon_request_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_netlogon_request_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_nbt_netlogon_request_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject nbt_netlogon_request_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.netlogon_request",
	.tp_getset = NULL,
	.tp_methods = py_nbt_netlogon_request_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_netlogon_request_new,
};


static PyObject *py_nbt_netlogon_packet_get_command(PyObject *obj, void *closure)
{
	struct nbt_netlogon_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_command;
	py_command = PyLong_FromLong((uint16_t)(object->command));
	return py_command;
}

static int py_nbt_netlogon_packet_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->command");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->command));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->command = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_netlogon_packet_get_req(PyObject *obj, void *closure)
{
	struct nbt_netlogon_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_req;
	py_req = pyrpc_import_union(&nbt_netlogon_request_Type, pytalloc_get_mem_ctx(obj), object->command, &object->req, "union nbt_netlogon_request");
	if (py_req == NULL) {
		return NULL;
	}
	return py_req;
}

static int py_nbt_netlogon_packet_set_req(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_netlogon_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->req");
		return -1;
	}
	{
		union nbt_netlogon_request *req_switch_0;
		req_switch_0 = (union nbt_netlogon_request *)pyrpc_export_union(&nbt_netlogon_request_Type, pytalloc_get_mem_ctx(py_obj), object->command, value, "union nbt_netlogon_request");
		if (req_switch_0 == NULL) {
			return -1;
		}
		object->req = *req_switch_0;
	}
	return 0;
}

static PyGetSetDef py_nbt_netlogon_packet_getsetters[] = {
	{
		.name = discard_const_p(char, "command"),
		.get = py_nbt_netlogon_packet_get_command,
		.set = py_nbt_netlogon_packet_set_command,
		.doc = discard_const_p(char, "PIDL-generated element of base type netlogon_command")
	},
	{
		.name = discard_const_p(char, "req"),
		.get = py_nbt_netlogon_packet_get_req,
		.set = py_nbt_netlogon_packet_set_req,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_netlogon_request")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_netlogon_packet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_netlogon_packet, type);
}

static PyObject *py_nbt_netlogon_packet_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct nbt_netlogon_packet *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_nbt_netlogon_packet);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_nbt_netlogon_packet_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_netlogon_packet *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_netlogon_packet);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_netlogon_packet);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_nbt_netlogon_packet_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_netlogon_packet *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_netlogon_packet, "nbt_netlogon_packet", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_netlogon_packet, "nbt_netlogon_packet", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_nbt_netlogon_packet_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_nbt_netlogon_packet_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_netlogon_packet_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_netlogon_packet_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbt_netlogon_packet_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.netlogon_packet",
	.tp_getset = py_nbt_netlogon_packet_getsetters,
	.tp_methods = py_nbt_netlogon_packet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_netlogon_packet_new,
};


static PyObject *py_nbt_browse_host_announcement_get_UpdateCount(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_UpdateCount;
	py_UpdateCount = PyLong_FromLong((uint16_t)(object->UpdateCount));
	return py_UpdateCount;
}

static int py_nbt_browse_host_announcement_set_UpdateCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->UpdateCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->UpdateCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->UpdateCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_host_announcement_get_Periodicity(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_Periodicity;
	py_Periodicity = PyLong_FromUnsignedLongLong((uint32_t)(object->Periodicity));
	return py_Periodicity;
}

static int py_nbt_browse_host_announcement_set_Periodicity(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Periodicity");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Periodicity));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Periodicity = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_host_announcement_get_ServerName(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_ServerName;
	if (object->ServerName == NULL) {
		py_ServerName = Py_None;
		Py_INCREF(py_ServerName);
	} else {
		py_ServerName = PyUnicode_Decode(object->ServerName, strlen(object->ServerName), "utf-8", "ignore");
	}
	return py_ServerName;
}

static int py_nbt_browse_host_announcement_set_ServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ServerName");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ServerName = talloc_str;
	}
	return 0;
}

static PyObject *py_nbt_browse_host_announcement_get_OSMajor(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_OSMajor;
	py_OSMajor = PyLong_FromLong((uint16_t)(object->OSMajor));
	return py_OSMajor;
}

static int py_nbt_browse_host_announcement_set_OSMajor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->OSMajor");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->OSMajor));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->OSMajor = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_host_announcement_get_OSMinor(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_OSMinor;
	py_OSMinor = PyLong_FromLong((uint16_t)(object->OSMinor));
	return py_OSMinor;
}

static int py_nbt_browse_host_announcement_set_OSMinor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->OSMinor");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->OSMinor));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->OSMinor = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_host_announcement_get_ServerType(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_ServerType;
	py_ServerType = PyLong_FromUnsignedLongLong((uint32_t)(object->ServerType));
	return py_ServerType;
}

static int py_nbt_browse_host_announcement_set_ServerType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ServerType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ServerType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ServerType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_host_announcement_get_BroMajorVer(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_BroMajorVer;
	py_BroMajorVer = PyLong_FromLong((uint16_t)(object->BroMajorVer));
	return py_BroMajorVer;
}

static int py_nbt_browse_host_announcement_set_BroMajorVer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->BroMajorVer");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->BroMajorVer));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->BroMajorVer = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_host_announcement_get_BroMinorVer(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_BroMinorVer;
	py_BroMinorVer = PyLong_FromLong((uint16_t)(object->BroMinorVer));
	return py_BroMinorVer;
}

static int py_nbt_browse_host_announcement_set_BroMinorVer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->BroMinorVer");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->BroMinorVer));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->BroMinorVer = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_host_announcement_get_Signature(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_Signature;
	py_Signature = PyLong_FromLong((uint16_t)(object->Signature));
	return py_Signature;
}

static int py_nbt_browse_host_announcement_set_Signature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Signature");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Signature));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Signature = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_host_announcement_get_Comment(PyObject *obj, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_Comment;
	py_Comment = PyString_FromStringOrNULL(object->Comment);
	return py_Comment;
}

static int py_nbt_browse_host_announcement_set_Comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_host_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Comment");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->Comment = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_nbt_browse_host_announcement_getsetters[] = {
	{
		.name = discard_const_p(char, "UpdateCount"),
		.get = py_nbt_browse_host_announcement_get_UpdateCount,
		.set = py_nbt_browse_host_announcement_set_UpdateCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "Periodicity"),
		.get = py_nbt_browse_host_announcement_get_Periodicity,
		.set = py_nbt_browse_host_announcement_set_Periodicity,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ServerName"),
		.get = py_nbt_browse_host_announcement_get_ServerName,
		.set = py_nbt_browse_host_announcement_set_ServerName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "OSMajor"),
		.get = py_nbt_browse_host_announcement_get_OSMajor,
		.set = py_nbt_browse_host_announcement_set_OSMajor,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "OSMinor"),
		.get = py_nbt_browse_host_announcement_get_OSMinor,
		.set = py_nbt_browse_host_announcement_set_OSMinor,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "ServerType"),
		.get = py_nbt_browse_host_announcement_get_ServerType,
		.set = py_nbt_browse_host_announcement_set_ServerType,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_ServerType")
	},
	{
		.name = discard_const_p(char, "BroMajorVer"),
		.get = py_nbt_browse_host_announcement_get_BroMajorVer,
		.set = py_nbt_browse_host_announcement_set_BroMajorVer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "BroMinorVer"),
		.get = py_nbt_browse_host_announcement_get_BroMinorVer,
		.set = py_nbt_browse_host_announcement_set_BroMinorVer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "Signature"),
		.get = py_nbt_browse_host_announcement_get_Signature,
		.set = py_nbt_browse_host_announcement_set_Signature,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "Comment"),
		.get = py_nbt_browse_host_announcement_get_Comment,
		.set = py_nbt_browse_host_announcement_set_Comment,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_browse_host_announcement_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_host_announcement, type);
}


static PyTypeObject nbt_browse_host_announcement_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.browse_host_announcement",
	.tp_getset = py_nbt_browse_host_announcement_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_browse_host_announcement_new,
};


static PyObject *py_nbt_browse_announcement_request_get_Unused(PyObject *obj, void *closure)
{
	struct nbt_browse_announcement_request *object = pytalloc_get_ptr(obj);
	PyObject *py_Unused;
	py_Unused = PyLong_FromLong((uint16_t)(object->Unused));
	return py_Unused;
}

static int py_nbt_browse_announcement_request_set_Unused(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_announcement_request *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Unused");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Unused));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Unused = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_announcement_request_get_ResponseName(PyObject *obj, void *closure)
{
	struct nbt_browse_announcement_request *object = pytalloc_get_ptr(obj);
	PyObject *py_ResponseName;
	py_ResponseName = PyString_FromStringOrNULL(object->ResponseName);
	return py_ResponseName;
}

static int py_nbt_browse_announcement_request_set_ResponseName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_announcement_request *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ResponseName");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ResponseName = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_nbt_browse_announcement_request_getsetters[] = {
	{
		.name = discard_const_p(char, "Unused"),
		.get = py_nbt_browse_announcement_request_get_Unused,
		.set = py_nbt_browse_announcement_request_set_Unused,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "ResponseName"),
		.get = py_nbt_browse_announcement_request_get_ResponseName,
		.set = py_nbt_browse_announcement_request_set_ResponseName,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_browse_announcement_request_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_announcement_request, type);
}


static PyTypeObject nbt_browse_announcement_request_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.browse_announcement_request",
	.tp_getset = py_nbt_browse_announcement_request_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_browse_announcement_request_new,
};


static PyObject *py_nbt_browse_election_request_get_Version(PyObject *obj, void *closure)
{
	struct nbt_browse_election_request *object = pytalloc_get_ptr(obj);
	PyObject *py_Version;
	py_Version = PyLong_FromLong((uint16_t)(object->Version));
	return py_Version;
}

static int py_nbt_browse_election_request_set_Version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_election_request *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_election_request_get_Criteria(PyObject *obj, void *closure)
{
	struct nbt_browse_election_request *object = pytalloc_get_ptr(obj);
	PyObject *py_Criteria;
	py_Criteria = PyLong_FromUnsignedLongLong((uint32_t)(object->Criteria));
	return py_Criteria;
}

static int py_nbt_browse_election_request_set_Criteria(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_election_request *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Criteria");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Criteria));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Criteria = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_election_request_get_UpTime(PyObject *obj, void *closure)
{
	struct nbt_browse_election_request *object = pytalloc_get_ptr(obj);
	PyObject *py_UpTime;
	py_UpTime = PyLong_FromUnsignedLongLong((uint32_t)(object->UpTime));
	return py_UpTime;
}

static int py_nbt_browse_election_request_set_UpTime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_election_request *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->UpTime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->UpTime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->UpTime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_election_request_get_Reserved(PyObject *obj, void *closure)
{
	struct nbt_browse_election_request *object = pytalloc_get_ptr(obj);
	PyObject *py_Reserved;
	py_Reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->Reserved));
	return py_Reserved;
}

static int py_nbt_browse_election_request_set_Reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_election_request *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_election_request_get_ServerName(PyObject *obj, void *closure)
{
	struct nbt_browse_election_request *object = pytalloc_get_ptr(obj);
	PyObject *py_ServerName;
	py_ServerName = PyString_FromStringOrNULL(object->ServerName);
	return py_ServerName;
}

static int py_nbt_browse_election_request_set_ServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_election_request *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ServerName");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ServerName = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_nbt_browse_election_request_getsetters[] = {
	{
		.name = discard_const_p(char, "Version"),
		.get = py_nbt_browse_election_request_get_Version,
		.set = py_nbt_browse_election_request_set_Version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "Criteria"),
		.get = py_nbt_browse_election_request_get_Criteria,
		.set = py_nbt_browse_election_request_set_Criteria,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "UpTime"),
		.get = py_nbt_browse_election_request_get_UpTime,
		.set = py_nbt_browse_election_request_set_UpTime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "Reserved"),
		.get = py_nbt_browse_election_request_get_Reserved,
		.set = py_nbt_browse_election_request_set_Reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ServerName"),
		.get = py_nbt_browse_election_request_get_ServerName,
		.set = py_nbt_browse_election_request_set_ServerName,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_browse_election_request_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_election_request, type);
}


static PyTypeObject nbt_browse_election_request_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.browse_election_request",
	.tp_getset = py_nbt_browse_election_request_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_browse_election_request_new,
};


static PyObject *py_nbt_browse_backup_list_request_get_ReqCount(PyObject *obj, void *closure)
{
	struct nbt_browse_backup_list_request *object = pytalloc_get_ptr(obj);
	PyObject *py_ReqCount;
	py_ReqCount = PyLong_FromLong((uint16_t)(object->ReqCount));
	return py_ReqCount;
}

static int py_nbt_browse_backup_list_request_set_ReqCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_backup_list_request *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ReqCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ReqCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ReqCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_backup_list_request_get_Token(PyObject *obj, void *closure)
{
	struct nbt_browse_backup_list_request *object = pytalloc_get_ptr(obj);
	PyObject *py_Token;
	py_Token = PyLong_FromUnsignedLongLong((uint32_t)(object->Token));
	return py_Token;
}

static int py_nbt_browse_backup_list_request_set_Token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_backup_list_request *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Token");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Token));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Token = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_nbt_browse_backup_list_request_getsetters[] = {
	{
		.name = discard_const_p(char, "ReqCount"),
		.get = py_nbt_browse_backup_list_request_get_ReqCount,
		.set = py_nbt_browse_backup_list_request_set_ReqCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "Token"),
		.get = py_nbt_browse_backup_list_request_get_Token,
		.set = py_nbt_browse_backup_list_request_set_Token,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_browse_backup_list_request_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_backup_list_request, type);
}


static PyTypeObject nbt_browse_backup_list_request_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.browse_backup_list_request",
	.tp_getset = py_nbt_browse_backup_list_request_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_browse_backup_list_request_new,
};


static PyObject *py_nbt_browse_backup_list_response_get_BackupCount(PyObject *obj, void *closure)
{
	struct nbt_browse_backup_list_response *object = pytalloc_get_ptr(obj);
	PyObject *py_BackupCount;
	py_BackupCount = PyLong_FromLong((uint16_t)(object->BackupCount));
	return py_BackupCount;
}

static int py_nbt_browse_backup_list_response_set_BackupCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_backup_list_response *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->BackupCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->BackupCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->BackupCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_backup_list_response_get_Token(PyObject *obj, void *closure)
{
	struct nbt_browse_backup_list_response *object = pytalloc_get_ptr(obj);
	PyObject *py_Token;
	py_Token = PyLong_FromUnsignedLongLong((uint32_t)(object->Token));
	return py_Token;
}

static int py_nbt_browse_backup_list_response_set_Token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_backup_list_response *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Token");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Token));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Token = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_backup_list_response_get_BackupServerList(PyObject *obj, void *closure)
{
	struct nbt_browse_backup_list_response *object = pytalloc_get_ptr(obj);
	PyObject *py_BackupServerList;
	py_BackupServerList = PyList_New(object->BackupCount);
	if (py_BackupServerList == NULL) {
		return NULL;
	}
	{
		int BackupServerList_cntr_0;
		for (BackupServerList_cntr_0 = 0; BackupServerList_cntr_0 < (object->BackupCount); BackupServerList_cntr_0++) {
			PyObject *py_BackupServerList_0;
			py_BackupServerList_0 = pytalloc_reference_ex(&nbt_name_Type, object->BackupServerList, &(object->BackupServerList)[BackupServerList_cntr_0]);
			PyList_SetItem(py_BackupServerList, BackupServerList_cntr_0, py_BackupServerList_0);
		}
	}
	return py_BackupServerList;
}

static int py_nbt_browse_backup_list_response_set_BackupServerList(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_backup_list_response *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->BackupServerList");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int BackupServerList_cntr_0;
		object->BackupServerList = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->BackupServerList, PyList_GET_SIZE(value));
		if (!object->BackupServerList) { return -1; }
		talloc_set_name_const(object->BackupServerList, "ARRAY: object->BackupServerList");
		for (BackupServerList_cntr_0 = 0; BackupServerList_cntr_0 < PyList_GET_SIZE(value); BackupServerList_cntr_0++) {
			if (PyList_GET_ITEM(value, BackupServerList_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->BackupServerList)[BackupServerList_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&nbt_name_Type, PyList_GET_ITEM(value, BackupServerList_cntr_0), return -1;);
			if (talloc_reference(object->BackupServerList, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, BackupServerList_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->BackupServerList)[BackupServerList_cntr_0] = *(struct nbt_name *)pytalloc_get_ptr(PyList_GET_ITEM(value, BackupServerList_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_nbt_browse_backup_list_response_getsetters[] = {
	{
		.name = discard_const_p(char, "BackupCount"),
		.get = py_nbt_browse_backup_list_response_get_BackupCount,
		.set = py_nbt_browse_backup_list_response_set_BackupCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "Token"),
		.get = py_nbt_browse_backup_list_response_get_Token,
		.set = py_nbt_browse_backup_list_response_set_Token,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "BackupServerList"),
		.get = py_nbt_browse_backup_list_response_get_BackupServerList,
		.set = py_nbt_browse_backup_list_response_set_BackupServerList,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_name")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_browse_backup_list_response_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_backup_list_response, type);
}


static PyTypeObject nbt_browse_backup_list_response_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.browse_backup_list_response",
	.tp_getset = py_nbt_browse_backup_list_response_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_browse_backup_list_response_new,
};


static PyObject *py_nbt_browse_become_backup_get_BrowserName(PyObject *obj, void *closure)
{
	struct nbt_browse_become_backup *object = pytalloc_get_ptr(obj);
	PyObject *py_BrowserName;
	py_BrowserName = PyString_FromStringOrNULL(object->BrowserName);
	return py_BrowserName;
}

static int py_nbt_browse_become_backup_set_BrowserName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_become_backup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->BrowserName");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->BrowserName = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_nbt_browse_become_backup_getsetters[] = {
	{
		.name = discard_const_p(char, "BrowserName"),
		.get = py_nbt_browse_become_backup_get_BrowserName,
		.set = py_nbt_browse_become_backup_set_BrowserName,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_browse_become_backup_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_become_backup, type);
}


static PyTypeObject nbt_browse_become_backup_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.browse_become_backup",
	.tp_getset = py_nbt_browse_become_backup_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_browse_become_backup_new,
};


static PyObject *py_nbt_browse_domain_announcement_get_UpdateCount(PyObject *obj, void *closure)
{
	struct nbt_browse_domain_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_UpdateCount;
	py_UpdateCount = PyLong_FromLong((uint16_t)(object->UpdateCount));
	return py_UpdateCount;
}

static int py_nbt_browse_domain_announcement_set_UpdateCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_domain_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->UpdateCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->UpdateCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->UpdateCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_domain_announcement_get_Periodicity(PyObject *obj, void *closure)
{
	struct nbt_browse_domain_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_Periodicity;
	py_Periodicity = PyLong_FromUnsignedLongLong((uint32_t)(object->Periodicity));
	return py_Periodicity;
}

static int py_nbt_browse_domain_announcement_set_Periodicity(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_domain_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Periodicity");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Periodicity));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Periodicity = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_domain_announcement_get_ServerName(PyObject *obj, void *closure)
{
	struct nbt_browse_domain_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_ServerName;
	if (object->ServerName == NULL) {
		py_ServerName = Py_None;
		Py_INCREF(py_ServerName);
	} else {
		py_ServerName = PyUnicode_Decode(object->ServerName, strlen(object->ServerName), "utf-8", "ignore");
	}
	return py_ServerName;
}

static int py_nbt_browse_domain_announcement_set_ServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_domain_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ServerName");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ServerName = talloc_str;
	}
	return 0;
}

static PyObject *py_nbt_browse_domain_announcement_get_OSMajor(PyObject *obj, void *closure)
{
	struct nbt_browse_domain_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_OSMajor;
	py_OSMajor = PyLong_FromLong((uint16_t)(object->OSMajor));
	return py_OSMajor;
}

static int py_nbt_browse_domain_announcement_set_OSMajor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_domain_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->OSMajor");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->OSMajor));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->OSMajor = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_domain_announcement_get_OSMinor(PyObject *obj, void *closure)
{
	struct nbt_browse_domain_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_OSMinor;
	py_OSMinor = PyLong_FromLong((uint16_t)(object->OSMinor));
	return py_OSMinor;
}

static int py_nbt_browse_domain_announcement_set_OSMinor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_domain_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->OSMinor");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->OSMinor));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->OSMinor = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_domain_announcement_get_ServerType(PyObject *obj, void *closure)
{
	struct nbt_browse_domain_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_ServerType;
	py_ServerType = PyLong_FromUnsignedLongLong((uint32_t)(object->ServerType));
	return py_ServerType;
}

static int py_nbt_browse_domain_announcement_set_ServerType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_domain_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ServerType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ServerType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ServerType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_domain_announcement_get_MysteriousField(PyObject *obj, void *closure)
{
	struct nbt_browse_domain_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_MysteriousField;
	py_MysteriousField = PyLong_FromUnsignedLongLong((uint32_t)(object->MysteriousField));
	return py_MysteriousField;
}

static int py_nbt_browse_domain_announcement_set_MysteriousField(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_domain_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->MysteriousField");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->MysteriousField));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->MysteriousField = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_domain_announcement_get_Comment(PyObject *obj, void *closure)
{
	struct nbt_browse_domain_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_Comment;
	py_Comment = PyString_FromStringOrNULL(object->Comment);
	return py_Comment;
}

static int py_nbt_browse_domain_announcement_set_Comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_domain_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Comment");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->Comment = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_nbt_browse_domain_announcement_getsetters[] = {
	{
		.name = discard_const_p(char, "UpdateCount"),
		.get = py_nbt_browse_domain_announcement_get_UpdateCount,
		.set = py_nbt_browse_domain_announcement_set_UpdateCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "Periodicity"),
		.get = py_nbt_browse_domain_announcement_get_Periodicity,
		.set = py_nbt_browse_domain_announcement_set_Periodicity,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ServerName"),
		.get = py_nbt_browse_domain_announcement_get_ServerName,
		.set = py_nbt_browse_domain_announcement_set_ServerName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "OSMajor"),
		.get = py_nbt_browse_domain_announcement_get_OSMajor,
		.set = py_nbt_browse_domain_announcement_set_OSMajor,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "OSMinor"),
		.get = py_nbt_browse_domain_announcement_get_OSMinor,
		.set = py_nbt_browse_domain_announcement_set_OSMinor,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "ServerType"),
		.get = py_nbt_browse_domain_announcement_get_ServerType,
		.set = py_nbt_browse_domain_announcement_set_ServerType,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_ServerType")
	},
	{
		.name = discard_const_p(char, "MysteriousField"),
		.get = py_nbt_browse_domain_announcement_get_MysteriousField,
		.set = py_nbt_browse_domain_announcement_set_MysteriousField,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "Comment"),
		.get = py_nbt_browse_domain_announcement_get_Comment,
		.set = py_nbt_browse_domain_announcement_set_Comment,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_browse_domain_announcement_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_domain_announcement, type);
}


static PyTypeObject nbt_browse_domain_announcement_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.browse_domain_announcement",
	.tp_getset = py_nbt_browse_domain_announcement_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_browse_domain_announcement_new,
};


static PyObject *py_nbt_browse_master_announcement_get_ServerName(PyObject *obj, void *closure)
{
	struct nbt_browse_master_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_ServerName;
	py_ServerName = PyString_FromStringOrNULL(object->ServerName);
	return py_ServerName;
}

static int py_nbt_browse_master_announcement_set_ServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_master_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ServerName");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ServerName = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_nbt_browse_master_announcement_getsetters[] = {
	{
		.name = discard_const_p(char, "ServerName"),
		.get = py_nbt_browse_master_announcement_get_ServerName,
		.set = py_nbt_browse_master_announcement_set_ServerName,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_browse_master_announcement_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_master_announcement, type);
}


static PyTypeObject nbt_browse_master_announcement_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.browse_master_announcement",
	.tp_getset = py_nbt_browse_master_announcement_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_browse_master_announcement_new,
};


static PyObject *py_nbt_browse_reset_state_get_Command(PyObject *obj, void *closure)
{
	struct nbt_browse_reset_state *object = pytalloc_get_ptr(obj);
	PyObject *py_Command;
	py_Command = PyLong_FromLong((uint16_t)(object->Command));
	return py_Command;
}

static int py_nbt_browse_reset_state_set_Command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_reset_state *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Command");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Command));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Command = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_nbt_browse_reset_state_getsetters[] = {
	{
		.name = discard_const_p(char, "Command"),
		.get = py_nbt_browse_reset_state_get_Command,
		.set = py_nbt_browse_reset_state_set_Command,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_browse_reset_state_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_reset_state, type);
}


static PyTypeObject nbt_browse_reset_state_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.browse_reset_state",
	.tp_getset = py_nbt_browse_reset_state_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_browse_reset_state_new,
};


static PyObject *py_nbt_browse_local_master_announcement_get_UpdateCount(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_UpdateCount;
	py_UpdateCount = PyLong_FromLong((uint16_t)(object->UpdateCount));
	return py_UpdateCount;
}

static int py_nbt_browse_local_master_announcement_set_UpdateCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->UpdateCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->UpdateCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->UpdateCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_local_master_announcement_get_Periodicity(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_Periodicity;
	py_Periodicity = PyLong_FromUnsignedLongLong((uint32_t)(object->Periodicity));
	return py_Periodicity;
}

static int py_nbt_browse_local_master_announcement_set_Periodicity(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Periodicity");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Periodicity));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Periodicity = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_local_master_announcement_get_ServerName(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_ServerName;
	if (object->ServerName == NULL) {
		py_ServerName = Py_None;
		Py_INCREF(py_ServerName);
	} else {
		py_ServerName = PyUnicode_Decode(object->ServerName, strlen(object->ServerName), "utf-8", "ignore");
	}
	return py_ServerName;
}

static int py_nbt_browse_local_master_announcement_set_ServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ServerName");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->ServerName = talloc_str;
	}
	return 0;
}

static PyObject *py_nbt_browse_local_master_announcement_get_OSMajor(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_OSMajor;
	py_OSMajor = PyLong_FromLong((uint16_t)(object->OSMajor));
	return py_OSMajor;
}

static int py_nbt_browse_local_master_announcement_set_OSMajor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->OSMajor");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->OSMajor));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->OSMajor = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_local_master_announcement_get_OSMinor(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_OSMinor;
	py_OSMinor = PyLong_FromLong((uint16_t)(object->OSMinor));
	return py_OSMinor;
}

static int py_nbt_browse_local_master_announcement_set_OSMinor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->OSMinor");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->OSMinor));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->OSMinor = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_local_master_announcement_get_ServerType(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_ServerType;
	py_ServerType = PyLong_FromUnsignedLongLong((uint32_t)(object->ServerType));
	return py_ServerType;
}

static int py_nbt_browse_local_master_announcement_set_ServerType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ServerType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ServerType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ServerType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_local_master_announcement_get_BroMajorVer(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_BroMajorVer;
	py_BroMajorVer = PyLong_FromLong((uint16_t)(object->BroMajorVer));
	return py_BroMajorVer;
}

static int py_nbt_browse_local_master_announcement_set_BroMajorVer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->BroMajorVer");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->BroMajorVer));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->BroMajorVer = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_local_master_announcement_get_BroMinorVer(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_BroMinorVer;
	py_BroMinorVer = PyLong_FromLong((uint16_t)(object->BroMinorVer));
	return py_BroMinorVer;
}

static int py_nbt_browse_local_master_announcement_set_BroMinorVer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->BroMinorVer");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->BroMinorVer));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->BroMinorVer = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_local_master_announcement_get_Signature(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_Signature;
	py_Signature = PyLong_FromLong((uint16_t)(object->Signature));
	return py_Signature;
}

static int py_nbt_browse_local_master_announcement_set_Signature(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Signature");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Signature));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Signature = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_local_master_announcement_get_Comment(PyObject *obj, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(obj);
	PyObject *py_Comment;
	py_Comment = PyString_FromStringOrNULL(object->Comment);
	return py_Comment;
}

static int py_nbt_browse_local_master_announcement_set_Comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_local_master_announcement *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Comment");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->Comment = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_nbt_browse_local_master_announcement_getsetters[] = {
	{
		.name = discard_const_p(char, "UpdateCount"),
		.get = py_nbt_browse_local_master_announcement_get_UpdateCount,
		.set = py_nbt_browse_local_master_announcement_set_UpdateCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "Periodicity"),
		.get = py_nbt_browse_local_master_announcement_get_Periodicity,
		.set = py_nbt_browse_local_master_announcement_set_Periodicity,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ServerName"),
		.get = py_nbt_browse_local_master_announcement_get_ServerName,
		.set = py_nbt_browse_local_master_announcement_set_ServerName,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "OSMajor"),
		.get = py_nbt_browse_local_master_announcement_get_OSMajor,
		.set = py_nbt_browse_local_master_announcement_set_OSMajor,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "OSMinor"),
		.get = py_nbt_browse_local_master_announcement_get_OSMinor,
		.set = py_nbt_browse_local_master_announcement_set_OSMinor,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "ServerType"),
		.get = py_nbt_browse_local_master_announcement_get_ServerType,
		.set = py_nbt_browse_local_master_announcement_set_ServerType,
		.doc = discard_const_p(char, "PIDL-generated element of base type svcctl_ServerType")
	},
	{
		.name = discard_const_p(char, "BroMajorVer"),
		.get = py_nbt_browse_local_master_announcement_get_BroMajorVer,
		.set = py_nbt_browse_local_master_announcement_set_BroMajorVer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "BroMinorVer"),
		.get = py_nbt_browse_local_master_announcement_get_BroMinorVer,
		.set = py_nbt_browse_local_master_announcement_set_BroMinorVer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "Signature"),
		.get = py_nbt_browse_local_master_announcement_get_Signature,
		.set = py_nbt_browse_local_master_announcement_set_Signature,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "Comment"),
		.get = py_nbt_browse_local_master_announcement_get_Comment,
		.set = py_nbt_browse_local_master_announcement_set_Comment,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_browse_local_master_announcement_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_local_master_announcement, type);
}


static PyTypeObject nbt_browse_local_master_announcement_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.browse_local_master_announcement",
	.tp_getset = py_nbt_browse_local_master_announcement_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_browse_local_master_announcement_new,
};

static PyObject *py_import_nbt_browse_payload(TALLOC_CTX *mem_ctx, int level, union nbt_browse_payload *in)
{
	PyObject *ret;

	switch (level) {
		case HostAnnouncement:
			ret = pytalloc_reference_ex(&nbt_browse_host_announcement_Type, mem_ctx, &in->host_annoucement);
			return ret;

		case AnnouncementRequest:
			ret = pytalloc_reference_ex(&nbt_browse_announcement_request_Type, mem_ctx, &in->announcement_request);
			return ret;

		case Election:
			ret = pytalloc_reference_ex(&nbt_browse_election_request_Type, mem_ctx, &in->election_request);
			return ret;

		case GetBackupListReq:
			ret = pytalloc_reference_ex(&nbt_browse_backup_list_request_Type, mem_ctx, &in->backup_list_request);
			return ret;

		case GetBackupListResp:
			ret = pytalloc_reference_ex(&nbt_browse_backup_list_response_Type, mem_ctx, &in->backup_list_response);
			return ret;

		case BecomeBackup:
			ret = pytalloc_reference_ex(&nbt_browse_become_backup_Type, mem_ctx, &in->become_backup);
			return ret;

		case DomainAnnouncement:
			ret = pytalloc_reference_ex(&nbt_browse_domain_announcement_Type, mem_ctx, &in->domain_announcement);
			return ret;

		case MasterAnnouncement:
			ret = pytalloc_reference_ex(&nbt_browse_master_announcement_Type, mem_ctx, &in->master_announcement);
			return ret;

		case ResetBrowserState:
			ret = pytalloc_reference_ex(&nbt_browse_reset_state_Type, mem_ctx, &in->reset_browser_state);
			return ret;

		case LocalMasterAnnouncement:
			ret = pytalloc_reference_ex(&nbt_browse_local_master_announcement_Type, mem_ctx, &in->local_master_announcement);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union nbt_browse_payload *py_export_nbt_browse_payload(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union nbt_browse_payload *ret = talloc_zero(mem_ctx, union nbt_browse_payload);
	switch (level) {
		case HostAnnouncement:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->host_annoucement");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&nbt_browse_host_announcement_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->host_annoucement = *(struct nbt_browse_host_announcement *)pytalloc_get_ptr(in);
			break;

		case AnnouncementRequest:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->announcement_request");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&nbt_browse_announcement_request_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->announcement_request = *(struct nbt_browse_announcement_request *)pytalloc_get_ptr(in);
			break;

		case Election:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->election_request");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&nbt_browse_election_request_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->election_request = *(struct nbt_browse_election_request *)pytalloc_get_ptr(in);
			break;

		case GetBackupListReq:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->backup_list_request");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&nbt_browse_backup_list_request_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->backup_list_request = *(struct nbt_browse_backup_list_request *)pytalloc_get_ptr(in);
			break;

		case GetBackupListResp:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->backup_list_response");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&nbt_browse_backup_list_response_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->backup_list_response = *(struct nbt_browse_backup_list_response *)pytalloc_get_ptr(in);
			break;

		case BecomeBackup:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->become_backup");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&nbt_browse_become_backup_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->become_backup = *(struct nbt_browse_become_backup *)pytalloc_get_ptr(in);
			break;

		case DomainAnnouncement:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->domain_announcement");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&nbt_browse_domain_announcement_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->domain_announcement = *(struct nbt_browse_domain_announcement *)pytalloc_get_ptr(in);
			break;

		case MasterAnnouncement:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->master_announcement");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&nbt_browse_master_announcement_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->master_announcement = *(struct nbt_browse_master_announcement *)pytalloc_get_ptr(in);
			break;

		case ResetBrowserState:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->reset_browser_state");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&nbt_browse_reset_state_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->reset_browser_state = *(struct nbt_browse_reset_state *)pytalloc_get_ptr(in);
			break;

		case LocalMasterAnnouncement:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->local_master_announcement");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&nbt_browse_local_master_announcement_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->local_master_announcement = *(struct nbt_browse_local_master_announcement *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_nbt_browse_payload_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union nbt_browse_payload *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union nbt_browse_payload *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union nbt_browse_payload!");
		return NULL;
	}

	return py_import_nbt_browse_payload(mem_ctx, level, in);
}

static PyObject *py_nbt_browse_payload_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union nbt_browse_payload *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_nbt_browse_payload(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_nbt_browse_payload_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_browse_payload_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_browse_payload_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_nbt_browse_payload_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject nbt_browse_payload_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.browse_payload",
	.tp_getset = NULL,
	.tp_methods = py_nbt_browse_payload_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_browse_payload_new,
};


static PyObject *py_nbt_browse_packet_get_opcode(PyObject *obj, void *closure)
{
	struct nbt_browse_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_opcode;
	py_opcode = PyLong_FromLong((uint16_t)(object->opcode));
	return py_opcode;
}

static int py_nbt_browse_packet_set_opcode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->opcode");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->opcode));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->opcode = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbt_browse_packet_get_payload(PyObject *obj, void *closure)
{
	struct nbt_browse_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_payload;
	py_payload = pyrpc_import_union(&nbt_browse_payload_Type, pytalloc_get_mem_ctx(obj), object->opcode, &object->payload, "union nbt_browse_payload");
	if (py_payload == NULL) {
		return NULL;
	}
	return py_payload;
}

static int py_nbt_browse_packet_set_payload(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbt_browse_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->payload");
		return -1;
	}
	{
		union nbt_browse_payload *payload_switch_0;
		payload_switch_0 = (union nbt_browse_payload *)pyrpc_export_union(&nbt_browse_payload_Type, pytalloc_get_mem_ctx(py_obj), object->opcode, value, "union nbt_browse_payload");
		if (payload_switch_0 == NULL) {
			return -1;
		}
		object->payload = *payload_switch_0;
	}
	return 0;
}

static PyGetSetDef py_nbt_browse_packet_getsetters[] = {
	{
		.name = discard_const_p(char, "opcode"),
		.get = py_nbt_browse_packet_get_opcode,
		.set = py_nbt_browse_packet_set_opcode,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_browse_opcode")
	},
	{
		.name = discard_const_p(char, "payload"),
		.get = py_nbt_browse_packet_get_payload,
		.set = py_nbt_browse_packet_set_payload,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_browse_payload")
	},
	{ .name = NULL }
};

static PyObject *py_nbt_browse_packet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbt_browse_packet, type);
}

static PyObject *py_nbt_browse_packet_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct nbt_browse_packet *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_nbt_browse_packet);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_nbt_browse_packet_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_browse_packet *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_browse_packet);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_nbt_browse_packet);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_nbt_browse_packet_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct nbt_browse_packet *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_browse_packet, "nbt_browse_packet", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_nbt_browse_packet, "nbt_browse_packet", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_nbt_browse_packet_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_nbt_browse_packet_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_browse_packet_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbt_browse_packet_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbt_browse_packet_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.browse_packet",
	.tp_getset = py_nbt_browse_packet_getsetters,
	.tp_methods = py_nbt_browse_packet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbt_browse_packet_new,
};


const struct PyNdrRpcMethodDef py_ndr_nbt_methods[] = {
	{
		.name = NULL,
	},
};

static PyObject *interface_nbt_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_nbt);
}

#define PY_DOC_NBT "NBT messages"
static PyTypeObject nbt_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.nbt",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "nbt(binding, lp_ctx=None, credentials=None, basis_connection=None) -> connection\n"
"\n\n"
"Parameters\n"
"----------\n"
"binding : str\n"
"    A DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx : param.LoadParm\n"
"    Should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials : credentials.Credentials, optional\n"
"    A credentials.Credentials object (default is None).\n"
"basis_connection : samba.dcerpc.ClientConnection, optional\n"
"    A nbt client connection object (default is None).\n"
"\n\n"
"Returns\n"
"-------\n"
"samba.dcerpc.ClientConnection\n"
"    A ClientConnection object\n"
"\n\n"
"Raises\n"
"------\n"
"samba.NTSTATUSError\n"
"    An NTSTATUS error\n"
"\n"PY_DOC_NBT,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_nbt_new,
};

static PyObject *syntax_nbt_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_nbt.syntax_id);
}

#define PY_DOC_NBT_SYNTAX "NBT messages"
static PyTypeObject nbt_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "nbt.nbt_abstract_syntax",
	.tp_doc = "nbt_abstract_syntax()\n"PY_DOC_NBT_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_nbt_new,
};

static PyMethodDef nbt_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "nbt",
	.m_doc = "nbt DCE/RPC",
	.m_size = -1,
	.m_methods = nbt_methods,
};
MODULE_INIT_FUNC(nbt)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;
	PyObject *dep_samba_dcerpc_security = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "dom_sid");
	if (dom_sid_Type == NULL)
		goto out;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	nbt_name_Type.tp_base = BaseObject_Type;
	nbt_name_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_name_question_Type.tp_base = BaseObject_Type;
	nbt_name_question_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_rdata_address_Type.tp_base = BaseObject_Type;
	nbt_rdata_address_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_rdata_netbios_Type.tp_base = BaseObject_Type;
	nbt_rdata_netbios_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_statistics_Type.tp_base = BaseObject_Type;
	nbt_statistics_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_status_name_Type.tp_base = BaseObject_Type;
	nbt_status_name_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_rdata_status_Type.tp_base = BaseObject_Type;
	nbt_rdata_status_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_rdata_data_Type.tp_base = BaseObject_Type;
	nbt_rdata_data_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_rdata_Type.tp_base = BaseObject_Type;
	nbt_rdata_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_res_rec_Type.tp_base = BaseObject_Type;
	nbt_res_rec_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_name_packet_Type.tp_base = BaseObject_Type;
	nbt_name_packet_Type.tp_basicsize = pytalloc_BaseObject_size();

	smb_trans_body_Type.tp_base = BaseObject_Type;
	smb_trans_body_Type.tp_basicsize = pytalloc_BaseObject_size();

	smb_body_Type.tp_base = BaseObject_Type;
	smb_body_Type.tp_basicsize = pytalloc_BaseObject_size();

	dgram_smb_packet_Type.tp_base = BaseObject_Type;
	dgram_smb_packet_Type.tp_basicsize = pytalloc_BaseObject_size();

	dgram_message_body_Type.tp_base = BaseObject_Type;
	dgram_message_body_Type.tp_basicsize = pytalloc_BaseObject_size();

	dgram_message_Type.tp_base = BaseObject_Type;
	dgram_message_Type.tp_basicsize = pytalloc_BaseObject_size();

	dgram_data_Type.tp_base = BaseObject_Type;
	dgram_data_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_dgram_packet_Type.tp_base = BaseObject_Type;
	nbt_dgram_packet_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_sockaddr_Type.tp_base = BaseObject_Type;
	nbt_sockaddr_Type.tp_basicsize = pytalloc_BaseObject_size();

	NETLOGON_SAM_LOGON_REQUEST_Type.tp_base = BaseObject_Type;
	NETLOGON_SAM_LOGON_REQUEST_Type.tp_basicsize = pytalloc_BaseObject_size();

	NETLOGON_LOGON_REQUEST_Type.tp_base = BaseObject_Type;
	NETLOGON_LOGON_REQUEST_Type.tp_basicsize = pytalloc_BaseObject_size();

	NETLOGON_SAM_LOGON_RESPONSE_NT40_Type.tp_base = BaseObject_Type;
	NETLOGON_SAM_LOGON_RESPONSE_NT40_Type.tp_basicsize = pytalloc_BaseObject_size();

	NETLOGON_SAM_LOGON_RESPONSE_Type.tp_base = BaseObject_Type;
	NETLOGON_SAM_LOGON_RESPONSE_Type.tp_basicsize = pytalloc_BaseObject_size();

	NETLOGON_SAM_LOGON_RESPONSE_EX_Type.tp_base = BaseObject_Type;
	NETLOGON_SAM_LOGON_RESPONSE_EX_Type.tp_basicsize = pytalloc_BaseObject_size();

	netlogon_samlogon_response_union_Type.tp_base = BaseObject_Type;
	netlogon_samlogon_response_union_Type.tp_basicsize = pytalloc_BaseObject_size();

	netlogon_samlogon_response_Type.tp_base = BaseObject_Type;
	netlogon_samlogon_response_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_netlogon_query_for_pdc_Type.tp_base = BaseObject_Type;
	nbt_netlogon_query_for_pdc_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_netlogon_response_from_pdc_Type.tp_base = BaseObject_Type;
	nbt_netlogon_response_from_pdc_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_netlogon_response2_Type.tp_base = BaseObject_Type;
	nbt_netlogon_response2_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_db_change_info_Type.tp_base = BaseObject_Type;
	nbt_db_change_info_Type.tp_basicsize = pytalloc_BaseObject_size();

	NETLOGON_DB_CHANGE_Type.tp_base = BaseObject_Type;
	NETLOGON_DB_CHANGE_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_netlogon_request_Type.tp_base = BaseObject_Type;
	nbt_netlogon_request_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_netlogon_packet_Type.tp_base = BaseObject_Type;
	nbt_netlogon_packet_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_browse_host_announcement_Type.tp_base = BaseObject_Type;
	nbt_browse_host_announcement_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_browse_announcement_request_Type.tp_base = BaseObject_Type;
	nbt_browse_announcement_request_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_browse_election_request_Type.tp_base = BaseObject_Type;
	nbt_browse_election_request_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_browse_backup_list_request_Type.tp_base = BaseObject_Type;
	nbt_browse_backup_list_request_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_browse_backup_list_response_Type.tp_base = BaseObject_Type;
	nbt_browse_backup_list_response_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_browse_become_backup_Type.tp_base = BaseObject_Type;
	nbt_browse_become_backup_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_browse_domain_announcement_Type.tp_base = BaseObject_Type;
	nbt_browse_domain_announcement_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_browse_master_announcement_Type.tp_base = BaseObject_Type;
	nbt_browse_master_announcement_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_browse_reset_state_Type.tp_base = BaseObject_Type;
	nbt_browse_reset_state_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_browse_local_master_announcement_Type.tp_base = BaseObject_Type;
	nbt_browse_local_master_announcement_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_browse_payload_Type.tp_base = BaseObject_Type;
	nbt_browse_payload_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_browse_packet_Type.tp_base = BaseObject_Type;
	nbt_browse_packet_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbt_InterfaceType.tp_base = ClientConnection_Type;

	nbt_SyntaxType.tp_base = ndr_syntax_id_Type;
	nbt_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&nbt_name_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_name_question_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_rdata_address_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_rdata_netbios_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_statistics_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_status_name_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_rdata_status_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_rdata_data_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_rdata_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_res_rec_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_name_packet_Type) < 0)
		goto out;
	if (PyType_Ready(&smb_trans_body_Type) < 0)
		goto out;
	if (PyType_Ready(&smb_body_Type) < 0)
		goto out;
	if (PyType_Ready(&dgram_smb_packet_Type) < 0)
		goto out;
	if (PyType_Ready(&dgram_message_body_Type) < 0)
		goto out;
	if (PyType_Ready(&dgram_message_Type) < 0)
		goto out;
	if (PyType_Ready(&dgram_data_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_dgram_packet_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_sockaddr_Type) < 0)
		goto out;
	if (PyType_Ready(&NETLOGON_SAM_LOGON_REQUEST_Type) < 0)
		goto out;
	if (PyType_Ready(&NETLOGON_LOGON_REQUEST_Type) < 0)
		goto out;
	if (PyType_Ready(&NETLOGON_SAM_LOGON_RESPONSE_NT40_Type) < 0)
		goto out;
	if (PyType_Ready(&NETLOGON_SAM_LOGON_RESPONSE_Type) < 0)
		goto out;
	if (PyType_Ready(&NETLOGON_SAM_LOGON_RESPONSE_EX_Type) < 0)
		goto out;
	if (PyType_Ready(&netlogon_samlogon_response_union_Type) < 0)
		goto out;
	if (PyType_Ready(&netlogon_samlogon_response_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_netlogon_query_for_pdc_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_netlogon_response_from_pdc_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_netlogon_response2_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_db_change_info_Type) < 0)
		goto out;
	if (PyType_Ready(&NETLOGON_DB_CHANGE_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_netlogon_request_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_netlogon_packet_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_browse_host_announcement_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_browse_announcement_request_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_browse_election_request_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_browse_backup_list_request_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_browse_backup_list_response_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_browse_become_backup_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_browse_domain_announcement_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_browse_master_announcement_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_browse_reset_state_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_browse_local_master_announcement_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_browse_payload_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_browse_packet_Type) < 0)
		goto out;
	if (PyType_Ready(&nbt_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&nbt_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&nbt_InterfaceType, py_ndr_nbt_methods))
		return NULL;

#ifdef PY_NAME_PATCH
	PY_NAME_PATCH(&nbt_name_Type);
#endif
#ifdef PY_NAME_QUESTION_PATCH
	PY_NAME_QUESTION_PATCH(&nbt_name_question_Type);
#endif
#ifdef PY_RDATA_ADDRESS_PATCH
	PY_RDATA_ADDRESS_PATCH(&nbt_rdata_address_Type);
#endif
#ifdef PY_RDATA_NETBIOS_PATCH
	PY_RDATA_NETBIOS_PATCH(&nbt_rdata_netbios_Type);
#endif
#ifdef PY_STATISTICS_PATCH
	PY_STATISTICS_PATCH(&nbt_statistics_Type);
#endif
#ifdef PY_STATUS_NAME_PATCH
	PY_STATUS_NAME_PATCH(&nbt_status_name_Type);
#endif
#ifdef PY_RDATA_STATUS_PATCH
	PY_RDATA_STATUS_PATCH(&nbt_rdata_status_Type);
#endif
#ifdef PY_RDATA_DATA_PATCH
	PY_RDATA_DATA_PATCH(&nbt_rdata_data_Type);
#endif
#ifdef PY_RDATA_PATCH
	PY_RDATA_PATCH(&nbt_rdata_Type);
#endif
#ifdef PY_RES_REC_PATCH
	PY_RES_REC_PATCH(&nbt_res_rec_Type);
#endif
#ifdef PY_NAME_PACKET_PATCH
	PY_NAME_PACKET_PATCH(&nbt_name_packet_Type);
#endif
#ifdef PY_SMB_TRANS_BODY_PATCH
	PY_SMB_TRANS_BODY_PATCH(&smb_trans_body_Type);
#endif
#ifdef PY_SMB_BODY_PATCH
	PY_SMB_BODY_PATCH(&smb_body_Type);
#endif
#ifdef PY_DGRAM_SMB_PACKET_PATCH
	PY_DGRAM_SMB_PACKET_PATCH(&dgram_smb_packet_Type);
#endif
#ifdef PY_DGRAM_MESSAGE_BODY_PATCH
	PY_DGRAM_MESSAGE_BODY_PATCH(&dgram_message_body_Type);
#endif
#ifdef PY_DGRAM_MESSAGE_PATCH
	PY_DGRAM_MESSAGE_PATCH(&dgram_message_Type);
#endif
#ifdef PY_DGRAM_DATA_PATCH
	PY_DGRAM_DATA_PATCH(&dgram_data_Type);
#endif
#ifdef PY_DGRAM_PACKET_PATCH
	PY_DGRAM_PACKET_PATCH(&nbt_dgram_packet_Type);
#endif
#ifdef PY_SOCKADDR_PATCH
	PY_SOCKADDR_PATCH(&nbt_sockaddr_Type);
#endif
#ifdef PY_NETLOGON_SAM_LOGON_REQUEST_PATCH
	PY_NETLOGON_SAM_LOGON_REQUEST_PATCH(&NETLOGON_SAM_LOGON_REQUEST_Type);
#endif
#ifdef PY_NETLOGON_LOGON_REQUEST_PATCH
	PY_NETLOGON_LOGON_REQUEST_PATCH(&NETLOGON_LOGON_REQUEST_Type);
#endif
#ifdef PY_NETLOGON_SAM_LOGON_RESPONSE_NT40_PATCH
	PY_NETLOGON_SAM_LOGON_RESPONSE_NT40_PATCH(&NETLOGON_SAM_LOGON_RESPONSE_NT40_Type);
#endif
#ifdef PY_NETLOGON_SAM_LOGON_RESPONSE_PATCH
	PY_NETLOGON_SAM_LOGON_RESPONSE_PATCH(&NETLOGON_SAM_LOGON_RESPONSE_Type);
#endif
#ifdef PY_NETLOGON_SAM_LOGON_RESPONSE_EX_PATCH
	PY_NETLOGON_SAM_LOGON_RESPONSE_EX_PATCH(&NETLOGON_SAM_LOGON_RESPONSE_EX_Type);
#endif
#ifdef PY_NETLOGON_SAMLOGON_RESPONSE_UNION_PATCH
	PY_NETLOGON_SAMLOGON_RESPONSE_UNION_PATCH(&netlogon_samlogon_response_union_Type);
#endif
#ifdef PY_NETLOGON_SAMLOGON_RESPONSE_PATCH
	PY_NETLOGON_SAMLOGON_RESPONSE_PATCH(&netlogon_samlogon_response_Type);
#endif
#ifdef PY_NETLOGON_QUERY_FOR_PDC_PATCH
	PY_NETLOGON_QUERY_FOR_PDC_PATCH(&nbt_netlogon_query_for_pdc_Type);
#endif
#ifdef PY_NETLOGON_RESPONSE_FROM_PDC_PATCH
	PY_NETLOGON_RESPONSE_FROM_PDC_PATCH(&nbt_netlogon_response_from_pdc_Type);
#endif
#ifdef PY_NETLOGON_RESPONSE2_PATCH
	PY_NETLOGON_RESPONSE2_PATCH(&nbt_netlogon_response2_Type);
#endif
#ifdef PY_DB_CHANGE_INFO_PATCH
	PY_DB_CHANGE_INFO_PATCH(&nbt_db_change_info_Type);
#endif
#ifdef PY_NETLOGON_DB_CHANGE_PATCH
	PY_NETLOGON_DB_CHANGE_PATCH(&NETLOGON_DB_CHANGE_Type);
#endif
#ifdef PY_NETLOGON_REQUEST_PATCH
	PY_NETLOGON_REQUEST_PATCH(&nbt_netlogon_request_Type);
#endif
#ifdef PY_NETLOGON_PACKET_PATCH
	PY_NETLOGON_PACKET_PATCH(&nbt_netlogon_packet_Type);
#endif
#ifdef PY_BROWSE_HOST_ANNOUNCEMENT_PATCH
	PY_BROWSE_HOST_ANNOUNCEMENT_PATCH(&nbt_browse_host_announcement_Type);
#endif
#ifdef PY_BROWSE_ANNOUNCEMENT_REQUEST_PATCH
	PY_BROWSE_ANNOUNCEMENT_REQUEST_PATCH(&nbt_browse_announcement_request_Type);
#endif
#ifdef PY_BROWSE_ELECTION_REQUEST_PATCH
	PY_BROWSE_ELECTION_REQUEST_PATCH(&nbt_browse_election_request_Type);
#endif
#ifdef PY_BROWSE_BACKUP_LIST_REQUEST_PATCH
	PY_BROWSE_BACKUP_LIST_REQUEST_PATCH(&nbt_browse_backup_list_request_Type);
#endif
#ifdef PY_BROWSE_BACKUP_LIST_RESPONSE_PATCH
	PY_BROWSE_BACKUP_LIST_RESPONSE_PATCH(&nbt_browse_backup_list_response_Type);
#endif
#ifdef PY_BROWSE_BECOME_BACKUP_PATCH
	PY_BROWSE_BECOME_BACKUP_PATCH(&nbt_browse_become_backup_Type);
#endif
#ifdef PY_BROWSE_DOMAIN_ANNOUNCEMENT_PATCH
	PY_BROWSE_DOMAIN_ANNOUNCEMENT_PATCH(&nbt_browse_domain_announcement_Type);
#endif
#ifdef PY_BROWSE_MASTER_ANNOUNCEMENT_PATCH
	PY_BROWSE_MASTER_ANNOUNCEMENT_PATCH(&nbt_browse_master_announcement_Type);
#endif
#ifdef PY_BROWSE_RESET_STATE_PATCH
	PY_BROWSE_RESET_STATE_PATCH(&nbt_browse_reset_state_Type);
#endif
#ifdef PY_BROWSE_LOCAL_MASTER_ANNOUNCEMENT_PATCH
	PY_BROWSE_LOCAL_MASTER_ANNOUNCEMENT_PATCH(&nbt_browse_local_master_announcement_Type);
#endif
#ifdef PY_BROWSE_PAYLOAD_PATCH
	PY_BROWSE_PAYLOAD_PATCH(&nbt_browse_payload_Type);
#endif
#ifdef PY_BROWSE_PACKET_PATCH
	PY_BROWSE_PACKET_PATCH(&nbt_browse_packet_Type);
#endif
#ifdef PY_NBT_PATCH
	PY_NBT_PATCH(&nbt_InterfaceType);
#endif
#ifdef PY_NBT_ABSTRACT_SYNTAX_PATCH
	PY_NBT_ABSTRACT_SYNTAX_PATCH(&nbt_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&nbt_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "NBT_NAME_SERVICE_PORT", PyLong_FromUnsignedLongLong(137));
	PyModule_AddObject(m, "NBT_DGRAM_SERVICE_PORT", PyLong_FromUnsignedLongLong(138));
	PyModule_AddObject(m, "NBT_MAILSLOT_NETLOGON", PyUnicode_FromString("\\MAILSLOT\\NET\\NETLOGON"));
	PyModule_AddObject(m, "NBT_MAILSLOT_NTLOGON", PyUnicode_FromString("\\MAILSLOT\\NET\\NTLOGON"));
	PyModule_AddObject(m, "NBT_MAILSLOT_GETDC", PyUnicode_FromString("\\MAILSLOT\\NET\\GETDC"));
	PyModule_AddObject(m, "NBT_MAILSLOT_BROWSE", PyUnicode_FromString("\\MAILSLOT\\BROWSE"));
	PyModule_AddObject(m, "DGRAM_SMB", PyLong_FromUnsignedLongLong(0xff534d42));
	PyModule_AddObject(m, "NBT_RCODE", PyLong_FromLong((uint16_t)(NBT_RCODE)));
	PyModule_AddObject(m, "NBT_FLAG_BROADCAST", PyLong_FromLong((uint16_t)(NBT_FLAG_BROADCAST)));
	PyModule_AddObject(m, "NBT_FLAG_RECURSION_AVAIL", PyLong_FromLong((uint16_t)(NBT_FLAG_RECURSION_AVAIL)));
	PyModule_AddObject(m, "NBT_FLAG_RECURSION_DESIRED", PyLong_FromLong((uint16_t)(NBT_FLAG_RECURSION_DESIRED)));
	PyModule_AddObject(m, "NBT_FLAG_TRUNCATION", PyLong_FromLong((uint16_t)(NBT_FLAG_TRUNCATION)));
	PyModule_AddObject(m, "NBT_FLAG_AUTHORITATIVE", PyLong_FromLong((uint16_t)(NBT_FLAG_AUTHORITATIVE)));
	PyModule_AddObject(m, "NBT_OPCODE", PyLong_FromLong((uint16_t)(NBT_OPCODE)));
	PyModule_AddObject(m, "NBT_FLAG_REPLY", PyLong_FromLong((uint16_t)(NBT_FLAG_REPLY)));
	PyModule_AddObject(m, "NBT_OPCODE_QUERY", PyLong_FromLong((uint16_t)(NBT_OPCODE_QUERY)));
	PyModule_AddObject(m, "NBT_OPCODE_REGISTER", PyLong_FromLong((uint16_t)(NBT_OPCODE_REGISTER)));
	PyModule_AddObject(m, "NBT_OPCODE_RELEASE", PyLong_FromLong((uint16_t)(NBT_OPCODE_RELEASE)));
	PyModule_AddObject(m, "NBT_OPCODE_WACK", PyLong_FromLong((uint16_t)(NBT_OPCODE_WACK)));
	PyModule_AddObject(m, "NBT_OPCODE_REFRESH", PyLong_FromLong((uint16_t)(NBT_OPCODE_REFRESH)));
	PyModule_AddObject(m, "NBT_OPCODE_REFRESH2", PyLong_FromLong((uint16_t)(NBT_OPCODE_REFRESH2)));
	PyModule_AddObject(m, "NBT_OPCODE_MULTI_HOME_REG", PyLong_FromLong((uint16_t)(NBT_OPCODE_MULTI_HOME_REG)));
	PyModule_AddObject(m, "NBT_RCODE_OK", PyLong_FromLong((uint16_t)(NBT_RCODE_OK)));
	PyModule_AddObject(m, "NBT_RCODE_FMT", PyLong_FromLong((uint16_t)(NBT_RCODE_FMT)));
	PyModule_AddObject(m, "NBT_RCODE_SVR", PyLong_FromLong((uint16_t)(NBT_RCODE_SVR)));
	PyModule_AddObject(m, "NBT_RCODE_NAM", PyLong_FromLong((uint16_t)(NBT_RCODE_NAM)));
	PyModule_AddObject(m, "NBT_RCODE_IMP", PyLong_FromLong((uint16_t)(NBT_RCODE_IMP)));
	PyModule_AddObject(m, "NBT_RCODE_RFS", PyLong_FromLong((uint16_t)(NBT_RCODE_RFS)));
	PyModule_AddObject(m, "NBT_RCODE_ACT", PyLong_FromLong((uint16_t)(NBT_RCODE_ACT)));
	PyModule_AddObject(m, "NBT_RCODE_CFT", PyLong_FromLong((uint16_t)(NBT_RCODE_CFT)));
	PyModule_AddObject(m, "NBT_NAME_CLIENT", PyLong_FromLong((uint16_t)(NBT_NAME_CLIENT)));
	PyModule_AddObject(m, "NBT_NAME_MS", PyLong_FromLong((uint16_t)(NBT_NAME_MS)));
	PyModule_AddObject(m, "NBT_NAME_USER", PyLong_FromLong((uint16_t)(NBT_NAME_USER)));
	PyModule_AddObject(m, "NBT_NAME_SERVER", PyLong_FromLong((uint16_t)(NBT_NAME_SERVER)));
	PyModule_AddObject(m, "NBT_NAME_PDC", PyLong_FromLong((uint16_t)(NBT_NAME_PDC)));
	PyModule_AddObject(m, "NBT_NAME_LOGON", PyLong_FromLong((uint16_t)(NBT_NAME_LOGON)));
	PyModule_AddObject(m, "NBT_NAME_MASTER", PyLong_FromLong((uint16_t)(NBT_NAME_MASTER)));
	PyModule_AddObject(m, "NBT_NAME_BROWSER", PyLong_FromLong((uint16_t)(NBT_NAME_BROWSER)));
	PyModule_AddObject(m, "NBT_QCLASS_IP", PyLong_FromLong((uint16_t)(NBT_QCLASS_IP)));
	PyModule_AddObject(m, "NBT_QTYPE_ADDRESS", PyLong_FromLong((uint16_t)(NBT_QTYPE_ADDRESS)));
	PyModule_AddObject(m, "NBT_QTYPE_NAMESERVICE", PyLong_FromLong((uint16_t)(NBT_QTYPE_NAMESERVICE)));
	PyModule_AddObject(m, "NBT_QTYPE_NULL", PyLong_FromLong((uint16_t)(NBT_QTYPE_NULL)));
	PyModule_AddObject(m, "NBT_QTYPE_NETBIOS", PyLong_FromLong((uint16_t)(NBT_QTYPE_NETBIOS)));
	PyModule_AddObject(m, "NBT_QTYPE_STATUS", PyLong_FromLong((uint16_t)(NBT_QTYPE_STATUS)));
	PyModule_AddObject(m, "NBT_QTYPE_WACK", PyLong_FromLong((uint16_t)(NBT_QTYPE_WACK)));
	PyModule_AddObject(m, "NBT_NODE_B", PyLong_FromLong((uint16_t)(NBT_NODE_B)));
	PyModule_AddObject(m, "NBT_NODE_P", PyLong_FromLong((uint16_t)(NBT_NODE_P)));
	PyModule_AddObject(m, "NBT_NODE_M", PyLong_FromLong((uint16_t)(NBT_NODE_M)));
	PyModule_AddObject(m, "NBT_NODE_H", PyLong_FromLong((uint16_t)(NBT_NODE_H)));
	PyModule_AddObject(m, "NBT_NM_PERMANENT", PyLong_FromLong((uint16_t)(NBT_NM_PERMANENT)));
	PyModule_AddObject(m, "NBT_NM_ACTIVE", PyLong_FromLong((uint16_t)(NBT_NM_ACTIVE)));
	PyModule_AddObject(m, "NBT_NM_CONFLICT", PyLong_FromLong((uint16_t)(NBT_NM_CONFLICT)));
	PyModule_AddObject(m, "NBT_NM_DEREGISTER", PyLong_FromLong((uint16_t)(NBT_NM_DEREGISTER)));
	PyModule_AddObject(m, "NBT_NM_OWNER_TYPE", PyLong_FromLong((uint16_t)(NBT_NM_OWNER_TYPE)));
	PyModule_AddObject(m, "NBT_NM_GROUP", PyLong_FromLong((uint16_t)(NBT_NM_GROUP)));
	PyModule_AddObject(m, "DGRAM_DIRECT_UNIQUE", PyLong_FromLong((uint16_t)(DGRAM_DIRECT_UNIQUE)));
	PyModule_AddObject(m, "DGRAM_DIRECT_GROUP", PyLong_FromLong((uint16_t)(DGRAM_DIRECT_GROUP)));
	PyModule_AddObject(m, "DGRAM_BCAST", PyLong_FromLong((uint16_t)(DGRAM_BCAST)));
	PyModule_AddObject(m, "DGRAM_ERROR", PyLong_FromLong((uint16_t)(DGRAM_ERROR)));
	PyModule_AddObject(m, "DGRAM_QUERY", PyLong_FromLong((uint16_t)(DGRAM_QUERY)));
	PyModule_AddObject(m, "DGRAM_QUERY_POSITIVE", PyLong_FromLong((uint16_t)(DGRAM_QUERY_POSITIVE)));
	PyModule_AddObject(m, "DGRAM_QUERY_NEGATIVE", PyLong_FromLong((uint16_t)(DGRAM_QUERY_NEGATIVE)));
	PyModule_AddObject(m, "DGRAM_FLAG_MORE", PyLong_FromLong((uint16_t)(DGRAM_FLAG_MORE)));
	PyModule_AddObject(m, "DGRAM_FLAG_FIRST", PyLong_FromLong((uint16_t)(DGRAM_FLAG_FIRST)));
	PyModule_AddObject(m, "DGRAM_FLAG_NODE_TYPE", PyLong_FromLong((uint16_t)(DGRAM_FLAG_NODE_TYPE)));
	PyModule_AddObject(m, "DGRAM_NODE_B", PyLong_FromLong((uint16_t)(DGRAM_NODE_B)));
	PyModule_AddObject(m, "DGRAM_NODE_P", PyLong_FromLong((uint16_t)(DGRAM_NODE_P)));
	PyModule_AddObject(m, "DGRAM_NODE_M", PyLong_FromLong((uint16_t)(DGRAM_NODE_M)));
	PyModule_AddObject(m, "DGRAM_NODE_NBDD", PyLong_FromLong((uint16_t)(DGRAM_NODE_NBDD)));
	PyModule_AddObject(m, "SMB_TRANSACTION", PyLong_FromLong((uint16_t)(SMB_TRANSACTION)));
	PyModule_AddObject(m, "DGRAM_ERROR_NAME_NOT_PRESENT", PyLong_FromLong((uint16_t)(DGRAM_ERROR_NAME_NOT_PRESENT)));
	PyModule_AddObject(m, "DGRAM_ERROR_INVALID_SOURCE", PyLong_FromLong((uint16_t)(DGRAM_ERROR_INVALID_SOURCE)));
	PyModule_AddObject(m, "DGRAM_ERROR_INVALID_DEST", PyLong_FromLong((uint16_t)(DGRAM_ERROR_INVALID_DEST)));
	PyModule_AddObject(m, "NBT_SERVER_PDC", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_PDC)));
	PyModule_AddObject(m, "NBT_SERVER_GC", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_GC)));
	PyModule_AddObject(m, "NBT_SERVER_LDAP", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_LDAP)));
	PyModule_AddObject(m, "NBT_SERVER_DS", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_DS)));
	PyModule_AddObject(m, "NBT_SERVER_KDC", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_KDC)));
	PyModule_AddObject(m, "NBT_SERVER_TIMESERV", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_TIMESERV)));
	PyModule_AddObject(m, "NBT_SERVER_CLOSEST", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_CLOSEST)));
	PyModule_AddObject(m, "NBT_SERVER_WRITABLE", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_WRITABLE)));
	PyModule_AddObject(m, "NBT_SERVER_GOOD_TIMESERV", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_GOOD_TIMESERV)));
	PyModule_AddObject(m, "NBT_SERVER_NDNC", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_NDNC)));
	PyModule_AddObject(m, "NBT_SERVER_SELECT_SECRET_DOMAIN_6", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_SELECT_SECRET_DOMAIN_6)));
	PyModule_AddObject(m, "NBT_SERVER_FULL_SECRET_DOMAIN_6", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_FULL_SECRET_DOMAIN_6)));
	PyModule_AddObject(m, "NBT_SERVER_ADS_WEB_SERVICE", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_ADS_WEB_SERVICE)));
	PyModule_AddObject(m, "NBT_SERVER_DS_8", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_DS_8)));
	PyModule_AddObject(m, "NBT_SERVER_DS_9", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_DS_9)));
	PyModule_AddObject(m, "NBT_SERVER_DS_10", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_DS_10)));
	PyModule_AddObject(m, "NBT_SERVER_HAS_DNS_NAME", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_HAS_DNS_NAME)));
	PyModule_AddObject(m, "NBT_SERVER_IS_DEFAULT_NC", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_IS_DEFAULT_NC)));
	PyModule_AddObject(m, "NBT_SERVER_FOREST_ROOT", PyLong_FromUnsignedLongLong((uint32_t)(NBT_SERVER_FOREST_ROOT)));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_1", PyLong_FromUnsignedLongLong((uint32_t)(NETLOGON_NT_VERSION_1)));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_5", PyLong_FromUnsignedLongLong((uint32_t)(NETLOGON_NT_VERSION_5)));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_5EX", PyLong_FromUnsignedLongLong((uint32_t)(NETLOGON_NT_VERSION_5EX)));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_5EX_WITH_IP", PyLong_FromUnsignedLongLong((uint32_t)(NETLOGON_NT_VERSION_5EX_WITH_IP)));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_WITH_CLOSEST_SITE", PyLong_FromUnsignedLongLong((uint32_t)(NETLOGON_NT_VERSION_WITH_CLOSEST_SITE)));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_AVOID_NT4EMUL", PyLong_FromUnsignedLongLong((uint32_t)(NETLOGON_NT_VERSION_AVOID_NT4EMUL)));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_PDC", PyLong_FromUnsignedLongLong((uint32_t)(NETLOGON_NT_VERSION_PDC)));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_IP", PyLong_FromUnsignedLongLong((uint32_t)(NETLOGON_NT_VERSION_IP)));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_LOCAL", PyLong_FromUnsignedLongLong((uint32_t)(NETLOGON_NT_VERSION_LOCAL)));
	PyModule_AddObject(m, "NETLOGON_NT_VERSION_GC", PyLong_FromUnsignedLongLong((uint32_t)(NETLOGON_NT_VERSION_GC)));
	PyModule_AddObject(m, "LOGON_REQUEST", PyLong_FromLong((uint16_t)(LOGON_REQUEST)));
	PyModule_AddObject(m, "LOGON_RESPONSE2", PyLong_FromLong((uint16_t)(LOGON_RESPONSE2)));
	PyModule_AddObject(m, "LOGON_PRIMARY_QUERY", PyLong_FromLong((uint16_t)(LOGON_PRIMARY_QUERY)));
	PyModule_AddObject(m, "NETLOGON_ANNOUNCE_UAS", PyLong_FromLong((uint16_t)(NETLOGON_ANNOUNCE_UAS)));
	PyModule_AddObject(m, "NETLOGON_RESPONSE_FROM_PDC", PyLong_FromLong((uint16_t)(NETLOGON_RESPONSE_FROM_PDC)));
	PyModule_AddObject(m, "LOGON_SAM_LOGON_REQUEST", PyLong_FromLong((uint16_t)(LOGON_SAM_LOGON_REQUEST)));
	PyModule_AddObject(m, "LOGON_SAM_LOGON_RESPONSE", PyLong_FromLong((uint16_t)(LOGON_SAM_LOGON_RESPONSE)));
	PyModule_AddObject(m, "LOGON_SAM_LOGON_PAUSE_RESPONSE", PyLong_FromLong((uint16_t)(LOGON_SAM_LOGON_PAUSE_RESPONSE)));
	PyModule_AddObject(m, "LOGON_SAM_LOGON_USER_UNKNOWN", PyLong_FromLong((uint16_t)(LOGON_SAM_LOGON_USER_UNKNOWN)));
	PyModule_AddObject(m, "LOGON_SAM_LOGON_RESPONSE_EX", PyLong_FromLong((uint16_t)(LOGON_SAM_LOGON_RESPONSE_EX)));
	PyModule_AddObject(m, "LOGON_SAM_LOGON_PAUSE_RESPONSE_EX", PyLong_FromLong((uint16_t)(LOGON_SAM_LOGON_PAUSE_RESPONSE_EX)));
	PyModule_AddObject(m, "LOGON_SAM_LOGON_USER_UNKNOWN_EX", PyLong_FromLong((uint16_t)(LOGON_SAM_LOGON_USER_UNKNOWN_EX)));
	PyModule_AddObject(m, "HostAnnouncement", PyLong_FromLong((uint16_t)(HostAnnouncement)));
	PyModule_AddObject(m, "AnnouncementRequest", PyLong_FromLong((uint16_t)(AnnouncementRequest)));
	PyModule_AddObject(m, "Election", PyLong_FromLong((uint16_t)(Election)));
	PyModule_AddObject(m, "GetBackupListReq", PyLong_FromLong((uint16_t)(GetBackupListReq)));
	PyModule_AddObject(m, "GetBackupListResp", PyLong_FromLong((uint16_t)(GetBackupListResp)));
	PyModule_AddObject(m, "BecomeBackup", PyLong_FromLong((uint16_t)(BecomeBackup)));
	PyModule_AddObject(m, "DomainAnnouncement", PyLong_FromLong((uint16_t)(DomainAnnouncement)));
	PyModule_AddObject(m, "MasterAnnouncement", PyLong_FromLong((uint16_t)(MasterAnnouncement)));
	PyModule_AddObject(m, "ResetBrowserState", PyLong_FromLong((uint16_t)(ResetBrowserState)));
	PyModule_AddObject(m, "LocalMasterAnnouncement", PyLong_FromLong((uint16_t)(LocalMasterAnnouncement)));
	Py_INCREF((PyObject *)(void *)&nbt_name_Type);
	PyModule_AddObject(m, "name", (PyObject *)(void *)&nbt_name_Type);
	Py_INCREF((PyObject *)(void *)&nbt_name_question_Type);
	PyModule_AddObject(m, "name_question", (PyObject *)(void *)&nbt_name_question_Type);
	Py_INCREF((PyObject *)(void *)&nbt_rdata_address_Type);
	PyModule_AddObject(m, "rdata_address", (PyObject *)(void *)&nbt_rdata_address_Type);
	Py_INCREF((PyObject *)(void *)&nbt_rdata_netbios_Type);
	PyModule_AddObject(m, "rdata_netbios", (PyObject *)(void *)&nbt_rdata_netbios_Type);
	Py_INCREF((PyObject *)(void *)&nbt_statistics_Type);
	PyModule_AddObject(m, "statistics", (PyObject *)(void *)&nbt_statistics_Type);
	Py_INCREF((PyObject *)(void *)&nbt_status_name_Type);
	PyModule_AddObject(m, "status_name", (PyObject *)(void *)&nbt_status_name_Type);
	Py_INCREF((PyObject *)(void *)&nbt_rdata_status_Type);
	PyModule_AddObject(m, "rdata_status", (PyObject *)(void *)&nbt_rdata_status_Type);
	Py_INCREF((PyObject *)(void *)&nbt_rdata_data_Type);
	PyModule_AddObject(m, "rdata_data", (PyObject *)(void *)&nbt_rdata_data_Type);
	Py_INCREF((PyObject *)(void *)&nbt_rdata_Type);
	PyModule_AddObject(m, "rdata", (PyObject *)(void *)&nbt_rdata_Type);
	Py_INCREF((PyObject *)(void *)&nbt_res_rec_Type);
	PyModule_AddObject(m, "res_rec", (PyObject *)(void *)&nbt_res_rec_Type);
	Py_INCREF((PyObject *)(void *)&nbt_name_packet_Type);
	PyModule_AddObject(m, "name_packet", (PyObject *)(void *)&nbt_name_packet_Type);
	Py_INCREF((PyObject *)(void *)&smb_trans_body_Type);
	PyModule_AddObject(m, "smb_trans_body", (PyObject *)(void *)&smb_trans_body_Type);
	Py_INCREF((PyObject *)(void *)&smb_body_Type);
	PyModule_AddObject(m, "smb_body", (PyObject *)(void *)&smb_body_Type);
	Py_INCREF((PyObject *)(void *)&dgram_smb_packet_Type);
	PyModule_AddObject(m, "dgram_smb_packet", (PyObject *)(void *)&dgram_smb_packet_Type);
	Py_INCREF((PyObject *)(void *)&dgram_message_body_Type);
	PyModule_AddObject(m, "dgram_message_body", (PyObject *)(void *)&dgram_message_body_Type);
	Py_INCREF((PyObject *)(void *)&dgram_message_Type);
	PyModule_AddObject(m, "dgram_message", (PyObject *)(void *)&dgram_message_Type);
	Py_INCREF((PyObject *)(void *)&dgram_data_Type);
	PyModule_AddObject(m, "dgram_data", (PyObject *)(void *)&dgram_data_Type);
	Py_INCREF((PyObject *)(void *)&nbt_dgram_packet_Type);
	PyModule_AddObject(m, "dgram_packet", (PyObject *)(void *)&nbt_dgram_packet_Type);
	Py_INCREF((PyObject *)(void *)&nbt_sockaddr_Type);
	PyModule_AddObject(m, "sockaddr", (PyObject *)(void *)&nbt_sockaddr_Type);
	Py_INCREF((PyObject *)(void *)&NETLOGON_SAM_LOGON_REQUEST_Type);
	PyModule_AddObject(m, "NETLOGON_SAM_LOGON_REQUEST", (PyObject *)(void *)&NETLOGON_SAM_LOGON_REQUEST_Type);
	Py_INCREF((PyObject *)(void *)&NETLOGON_LOGON_REQUEST_Type);
	PyModule_AddObject(m, "NETLOGON_LOGON_REQUEST", (PyObject *)(void *)&NETLOGON_LOGON_REQUEST_Type);
	Py_INCREF((PyObject *)(void *)&NETLOGON_SAM_LOGON_RESPONSE_NT40_Type);
	PyModule_AddObject(m, "NETLOGON_SAM_LOGON_RESPONSE_NT40", (PyObject *)(void *)&NETLOGON_SAM_LOGON_RESPONSE_NT40_Type);
	Py_INCREF((PyObject *)(void *)&NETLOGON_SAM_LOGON_RESPONSE_Type);
	PyModule_AddObject(m, "NETLOGON_SAM_LOGON_RESPONSE", (PyObject *)(void *)&NETLOGON_SAM_LOGON_RESPONSE_Type);
	Py_INCREF((PyObject *)(void *)&NETLOGON_SAM_LOGON_RESPONSE_EX_Type);
	PyModule_AddObject(m, "NETLOGON_SAM_LOGON_RESPONSE_EX", (PyObject *)(void *)&NETLOGON_SAM_LOGON_RESPONSE_EX_Type);
	Py_INCREF((PyObject *)(void *)&netlogon_samlogon_response_union_Type);
	PyModule_AddObject(m, "netlogon_samlogon_response_union", (PyObject *)(void *)&netlogon_samlogon_response_union_Type);
	Py_INCREF((PyObject *)(void *)&netlogon_samlogon_response_Type);
	PyModule_AddObject(m, "netlogon_samlogon_response", (PyObject *)(void *)&netlogon_samlogon_response_Type);
	Py_INCREF((PyObject *)(void *)&nbt_netlogon_query_for_pdc_Type);
	PyModule_AddObject(m, "netlogon_query_for_pdc", (PyObject *)(void *)&nbt_netlogon_query_for_pdc_Type);
	Py_INCREF((PyObject *)(void *)&nbt_netlogon_response_from_pdc_Type);
	PyModule_AddObject(m, "netlogon_response_from_pdc", (PyObject *)(void *)&nbt_netlogon_response_from_pdc_Type);
	Py_INCREF((PyObject *)(void *)&nbt_netlogon_response2_Type);
	PyModule_AddObject(m, "netlogon_response2", (PyObject *)(void *)&nbt_netlogon_response2_Type);
	Py_INCREF((PyObject *)(void *)&nbt_db_change_info_Type);
	PyModule_AddObject(m, "db_change_info", (PyObject *)(void *)&nbt_db_change_info_Type);
	Py_INCREF((PyObject *)(void *)&NETLOGON_DB_CHANGE_Type);
	PyModule_AddObject(m, "NETLOGON_DB_CHANGE", (PyObject *)(void *)&NETLOGON_DB_CHANGE_Type);
	Py_INCREF((PyObject *)(void *)&nbt_netlogon_request_Type);
	PyModule_AddObject(m, "netlogon_request", (PyObject *)(void *)&nbt_netlogon_request_Type);
	Py_INCREF((PyObject *)(void *)&nbt_netlogon_packet_Type);
	PyModule_AddObject(m, "netlogon_packet", (PyObject *)(void *)&nbt_netlogon_packet_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_host_announcement_Type);
	PyModule_AddObject(m, "browse_host_announcement", (PyObject *)(void *)&nbt_browse_host_announcement_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_announcement_request_Type);
	PyModule_AddObject(m, "browse_announcement_request", (PyObject *)(void *)&nbt_browse_announcement_request_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_election_request_Type);
	PyModule_AddObject(m, "browse_election_request", (PyObject *)(void *)&nbt_browse_election_request_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_backup_list_request_Type);
	PyModule_AddObject(m, "browse_backup_list_request", (PyObject *)(void *)&nbt_browse_backup_list_request_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_backup_list_response_Type);
	PyModule_AddObject(m, "browse_backup_list_response", (PyObject *)(void *)&nbt_browse_backup_list_response_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_become_backup_Type);
	PyModule_AddObject(m, "browse_become_backup", (PyObject *)(void *)&nbt_browse_become_backup_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_domain_announcement_Type);
	PyModule_AddObject(m, "browse_domain_announcement", (PyObject *)(void *)&nbt_browse_domain_announcement_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_master_announcement_Type);
	PyModule_AddObject(m, "browse_master_announcement", (PyObject *)(void *)&nbt_browse_master_announcement_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_reset_state_Type);
	PyModule_AddObject(m, "browse_reset_state", (PyObject *)(void *)&nbt_browse_reset_state_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_local_master_announcement_Type);
	PyModule_AddObject(m, "browse_local_master_announcement", (PyObject *)(void *)&nbt_browse_local_master_announcement_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_payload_Type);
	PyModule_AddObject(m, "browse_payload", (PyObject *)(void *)&nbt_browse_payload_Type);
	Py_INCREF((PyObject *)(void *)&nbt_browse_packet_Type);
	PyModule_AddObject(m, "browse_packet", (PyObject *)(void *)&nbt_browse_packet_Type);
	Py_INCREF((PyObject *)(void *)&nbt_InterfaceType);
	PyModule_AddObject(m, "nbt", (PyObject *)(void *)&nbt_InterfaceType);
	Py_INCREF((PyObject *)(void *)&nbt_SyntaxType);
	PyModule_AddObject(m, "nbt_abstract_syntax", (PyObject *)(void *)&nbt_SyntaxType);
	Py_INCREF((PyObject *)(void *)&nbt_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&nbt_SyntaxType);
#ifdef PY_MOD_NBT_PATCH
	PY_MOD_NBT_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_misc);
	Py_XDECREF(dep_samba_dcerpc_security);
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	return m;

}
