/* This is a generated file! */
/* Generated by `utils/build_lexers.py` via `utils/rustify.py` */
/* This process can be run via tox: `tox -e generate-rs` */
#![cfg_attr(rustfmt, rustfmt_skip)]
use once_cell::sync::Lazy;
use sqlfluffrs_types::LexMatcher;
use sqlfluffrs_types::{Token, RegexModeGroup};
use sqlfluffrs_types::token::CaseFold;

pub static EXASOL_KEYWORDS: Lazy<Vec<String>> = Lazy::new(|| { vec![
    "ABSOLUTE".to_string(),
    "ACTION".to_string(),
    "ADD".to_string(),
    "AFTER".to_string(),
    "ALL".to_string(),
    "ALLOCATE".to_string(),
    "ALTER".to_string(),
    "AND".to_string(),
    "ANY".to_string(),
    "APPEND".to_string(),
    "ARE".to_string(),
    "ARRAY".to_string(),
    "AS".to_string(),
    "ASC".to_string(),
    "ASENSITIVE".to_string(),
    "ASSERTION".to_string(),
    "AT".to_string(),
    "ATTRIBUTE".to_string(),
    "AUTHID".to_string(),
    "AUTHORIZATION".to_string(),
    "BEFORE".to_string(),
    "BEGIN".to_string(),
    "BETWEEN".to_string(),
    "BIGINT".to_string(),
    "BINARY".to_string(),
    "BIT".to_string(),
    "BLOB".to_string(),
    "BLOCKED".to_string(),
    "BOOL".to_string(),
    "BOOLEAN".to_string(),
    "BOTH".to_string(),
    "BY".to_string(),
    "BYTE".to_string(),
    "CALL".to_string(),
    "CALLED".to_string(),
    "CARDINALITY".to_string(),
    "CASCADE".to_string(),
    "CASCADED".to_string(),
    "CASE".to_string(),
    "CASESPECIFIC".to_string(),
    "CAST".to_string(),
    "CATALOG".to_string(),
    "CHAIN".to_string(),
    "CHAR".to_string(),
    "CHARACTER".to_string(),
    "CHARACTERISTICS".to_string(),
    "CHARACTER_SET_CATALOG".to_string(),
    "CHARACTER_SET_NAME".to_string(),
    "CHARACTER_SET_SCHEMA".to_string(),
    "CHECK".to_string(),
    "CHECKED".to_string(),
    "CLOB".to_string(),
    "CLOSE".to_string(),
    "COALESCE".to_string(),
    "COLLATE".to_string(),
    "COLLATION".to_string(),
    "COLLATION_CATALOG".to_string(),
    "COLLATION_NAME".to_string(),
    "COLLATION_SCHEMA".to_string(),
    "COLUMN".to_string(),
    "COMMIT".to_string(),
    "CONDITION".to_string(),
    "CONNECTION".to_string(),
    "CONNECT_BY_ISCYCLE".to_string(),
    "CONNECT_BY_ISLEAF".to_string(),
    "CONNECT_BY_ROOT".to_string(),
    "CONSTANT".to_string(),
    "CONSTRAINT".to_string(),
    "CONSTRAINTS".to_string(),
    "CONSTRAINT_STATE_DEFAULT".to_string(),
    "CONSTRUCTOR".to_string(),
    "CONTAINS".to_string(),
    "CONTINUE".to_string(),
    "CONTROL".to_string(),
    "CONVERT".to_string(),
    "CORRESPONDING".to_string(),
    "CREATE".to_string(),
    "CROSS".to_string(),
    "CS".to_string(),
    "CSV".to_string(),
    "CUBE".to_string(),
    "CURRENT".to_string(),
    "CURRENT_DATE".to_string(),
    "CURRENT_PATH".to_string(),
    "CURRENT_ROLE".to_string(),
    "CURRENT_SCHEMA".to_string(),
    "CURRENT_SESSION".to_string(),
    "CURRENT_STATEMENT".to_string(),
    "CURRENT_TIME".to_string(),
    "CURRENT_TIMESTAMP".to_string(),
    "CURRENT_USER".to_string(),
    "CURSOR".to_string(),
    "CYCLE".to_string(),
    "DATA".to_string(),
    "DATALINK".to_string(),
    "DATE".to_string(),
    "DATETIME_INTERVAL_CODE".to_string(),
    "DATETIME_INTERVAL_PRECISION".to_string(),
    "DAY".to_string(),
    "DBTIMEZONE".to_string(),
    "DEALLOCATE".to_string(),
    "DEC".to_string(),
    "DECIMAL".to_string(),
    "DECLARE".to_string(),
    "DEFAULT".to_string(),
    "DEFAULT_LIKE_ESCAPE_CHARACTER".to_string(),
    "DEFERRABLE".to_string(),
    "DEFERRED".to_string(),
    "DEFINED".to_string(),
    "DEFINER".to_string(),
    "DELETE".to_string(),
    "DEREF".to_string(),
    "DERIVED".to_string(),
    "DESC".to_string(),
    "DESCRIBE".to_string(),
    "DESCRIPTOR".to_string(),
    "DETERMINISTIC".to_string(),
    "DISABLE".to_string(),
    "DISABLED".to_string(),
    "DISCONNECT".to_string(),
    "DISPATCH".to_string(),
    "DISTINCT".to_string(),
    "DLURLCOMPLETE".to_string(),
    "DLURLPATH".to_string(),
    "DLURLPATHONLY".to_string(),
    "DLURLSCHEME".to_string(),
    "DLURLSERVER".to_string(),
    "DLVALUE".to_string(),
    "DO".to_string(),
    "DOMAIN".to_string(),
    "DOUBLE".to_string(),
    "DROP".to_string(),
    "DYNAMIC".to_string(),
    "DYNAMIC_FUNCTION".to_string(),
    "DYNAMIC_FUNCTION_CODE".to_string(),
    "EACH".to_string(),
    "ELSE".to_string(),
    "ELSEIF".to_string(),
    "ELSIF".to_string(),
    "EMITS".to_string(),
    "ENABLE".to_string(),
    "ENABLED".to_string(),
    "END".to_string(),
    "END-EXEC".to_string(),
    "ENDIF".to_string(),
    "ENFORCE".to_string(),
    "EQUALS".to_string(),
    "ERRORS".to_string(),
    "ESCAPE".to_string(),
    "EXCEPT".to_string(),
    "EXCEPTION".to_string(),
    "EXEC".to_string(),
    "EXECUTE".to_string(),
    "EXISTS".to_string(),
    "EXIT".to_string(),
    "EXPORT".to_string(),
    "EXTERNAL".to_string(),
    "EXTRACT".to_string(),
    "FALSE".to_string(),
    "FBV".to_string(),
    "FETCH".to_string(),
    "FILE".to_string(),
    "FINAL".to_string(),
    "FIRST".to_string(),
    "FLOAT".to_string(),
    "FOLLOWING".to_string(),
    "FOR".to_string(),
    "FORALL".to_string(),
    "FORCE".to_string(),
    "FORMAT".to_string(),
    "FOUND".to_string(),
    "FREE".to_string(),
    "FROM".to_string(),
    "FS".to_string(),
    "FULL".to_string(),
    "FUNCTION".to_string(),
    "GENERAL".to_string(),
    "GENERATED".to_string(),
    "GEOMETRY".to_string(),
    "GET".to_string(),
    "GLOBAL".to_string(),
    "GO".to_string(),
    "GOTO".to_string(),
    "GRANT".to_string(),
    "GRANTED".to_string(),
    "GROUP".to_string(),
    "GROUPING".to_string(),
    "GROUPS".to_string(),
    "GROUP_CONCAT".to_string(),
    "HASHTYPE".to_string(),
    "HASHTYPE_FORMAT".to_string(),
    "HAVING".to_string(),
    "HIGH".to_string(),
    "HOLD".to_string(),
    "HOUR".to_string(),
    "IDENTITY".to_string(),
    "IF".to_string(),
    "IFNULL".to_string(),
    "IMMEDIATE".to_string(),
    "IMPERSONATE".to_string(),
    "IMPLEMENTATION".to_string(),
    "IMPORT".to_string(),
    "IN".to_string(),
    "INDEX".to_string(),
    "INDICATOR".to_string(),
    "INNER".to_string(),
    "INOUT".to_string(),
    "INPUT".to_string(),
    "INSENSITIVE".to_string(),
    "INSERT".to_string(),
    "INSTANCE".to_string(),
    "INSTANTIABLE".to_string(),
    "INT".to_string(),
    "INTEGER".to_string(),
    "INTEGRITY".to_string(),
    "INTERSECT".to_string(),
    "INTERVAL".to_string(),
    "INTO".to_string(),
    "INVERSE".to_string(),
    "INVOKER".to_string(),
    "IS".to_string(),
    "ITERATE".to_string(),
    "JOIN".to_string(),
    "KEY_MEMBER".to_string(),
    "KEY_TYPE".to_string(),
    "LARGE".to_string(),
    "LAST".to_string(),
    "LATERAL".to_string(),
    "LDAP".to_string(),
    "LEADING".to_string(),
    "LEAVE".to_string(),
    "LEFT".to_string(),
    "LEVEL".to_string(),
    "LIKE".to_string(),
    "LIMIT".to_string(),
    "LISTAGG".to_string(),
    "LOCAL".to_string(),
    "LOCALTIME".to_string(),
    "LOCALTIMESTAMP".to_string(),
    "LOCATOR".to_string(),
    "LOG".to_string(),
    "LONGVARCHAR".to_string(),
    "LOOP".to_string(),
    "LOW".to_string(),
    "MAP".to_string(),
    "MATCH".to_string(),
    "MATCHED".to_string(),
    "MERGE".to_string(),
    "METHOD".to_string(),
    "MINUS".to_string(),
    "MINUTE".to_string(),
    "MOD".to_string(),
    "MODIFIES".to_string(),
    "MODIFY".to_string(),
    "MODULE".to_string(),
    "MONTH".to_string(),
    "NAMES".to_string(),
    "NATIONAL".to_string(),
    "NATURAL".to_string(),
    "NCHAR".to_string(),
    "NCLOB".to_string(),
    "NEW".to_string(),
    "NEXT".to_string(),
    "NLS_DATE_FORMAT".to_string(),
    "NLS_DATE_LANGUAGE".to_string(),
    "NLS_FIRST_DAY_OF_WEEK".to_string(),
    "NLS_NUMERIC_CHARACTERS".to_string(),
    "NLS_TIMESTAMP_FORMAT".to_string(),
    "NO".to_string(),
    "NOCYCLE".to_string(),
    "NOLOGGING".to_string(),
    "NONE".to_string(),
    "NOT".to_string(),
    "NULL".to_string(),
    "NULLIF".to_string(),
    "NUMBER".to_string(),
    "NUMERIC".to_string(),
    "NVARCHAR".to_string(),
    "NVARCHAR2".to_string(),
    "OBJECT".to_string(),
    "OF".to_string(),
    "OFF".to_string(),
    "OLD".to_string(),
    "ON".to_string(),
    "ONLY".to_string(),
    "OPEN".to_string(),
    "OPTION".to_string(),
    "OPTIONS".to_string(),
    "OR".to_string(),
    "ORDER".to_string(),
    "ORDERING".to_string(),
    "ORDINALITY".to_string(),
    "OTHERS".to_string(),
    "OUT".to_string(),
    "OUTER".to_string(),
    "OUTPUT".to_string(),
    "OVER".to_string(),
    "OVERLAPS".to_string(),
    "OVERLAY".to_string(),
    "OVERRIDING".to_string(),
    "PAD".to_string(),
    "PARALLEL_ENABLE".to_string(),
    "PARAMETER".to_string(),
    "PARAMETER_SPECIFIC_CATALOG".to_string(),
    "PARAMETER_SPECIFIC_NAME".to_string(),
    "PARAMETER_SPECIFIC_SCHEMA".to_string(),
    "PARTIAL".to_string(),
    "PARTITION".to_string(),
    "PATH".to_string(),
    "PERMISSION".to_string(),
    "PLACING".to_string(),
    "PLUS".to_string(),
    "POSITION".to_string(),
    "PRECEDING".to_string(),
    "PREFERRING".to_string(),
    "PREPARE".to_string(),
    "PRESERVE".to_string(),
    "PRIOR".to_string(),
    "PRIVILEGES".to_string(),
    "PROCEDURE".to_string(),
    "PROFILE".to_string(),
    "QUALIFY".to_string(),
    "RANDOM".to_string(),
    "RANGE".to_string(),
    "READ".to_string(),
    "READS".to_string(),
    "REAL".to_string(),
    "RECOVERY".to_string(),
    "RECURSIVE".to_string(),
    "REF".to_string(),
    "REFERENCES".to_string(),
    "REFERENCING".to_string(),
    "REFRESH".to_string(),
    "REGEXP_LIKE".to_string(),
    "RELATIVE".to_string(),
    "RELEASE".to_string(),
    "RENAME".to_string(),
    "REPEAT".to_string(),
    "REPLACE".to_string(),
    "RESTORE".to_string(),
    "RESTRICT".to_string(),
    "RESULT".to_string(),
    "RETURN".to_string(),
    "RETURNED_LENGTH".to_string(),
    "RETURNED_OCTET_LENGTH".to_string(),
    "RETURNS".to_string(),
    "REVOKE".to_string(),
    "RIGHT".to_string(),
    "ROLLBACK".to_string(),
    "ROLLUP".to_string(),
    "ROUTINE".to_string(),
    "ROW".to_string(),
    "ROWS".to_string(),
    "ROWTYPE".to_string(),
    "SAVEPOINT".to_string(),
    "SCHEMA".to_string(),
    "SCOPE".to_string(),
    "SCOPE_USER".to_string(),
    "SCRIPT".to_string(),
    "SCROLL".to_string(),
    "SEARCH".to_string(),
    "SECOND".to_string(),
    "SECTION".to_string(),
    "SECURITY".to_string(),
    "SELECT".to_string(),
    "SELECTIVE".to_string(),
    "SELF".to_string(),
    "SENSITIVE".to_string(),
    "SEPARATOR".to_string(),
    "SEQUENCE".to_string(),
    "SESSION".to_string(),
    "SESSIONTIMEZONE".to_string(),
    "SESSION_USER".to_string(),
    "SET".to_string(),
    "SETS".to_string(),
    "SHORTINT".to_string(),
    "SIMILAR".to_string(),
    "SMALLINT".to_string(),
    "SOME".to_string(),
    "SOURCE".to_string(),
    "SPACE".to_string(),
    "SPECIFIC".to_string(),
    "SPECIFICTYPE".to_string(),
    "SQL".to_string(),
    "SQLEXCEPTION".to_string(),
    "SQLSTATE".to_string(),
    "SQLWARNING".to_string(),
    "SQL_BIGINT".to_string(),
    "SQL_BIT".to_string(),
    "SQL_CHAR".to_string(),
    "SQL_DATE".to_string(),
    "SQL_DECIMAL".to_string(),
    "SQL_DOUBLE".to_string(),
    "SQL_FLOAT".to_string(),
    "SQL_INTEGER".to_string(),
    "SQL_LONGVARCHAR".to_string(),
    "SQL_NUMERIC".to_string(),
    "SQL_PREPROCESSOR_SCRIPT".to_string(),
    "SQL_REAL".to_string(),
    "SQL_SMALLINT".to_string(),
    "SQL_TIMESTAMP".to_string(),
    "SQL_TINYINT".to_string(),
    "SQL_TYPE_DATE".to_string(),
    "SQL_TYPE_TIMESTAMP".to_string(),
    "SQL_VARCHAR".to_string(),
    "START".to_string(),
    "STATE".to_string(),
    "STATEMENT".to_string(),
    "STATIC".to_string(),
    "STRUCTURE".to_string(),
    "STYLE".to_string(),
    "SUBSTRING".to_string(),
    "SUBTYPE".to_string(),
    "SYSDATE".to_string(),
    "SYSTEM".to_string(),
    "SYSTEM_USER".to_string(),
    "SYSTIMESTAMP".to_string(),
    "TABLE".to_string(),
    "TEMPORARY".to_string(),
    "TEXT".to_string(),
    "THEN".to_string(),
    "TIME".to_string(),
    "TIMESTAMP".to_string(),
    "TIMEZONE_HOUR".to_string(),
    "TIMEZONE_MINUTE".to_string(),
    "TINYINT".to_string(),
    "TO".to_string(),
    "TRAILING".to_string(),
    "TRANSACTION".to_string(),
    "TRANSFORM".to_string(),
    "TRANSFORMS".to_string(),
    "TRANSLATION".to_string(),
    "TREAT".to_string(),
    "TRIGGER".to_string(),
    "TRIM".to_string(),
    "TRUE".to_string(),
    "TRUNCATE".to_string(),
    "UNDER".to_string(),
    "UNION".to_string(),
    "UNIQUE".to_string(),
    "UNKNOWN".to_string(),
    "UNLINK".to_string(),
    "UNNEST".to_string(),
    "UNTIL".to_string(),
    "UPDATE".to_string(),
    "USAGE".to_string(),
    "USER".to_string(),
    "USING".to_string(),
    "VALUE".to_string(),
    "VALUES".to_string(),
    "VARCHAR".to_string(),
    "VARCHAR2".to_string(),
    "VARRAY".to_string(),
    "VERIFY".to_string(),
    "VIEW".to_string(),
    "WHEN".to_string(),
    "WHENEVER".to_string(),
    "WHERE".to_string(),
    "WHILE".to_string(),
    "WINDOW".to_string(),
    "WITH".to_string(),
    "WITHIN".to_string(),
    "WITHOUT".to_string(),
    "WORK".to_string(),
    "YEAR".to_string(),
    "YES".to_string(),
    "ZONE".to_string(),
]});

pub static EXASOL_LEXERS: Lazy<Vec<LexMatcher>> = Lazy::new(|| { vec![

    LexMatcher::regex_lexer(
        "whitespace",
        r#"[^\S\r\n]+"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::whitespace_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "inline_comment",
        r#"--[^\n]*"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comment_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        Some(vec![String::from("-"), String::from("-")]),
        None,
        None,
        None,
        CaseFold::None,
        None,
        |input| input.starts_with(['#','-','/']),
        None,
    ),

    LexMatcher::regex_lexer(
        "block_comment",
        r#"\/\*([^\*]|\*(?!\/))*\*\/"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comment_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        Some(Box::new(
    LexMatcher::regex_subdivider(
        "newline",
        r#"\r\n|\n"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::newline_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ))),
        Some(Box::new(
    LexMatcher::regex_subdivider(
        "whitespace",
        r#"[^\S\r\n]+"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::whitespace_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ))),
        None,
        None,
        None,
        None,
        CaseFold::None,
        Some(extract_nested_block_comment),
        |input| input.starts_with("/"),
        None,
    ),

    LexMatcher::regex_lexer(
        "single_quote",
        r#"'([^']|'')*'"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        Some((r#"'((?:[^']|'')*)'"#.to_string(), RegexModeGroup::Index(1))),
        Some((r#"''"#.to_string(), r#"'"#.to_string())),
        CaseFold::None,
        None,
        |input| match input.as_bytes() {
        [b'\'', ..] => true,                     // Single quote case
        [b'R' | b'r', b'\'', ..] => true,        // r' or R'
        [b'B' | b'b', b'\'', ..] => true,        // b' or B'
        [b'R' | b'r', b'B' | b'b', b'\'', ..] => true, // rb', RB', etc.
        [b'B' | b'b', b'R' | b'r', b'\'', ..] => true, // br', Br', etc.
        _ => false,
    },
        None,
    ),

    LexMatcher::regex_lexer(
        "double_quote",
        r#""([^"]|"")*""#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        Some((r#""((?:[^"]|"")*)""#.to_string(), RegexModeGroup::Index(1))),
        Some((r#""""#.to_string(), r#"""#.to_string())),
        CaseFold::None,
        None,
        |input| match input.as_bytes() {
        [b'"', ..] => true,                     // Just a double quote
        [b'R' | b'r', b'"', ..] => true,        // r" or R"
        [b'B' | b'b', b'"', ..] => true,        // b" or B"
        [b'R' | b'r', b'B' | b'b', b'"', ..] => true, // rb", RB", etc.
        [b'B' | b'b', b'R' | b'r', b'"', ..] => true, // br", Br", etc.
        _ => false,
    },
        None,
    ),

    LexMatcher::regex_lexer(
        "back_quote",
        r#"`(?:[^`\\]|\\.)*`"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        Some((r#"`((?:[^`\\]|\\.)*)`"#.to_string(), RegexModeGroup::Index(1))),
        Some((r#"\\`"#.to_string(), r#"`"#.to_string())),
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "dollar_quote",
        r#"\$(\w*)\$(.*?)\$\1\$"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        Some((r#"\$(\w*)\$(.*?)\$\1\$"#.to_string(), RegexModeGroup::Index(2))),
        None,
        CaseFold::None,
        None,
        |input| input.starts_with("$"),
        None,
    ),

    LexMatcher::regex_lexer(
        "numeric_literal",
        r#"(?>\d+\.\d+|\d+\.(?![\.\w])|\.\d+|\d+)(\.?[eE][+-]?\d+)?((?<=\.)|(?=\b))"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::literal_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |input| input.starts_with(['x','X','.','0','1','2','3','4','5','6','7','8','9']),
        None,
    ),

    LexMatcher::regex_lexer(
        "obevo_annotation",
        r#"////\s*(CHANGE|BODY|METADATA)[^\n]*"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comment_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::string_lexer(
        "glob_operator",
        "~~~",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comparison_operator_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::regex_lexer(
        "lua_nested_quotes",
        r#"\[={1,3}\[.*\]={1,3}\]"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "lua_multiline_quotes",
        r#"\[{2}([^\[\\]|\\.)*\]{2}"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "escaped_identifier",
        r#"\[\w+\]"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        Some((r#"\[(\w+)\]"#.to_string(), RegexModeGroup::Index(1))),
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "udf_param_dot_syntax",
        r#"\.{3}"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "range_operator",
        r#"\.{2}"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::symbol_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::string_lexer(
        "hash",
        "#",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "walrus_operator",
        ":=",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::regex_lexer(
        "function_script_terminator",
        r#"\n/\n|\n/$"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::symbol_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        Some(Box::new(
    LexMatcher::regex_subdivider(
        "newline",
        r#"(\n|\r\n)+"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::newline_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ))),
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "at_sign_literal",
        r#"@[a-zA-Z_][\w]*"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "dollar_literal",
        r#"[$][a-zA-Z0-9_.]*"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "like_operator",
        r#"!?~~?\*?"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comparison_operator_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "newline",
        r#"\r\n|\n"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::newline_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::string_lexer(
        "casting_operator",
        "::",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "equals",
        "=",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "greater_than",
        ">",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "less_than",
        "<",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "not",
        "!",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "dot",
        ".",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "comma",
        ",",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "plus",
        "+",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "minus",
        "-",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "divide",
        "/",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "percent",
        "%",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "question",
        "?",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "ampersand",
        "&",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "vertical_bar",
        "|",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "caret",
        "^",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "star",
        "*",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "start_bracket",
        "(",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "end_bracket",
        ")",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "start_square_bracket",
        "[",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "end_square_bracket",
        "]",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "start_curly_bracket",
        "{",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "end_curly_bracket",
        "}",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "colon",
        ":",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "semicolon",
        ";",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::regex_lexer(
        "word",
        r#"[0-9a-zA-Z_]+"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::word_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),
]});


// Wrapper function that passes the dialect name to the shared implementation
fn extract_nested_block_comment(input: &str) -> Option<&str> {
    crate::extract_nested_block_comment(input, "exasol")
}
