/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

// RuntimeClassSpecApplyConfiguration represents a declarative configuration of the RuntimeClassSpec type for use
// with apply.
//
// RuntimeClassSpec is a specification of a RuntimeClass. It contains parameters
// that are required to describe the RuntimeClass to the Container Runtime
// Interface (CRI) implementation, as well as any other components that need to
// understand how the pod will be run. The RuntimeClassSpec is immutable.
type RuntimeClassSpecApplyConfiguration struct {
	// runtimeHandler specifies the underlying runtime and configuration that the
	// CRI implementation will use to handle pods of this class. The possible
	// values are specific to the node & CRI configuration.  It is assumed that
	// all handlers are available on every node, and handlers of the same name are
	// equivalent on every node.
	// For example, a handler called "runc" might specify that the runc OCI
	// runtime (using native Linux containers) will be used to run the containers
	// in a pod.
	// The runtimeHandler must be lowercase, conform to the DNS Label (RFC 1123)
	// requirements, and is immutable.
	RuntimeHandler *string `json:"runtimeHandler,omitempty"`
	// overhead represents the resource overhead associated with running a pod for a
	// given RuntimeClass. For more details, see
	// https://git.k8s.io/enhancements/keps/sig-node/688-pod-overhead/README.md
	Overhead *OverheadApplyConfiguration `json:"overhead,omitempty"`
	// scheduling holds the scheduling constraints to ensure that pods running
	// with this RuntimeClass are scheduled to nodes that support it.
	// If scheduling is nil, this RuntimeClass is assumed to be supported by all
	// nodes.
	Scheduling *SchedulingApplyConfiguration `json:"scheduling,omitempty"`
}

// RuntimeClassSpecApplyConfiguration constructs a declarative configuration of the RuntimeClassSpec type for use with
// apply.
func RuntimeClassSpec() *RuntimeClassSpecApplyConfiguration {
	return &RuntimeClassSpecApplyConfiguration{}
}

// WithRuntimeHandler sets the RuntimeHandler field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RuntimeHandler field is set to the value of the last call.
func (b *RuntimeClassSpecApplyConfiguration) WithRuntimeHandler(value string) *RuntimeClassSpecApplyConfiguration {
	b.RuntimeHandler = &value
	return b
}

// WithOverhead sets the Overhead field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Overhead field is set to the value of the last call.
func (b *RuntimeClassSpecApplyConfiguration) WithOverhead(value *OverheadApplyConfiguration) *RuntimeClassSpecApplyConfiguration {
	b.Overhead = value
	return b
}

// WithScheduling sets the Scheduling field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Scheduling field is set to the value of the last call.
func (b *RuntimeClassSpecApplyConfiguration) WithScheduling(value *SchedulingApplyConfiguration) *RuntimeClassSpecApplyConfiguration {
	b.Scheduling = value
	return b
}
