// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanCommMailComponentsComposeMetrics_h
#define mozilla_GleanCommMailComponentsComposeMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace compose {
  /**
   * generated from compose.compose_format
   */
  enum class ComposeFormatLabel: uint16_t {
    eHtml = 0,
    ePlaintext = 1,
    e__Other__,
  };
  /**
   * How many times messages were written in HTML composition mode, vs. how many were written in plain text composition mode. Label names are from nsIMsgCompFormat.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ComposeFormatLabel> compose_format(1101);

  /**
   * generated from compose.compose_type
   */
  enum class ComposeTypeLabel: uint16_t {
    eNew = 0,
    eReply = 1,
    eReplyall = 2,
    eForwardasattachment = 3,
    eForwardinline = 4,
    eNewspost = 5,
    eReplytosender = 6,
    eReplytogroup = 7,
    eReplytosendergroup = 8,
    eDraft = 9,
    eTemplate = 10,
    eMailtourl = 11,
    eReplywithtemplate = 12,
    eReplytolist = 13,
    eRedirect = 14,
    eEditasnew = 15,
    eEdittemplate = 16,
    e__Other__,
  };
  /**
   * How many times each message compose type was used when creating a message.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ComposeTypeLabel> compose_type(1102);

  /**
   * generated from compose.mails_sent
   * How many emails were sent by the user.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mails_sent(1103);
}

} // namespace mozilla::glean

#endif // mozilla_GleanCommMailComponentsComposeMetrics_h
