/* THIS FILE IS AUTOGENERATED FROM HTMLFormControlsCollection.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "HTMLCollectionBinding.h"
#include "HTMLFormControlsCollectionBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DOMJSProxyHandler.h"
#include "mozilla/dom/Element.h"
#include "mozilla/dom/HTMLFormControlsCollection.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/ProxyHandlerUtils.h"
#include "mozilla/dom/RadioNodeList.h"
#include "mozilla/dom/XrayExpandoClass.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningRadioNodeListOrElement& aUnion, const char* aName, uint32_t aFlags)
{
  if (aUnion.IsRadioNodeList()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsRadioNodeList(), "mRadioNodeList", aFlags);
  } else if (aUnion.IsElement()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsElement(), "mElement", aFlags);
  }
}


void
ImplCycleCollectionUnlink(OwningRadioNodeListOrElement& aUnion)
{
  aUnion.Uninit();
}


bool
RadioNodeListOrElement::TrySetToRadioNodeList(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::RadioNodeList>& memberSlot = RawSetAsRadioNodeList();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::RadioNodeList, mozilla::dom::RadioNodeList>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyRadioNodeList();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
RadioNodeListOrElement::TrySetToRadioNodeList(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToRadioNodeList(cx, value, tryNext, passedToJSImpl);
}







bool
RadioNodeListOrElement::TrySetToElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::Element>& memberSlot = RawSetAsElement();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyElement();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
RadioNodeListOrElement::TrySetToElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToElement(cx, value, tryNext, passedToJSImpl);
}







bool
RadioNodeListOrElement::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToRadioNodeList(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToElement(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "RadioNodeList, Element");
    return false;
  }
  return true;
}

bool
RadioNodeListOrElement::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
RadioNodeListOrElement::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eRadioNodeList: {
      if (!GetOrCreateDOMReflector(cx, mValue.mRadioNodeList.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eElement: {
      if (!GetOrCreateDOMReflector(cx, mValue.mElement.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningRadioNodeListOrElement::OwningRadioNodeListOrElement(OwningRadioNodeListOrElement&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eRadioNodeList: {
      mType = eRadioNodeList;
      mValue.mRadioNodeList.SetValue(std::move(aOther.mValue.mRadioNodeList.Value()));
      break;
    }
    case eElement: {
      mType = eElement;
      mValue.mElement.SetValue(std::move(aOther.mValue.mElement.Value()));
      break;
    }
  }
}



bool
OwningRadioNodeListOrElement::TrySetToRadioNodeList(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::RadioNodeList>& memberSlot = RawSetAsRadioNodeList();
    static_assert(IsRefcounted<mozilla::dom::RadioNodeList>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::RadioNodeList, mozilla::dom::RadioNodeList>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyRadioNodeList();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningRadioNodeListOrElement::TrySetToRadioNodeList(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToRadioNodeList(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::RadioNodeList>&
OwningRadioNodeListOrElement::RawSetAsRadioNodeList()
{
  if (mType == eRadioNodeList) {
    return mValue.mRadioNodeList.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eRadioNodeList;
  return mValue.mRadioNodeList.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::RadioNodeList>&
OwningRadioNodeListOrElement::SetAsRadioNodeList()
{
  if (mType == eRadioNodeList) {
    return mValue.mRadioNodeList.Value();
  }
  Uninit();
  mType = eRadioNodeList;
  return mValue.mRadioNodeList.SetValue();
}


void
OwningRadioNodeListOrElement::DestroyRadioNodeList()
{
  MOZ_RELEASE_ASSERT(IsRadioNodeList(), "Wrong type!");
  mValue.mRadioNodeList.Destroy();
  mType = eUninitialized;
}



bool
OwningRadioNodeListOrElement::TrySetToElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::Element>& memberSlot = RawSetAsElement();
    static_assert(IsRefcounted<mozilla::dom::Element>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Element, mozilla::dom::Element>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyElement();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningRadioNodeListOrElement::TrySetToElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToElement(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::Element>&
OwningRadioNodeListOrElement::RawSetAsElement()
{
  if (mType == eElement) {
    return mValue.mElement.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eElement;
  return mValue.mElement.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::Element>&
OwningRadioNodeListOrElement::SetAsElement()
{
  if (mType == eElement) {
    return mValue.mElement.Value();
  }
  Uninit();
  mType = eElement;
  return mValue.mElement.SetValue();
}


void
OwningRadioNodeListOrElement::DestroyElement()
{
  MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
  mValue.mElement.Destroy();
  mType = eUninitialized;
}



bool
OwningRadioNodeListOrElement::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToRadioNodeList(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToElement(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "RadioNodeList, Element");
    return false;
  }
  return true;
}

bool
OwningRadioNodeListOrElement::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningRadioNodeListOrElement::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eRadioNodeList: {
      DestroyRadioNodeList();
      break;
    }
    case eElement: {
      DestroyElement();
      break;
    }
  }
}

bool
OwningRadioNodeListOrElement::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eRadioNodeList: {
      if (!GetOrCreateDOMReflector(cx, mValue.mRadioNodeList.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eElement: {
      if (!GetOrCreateDOMReflector(cx, mValue.mElement.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningRadioNodeListOrElement&
OwningRadioNodeListOrElement::operator=(OwningRadioNodeListOrElement&& aOther)
{
  this->~OwningRadioNodeListOrElement();
  new (this) OwningRadioNodeListOrElement (std::move(aOther));
  return *this;
}


OwningRadioNodeListOrElement&
OwningRadioNodeListOrElement::operator=(const OwningRadioNodeListOrElement& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eRadioNodeList: {
      SetAsRadioNodeList() = aOther.GetAsRadioNodeList();
      break;
    }
    case eElement: {
      SetAsElement() = aOther.GetAsElement();
      break;
    }
  }
  return *this;
}


namespace HTMLFormControlsCollection_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<HTMLCollection_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
namedItem(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormControlsCollection", "namedItem", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormControlsCollection*>(void_self);
  if (!args.requireAtLeast(cx, "HTMLFormControlsCollection.namedItem", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Nullable<OwningRadioNodeListOrElement> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NamedItem(NonNullHelper(Constify(arg0)), result))>, "Should be returning void here");
  MOZ_KnownLive(self)->NamedItem(NonNullHelper(Constify(arg0)), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!result.Value().ToJSVal(cx, obj, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo namedItem_methodinfo = {
  { (JSJitGetterOp)namedItem },
  { prototypes::id::HTMLFormControlsCollection },
  { PrototypeTraits<prototypes::id::HTMLFormControlsCollection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("namedItem", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&namedItem_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_SYM_FNSPEC(iterator, nullptr, nullptr, 0, 0, "$ArrayValues"),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(2 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[2];
static PropertyInfo sNativeProperties_propertyInfos[2];

static const NativePropertiesN<1> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  2,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(2 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static_assert(std::is_base_of_v<nsISupports, mozilla::dom::HTMLFormControlsCollection>,
              "We don't support non-nsISupports native classes for "
              "proxy-based bindings yet");


class DOMProxyHandler : public mozilla::dom::DOMProxyHandler
{
public:
  using Base = mozilla::dom::DOMProxyHandler;

  explicit constexpr DOMProxyHandler()
  {
  }

  bool
  getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const override;

  bool
  defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const override;

  using mozilla::dom::DOMProxyHandler::defineProperty;

  bool
  ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const override;

  bool
  hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const override;

  bool
  get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const override;

  const char*
  className(JSContext* cx, JS::Handle<JSObject*> proxy) const override;

  bool
  finalizeInBackground(const JS::Value& priv) const override;

  void
  finalize(JS::GCContext* gcx, JSObject* proxy) const override;

  static const DOMProxyHandler*
  getInstance();

  bool
  delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const override;

  bool
  getElements(JSContext* cx, JS::Handle<JSObject*> proxy, uint32_t begin, uint32_t end, js::ElementAdder* adder) const override;

  size_t
  objectMoved(JSObject* obj, JSObject* old) const override;
};

MOZ_ALWAYS_INLINE bool
IsProxy(JSObject* obj)
{
  return js::IsProxy(obj) && js::GetProxyHandler(obj) == DOMProxyHandler::getInstance();
}

MOZ_ALWAYS_INLINE mozilla::dom::HTMLFormControlsCollection*
UnwrapProxy(JSObject* obj)
{
  MOZ_ASSERT(js::IsProxy(obj));
  if (js::GetProxyHandler(obj) != DOMProxyHandler::getInstance()) {
    MOZ_ASSERT(xpc::WrapperFactory::IsXrayWrapper(obj));
    obj = js::UncheckedUnwrap(obj);
  }
  MOZ_ASSERT(IsProxy(obj));
  return static_cast<mozilla::dom::HTMLFormControlsCollection*>(js::GetProxyReservedSlot(obj, DOM_OBJECT_SLOT).toPrivate());
}

const NativeNamedOrIndexedPropertyHooks sNativeNamedOrIndexedPropertyHooks = {
  binding_detail::ResolveOwnProperty,
  binding_detail::EnumerateOwnProperties,
  nullptr
};
bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  &sNativeNamedOrIndexedPropertyHooks,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::HTMLFormControlsCollection,
  constructors::id::HTMLFormControlsCollection,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  HTMLCollection_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::HTMLFormControlsCollection>::Depth,
  prototypes::id::HTMLFormControlsCollection,
  true,
  0,
  "HTMLFormControlsCollection",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "HTMLFormControlsCollectionPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::HTMLFormControlsCollection,
  PrototypeTraits<prototypes::id::HTMLFormControlsCollection>::Depth,
  &sNativePropertyHooks,
  HTMLCollection_Binding::GetProtoObject
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

bool
DOMProxyHandler::getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);
  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    JS::Rooted<JS::Value> value(cx);
    mozilla::dom::HTMLFormControlsCollection* self = UnwrapProxy(proxy);
    bool found = false;
    auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->IndexedGetter(index, found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    if (found) {
      if (!result) {
        value.setNull();
        desc.set(mozilla::Some(JS::PropertyDescriptor::Data(value, { JS::PropertyAttribute::Configurable, JS::PropertyAttribute::Enumerable })));
        return true;
      }
      if (!GetOrCreateDOMReflector(cx, result, &value)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      desc.set(mozilla::Some(JS::PropertyDescriptor::Data(value, { JS::PropertyAttribute::Configurable, JS::PropertyAttribute::Enumerable })));
      return true;
    }
  }

  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = GetExpandoObject(proxy))) {
    if (!JS_GetOwnPropertyDescriptorById(cx, expando, id, desc)) {
      return false;
    }
    if (desc.isSome()) {
      return true;
    }
  }

  bool callNamedGetter = false;
  if (!IsArrayIndex(index) && !ignoreNamedProps) {
    bool hasOnProto;
    if (!HasPropertyOnPrototype(cx, proxy, id, &hasOnProto)) {
      return false;
    }
    callNamedGetter = !hasOnProto;
  }
  if (callNamedGetter) {
    JS::Rooted<JS::Value> value(cx);
    FakeString<char16_t> name;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, name, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::dom::HTMLFormControlsCollection* self = UnwrapProxy(proxy);
      bool found = false;
      Nullable<OwningRadioNodeListOrElement> result;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found, result))>, "Should be returning void here");
      MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found, result);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));

      if (found) {
        if (result.IsNull()) {
          value.setNull();
          desc.set(mozilla::Some(JS::PropertyDescriptor::Data(value, { JS::PropertyAttribute::Configurable })));
          return true;
        }
        if (!result.Value().ToJSVal(cx, proxy, &value)) {
          return false;
        }
        desc.set(mozilla::Some(JS::PropertyDescriptor::Data(value, { JS::PropertyAttribute::Configurable })));
        return true;
      }
    }
  }

  desc.reset();
  return true;
}

bool
DOMProxyHandler::defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const
{
  if (IsArrayIndex(GetArrayIndexFromId(id))) {
    *done = true;
    return opresult.failNoIndexedSetter();
  }
  JSContext* cx = cx_;
  bool found = false;
  FakeString<char16_t> name;
  bool isSymbol;
  if (!ConvertIdToString(cx, id, name, isSymbol)) {
    return false;
  }
  if (!isSymbol) {
    mozilla::dom::HTMLFormControlsCollection* self = UnwrapProxy(proxy);
    Nullable<OwningRadioNodeListOrElement> result;
    // NOTE: This assert does NOT call the function.
    static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found, result))>, "Should be returning void here");
    MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found, result);
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;
  }

  if (found) {
    *done = true;
    return opresult.failNoNamedSetter();
  }
  return mozilla::dom::DOMProxyHandler::defineProperty(cx_, proxy, id, desc, opresult, done);
}


bool
DOMProxyHandler::ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);

  uint32_t length = UnwrapProxy(proxy)->Length();
  MOZ_ASSERT(int32_t(length) >= 0);
  for (int32_t i = 0; i < int32_t(length); ++i) {
    if (!props.append(JS::PropertyKey::Int(i))) {
      return false;
    }
  }

  if (flags & JSITER_HIDDEN) {
    nsTArray<nsString> names;
    UnwrapProxy(proxy)->GetSupportedNames(names);
    if (!AppendNamedPropertyIds(cx, proxy, names, false, props)) {
      return false;
    }
  }

  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = DOMProxyHandler::GetExpandoObject(proxy)) &&
      !js::GetPropertyKeys(cx, expando, flags, props)) {
    return false;
  }

  return true;
}

bool
DOMProxyHandler::hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");
  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    bool found = false;
    mozilla::dom::HTMLFormControlsCollection* self = UnwrapProxy(proxy);
    auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->IndexedGetter(index, found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;

    *bp = found;
    return true;
  }


  JS::Rooted<JSObject*> expando(cx, GetExpandoObject(proxy));
  if (expando) {
    bool b = true;
    bool ok = JS_HasPropertyById(cx, expando, id, &b);
    *bp = !!b;
    if (!ok || *bp) {
      return ok;
    }
  }

  bool hasOnProto;
  if (!HasPropertyOnPrototype(cx, proxy, id, &hasOnProto)) {
    return false;
  }
  if (!hasOnProto) {
    bool found = false;
    FakeString<char16_t> name;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, name, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::dom::HTMLFormControlsCollection* self = UnwrapProxy(proxy);
      Nullable<OwningRadioNodeListOrElement> result;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found, result))>, "Should be returning void here");
      MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found, result);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      (void)result;
    }

    *bp = found;
    return true;
  }
  *bp = false;
  return true;
}

bool
DOMProxyHandler::get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
              "Should not have a XrayWrapper here");

  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    mozilla::dom::HTMLFormControlsCollection* self = UnwrapProxy(proxy);
    bool found = false;
    auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->IndexedGetter(index, found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    if (found) {
      if (!result) {
        vp.setNull();
        return true;
      }
      if (!GetOrCreateDOMReflector(cx, result, vp)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    // Even if we don't have this index, we don't forward the
    // get on to our expando object.
  } else {
    bool expandoHasProp = false;
    { // Scope for expando
      JS::Rooted<JSObject*> expando(cx, DOMProxyHandler::GetExpandoObject(proxy));
      if (expando) {
        if (!JS_HasPropertyById(cx, expando, id, &expandoHasProp)) {
          return false;
        }

        if (expandoHasProp) {
          // Forward the get to the expando object, but our receiver is whatever our
          // receiver is.
          if (!JS_ForwardGetPropertyTo(cx, expando, id, receiver, vp)) {
            return false;
          }
        }
      }
    }

    if (expandoHasProp) {
      return true;
    }
  }

  bool foundOnPrototype;
  if (!GetPropertyOnPrototype(cx, proxy, receiver, id, &foundOnPrototype, vp)) {
    return false;
  }

  if (foundOnPrototype) {
    return true;
  }

  MOZ_ASSERT(vp.isUndefined());
  if (!IsArrayIndex(index)) {
    FakeString<char16_t> name;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, name, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::dom::HTMLFormControlsCollection* self = UnwrapProxy(proxy);
      bool found = false;
      Nullable<OwningRadioNodeListOrElement> result;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found, result))>, "Should be returning void here");
      MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found, result);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));

      if (found) {
        if (result.IsNull()) {
          vp.setNull();
          return true;
        }
        if (!result.Value().ToJSVal(cx, proxy, vp)) {
          return false;
        }
        return true;
      }
    }
  }

  return true;
}

const char*
DOMProxyHandler::className(JSContext* cx, JS::Handle<JSObject*> proxy) const
{
  return "HTMLFormControlsCollection";
}

bool
DOMProxyHandler::finalizeInBackground(const JS::Value& priv) const
{
  return false;
}

void
DOMProxyHandler::finalize(JS::GCContext* gcx, JSObject* proxy) const
{
  mozilla::dom::HTMLFormControlsCollection* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::HTMLFormControlsCollection>(proxy);
  if (self) {
    JS::SetReservedSlot(proxy, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, proxy);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(proxy, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::HTMLFormControlsCollection>(self);
  }
}

const DOMProxyHandler*
DOMProxyHandler::getInstance()
{
  static const DOMProxyHandler instance;
  return &instance;
}

bool
DOMProxyHandler::delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");

  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    bool deleteSucceeded;
    bool found = false;
    mozilla::dom::HTMLFormControlsCollection* self = UnwrapProxy(proxy);
    auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->IndexedGetter(index, found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;
    deleteSucceeded = !found;
    return deleteSucceeded ? opresult.succeed() : opresult.failCantDelete();
  }
  // Try named delete only if the named property visibility
  // algorithm says the property is visible.
  bool tryNamedDelete = true;
  { // Scope for expando
    JS::Rooted<JSObject*> expando(cx, DOMProxyHandler::GetExpandoObject(proxy));
    if (expando) {
      bool hasProp;
      if (!JS_HasPropertyById(cx, expando, id, &hasProp)) {
        return false;
      }
      tryNamedDelete = !hasProp;
    }
  }
  if (tryNamedDelete) {
    bool hasOnProto;
    if (!HasPropertyOnPrototype(cx, proxy, id, &hasOnProto)) {
      return false;
    }
    tryNamedDelete = !hasOnProto;
  }
  if (tryNamedDelete) {
    bool found = false;
    bool deleteSucceeded;
    FakeString<char16_t> name;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, name, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::dom::HTMLFormControlsCollection* self = UnwrapProxy(proxy);
      Nullable<OwningRadioNodeListOrElement> result;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found, result))>, "Should be returning void here");
      MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found, result);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      (void)result;
    }
    deleteSucceeded = !found;
    if (found) {
      return deleteSucceeded ? opresult.succeed() : opresult.failCantDelete();
    }
  }

  return dom::DOMProxyHandler::delete_(cx, proxy, id, opresult);
}

bool
DOMProxyHandler::getElements(JSContext* cx, JS::Handle<JSObject*> proxy, uint32_t begin, uint32_t end, js::ElementAdder* adder) const
{
  JS::Rooted<JS::Value> temp(cx);
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
             "Should not have a XrayWrapper here");

  mozilla::dom::HTMLFormControlsCollection* self = UnwrapProxy(proxy);
  uint32_t length = self->Length();
  // Compute the end of the indices we'll get ourselves
  uint32_t ourEnd = std::clamp(length, begin, end);

  for (uint32_t index = begin; index < ourEnd; ++index) {
    bool found = false;
    auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->IndexedGetter(index, found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    MOZ_ASSERT(found);
    if (!result) {
      temp.setNull();
      if (!adder->append(cx, temp)) return false;
      continue;
    }
    if (!GetOrCreateDOMReflector(cx, result, &temp)) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      return false;
    }
    if (!adder->append(cx, temp)) return false;
    continue;
  }

  if (end > ourEnd) {
    JS::Rooted<JSObject*> proto(cx);
    if (!js::GetObjectProto(cx, proxy, &proto)) {
      return false;
    }
    return js::GetElementsWithAdder(cx, proto, proxy, ourEnd, end, adder);
  }

  return true;
}

size_t
DOMProxyHandler::objectMoved(JSObject* obj, JSObject* old) const
{
  return NativeTypeHelpers<mozilla::dom::HTMLFormControlsCollection>::ObjectMoved(obj, old);
}

static const DOMJSClass sClass = {
  PROXY_CLASS_DEF("HTMLFormControlsCollection",
                  JSCLASS_IS_DOMJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(1)),
  { prototypes::id::HTMLCollection, prototypes::id::HTMLFormControlsCollection, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::HTMLFormControlsCollection>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::HTMLFormControlsCollection>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::HTMLFormControlsCollection>::Get(),
  nullptr,
  nullptr
};

bool
Wrap(JSContext* aCx, mozilla::dom::HTMLFormControlsCollection* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::HTMLFormControlsCollection>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::HTMLFormControlsCollection*>);
  MOZ_ASSERT(static_cast<nsIHTMLCollection*>(aObject) ==
             reinterpret_cast<nsIHTMLCollection*>(aObject),
             "Multiple inheritance for nsIHTMLCollection is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    DOMProxyHandler::getInstance()->finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::HTMLFormControlsCollection> creator(aCx);
  creator.CreateProxyObject(aCx, &sClass.mBase, DOMProxyHandler::getInstance(),
                            proto, /* aLazyProto = */ false,
                            aObject, JS::UndefinedHandleValue, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::HTMLFormControlsCollection);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::HTMLFormControlsCollection);

  JS::Handle<JSObject*> parentProto(HTMLCollection_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(HTMLCollection_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "HTMLFormControlsCollection",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::HTMLFormControlsCollection,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::HTMLFormControlsCollection,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace HTMLFormControlsCollection_Binding



} // namespace mozilla::dom
