//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/cache/PCacheStreamControlParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/cache/CacheStreamControlParent.h"
#include "nsID.h"

#include "mozilla/ipc/PBackgroundParent.h"
#include "mozilla/dom/cache/PBoundStorageKeyParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace cache {


MOZ_IMPLICIT PCacheStreamControlParent::PCacheStreamControlParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PCacheStreamControlParent);
}

PCacheStreamControlParent::~PCacheStreamControlParent()
{
    MOZ_COUNT_DTOR(PCacheStreamControlParent);
}

auto PCacheStreamControlParent::ActorAlloc() -> void
{
    AddRef();
}

auto PCacheStreamControlParent::ActorDealloc() -> void
{
    Release();
}

auto PCacheStreamControlParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PCacheStreamControlParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PCacheStreamControlParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PCacheStreamControlParent::SendCloseAll() -> bool
{
    UniquePtr<IPC::Message> msg__ = PCacheStreamControl::Msg_CloseAll(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PCacheStreamControl", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCacheStreamControlParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCacheStreamControl::Msg_CloseAll", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCacheStreamControlParent::Send__delete__(PCacheStreamControlParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PCacheStreamControl::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PCacheStreamControl", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCacheStreamControlParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCacheStreamControl::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PCacheStreamControlParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PCacheStreamControlParent::OnMessageReceived(const Message& msg__) -> PCacheStreamControlParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PCacheStreamControl::Msg_OpenStream__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCacheStreamControl", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCacheStreamControlParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCacheStreamControl::Msg_OpenStream", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aStreamId = IPC::ReadParam<nsID>((&(reader__)));
            if (!maybe__aStreamId) {
                FatalError("Error deserializing 'nsID'");
                return MsgValueError;

            }
            auto& aStreamId = *maybe__aStreamId;
            // Sentinel = 'aStreamId'
            if ((!(((&(reader__)))->ReadSentinel(295437179)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsID'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PCacheStreamControl::Reply_OpenStream(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            OpenStreamResolver resolver = [resolver__ = std::move(resolver__)](const mozilla::Maybe<IPCStream>& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'aStream'
                    ((&(writer__)))->WriteSentinel(185205454);

                    if (mozilla::ipc::LoggingEnabledFor("PCacheStreamControl", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PCacheStreamControlParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<CacheStreamControlParent*>(this))->RecvOpenStream(std::move(aStreamId), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCacheStreamControl::Msg_NoteClosed__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCacheStreamControl", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCacheStreamControlParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCacheStreamControl::Msg_NoteClosed", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aStreamId = IPC::ReadParam<nsID>((&(reader__)));
            if (!maybe__aStreamId) {
                FatalError("Error deserializing 'nsID'");
                return MsgValueError;

            }
            auto& aStreamId = *maybe__aStreamId;
            // Sentinel = 'aStreamId'
            if ((!(((&(reader__)))->ReadSentinel(295437179)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsID'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CacheStreamControlParent*>(this))->RecvNoteClosed(std::move(aStreamId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCacheStreamControl::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PCacheStreamControlParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PCacheStreamControlParent::Result
{
    return MsgNotKnown;
}



} // namespace cache
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::cache::PCacheStreamControlParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PCacheStreamControl'
    (aWriter)->WriteSentinel(1196230514);
}

auto ParamTraits<::mozilla::dom::cache::PCacheStreamControlParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PCacheStreamControl actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PCacheStreamControl'
    if ((!((aReader)->ReadSentinel(1196230514)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PCacheStreamControl actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PCacheStreamControlMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PCacheStreamControl)");

        return {};
    }
    return static_cast<::mozilla::dom::cache::PCacheStreamControlParent*>(actor);
}

} // namespace IPC
