/* MediaViewer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MediaViewer.vala, do not modify */

/* Mostly inspired by Loupe https://gitlab.gnome.org/GNOME/loupe and Fractal https://gitlab.gnome.org/GNOME/fractal*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>
#include <gtk/gtk.h>
#include <adwaita.h>
#include <gio/gio.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <graphene-gobject.h>
#include <glib/gi18n-lib.h>
#include <clapper-gtk/clapper-gtk.h>
#include <clapper/clapper.h>

#define TUBA_VIEWS_MEDIA_VIEWER_MAX_ZOOM ((gdouble) 20)
#define TUBA_VIEWS_MEDIA_VIEWER_CANCEL_SWIPE_ANIMATION_DURATION ((guint) 400)
#define BUILD_NAME "Tuba"
#define BUILD_DOMAIN "dev.geopjr.Tuba"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TUBA_TYPE_ATTACHMENT (tuba_attachment_get_type ())
#define TUBA_ATTACHMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_ATTACHMENT, TubaAttachment))
#define TUBA_ATTACHMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_ATTACHMENT, TubaAttachmentClass))
#define TUBA_IS_ATTACHMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_ATTACHMENT))
#define TUBA_IS_ATTACHMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_ATTACHMENT))
#define TUBA_ATTACHMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_ATTACHMENT, TubaAttachmentClass))

typedef struct _TubaAttachment TubaAttachment;
typedef struct _TubaAttachmentClass TubaAttachmentClass;
typedef struct _TubaAttachmentPrivate TubaAttachmentPrivate;
typedef enum  {
	TUBA_ATTACHMENT_MEDIA_TYPE_IMAGE,
	TUBA_ATTACHMENT_MEDIA_TYPE_VIDEO,
	TUBA_ATTACHMENT_MEDIA_TYPE_GIFV,
	TUBA_ATTACHMENT_MEDIA_TYPE_AUDIO,
	TUBA_ATTACHMENT_MEDIA_TYPE_UNKNOWN
} TubaAttachmentMediaType;

#define TUBA_ATTACHMENT_TYPE_MEDIA_TYPE (tuba_attachment_media_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TubaParamSpecAttachment TubaParamSpecAttachment;

#define TUBA_VIEWS_TYPE_MEDIA_VIEWER (tuba_views_media_viewer_get_type ())
#define TUBA_VIEWS_MEDIA_VIEWER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_VIEWS_TYPE_MEDIA_VIEWER, TubaViewsMediaViewer))
#define TUBA_VIEWS_MEDIA_VIEWER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_VIEWS_TYPE_MEDIA_VIEWER, TubaViewsMediaViewerClass))
#define TUBA_VIEWS_IS_MEDIA_VIEWER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_VIEWS_TYPE_MEDIA_VIEWER))
#define TUBA_VIEWS_IS_MEDIA_VIEWER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_VIEWS_TYPE_MEDIA_VIEWER))
#define TUBA_VIEWS_MEDIA_VIEWER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_VIEWS_TYPE_MEDIA_VIEWER, TubaViewsMediaViewerClass))

typedef struct _TubaViewsMediaViewer TubaViewsMediaViewer;
typedef struct _TubaViewsMediaViewerClass TubaViewsMediaViewerClass;
typedef struct _TubaViewsMediaViewerPrivate TubaViewsMediaViewerPrivate;

#define TUBA_VIEWS_MEDIA_VIEWER_TYPE_ITEM (tuba_views_media_viewer_item_get_type ())
#define TUBA_VIEWS_MEDIA_VIEWER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_VIEWS_MEDIA_VIEWER_TYPE_ITEM, TubaViewsMediaViewerItem))
#define TUBA_VIEWS_MEDIA_VIEWER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_VIEWS_MEDIA_VIEWER_TYPE_ITEM, TubaViewsMediaViewerItemClass))
#define TUBA_VIEWS_MEDIA_VIEWER_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_VIEWS_MEDIA_VIEWER_TYPE_ITEM))
#define TUBA_VIEWS_MEDIA_VIEWER_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_VIEWS_MEDIA_VIEWER_TYPE_ITEM))
#define TUBA_VIEWS_MEDIA_VIEWER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_VIEWS_MEDIA_VIEWER_TYPE_ITEM, TubaViewsMediaViewerItemClass))

typedef struct _TubaViewsMediaViewerItem TubaViewsMediaViewerItem;
typedef struct _TubaViewsMediaViewerItemClass TubaViewsMediaViewerItemClass;

#define TUBA_WIDGETS_TYPE_SCALE_REVEALER (tuba_widgets_scale_revealer_get_type ())
#define TUBA_WIDGETS_SCALE_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_WIDGETS_TYPE_SCALE_REVEALER, TubaWidgetsScaleRevealer))
#define TUBA_WIDGETS_SCALE_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_WIDGETS_TYPE_SCALE_REVEALER, TubaWidgetsScaleRevealerClass))
#define TUBA_WIDGETS_IS_SCALE_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_WIDGETS_TYPE_SCALE_REVEALER))
#define TUBA_WIDGETS_IS_SCALE_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_WIDGETS_TYPE_SCALE_REVEALER))
#define TUBA_WIDGETS_SCALE_REVEALER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_WIDGETS_TYPE_SCALE_REVEALER, TubaWidgetsScaleRevealerClass))

typedef struct _TubaWidgetsScaleRevealer TubaWidgetsScaleRevealer;
typedef struct _TubaWidgetsScaleRevealerClass TubaWidgetsScaleRevealerClass;
enum  {
	TUBA_VIEWS_MEDIA_VIEWER_0_PROPERTY,
	TUBA_VIEWS_MEDIA_VIEWER_FULLSCREEN_PROPERTY,
	TUBA_VIEWS_MEDIA_VIEWER_NUM_PROPERTIES
};
static GParamSpec* tuba_views_media_viewer_properties[TUBA_VIEWS_MEDIA_VIEWER_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TUBA_TYPE_APPLICATION (tuba_application_get_type ())
#define TUBA_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_APPLICATION, TubaApplication))
#define TUBA_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_APPLICATION, TubaApplicationClass))
#define TUBA_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_APPLICATION))
#define TUBA_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_APPLICATION))
#define TUBA_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_APPLICATION, TubaApplicationClass))

typedef struct _TubaApplication TubaApplication;
typedef struct _TubaApplicationClass TubaApplicationClass;
typedef struct _Block83Data Block83Data;

#define TUBA_WIDGETS_AUDIO_TYPE_PLAYER (tuba_widgets_audio_player_get_type ())
#define TUBA_WIDGETS_AUDIO_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_WIDGETS_AUDIO_TYPE_PLAYER, TubaWidgetsAudioPlayer))
#define TUBA_WIDGETS_AUDIO_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_WIDGETS_AUDIO_TYPE_PLAYER, TubaWidgetsAudioPlayerClass))
#define TUBA_WIDGETS_AUDIO_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_WIDGETS_AUDIO_TYPE_PLAYER))
#define TUBA_WIDGETS_AUDIO_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_WIDGETS_AUDIO_TYPE_PLAYER))
#define TUBA_WIDGETS_AUDIO_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_WIDGETS_AUDIO_TYPE_PLAYER, TubaWidgetsAudioPlayerClass))

typedef struct _TubaWidgetsAudioPlayer TubaWidgetsAudioPlayer;
typedef struct _TubaWidgetsAudioPlayerClass TubaWidgetsAudioPlayerClass;
typedef struct _Block84Data Block84Data;

#define TUBA_TYPE_SETTINGS (tuba_settings_get_type ())
#define TUBA_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_SETTINGS, TubaSettings))
#define TUBA_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_SETTINGS, TubaSettingsClass))
#define TUBA_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_SETTINGS))
#define TUBA_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_SETTINGS))
#define TUBA_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_SETTINGS, TubaSettingsClass))

typedef struct _TubaSettings TubaSettings;
typedef struct _TubaSettingsClass TubaSettingsClass;
typedef void (*TubaHelperImageOnItemChangedFn) (GdkPaintable* data, gpointer user_data);
typedef struct _Block85Data Block85Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _Block86Data Block86Data;

#define TUBA_DIALOGS_TYPE_MAIN_WINDOW (tuba_dialogs_main_window_get_type ())
#define TUBA_DIALOGS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_DIALOGS_TYPE_MAIN_WINDOW, TubaDialogsMainWindow))
#define TUBA_DIALOGS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_DIALOGS_TYPE_MAIN_WINDOW, TubaDialogsMainWindowClass))
#define TUBA_DIALOGS_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_DIALOGS_TYPE_MAIN_WINDOW))
#define TUBA_DIALOGS_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_DIALOGS_TYPE_MAIN_WINDOW))
#define TUBA_DIALOGS_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_DIALOGS_TYPE_MAIN_WINDOW, TubaDialogsMainWindowClass))

typedef struct _TubaDialogsMainWindow TubaDialogsMainWindow;
typedef struct _TubaDialogsMainWindowClass TubaDialogsMainWindowClass;
typedef struct _TubaViewsMediaViewerItemPrivate TubaViewsMediaViewerItemPrivate;
enum  {
	TUBA_VIEWS_MEDIA_VIEWER_ITEM_0_PROPERTY,
	TUBA_VIEWS_MEDIA_VIEWER_ITEM_CHILD_WIDGET_PROPERTY,
	TUBA_VIEWS_MEDIA_VIEWER_ITEM_IS_VIDEO_PROPERTY,
	TUBA_VIEWS_MEDIA_VIEWER_ITEM_IS_AUDIO_PROPERTY,
	TUBA_VIEWS_MEDIA_VIEWER_ITEM_URL_PROPERTY,
	TUBA_VIEWS_MEDIA_VIEWER_ITEM_LAST_X_PROPERTY,
	TUBA_VIEWS_MEDIA_VIEWER_ITEM_LAST_Y_PROPERTY,
	TUBA_VIEWS_MEDIA_VIEWER_ITEM_PLAYING_PROPERTY,
	TUBA_VIEWS_MEDIA_VIEWER_ITEM_CAN_ZOOM_IN_PROPERTY,
	TUBA_VIEWS_MEDIA_VIEWER_ITEM_CAN_ZOOM_OUT_PROPERTY,
	TUBA_VIEWS_MEDIA_VIEWER_ITEM_CHILD_WIDTH_PROPERTY,
	TUBA_VIEWS_MEDIA_VIEWER_ITEM_CHILD_HEIGHT_PROPERTY,
	TUBA_VIEWS_MEDIA_VIEWER_ITEM_NUM_PROPERTIES
};
static GParamSpec* tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_NUM_PROPERTIES];
enum  {
	TUBA_VIEWS_MEDIA_VIEWER_ITEM_ZOOM_CHANGED_SIGNAL,
	TUBA_VIEWS_MEDIA_VIEWER_ITEM_NUM_SIGNALS
};
static guint tuba_views_media_viewer_item_signals[TUBA_VIEWS_MEDIA_VIEWER_ITEM_NUM_SIGNALS] = {0};

struct _TubaAttachment {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TubaAttachmentPrivate * priv;
};

struct _TubaAttachmentClass {
	GTypeClass parent_class;
	void (*finalize) (TubaAttachment *self);
};

struct _TubaParamSpecAttachment {
	GParamSpec parent_instance;
};

struct _TubaViewsMediaViewer {
	GtkWidget parent_instance;
	TubaViewsMediaViewerPrivate * priv;
	GSimpleAction* copy_media_simple_action;
	AdwSwipeTracker* swipe_tracker;
	GeeHashMap* revealer_widgets;
};

struct _TubaViewsMediaViewerClass {
	GtkWidgetClass parent_class;
};

struct _TubaViewsMediaViewerPrivate {
	gboolean _fullscreen;
	GeeArrayList* items;
	GtkPopoverMenu* context_menu;
	GtkButton* fullscreen_btn;
	AdwHeaderBar* headerbar;
	GtkButton* back_btn;
	GtkRevealer* toggle_fs_revealer;
	GtkRevealer* page_buttons_revealer;
	GtkButton* prev_btn;
	GtkButton* next_btn;
	GtkRevealer* zoom_buttons_revealer;
	GtkButton* zoom_out_btn;
	GtkButton* zoom_in_btn;
	TubaWidgetsScaleRevealer* scale_revealer;
	AdwCarousel* carousel;
	gchar* clapper_cache_dir;
	GeeHashMap* clapper_cached_urls;
	gdouble _swipe_progress;
	gint* old_height;
	gint* old_width;
	gdouble on_motion_last_x;
	gdouble on_motion_last_y;
	guint revealer_timeout;
	gboolean revealed;
	gint load_and_scroll_to;
	GeeArrayList* clapper_cached_locations;
	GeeArrayList* todo_items;
	guint old_pos;
};

struct _Block83Data {
	int _ref_count_;
	TubaViewsMediaViewer* self;
	TubaViewsMediaViewerItem* item;
};

struct _Block84Data {
	int _ref_count_;
	Block83Data * _data83_;
	GtkPicture* picture;
};

struct _Block85Data {
	int _ref_count_;
	TubaViewsMediaViewer* self;
	GFile* file;
};

struct _Block86Data {
	int _ref_count_;
	TubaViewsMediaViewer* self;
	gint i;
	gint pos;
};

struct _TubaViewsMediaViewerItem {
	AdwBin parent_instance;
	TubaViewsMediaViewerItemPrivate * priv;
};

struct _TubaViewsMediaViewerItemClass {
	AdwBinClass parent_class;
};

struct _TubaViewsMediaViewerItemPrivate {
	GtkStack* stack;
	GtkOverlay* overlay;
	AdwSpinner* spinner;
	GtkScrolledWindow* scroller;
	gboolean is_done;
	GtkWidget* _child_widget;
	gboolean _is_video;
	gboolean _is_audio;
	gchar* _url;
	gdouble _last_x;
	gdouble _last_y;
	gboolean pre_playing;
	guint spinner_timeout;
};

static gpointer tuba_attachment_parent_class = NULL;
static gint TubaViewsMediaViewer_private_offset;
static gpointer tuba_views_media_viewer_parent_class = NULL;
static gdouble tuba_views_media_viewer_last_used_volume;
static gdouble tuba_views_media_viewer_last_used_volume = 1.0;
VALA_EXTERN TubaApplication* tuba_app;
VALA_EXTERN TubaSettings* tuba_settings;
static gint TubaViewsMediaViewerItem_private_offset;
static gpointer tuba_views_media_viewer_item_parent_class = NULL;
VALA_EXTERN gchar* tuba_cache_path;
VALA_EXTERN gboolean tuba_is_rtl;
static GtkBuildableIface * tuba_views_media_viewer_gtk_buildable_parent_iface = NULL;
static AdwSwipeableInterface * tuba_views_media_viewer_adw_swipeable_parent_iface = NULL;

VALA_EXTERN gpointer tuba_attachment_ref (gpointer instance);
VALA_EXTERN void tuba_attachment_unref (gpointer instance);
VALA_EXTERN GParamSpec* tuba_param_spec_attachment (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void tuba_value_set_attachment (GValue* value,
                                gpointer v_object);
VALA_EXTERN void tuba_value_take_attachment (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer tuba_value_get_attachment (const GValue* value);
VALA_EXTERN GType tuba_attachment_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaAttachment, tuba_attachment_unref)
VALA_EXTERN GType tuba_attachment_media_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean tuba_attachment_media_type_can_copy (TubaAttachmentMediaType self);
VALA_EXTERN gboolean tuba_attachment_media_type_is_video (TubaAttachmentMediaType self);
VALA_EXTERN gchar* tuba_attachment_media_type_to_string (TubaAttachmentMediaType self);
VALA_EXTERN TubaAttachmentMediaType tuba_attachment_media_type_from_string (const gchar* media_type);
VALA_EXTERN TubaAttachment* tuba_attachment_new (void);
VALA_EXTERN TubaAttachment* tuba_attachment_construct (GType object_type);
static void tuba_attachment_finalize (TubaAttachment * obj);
static GType tuba_attachment_get_type_once (void);
VALA_EXTERN GType tuba_views_media_viewer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaViewsMediaViewer, g_object_unref)
VALA_EXTERN GType tuba_views_media_viewer_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaViewsMediaViewerItem, g_object_unref)
VALA_EXTERN GType tuba_widgets_scale_revealer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaWidgetsScaleRevealer, g_object_unref)
static void tuba_views_media_viewer_clapper_cache_cleanup (TubaViewsMediaViewer* self,
                                                    gboolean all);
static void tuba_views_media_viewer_copy_url (TubaViewsMediaViewer* self);
static void _tuba_views_media_viewer_copy_url_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void tuba_views_media_viewer_open_in_browser (TubaViewsMediaViewer* self);
static void _tuba_views_media_viewer_open_in_browser_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self);
static void tuba_views_media_viewer_save_as (TubaViewsMediaViewer* self);
static void _tuba_views_media_viewer_save_as_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void tuba_views_media_viewer_toggle_fullscreen (TubaViewsMediaViewer* self);
static void _tuba_views_media_viewer_toggle_fullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                  GVariant* parameter,
                                                                                  gpointer self);
static void tuba_views_media_viewer_zoom_in_action (TubaViewsMediaViewer* self);
static void _tuba_views_media_viewer_zoom_in_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self);
static void tuba_views_media_viewer_zoom_out_action (TubaViewsMediaViewer* self);
static void _tuba_views_media_viewer_zoom_out_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self);
static void tuba_views_media_viewer_on_next_clicked (TubaViewsMediaViewer* self);
static void _tuba_views_media_viewer_on_next_clicked_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self);
static void tuba_views_media_viewer_on_previous_clicked (TubaViewsMediaViewer* self);
static void _tuba_views_media_viewer_on_previous_clicked_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static void tuba_views_media_viewer_on_visible_toggle (TubaViewsMediaViewer* self);
static void tuba_views_media_viewer_setup_swipe_close (TubaViewsMediaViewer* self);
static void tuba_views_media_viewer_on_update_swipe (TubaViewsMediaViewer* self,
                                              gdouble progress);
static void _tuba_views_media_viewer_on_update_swipe_adw_swipe_tracker_update_swipe (AdwSwipeTracker* _sender,
                                                                              gdouble progress,
                                                                              gpointer self);
static void tuba_views_media_viewer_on_end_swipe (TubaViewsMediaViewer* self,
                                           gdouble velocity,
                                           gdouble to);
static void _tuba_views_media_viewer_on_end_swipe_adw_swipe_tracker_end_swipe (AdwSwipeTracker* _sender,
                                                                        gdouble velocity,
                                                                        gdouble to,
                                                                        gpointer self);
static void tuba_views_media_viewer_set_swipe_children_opacity (TubaViewsMediaViewer* self,
                                                         gdouble value);
static void tuba_views_media_viewer_set_swipe_progress (TubaViewsMediaViewer* self,
                                                 gdouble value);
static void tuba_views_media_viewer_swipe_animation_target_cb (TubaViewsMediaViewer* self,
                                                        gdouble value);
static void _tuba_views_media_viewer_swipe_animation_target_cb_adw_animation_target_func (gdouble value,
                                                                                   gpointer self);
static gdouble tuba_views_media_viewer_get_swipe_progress (TubaViewsMediaViewer* self);
static void tuba_views_media_viewer_on_swipe_animation_end (TubaViewsMediaViewer* self);
static void _tuba_views_media_viewer_on_swipe_animation_end_adw_animation_done (AdwAnimation* _sender,
                                                                         gpointer self);
VALA_EXTERN void tuba_views_media_viewer_clear (TubaViewsMediaViewer* self);
static void tuba_views_media_viewer_real_measure (GtkWidget* base,
                                           GtkOrientation orientation,
                                           gint for_size,
                                           gint* minimum,
                                           gint* natural,
                                           gint* minimum_baseline,
                                           gint* natural_baseline);
static void tuba_views_media_viewer_real_size_allocate (GtkWidget* base,
                                                 gint width,
                                                 gint height,
                                                 gint baseline);
static void tuba_views_media_viewer_real_snapshot (GtkWidget* base,
                                            GtkSnapshot* snapshot);
VALA_EXTERN AdwTimedAnimation* tuba_widgets_scale_revealer_get_animation (TubaWidgetsScaleRevealer* self);
static gdouble tuba_views_media_viewer_real_get_cancel_progress (AdwSwipeable* base);
static gdouble tuba_views_media_viewer_real_get_distance (AdwSwipeable* base);
static gdouble tuba_views_media_viewer_real_get_progress (AdwSwipeable* base);
static gdouble* tuba_views_media_viewer_real_get_snap_points (AdwSwipeable* base,
                                                       gint* result_length1);
static void tuba_views_media_viewer_real_get_swipe_area (AdwSwipeable* base,
                                                  AdwNavigationDirection navigation_direction,
                                                  gboolean is_drag,
                                                  GdkRectangle* result);
static void tuba_views_media_viewer_on_scale_revealer_transition_end (TubaViewsMediaViewer* self);
VALA_EXTERN gboolean tuba_widgets_scale_revealer_get_reveal_child (TubaWidgetsScaleRevealer* self);
VALA_EXTERN void tuba_widgets_scale_revealer_set_source_widget (TubaWidgetsScaleRevealer* self,
                                                    GtkWidget* value);
static void tuba_views_media_viewer_reset_media_viewer (TubaViewsMediaViewer* self);
static TubaViewsMediaViewerItem* tuba_views_media_viewer_safe_get (TubaViewsMediaViewer* self,
                                                            gint pos);
static void tuba_views_media_viewer_do_todo_item (TubaViewsMediaViewer* self,
                                           TubaViewsMediaViewerItem* item);
static void tuba_views_media_viewer_do_todo_items (TubaViewsMediaViewer* self);
static void tuba_views_media_viewer_on_carousel_page_changed (TubaViewsMediaViewer* self,
                                                       guint pos);
VALA_EXTERN void tuba_views_media_viewer_on_scale_changed (TubaViewsMediaViewer* self,
                                               gdouble scale);
VALA_EXTERN gint tuba_views_media_viewer_item_get_child_height (TubaViewsMediaViewerItem* self);
static gint* _int_dup (gint* self);
VALA_EXTERN gint tuba_views_media_viewer_item_get_child_width (TubaViewsMediaViewerItem* self);
VALA_EXTERN void tuba_views_media_viewer_item_zoom (TubaViewsMediaViewerItem* self,
                                        gdouble zoom_level,
                                        gint* old_width,
                                        gint* old_height);
VALA_EXTERN void tuba_views_media_viewer_on_scale_end (TubaViewsMediaViewer* self,
                                           GdkEventSequence* sequence);
VALA_EXTERN void tuba_views_media_viewer_on_motion (TubaViewsMediaViewer* self,
                                        gdouble x,
                                        gdouble y);
VALA_EXTERN void tuba_views_media_viewer_on_reveal_media_buttons (TubaViewsMediaViewer* self);
VALA_EXTERN gboolean tuba_views_media_viewer_on_hide_media_buttons (TubaViewsMediaViewer* self);
static gboolean _tuba_views_media_viewer_on_hide_media_buttons_gsource_func (gpointer self);
VALA_EXTERN void tuba_views_media_viewer_item_zoom_in (TubaViewsMediaViewerItem* self);
VALA_EXTERN void tuba_views_media_viewer_item_zoom_out (TubaViewsMediaViewerItem* self);
VALA_EXTERN void tuba_widgets_scale_revealer_set_reveal_child (TubaWidgetsScaleRevealer* self,
                                                   gboolean value);
static void _tuba_views_media_viewer_clear_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self);
VALA_EXTERN void tuba_views_media_viewer_set_fullscreen (TubaViewsMediaViewer* self,
                                             gboolean value);
static void _tuba_views_media_viewer_toggle_fullscreen_gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self);
VALA_EXTERN void tuba_utils_host_copy (const gchar* str);
VALA_EXTERN const gchar* tuba_views_media_viewer_item_get_url (TubaViewsMediaViewerItem* self);
VALA_EXTERN GType tuba_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaApplication, g_object_unref)
VALA_EXTERN void tuba_utils_host_open_url (const gchar* _uri,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN gboolean tuba_utils_host_open_url_finish (GAsyncResult* _res_);
VALA_EXTERN void tuba_widgets_attachment_item_save_media_as (const gchar* url,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN void tuba_widgets_attachment_item_save_media_as_finish (GAsyncResult* _res_);
static void tuba_views_media_viewer_on_drag_begin (TubaViewsMediaViewer* self,
                                            gdouble x,
                                            gdouble y);
VALA_EXTERN GtkWidget* tuba_views_media_viewer_item_get_child_widget (TubaViewsMediaViewerItem* self);
VALA_EXTERN gboolean tuba_views_media_viewer_item_get_can_zoom_out (TubaViewsMediaViewerItem* self);
VALA_EXTERN void tuba_views_media_viewer_item_set_last_x (TubaViewsMediaViewerItem* self,
                                              gdouble value);
VALA_EXTERN void tuba_views_media_viewer_item_set_last_y (TubaViewsMediaViewerItem* self,
                                              gdouble value);
static void tuba_views_media_viewer_on_drag_update (TubaViewsMediaViewer* self,
                                             gdouble x,
                                             gdouble y);
VALA_EXTERN void tuba_views_media_viewer_item_update_adjustment (TubaViewsMediaViewerItem* self,
                                                     gdouble x,
                                                     gdouble y);
static void tuba_views_media_viewer_on_drag_end (TubaViewsMediaViewer* self,
                                          gdouble x,
                                          gdouble y);
static void tuba_views_media_viewer_setup_mouse_previous_click (TubaViewsMediaViewer* self);
static void tuba_views_media_viewer_handle_mouse_previous_click (TubaViewsMediaViewer* self,
                                                          gint n_press,
                                                          gdouble x,
                                                          gdouble y);
static void _tuba_views_media_viewer_handle_mouse_previous_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                                     gint n_press,
                                                                                     gdouble x,
                                                                                     gdouble y,
                                                                                     gpointer self);
static void tuba_views_media_viewer_setup_mouse_secondary_click (TubaViewsMediaViewer* self);
static void tuba_views_media_viewer_on_secondary_click (TubaViewsMediaViewer* self,
                                                 gint n_press,
                                                 gdouble x,
                                                 gdouble y);
static void _tuba_views_media_viewer_on_secondary_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                            gint n_press,
                                                                            gdouble x,
                                                                            gdouble y,
                                                                            gpointer self);
static void tuba_views_media_viewer_setup_mouse1_click (TubaViewsMediaViewer* self);
static void tuba_views_media_viewer_on_mouse1_click (TubaViewsMediaViewer* self,
                                              gint n_press,
                                              gdouble x,
                                              gdouble y);
static void _tuba_views_media_viewer_on_mouse1_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                         gint n_press,
                                                                         gdouble x,
                                                                         gdouble y,
                                                                         gpointer self);
VALA_EXTERN void tuba_views_media_viewer_item_on_double_click (TubaViewsMediaViewerItem* self);
static gboolean __lambda35_ (TubaViewsMediaViewer* self,
                      TubaViewsMediaViewerItem* item);
static gboolean ___lambda35__gee_forall_func (gpointer g,
                                       gpointer self);
static void tuba_views_media_viewer_update_revealer_widget (TubaViewsMediaViewer* self,
                                                     gint pos);
VALA_EXTERN void tuba_views_media_viewer_reveal (TubaViewsMediaViewer* self,
                                     GtkWidget* widget);
VALA_EXTERN void tuba_views_media_viewer_add_media (TubaViewsMediaViewer* self,
                                        const gchar* url,
                                        TubaAttachmentMediaType media_type,
                                        GdkPaintable* preview,
                                        gboolean as_is,
                                        const gchar* alt_text,
                                        const gchar* user_friendly_url,
                                        const gchar* blurhash,
                                        gboolean stream,
                                        GtkWidget* revealer_widget,
                                        gboolean* load_and_scroll);
static Block83Data* block83_data_ref (Block83Data* _data83_);
static void block83_data_unref (void * _userdata_);
VALA_EXTERN GType tuba_widgets_audio_player_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaWidgetsAudioPlayer, g_object_unref)
VALA_EXTERN TubaWidgetsAudioPlayer* tuba_widgets_audio_player_new (GdkTexture* texture,
                                                       const gchar* blurhash);
VALA_EXTERN TubaWidgetsAudioPlayer* tuba_widgets_audio_player_construct (GType object_type,
                                                             GdkTexture* texture,
                                                             const gchar* blurhash);
VALA_EXTERN void tuba_widgets_audio_player_set_url (TubaWidgetsAudioPlayer* self,
                                        const gchar* value);
VALA_EXTERN TubaViewsMediaViewerItem* tuba_views_media_viewer_item_new (GtkWidget* child,
                                                            const gchar* t_url,
                                                            GdkPaintable* paintable,
                                                            gboolean t_is_video,
                                                            gboolean t_is_audio);
VALA_EXTERN TubaViewsMediaViewerItem* tuba_views_media_viewer_item_construct (GType object_type,
                                                                  GtkWidget* child,
                                                                  const gchar* t_url,
                                                                  GdkPaintable* paintable,
                                                                  gboolean t_is_video,
                                                                  gboolean t_is_audio);
static void tuba_views_media_viewer_on_clapper_download_complete (TubaViewsMediaViewer* self,
                                                           ClapperMediaItem* clp_media_item,
                                                           const gchar* location);
static void _tuba_views_media_viewer_on_clapper_download_complete_clapper_player_download_complete (ClapperPlayer* _sender,
                                                                                             ClapperMediaItem* item,
                                                                                             const gchar* location,
                                                                                             gpointer self);
static void tuba_views_media_viewer_add_todo_item (TubaViewsMediaViewer* self,
                                            TubaViewsMediaViewerItem* todo_item);
static Block84Data* block84_data_ref (Block84Data* _data84_);
static void block84_data_unref (void * _userdata_);
VALA_EXTERN GType tuba_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaSettings, g_object_unref)
VALA_EXTERN gboolean tuba_settings_get_media_viewer_expand_pictures (TubaSettings* self);
VALA_EXTERN void tuba_views_media_viewer_on_zoom_change (TubaViewsMediaViewer* self);
static void _tuba_views_media_viewer_on_zoom_change_tuba_views_media_viewer_item_zoom_changed (TubaViewsMediaViewerItem* _sender,
                                                                                        gpointer self);
VALA_EXTERN void tuba_helper_image_request_paintable (const gchar* url,
                                          const gchar* blurhash,
                                          gboolean disable_cache,
                                          TubaHelperImageOnItemChangedFn cb,
                                          gpointer cb_target,
                                          GDestroyNotify cb_target_destroy_notify);
static void _____lambda41_ (Block84Data* _data84_,
                     GdkPaintable* data);
static void ______lambda41__tuba_helper_image_on_item_changed_fn (GdkPaintable* data,
                                                           gpointer self);
static gboolean _bool_equal (const gboolean * s1,
                      const gboolean * s2);
static gboolean ____lambda36_ (TubaViewsMediaViewer* self,
                        GeeMapEntry* e);
static gboolean _____lambda36__gee_forall_func (gpointer g,
                                         gpointer self);
static Block85Data* block85_data_ref (Block85Data* _data85_);
static void block85_data_unref (void * _userdata_);
static void ____lambda37_ (Block85Data* _data85_,
                    GObject* obj,
                    GAsyncResult* res);
static void _____lambda37__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
VALA_EXTERN void tuba_views_media_viewer_item_done (TubaViewsMediaViewerItem* self);
static gboolean __lambda38_ (TubaViewsMediaViewer* self,
                      TubaViewsMediaViewerItem* item);
static gboolean ___lambda38__gee_forall_func (gpointer g,
                                       gpointer self);
VALA_EXTERN void tuba_views_media_viewer_scroll_to (TubaViewsMediaViewer* self,
                                        gint pos,
                                        gboolean animate);
static void _tuba_views_media_viewer_on_previous_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self);
static void _tuba_views_media_viewer_on_next_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self);
static void tuba_views_media_viewer_on_zoom_out_clicked (TubaViewsMediaViewer* self);
static void _tuba_views_media_viewer_on_zoom_out_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self);
static void tuba_views_media_viewer_on_zoom_in_clicked (TubaViewsMediaViewer* self);
static void _tuba_views_media_viewer_on_zoom_in_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self);
VALA_EXTERN gboolean tuba_views_media_viewer_item_get_is_video (TubaViewsMediaViewerItem* self);
VALA_EXTERN gboolean tuba_views_media_viewer_item_get_is_audio (TubaViewsMediaViewerItem* self);
static void tuba_views_media_viewer_play_video (TubaViewsMediaViewer* self,
                                         gint pos);
static void tuba_views_media_viewer_pause_all_videos (TubaViewsMediaViewer* self);
static void tuba_views_media_viewer_on_carousel_n_pages_changed (TubaViewsMediaViewer* self);
VALA_EXTERN gboolean tuba_views_media_viewer_item_get_can_zoom_in (TubaViewsMediaViewerItem* self);
static Block86Data* block86_data_ref (Block86Data* _data86_);
static void block86_data_unref (void * _userdata_);
static gboolean __lambda39_ (Block86Data* _data86_,
                      TubaViewsMediaViewerItem* item);
VALA_EXTERN void tuba_views_media_viewer_item_set_playing (TubaViewsMediaViewerItem* self,
                                               gboolean value);
static gboolean ___lambda39__gee_forall_func (gpointer g,
                                       gpointer self);
static gboolean __lambda40_ (TubaViewsMediaViewer* self,
                      TubaViewsMediaViewerItem* item);
static gboolean ___lambda40__gee_forall_func (gpointer g,
                                       gpointer self);
VALA_EXTERN void tuba_views_media_viewer_copy_media (TubaViewsMediaViewer* self);
VALA_EXTERN TubaViewsMediaViewer* tuba_views_media_viewer_new (void);
VALA_EXTERN TubaViewsMediaViewer* tuba_views_media_viewer_construct (GType object_type);
VALA_EXTERN gboolean tuba_views_media_viewer_get_fullscreen (TubaViewsMediaViewer* self);
VALA_EXTERN GType tuba_dialogs_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaDialogsMainWindow, g_object_unref)
VALA_EXTERN TubaDialogsMainWindow* tuba_application_get_main_window (TubaApplication* self);
VALA_EXTERN gboolean tuba_widgets_audio_player_get_muted (TubaWidgetsAudioPlayer* self);
VALA_EXTERN gdouble tuba_widgets_audio_player_get_volume (TubaWidgetsAudioPlayer* self);
VALA_EXTERN gdouble tuba_views_media_viewer_item_get_last_x (TubaViewsMediaViewerItem* self);
VALA_EXTERN gdouble tuba_views_media_viewer_item_get_last_y (TubaViewsMediaViewerItem* self);
static void tuba_views_media_viewer_item_emit_zoom_changed (TubaViewsMediaViewerItem* self);
static void tuba_views_media_viewer_item_add_spinner_to_overlay (TubaViewsMediaViewerItem* self);
static void tuba_views_media_viewer_item_set_child_widget (TubaViewsMediaViewerItem* self,
                                                    GtkWidget* value);
static void tuba_views_media_viewer_item_set_is_video (TubaViewsMediaViewerItem* self,
                                                gboolean value);
static void tuba_views_media_viewer_item_set_is_audio (TubaViewsMediaViewerItem* self,
                                                gboolean value);
static GtkWidget* tuba_views_media_viewer_item_setup_scrolledwindow (TubaViewsMediaViewerItem* self,
                                                              GtkWidget* child);
static void tuba_views_media_viewer_item_set_url (TubaViewsMediaViewerItem* self,
                                           const gchar* value);
static void tuba_views_media_viewer_item_on_manual_volume_change_video (TubaViewsMediaViewerItem* self);
static void _tuba_views_media_viewer_item_on_manual_volume_change_video_g_object_notify (GObject* _sender,
                                                                                  GParamSpec* pspec,
                                                                                  gpointer self);
static void tuba_views_media_viewer_item_on_manual_volume_change_audio (TubaViewsMediaViewerItem* self);
static void _tuba_views_media_viewer_item_on_manual_volume_change_audio_g_object_notify (GObject* _sender,
                                                                                  GParamSpec* pspec,
                                                                                  gpointer self);
VALA_EXTERN void tuba_settings_set_media_viewer_last_used_volume (TubaSettings* self,
                                                      gdouble value);
static gboolean tuba_views_media_viewer_item_on_scroll (TubaViewsMediaViewerItem* self,
                                                 GtkEventControllerScroll* scroll,
                                                 gdouble dx,
                                                 gdouble dy);
static void _tuba_views_media_viewer_item_emit_zoom_changed_gtk_adjustment_changed (GtkAdjustment* _sender,
                                                                             gpointer self);
static gboolean _tuba_views_media_viewer_item_on_scroll_gtk_event_controller_scroll_scroll (GtkEventControllerScroll* _sender,
                                                                                     gdouble dx,
                                                                                     gdouble dy,
                                                                                     gpointer self);
VALA_EXTERN gboolean tuba_views_media_viewer_item_get_playing (TubaViewsMediaViewerItem* self);
VALA_EXTERN gboolean tuba_widgets_audio_player_get_playing (TubaWidgetsAudioPlayer* self);
VALA_EXTERN void tuba_widgets_audio_player_set_playing (TubaWidgetsAudioPlayer* self,
                                            gboolean value);
static GObject * tuba_views_media_viewer_item_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void _tuba_views_media_viewer_item_add_spinner_to_overlay_gsource_once_func (gpointer self);
static void tuba_views_media_viewer_item_finalize (GObject * obj);
static GType tuba_views_media_viewer_item_get_type_once (void);
static void _vala_tuba_views_media_viewer_item_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_tuba_views_media_viewer_item_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static GObject * tuba_views_media_viewer_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _tuba_views_media_viewer___lambda42_ (TubaViewsMediaViewer* self);
static void __tuba_views_media_viewer___lambda42__g_application_shutdown (GApplication* _sender,
                                                                   gpointer self);
VALA_EXTERN gdouble tuba_settings_get_media_viewer_last_used_volume (TubaSettings* self);
static void _tuba_views_media_viewer_on_drag_begin_gtk_gesture_drag_drag_begin (GtkGestureDrag* _sender,
                                                                         gdouble start_x,
                                                                         gdouble start_y,
                                                                         gpointer self);
static void _tuba_views_media_viewer_on_drag_update_gtk_gesture_drag_drag_update (GtkGestureDrag* _sender,
                                                                           gdouble offset_x,
                                                                           gdouble offset_y,
                                                                           gpointer self);
static void _tuba_views_media_viewer_on_drag_end_gtk_gesture_drag_drag_end (GtkGestureDrag* _sender,
                                                                     gdouble offset_x,
                                                                     gdouble offset_y,
                                                                     gpointer self);
static void _tuba_views_media_viewer_on_scale_changed_gtk_gesture_zoom_scale_changed (GtkGestureZoom* _sender,
                                                                               gdouble scale,
                                                                               gpointer self);
static void _tuba_views_media_viewer_on_scale_end_gtk_gesture_end (GtkGesture* _sender,
                                                            GdkEventSequence* sequence,
                                                            gpointer self);
static void _tuba_views_media_viewer_on_motion_gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                                            gdouble x,
                                                                            gdouble y,
                                                                            gpointer self);
static void _tuba_views_media_viewer_copy_media_g_simple_action_activate (GSimpleAction* _sender,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void _tuba_views_media_viewer_on_visible_toggle_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void _tuba_views_media_viewer_on_carousel_n_pages_changed_g_object_notify (GObject* _sender,
                                                                           GParamSpec* pspec,
                                                                           gpointer self);
static void _tuba_views_media_viewer_on_carousel_page_changed_adw_carousel_page_changed (AdwCarousel* _sender,
                                                                                  guint index,
                                                                                  gpointer self);
static void _tuba_views_media_viewer_on_scale_revealer_transition_end_tuba_widgets_scale_revealer_transition_done (TubaWidgetsScaleRevealer* _sender,
                                                                                                            gpointer self);
static void tuba_views_media_viewer_finalize (GObject * obj);
static GType tuba_views_media_viewer_get_type_once (void);
static void _vala_tuba_views_media_viewer_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_tuba_views_media_viewer_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry TUBA_VIEWS_MEDIA_VIEWER_ACTION_ENTRIES[8] = {{"copy-url", _tuba_views_media_viewer_copy_url_gsimple_action_activate_callback}, {"open-in-browser", _tuba_views_media_viewer_open_in_browser_gsimple_action_activate_callback}, {"save-as", _tuba_views_media_viewer_save_as_gsimple_action_activate_callback}, {"fullscreen", _tuba_views_media_viewer_toggle_fullscreen_gsimple_action_activate_callback}, {"zoom-in", _tuba_views_media_viewer_zoom_in_action_gsimple_action_activate_callback}, {"zoom-out", _tuba_views_media_viewer_zoom_out_action_gsimple_action_activate_callback}, {"scroll-next", _tuba_views_media_viewer_on_next_clicked_gsimple_action_activate_callback}, {"scroll-back", _tuba_views_media_viewer_on_previous_clicked_gsimple_action_activate_callback}};

gboolean
tuba_attachment_media_type_can_copy (TubaAttachmentMediaType self)
{
	gboolean result;
	switch (self) {
		case TUBA_ATTACHMENT_MEDIA_TYPE_IMAGE:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

gboolean
tuba_attachment_media_type_is_video (TubaAttachmentMediaType self)
{
	gboolean result;
	switch (self) {
		case TUBA_ATTACHMENT_MEDIA_TYPE_VIDEO:
		case TUBA_ATTACHMENT_MEDIA_TYPE_GIFV:
		case TUBA_ATTACHMENT_MEDIA_TYPE_AUDIO:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

gchar*
tuba_attachment_media_type_to_string (TubaAttachmentMediaType self)
{
	gchar* result;
	switch (self) {
		case TUBA_ATTACHMENT_MEDIA_TYPE_IMAGE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("IMAGE");
			result = _tmp0_;
			return result;
		}
		case TUBA_ATTACHMENT_MEDIA_TYPE_VIDEO:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("VIDEO");
			result = _tmp1_;
			return result;
		}
		case TUBA_ATTACHMENT_MEDIA_TYPE_GIFV:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("GIFV");
			result = _tmp2_;
			return result;
		}
		case TUBA_ATTACHMENT_MEDIA_TYPE_AUDIO:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("AUDIO");
			result = _tmp3_;
			return result;
		}
		default:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("UNKNOWN");
			result = _tmp4_;
			return result;
		}
	}
}

TubaAttachmentMediaType
tuba_attachment_media_type_from_string (const gchar* media_type)
{
	gchar* media_type_up = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	TubaAttachmentMediaType result;
	g_return_val_if_fail (media_type != NULL, 0);
	_tmp0_ = g_utf8_strup (media_type, (gssize) -1);
	media_type_up = _tmp0_;
	_tmp1_ = media_type_up;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("IMAGE")))) {
		switch (0) {
			default:
			{
				result = TUBA_ATTACHMENT_MEDIA_TYPE_IMAGE;
				_g_free0 (media_type_up);
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("VIDEO")))) {
		switch (0) {
			default:
			{
				result = TUBA_ATTACHMENT_MEDIA_TYPE_VIDEO;
				_g_free0 (media_type_up);
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("GIFV")))) {
		switch (0) {
			default:
			{
				result = TUBA_ATTACHMENT_MEDIA_TYPE_GIFV;
				_g_free0 (media_type_up);
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("AUDIO")))) {
		switch (0) {
			default:
			{
				result = TUBA_ATTACHMENT_MEDIA_TYPE_AUDIO;
				_g_free0 (media_type_up);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = TUBA_ATTACHMENT_MEDIA_TYPE_UNKNOWN;
				_g_free0 (media_type_up);
				return result;
			}
		}
	}
}

 G_GNUC_NO_INLINE static GType
tuba_attachment_media_type_get_type_once (void)
{
	static const GEnumValue values[] = {{TUBA_ATTACHMENT_MEDIA_TYPE_IMAGE, "TUBA_ATTACHMENT_MEDIA_TYPE_IMAGE", "image"}, {TUBA_ATTACHMENT_MEDIA_TYPE_VIDEO, "TUBA_ATTACHMENT_MEDIA_TYPE_VIDEO", "video"}, {TUBA_ATTACHMENT_MEDIA_TYPE_GIFV, "TUBA_ATTACHMENT_MEDIA_TYPE_GIFV", "gifv"}, {TUBA_ATTACHMENT_MEDIA_TYPE_AUDIO, "TUBA_ATTACHMENT_MEDIA_TYPE_AUDIO", "audio"}, {TUBA_ATTACHMENT_MEDIA_TYPE_UNKNOWN, "TUBA_ATTACHMENT_MEDIA_TYPE_UNKNOWN", "unknown"}, {0, NULL, NULL}};
	GType tuba_attachment_media_type_type_id;
	tuba_attachment_media_type_type_id = g_enum_register_static ("TubaAttachmentMediaType", values);
	return tuba_attachment_media_type_type_id;
}

GType
tuba_attachment_media_type_get_type (void)
{
	static gsize tuba_attachment_media_type_type_id__once = 0;
	if (g_once_init_enter (&tuba_attachment_media_type_type_id__once)) {
		GType tuba_attachment_media_type_type_id;
		tuba_attachment_media_type_type_id = tuba_attachment_media_type_get_type_once ();
		g_once_init_leave (&tuba_attachment_media_type_type_id__once, tuba_attachment_media_type_type_id);
	}
	return tuba_attachment_media_type_type_id__once;
}

TubaAttachment*
tuba_attachment_construct (GType object_type)
{
	TubaAttachment* self = NULL;
	self = (TubaAttachment*) g_type_create_instance (object_type);
	return self;
}

TubaAttachment*
tuba_attachment_new (void)
{
	return tuba_attachment_construct (TUBA_TYPE_ATTACHMENT);
}

static void
tuba_value_attachment_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
tuba_value_attachment_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		tuba_attachment_unref (value->data[0].v_pointer);
	}
}

static void
tuba_value_attachment_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tuba_attachment_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
tuba_value_attachment_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
tuba_value_attachment_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TubaAttachment * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tuba_attachment_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
tuba_value_attachment_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	TubaAttachment ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tuba_attachment_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
tuba_param_spec_attachment (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	TubaParamSpecAttachment* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TUBA_TYPE_ATTACHMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
tuba_value_get_attachment (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TUBA_TYPE_ATTACHMENT), NULL);
	return value->data[0].v_pointer;
}

void
tuba_value_set_attachment (GValue* value,
                           gpointer v_object)
{
	TubaAttachment * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TUBA_TYPE_ATTACHMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TUBA_TYPE_ATTACHMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tuba_attachment_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tuba_attachment_unref (old);
	}
}

void
tuba_value_take_attachment (GValue* value,
                            gpointer v_object)
{
	TubaAttachment * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TUBA_TYPE_ATTACHMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TUBA_TYPE_ATTACHMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tuba_attachment_unref (old);
	}
}

static void
tuba_attachment_class_init (TubaAttachmentClass * klass,
                            gpointer klass_data)
{
	tuba_attachment_parent_class = g_type_class_peek_parent (klass);
	((TubaAttachmentClass *) klass)->finalize = tuba_attachment_finalize;
}

static void
tuba_attachment_instance_init (TubaAttachment * self,
                               gpointer klass)
{
	self->ref_count = 1;
}

static void
tuba_attachment_finalize (TubaAttachment * obj)
{
	TubaAttachment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_TYPE_ATTACHMENT, TubaAttachment);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
tuba_attachment_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { tuba_value_attachment_init, tuba_value_attachment_free_value, tuba_value_attachment_copy_value, tuba_value_attachment_peek_pointer, "p", tuba_value_attachment_collect_value, "p", tuba_value_attachment_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TubaAttachmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_attachment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaAttachment), 0, (GInstanceInitFunc) tuba_attachment_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType tuba_attachment_type_id;
	tuba_attachment_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TubaAttachment", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return tuba_attachment_type_id;
}

GType
tuba_attachment_get_type (void)
{
	static gsize tuba_attachment_type_id__once = 0;
	if (g_once_init_enter (&tuba_attachment_type_id__once)) {
		GType tuba_attachment_type_id;
		tuba_attachment_type_id = tuba_attachment_get_type_once ();
		g_once_init_leave (&tuba_attachment_type_id__once, tuba_attachment_type_id);
	}
	return tuba_attachment_type_id__once;
}

gpointer
tuba_attachment_ref (gpointer instance)
{
	TubaAttachment * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
tuba_attachment_unref (gpointer instance)
{
	TubaAttachment * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TUBA_ATTACHMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
tuba_views_media_viewer_get_instance_private (TubaViewsMediaViewer* self)
{
	return G_STRUCT_MEMBER_P (self, TubaViewsMediaViewer_private_offset);
}

static void
_tuba_views_media_viewer_copy_url_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	tuba_views_media_viewer_copy_url ((TubaViewsMediaViewer*) self);
}

static void
_tuba_views_media_viewer_open_in_browser_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self)
{
	tuba_views_media_viewer_open_in_browser ((TubaViewsMediaViewer*) self);
}

static void
_tuba_views_media_viewer_save_as_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	tuba_views_media_viewer_save_as ((TubaViewsMediaViewer*) self);
}

static void
_tuba_views_media_viewer_toggle_fullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self)
{
	tuba_views_media_viewer_toggle_fullscreen ((TubaViewsMediaViewer*) self);
}

static void
_tuba_views_media_viewer_zoom_in_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self)
{
	tuba_views_media_viewer_zoom_in_action ((TubaViewsMediaViewer*) self);
}

static void
_tuba_views_media_viewer_zoom_out_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self)
{
	tuba_views_media_viewer_zoom_out_action ((TubaViewsMediaViewer*) self);
}

static void
_tuba_views_media_viewer_on_next_clicked_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self)
{
	tuba_views_media_viewer_on_next_clicked ((TubaViewsMediaViewer*) self);
}

static void
_tuba_views_media_viewer_on_previous_clicked_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	tuba_views_media_viewer_on_previous_clicked ((TubaViewsMediaViewer*) self);
}

static void
tuba_views_media_viewer_on_visible_toggle (TubaViewsMediaViewer* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gtk_widget_grab_focus ((GtkWidget*) self);
	}
}

static void
_tuba_views_media_viewer_on_update_swipe_adw_swipe_tracker_update_swipe (AdwSwipeTracker* _sender,
                                                                         gdouble progress,
                                                                         gpointer self)
{
	tuba_views_media_viewer_on_update_swipe ((TubaViewsMediaViewer*) self, progress);
}

static void
_tuba_views_media_viewer_on_end_swipe_adw_swipe_tracker_end_swipe (AdwSwipeTracker* _sender,
                                                                   gdouble velocity,
                                                                   gdouble to,
                                                                   gpointer self)
{
	tuba_views_media_viewer_on_end_swipe ((TubaViewsMediaViewer*) self, velocity, to);
}

static void
tuba_views_media_viewer_setup_swipe_close (TubaViewsMediaViewer* self)
{
	AdwSwipeTracker* _tmp0_ = NULL;
	AdwSwipeTracker* _tmp1_;
	AdwSwipeTracker* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = adw_swipe_tracker_new ((AdwSwipeable*) self);
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp0_, GTK_ORIENTATION_VERTICAL);
	adw_swipe_tracker_set_enabled (_tmp0_, TRUE);
	adw_swipe_tracker_set_allow_mouse_drag (_tmp0_, TRUE);
	_g_object_unref0 (self->swipe_tracker);
	self->swipe_tracker = _tmp0_;
	_tmp1_ = self->swipe_tracker;
	g_signal_connect_object (_tmp1_, "update-swipe", (GCallback) _tuba_views_media_viewer_on_update_swipe_adw_swipe_tracker_update_swipe, self, 0);
	_tmp2_ = self->swipe_tracker;
	g_signal_connect_object (_tmp2_, "end-swipe", (GCallback) _tuba_views_media_viewer_on_end_swipe_adw_swipe_tracker_end_swipe, self, 0);
}

static void
tuba_views_media_viewer_on_update_swipe (TubaViewsMediaViewer* self,
                                         gdouble progress)
{
	g_return_if_fail (self != NULL);
	tuba_views_media_viewer_set_swipe_children_opacity (self, 0.0);
	tuba_views_media_viewer_set_swipe_progress (self, progress);
	gtk_widget_queue_allocate ((GtkWidget*) self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
_tuba_views_media_viewer_swipe_animation_target_cb_adw_animation_target_func (gdouble value,
                                                                              gpointer self)
{
	tuba_views_media_viewer_swipe_animation_target_cb ((TubaViewsMediaViewer*) self, value);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_tuba_views_media_viewer_on_swipe_animation_end_adw_animation_done (AdwAnimation* _sender,
                                                                    gpointer self)
{
	tuba_views_media_viewer_on_swipe_animation_end ((TubaViewsMediaViewer*) self);
}

static void
tuba_views_media_viewer_on_end_swipe (TubaViewsMediaViewer* self,
                                      gdouble velocity,
                                      gdouble to)
{
	g_return_if_fail (self != NULL);
	if (to == 0.0) {
		AdwCallbackAnimationTarget* target = NULL;
		AdwCallbackAnimationTarget* _tmp0_;
		AdwTimedAnimation* animation = NULL;
		gdouble _tmp1_;
		AdwCallbackAnimationTarget* _tmp2_;
		AdwAnimationTarget* _tmp3_;
		AdwTimedAnimation* _tmp4_ = NULL;
		AdwTimedAnimation* _tmp5_;
		AdwTimedAnimation* _tmp6_;
		_tmp0_ = (AdwCallbackAnimationTarget*) adw_callback_animation_target_new (_tuba_views_media_viewer_swipe_animation_target_cb_adw_animation_target_func, g_object_ref (self), g_object_unref);
		target = _tmp0_;
		_tmp1_ = self->priv->_swipe_progress;
		_tmp2_ = target;
		_tmp3_ = _g_object_ref0 ((AdwAnimationTarget*) _tmp2_);
		_tmp4_ = (AdwTimedAnimation*) adw_timed_animation_new ((GtkWidget*) self, _tmp1_, 0.0, TUBA_VIEWS_MEDIA_VIEWER_CANCEL_SWIPE_ANIMATION_DURATION, _tmp3_);
		adw_timed_animation_set_easing (_tmp4_, ADW_EASE_OUT_QUART);
		animation = _tmp4_;
		_tmp5_ = animation;
		g_signal_connect_object ((AdwAnimation*) _tmp5_, "done", (GCallback) _tuba_views_media_viewer_on_swipe_animation_end_adw_animation_done, self, 0);
		_tmp6_ = animation;
		adw_animation_play ((AdwAnimation*) _tmp6_);
		_g_object_unref0 (animation);
		_g_object_unref0 (target);
	} else {
		tuba_views_media_viewer_clear (self);
		tuba_views_media_viewer_set_swipe_children_opacity (self, 1.0);
	}
}

static void
tuba_views_media_viewer_swipe_animation_target_cb (TubaViewsMediaViewer* self,
                                                   gdouble value)
{
	g_return_if_fail (self != NULL);
	tuba_views_media_viewer_set_swipe_progress (self, value);
	gtk_widget_queue_allocate ((GtkWidget*) self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
tuba_views_media_viewer_on_swipe_animation_end (TubaViewsMediaViewer* self)
{
	g_return_if_fail (self != NULL);
	tuba_views_media_viewer_set_swipe_children_opacity (self, 1.0);
}

static void
tuba_views_media_viewer_real_measure (GtkWidget* base,
                                      GtkOrientation orientation,
                                      gint for_size,
                                      gint* minimum,
                                      gint* natural,
                                      gint* minimum_baseline,
                                      gint* natural_baseline)
{
	TubaViewsMediaViewer * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint _vala_minimum_baseline = 0;
	gint _vala_natural_baseline = 0;
	TubaWidgetsScaleRevealer* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	self = (TubaViewsMediaViewer*) base;
	_tmp0_ = self->priv->scale_revealer;
	gtk_widget_measure ((GtkWidget*) _tmp0_, orientation, for_size, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	_vala_minimum = _tmp1_;
	_vala_natural = _tmp2_;
	_vala_minimum_baseline = _tmp3_;
	_vala_natural_baseline = _tmp4_;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
	if (minimum_baseline) {
		*minimum_baseline = _vala_minimum_baseline;
	}
	if (natural_baseline) {
		*natural_baseline = _vala_natural_baseline;
	}
}

static void
tuba_views_media_viewer_real_size_allocate (GtkWidget* base,
                                            gint width,
                                            gint height,
                                            gint baseline)
{
	TubaViewsMediaViewer * self;
	gint swipe_y_offset = 0;
	gdouble _tmp0_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp1_ = {0};
	TubaWidgetsScaleRevealer* _tmp2_;
	GtkAllocation _tmp3_;
	self = (TubaViewsMediaViewer*) base;
	_tmp0_ = self->priv->_swipe_progress;
	swipe_y_offset = (gint) ((-height) * _tmp0_);
	memset (&_tmp1_, 0, sizeof (GtkAllocation));
	_tmp1_.x = 0;
	_tmp1_.y = swipe_y_offset;
	_tmp1_.width = width;
	_tmp1_.height = height;
	allocation = _tmp1_;
	_tmp2_ = self->priv->scale_revealer;
	_tmp3_ = allocation;
	gtk_widget_size_allocate ((GtkWidget*) _tmp2_, &_tmp3_, baseline);
}

static void
tuba_views_media_viewer_real_snapshot (GtkWidget* base,
                                       GtkSnapshot* snapshot)
{
	TubaViewsMediaViewer * self;
	gdouble progress = 0.0;
	gdouble _tmp0_;
	TubaWidgetsScaleRevealer* _tmp1_;
	AdwTimedAnimation* _tmp2_;
	AdwTimedAnimation* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	TubaWidgetsScaleRevealer* _tmp12_;
	self = (TubaViewsMediaViewer*) base;
	g_return_if_fail (snapshot != NULL);
	_tmp0_ = self->priv->_swipe_progress;
	_tmp1_ = self->priv->scale_revealer;
	_tmp2_ = tuba_widgets_scale_revealer_get_animation (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = adw_animation_get_value ((AdwAnimation*) _tmp3_);
	_tmp5_ = _tmp4_;
	progress = MIN (1.0 - fabs (_tmp0_), _tmp5_);
	if (progress > 0.0) {
		GdkRGBA background_color = {0};
		GdkRGBA _tmp6_ = {0};
		graphene_rect_t bounds = {0};
		graphene_point_t _tmp7_ = {0};
		graphene_size_t _tmp8_ = {0};
		graphene_rect_t _tmp9_ = {0};
		GdkRGBA _tmp10_;
		graphene_rect_t _tmp11_;
		memset (&_tmp6_, 0, sizeof (GdkRGBA));
		_tmp6_.red = 0.0f;
		_tmp6_.green = 0.0f;
		_tmp6_.blue = 0.0f;
		_tmp6_.alpha = (gfloat) progress;
		background_color = _tmp6_;
		memset (&_tmp7_, 0, sizeof (graphene_point_t));
		_tmp7_.x = 0.0f;
		_tmp7_.y = 0.0f;
		memset (&_tmp8_, 0, sizeof (graphene_size_t));
		_tmp8_.width = (gfloat) gtk_widget_get_width ((GtkWidget*) self);
		_tmp8_.height = (gfloat) gtk_widget_get_height ((GtkWidget*) self);
		memset (&_tmp9_, 0, sizeof (graphene_rect_t));
		_tmp9_.origin = _tmp7_;
		_tmp9_.size = _tmp8_;
		bounds = _tmp9_;
		_tmp10_ = background_color;
		_tmp11_ = bounds;
		gtk_snapshot_append_color (snapshot, &_tmp10_, &_tmp11_);
	}
	_tmp12_ = self->priv->scale_revealer;
	gtk_widget_snapshot_child ((GtkWidget*) self, (GtkWidget*) _tmp12_, snapshot);
}

static gdouble
tuba_views_media_viewer_real_get_cancel_progress (AdwSwipeable* base)
{
	TubaViewsMediaViewer * self;
	gdouble result;
	self = (TubaViewsMediaViewer*) base;
	result = 0.0;
	return result;
}

static gdouble
tuba_views_media_viewer_real_get_distance (AdwSwipeable* base)
{
	TubaViewsMediaViewer * self;
	gdouble result;
	self = (TubaViewsMediaViewer*) base;
	result = (gdouble) gtk_widget_get_height ((GtkWidget*) self);
	return result;
}

static gdouble
tuba_views_media_viewer_real_get_progress (AdwSwipeable* base)
{
	TubaViewsMediaViewer * self;
	gdouble _tmp0_;
	gdouble result;
	self = (TubaViewsMediaViewer*) base;
	_tmp0_ = self->priv->_swipe_progress;
	result = _tmp0_;
	return result;
}

static gdouble*
tuba_views_media_viewer_real_get_snap_points (AdwSwipeable* base,
                                              gint* result_length1)
{
	TubaViewsMediaViewer * self;
	gdouble* _tmp0_;
	gdouble* _tmp1_;
	gint _tmp1__length1;
	gdouble* result;
	self = (TubaViewsMediaViewer*) base;
	_tmp0_ = g_new0 (gdouble, 3);
	_tmp0_[0] = -1.0;
	_tmp0_[1] = 0.0;
	_tmp0_[2] = 1.0;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static void
tuba_views_media_viewer_real_get_swipe_area (AdwSwipeable* base,
                                             AdwNavigationDirection navigation_direction,
                                             gboolean is_drag,
                                             GdkRectangle* result)
{
	TubaViewsMediaViewer * self;
	GdkRectangle _tmp0_ = {0};
	self = (TubaViewsMediaViewer*) base;
	_tmp0_.x = 0;
	_tmp0_.y = 0;
	_tmp0_.width = gtk_widget_get_width ((GtkWidget*) self);
	_tmp0_.height = gtk_widget_get_height ((GtkWidget*) self);
	*result = _tmp0_;
	return;
}

static void
tuba_views_media_viewer_on_scale_revealer_transition_end (TubaViewsMediaViewer* self)
{
	TubaWidgetsScaleRevealer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	AdwCarousel* _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scale_revealer;
	_tmp1_ = tuba_widgets_scale_revealer_get_reveal_child (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		TubaWidgetsScaleRevealer* _tmp3_;
		gtk_widget_set_visible ((GtkWidget*) self, FALSE);
		tuba_views_media_viewer_set_swipe_progress (self, 0.0);
		_tmp3_ = self->priv->scale_revealer;
		tuba_widgets_scale_revealer_set_source_widget (_tmp3_, NULL);
		tuba_views_media_viewer_reset_media_viewer (self);
		return;
	}
	self->priv->revealed = TRUE;
	if (self->priv->load_and_scroll_to != -1) {
		TubaViewsMediaViewerItem* scroll_to_widget = NULL;
		TubaViewsMediaViewerItem* _tmp4_;
		TubaViewsMediaViewerItem* _tmp5_;
		_tmp4_ = tuba_views_media_viewer_safe_get (self, self->priv->load_and_scroll_to);
		scroll_to_widget = _tmp4_;
		_tmp5_ = scroll_to_widget;
		tuba_views_media_viewer_do_todo_item (self, _tmp5_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					TubaViewsMediaViewerItem* item = NULL;
					TubaViewsMediaViewerItem* _tmp8_;
					TubaViewsMediaViewerItem* _tmp9_;
					if (!_tmp6_) {
						gint _tmp7_;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					if (!(i < self->priv->load_and_scroll_to)) {
						break;
					}
					_tmp8_ = tuba_views_media_viewer_safe_get (self, i);
					item = _tmp8_;
					_tmp9_ = item;
					if (_tmp9_ != NULL) {
						TubaViewsMediaViewerItem* _tmp10_;
						AdwCarousel* _tmp11_;
						TubaViewsMediaViewerItem* _tmp12_;
						_tmp10_ = item;
						gtk_widget_set_visible ((GtkWidget*) _tmp10_, TRUE);
						_tmp11_ = self->priv->carousel;
						_tmp12_ = scroll_to_widget;
						adw_carousel_scroll_to (_tmp11_, (GtkWidget*) _tmp12_, FALSE);
					} else {
						_g_object_unref0 (item);
						break;
					}
					_g_object_unref0 (item);
				}
			}
		}
		_g_object_unref0 (scroll_to_widget);
	}
	tuba_views_media_viewer_do_todo_items (self);
	_tmp13_ = self->priv->carousel;
	_tmp14_ = adw_carousel_get_position (_tmp13_);
	_tmp15_ = _tmp14_;
	tuba_views_media_viewer_on_carousel_page_changed (self, (guint) ((gint) _tmp15_));
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

void
tuba_views_media_viewer_on_scale_changed (TubaViewsMediaViewer* self,
                                          gdouble scale)
{
	TubaViewsMediaViewerItem* t_item = NULL;
	AdwCarousel* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	TubaViewsMediaViewerItem* _tmp3_;
	TubaViewsMediaViewerItem* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = adw_carousel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tuba_views_media_viewer_safe_get (self, (gint) _tmp2_);
	t_item = _tmp3_;
	_tmp4_ = t_item;
	if (_tmp4_ != NULL) {
		gint* _tmp5_;
		gint* _tmp10_;
		TubaViewsMediaViewerItem* _tmp15_;
		gint* _tmp16_;
		gint* _tmp17_;
		_tmp5_ = self->priv->old_height;
		if (_tmp5_ == NULL) {
			TubaViewsMediaViewerItem* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint* _tmp9_;
			_tmp6_ = t_item;
			_tmp7_ = tuba_views_media_viewer_item_get_child_height (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = __int_dup0 (&_tmp8_);
			_g_free0 (self->priv->old_height);
			self->priv->old_height = _tmp9_;
		}
		_tmp10_ = self->priv->old_width;
		if (_tmp10_ == NULL) {
			TubaViewsMediaViewerItem* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint* _tmp14_;
			_tmp11_ = t_item;
			_tmp12_ = tuba_views_media_viewer_item_get_child_width (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = __int_dup0 (&_tmp13_);
			_g_free0 (self->priv->old_width);
			self->priv->old_width = _tmp14_;
		}
		_tmp15_ = t_item;
		_tmp16_ = self->priv->old_width;
		_tmp17_ = self->priv->old_height;
		tuba_views_media_viewer_item_zoom (_tmp15_, scale, _tmp16_, _tmp17_);
	}
	_g_object_unref0 (t_item);
}

void
tuba_views_media_viewer_on_scale_end (TubaViewsMediaViewer* self,
                                      GdkEventSequence* sequence)
{
	g_return_if_fail (self != NULL);
	_g_free0 (self->priv->old_height);
	self->priv->old_height = NULL;
	_g_free0 (self->priv->old_width);
	self->priv->old_width = NULL;
}

void
tuba_views_media_viewer_on_motion (TubaViewsMediaViewer* self,
                                   gdouble x,
                                   gdouble y)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->on_motion_last_x == x) {
		_tmp0_ = self->priv->on_motion_last_y == y;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	self->priv->on_motion_last_x = x;
	self->priv->on_motion_last_y = y;
	tuba_views_media_viewer_on_reveal_media_buttons (self);
}

static gboolean
_tuba_views_media_viewer_on_hide_media_buttons_gsource_func (gpointer self)
{
	gboolean result;
	result = tuba_views_media_viewer_on_hide_media_buttons ((TubaViewsMediaViewer*) self);
	return result;
}

void
tuba_views_media_viewer_on_reveal_media_buttons (TubaViewsMediaViewer* self)
{
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	GtkRevealer* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->page_buttons_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
	_tmp1_ = self->priv->zoom_buttons_revealer;
	gtk_revealer_set_reveal_child (_tmp1_, TRUE);
	_tmp2_ = self->priv->toggle_fs_revealer;
	gtk_revealer_set_reveal_child (_tmp2_, TRUE);
	if (self->priv->revealer_timeout > ((guint) 0)) {
		g_source_remove (self->priv->revealer_timeout);
	}
	self->priv->revealer_timeout = g_timeout_add_full (G_PRIORITY_LOW, (guint) (3 * 1000), _tuba_views_media_viewer_on_hide_media_buttons_gsource_func, g_object_ref (self), g_object_unref);
}

gboolean
tuba_views_media_viewer_on_hide_media_buttons (TubaViewsMediaViewer* self)
{
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	GtkRevealer* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->page_buttons_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
	_tmp1_ = self->priv->zoom_buttons_revealer;
	gtk_revealer_set_reveal_child (_tmp1_, FALSE);
	_tmp2_ = self->priv->toggle_fs_revealer;
	gtk_revealer_set_reveal_child (_tmp2_, FALSE);
	self->priv->revealer_timeout = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static void
tuba_views_media_viewer_zoom_in_action (TubaViewsMediaViewer* self)
{
	TubaViewsMediaViewerItem* page = NULL;
	AdwCarousel* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	TubaViewsMediaViewerItem* _tmp3_;
	TubaViewsMediaViewerItem* _tmp4_;
	TubaViewsMediaViewerItem* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = adw_carousel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tuba_views_media_viewer_safe_get (self, (gint) _tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (page);
		return;
	}
	_tmp5_ = page;
	tuba_views_media_viewer_item_zoom_in (_tmp5_);
	_g_object_unref0 (page);
}

static void
tuba_views_media_viewer_zoom_out_action (TubaViewsMediaViewer* self)
{
	TubaViewsMediaViewerItem* page = NULL;
	AdwCarousel* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	TubaViewsMediaViewerItem* _tmp3_;
	TubaViewsMediaViewerItem* _tmp4_;
	TubaViewsMediaViewerItem* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = adw_carousel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tuba_views_media_viewer_safe_get (self, (gint) _tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (page);
		return;
	}
	_tmp5_ = page;
	tuba_views_media_viewer_item_zoom_out (_tmp5_);
	_g_object_unref0 (page);
}

void
tuba_views_media_viewer_clear (TubaViewsMediaViewer* self)
{
	TubaWidgetsScaleRevealer* _tmp0_;
	g_return_if_fail (self != NULL);
	if (!self->priv->revealed) {
		tuba_views_media_viewer_reset_media_viewer (self);
	}
	_tmp0_ = self->priv->scale_revealer;
	tuba_widgets_scale_revealer_set_reveal_child (_tmp0_, FALSE);
	self->priv->load_and_scroll_to = -1;
	self->priv->old_pos = (guint) 500;
}

static void
_tuba_views_media_viewer_clear_gtk_button_clicked (GtkButton* _sender,
                                                   gpointer self)
{
	tuba_views_media_viewer_clear ((TubaViewsMediaViewer*) self);
}

static void
tuba_views_media_viewer_toggle_fullscreen (TubaViewsMediaViewer* self)
{
	g_return_if_fail (self != NULL);
	tuba_views_media_viewer_set_fullscreen (self, !self->priv->_fullscreen);
}

static void
_tuba_views_media_viewer_toggle_fullscreen_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self)
{
	tuba_views_media_viewer_toggle_fullscreen ((TubaViewsMediaViewer*) self);
}

static void
tuba_views_media_viewer_copy_url (TubaViewsMediaViewer* self)
{
	TubaViewsMediaViewerItem* page = NULL;
	AdwCarousel* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	TubaViewsMediaViewerItem* _tmp3_;
	TubaViewsMediaViewerItem* _tmp4_;
	TubaViewsMediaViewerItem* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	TubaApplication* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = adw_carousel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tuba_views_media_viewer_safe_get (self, (gint) _tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (page);
		return;
	}
	_tmp5_ = page;
	_tmp6_ = tuba_views_media_viewer_item_get_url (_tmp5_);
	_tmp7_ = _tmp6_;
	tuba_utils_host_copy (_tmp7_);
	_tmp8_ = tuba_app;
	g_signal_emit_by_name (_tmp8_, "toast", _ ("Copied media url to clipboard"), (guint) 5);
	_g_object_unref0 (page);
}

static void
tuba_views_media_viewer_open_in_browser (TubaViewsMediaViewer* self)
{
	TubaViewsMediaViewerItem* page = NULL;
	AdwCarousel* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	TubaViewsMediaViewerItem* _tmp3_;
	TubaViewsMediaViewerItem* _tmp4_;
	TubaViewsMediaViewerItem* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = adw_carousel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tuba_views_media_viewer_safe_get (self, (gint) _tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (page);
		return;
	}
	_tmp5_ = page;
	_tmp6_ = tuba_views_media_viewer_item_get_url (_tmp5_);
	_tmp7_ = _tmp6_;
	tuba_utils_host_open_url (_tmp7_, NULL, NULL);
	_g_object_unref0 (page);
}

static void
tuba_views_media_viewer_save_as (TubaViewsMediaViewer* self)
{
	TubaViewsMediaViewerItem* page = NULL;
	AdwCarousel* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	TubaViewsMediaViewerItem* _tmp3_;
	TubaViewsMediaViewerItem* _tmp4_;
	TubaViewsMediaViewerItem* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = adw_carousel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tuba_views_media_viewer_safe_get (self, (gint) _tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (page);
		return;
	}
	_tmp5_ = page;
	_tmp6_ = tuba_views_media_viewer_item_get_url (_tmp5_);
	_tmp7_ = _tmp6_;
	tuba_widgets_attachment_item_save_media_as (_tmp7_, NULL, NULL);
	_g_object_unref0 (page);
}

static void
tuba_views_media_viewer_on_drag_begin (TubaViewsMediaViewer* self,
                                       gdouble x,
                                       gdouble y)
{
	TubaViewsMediaViewerItem* t_item = NULL;
	AdwCarousel* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	TubaViewsMediaViewerItem* _tmp3_;
	TubaViewsMediaViewerItem* _tmp4_;
	GtkPicture* pic = NULL;
	TubaViewsMediaViewerItem* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkPicture* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GtkPicture* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = adw_carousel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tuba_views_media_viewer_safe_get (self, (gint) _tmp2_);
	t_item = _tmp3_;
	_tmp4_ = t_item;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (t_item);
		return;
	}
	_tmp5_ = t_item;
	_tmp6_ = tuba_views_media_viewer_item_get_child_widget (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_picture_get_type ()) ? ((GtkPicture*) _tmp7_) : NULL);
	pic = _tmp8_;
	_tmp10_ = pic;
	if (_tmp10_ != NULL) {
		TubaViewsMediaViewerItem* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp11_ = t_item;
		_tmp12_ = tuba_views_media_viewer_item_get_can_zoom_out (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp9_ = _tmp13_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GtkPicture* _tmp14_;
		GdkCursor* _tmp15_;
		GdkCursor* _tmp16_;
		TubaViewsMediaViewerItem* _tmp17_;
		TubaViewsMediaViewerItem* _tmp18_;
		_tmp14_ = pic;
		_tmp15_ = gdk_cursor_new_from_name ("grabbing", NULL);
		_tmp16_ = _tmp15_;
		gtk_widget_set_cursor ((GtkWidget*) _tmp14_, _tmp16_);
		_g_object_unref0 (_tmp16_);
		_tmp17_ = t_item;
		tuba_views_media_viewer_item_set_last_x (_tmp17_, 0.0);
		_tmp18_ = t_item;
		tuba_views_media_viewer_item_set_last_y (_tmp18_, 0.0);
	}
	_g_object_unref0 (pic);
	_g_object_unref0 (t_item);
}

static void
tuba_views_media_viewer_on_drag_update (TubaViewsMediaViewer* self,
                                        gdouble x,
                                        gdouble y)
{
	TubaViewsMediaViewerItem* t_item = NULL;
	AdwCarousel* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	TubaViewsMediaViewerItem* _tmp3_;
	TubaViewsMediaViewerItem* _tmp4_;
	GtkPicture* pic = NULL;
	TubaViewsMediaViewerItem* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkPicture* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GtkPicture* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = adw_carousel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tuba_views_media_viewer_safe_get (self, (gint) _tmp2_);
	t_item = _tmp3_;
	_tmp4_ = t_item;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (t_item);
		return;
	}
	_tmp5_ = t_item;
	_tmp6_ = tuba_views_media_viewer_item_get_child_widget (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_picture_get_type ()) ? ((GtkPicture*) _tmp7_) : NULL);
	pic = _tmp8_;
	_tmp10_ = pic;
	if (_tmp10_ != NULL) {
		TubaViewsMediaViewerItem* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp11_ = t_item;
		_tmp12_ = tuba_views_media_viewer_item_get_can_zoom_out (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp9_ = _tmp13_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		TubaViewsMediaViewerItem* _tmp14_;
		TubaViewsMediaViewerItem* _tmp15_;
		TubaViewsMediaViewerItem* _tmp16_;
		_tmp14_ = t_item;
		tuba_views_media_viewer_item_update_adjustment (_tmp14_, x, y);
		_tmp15_ = t_item;
		tuba_views_media_viewer_item_set_last_x (_tmp15_, x);
		_tmp16_ = t_item;
		tuba_views_media_viewer_item_set_last_y (_tmp16_, y);
	}
	_g_object_unref0 (pic);
	_g_object_unref0 (t_item);
}

static void
tuba_views_media_viewer_on_drag_end (TubaViewsMediaViewer* self,
                                     gdouble x,
                                     gdouble y)
{
	TubaViewsMediaViewerItem* t_item = NULL;
	AdwCarousel* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	TubaViewsMediaViewerItem* _tmp3_;
	TubaViewsMediaViewerItem* _tmp4_;
	GtkPicture* pic = NULL;
	TubaViewsMediaViewerItem* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkPicture* _tmp8_;
	GtkPicture* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = adw_carousel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tuba_views_media_viewer_safe_get (self, (gint) _tmp2_);
	t_item = _tmp3_;
	_tmp4_ = t_item;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (t_item);
		return;
	}
	_tmp5_ = t_item;
	_tmp6_ = tuba_views_media_viewer_item_get_child_widget (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_picture_get_type ()) ? ((GtkPicture*) _tmp7_) : NULL);
	pic = _tmp8_;
	_tmp9_ = pic;
	if (_tmp9_ != NULL) {
		GtkPicture* _tmp10_;
		TubaViewsMediaViewerItem* _tmp11_;
		TubaViewsMediaViewerItem* _tmp12_;
		_tmp10_ = pic;
		gtk_widget_set_cursor ((GtkWidget*) _tmp10_, NULL);
		_tmp11_ = t_item;
		tuba_views_media_viewer_item_set_last_x (_tmp11_, 0.0);
		_tmp12_ = t_item;
		tuba_views_media_viewer_item_set_last_y (_tmp12_, 0.0);
	}
	_g_object_unref0 (pic);
	_g_object_unref0 (t_item);
}

static void
_tuba_views_media_viewer_handle_mouse_previous_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                                gint n_press,
                                                                                gdouble x,
                                                                                gdouble y,
                                                                                gpointer self)
{
	tuba_views_media_viewer_handle_mouse_previous_click ((TubaViewsMediaViewer*) self, n_press, x, y);
}

static void
tuba_views_media_viewer_setup_mouse_previous_click (TubaViewsMediaViewer* self)
{
	GtkGestureClick* gesture = NULL;
	GtkGestureClick* _tmp0_;
	GtkEventController* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkGestureClick*) gtk_gesture_click_new ();
	gesture = _tmp0_;
	gtk_gesture_single_set_button ((GtkGestureSingle*) gesture, (guint) 8);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) gesture, GTK_PHASE_CAPTURE);
	g_signal_connect_object (gesture, "pressed", (GCallback) _tuba_views_media_viewer_handle_mouse_previous_click_gtk_gesture_click_pressed, self, 0);
	_tmp1_ = _g_object_ref0 ((GtkEventController*) gesture);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp1_);
	_g_object_unref0 (gesture);
}

static void
_tuba_views_media_viewer_on_secondary_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                       gint n_press,
                                                                       gdouble x,
                                                                       gdouble y,
                                                                       gpointer self)
{
	tuba_views_media_viewer_on_secondary_click ((TubaViewsMediaViewer*) self, n_press, x, y);
}

static void
tuba_views_media_viewer_setup_mouse_secondary_click (TubaViewsMediaViewer* self)
{
	GtkGestureClick* gesture = NULL;
	GtkGestureClick* _tmp0_ = NULL;
	GtkEventController* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkGestureClick*) gtk_gesture_click_new ();
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp0_, (guint) GDK_BUTTON_SECONDARY);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp0_, GTK_PHASE_CAPTURE);
	gesture = _tmp0_;
	g_signal_connect_object (gesture, "pressed", (GCallback) _tuba_views_media_viewer_on_secondary_click_gtk_gesture_click_pressed, self, 0);
	_tmp1_ = _g_object_ref0 ((GtkEventController*) gesture);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp1_);
	_g_object_unref0 (gesture);
}

static void
_tuba_views_media_viewer_on_mouse1_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                    gint n_press,
                                                                    gdouble x,
                                                                    gdouble y,
                                                                    gpointer self)
{
	tuba_views_media_viewer_on_mouse1_click ((TubaViewsMediaViewer*) self, n_press, x, y);
}

static void
tuba_views_media_viewer_setup_mouse1_click (TubaViewsMediaViewer* self)
{
	GtkGestureClick* gesture = NULL;
	GtkGestureClick* _tmp0_ = NULL;
	GtkEventController* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkGestureClick*) gtk_gesture_click_new ();
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp0_, (guint) 1);
	gesture = _tmp0_;
	g_signal_connect_object (gesture, "pressed", (GCallback) _tuba_views_media_viewer_on_mouse1_click_gtk_gesture_click_pressed, self, 0);
	_tmp1_ = _g_object_ref0 ((GtkEventController*) gesture);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp1_);
	_g_object_unref0 (gesture);
}

static void
tuba_views_media_viewer_on_secondary_click (TubaViewsMediaViewer* self,
                                            gint n_press,
                                            gdouble x,
                                            gdouble y)
{
	GdkRectangle rectangle = {0};
	GdkRectangle _tmp0_ = {0};
	GtkPopoverMenu* _tmp1_;
	GdkRectangle _tmp2_;
	GtkPopoverMenu* _tmp3_;
	g_return_if_fail (self != NULL);
	g_debug ("MediaViewer.vala:906: Context menu triggered");
	_tmp0_.x = (gint) x;
	_tmp0_.y = (gint) y;
	_tmp0_.width = 0;
	_tmp0_.height = 0;
	rectangle = _tmp0_;
	_tmp1_ = self->priv->context_menu;
	_tmp2_ = rectangle;
	gtk_popover_set_pointing_to ((GtkPopover*) _tmp1_, &_tmp2_);
	_tmp3_ = self->priv->context_menu;
	gtk_popover_popup ((GtkPopover*) _tmp3_);
}

static void
tuba_views_media_viewer_handle_mouse_previous_click (TubaViewsMediaViewer* self,
                                                     gint n_press,
                                                     gdouble x,
                                                     gdouble y)
{
	g_return_if_fail (self != NULL);
	tuba_views_media_viewer_clear (self);
}

static void
tuba_views_media_viewer_on_mouse1_click (TubaViewsMediaViewer* self,
                                         gint n_press,
                                         gdouble x,
                                         gdouble y)
{
	g_return_if_fail (self != NULL);
	switch (n_press) {
		case 1:
		{
			tuba_views_media_viewer_on_reveal_media_buttons (self);
			break;
		}
		case 2:
		{
			TubaViewsMediaViewerItem* page = NULL;
			AdwCarousel* _tmp0_;
			gdouble _tmp1_;
			gdouble _tmp2_;
			TubaViewsMediaViewerItem* _tmp3_;
			TubaViewsMediaViewerItem* _tmp4_;
			TubaViewsMediaViewerItem* _tmp5_;
			_tmp0_ = self->priv->carousel;
			_tmp1_ = adw_carousel_get_position (_tmp0_);
			_tmp2_ = _tmp1_;
			_tmp3_ = tuba_views_media_viewer_safe_get (self, (gint) _tmp2_);
			page = _tmp3_;
			_tmp4_ = page;
			if (_tmp4_ == NULL) {
				_g_object_unref0 (page);
				break;
			}
			_tmp5_ = page;
			tuba_views_media_viewer_item_on_double_click (_tmp5_);
			_g_object_unref0 (page);
			break;
		}
		default:
		break;
	}
}

static gboolean
__lambda35_ (TubaViewsMediaViewer* self,
             TubaViewsMediaViewerItem* item)
{
	AdwCarousel* _tmp0_;
	gboolean result;
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = self->priv->carousel;
	adw_carousel_remove (_tmp0_, (GtkWidget*) item);
	result = TRUE;
	_g_object_unref0 (item);
	return result;
}

static gboolean
___lambda35__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda35_ ((TubaViewsMediaViewer*) self, (TubaViewsMediaViewerItem*) g);
	return result;
}

static void
tuba_views_media_viewer_reset_media_viewer (TubaViewsMediaViewer* self)
{
	GeeHashMap* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->revealer_widgets;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	tuba_views_media_viewer_set_fullscreen (self, FALSE);
	_tmp1_ = self->priv->todo_items;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	_tmp2_ = self->priv->items;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp2_, ___lambda35__gee_forall_func, self);
	_tmp3_ = self->priv->items;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp3_);
	self->priv->revealed = FALSE;
	tuba_views_media_viewer_clapper_cache_cleanup (self, FALSE);
}

static void
tuba_views_media_viewer_update_revealer_widget (TubaViewsMediaViewer* self,
                                                gint pos)
{
	gint _tmp0_ = 0;
	gint new_pos = 0;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	if (pos == -1) {
		AdwCarousel* _tmp1_;
		gdouble _tmp2_;
		gdouble _tmp3_;
		_tmp1_ = self->priv->carousel;
		_tmp2_ = adw_carousel_get_position (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = (gint) _tmp3_;
	} else {
		_tmp0_ = pos;
	}
	new_pos = _tmp0_;
	if (self->priv->revealed) {
		GeeHashMap* _tmp5_;
		_tmp5_ = self->revealer_widgets;
		_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, (gpointer) ((gintptr) new_pos));
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		TubaWidgetsScaleRevealer* _tmp6_;
		GeeHashMap* _tmp7_;
		gpointer _tmp8_;
		GtkWidget* _tmp9_;
		_tmp6_ = self->priv->scale_revealer;
		_tmp7_ = self->revealer_widgets;
		_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, (gpointer) ((gintptr) new_pos));
		_tmp9_ = (GtkWidget*) _tmp8_;
		tuba_widgets_scale_revealer_set_source_widget (_tmp6_, _tmp9_);
		_g_object_unref0 (_tmp9_);
	}
}

void
tuba_views_media_viewer_reveal (TubaViewsMediaViewer* self,
                                GtkWidget* widget)
{
	TubaWidgetsScaleRevealer* _tmp0_;
	TubaWidgetsScaleRevealer* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->revealed) {
		return;
	}
	gtk_widget_set_visible ((GtkWidget*) self, TRUE);
	_tmp0_ = self->priv->scale_revealer;
	tuba_widgets_scale_revealer_set_source_widget (_tmp0_, widget);
	_tmp1_ = self->priv->scale_revealer;
	tuba_widgets_scale_revealer_set_reveal_child (_tmp1_, TRUE);
}

static Block83Data*
block83_data_ref (Block83Data* _data83_)
{
	g_atomic_int_inc (&_data83_->_ref_count_);
	return _data83_;
}

static void
block83_data_unref (void * _userdata_)
{
	Block83Data* _data83_;
	_data83_ = (Block83Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data83_->_ref_count_)) {
		TubaViewsMediaViewer* self;
		self = _data83_->self;
		_g_object_unref0 (_data83_->item);
		_g_object_unref0 (self);
		g_slice_free (Block83Data, _data83_);
	}
}

static void
_tuba_views_media_viewer_on_clapper_download_complete_clapper_player_download_complete (ClapperPlayer* _sender,
                                                                                        ClapperMediaItem* item,
                                                                                        const gchar* location,
                                                                                        gpointer self)
{
	tuba_views_media_viewer_on_clapper_download_complete ((TubaViewsMediaViewer*) self, item, location);
}

static Block84Data*
block84_data_ref (Block84Data* _data84_)
{
	g_atomic_int_inc (&_data84_->_ref_count_);
	return _data84_;
}

static void
block84_data_unref (void * _userdata_)
{
	Block84Data* _data84_;
	_data84_ = (Block84Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data84_->_ref_count_)) {
		TubaViewsMediaViewer* self;
		self = _data84_->_data83_->self;
		_g_object_unref0 (_data84_->picture);
		block83_data_unref (_data84_->_data83_);
		_data84_->_data83_ = NULL;
		g_slice_free (Block84Data, _data84_);
	}
}

static void
_tuba_views_media_viewer_on_zoom_change_tuba_views_media_viewer_item_zoom_changed (TubaViewsMediaViewerItem* _sender,
                                                                                   gpointer self)
{
	tuba_views_media_viewer_on_zoom_change ((TubaViewsMediaViewer*) self);
}

static void
_____lambda41_ (Block84Data* _data84_,
                GdkPaintable* data)
{
	Block83Data* _data83_;
	TubaViewsMediaViewer* self;
	GtkPicture* _tmp0_;
	_data83_ = _data84_->_data83_;
	self = _data83_->self;
	_tmp0_ = _data84_->picture;
	gtk_picture_set_paintable (_tmp0_, data);
	if (data != NULL) {
		TubaViewsMediaViewerItem* _tmp1_;
		_tmp1_ = _data83_->item;
		tuba_views_media_viewer_add_todo_item (self, _tmp1_);
	}
}

static void
______lambda41__tuba_helper_image_on_item_changed_fn (GdkPaintable* data,
                                                      gpointer self)
{
	_____lambda41_ (self, data);
}

static gboolean
_bool_equal (const gboolean * s1,
             const gboolean * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

void
tuba_views_media_viewer_add_media (TubaViewsMediaViewer* self,
                                   const gchar* url,
                                   TubaAttachmentMediaType media_type,
                                   GdkPaintable* preview,
                                   gboolean as_is,
                                   const gchar* alt_text,
                                   const gchar* user_friendly_url,
                                   const gchar* blurhash,
                                   gboolean stream,
                                   GtkWidget* revealer_widget,
                                   gboolean* load_and_scroll)
{
	Block83Data* _data83_;
	const gchar* _tmp0_ = NULL;
	gchar* final_friendly_url = NULL;
	gchar* _tmp1_;
	GdkPaintable* _tmp2_ = NULL;
	GdkPaintable* final_preview = NULL;
	GdkPaintable* _tmp3_;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_;
	gboolean _tmp82_;
	AdwCarousel* _tmp86_;
	TubaViewsMediaViewerItem* _tmp87_;
	GeeArrayList* _tmp88_;
	TubaViewsMediaViewerItem* _tmp89_;
	gboolean _tmp90_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (url != NULL);
	_data83_ = g_slice_new0 (Block83Data);
	_data83_->_ref_count_ = 1;
	_data83_->self = g_object_ref (self);
	if (user_friendly_url == NULL) {
		_tmp0_ = url;
	} else {
		_tmp0_ = user_friendly_url;
	}
	_tmp1_ = g_strdup (_tmp0_);
	final_friendly_url = _tmp1_;
	if (as_is) {
		_tmp2_ = NULL;
	} else {
		_tmp2_ = preview;
	}
	_tmp3_ = _g_object_ref0 (_tmp2_);
	final_preview = _tmp3_;
	if (revealer_widget != NULL) {
		GeeHashMap* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp4_ = self->revealer_widgets;
		_tmp5_ = self->priv->items;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, (gpointer) ((gintptr) _tmp7_), revealer_widget);
	}
	if (media_type == TUBA_ATTACHMENT_MEDIA_TYPE_AUDIO) {
		TubaWidgetsAudioPlayer* audio_player = NULL;
		gchar* _tmp8_;
		TubaWidgetsAudioPlayer* _tmp9_ = NULL;
		TubaWidgetsAudioPlayer* _tmp10_;
		const gchar* _tmp11_;
		GdkPaintable* _tmp12_;
		TubaViewsMediaViewerItem* _tmp13_;
		_tmp8_ = g_strdup (url);
		_tmp9_ = tuba_widgets_audio_player_new (G_TYPE_CHECK_INSTANCE_TYPE (preview, gdk_texture_get_type ()) ? ((GdkTexture*) preview) : NULL, blurhash);
		tuba_widgets_audio_player_set_url (_tmp9_, _tmp8_);
		_g_free0 (_tmp8_);
		g_object_ref_sink (_tmp9_);
		audio_player = _tmp9_;
		_tmp10_ = audio_player;
		_tmp11_ = final_friendly_url;
		_tmp12_ = final_preview;
		_tmp13_ = tuba_views_media_viewer_item_new ((GtkWidget*) _tmp10_, _tmp11_, _tmp12_, FALSE, TRUE);
		g_object_ref_sink (_tmp13_);
		_g_object_unref0 (_data83_->item);
		_data83_->item = _tmp13_;
		_g_object_unref0 (audio_player);
	} else {
		if (tuba_attachment_media_type_is_video (media_type)) {
			ClapperGtkVideo* video = NULL;
			ClapperGtkVideo* _tmp14_ = NULL;
			ClapperGtkVideo* _tmp15_;
			ClapperPlayer* _tmp16_;
			ClapperPlayer* _tmp17_;
			const gchar* _tmp18_;
			ClapperGtkVideo* _tmp19_;
			ClapperPlayer* _tmp20_;
			ClapperPlayer* _tmp21_;
			ClapperGtkVideo* _tmp22_;
			ClapperPlayer* _tmp23_;
			ClapperPlayer* _tmp24_;
			ClapperGtkVideo* _tmp45_;
			const gchar* _tmp46_;
			GdkPaintable* _tmp47_;
			TubaViewsMediaViewerItem* _tmp48_;
			ClapperMediaItem* clp_item = NULL;
			GeeHashMap* _tmp49_;
			gpointer _tmp50_;
			gchar* _tmp51_;
			ClapperMediaItem* _tmp52_;
			ClapperGtkVideo* _tmp53_;
			ClapperPlayer* _tmp54_;
			ClapperPlayer* _tmp55_;
			ClapperQueue* _tmp56_;
			ClapperQueue* _tmp57_;
			ClapperMediaItem* _tmp58_;
			ClapperGtkVideo* _tmp59_;
			ClapperPlayer* _tmp60_;
			ClapperPlayer* _tmp61_;
			ClapperQueue* _tmp62_;
			ClapperQueue* _tmp63_;
			ClapperMediaItem* _tmp64_;
			TubaViewsMediaViewerItem* _tmp65_;
			_tmp14_ = (ClapperGtkVideo*) clapper_gtk_video_new ();
			clapper_gtk_av_set_auto_inhibit ((ClapperGtkAv*) _tmp14_, TRUE);
			g_object_ref_sink (_tmp14_);
			video = _tmp14_;
			_tmp15_ = video;
			_tmp16_ = clapper_gtk_av_get_player ((ClapperGtkAv*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = self->priv->clapper_cache_dir;
			clapper_player_set_download_dir (_tmp17_, _tmp18_);
			_tmp19_ = video;
			_tmp20_ = clapper_gtk_av_get_player ((ClapperGtkAv*) _tmp19_);
			_tmp21_ = _tmp20_;
			clapper_player_set_download_enabled (_tmp21_, TRUE);
			_tmp22_ = video;
			_tmp23_ = clapper_gtk_av_get_player ((ClapperGtkAv*) _tmp22_);
			_tmp24_ = _tmp23_;
			g_signal_connect_object (_tmp24_, "download-complete", (GCallback) _tuba_views_media_viewer_on_clapper_download_complete_clapper_player_download_complete, self, 0);
			if (media_type == TUBA_ATTACHMENT_MEDIA_TYPE_GIFV) {
				ClapperGtkVideo* _tmp25_;
				ClapperPlayer* _tmp26_;
				ClapperPlayer* _tmp27_;
				ClapperQueue* _tmp28_;
				ClapperQueue* _tmp29_;
				_tmp25_ = video;
				_tmp26_ = clapper_gtk_av_get_player ((ClapperGtkAv*) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = clapper_player_get_queue (_tmp27_);
				_tmp29_ = _tmp28_;
				clapper_queue_set_progression_mode (_tmp29_, CLAPPER_QUEUE_PROGRESSION_REPEAT_ITEM);
			} else {
				ClapperGtkVideo* _tmp30_;
				ClapperPlayer* _tmp31_;
				ClapperPlayer* _tmp32_;
				GeeArrayList* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				ClapperMpris* _tmp40_;
				ClapperMpris* _tmp41_;
				ClapperGtkVideo* _tmp42_;
				ClapperGtkSimpleControls* _tmp43_ = NULL;
				ClapperGtkSimpleControls* _tmp44_;
				_tmp30_ = video;
				_tmp31_ = clapper_gtk_av_get_player ((ClapperGtkAv*) _tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = self->priv->items;
				_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = g_strdup_printf ("%i", _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = g_strconcat ("org.mpris.MediaPlayer2.Tuba.instance", _tmp37_, NULL);
				_tmp39_ = _tmp38_;
				_tmp40_ = clapper_mpris_new (_tmp39_, BUILD_NAME, BUILD_DOMAIN);
				g_object_ref_sink (_tmp40_);
				_tmp41_ = _tmp40_;
				clapper_player_add_feature (_tmp32_, (ClapperFeature*) _tmp41_);
				_g_object_unref0 (_tmp41_);
				_g_free0 (_tmp39_);
				_g_free0 (_tmp37_);
				_tmp42_ = video;
				_tmp43_ = (ClapperGtkSimpleControls*) clapper_gtk_simple_controls_new ();
				gtk_widget_set_valign ((GtkWidget*) _tmp43_, GTK_ALIGN_END);
				clapper_gtk_simple_controls_set_fullscreenable (_tmp43_, FALSE);
				g_object_ref_sink (_tmp43_);
				_tmp44_ = _tmp43_;
				clapper_gtk_video_add_fading_overlay (_tmp42_, (GtkWidget*) _tmp44_);
				_g_object_unref0 (_tmp44_);
			}
			_tmp45_ = video;
			_tmp46_ = final_friendly_url;
			_tmp47_ = final_preview;
			_tmp48_ = tuba_views_media_viewer_item_new ((GtkWidget*) _tmp45_, _tmp46_, _tmp47_, TRUE, FALSE);
			g_object_ref_sink (_tmp48_);
			_g_object_unref0 (_data83_->item);
			_data83_->item = _tmp48_;
			_tmp49_ = self->priv->clapper_cached_urls;
			_tmp50_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp49_, url);
			_tmp51_ = (gchar*) _tmp50_;
			_tmp52_ = clapper_media_item_new_cached (url, _tmp51_);
			g_object_ref_sink (_tmp52_);
			_g_object_unref0 (clp_item);
			clp_item = _tmp52_;
			_g_free0 (_tmp51_);
			_tmp53_ = video;
			_tmp54_ = clapper_gtk_av_get_player ((ClapperGtkAv*) _tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = clapper_player_get_queue (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = clp_item;
			clapper_queue_add_item (_tmp57_, _tmp58_);
			_tmp59_ = video;
			_tmp60_ = clapper_gtk_av_get_player ((ClapperGtkAv*) _tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = clapper_player_get_queue (_tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = clp_item;
			clapper_queue_select_item (_tmp63_, _tmp64_);
			_tmp65_ = _data83_->item;
			tuba_views_media_viewer_add_todo_item (self, _tmp65_);
			_g_object_unref0 (clp_item);
			_g_object_unref0 (video);
		} else {
			Block84Data* _data84_;
			GtkPicture* _tmp66_;
			TubaSettings* _tmp67_;
			gboolean _tmp68_;
			gboolean _tmp69_;
			GtkPicture* _tmp72_;
			const gchar* _tmp73_;
			GdkPaintable* _tmp74_;
			TubaViewsMediaViewerItem* _tmp75_;
			TubaViewsMediaViewerItem* _tmp76_;
			_data84_ = g_slice_new0 (Block84Data);
			_data84_->_ref_count_ = 1;
			_data84_->_data83_ = block83_data_ref (_data83_);
			_tmp66_ = (GtkPicture*) gtk_picture_new ();
			g_object_ref_sink (_tmp66_);
			_data84_->picture = _tmp66_;
			_tmp67_ = tuba_settings;
			_tmp68_ = tuba_settings_get_media_viewer_expand_pictures (_tmp67_);
			_tmp69_ = _tmp68_;
			if (!_tmp69_) {
				GtkPicture* _tmp70_;
				GtkPicture* _tmp71_;
				_tmp70_ = _data84_->picture;
				_tmp71_ = _data84_->picture;
				gtk_widget_set_halign ((GtkWidget*) _tmp71_, GTK_ALIGN_CENTER);
				gtk_widget_set_valign ((GtkWidget*) _tmp70_, GTK_ALIGN_CENTER);
			}
			_tmp72_ = _data84_->picture;
			_tmp73_ = final_friendly_url;
			_tmp74_ = final_preview;
			_tmp75_ = tuba_views_media_viewer_item_new ((GtkWidget*) _tmp72_, _tmp73_, _tmp74_, FALSE, FALSE);
			g_object_ref_sink (_tmp75_);
			_g_object_unref0 (_data83_->item);
			_data83_->item = _tmp75_;
			_tmp76_ = _data83_->item;
			g_signal_connect_object (_tmp76_, "zoom-changed", (GCallback) _tuba_views_media_viewer_on_zoom_change_tuba_views_media_viewer_item_zoom_changed, self, 0);
			if (alt_text != NULL) {
				GtkPicture* _tmp77_;
				_tmp77_ = _data84_->picture;
				gtk_picture_set_alternative_text (_tmp77_, alt_text);
			}
			if (!as_is) {
				tuba_helper_image_request_paintable (url, NULL, FALSE, ______lambda41__tuba_helper_image_on_item_changed_fn, block84_data_ref (_data84_), block84_data_unref);
			} else {
				GtkPicture* _tmp78_;
				_tmp78_ = _data84_->picture;
				gtk_picture_set_paintable (_tmp78_, preview);
			}
			block84_data_unref (_data84_);
			_data84_ = NULL;
		}
	}
	_tmp80_ = FALSE;
	if (_bool_equal (load_and_scroll, &_tmp80_) == TRUE) {
		_tmp79_ = self->priv->load_and_scroll_to == -1;
	} else {
		_tmp79_ = FALSE;
	}
	if (_tmp79_) {
		TubaViewsMediaViewerItem* _tmp81_;
		_tmp81_ = _data83_->item;
		gtk_widget_set_visible ((GtkWidget*) _tmp81_, FALSE);
	}
	_tmp82_ = TRUE;
	if (_bool_equal (load_and_scroll, &_tmp82_) == TRUE) {
		GeeArrayList* _tmp83_;
		gint _tmp84_;
		gint _tmp85_;
		_tmp83_ = self->priv->items;
		_tmp84_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp83_);
		_tmp85_ = _tmp84_;
		self->priv->load_and_scroll_to = _tmp85_;
	}
	_tmp86_ = self->priv->carousel;
	_tmp87_ = _data83_->item;
	adw_carousel_append (_tmp86_, (GtkWidget*) _tmp87_);
	_tmp88_ = self->priv->items;
	_tmp89_ = _data83_->item;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp88_, _tmp89_);
	if (as_is) {
		_tmp90_ = TRUE;
	} else {
		_tmp90_ = stream;
	}
	if (_tmp90_) {
		TubaViewsMediaViewerItem* _tmp91_;
		_tmp91_ = _data83_->item;
		tuba_views_media_viewer_add_todo_item (self, _tmp91_);
	}
	_g_object_unref0 (final_preview);
	_g_free0 (final_friendly_url);
	block83_data_unref (_data83_);
	_data83_ = NULL;
}

static void
tuba_views_media_viewer_on_clapper_download_complete (TubaViewsMediaViewer* self,
                                                      ClapperMediaItem* clp_media_item,
                                                      const gchar* location)
{
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GeeArrayList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clp_media_item != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = self->priv->clapper_cached_urls;
	_tmp1_ = clapper_media_item_get_uri (clp_media_item);
	_tmp2_ = _tmp1_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, _tmp2_, location);
	_tmp3_ = self->priv->clapper_cached_locations;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, location);
}

static gboolean
____lambda36_ (TubaViewsMediaViewer* self,
               GeeMapEntry* e)
{
	GeeArrayList* _tmp0_;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->priv->clapper_cached_locations;
	_tmp1_ = gee_map_entry_get_value (e);
	_tmp2_ = _tmp1_;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, (const gchar*) _tmp2_)) {
		GeeHashMap* _tmp3_;
		gconstpointer _tmp4_;
		gconstpointer _tmp5_;
		_tmp3_ = self->priv->clapper_cached_urls;
		_tmp4_ = gee_map_entry_get_key (e);
		_tmp5_ = _tmp4_;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, (const gchar*) _tmp5_, NULL);
	}
	result = TRUE;
	_g_object_unref0 (e);
	return result;
}

static gboolean
_____lambda36__gee_forall_func (gpointer g,
                                gpointer self)
{
	gboolean result;
	result = ____lambda36_ ((TubaViewsMediaViewer*) self, (GeeMapEntry*) g);
	return result;
}

static Block85Data*
block85_data_ref (Block85Data* _data85_)
{
	g_atomic_int_inc (&_data85_->_ref_count_);
	return _data85_;
}

static void
block85_data_unref (void * _userdata_)
{
	Block85Data* _data85_;
	_data85_ = (Block85Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data85_->_ref_count_)) {
		TubaViewsMediaViewer* self;
		self = _data85_->self;
		_g_object_unref0 (_data85_->file);
		_g_object_unref0 (self);
		g_slice_free (Block85Data, _data85_);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
____lambda37_ (Block85Data* _data85_,
               GObject* obj,
               GAsyncResult* res)
{
	TubaViewsMediaViewer* self;
	GError* _inner_error0_ = NULL;
	self = _data85_->self;
	g_return_if_fail (res != NULL);
	{
		GFile* _tmp0_;
		_tmp0_ = _data85_->file;
		g_file_delete_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("Error while deleting Clapper's cache: ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		g_warning ("MediaViewer.vala:1140: %s", _tmp5_);
		_g_free0 (_tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_____lambda37__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda37_ (self, source_object, res);
	block85_data_unref (self);
}

static void
tuba_views_media_viewer_clapper_cache_cleanup (TubaViewsMediaViewer* self,
                                               gboolean all)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (!all) {
		gint to_remove = 0;
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		_tmp0_ = self->priv->clapper_cached_locations;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		to_remove = _tmp2_ - 10;
		if (to_remove > 0) {
			GeeList* sliced = NULL;
			GeeArrayList* _tmp3_;
			GeeList* _tmp4_;
			GeeArrayList* _tmp5_;
			GeeList* _tmp6_;
			GeeHashMap* _tmp7_;
			_tmp3_ = self->priv->clapper_cached_locations;
			_tmp4_ = gee_abstract_list_slice ((GeeAbstractList*) _tmp3_, 0, to_remove);
			sliced = _tmp4_;
			_tmp5_ = self->priv->clapper_cached_locations;
			_tmp6_ = sliced;
			gee_collection_remove_all ((GeeCollection*) _tmp5_, (GeeCollection*) _tmp6_);
			_tmp7_ = self->priv->clapper_cached_urls;
			gee_abstract_map_foreach ((GeeAbstractMap*) _tmp7_, _____lambda36__gee_forall_func, self);
			_g_object_unref0 (sliced);
		}
	}
	{
		GDir* dir = NULL;
		const gchar* _tmp8_;
		GDir* _tmp9_;
		gchar* name = NULL;
		_tmp8_ = self->priv->clapper_cache_dir;
		_tmp9_ = g_dir_open (_tmp8_, (guint) 0, &_inner_error0_);
		dir = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		name = NULL;
		while (TRUE) {
			Block85Data* _data85_;
			GDir* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* path = NULL;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gboolean _tmp17_ = FALSE;
			const gchar* _tmp20_;
			GFile* _tmp21_;
			GFile* _tmp22_;
			_data85_ = g_slice_new0 (Block85Data);
			_data85_->_ref_count_ = 1;
			_data85_->self = g_object_ref (self);
			_tmp10_ = dir;
			_tmp11_ = g_dir_read_name (_tmp10_);
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (name);
			name = _tmp12_;
			_tmp13_ = name;
			if (!(_tmp13_ != NULL)) {
				block85_data_unref (_data85_);
				_data85_ = NULL;
				break;
			}
			_tmp14_ = self->priv->clapper_cache_dir;
			_tmp15_ = name;
			_tmp16_ = g_build_filename (_tmp14_, _tmp15_, NULL);
			path = _tmp16_;
			if (!all) {
				GeeArrayList* _tmp18_;
				const gchar* _tmp19_;
				_tmp18_ = self->priv->clapper_cached_locations;
				_tmp19_ = path;
				_tmp17_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp18_, _tmp19_);
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				_g_free0 (path);
				block85_data_unref (_data85_);
				_data85_ = NULL;
				continue;
			}
			_tmp20_ = path;
			_tmp21_ = g_file_new_for_path (_tmp20_);
			_data85_->file = _tmp21_;
			_tmp22_ = _data85_->file;
			g_file_delete_async (_tmp22_, G_PRIORITY_LOW, NULL, _____lambda37__gasync_ready_callback, block85_data_ref (_data85_));
			_g_free0 (path);
			block85_data_unref (_data85_);
			_data85_ = NULL;
		}
		_g_free0 (name);
		_g_dir_close0 (dir);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = g_strconcat ("Error while opening Clapper's cache: ", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		g_warning ("MediaViewer.vala:1145: %s", _tmp27_);
		_g_free0 (_tmp27_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
tuba_views_media_viewer_add_todo_item (TubaViewsMediaViewer* self,
                                       TubaViewsMediaViewerItem* todo_item)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (todo_item != NULL);
	if (self->priv->revealed) {
		tuba_views_media_viewer_item_done (todo_item);
	} else {
		GeeArrayList* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = self->priv->todo_items;
		_tmp1_ = tuba_views_media_viewer_item_get_url (todo_item);
		_tmp2_ = _tmp1_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp2_);
	}
}

static void
tuba_views_media_viewer_do_todo_item (TubaViewsMediaViewer* self,
                                      TubaViewsMediaViewerItem* item)
{
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	tuba_views_media_viewer_item_done (item);
	_tmp0_ = self->priv->todo_items;
	_tmp1_ = tuba_views_media_viewer_item_get_url (item);
	_tmp2_ = _tmp1_;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp2_);
}

static gboolean
__lambda38_ (TubaViewsMediaViewer* self,
             TubaViewsMediaViewerItem* item)
{
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = self->priv->todo_items;
	_tmp1_ = tuba_views_media_viewer_item_get_url (item);
	_tmp2_ = _tmp1_;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp2_)) {
		tuba_views_media_viewer_do_todo_item (self, item);
	}
	result = TRUE;
	_g_object_unref0 (item);
	return result;
}

static gboolean
___lambda38__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda38_ ((TubaViewsMediaViewer*) self, (TubaViewsMediaViewerItem*) g);
	return result;
}

static void
tuba_views_media_viewer_do_todo_items (TubaViewsMediaViewer* self)
{
	gboolean _tmp0_ = FALSE;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->todo_items;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		_tmp0_ = TRUE;
	} else {
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = self->priv->items;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp7_ = self->priv->items;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp7_, ___lambda38__gee_forall_func, self);
}

void
tuba_views_media_viewer_scroll_to (TubaViewsMediaViewer* self,
                                   gint pos,
                                   gboolean animate)
{
	gboolean _tmp0_ = FALSE;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	AdwCarousel* _tmp4_;
	AdwCarousel* _tmp5_;
	GtkWidget* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->items;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (pos >= _tmp3_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = pos < 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->carousel;
	_tmp5_ = self->priv->carousel;
	_tmp6_ = adw_carousel_get_nth_page (_tmp5_, (guint) pos);
	adw_carousel_scroll_to (_tmp4_, _tmp6_, animate);
}

static void
tuba_views_media_viewer_on_previous_clicked (TubaViewsMediaViewer* self)
{
	AdwCarousel* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = adw_carousel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	tuba_views_media_viewer_scroll_to (self, ((gint) _tmp2_) - 1, TRUE);
}

static void
_tuba_views_media_viewer_on_previous_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self)
{
	tuba_views_media_viewer_on_previous_clicked ((TubaViewsMediaViewer*) self);
}

static void
tuba_views_media_viewer_on_next_clicked (TubaViewsMediaViewer* self)
{
	AdwCarousel* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = adw_carousel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	tuba_views_media_viewer_scroll_to (self, ((gint) _tmp2_) + 1, TRUE);
}

static void
_tuba_views_media_viewer_on_next_clicked_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self)
{
	tuba_views_media_viewer_on_next_clicked ((TubaViewsMediaViewer*) self);
}

static void
tuba_views_media_viewer_on_zoom_out_clicked (TubaViewsMediaViewer* self)
{
	TubaViewsMediaViewerItem* page = NULL;
	AdwCarousel* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	TubaViewsMediaViewerItem* _tmp3_;
	TubaViewsMediaViewerItem* _tmp4_;
	TubaViewsMediaViewerItem* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = adw_carousel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tuba_views_media_viewer_safe_get (self, (gint) _tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (page);
		return;
	}
	_tmp5_ = page;
	tuba_views_media_viewer_item_zoom_out (_tmp5_);
	_g_object_unref0 (page);
}

static void
_tuba_views_media_viewer_on_zoom_out_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self)
{
	tuba_views_media_viewer_on_zoom_out_clicked ((TubaViewsMediaViewer*) self);
}

static void
tuba_views_media_viewer_on_zoom_in_clicked (TubaViewsMediaViewer* self)
{
	TubaViewsMediaViewerItem* page = NULL;
	AdwCarousel* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	TubaViewsMediaViewerItem* _tmp3_;
	TubaViewsMediaViewerItem* _tmp4_;
	TubaViewsMediaViewerItem* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = adw_carousel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tuba_views_media_viewer_safe_get (self, (gint) _tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (page);
		return;
	}
	_tmp5_ = page;
	tuba_views_media_viewer_item_zoom_in (_tmp5_);
	_g_object_unref0 (page);
}

static void
_tuba_views_media_viewer_on_zoom_in_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self)
{
	tuba_views_media_viewer_on_zoom_in_clicked ((TubaViewsMediaViewer*) self);
}

static void
tuba_views_media_viewer_on_carousel_page_changed (TubaViewsMediaViewer* self,
                                                  guint pos)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	TubaViewsMediaViewerItem* page = NULL;
	TubaViewsMediaViewerItem* _tmp5_;
	gboolean _tmp6_ = FALSE;
	TubaViewsMediaViewerItem* _tmp7_;
	g_return_if_fail (self != NULL);
	if (self->priv->old_pos == pos) {
		return;
	}
	self->priv->old_pos = pos;
	tuba_views_media_viewer_update_revealer_widget (self, (gint) pos);
	_tmp0_ = self->priv->prev_btn;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, pos > ((guint) 0));
	_tmp1_ = self->priv->next_btn;
	_tmp2_ = self->priv->items;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, pos < ((guint) (_tmp4_ - 1)));
	_tmp5_ = tuba_views_media_viewer_safe_get (self, (gint) pos);
	page = _tmp5_;
	_tmp7_ = page;
	if (_tmp7_ != NULL) {
		gboolean _tmp8_ = FALSE;
		TubaViewsMediaViewerItem* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = page;
		_tmp10_ = tuba_views_media_viewer_item_get_is_video (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_) {
			_tmp8_ = TRUE;
		} else {
			TubaViewsMediaViewerItem* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			_tmp12_ = page;
			_tmp13_ = tuba_views_media_viewer_item_get_is_audio (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp8_ = _tmp14_;
		}
		_tmp6_ = _tmp8_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GtkRevealer* _tmp15_;
		GtkRevealer* _tmp16_;
		GtkRevealer* _tmp17_;
		GSimpleAction* _tmp18_;
		_tmp15_ = self->priv->page_buttons_revealer;
		_tmp16_ = self->priv->zoom_buttons_revealer;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp16_, 68);
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp15_, 68);
		_tmp17_ = self->priv->zoom_buttons_revealer;
		gtk_widget_set_visible ((GtkWidget*) _tmp17_, FALSE);
		tuba_views_media_viewer_play_video (self, (gint) pos);
		_tmp18_ = self->copy_media_simple_action;
		g_simple_action_set_enabled (_tmp18_, FALSE);
	} else {
		GtkRevealer* _tmp19_;
		GtkRevealer* _tmp20_;
		GtkRevealer* _tmp21_;
		GSimpleAction* _tmp22_;
		_tmp19_ = self->priv->page_buttons_revealer;
		_tmp20_ = self->priv->zoom_buttons_revealer;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp20_, 18);
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp19_, 18);
		_tmp21_ = self->priv->zoom_buttons_revealer;
		gtk_widget_set_visible ((GtkWidget*) _tmp21_, TRUE);
		tuba_views_media_viewer_pause_all_videos (self);
		_tmp22_ = self->copy_media_simple_action;
		g_simple_action_set_enabled (_tmp22_, TRUE);
	}
	tuba_views_media_viewer_on_zoom_change (self);
	_g_object_unref0 (page);
}

static void
tuba_views_media_viewer_on_carousel_n_pages_changed (TubaViewsMediaViewer* self)
{
	GtkRevealer* _tmp0_;
	AdwCarousel* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->page_buttons_revealer;
	_tmp1_ = self->priv->carousel;
	_tmp2_ = adw_carousel_get_n_pages (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, _tmp3_ > ((guint) 1));
}

void
tuba_views_media_viewer_on_zoom_change (TubaViewsMediaViewer* self)
{
	TubaViewsMediaViewerItem* page = NULL;
	AdwCarousel* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	TubaViewsMediaViewerItem* _tmp3_;
	gboolean _tmp4_ = FALSE;
	TubaViewsMediaViewerItem* _tmp5_;
	GtkButton* _tmp9_;
	gboolean _tmp10_ = FALSE;
	TubaViewsMediaViewerItem* _tmp11_;
	gboolean can_zoom_out = FALSE;
	GtkButton* _tmp15_;
	AdwCarousel* _tmp16_;
	AdwSwipeTracker* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = adw_carousel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tuba_views_media_viewer_safe_get (self, (gint) _tmp2_);
	page = _tmp3_;
	_tmp5_ = page;
	if (_tmp5_ == NULL) {
		_tmp4_ = FALSE;
	} else {
		TubaViewsMediaViewerItem* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = page;
		_tmp7_ = tuba_views_media_viewer_item_get_can_zoom_in (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_;
	}
	_tmp9_ = self->priv->zoom_in_btn;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, _tmp4_);
	_tmp11_ = page;
	if (_tmp11_ == NULL) {
		_tmp10_ = FALSE;
	} else {
		TubaViewsMediaViewerItem* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp12_ = page;
		_tmp13_ = tuba_views_media_viewer_item_get_can_zoom_out (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp10_ = _tmp14_;
	}
	can_zoom_out = _tmp10_;
	_tmp15_ = self->priv->zoom_out_btn;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, can_zoom_out);
	_tmp16_ = self->priv->carousel;
	adw_carousel_set_interactive (_tmp16_, !can_zoom_out);
	_tmp17_ = self->swipe_tracker;
	adw_swipe_tracker_set_enabled (_tmp17_, !can_zoom_out);
	_g_object_unref0 (page);
}

static TubaViewsMediaViewerItem*
tuba_views_media_viewer_safe_get (TubaViewsMediaViewer* self,
                                  gint pos)
{
	gboolean _tmp0_ = FALSE;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	TubaViewsMediaViewerItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->items;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > pos) {
		_tmp0_ = pos > -1;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GeeArrayList* _tmp4_;
		gpointer _tmp5_;
		_tmp4_ = self->priv->items;
		_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, pos);
		result = (TubaViewsMediaViewerItem*) _tmp5_;
		return result;
	}
	result = NULL;
	return result;
}

static Block86Data*
block86_data_ref (Block86Data* _data86_)
{
	g_atomic_int_inc (&_data86_->_ref_count_);
	return _data86_;
}

static void
block86_data_unref (void * _userdata_)
{
	Block86Data* _data86_;
	_data86_ = (Block86Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data86_->_ref_count_)) {
		TubaViewsMediaViewer* self;
		self = _data86_->self;
		_g_object_unref0 (self);
		g_slice_free (Block86Data, _data86_);
	}
}

static gboolean
__lambda39_ (Block86Data* _data86_,
             TubaViewsMediaViewerItem* item)
{
	TubaViewsMediaViewer* self;
	gint _tmp0_;
	gboolean result;
	self = _data86_->self;
	g_return_val_if_fail (item != NULL, FALSE);
	tuba_views_media_viewer_item_set_playing (item, _data86_->i == _data86_->pos);
	_tmp0_ = _data86_->i;
	_data86_->i = _tmp0_ + 1;
	result = TRUE;
	_g_object_unref0 (item);
	return result;
}

static gboolean
___lambda39__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda39_ (self, (TubaViewsMediaViewerItem*) g);
	return result;
}

static void
tuba_views_media_viewer_play_video (TubaViewsMediaViewer* self,
                                    gint pos)
{
	Block86Data* _data86_;
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	_data86_ = g_slice_new0 (Block86Data);
	_data86_->_ref_count_ = 1;
	_data86_->self = g_object_ref (self);
	_data86_->pos = pos;
	_data86_->i = 0;
	_tmp0_ = self->priv->items;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp0_, ___lambda39__gee_forall_func, _data86_);
	block86_data_unref (_data86_);
	_data86_ = NULL;
}

static gboolean
__lambda40_ (TubaViewsMediaViewer* self,
             TubaViewsMediaViewerItem* item)
{
	gboolean result;
	g_return_val_if_fail (item != NULL, FALSE);
	tuba_views_media_viewer_item_set_playing (item, FALSE);
	result = TRUE;
	_g_object_unref0 (item);
	return result;
}

static gboolean
___lambda40__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda40_ ((TubaViewsMediaViewer*) self, (TubaViewsMediaViewerItem*) g);
	return result;
}

static void
tuba_views_media_viewer_pause_all_videos (TubaViewsMediaViewer* self)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->items;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp0_, ___lambda40__gee_forall_func, self);
}

void
tuba_views_media_viewer_copy_media (TubaViewsMediaViewer* self)
{
	TubaViewsMediaViewerItem* page = NULL;
	AdwCarousel* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	TubaViewsMediaViewerItem* _tmp3_;
	TubaViewsMediaViewerItem* _tmp4_;
	GtkPicture* pic = NULL;
	TubaViewsMediaViewerItem* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkPicture* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GtkPicture* _tmp10_;
	GdkClipboard* clipboard = NULL;
	GdkDisplay* _tmp14_;
	GdkClipboard* _tmp15_;
	GdkClipboard* _tmp16_;
	GdkTexture* texture = NULL;
	GtkPicture* _tmp17_;
	GdkPaintable* _tmp18_;
	GdkPaintable* _tmp19_;
	GdkTexture* _tmp20_;
	GdkTexture* _tmp21_;
	GdkClipboard* _tmp22_;
	GdkTexture* _tmp23_;
	TubaApplication* _tmp24_;
	g_return_if_fail (self != NULL);
	g_debug ("MediaViewer.vala:1296: Begin copy-media action");
	_tmp0_ = self->priv->carousel;
	_tmp1_ = adw_carousel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tuba_views_media_viewer_safe_get (self, (gint) _tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (page);
		return;
	}
	_tmp5_ = page;
	_tmp6_ = tuba_views_media_viewer_item_get_child_widget (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_picture_get_type ()) ? ((GtkPicture*) _tmp7_) : NULL);
	pic = _tmp8_;
	_tmp10_ = pic;
	if (_tmp10_ == NULL) {
		_tmp9_ = TRUE;
	} else {
		GtkPicture* _tmp11_;
		GdkPaintable* _tmp12_;
		GdkPaintable* _tmp13_;
		_tmp11_ = pic;
		_tmp12_ = gtk_picture_get_paintable (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp9_ = _tmp13_ == NULL;
	}
	if (_tmp9_) {
		_g_object_unref0 (pic);
		_g_object_unref0 (page);
		return;
	}
	_tmp14_ = gdk_display_get_default ();
	_tmp15_ = gdk_display_get_clipboard (_tmp14_);
	_tmp16_ = _g_object_ref0 (_tmp15_);
	clipboard = _tmp16_;
	_tmp17_ = pic;
	_tmp18_ = gtk_picture_get_paintable (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, gdk_texture_get_type ()) ? ((GdkTexture*) _tmp19_) : NULL);
	texture = _tmp20_;
	_tmp21_ = texture;
	if (_tmp21_ == NULL) {
		_g_object_unref0 (texture);
		_g_object_unref0 (clipboard);
		_g_object_unref0 (pic);
		_g_object_unref0 (page);
		return;
	}
	_tmp22_ = clipboard;
	_tmp23_ = texture;
	gdk_clipboard_set_texture (_tmp22_, _tmp23_);
	_tmp24_ = tuba_app;
	g_signal_emit_by_name (_tmp24_, "toast", _ ("Copied image to clipboard"), (guint) 5);
	g_debug ("MediaViewer.vala:1309: End copy-media action");
	_g_object_unref0 (texture);
	_g_object_unref0 (clipboard);
	_g_object_unref0 (pic);
	_g_object_unref0 (page);
}

TubaViewsMediaViewer*
tuba_views_media_viewer_construct (GType object_type)
{
	TubaViewsMediaViewer * self = NULL;
	self = (TubaViewsMediaViewer*) g_object_new (object_type, NULL);
	return self;
}

TubaViewsMediaViewer*
tuba_views_media_viewer_new (void)
{
	return tuba_views_media_viewer_construct (TUBA_VIEWS_TYPE_MEDIA_VIEWER);
}

gboolean
tuba_views_media_viewer_get_fullscreen (TubaViewsMediaViewer* self)
{
	gboolean result;
	TubaApplication* _tmp0_;
	TubaDialogsMainWindow* _tmp1_;
	TubaDialogsMainWindow* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tuba_app;
	_tmp1_ = tuba_application_get_main_window (_tmp0_);
	_tmp2_ = _tmp1_;
	g_object_get ((GtkWindow*) _tmp2_, "fullscreened", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	result = _tmp4_;
	return result;
}

void
tuba_views_media_viewer_set_fullscreen (TubaViewsMediaViewer* self,
                                        gboolean value)
{
	GtkRevealer* _tmp8_;
	AdwHeaderBar* _tmp9_;
	g_return_if_fail (self != NULL);
	if (value) {
		TubaApplication* _tmp0_;
		TubaDialogsMainWindow* _tmp1_;
		TubaDialogsMainWindow* _tmp2_;
		GtkButton* _tmp3_;
		_tmp0_ = tuba_app;
		_tmp1_ = tuba_application_get_main_window (_tmp0_);
		_tmp2_ = _tmp1_;
		gtk_window_fullscreen ((GtkWindow*) _tmp2_);
		_tmp3_ = self->priv->fullscreen_btn;
		gtk_button_set_icon_name (_tmp3_, "view-restore-symbolic");
	} else {
		TubaApplication* _tmp4_;
		TubaDialogsMainWindow* _tmp5_;
		TubaDialogsMainWindow* _tmp6_;
		GtkButton* _tmp7_;
		_tmp4_ = tuba_app;
		_tmp5_ = tuba_application_get_main_window (_tmp4_);
		_tmp6_ = _tmp5_;
		gtk_window_unfullscreen ((GtkWindow*) _tmp6_);
		_tmp7_ = self->priv->fullscreen_btn;
		gtk_button_set_icon_name (_tmp7_, "view-fullscreen-symbolic");
	}
	_tmp8_ = self->priv->toggle_fs_revealer;
	gtk_widget_set_visible ((GtkWidget*) _tmp8_, value);
	self->priv->_fullscreen = value;
	_tmp9_ = self->priv->headerbar;
	gtk_widget_set_visible ((GtkWidget*) _tmp9_, !value);
	g_object_notify_by_pspec ((GObject *) self, tuba_views_media_viewer_properties[TUBA_VIEWS_MEDIA_VIEWER_FULLSCREEN_PROPERTY]);
}

static void
tuba_views_media_viewer_set_swipe_children_opacity (TubaViewsMediaViewer* self,
                                                    gdouble value)
{
	AdwHeaderBar* _tmp0_;
	GtkRevealer* _tmp1_;
	GtkRevealer* _tmp2_;
	GtkRevealer* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	_tmp1_ = self->priv->page_buttons_revealer;
	_tmp2_ = self->priv->toggle_fs_revealer;
	_tmp3_ = self->priv->zoom_buttons_revealer;
	gtk_widget_set_opacity ((GtkWidget*) _tmp3_, value);
	gtk_widget_set_opacity ((GtkWidget*) _tmp2_, value);
	gtk_widget_set_opacity ((GtkWidget*) _tmp1_, value);
	gtk_widget_set_opacity ((GtkWidget*) _tmp0_, value);
}

static gdouble
tuba_views_media_viewer_get_swipe_progress (TubaViewsMediaViewer* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_swipe_progress;
	return result;
}

static void
tuba_views_media_viewer_set_swipe_progress (TubaViewsMediaViewer* self,
                                            gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_swipe_progress = value;
}

static inline gpointer
tuba_views_media_viewer_item_get_instance_private (TubaViewsMediaViewerItem* self)
{
	return G_STRUCT_MEMBER_P (self, TubaViewsMediaViewerItem_private_offset);
}

void
tuba_views_media_viewer_item_update_adjustment (TubaViewsMediaViewerItem* self,
                                                gdouble x,
                                                gdouble y)
{
	GtkScrolledWindow* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkAdjustment* _tmp2_;
	GtkScrolledWindow* _tmp3_;
	GtkAdjustment* _tmp4_;
	GtkAdjustment* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	GtkScrolledWindow* _tmp9_;
	GtkAdjustment* _tmp10_;
	GtkAdjustment* _tmp11_;
	GtkScrolledWindow* _tmp12_;
	GtkAdjustment* _tmp13_;
	GtkAdjustment* _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scroller;
	_tmp1_ = gtk_scrolled_window_get_hadjustment (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->scroller;
	_tmp4_ = gtk_scrolled_window_get_hadjustment (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_adjustment_get_value (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->_last_x;
	gtk_adjustment_set_value (_tmp2_, (_tmp7_ - x) + _tmp8_);
	_tmp9_ = self->priv->scroller;
	_tmp10_ = gtk_scrolled_window_get_vadjustment (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->scroller;
	_tmp13_ = gtk_scrolled_window_get_vadjustment (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = gtk_adjustment_get_value (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->_last_y;
	gtk_adjustment_set_value (_tmp11_, (_tmp16_ - y) + _tmp17_);
}

void
tuba_views_media_viewer_item_zoom (TubaViewsMediaViewerItem* self,
                                   gdouble zoom_level,
                                   gint* old_width,
                                   gint* old_height)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gint* _tmp15_ = NULL;
	gint* _tmp16_;
	gdouble new_width = 0.0;
	gint* _tmp20_ = NULL;
	gint* _tmp21_;
	gdouble new_height = 0.0;
	TubaSettings* _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	GtkWidget* _tmp48_;
	GtkScrolledWindow* _tmp49_;
	GtkAdjustment* _tmp50_;
	GtkAdjustment* _tmp51_;
	GtkScrolledWindow* _tmp52_;
	GtkAdjustment* _tmp53_;
	GtkAdjustment* _tmp54_;
	GtkScrolledWindow* _tmp55_;
	GtkAdjustment* _tmp56_;
	GtkAdjustment* _tmp57_;
	gdouble _tmp58_;
	gdouble _tmp59_;
	GtkScrolledWindow* _tmp60_;
	GtkAdjustment* _tmp61_;
	GtkAdjustment* _tmp62_;
	GtkScrolledWindow* _tmp63_;
	GtkAdjustment* _tmp64_;
	GtkAdjustment* _tmp65_;
	GtkScrolledWindow* _tmp66_;
	GtkAdjustment* _tmp67_;
	GtkAdjustment* _tmp68_;
	gdouble _tmp69_;
	gdouble _tmp70_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_is_video;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->priv->_is_audio;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		return;
	}
	if (zoom_level > 1.0) {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = tuba_views_media_viewer_item_get_can_zoom_in (self);
		_tmp7_ = _tmp6_;
		_tmp5_ = !_tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		if (zoom_level < 1.0) {
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp10_ = tuba_views_media_viewer_item_get_can_zoom_out (self);
			_tmp11_ = _tmp10_;
			_tmp9_ = !_tmp11_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			TubaSettings* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			_tmp12_ = tuba_settings;
			_tmp13_ = tuba_settings_get_media_viewer_expand_pictures (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp8_ = _tmp14_;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp4_ = _tmp8_;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = zoom_level == 1.0;
	}
	if (_tmp3_) {
		return;
	}
	_tmp16_ = __int_dup0 (old_width);
	_tmp15_ = _tmp16_;
	if (_tmp15_ == NULL) {
		gint _tmp17_;
		gint _tmp18_;
		gint* _tmp19_;
		_tmp17_ = tuba_views_media_viewer_item_get_child_width (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = __int_dup0 (&_tmp18_);
		_g_free0 (_tmp15_);
		_tmp15_ = _tmp19_;
	}
	new_width = (*_tmp15_) * zoom_level;
	_tmp21_ = __int_dup0 (old_height);
	_tmp20_ = _tmp21_;
	if (_tmp20_ == NULL) {
		gint _tmp22_;
		gint _tmp23_;
		gint* _tmp24_;
		_tmp22_ = tuba_views_media_viewer_item_get_child_height (self);
		_tmp23_ = _tmp22_;
		_tmp24_ = __int_dup0 (&_tmp23_);
		_g_free0 (_tmp20_);
		_tmp20_ = _tmp24_;
	}
	new_height = (*_tmp20_) * zoom_level;
	_tmp25_ = tuba_settings;
	_tmp26_ = tuba_settings_get_media_viewer_expand_pictures (_tmp25_);
	_tmp27_ = _tmp26_;
	if (_tmp27_) {
		GtkScrolledWindow* _tmp28_;
		GtkAdjustment* _tmp29_;
		GtkAdjustment* _tmp30_;
		gdouble _tmp31_;
		gdouble _tmp32_;
		GtkScrolledWindow* _tmp38_;
		GtkAdjustment* _tmp39_;
		GtkAdjustment* _tmp40_;
		gdouble _tmp41_;
		gdouble _tmp42_;
		_tmp28_ = self->priv->scroller;
		_tmp29_ = gtk_scrolled_window_get_hadjustment (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = gtk_adjustment_get_page_size (_tmp30_);
		_tmp32_ = _tmp31_;
		if (new_width < _tmp32_) {
			GtkScrolledWindow* _tmp33_;
			GtkAdjustment* _tmp34_;
			GtkAdjustment* _tmp35_;
			gdouble _tmp36_;
			gdouble _tmp37_;
			_tmp33_ = self->priv->scroller;
			_tmp34_ = gtk_scrolled_window_get_hadjustment (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = gtk_adjustment_get_page_size (_tmp35_);
			_tmp37_ = _tmp36_;
			new_width = _tmp37_;
		}
		_tmp38_ = self->priv->scroller;
		_tmp39_ = gtk_scrolled_window_get_vadjustment (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = gtk_adjustment_get_page_size (_tmp40_);
		_tmp42_ = _tmp41_;
		if (new_height < _tmp42_) {
			GtkScrolledWindow* _tmp43_;
			GtkAdjustment* _tmp44_;
			GtkAdjustment* _tmp45_;
			gdouble _tmp46_;
			gdouble _tmp47_;
			_tmp43_ = self->priv->scroller;
			_tmp44_ = gtk_scrolled_window_get_vadjustment (_tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = gtk_adjustment_get_page_size (_tmp45_);
			_tmp47_ = _tmp46_;
			new_height = _tmp47_;
		}
	} else {
		if (new_width < ((gdouble) 0)) {
			new_width = (gdouble) -1;
		}
		if (new_height < ((gdouble) 0)) {
			new_height = (gdouble) -1;
		}
	}
	_tmp48_ = self->priv->_child_widget;
	gtk_widget_set_size_request (_tmp48_, (gint) new_width, (gint) new_height);
	_tmp49_ = self->priv->scroller;
	_tmp50_ = gtk_scrolled_window_get_vadjustment (_tmp49_);
	_tmp51_ = _tmp50_;
	gtk_adjustment_set_upper (_tmp51_, new_height);
	_tmp52_ = self->priv->scroller;
	_tmp53_ = gtk_scrolled_window_get_vadjustment (_tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = self->priv->scroller;
	_tmp56_ = gtk_scrolled_window_get_vadjustment (_tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = gtk_adjustment_get_page_size (_tmp57_);
	_tmp59_ = _tmp58_;
	gtk_adjustment_set_value (_tmp54_, (new_height - _tmp59_) / 2);
	_tmp60_ = self->priv->scroller;
	_tmp61_ = gtk_scrolled_window_get_hadjustment (_tmp60_);
	_tmp62_ = _tmp61_;
	gtk_adjustment_set_upper (_tmp62_, new_width);
	_tmp63_ = self->priv->scroller;
	_tmp64_ = gtk_scrolled_window_get_hadjustment (_tmp63_);
	_tmp65_ = _tmp64_;
	_tmp66_ = self->priv->scroller;
	_tmp67_ = gtk_scrolled_window_get_hadjustment (_tmp66_);
	_tmp68_ = _tmp67_;
	_tmp69_ = gtk_adjustment_get_page_size (_tmp68_);
	_tmp70_ = _tmp69_;
	gtk_adjustment_set_value (_tmp65_, (new_width - _tmp70_) / 2);
	tuba_views_media_viewer_item_emit_zoom_changed (self);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp15_);
}

void
tuba_views_media_viewer_item_zoom_in (TubaViewsMediaViewerItem* self)
{
	g_return_if_fail (self != NULL);
	tuba_views_media_viewer_item_zoom (self, 1.5, NULL, NULL);
}

void
tuba_views_media_viewer_item_zoom_out (TubaViewsMediaViewerItem* self)
{
	g_return_if_fail (self != NULL);
	tuba_views_media_viewer_item_zoom (self, 0.5, NULL, NULL);
}

static void
tuba_views_media_viewer_item_add_spinner_to_overlay (TubaViewsMediaViewerItem* self)
{
	GtkOverlay* _tmp0_;
	AdwSpinner* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->spinner_timeout = (guint) 0;
	if (self->priv->is_done) {
		return;
	}
	_tmp0_ = self->priv->overlay;
	_tmp1_ = self->priv->spinner;
	gtk_overlay_add_overlay (_tmp0_, (GtkWidget*) _tmp1_);
}

TubaViewsMediaViewerItem*
tuba_views_media_viewer_item_construct (GType object_type,
                                        GtkWidget* child,
                                        const gchar* t_url,
                                        GdkPaintable* paintable,
                                        gboolean t_is_video,
                                        gboolean t_is_audio)
{
	TubaViewsMediaViewerItem * self = NULL;
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_val_if_fail (child != NULL, NULL);
	g_return_val_if_fail (t_url != NULL, NULL);
	self = (TubaViewsMediaViewerItem*) g_object_new (object_type, NULL);
	tuba_views_media_viewer_item_set_child_widget (self, child);
	tuba_views_media_viewer_item_set_is_video (self, t_is_video);
	tuba_views_media_viewer_item_set_is_audio (self, t_is_audio);
	_tmp0_ = self->priv->stack;
	_tmp1_ = tuba_views_media_viewer_item_setup_scrolledwindow (self, child);
	_tmp2_ = _tmp1_;
	gtk_stack_add_named (_tmp0_, _tmp2_, "child");
	_g_object_unref0 (_tmp2_);
	tuba_views_media_viewer_item_set_url (self, t_url);
	if (paintable != NULL) {
		GtkOverlay* _tmp3_;
		GtkPicture* _tmp4_;
		GtkPicture* _tmp5_;
		_tmp3_ = self->priv->overlay;
		_tmp4_ = (GtkPicture*) gtk_picture_new_for_paintable (paintable);
		g_object_ref_sink (_tmp4_);
		_tmp5_ = _tmp4_;
		gtk_overlay_set_child (_tmp3_, (GtkWidget*) _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	return self;
}

TubaViewsMediaViewerItem*
tuba_views_media_viewer_item_new (GtkWidget* child,
                                  const gchar* t_url,
                                  GdkPaintable* paintable,
                                  gboolean t_is_video,
                                  gboolean t_is_audio)
{
	return tuba_views_media_viewer_item_construct (TUBA_VIEWS_MEDIA_VIEWER_TYPE_ITEM, child, t_url, paintable, t_is_video, t_is_audio);
}

static void
_tuba_views_media_viewer_item_on_manual_volume_change_video_g_object_notify (GObject* _sender,
                                                                             GParamSpec* pspec,
                                                                             gpointer self)
{
	tuba_views_media_viewer_item_on_manual_volume_change_video ((TubaViewsMediaViewerItem*) self);
}

static void
_tuba_views_media_viewer_item_on_manual_volume_change_audio_g_object_notify (GObject* _sender,
                                                                             GParamSpec* pspec,
                                                                             gpointer self)
{
	tuba_views_media_viewer_item_on_manual_volume_change_audio ((TubaViewsMediaViewerItem*) self);
}

void
tuba_views_media_viewer_item_done (TubaViewsMediaViewerItem* self)
{
	GtkStack* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->is_done) {
		return;
	}
	_tmp0_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp0_, "child");
	_tmp1_ = self->priv->_is_video;
	if (_tmp1_) {
		ClapperPlayer* player = NULL;
		GtkWidget* _tmp2_;
		ClapperPlayer* _tmp3_;
		ClapperPlayer* _tmp4_;
		ClapperPlayer* _tmp5_;
		ClapperPlayer* _tmp11_;
		ClapperPlayer* _tmp12_;
		_tmp2_ = self->priv->_child_widget;
		_tmp3_ = clapper_gtk_av_get_player ((ClapperGtkAv*) G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, clapper_gtk_video_get_type (), ClapperGtkVideo));
		_tmp4_ = _tmp3_;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		player = _tmp5_;
		if (self->priv->pre_playing) {
			ClapperPlayer* _tmp6_;
			_tmp6_ = player;
			clapper_player_play (_tmp6_);
		} else {
			ClapperPlayer* _tmp7_;
			ClapperPlayerState _tmp8_;
			ClapperPlayerState _tmp9_;
			_tmp7_ = player;
			_tmp8_ = clapper_player_get_state (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_ > CLAPPER_PLAYER_STATE_STOPPED) {
				ClapperPlayer* _tmp10_;
				_tmp10_ = player;
				clapper_player_pause (_tmp10_);
			}
		}
		_tmp11_ = player;
		clapper_player_set_volume (_tmp11_, tuba_views_media_viewer_last_used_volume);
		_tmp12_ = player;
		g_signal_connect_object ((GObject*) _tmp12_, "notify::volume", (GCallback) _tuba_views_media_viewer_item_on_manual_volume_change_video_g_object_notify, self, 0);
		_g_object_unref0 (player);
	} else {
		gboolean _tmp13_;
		_tmp13_ = self->priv->_is_audio;
		if (_tmp13_) {
			GtkWidget* _tmp14_;
			_tmp14_ = self->priv->_child_widget;
			g_signal_connect_object ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TUBA_WIDGETS_AUDIO_TYPE_PLAYER, TubaWidgetsAudioPlayer), "notify::volume", (GCallback) _tuba_views_media_viewer_item_on_manual_volume_change_audio_g_object_notify, self, 0);
		}
	}
	self->priv->is_done = TRUE;
}

static void
tuba_views_media_viewer_item_on_manual_volume_change_video (TubaViewsMediaViewerItem* self)
{
	TubaSettings* _tmp0_;
	GtkWidget* _tmp1_;
	ClapperPlayer* _tmp2_;
	ClapperPlayer* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tuba_settings;
	_tmp1_ = self->priv->_child_widget;
	_tmp2_ = clapper_gtk_av_get_player ((ClapperGtkAv*) G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, clapper_gtk_video_get_type (), ClapperGtkVideo));
	_tmp3_ = _tmp2_;
	_tmp4_ = clapper_player_get_volume (_tmp3_);
	_tmp5_ = _tmp4_;
	tuba_settings_set_media_viewer_last_used_volume (_tmp0_, _tmp5_);
}

static void
tuba_views_media_viewer_item_on_manual_volume_change_audio (TubaViewsMediaViewerItem* self)
{
	TubaSettings* _tmp0_;
	GtkWidget* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tuba_settings;
	_tmp1_ = self->priv->_child_widget;
	_tmp2_ = tuba_widgets_audio_player_get_volume (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TUBA_WIDGETS_AUDIO_TYPE_PLAYER, TubaWidgetsAudioPlayer));
	_tmp3_ = _tmp2_;
	tuba_settings_set_media_viewer_last_used_volume (_tmp0_, _tmp3_);
}

static gboolean
tuba_views_media_viewer_item_on_scroll (TubaViewsMediaViewerItem* self,
                                        GtkEventControllerScroll* scroll,
                                        gdouble dx,
                                        gdouble dy)
{
	GdkModifierType state = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (scroll != NULL, FALSE);
	state = gtk_event_controller_get_current_event_state ((GtkEventController*) scroll) & GDK_MODIFIER_MASK;
	if (state != GDK_CONTROL_MASK) {
		result = FALSE;
		return result;
	}
	if (dy < ((gdouble) 0)) {
		tuba_views_media_viewer_item_zoom_in (self);
	} else {
		tuba_views_media_viewer_item_zoom_out (self);
	}
	result = TRUE;
	return result;
}

static void
_tuba_views_media_viewer_item_emit_zoom_changed_gtk_adjustment_changed (GtkAdjustment* _sender,
                                                                        gpointer self)
{
	tuba_views_media_viewer_item_emit_zoom_changed ((TubaViewsMediaViewerItem*) self);
}

static gboolean
_tuba_views_media_viewer_item_on_scroll_gtk_event_controller_scroll_scroll (GtkEventControllerScroll* _sender,
                                                                            gdouble dx,
                                                                            gdouble dy,
                                                                            gpointer self)
{
	gboolean result;
	result = tuba_views_media_viewer_item_on_scroll ((TubaViewsMediaViewerItem*) self, _sender, dx, dy);
	return result;
}

static GtkWidget*
tuba_views_media_viewer_item_setup_scrolledwindow (TubaViewsMediaViewerItem* self,
                                                   GtkWidget* child)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GtkScrolledWindow* _tmp4_ = NULL;
	GtkScrolledWindow* _tmp5_;
	GtkScrolledWindow* _tmp6_;
	GtkAdjustment* _tmp7_;
	GtkAdjustment* _tmp8_;
	GtkScrolledWindow* _tmp9_;
	GtkAdjustment* _tmp10_;
	GtkAdjustment* _tmp11_;
	GtkEventControllerScroll* scroll = NULL;
	GtkEventControllerScroll* _tmp12_;
	GtkEventControllerScroll* _tmp13_;
	GtkScrolledWindow* _tmp14_;
	GtkEventControllerScroll* _tmp15_;
	GtkEventController* _tmp16_;
	GtkScrolledWindow* _tmp17_;
	GtkWidget* _tmp18_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (child != NULL, NULL);
	_tmp1_ = self->priv->_is_video;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->priv->_is_audio;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		GtkWidget* _tmp3_;
		_tmp3_ = _g_object_ref0 (child);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp4_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp4_, TRUE);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->scroller);
	self->priv->scroller = _tmp4_;
	_tmp5_ = self->priv->scroller;
	gtk_scrolled_window_set_child (_tmp5_, child);
	_tmp6_ = self->priv->scroller;
	_tmp7_ = gtk_scrolled_window_get_vadjustment (_tmp6_);
	_tmp8_ = _tmp7_;
	g_signal_connect_object (_tmp8_, "changed", (GCallback) _tuba_views_media_viewer_item_emit_zoom_changed_gtk_adjustment_changed, self, 0);
	_tmp9_ = self->priv->scroller;
	_tmp10_ = gtk_scrolled_window_get_hadjustment (_tmp9_);
	_tmp11_ = _tmp10_;
	g_signal_connect_object (_tmp11_, "changed", (GCallback) _tuba_views_media_viewer_item_emit_zoom_changed_gtk_adjustment_changed, self, 0);
	_tmp12_ = (GtkEventControllerScroll*) gtk_event_controller_scroll_new (GTK_EVENT_CONTROLLER_SCROLL_BOTH_AXES | GTK_EVENT_CONTROLLER_SCROLL_DISCRETE);
	scroll = _tmp12_;
	_tmp13_ = scroll;
	g_signal_connect_object (_tmp13_, "scroll", (GCallback) _tuba_views_media_viewer_item_on_scroll_gtk_event_controller_scroll_scroll, self, 0);
	_tmp14_ = self->priv->scroller;
	_tmp15_ = scroll;
	_tmp16_ = _g_object_ref0 ((GtkEventController*) _tmp15_);
	gtk_widget_add_controller ((GtkWidget*) _tmp14_, _tmp16_);
	_tmp17_ = self->priv->scroller;
	_tmp18_ = _g_object_ref0 ((GtkWidget*) _tmp17_);
	result = _tmp18_;
	_g_object_unref0 (scroll);
	return result;
}

void
tuba_views_media_viewer_item_on_double_click (TubaViewsMediaViewerItem* self)
{
	gdouble _tmp0_ = 0.0;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp1_ = tuba_views_media_viewer_item_get_can_zoom_out (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = -2.5;
	} else {
		_tmp0_ = 2.5;
	}
	tuba_views_media_viewer_item_zoom (self, _tmp0_, NULL, NULL);
}

static void
tuba_views_media_viewer_item_emit_zoom_changed (TubaViewsMediaViewerItem* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, tuba_views_media_viewer_item_signals[TUBA_VIEWS_MEDIA_VIEWER_ITEM_ZOOM_CHANGED_SIGNAL], 0);
}

GtkWidget*
tuba_views_media_viewer_item_get_child_widget (TubaViewsMediaViewerItem* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_child_widget;
	result = _tmp0_;
	return result;
}

static void
tuba_views_media_viewer_item_set_child_widget (TubaViewsMediaViewerItem* self,
                                               GtkWidget* value)
{
	GtkWidget* old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_views_media_viewer_item_get_child_widget (self);
	if (old_value != value) {
		GtkWidget* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_child_widget);
		self->priv->_child_widget = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_CHILD_WIDGET_PROPERTY]);
	}
}

gboolean
tuba_views_media_viewer_item_get_is_video (TubaViewsMediaViewerItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_video;
	return result;
}

static void
tuba_views_media_viewer_item_set_is_video (TubaViewsMediaViewerItem* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_views_media_viewer_item_get_is_video (self);
	if (old_value != value) {
		self->priv->_is_video = value;
		g_object_notify_by_pspec ((GObject *) self, tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_IS_VIDEO_PROPERTY]);
	}
}

gboolean
tuba_views_media_viewer_item_get_is_audio (TubaViewsMediaViewerItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_audio;
	return result;
}

static void
tuba_views_media_viewer_item_set_is_audio (TubaViewsMediaViewerItem* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_views_media_viewer_item_get_is_audio (self);
	if (old_value != value) {
		self->priv->_is_audio = value;
		g_object_notify_by_pspec ((GObject *) self, tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_IS_AUDIO_PROPERTY]);
	}
}

const gchar*
tuba_views_media_viewer_item_get_url (TubaViewsMediaViewerItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_url;
	result = _tmp0_;
	return result;
}

static void
tuba_views_media_viewer_item_set_url (TubaViewsMediaViewerItem* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_views_media_viewer_item_get_url (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_url);
		self->priv->_url = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_URL_PROPERTY]);
	}
}

gdouble
tuba_views_media_viewer_item_get_last_x (TubaViewsMediaViewerItem* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_last_x;
	return result;
}

void
tuba_views_media_viewer_item_set_last_x (TubaViewsMediaViewerItem* self,
                                         gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_views_media_viewer_item_get_last_x (self);
	if (old_value != value) {
		self->priv->_last_x = value;
		g_object_notify_by_pspec ((GObject *) self, tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_LAST_X_PROPERTY]);
	}
}

gdouble
tuba_views_media_viewer_item_get_last_y (TubaViewsMediaViewerItem* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_last_y;
	return result;
}

void
tuba_views_media_viewer_item_set_last_y (TubaViewsMediaViewerItem* self,
                                         gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_views_media_viewer_item_get_last_y (self);
	if (old_value != value) {
		self->priv->_last_y = value;
		g_object_notify_by_pspec ((GObject *) self, tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_LAST_Y_PROPERTY]);
	}
}

gboolean
tuba_views_media_viewer_item_get_playing (TubaViewsMediaViewerItem* self)
{
	gboolean result;
	gboolean _tmp0_;
	gboolean _tmp4_;
	GtkWidget* _tmp5_;
	ClapperPlayer* _tmp6_;
	ClapperPlayer* _tmp7_;
	ClapperPlayerState _tmp8_;
	ClapperPlayerState _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_audio;
	if (_tmp0_) {
		GtkWidget* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->_child_widget;
		_tmp2_ = tuba_widgets_audio_player_get_playing (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TUBA_WIDGETS_AUDIO_TYPE_PLAYER, TubaWidgetsAudioPlayer));
		_tmp3_ = _tmp2_;
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->_is_video;
	if (!_tmp4_) {
		result = FALSE;
		return result;
	}
	if (!self->priv->is_done) {
		result = self->priv->pre_playing;
		return result;
	}
	_tmp5_ = self->priv->_child_widget;
	_tmp6_ = clapper_gtk_av_get_player ((ClapperGtkAv*) G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, clapper_gtk_video_get_type (), ClapperGtkVideo));
	_tmp7_ = _tmp6_;
	_tmp8_ = clapper_player_get_state (_tmp7_);
	_tmp9_ = _tmp8_;
	switch (_tmp9_) {
		case CLAPPER_PLAYER_STATE_PAUSED:
		case CLAPPER_PLAYER_STATE_STOPPED:
		{
			result = FALSE;
			return result;
		}
		default:
		{
			result = TRUE;
			return result;
		}
	}
}

void
tuba_views_media_viewer_item_set_playing (TubaViewsMediaViewerItem* self,
                                          gboolean value)
{
	gboolean _tmp0_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_is_audio;
	if (_tmp0_) {
		GtkWidget* _tmp1_;
		_tmp1_ = self->priv->_child_widget;
		tuba_widgets_audio_player_set_playing (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TUBA_WIDGETS_AUDIO_TYPE_PLAYER, TubaWidgetsAudioPlayer), value);
		return;
	}
	_tmp2_ = self->priv->_is_video;
	if (!_tmp2_) {
		return;
	}
	if (self->priv->is_done) {
		ClapperPlayer* player = NULL;
		GtkWidget* _tmp3_;
		ClapperPlayer* _tmp4_;
		ClapperPlayer* _tmp5_;
		ClapperPlayer* _tmp6_;
		_tmp3_ = self->priv->_child_widget;
		_tmp4_ = clapper_gtk_av_get_player ((ClapperGtkAv*) G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, clapper_gtk_video_get_type (), ClapperGtkVideo));
		_tmp5_ = _tmp4_;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		player = _tmp6_;
		if (value) {
			ClapperPlayer* _tmp7_;
			_tmp7_ = player;
			clapper_player_play (_tmp7_);
		} else {
			ClapperPlayer* _tmp8_;
			ClapperPlayerState _tmp9_;
			ClapperPlayerState _tmp10_;
			_tmp8_ = player;
			_tmp9_ = clapper_player_get_state (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ > CLAPPER_PLAYER_STATE_STOPPED) {
				ClapperPlayer* _tmp11_;
				_tmp11_ = player;
				clapper_player_pause (_tmp11_);
			}
		}
		_g_object_unref0 (player);
	} else {
		self->priv->pre_playing = value;
	}
	g_object_notify_by_pspec ((GObject *) self, tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_PLAYING_PROPERTY]);
}

gboolean
tuba_views_media_viewer_item_get_can_zoom_in (TubaViewsMediaViewerItem* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp3_ = FALSE;
	GtkScrolledWindow* _tmp4_;
	GtkAdjustment* _tmp5_;
	GtkAdjustment* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	GtkScrolledWindow* _tmp9_;
	GtkAdjustment* _tmp10_;
	GtkAdjustment* _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_is_video;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->priv->_is_audio;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->scroller;
	_tmp5_ = gtk_scrolled_window_get_hadjustment (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gtk_adjustment_get_upper (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->scroller;
	_tmp10_ = gtk_scrolled_window_get_hadjustment (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gtk_adjustment_get_page_size (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp8_ < (_tmp13_ * TUBA_VIEWS_MEDIA_VIEWER_MAX_ZOOM)) {
		GtkScrolledWindow* _tmp14_;
		GtkAdjustment* _tmp15_;
		GtkAdjustment* _tmp16_;
		gdouble _tmp17_;
		gdouble _tmp18_;
		GtkScrolledWindow* _tmp19_;
		GtkAdjustment* _tmp20_;
		GtkAdjustment* _tmp21_;
		gdouble _tmp22_;
		gdouble _tmp23_;
		_tmp14_ = self->priv->scroller;
		_tmp15_ = gtk_scrolled_window_get_vadjustment (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = gtk_adjustment_get_upper (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->scroller;
		_tmp20_ = gtk_scrolled_window_get_vadjustment (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = gtk_adjustment_get_page_size (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp3_ = _tmp18_ < (_tmp23_ * TUBA_VIEWS_MEDIA_VIEWER_MAX_ZOOM);
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	return result;
}

gboolean
tuba_views_media_viewer_item_get_can_zoom_out (TubaViewsMediaViewerItem* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp3_ = FALSE;
	GtkScrolledWindow* _tmp4_;
	GtkAdjustment* _tmp5_;
	GtkAdjustment* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	GtkScrolledWindow* _tmp9_;
	GtkAdjustment* _tmp10_;
	GtkAdjustment* _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_is_video;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->priv->_is_audio;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->scroller;
	_tmp5_ = gtk_scrolled_window_get_hadjustment (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gtk_adjustment_get_upper (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->scroller;
	_tmp10_ = gtk_scrolled_window_get_hadjustment (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gtk_adjustment_get_page_size (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp8_ > _tmp13_) {
		_tmp3_ = TRUE;
	} else {
		GtkScrolledWindow* _tmp14_;
		GtkAdjustment* _tmp15_;
		GtkAdjustment* _tmp16_;
		gdouble _tmp17_;
		gdouble _tmp18_;
		GtkScrolledWindow* _tmp19_;
		GtkAdjustment* _tmp20_;
		GtkAdjustment* _tmp21_;
		gdouble _tmp22_;
		gdouble _tmp23_;
		_tmp14_ = self->priv->scroller;
		_tmp15_ = gtk_scrolled_window_get_vadjustment (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = gtk_adjustment_get_upper (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->scroller;
		_tmp20_ = gtk_scrolled_window_get_vadjustment (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = gtk_adjustment_get_page_size (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp3_ = _tmp18_ > _tmp23_;
	}
	result = _tmp3_;
	return result;
}

gint
tuba_views_media_viewer_item_get_child_width (TubaViewsMediaViewerItem* self)
{
	gint result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_child_widget;
	result = gtk_widget_get_width (_tmp0_);
	return result;
}

gint
tuba_views_media_viewer_item_get_child_height (TubaViewsMediaViewerItem* self)
{
	gint result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_child_widget;
	result = gtk_widget_get_height (_tmp0_);
	return result;
}

static void
_tuba_views_media_viewer_item_add_spinner_to_overlay_gsource_once_func (gpointer self)
{
	tuba_views_media_viewer_item_add_spinner_to_overlay ((TubaViewsMediaViewerItem*) self);
}

static GObject *
tuba_views_media_viewer_item_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TubaViewsMediaViewerItem * self;
	GtkStack* _tmp0_;
	GtkOverlay* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	AdwSpinner* _tmp5_ = NULL;
	GtkStack* _tmp6_;
	GtkOverlay* _tmp7_;
	GtkStack* _tmp8_;
	parent_class = G_OBJECT_CLASS (tuba_views_media_viewer_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_VIEWS_MEDIA_VIEWER_TYPE_ITEM, TubaViewsMediaViewerItem);
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) self, TRUE);
	_tmp0_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp0_;
	_tmp1_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_widget_set_vexpand ((GtkWidget*) _tmp1_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->overlay);
	self->priv->overlay = _tmp1_;
	_tmp2_ = g_strdup ("osd");
	_tmp3_ = g_strdup ("circular-spinner");
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp2_;
	_tmp4_[1] = _tmp3_;
	_tmp5_ = (AdwSpinner*) adw_spinner_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp5_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_CENTER);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp5_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp5_, TRUE);
	g_object_set ((GtkWidget*) _tmp5_, "width-request", 35, NULL);
	g_object_set ((GtkWidget*) _tmp5_, "height-request", 35, NULL);
	gtk_widget_set_css_classes ((GtkWidget*) _tmp5_, _tmp4_);
	_tmp4_ = (_vala_array_free (_tmp4_, 2, (GDestroyNotify) g_free), NULL);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp5_;
	self->priv->spinner_timeout = g_timeout_add_once ((guint) 1000, _tuba_views_media_viewer_item_add_spinner_to_overlay_gsource_once_func, self);
	_tmp6_ = self->priv->stack;
	_tmp7_ = self->priv->overlay;
	gtk_stack_add_named (_tmp6_, (GtkWidget*) _tmp7_, "spinner");
	_tmp8_ = self->priv->stack;
	adw_bin_set_child ((AdwBin*) self, (GtkWidget*) _tmp8_);
	return obj;
}

static void
tuba_views_media_viewer_item_class_init (TubaViewsMediaViewerItemClass * klass,
                                         gpointer klass_data)
{
	tuba_views_media_viewer_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TubaViewsMediaViewerItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_tuba_views_media_viewer_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tuba_views_media_viewer_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = tuba_views_media_viewer_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = tuba_views_media_viewer_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_VIEWS_MEDIA_VIEWER_ITEM_CHILD_WIDGET_PROPERTY, tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_CHILD_WIDGET_PROPERTY] = g_param_spec_object ("child-widget", "child-widget", "child-widget", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_VIEWS_MEDIA_VIEWER_ITEM_IS_VIDEO_PROPERTY, tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_IS_VIDEO_PROPERTY] = g_param_spec_boolean ("is-video", "is-video", "is-video", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_VIEWS_MEDIA_VIEWER_ITEM_IS_AUDIO_PROPERTY, tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_IS_AUDIO_PROPERTY] = g_param_spec_boolean ("is-audio", "is-audio", "is-audio", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_VIEWS_MEDIA_VIEWER_ITEM_URL_PROPERTY, tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_URL_PROPERTY] = g_param_spec_string ("url", "url", "url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_VIEWS_MEDIA_VIEWER_ITEM_LAST_X_PROPERTY, tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_LAST_X_PROPERTY] = g_param_spec_double ("last-x", "last-x", "last-x", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_VIEWS_MEDIA_VIEWER_ITEM_LAST_Y_PROPERTY, tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_LAST_Y_PROPERTY] = g_param_spec_double ("last-y", "last-y", "last-y", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_VIEWS_MEDIA_VIEWER_ITEM_PLAYING_PROPERTY, tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_PLAYING_PROPERTY] = g_param_spec_boolean ("playing", "playing", "playing", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_VIEWS_MEDIA_VIEWER_ITEM_CAN_ZOOM_IN_PROPERTY, tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_CAN_ZOOM_IN_PROPERTY] = g_param_spec_boolean ("can-zoom-in", "can-zoom-in", "can-zoom-in", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_VIEWS_MEDIA_VIEWER_ITEM_CAN_ZOOM_OUT_PROPERTY, tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_CAN_ZOOM_OUT_PROPERTY] = g_param_spec_boolean ("can-zoom-out", "can-zoom-out", "can-zoom-out", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_VIEWS_MEDIA_VIEWER_ITEM_CHILD_WIDTH_PROPERTY, tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_CHILD_WIDTH_PROPERTY] = g_param_spec_int ("child-width", "child-width", "child-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_VIEWS_MEDIA_VIEWER_ITEM_CHILD_HEIGHT_PROPERTY, tuba_views_media_viewer_item_properties[TUBA_VIEWS_MEDIA_VIEWER_ITEM_CHILD_HEIGHT_PROPERTY] = g_param_spec_int ("child-height", "child-height", "child-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	tuba_views_media_viewer_item_signals[TUBA_VIEWS_MEDIA_VIEWER_ITEM_ZOOM_CHANGED_SIGNAL] = g_signal_new ("zoom-changed", TUBA_VIEWS_MEDIA_VIEWER_TYPE_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
tuba_views_media_viewer_item_instance_init (TubaViewsMediaViewerItem * self,
                                            gpointer klass)
{
	self->priv = tuba_views_media_viewer_item_get_instance_private (self);
	self->priv->is_done = FALSE;
	self->priv->_is_video = FALSE;
	self->priv->_is_audio = FALSE;
	self->priv->_last_x = 0.0;
	self->priv->_last_y = 0.0;
	self->priv->pre_playing = FALSE;
	self->priv->spinner_timeout = (guint) 0;
}

static void
tuba_views_media_viewer_item_finalize (GObject * obj)
{
	TubaViewsMediaViewerItem * self;
	gboolean _tmp0_;
	GtkWidget* _tmp30_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_VIEWS_MEDIA_VIEWER_TYPE_ITEM, TubaViewsMediaViewerItem);
	g_debug ("MediaViewer.vala:255: Destroying MediaViewer.Item");
	if (self->priv->spinner_timeout > ((guint) 0)) {
		g_source_remove (self->priv->spinner_timeout);
	}
	_tmp0_ = self->priv->_is_audio;
	if (_tmp0_) {
		TubaWidgetsAudioPlayer* child_wdgt = NULL;
		GtkWidget* _tmp1_;
		TubaWidgetsAudioPlayer* _tmp2_;
		gdouble _tmp3_ = 0.0;
		TubaWidgetsAudioPlayer* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp1_ = self->priv->_child_widget;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TUBA_WIDGETS_AUDIO_TYPE_PLAYER, TubaWidgetsAudioPlayer));
		child_wdgt = _tmp2_;
		_tmp4_ = child_wdgt;
		_tmp5_ = tuba_widgets_audio_player_get_muted (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_) {
			_tmp3_ = 0.0;
		} else {
			TubaWidgetsAudioPlayer* _tmp7_;
			gdouble _tmp8_;
			gdouble _tmp9_;
			_tmp7_ = child_wdgt;
			_tmp8_ = tuba_widgets_audio_player_get_volume (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = _tmp9_;
		}
		tuba_views_media_viewer_last_used_volume = _tmp3_;
		_g_object_unref0 (child_wdgt);
	} else {
		gboolean _tmp10_;
		_tmp10_ = self->priv->_is_video;
		if (_tmp10_) {
			ClapperGtkVideo* child_wdgt = NULL;
			GtkWidget* _tmp11_;
			ClapperGtkVideo* _tmp12_;
			gdouble _tmp13_ = 0.0;
			ClapperGtkVideo* _tmp14_;
			ClapperPlayer* _tmp15_;
			ClapperPlayer* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			ClapperGtkVideo* _tmp24_;
			ClapperPlayer* _tmp25_;
			ClapperPlayer* _tmp26_;
			ClapperQueue* _tmp27_;
			ClapperQueue* _tmp28_;
			_tmp11_ = self->priv->_child_widget;
			_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, clapper_gtk_video_get_type (), ClapperGtkVideo));
			child_wdgt = _tmp12_;
			_tmp14_ = child_wdgt;
			_tmp15_ = clapper_gtk_av_get_player ((ClapperGtkAv*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = clapper_player_get_mute (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_) {
				_tmp13_ = 0.0;
			} else {
				ClapperGtkVideo* _tmp19_;
				ClapperPlayer* _tmp20_;
				ClapperPlayer* _tmp21_;
				gdouble _tmp22_;
				gdouble _tmp23_;
				_tmp19_ = child_wdgt;
				_tmp20_ = clapper_gtk_av_get_player ((ClapperGtkAv*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = clapper_player_get_volume (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp13_ = _tmp23_;
			}
			tuba_views_media_viewer_last_used_volume = _tmp13_;
			_tmp24_ = child_wdgt;
			_tmp25_ = clapper_gtk_av_get_player ((ClapperGtkAv*) _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = clapper_player_get_queue (_tmp26_);
			_tmp28_ = _tmp27_;
			clapper_queue_clear (_tmp28_);
			_g_object_unref0 (child_wdgt);
		} else {
			GtkWidget* _tmp29_;
			_tmp29_ = self->priv->_child_widget;
			gtk_picture_set_paintable (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_picture_get_type (), GtkPicture), NULL);
		}
	}
	_tmp30_ = self->priv->_child_widget;
	g_signal_emit_by_name (_tmp30_, "destroy");
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->overlay);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->priv->scroller);
	_g_object_unref0 (self->priv->_child_widget);
	_g_free0 (self->priv->_url);
	G_OBJECT_CLASS (tuba_views_media_viewer_item_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tuba_views_media_viewer_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TubaViewsMediaViewerItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_views_media_viewer_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaViewsMediaViewerItem), 0, (GInstanceInitFunc) tuba_views_media_viewer_item_instance_init, NULL };
	GType tuba_views_media_viewer_item_type_id;
	tuba_views_media_viewer_item_type_id = g_type_register_static (adw_bin_get_type (), "TubaViewsMediaViewerItem", &g_define_type_info, 0);
	TubaViewsMediaViewerItem_private_offset = g_type_add_instance_private (tuba_views_media_viewer_item_type_id, sizeof (TubaViewsMediaViewerItemPrivate));
	return tuba_views_media_viewer_item_type_id;
}

GType
tuba_views_media_viewer_item_get_type (void)
{
	static gsize tuba_views_media_viewer_item_type_id__once = 0;
	if (g_once_init_enter (&tuba_views_media_viewer_item_type_id__once)) {
		GType tuba_views_media_viewer_item_type_id;
		tuba_views_media_viewer_item_type_id = tuba_views_media_viewer_item_get_type_once ();
		g_once_init_leave (&tuba_views_media_viewer_item_type_id__once, tuba_views_media_viewer_item_type_id);
	}
	return tuba_views_media_viewer_item_type_id__once;
}

static void
_vala_tuba_views_media_viewer_item_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	TubaViewsMediaViewerItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_VIEWS_MEDIA_VIEWER_TYPE_ITEM, TubaViewsMediaViewerItem);
	switch (property_id) {
		case TUBA_VIEWS_MEDIA_VIEWER_ITEM_CHILD_WIDGET_PROPERTY:
		g_value_set_object (value, tuba_views_media_viewer_item_get_child_widget (self));
		break;
		case TUBA_VIEWS_MEDIA_VIEWER_ITEM_IS_VIDEO_PROPERTY:
		g_value_set_boolean (value, tuba_views_media_viewer_item_get_is_video (self));
		break;
		case TUBA_VIEWS_MEDIA_VIEWER_ITEM_IS_AUDIO_PROPERTY:
		g_value_set_boolean (value, tuba_views_media_viewer_item_get_is_audio (self));
		break;
		case TUBA_VIEWS_MEDIA_VIEWER_ITEM_URL_PROPERTY:
		g_value_set_string (value, tuba_views_media_viewer_item_get_url (self));
		break;
		case TUBA_VIEWS_MEDIA_VIEWER_ITEM_LAST_X_PROPERTY:
		g_value_set_double (value, tuba_views_media_viewer_item_get_last_x (self));
		break;
		case TUBA_VIEWS_MEDIA_VIEWER_ITEM_LAST_Y_PROPERTY:
		g_value_set_double (value, tuba_views_media_viewer_item_get_last_y (self));
		break;
		case TUBA_VIEWS_MEDIA_VIEWER_ITEM_PLAYING_PROPERTY:
		g_value_set_boolean (value, tuba_views_media_viewer_item_get_playing (self));
		break;
		case TUBA_VIEWS_MEDIA_VIEWER_ITEM_CAN_ZOOM_IN_PROPERTY:
		g_value_set_boolean (value, tuba_views_media_viewer_item_get_can_zoom_in (self));
		break;
		case TUBA_VIEWS_MEDIA_VIEWER_ITEM_CAN_ZOOM_OUT_PROPERTY:
		g_value_set_boolean (value, tuba_views_media_viewer_item_get_can_zoom_out (self));
		break;
		case TUBA_VIEWS_MEDIA_VIEWER_ITEM_CHILD_WIDTH_PROPERTY:
		g_value_set_int (value, tuba_views_media_viewer_item_get_child_width (self));
		break;
		case TUBA_VIEWS_MEDIA_VIEWER_ITEM_CHILD_HEIGHT_PROPERTY:
		g_value_set_int (value, tuba_views_media_viewer_item_get_child_height (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tuba_views_media_viewer_item_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	TubaViewsMediaViewerItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_VIEWS_MEDIA_VIEWER_TYPE_ITEM, TubaViewsMediaViewerItem);
	switch (property_id) {
		case TUBA_VIEWS_MEDIA_VIEWER_ITEM_CHILD_WIDGET_PROPERTY:
		tuba_views_media_viewer_item_set_child_widget (self, g_value_get_object (value));
		break;
		case TUBA_VIEWS_MEDIA_VIEWER_ITEM_IS_VIDEO_PROPERTY:
		tuba_views_media_viewer_item_set_is_video (self, g_value_get_boolean (value));
		break;
		case TUBA_VIEWS_MEDIA_VIEWER_ITEM_IS_AUDIO_PROPERTY:
		tuba_views_media_viewer_item_set_is_audio (self, g_value_get_boolean (value));
		break;
		case TUBA_VIEWS_MEDIA_VIEWER_ITEM_URL_PROPERTY:
		tuba_views_media_viewer_item_set_url (self, g_value_get_string (value));
		break;
		case TUBA_VIEWS_MEDIA_VIEWER_ITEM_LAST_X_PROPERTY:
		tuba_views_media_viewer_item_set_last_x (self, g_value_get_double (value));
		break;
		case TUBA_VIEWS_MEDIA_VIEWER_ITEM_LAST_Y_PROPERTY:
		tuba_views_media_viewer_item_set_last_y (self, g_value_get_double (value));
		break;
		case TUBA_VIEWS_MEDIA_VIEWER_ITEM_PLAYING_PROPERTY:
		tuba_views_media_viewer_item_set_playing (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_tuba_views_media_viewer___lambda42_ (TubaViewsMediaViewer* self)
{
	tuba_views_media_viewer_clapper_cache_cleanup (self, TRUE);
}

static void
__tuba_views_media_viewer___lambda42__g_application_shutdown (GApplication* _sender,
                                                              gpointer self)
{
	_tuba_views_media_viewer___lambda42_ ((TubaViewsMediaViewer*) self);
}

static void
_tuba_views_media_viewer_on_drag_begin_gtk_gesture_drag_drag_begin (GtkGestureDrag* _sender,
                                                                    gdouble start_x,
                                                                    gdouble start_y,
                                                                    gpointer self)
{
	tuba_views_media_viewer_on_drag_begin ((TubaViewsMediaViewer*) self, start_x, start_y);
}

static void
_tuba_views_media_viewer_on_drag_update_gtk_gesture_drag_drag_update (GtkGestureDrag* _sender,
                                                                      gdouble offset_x,
                                                                      gdouble offset_y,
                                                                      gpointer self)
{
	tuba_views_media_viewer_on_drag_update ((TubaViewsMediaViewer*) self, offset_x, offset_y);
}

static void
_tuba_views_media_viewer_on_drag_end_gtk_gesture_drag_drag_end (GtkGestureDrag* _sender,
                                                                gdouble offset_x,
                                                                gdouble offset_y,
                                                                gpointer self)
{
	tuba_views_media_viewer_on_drag_end ((TubaViewsMediaViewer*) self, offset_x, offset_y);
}

static void
_tuba_views_media_viewer_on_scale_changed_gtk_gesture_zoom_scale_changed (GtkGestureZoom* _sender,
                                                                          gdouble scale,
                                                                          gpointer self)
{
	tuba_views_media_viewer_on_scale_changed ((TubaViewsMediaViewer*) self, scale);
}

static void
_tuba_views_media_viewer_on_scale_end_gtk_gesture_end (GtkGesture* _sender,
                                                       GdkEventSequence* sequence,
                                                       gpointer self)
{
	tuba_views_media_viewer_on_scale_end ((TubaViewsMediaViewer*) self, sequence);
}

static void
_tuba_views_media_viewer_on_motion_gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                                       gdouble x,
                                                                       gdouble y,
                                                                       gpointer self)
{
	tuba_views_media_viewer_on_motion ((TubaViewsMediaViewer*) self, x, y);
}

static void
_tuba_views_media_viewer_copy_media_g_simple_action_activate (GSimpleAction* _sender,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	tuba_views_media_viewer_copy_media ((TubaViewsMediaViewer*) self);
}

static void
_tuba_views_media_viewer_on_visible_toggle_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	tuba_views_media_viewer_on_visible_toggle ((TubaViewsMediaViewer*) self);
}

static void
_tuba_views_media_viewer_on_carousel_n_pages_changed_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self)
{
	tuba_views_media_viewer_on_carousel_n_pages_changed ((TubaViewsMediaViewer*) self);
}

static void
_tuba_views_media_viewer_on_carousel_page_changed_adw_carousel_page_changed (AdwCarousel* _sender,
                                                                             guint index,
                                                                             gpointer self)
{
	tuba_views_media_viewer_on_carousel_page_changed ((TubaViewsMediaViewer*) self, index);
}

static void
_tuba_views_media_viewer_on_scale_revealer_transition_end_tuba_widgets_scale_revealer_transition_done (TubaWidgetsScaleRevealer* _sender,
                                                                                                       gpointer self)
{
	tuba_views_media_viewer_on_scale_revealer_transition_end ((TubaViewsMediaViewer*) self);
}

static GObject *
tuba_views_media_viewer_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TubaViewsMediaViewer * self;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* dir = NULL;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	TubaApplication* _tmp12_;
	TubaSettings* _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	GtkShortcutController* shortcutscontroller = NULL;
	GtkShortcutController* _tmp17_;
	GtkShortcutController* _tmp18_;
	GtkShortcutTrigger* _tmp19_;
	GtkNamedAction* _tmp20_;
	GtkShortcut* _tmp21_;
	GtkShortcutController* _tmp22_;
	GtkShortcutTrigger* _tmp23_;
	GtkNamedAction* _tmp24_;
	GtkShortcut* _tmp25_;
	GtkShortcutController* _tmp26_;
	GtkShortcutTrigger* _tmp27_;
	GtkNamedAction* _tmp28_;
	GtkShortcut* _tmp29_;
	GtkShortcutController* _tmp30_;
	GtkShortcutTrigger* _tmp31_;
	GtkNamedAction* _tmp32_;
	GtkShortcut* _tmp33_;
	GtkShortcutController* _tmp34_;
	GtkShortcutTrigger* _tmp35_;
	GtkNamedAction* _tmp36_;
	GtkShortcut* _tmp37_;
	GtkShortcutController* _tmp38_;
	GtkShortcutTrigger* _tmp39_;
	GtkNamedAction* _tmp40_;
	GtkShortcut* _tmp41_;
	GtkShortcutController* _tmp42_;
	GtkShortcutTrigger* _tmp43_;
	GtkNamedAction* _tmp44_;
	GtkShortcut* _tmp45_;
	GtkShortcutController* _tmp46_;
	GtkShortcutTrigger* _tmp47_;
	GtkNamedAction* _tmp48_;
	GtkShortcut* _tmp49_;
	GtkShortcutController* _tmp50_;
	GtkShortcutTrigger* _tmp51_;
	GtkNamedAction* _tmp52_;
	GtkShortcut* _tmp53_;
	GtkShortcutController* _tmp54_;
	GtkShortcutTrigger* _tmp55_;
	GtkNamedAction* _tmp56_;
	GtkShortcut* _tmp57_;
	GtkShortcutController* _tmp58_;
	GtkShortcutTrigger* _tmp59_;
	GtkNamedAction* _tmp60_;
	GtkShortcut* _tmp61_;
	GtkShortcutController* _tmp62_;
	GtkShortcutTrigger* _tmp63_;
	GtkNamedAction* _tmp64_;
	GtkShortcut* _tmp65_;
	GtkShortcutController* _tmp66_;
	GtkShortcutTrigger* _tmp67_;
	GtkNamedAction* _tmp68_;
	GtkShortcut* _tmp69_;
	GtkShortcutController* _tmp70_;
	GtkShortcutTrigger* _tmp71_;
	GtkNamedAction* _tmp72_;
	GtkShortcut* _tmp73_;
	GtkShortcutController* _tmp74_;
	GtkShortcutTrigger* _tmp75_;
	GtkNamedAction* _tmp76_;
	GtkShortcut* _tmp77_;
	GtkShortcutController* _tmp78_;
	GtkShortcutTrigger* _tmp79_;
	GtkNamedAction* _tmp80_;
	GtkShortcut* _tmp81_;
	GtkShortcutController* _tmp82_;
	GtkShortcutTrigger* _tmp83_;
	GtkNamedAction* _tmp84_;
	GtkShortcut* _tmp85_;
	GtkShortcutController* _tmp86_;
	GtkShortcutTrigger* _tmp87_;
	GtkNamedAction* _tmp88_;
	GtkShortcut* _tmp89_;
	GtkShortcutController* _tmp90_;
	GtkShortcutTrigger* _tmp91_;
	GtkNamedAction* _tmp92_;
	GtkShortcut* _tmp93_;
	GtkShortcutController* _tmp94_;
	GtkShortcutTrigger* _tmp95_;
	GtkNamedAction* _tmp96_;
	GtkShortcut* _tmp97_;
	GtkShortcutController* _tmp98_;
	GtkShortcutTrigger* _tmp99_;
	GtkNamedAction* _tmp100_;
	GtkShortcut* _tmp101_;
	GtkShortcutController* _tmp102_;
	GtkEventController* _tmp103_;
	GtkGestureDrag* drag = NULL;
	GtkGestureDrag* _tmp104_;
	GtkGestureDrag* _tmp105_;
	GtkGestureDrag* _tmp106_;
	GtkGestureDrag* _tmp107_;
	GtkGestureDrag* _tmp108_;
	GtkEventController* _tmp109_;
	GtkGestureZoom* gesture = NULL;
	GtkGestureZoom* _tmp110_;
	GtkGestureZoom* _tmp111_;
	GtkGestureZoom* _tmp112_;
	AdwCarousel* _tmp113_;
	GtkGestureZoom* _tmp114_;
	GtkEventController* _tmp115_;
	GtkEventControllerMotion* motion = NULL;
	GtkEventControllerMotion* _tmp116_;
	GtkEventControllerMotion* _tmp117_;
	GtkEventControllerMotion* _tmp118_;
	GtkEventController* _tmp119_;
	GSimpleActionGroup* actions = NULL;
	GSimpleActionGroup* _tmp120_;
	GSimpleActionGroup* _tmp121_;
	GSimpleAction* _tmp122_;
	GSimpleAction* _tmp123_;
	GSimpleActionGroup* _tmp124_;
	GSimpleAction* _tmp125_;
	GSimpleActionGroup* _tmp126_;
	AdwCarousel* _tmp127_;
	AdwCarousel* _tmp128_;
	TubaWidgetsScaleRevealer* _tmp129_;
	GtkPopoverMenu* _tmp130_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (tuba_views_media_viewer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_VIEWS_TYPE_MEDIA_VIEWER, TubaViewsMediaViewer);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->clapper_cached_urls);
	self->priv->clapper_cached_urls = _tmp0_;
	_tmp1_ = tuba_cache_path;
	_tmp2_ = g_build_path (G_DIR_SEPARATOR_S, _tmp1_, "clapper", NULL);
	_g_free0 (self->priv->clapper_cache_dir);
	self->priv->clapper_cache_dir = _tmp2_;
	_tmp3_ = self->priv->clapper_cache_dir;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	dir = _tmp4_;
	_tmp5_ = dir;
	if (!g_file_query_exists (_tmp5_, NULL)) {
		{
			GFile* _tmp6_;
			_tmp6_ = dir;
			g_file_make_directory_with_parents (_tmp6_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			_tmp9_ = string_to_string (_tmp8_);
			_tmp10_ = g_strconcat ("Couldn't create Clapper cache dir: ", _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			g_critical ("MediaViewer.vala:447: %s", _tmp11_);
			_g_free0 (_tmp11_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
	}
	tuba_views_media_viewer_clapper_cache_cleanup (self, TRUE);
	_tmp12_ = tuba_app;
	g_signal_connect_object ((GApplication*) _tmp12_, "shutdown", (GCallback) __tuba_views_media_viewer___lambda42__g_application_shutdown, self, 0);
	_tmp13_ = tuba_settings;
	_tmp14_ = tuba_settings_get_media_viewer_last_used_volume (_tmp13_);
	_tmp15_ = _tmp14_;
	tuba_views_media_viewer_last_used_volume = _tmp15_;
	if (tuba_is_rtl) {
		GtkButton* _tmp16_;
		_tmp16_ = self->priv->back_btn;
		gtk_button_set_icon_name (_tmp16_, "tuba-right-large-symbolic");
	}
	_tmp17_ = (GtkShortcutController*) gtk_shortcut_controller_new ();
	shortcutscontroller = _tmp17_;
	_tmp18_ = shortcutscontroller;
	_tmp19_ = gtk_shortcut_trigger_parse_string ("Escape");
	_tmp20_ = (GtkNamedAction*) gtk_named_action_new ("app.back");
	_tmp21_ = gtk_shortcut_new (_tmp19_, (GtkShortcutAction*) _tmp20_);
	gtk_shortcut_controller_add_shortcut (_tmp18_, _tmp21_);
	_tmp22_ = shortcutscontroller;
	_tmp23_ = gtk_shortcut_trigger_parse_string ("<Alt>Left");
	_tmp24_ = (GtkNamedAction*) gtk_named_action_new ("app.back");
	_tmp25_ = gtk_shortcut_new (_tmp23_, (GtkShortcutAction*) _tmp24_);
	gtk_shortcut_controller_add_shortcut (_tmp22_, _tmp25_);
	_tmp26_ = shortcutscontroller;
	_tmp27_ = gtk_shortcut_trigger_parse_string ("Pointer_DfltBtnPrev");
	_tmp28_ = (GtkNamedAction*) gtk_named_action_new ("app.back");
	_tmp29_ = gtk_shortcut_new (_tmp27_, (GtkShortcutAction*) _tmp28_);
	gtk_shortcut_controller_add_shortcut (_tmp26_, _tmp29_);
	_tmp30_ = shortcutscontroller;
	_tmp31_ = gtk_shortcut_trigger_parse_string ("F11");
	_tmp32_ = (GtkNamedAction*) gtk_named_action_new ("mediaviewer.fullscreen");
	_tmp33_ = gtk_shortcut_new (_tmp31_, (GtkShortcutAction*) _tmp32_);
	gtk_shortcut_controller_add_shortcut (_tmp30_, _tmp33_);
	_tmp34_ = shortcutscontroller;
	_tmp35_ = gtk_shortcut_trigger_parse_string ("<Ctrl>plus");
	_tmp36_ = (GtkNamedAction*) gtk_named_action_new ("mediaviewer.zoom-in");
	_tmp37_ = gtk_shortcut_new (_tmp35_, (GtkShortcutAction*) _tmp36_);
	gtk_shortcut_controller_add_shortcut (_tmp34_, _tmp37_);
	_tmp38_ = shortcutscontroller;
	_tmp39_ = gtk_shortcut_trigger_parse_string ("<Ctrl><Shift>plus");
	_tmp40_ = (GtkNamedAction*) gtk_named_action_new ("mediaviewer.zoom-in");
	_tmp41_ = gtk_shortcut_new (_tmp39_, (GtkShortcutAction*) _tmp40_);
	gtk_shortcut_controller_add_shortcut (_tmp38_, _tmp41_);
	_tmp42_ = shortcutscontroller;
	_tmp43_ = gtk_shortcut_trigger_parse_string ("<Ctrl>equal");
	_tmp44_ = (GtkNamedAction*) gtk_named_action_new ("mediaviewer.zoom-in");
	_tmp45_ = gtk_shortcut_new (_tmp43_, (GtkShortcutAction*) _tmp44_);
	gtk_shortcut_controller_add_shortcut (_tmp42_, _tmp45_);
	_tmp46_ = shortcutscontroller;
	_tmp47_ = gtk_shortcut_trigger_parse_string ("<Ctrl><Shift>equal");
	_tmp48_ = (GtkNamedAction*) gtk_named_action_new ("mediaviewer.zoom-in");
	_tmp49_ = gtk_shortcut_new (_tmp47_, (GtkShortcutAction*) _tmp48_);
	gtk_shortcut_controller_add_shortcut (_tmp46_, _tmp49_);
	_tmp50_ = shortcutscontroller;
	_tmp51_ = gtk_shortcut_trigger_parse_string ("<Ctrl>KP_Add");
	_tmp52_ = (GtkNamedAction*) gtk_named_action_new ("mediaviewer.zoom-in");
	_tmp53_ = gtk_shortcut_new (_tmp51_, (GtkShortcutAction*) _tmp52_);
	gtk_shortcut_controller_add_shortcut (_tmp50_, _tmp53_);
	_tmp54_ = shortcutscontroller;
	_tmp55_ = gtk_shortcut_trigger_parse_string ("<Ctrl><Shift>KP_Add");
	_tmp56_ = (GtkNamedAction*) gtk_named_action_new ("mediaviewer.zoom-in");
	_tmp57_ = gtk_shortcut_new (_tmp55_, (GtkShortcutAction*) _tmp56_);
	gtk_shortcut_controller_add_shortcut (_tmp54_, _tmp57_);
	_tmp58_ = shortcutscontroller;
	_tmp59_ = gtk_shortcut_trigger_parse_string ("<Ctrl>minus");
	_tmp60_ = (GtkNamedAction*) gtk_named_action_new ("mediaviewer.zoom-out");
	_tmp61_ = gtk_shortcut_new (_tmp59_, (GtkShortcutAction*) _tmp60_);
	gtk_shortcut_controller_add_shortcut (_tmp58_, _tmp61_);
	_tmp62_ = shortcutscontroller;
	_tmp63_ = gtk_shortcut_trigger_parse_string ("<Ctrl><Shift>minus");
	_tmp64_ = (GtkNamedAction*) gtk_named_action_new ("mediaviewer.zoom-out");
	_tmp65_ = gtk_shortcut_new (_tmp63_, (GtkShortcutAction*) _tmp64_);
	gtk_shortcut_controller_add_shortcut (_tmp62_, _tmp65_);
	_tmp66_ = shortcutscontroller;
	_tmp67_ = gtk_shortcut_trigger_parse_string ("<Ctrl>underscore");
	_tmp68_ = (GtkNamedAction*) gtk_named_action_new ("mediaviewer.zoom-out");
	_tmp69_ = gtk_shortcut_new (_tmp67_, (GtkShortcutAction*) _tmp68_);
	gtk_shortcut_controller_add_shortcut (_tmp66_, _tmp69_);
	_tmp70_ = shortcutscontroller;
	_tmp71_ = gtk_shortcut_trigger_parse_string ("<Ctrl><Shift>underscore");
	_tmp72_ = (GtkNamedAction*) gtk_named_action_new ("mediaviewer.zoom-out");
	_tmp73_ = gtk_shortcut_new (_tmp71_, (GtkShortcutAction*) _tmp72_);
	gtk_shortcut_controller_add_shortcut (_tmp70_, _tmp73_);
	_tmp74_ = shortcutscontroller;
	_tmp75_ = gtk_shortcut_trigger_parse_string ("<Ctrl>KP_Subtract");
	_tmp76_ = (GtkNamedAction*) gtk_named_action_new ("mediaviewer.zoom-out");
	_tmp77_ = gtk_shortcut_new (_tmp75_, (GtkShortcutAction*) _tmp76_);
	gtk_shortcut_controller_add_shortcut (_tmp74_, _tmp77_);
	_tmp78_ = shortcutscontroller;
	_tmp79_ = gtk_shortcut_trigger_parse_string ("<Ctrl><Shift>KP_Subtract");
	_tmp80_ = (GtkNamedAction*) gtk_named_action_new ("mediaviewer.zoom-out");
	_tmp81_ = gtk_shortcut_new (_tmp79_, (GtkShortcutAction*) _tmp80_);
	gtk_shortcut_controller_add_shortcut (_tmp78_, _tmp81_);
	_tmp82_ = shortcutscontroller;
	_tmp83_ = gtk_shortcut_trigger_parse_string ("<Ctrl>C");
	_tmp84_ = (GtkNamedAction*) gtk_named_action_new ("mediaviewer.copy-media");
	_tmp85_ = gtk_shortcut_new (_tmp83_, (GtkShortcutAction*) _tmp84_);
	gtk_shortcut_controller_add_shortcut (_tmp82_, _tmp85_);
	_tmp86_ = shortcutscontroller;
	_tmp87_ = gtk_shortcut_trigger_parse_string ("Left");
	_tmp88_ = (GtkNamedAction*) gtk_named_action_new ("mediaviewer.scroll-back");
	_tmp89_ = gtk_shortcut_new (_tmp87_, (GtkShortcutAction*) _tmp88_);
	gtk_shortcut_controller_add_shortcut (_tmp86_, _tmp89_);
	_tmp90_ = shortcutscontroller;
	_tmp91_ = gtk_shortcut_trigger_parse_string ("KP_Left");
	_tmp92_ = (GtkNamedAction*) gtk_named_action_new ("mediaviewer.scroll-back");
	_tmp93_ = gtk_shortcut_new (_tmp91_, (GtkShortcutAction*) _tmp92_);
	gtk_shortcut_controller_add_shortcut (_tmp90_, _tmp93_);
	_tmp94_ = shortcutscontroller;
	_tmp95_ = gtk_shortcut_trigger_parse_string ("Right");
	_tmp96_ = (GtkNamedAction*) gtk_named_action_new ("mediaviewer.scroll-next");
	_tmp97_ = gtk_shortcut_new (_tmp95_, (GtkShortcutAction*) _tmp96_);
	gtk_shortcut_controller_add_shortcut (_tmp94_, _tmp97_);
	_tmp98_ = shortcutscontroller;
	_tmp99_ = gtk_shortcut_trigger_parse_string ("KP_Right");
	_tmp100_ = (GtkNamedAction*) gtk_named_action_new ("mediaviewer.scroll-next");
	_tmp101_ = gtk_shortcut_new (_tmp99_, (GtkShortcutAction*) _tmp100_);
	gtk_shortcut_controller_add_shortcut (_tmp98_, _tmp101_);
	_tmp102_ = shortcutscontroller;
	_tmp103_ = _g_object_ref0 ((GtkEventController*) _tmp102_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp103_);
	_tmp104_ = (GtkGestureDrag*) gtk_gesture_drag_new ();
	drag = _tmp104_;
	_tmp105_ = drag;
	g_signal_connect_object (_tmp105_, "drag-begin", (GCallback) _tuba_views_media_viewer_on_drag_begin_gtk_gesture_drag_drag_begin, self, 0);
	_tmp106_ = drag;
	g_signal_connect_object (_tmp106_, "drag-update", (GCallback) _tuba_views_media_viewer_on_drag_update_gtk_gesture_drag_drag_update, self, 0);
	_tmp107_ = drag;
	g_signal_connect_object (_tmp107_, "drag-end", (GCallback) _tuba_views_media_viewer_on_drag_end_gtk_gesture_drag_drag_end, self, 0);
	_tmp108_ = drag;
	_tmp109_ = _g_object_ref0 ((GtkEventController*) _tmp108_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp109_);
	_tmp110_ = (GtkGestureZoom*) gtk_gesture_zoom_new ();
	gesture = _tmp110_;
	_tmp111_ = gesture;
	g_signal_connect_object (_tmp111_, "scale-changed", (GCallback) _tuba_views_media_viewer_on_scale_changed_gtk_gesture_zoom_scale_changed, self, 0);
	_tmp112_ = gesture;
	g_signal_connect_object ((GtkGesture*) _tmp112_, "end", (GCallback) _tuba_views_media_viewer_on_scale_end_gtk_gesture_end, self, 0);
	_tmp113_ = self->priv->carousel;
	_tmp114_ = gesture;
	_tmp115_ = _g_object_ref0 ((GtkEventController*) _tmp114_);
	gtk_widget_add_controller ((GtkWidget*) _tmp113_, _tmp115_);
	_tmp116_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ();
	motion = _tmp116_;
	_tmp117_ = motion;
	g_signal_connect_object (_tmp117_, "motion", (GCallback) _tuba_views_media_viewer_on_motion_gtk_event_controller_motion_motion, self, 0);
	_tmp118_ = motion;
	_tmp119_ = _g_object_ref0 ((GtkEventController*) _tmp118_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp119_);
	_tmp120_ = g_simple_action_group_new ();
	actions = _tmp120_;
	_tmp121_ = actions;
	g_action_map_add_action_entries ((GActionMap*) _tmp121_, TUBA_VIEWS_MEDIA_VIEWER_ACTION_ENTRIES, (gint) G_N_ELEMENTS (TUBA_VIEWS_MEDIA_VIEWER_ACTION_ENTRIES), self);
	_tmp122_ = g_simple_action_new ("copy-media", NULL);
	_g_object_unref0 (self->copy_media_simple_action);
	self->copy_media_simple_action = _tmp122_;
	_tmp123_ = self->copy_media_simple_action;
	g_signal_connect_object (_tmp123_, "activate", (GCallback) _tuba_views_media_viewer_copy_media_g_simple_action_activate, self, 0);
	_tmp124_ = actions;
	_tmp125_ = self->copy_media_simple_action;
	g_action_map_add_action ((GActionMap*) _tmp124_, (GAction*) _tmp125_);
	_tmp126_ = actions;
	gtk_widget_insert_action_group ((GtkWidget*) self, "mediaviewer", (GActionGroup*) _tmp126_);
	g_signal_connect_object ((GObject*) self, "notify::visible", (GCallback) _tuba_views_media_viewer_on_visible_toggle_g_object_notify, self, 0);
	_tmp127_ = self->priv->carousel;
	g_signal_connect_object ((GObject*) _tmp127_, "notify::n-pages", (GCallback) _tuba_views_media_viewer_on_carousel_n_pages_changed_g_object_notify, self, 0);
	_tmp128_ = self->priv->carousel;
	g_signal_connect_object (_tmp128_, "page-changed", (GCallback) _tuba_views_media_viewer_on_carousel_page_changed_adw_carousel_page_changed, self, 0);
	_tmp129_ = self->priv->scale_revealer;
	g_signal_connect_object (_tmp129_, "transition-done", (GCallback) _tuba_views_media_viewer_on_scale_revealer_transition_end_tuba_widgets_scale_revealer_transition_done, self, 0);
	_tmp130_ = self->priv->context_menu;
	gtk_widget_set_parent ((GtkWidget*) _tmp130_, (GtkWidget*) self);
	tuba_views_media_viewer_setup_mouse_previous_click (self);
	tuba_views_media_viewer_setup_mouse1_click (self);
	tuba_views_media_viewer_setup_mouse_secondary_click (self);
	tuba_views_media_viewer_setup_swipe_close (self);
	_g_object_unref0 (actions);
	_g_object_unref0 (motion);
	_g_object_unref0 (gesture);
	_g_object_unref0 (drag);
	_g_object_unref0 (shortcutscontroller);
	_g_object_unref0 (dir);
	return obj;
}

static void
tuba_views_media_viewer_class_init (TubaViewsMediaViewerClass * klass,
                                    gpointer klass_data)
{
	tuba_views_media_viewer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TubaViewsMediaViewer_private_offset);
	((GtkWidgetClass *) klass)->measure = (void (*) (GtkWidget*, GtkOrientation, gint, gint*, gint*, gint*, gint*)) tuba_views_media_viewer_real_measure;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) tuba_views_media_viewer_real_size_allocate;
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) tuba_views_media_viewer_real_snapshot;
	G_OBJECT_CLASS (klass)->get_property = _vala_tuba_views_media_viewer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tuba_views_media_viewer_set_property;
	G_OBJECT_CLASS (klass)->constructor = tuba_views_media_viewer_constructor;
	G_OBJECT_CLASS (klass)->finalize = tuba_views_media_viewer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_VIEWS_MEDIA_VIEWER_FULLSCREEN_PROPERTY, tuba_views_media_viewer_properties[TUBA_VIEWS_MEDIA_VIEWER_FULLSCREEN_PROPERTY] = g_param_spec_boolean ("fullscreen", "fullscreen", "fullscreen", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/dev/geopjr/Tuba/ui/views/media_viewer.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "context_menu", FALSE, TubaViewsMediaViewer_private_offset + G_STRUCT_OFFSET (TubaViewsMediaViewerPrivate, context_menu));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fullscreen_btn", FALSE, TubaViewsMediaViewer_private_offset + G_STRUCT_OFFSET (TubaViewsMediaViewerPrivate, fullscreen_btn));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, TubaViewsMediaViewer_private_offset + G_STRUCT_OFFSET (TubaViewsMediaViewerPrivate, headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_btn", FALSE, TubaViewsMediaViewer_private_offset + G_STRUCT_OFFSET (TubaViewsMediaViewerPrivate, back_btn));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "toggle_fs_revealer", FALSE, TubaViewsMediaViewer_private_offset + G_STRUCT_OFFSET (TubaViewsMediaViewerPrivate, toggle_fs_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_buttons_revealer", FALSE, TubaViewsMediaViewer_private_offset + G_STRUCT_OFFSET (TubaViewsMediaViewerPrivate, page_buttons_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "prev_btn", FALSE, TubaViewsMediaViewer_private_offset + G_STRUCT_OFFSET (TubaViewsMediaViewerPrivate, prev_btn));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "next_btn", FALSE, TubaViewsMediaViewer_private_offset + G_STRUCT_OFFSET (TubaViewsMediaViewerPrivate, next_btn));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "zoom_buttons_revealer", FALSE, TubaViewsMediaViewer_private_offset + G_STRUCT_OFFSET (TubaViewsMediaViewerPrivate, zoom_buttons_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "zoom_out_btn", FALSE, TubaViewsMediaViewer_private_offset + G_STRUCT_OFFSET (TubaViewsMediaViewerPrivate, zoom_out_btn));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "zoom_in_btn", FALSE, TubaViewsMediaViewer_private_offset + G_STRUCT_OFFSET (TubaViewsMediaViewerPrivate, zoom_in_btn));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scale_revealer", FALSE, TubaViewsMediaViewer_private_offset + G_STRUCT_OFFSET (TubaViewsMediaViewerPrivate, scale_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "carousel", FALSE, TubaViewsMediaViewer_private_offset + G_STRUCT_OFFSET (TubaViewsMediaViewerPrivate, carousel));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "clear", G_CALLBACK(_tuba_views_media_viewer_clear_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "toggle_fullscreen", G_CALLBACK(_tuba_views_media_viewer_toggle_fullscreen_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_previous_clicked", G_CALLBACK(_tuba_views_media_viewer_on_previous_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_next_clicked", G_CALLBACK(_tuba_views_media_viewer_on_next_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_zoom_out_clicked", G_CALLBACK(_tuba_views_media_viewer_on_zoom_out_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_zoom_in_clicked", G_CALLBACK(_tuba_views_media_viewer_on_zoom_in_clicked_gtk_button_clicked));
	g_type_ensure (TUBA_WIDGETS_TYPE_SCALE_REVEALER);
}

static void
tuba_views_media_viewer_gtk_buildable_interface_init (GtkBuildableIface * iface,
                                                      gpointer iface_data)
{
	tuba_views_media_viewer_gtk_buildable_parent_iface = g_type_interface_peek_parent (iface);
}

static void
tuba_views_media_viewer_adw_swipeable_interface_init (AdwSwipeableInterface * iface,
                                                      gpointer iface_data)
{
	tuba_views_media_viewer_adw_swipeable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_cancel_progress = (gdouble (*) (AdwSwipeable*)) tuba_views_media_viewer_real_get_cancel_progress;
	iface->get_distance = (gdouble (*) (AdwSwipeable*)) tuba_views_media_viewer_real_get_distance;
	iface->get_progress = (gdouble (*) (AdwSwipeable*)) tuba_views_media_viewer_real_get_progress;
	iface->get_snap_points = (gdouble* (*) (AdwSwipeable*, gint*)) tuba_views_media_viewer_real_get_snap_points;
	iface->get_swipe_area = (void (*) (AdwSwipeable*, AdwNavigationDirection, gboolean, GdkRectangle*)) tuba_views_media_viewer_real_get_swipe_area;
}

static void
tuba_views_media_viewer_instance_init (TubaViewsMediaViewer * self,
                                       gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	self->priv = tuba_views_media_viewer_get_instance_private (self);
	self->priv->_fullscreen = FALSE;
	_tmp0_ = gee_array_list_new (TUBA_VIEWS_MEDIA_VIEWER_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->items = _tmp0_;
	self->priv->on_motion_last_x = 0.0;
	self->priv->on_motion_last_y = 0.0;
	self->priv->revealer_timeout = (guint) 0;
	self->priv->revealed = FALSE;
	self->priv->load_and_scroll_to = -1;
	_tmp1_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, gtk_widget_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->revealer_widgets = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	self->priv->clapper_cached_locations = _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	self->priv->todo_items = _tmp3_;
	self->priv->old_pos = (guint) 500;
	g_type_ensure (TUBA_WIDGETS_TYPE_SCALE_REVEALER);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
tuba_views_media_viewer_finalize (GObject * obj)
{
	TubaViewsMediaViewer * self;
	GtkPopoverMenu* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeArrayList* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_VIEWS_TYPE_MEDIA_VIEWER, TubaViewsMediaViewer);
	g_debug ("MediaViewer.vala:589: Destroying MediaViewer");
	_tmp0_ = self->priv->context_menu;
	gtk_widget_unparent ((GtkWidget*) _tmp0_);
	tuba_views_media_viewer_clapper_cache_cleanup (self, TRUE);
	_tmp1_ = self->priv->clapper_cached_urls;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp1_);
	_tmp2_ = self->priv->clapper_cached_locations;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
	_g_object_unref0 (self->priv->items);
	_g_object_unref0 (self->copy_media_simple_action);
	_g_free0 (self->priv->clapper_cache_dir);
	_g_object_unref0 (self->priv->clapper_cached_urls);
	_g_object_unref0 (self->swipe_tracker);
	_g_free0 (self->priv->old_height);
	_g_free0 (self->priv->old_width);
	_g_object_unref0 (self->revealer_widgets);
	_g_object_unref0 (self->priv->clapper_cached_locations);
	_g_object_unref0 (self->priv->todo_items);
	G_OBJECT_CLASS (tuba_views_media_viewer_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tuba_views_media_viewer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TubaViewsMediaViewerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_views_media_viewer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaViewsMediaViewer), 0, (GInstanceInitFunc) tuba_views_media_viewer_instance_init, NULL };
	static const GInterfaceInfo gtk_buildable_info = { (GInterfaceInitFunc) tuba_views_media_viewer_gtk_buildable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo adw_swipeable_info = { (GInterfaceInitFunc) tuba_views_media_viewer_adw_swipeable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType tuba_views_media_viewer_type_id;
	tuba_views_media_viewer_type_id = g_type_register_static (gtk_widget_get_type (), "TubaViewsMediaViewer", &g_define_type_info, 0);
	g_type_add_interface_static (tuba_views_media_viewer_type_id, gtk_buildable_get_type (), &gtk_buildable_info);
	g_type_add_interface_static (tuba_views_media_viewer_type_id, adw_swipeable_get_type (), &adw_swipeable_info);
	TubaViewsMediaViewer_private_offset = g_type_add_instance_private (tuba_views_media_viewer_type_id, sizeof (TubaViewsMediaViewerPrivate));
	return tuba_views_media_viewer_type_id;
}

GType
tuba_views_media_viewer_get_type (void)
{
	static gsize tuba_views_media_viewer_type_id__once = 0;
	if (g_once_init_enter (&tuba_views_media_viewer_type_id__once)) {
		GType tuba_views_media_viewer_type_id;
		tuba_views_media_viewer_type_id = tuba_views_media_viewer_get_type_once ();
		g_once_init_leave (&tuba_views_media_viewer_type_id__once, tuba_views_media_viewer_type_id);
	}
	return tuba_views_media_viewer_type_id__once;
}

static void
_vala_tuba_views_media_viewer_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	TubaViewsMediaViewer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_VIEWS_TYPE_MEDIA_VIEWER, TubaViewsMediaViewer);
	switch (property_id) {
		case TUBA_VIEWS_MEDIA_VIEWER_FULLSCREEN_PROPERTY:
		g_value_set_boolean (value, tuba_views_media_viewer_get_fullscreen (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tuba_views_media_viewer_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	TubaViewsMediaViewer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_VIEWS_TYPE_MEDIA_VIEWER, TubaViewsMediaViewer);
	switch (property_id) {
		case TUBA_VIEWS_MEDIA_VIEWER_FULLSCREEN_PROPERTY:
		tuba_views_media_viewer_set_fullscreen (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

