/*
* Copyright (C) 2017-2023 Apple Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* 1.  Redistributions of source code must retain the above copyright
*     notice, this list of conditions and the following disclaimer.
* 2.  Redistributions in binary form must reproduce the above copyright
*     notice, this list of conditions and the following disclaimer in the
*     documentation and/or other materials provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
* THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

// DO NO EDIT! - This file was generated by /build/webkit2gtk/src/webkitgtk-2.50.5/Source/JavaScriptCore/yarr/generateYarrUnicodePropertyTables.py
static std::unique_ptr<CharacterClass> createCharacterClass0()
{
    // Name = Any, number of codePoints: 1114112
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x00, 0x7f}}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0080, 0x10ffff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass1()
{
    // Name = ASCII, number of codePoints: 128
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x00, 0x7f}}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass2()
{
    // Name = Assigned, number of codePoints: 299426
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x00, 0x7f}}),
        std::initializer_list<char32_t>({0x038c, 0x085e, 0x09b2, 0x09d7, 0x0a3c, 0x0a51, 0x0a5e, 0x0ad0, 
            0x0b9c, 0x0bd0, 0x0bd7, 0x0dbd, 0x0dca, 0x0dd6, 0x0e84, 0x0ea5, 
            0x0ec6, 0x10c7, 0x10cd, 0x1258, 0x12c0, 0x1940, 0x1f59, 0x1f5b, 
            0x1f5d, 0x2d27, 0x2d2d, 0xfb3e, 0xfeff, 0x101a0, 0x10808, 0x1083c, 
            0x110cd, 0x11288, 0x11350, 0x11357, 0x1138b, 0x1138e, 0x113c2, 0x113c5, 
            0x11909, 0x11d3a, 0x11fb0, 0x1b132, 0x1b155, 0x1d4a2, 0x1d4bb, 0x1d546, 
            0x1e08f, 0x1e2ff, 0x1e5ff, 0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 0x1ee42, 
            0x1ee47, 0x1ee49, 0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 0x1ee5d, 
            0x1ee5f, 0x1ee64, 0x1ee7e, 0x1f7f0, 0x1fac8, 0xe0001}),
        std::initializer_list<CharacterRange>({{0x0080, 0x0377}, {0x037a, 0x037f}, {0x0384, 0x038a}, {0x038e, 0x03a1}, 
            {0x03a3, 0x052f}, {0x0531, 0x0556}, {0x0559, 0x058a}, {0x058d, 0x058f}, 
            {0x0591, 0x05c7}, {0x05d0, 0x05ea}, {0x05ef, 0x05f4}, {0x0600, 0x070d}, 
            {0x070f, 0x074a}, {0x074d, 0x07b1}, {0x07c0, 0x07fa}, {0x07fd, 0x082d}, 
            {0x0830, 0x083e}, {0x0840, 0x085b}, {0x0860, 0x086a}, {0x0870, 0x0891}, 
            {0x0897, 0x0983}, {0x0985, 0x098c}, {0x098f, 0x0990}, {0x0993, 0x09a8}, 
            {0x09aa, 0x09b0}, {0x09b6, 0x09b9}, {0x09bc, 0x09c4}, {0x09c7, 0x09c8}, 
            {0x09cb, 0x09ce}, {0x09dc, 0x09dd}, {0x09df, 0x09e3}, {0x09e6, 0x09ff}, 
            {0x0a01, 0x0a03}, {0x0a05, 0x0a0a}, {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, 
            {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, 
            {0x0a3e, 0x0a42}, {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a59, 0x0a5c}, 
            {0x0a66, 0x0a76}, {0x0a81, 0x0a83}, {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, 
            {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0}, {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, 
            {0x0abc, 0x0ac5}, {0x0ac7, 0x0ac9}, {0x0acb, 0x0acd}, {0x0ae0, 0x0ae3}, 
            {0x0ae6, 0x0af1}, {0x0af9, 0x0aff}, {0x0b01, 0x0b03}, {0x0b05, 0x0b0c}, 
            {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, 
            {0x0b35, 0x0b39}, {0x0b3c, 0x0b44}, {0x0b47, 0x0b48}, {0x0b4b, 0x0b4d}, 
            {0x0b53, 0x0b57}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b63}, {0x0b66, 0x0b77}, 
            {0x0b82, 0x0b83}, {0x0b85, 0x0b8a}, {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, 
            {0x0b99, 0x0b9a}, {0x0b9e, 0x0b9f}, {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, 
            {0x0bae, 0x0bb9}, {0x0bbe, 0x0bc2}, {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcd}, 
            {0x0be6, 0x0bfa}, {0x0c00, 0x0c0c}, {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, 
            {0x0c2a, 0x0c39}, {0x0c3c, 0x0c44}, {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d}, 
            {0x0c55, 0x0c56}, {0x0c58, 0x0c5a}, {0x0c5c, 0x0c5d}, {0x0c60, 0x0c63}, 
            {0x0c66, 0x0c6f}, {0x0c77, 0x0c8c}, {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, 
            {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0cbc, 0x0cc4}, {0x0cc6, 0x0cc8}, 
            {0x0cca, 0x0ccd}, {0x0cd5, 0x0cd6}, {0x0cdc, 0x0cde}, {0x0ce0, 0x0ce3}, 
            {0x0ce6, 0x0cef}, {0x0cf1, 0x0cf3}, {0x0d00, 0x0d0c}, {0x0d0e, 0x0d10}, 
            {0x0d12, 0x0d44}, {0x0d46, 0x0d48}, {0x0d4a, 0x0d4f}, {0x0d54, 0x0d63}, 
            {0x0d66, 0x0d7f}, {0x0d81, 0x0d83}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, 
            {0x0db3, 0x0dbb}, {0x0dc0, 0x0dc6}, {0x0dcf, 0x0dd4}, {0x0dd8, 0x0ddf}, 
            {0x0de6, 0x0def}, {0x0df2, 0x0df4}, {0x0e01, 0x0e3a}, {0x0e3f, 0x0e5b}, 
            {0x0e81, 0x0e82}, {0x0e86, 0x0e8a}, {0x0e8c, 0x0ea3}, {0x0ea7, 0x0ebd}, 
            {0x0ec0, 0x0ec4}, {0x0ec8, 0x0ece}, {0x0ed0, 0x0ed9}, {0x0edc, 0x0edf}, 
            {0x0f00, 0x0f47}, {0x0f49, 0x0f6c}, {0x0f71, 0x0f97}, {0x0f99, 0x0fbc}, 
            {0x0fbe, 0x0fcc}, {0x0fce, 0x0fda}, {0x1000, 0x10c5}, {0x10d0, 0x1248}, 
            {0x124a, 0x124d}, {0x1250, 0x1256}, {0x125a, 0x125d}, {0x1260, 0x1288}, 
            {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, 
            {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, 
            {0x1318, 0x135a}, {0x135d, 0x137c}, {0x1380, 0x1399}, {0x13a0, 0x13f5}, 
            {0x13f8, 0x13fd}, {0x1400, 0x169c}, {0x16a0, 0x16f8}, {0x1700, 0x1715}, 
            {0x171f, 0x1736}, {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, 
            {0x1772, 0x1773}, {0x1780, 0x17dd}, {0x17e0, 0x17e9}, {0x17f0, 0x17f9}, 
            {0x1800, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, 
            {0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x193b}, {0x1944, 0x196d}, 
            {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, 
            {0x19de, 0x1a1b}, {0x1a1e, 0x1a5e}, {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, 
            {0x1a90, 0x1a99}, {0x1aa0, 0x1aad}, {0x1ab0, 0x1add}, {0x1ae0, 0x1aeb}, 
            {0x1b00, 0x1b4c}, {0x1b4e, 0x1bf3}, {0x1bfc, 0x1c37}, {0x1c3b, 0x1c49}, 
            {0x1c4d, 0x1c8a}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cc7}, {0x1cd0, 0x1cfa}, 
            {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, 
            {0x1f50, 0x1f57}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fc4}, 
            {0x1fc6, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fdd, 0x1fef}, {0x1ff2, 0x1ff4}, 
            {0x1ff6, 0x1ffe}, {0x2000, 0x2064}, {0x2066, 0x2071}, {0x2074, 0x208e}, 
            {0x2090, 0x209c}, {0x20a0, 0x20c1}, {0x20d0, 0x20f0}, {0x2100, 0x218b}, 
            {0x2190, 0x2429}, {0x2440, 0x244a}, {0x2460, 0x2b73}, {0x2b76, 0x2cf3}, 
            {0x2cf9, 0x2d25}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d70}, {0x2d7f, 0x2d96}, 
            {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, 
            {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, 
            {0x2de0, 0x2e5d}, {0x2e80, 0x2e99}, {0x2e9b, 0x2ef3}, {0x2f00, 0x2fd5}, 
            {0x2ff0, 0x303f}, {0x3041, 0x3096}, {0x3099, 0x30ff}, {0x3105, 0x312f}, 
            {0x3131, 0x318e}, {0x3190, 0x31e5}, {0x31ef, 0x321e}, {0x3220, 0xa48c}, 
            {0xa490, 0xa4c6}, {0xa4d0, 0xa62b}, {0xa640, 0xa6f7}, {0xa700, 0xa7dc}, 
            {0xa7f1, 0xa82c}, {0xa830, 0xa839}, {0xa840, 0xa877}, {0xa880, 0xa8c5}, 
            {0xa8ce, 0xa8d9}, {0xa8e0, 0xa953}, {0xa95f, 0xa97c}, {0xa980, 0xa9cd}, 
            {0xa9cf, 0xa9d9}, {0xa9de, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, 
            {0xaa50, 0xaa59}, {0xaa5c, 0xaac2}, {0xaadb, 0xaaf6}, {0xab01, 0xab06}, 
            {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, 
            {0xab30, 0xab6b}, {0xab70, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, 
            {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xd800, 0xfa6d}, {0xfa70, 0xfad9}, 
            {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb36}, {0xfb38, 0xfb3c}, 
            {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfdcf}, {0xfdf0, 0xfe19}, 
            {0xfe20, 0xfe52}, {0xfe54, 0xfe66}, {0xfe68, 0xfe6b}, {0xfe70, 0xfe74}, 
            {0xfe76, 0xfefc}, {0xff01, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, 
            {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0xffe0, 0xffe6}, {0xffe8, 0xffee}, 
            {0xfff9, 0xfffd}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, 
            {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, 
            {0x10100, 0x10102}, {0x10107, 0x10133}, {0x10137, 0x1018e}, {0x10190, 0x1019c}, 
            {0x101d0, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x102e0, 0x102fb}, 
            {0x10300, 0x10323}, {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, 
            {0x1039f, 0x103c3}, {0x103c8, 0x103d5}, {0x10400, 0x1049d}, {0x104a0, 0x104a9}, 
            {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, 
            {0x1056f, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, 
            {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, 
            {0x105c0, 0x105f3}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, 
            {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, 
            {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083f, 0x10855}, {0x10857, 0x1089e}, 
            {0x108a7, 0x108af}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x108fb, 0x1091b}, 
            {0x1091f, 0x10939}, {0x1093f, 0x10959}, {0x10980, 0x109b7}, {0x109bc, 0x109cf}, 
            {0x109d2, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, 
            {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a48}, {0x10a50, 0x10a58}, 
            {0x10a60, 0x10a9f}, {0x10ac0, 0x10ae6}, {0x10aeb, 0x10af6}, {0x10b00, 0x10b35}, 
            {0x10b39, 0x10b55}, {0x10b58, 0x10b72}, {0x10b78, 0x10b91}, {0x10b99, 0x10b9c}, 
            {0x10ba9, 0x10baf}, {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, 
            {0x10cfa, 0x10d27}, {0x10d30, 0x10d39}, {0x10d40, 0x10d65}, {0x10d69, 0x10d85}, 
            {0x10d8e, 0x10d8f}, {0x10e60, 0x10e7e}, {0x10e80, 0x10ea9}, {0x10eab, 0x10ead}, 
            {0x10eb0, 0x10eb1}, {0x10ec2, 0x10ec7}, {0x10ed0, 0x10ed8}, {0x10efa, 0x10f27}, 
            {0x10f30, 0x10f59}, {0x10f70, 0x10f89}, {0x10fb0, 0x10fcb}, {0x10fe0, 0x10ff6}, 
            {0x11000, 0x1104d}, {0x11052, 0x11075}, {0x1107f, 0x110c2}, {0x110d0, 0x110e8}, 
            {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x11147}, {0x11150, 0x11176}, 
            {0x11180, 0x111df}, {0x111e1, 0x111f4}, {0x11200, 0x11211}, {0x11213, 0x11241}, 
            {0x11280, 0x11286}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a9}, 
            {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303}, {0x11305, 0x1130c}, 
            {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, 
            {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d}, 
            {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11380, 0x11389}, 
            {0x11390, 0x113b5}, {0x113b7, 0x113c0}, {0x113c7, 0x113ca}, {0x113cc, 0x113d5}, 
            {0x113d7, 0x113d8}, {0x113e1, 0x113e2}, {0x11400, 0x1145b}, {0x1145d, 0x11461}, 
            {0x11480, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115dd}, 
            {0x11600, 0x11644}, {0x11650, 0x11659}, {0x11660, 0x1166c}, {0x11680, 0x116b9}, 
            {0x116c0, 0x116c9}, {0x116d0, 0x116e3}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, 
            {0x11730, 0x11746}, {0x11800, 0x1183b}, {0x118a0, 0x118f2}, {0x118ff, 0x11906}, 
            {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, {0x11937, 0x11938}, 
            {0x1193b, 0x11946}, {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, 
            {0x119da, 0x119e4}, {0x11a00, 0x11a47}, {0x11a50, 0x11aa2}, {0x11ab0, 0x11af8}, 
            {0x11b00, 0x11b09}, {0x11b60, 0x11b67}, {0x11bc0, 0x11be1}, {0x11bf0, 0x11bf9}, 
            {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c45}, {0x11c50, 0x11c6c}, 
            {0x11c70, 0x11c8f}, {0x11c92, 0x11ca7}, {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, 
            {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47}, 
            {0x11d50, 0x11d59}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, 
            {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11db0, 0x11ddb}, 
            {0x11de0, 0x11de9}, {0x11ee0, 0x11ef8}, {0x11f00, 0x11f10}, {0x11f12, 0x11f3a}, 
            {0x11f3e, 0x11f5a}, {0x11fc0, 0x11ff1}, {0x11fff, 0x12399}, {0x12400, 0x1246e}, 
            {0x12470, 0x12474}, {0x12480, 0x12543}, {0x12f90, 0x12ff2}, {0x13000, 0x13455}, 
            {0x13460, 0x143fa}, {0x14400, 0x14646}, {0x16100, 0x16139}, {0x16800, 0x16a38}, 
            {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a6e, 0x16abe}, {0x16ac0, 0x16ac9}, 
            {0x16ad0, 0x16aed}, {0x16af0, 0x16af5}, {0x16b00, 0x16b45}, {0x16b50, 0x16b59}, 
            {0x16b5b, 0x16b61}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16d40, 0x16d79}, 
            {0x16d80, 0x16d9d}, {0x16da0, 0x16da9}, {0x16e40, 0x16e9a}, {0x16ea0, 0x16eb8}, 
            {0x16ebb, 0x16ed3}, {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, 
            {0x16fe0, 0x16fe4}, {0x16ff0, 0x16ff6}, {0x17000, 0x18cd5}, {0x18cff, 0x18d1e}, 
            {0x18d80, 0x18df2}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, 
            {0x1b000, 0x1b122}, {0x1b150, 0x1b152}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, 
            {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, 
            {0x1bc9c, 0x1bca3}, {0x1cc00, 0x1ccfc}, {0x1cd00, 0x1ceb3}, {0x1ceba, 0x1ced0}, 
            {0x1cee0, 0x1cef0}, {0x1cf00, 0x1cf2d}, {0x1cf30, 0x1cf46}, {0x1cf50, 0x1cfc3}, 
            {0x1d000, 0x1d0f5}, {0x1d100, 0x1d126}, {0x1d129, 0x1d1ea}, {0x1d200, 0x1d245}, 
            {0x1d2c0, 0x1d2d3}, {0x1d2e0, 0x1d2f3}, {0x1d300, 0x1d356}, {0x1d360, 0x1d378}, 
            {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, 
            {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, 
            {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, 
            {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, 
            {0x1d6a8, 0x1d7cb}, {0x1d7ce, 0x1da8b}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, 
            {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018}, 
            {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e030, 0x1e06d}, 
            {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d}, {0x1e140, 0x1e149}, {0x1e14e, 0x1e14f}, 
            {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e4d0, 0x1e4f9}, {0x1e5d0, 0x1e5fa}, 
            {0x1e6c0, 0x1e6de}, {0x1e6e0, 0x1e6f5}, {0x1e6fe, 0x1e6ff}, {0x1e7e0, 0x1e7e6}, 
            {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, 
            {0x1e8c7, 0x1e8d6}, {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1e95e, 0x1e95f}, 
            {0x1ec71, 0x1ecb4}, {0x1ed01, 0x1ed3d}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, 
            {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee4d, 0x1ee4f}, 
            {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, 
            {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, 
            {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1eef0, 0x1eef1}, 
            {0x1f000, 0x1f02b}, {0x1f030, 0x1f093}, {0x1f0a0, 0x1f0ae}, {0x1f0b1, 0x1f0bf}, 
            {0x1f0c1, 0x1f0cf}, {0x1f0d1, 0x1f0f5}, {0x1f100, 0x1f1ad}, {0x1f1e6, 0x1f202}, 
            {0x1f210, 0x1f23b}, {0x1f240, 0x1f248}, {0x1f250, 0x1f251}, {0x1f260, 0x1f265}, 
            {0x1f300, 0x1f6d8}, {0x1f6dc, 0x1f6ec}, {0x1f6f0, 0x1f6fc}, {0x1f700, 0x1f7d9}, 
            {0x1f7e0, 0x1f7eb}, {0x1f800, 0x1f80b}, {0x1f810, 0x1f847}, {0x1f850, 0x1f859}, 
            {0x1f860, 0x1f887}, {0x1f890, 0x1f8ad}, {0x1f8b0, 0x1f8bb}, {0x1f8c0, 0x1f8c1}, 
            {0x1f8d0, 0x1f8d8}, {0x1f900, 0x1fa57}, {0x1fa60, 0x1fa6d}, {0x1fa70, 0x1fa7c}, 
            {0x1fa80, 0x1fa8a}, {0x1fa8e, 0x1fac6}, {0x1facd, 0x1fadd}, {0x1fadf, 0x1faea}, 
            {0x1faef, 0x1faf8}, {0x1fb00, 0x1fb92}, {0x1fb94, 0x1fbfa}, {0x20000, 0x2a6df}, 
            {0x2a700, 0x2b81d}, {0x2b820, 0x2cead}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, 
            {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x33479}, {0xe0020, 0xe007f}, 
            {0xe0100, 0xe01ef}, {0xf0000, 0xffffd}, {0x100000, 0x10fffd}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass3()
{
    // Name = Other, number of codePoints: 954437
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x7f}),
        std::initializer_list<CharacterRange>({{0x00, 0x1f}}),
        std::initializer_list<char32_t>({0x00ad, 0x038b, 0x038d, 0x03a2, 0x0530, 0x0590, 0x061c, 0x06dd, 
            0x083f, 0x085f, 0x08e2, 0x0984, 0x09a9, 0x09b1, 0x09de, 0x0a00, 
            0x0a04, 0x0a29, 0x0a31, 0x0a34, 0x0a37, 0x0a3d, 0x0a5d, 0x0a84, 
            0x0a8e, 0x0a92, 0x0aa9, 0x0ab1, 0x0ab4, 0x0ac6, 0x0aca, 0x0b00, 
            0x0b04, 0x0b29, 0x0b31, 0x0b34, 0x0b5e, 0x0b84, 0x0b91, 0x0b9b, 
            0x0b9d, 0x0bc9, 0x0c0d, 0x0c11, 0x0c29, 0x0c45, 0x0c49, 0x0c57, 
            0x0c5b, 0x0c8d, 0x0c91, 0x0ca9, 0x0cb4, 0x0cc5, 0x0cc9, 0x0cdf, 
            0x0cf0, 0x0d0d, 0x0d11, 0x0d45, 0x0d49, 0x0d80, 0x0d84, 0x0db2, 
            0x0dbc, 0x0dd5, 0x0dd7, 0x0e83, 0x0e85, 0x0e8b, 0x0ea4, 0x0ea6, 
            0x0ec5, 0x0ec7, 0x0ecf, 0x0f48, 0x0f98, 0x0fbd, 0x0fcd, 0x10c6, 
            0x1249, 0x1257, 0x1259, 0x1289, 0x12b1, 0x12bf, 0x12c1, 0x12d7, 
            0x1311, 0x176d, 0x1771, 0x180e, 0x191f, 0x1a5f, 0x1b4d, 0x1f58, 
            0x1f5a, 0x1f5c, 0x1f5e, 0x1fb5, 0x1fc5, 0x1fdc, 0x1ff5, 0x1fff, 
            0x208f, 0x2d26, 0x2da7, 0x2daf, 0x2db7, 0x2dbf, 0x2dc7, 0x2dcf, 
            0x2dd7, 0x2ddf, 0x2e9a, 0x3040, 0x3130, 0x318f, 0x321f, 0xa9ce, 
            0xa9ff, 0xab27, 0xab2f, 0xfb37, 0xfb3d, 0xfb3f, 0xfb42, 0xfb45, 
            0xfe53, 0xfe67, 0xfe75, 0xffe7, 0x1000c, 0x10027, 0x1003b, 0x1003e, 
            0x1018f, 0x1039e, 0x1057b, 0x1058b, 0x10593, 0x10596, 0x105a2, 0x105b2, 
            0x105ba, 0x10786, 0x107b1, 0x10809, 0x10836, 0x10856, 0x108f3, 0x10a04, 
            0x10a14, 0x10a18, 0x10e7f, 0x10eaa, 0x110bd, 0x11135, 0x111e0, 0x11212, 
            0x11287, 0x11289, 0x1128e, 0x1129e, 0x11304, 0x11329, 0x11331, 0x11334, 
            0x1133a, 0x1138a, 0x1138f, 0x113b6, 0x113c1, 0x113c6, 0x113cb, 0x113d6, 
            0x1145c, 0x11914, 0x11917, 0x11936, 0x11c09, 0x11c37, 0x11ca8, 0x11d07, 
            0x11d0a, 0x11d3b, 0x11d3e, 0x11d66, 0x11d69, 0x11d8f, 0x11d92, 0x11f11, 
            0x1246f, 0x16a5f, 0x16abf, 0x16b5a, 0x16b62, 0x1aff4, 0x1affc, 0x1afff, 
            0x1d455, 0x1d49d, 0x1d4ad, 0x1d4ba, 0x1d4bc, 0x1d4c4, 0x1d506, 0x1d515, 
            0x1d51d, 0x1d53a, 0x1d53f, 0x1d545, 0x1d551, 0x1daa0, 0x1e007, 0x1e022, 
            0x1e025, 0x1e6df, 0x1e7e7, 0x1e7ec, 0x1e7ef, 0x1e7ff, 0x1ee04, 0x1ee20, 
            0x1ee23, 0x1ee28, 0x1ee33, 0x1ee38, 0x1ee3a, 0x1ee48, 0x1ee4a, 0x1ee4c, 
            0x1ee50, 0x1ee53, 0x1ee58, 0x1ee5a, 0x1ee5c, 0x1ee5e, 0x1ee60, 0x1ee63, 
            0x1ee6b, 0x1ee73, 0x1ee78, 0x1ee7d, 0x1ee7f, 0x1ee8a, 0x1eea4, 0x1eeaa, 
            0x1f0c0, 0x1f0d0, 0x1fac7, 0x1fade, 0x1fb93}),
        std::initializer_list<CharacterRange>({{0x0080, 0x009f}, {0x0378, 0x0379}, {0x0380, 0x0383}, {0x0557, 0x0558}, 
            {0x058b, 0x058c}, {0x05c8, 0x05cf}, {0x05eb, 0x05ee}, {0x05f5, 0x0605}, 
            {0x070e, 0x070f}, {0x074b, 0x074c}, {0x07b2, 0x07bf}, {0x07fb, 0x07fc}, 
            {0x082e, 0x082f}, {0x085c, 0x085d}, {0x086b, 0x086f}, {0x0890, 0x0896}, 
            {0x098d, 0x098e}, {0x0991, 0x0992}, {0x09b3, 0x09b5}, {0x09ba, 0x09bb}, 
            {0x09c5, 0x09c6}, {0x09c9, 0x09ca}, {0x09cf, 0x09d6}, {0x09d8, 0x09db}, 
            {0x09e4, 0x09e5}, {0x0a0b, 0x0a0e}, {0x0a11, 0x0a12}, {0x0a3a, 0x0a3b}, 
            {0x0a43, 0x0a46}, {0x0a49, 0x0a4a}, {0x0a4e, 0x0a50}, {0x0a52, 0x0a58}, 
            {0x0a5f, 0x0a65}, {0x0a77, 0x0a80}, {0x0aba, 0x0abb}, {0x0ace, 0x0acf}, 
            {0x0ad1, 0x0adf}, {0x0ae4, 0x0ae5}, {0x0af2, 0x0af8}, {0x0b0d, 0x0b0e}, 
            {0x0b11, 0x0b12}, {0x0b3a, 0x0b3b}, {0x0b45, 0x0b46}, {0x0b49, 0x0b4a}, 
            {0x0b4e, 0x0b52}, {0x0b58, 0x0b5b}, {0x0b64, 0x0b65}, {0x0b78, 0x0b81}, 
            {0x0b8b, 0x0b8d}, {0x0b96, 0x0b98}, {0x0ba0, 0x0ba2}, {0x0ba5, 0x0ba7}, 
            {0x0bab, 0x0bad}, {0x0bba, 0x0bbd}, {0x0bc3, 0x0bc5}, {0x0bce, 0x0bcf}, 
            {0x0bd1, 0x0bd6}, {0x0bd8, 0x0be5}, {0x0bfb, 0x0bff}, {0x0c3a, 0x0c3b}, 
            {0x0c4e, 0x0c54}, {0x0c5e, 0x0c5f}, {0x0c64, 0x0c65}, {0x0c70, 0x0c76}, 
            {0x0cba, 0x0cbb}, {0x0cce, 0x0cd4}, {0x0cd7, 0x0cdb}, {0x0ce4, 0x0ce5}, 
            {0x0cf4, 0x0cff}, {0x0d50, 0x0d53}, {0x0d64, 0x0d65}, {0x0d97, 0x0d99}, 
            {0x0dbe, 0x0dbf}, {0x0dc7, 0x0dc9}, {0x0dcb, 0x0dce}, {0x0de0, 0x0de5}, 
            {0x0df0, 0x0df1}, {0x0df5, 0x0e00}, {0x0e3b, 0x0e3e}, {0x0e5c, 0x0e80}, 
            {0x0ebe, 0x0ebf}, {0x0eda, 0x0edb}, {0x0ee0, 0x0eff}, {0x0f6d, 0x0f70}, 
            {0x0fdb, 0x0fff}, {0x10c8, 0x10cc}, {0x10ce, 0x10cf}, {0x124e, 0x124f}, 
            {0x125e, 0x125f}, {0x128e, 0x128f}, {0x12b6, 0x12b7}, {0x12c6, 0x12c7}, 
            {0x1316, 0x1317}, {0x135b, 0x135c}, {0x137d, 0x137f}, {0x139a, 0x139f}, 
            {0x13f6, 0x13f7}, {0x13fe, 0x13ff}, {0x169d, 0x169f}, {0x16f9, 0x16ff}, 
            {0x1716, 0x171e}, {0x1737, 0x173f}, {0x1754, 0x175f}, {0x1774, 0x177f}, 
            {0x17de, 0x17df}, {0x17ea, 0x17ef}, {0x17fa, 0x17ff}, {0x181a, 0x181f}, 
            {0x1879, 0x187f}, {0x18ab, 0x18af}, {0x18f6, 0x18ff}, {0x192c, 0x192f}, 
            {0x193c, 0x193f}, {0x1941, 0x1943}, {0x196e, 0x196f}, {0x1975, 0x197f}, 
            {0x19ac, 0x19af}, {0x19ca, 0x19cf}, {0x19db, 0x19dd}, {0x1a1c, 0x1a1d}, 
            {0x1a7d, 0x1a7e}, {0x1a8a, 0x1a8f}, {0x1a9a, 0x1a9f}, {0x1aae, 0x1aaf}, 
            {0x1ade, 0x1adf}, {0x1aec, 0x1aff}, {0x1bf4, 0x1bfb}, {0x1c38, 0x1c3a}, 
            {0x1c4a, 0x1c4c}, {0x1c8b, 0x1c8f}, {0x1cbb, 0x1cbc}, {0x1cc8, 0x1ccf}, 
            {0x1cfb, 0x1cff}, {0x1f16, 0x1f17}, {0x1f1e, 0x1f1f}, {0x1f46, 0x1f47}, 
            {0x1f4e, 0x1f4f}, {0x1f7e, 0x1f7f}, {0x1fd4, 0x1fd5}, {0x1ff0, 0x1ff1}, 
            {0x200b, 0x200f}, {0x202a, 0x202e}, {0x2060, 0x206f}, {0x2072, 0x2073}, 
            {0x209d, 0x209f}, {0x20c2, 0x20cf}, {0x20f1, 0x20ff}, {0x218c, 0x218f}, 
            {0x242a, 0x243f}, {0x244b, 0x245f}, {0x2b74, 0x2b75}, {0x2cf4, 0x2cf8}, 
            {0x2d28, 0x2d2c}, {0x2d2e, 0x2d2f}, {0x2d68, 0x2d6e}, {0x2d71, 0x2d7e}, 
            {0x2d97, 0x2d9f}, {0x2e5e, 0x2e7f}, {0x2ef4, 0x2eff}, {0x2fd6, 0x2fef}, 
            {0x3097, 0x3098}, {0x3100, 0x3104}, {0x31e6, 0x31ee}, {0xa48d, 0xa48f}, 
            {0xa4c7, 0xa4cf}, {0xa62c, 0xa63f}, {0xa6f8, 0xa6ff}, {0xa7dd, 0xa7f0}, 
            {0xa82d, 0xa82f}, {0xa83a, 0xa83f}, {0xa878, 0xa87f}, {0xa8c6, 0xa8cd}, 
            {0xa8da, 0xa8df}, {0xa954, 0xa95e}, {0xa97d, 0xa97f}, {0xa9da, 0xa9dd}, 
            {0xaa37, 0xaa3f}, {0xaa4e, 0xaa4f}, {0xaa5a, 0xaa5b}, {0xaac3, 0xaada}, 
            {0xaaf7, 0xab00}, {0xab07, 0xab08}, {0xab0f, 0xab10}, {0xab17, 0xab1f}, 
            {0xab6c, 0xab6f}, {0xabee, 0xabef}, {0xabfa, 0xabff}, {0xd7a4, 0xd7af}, 
            {0xd7c7, 0xd7ca}, {0xd7fc, 0xf8ff}, {0xfa6e, 0xfa6f}, {0xfada, 0xfaff}, 
            {0xfb07, 0xfb12}, {0xfb18, 0xfb1c}, {0xfdd0, 0xfdef}, {0xfe1a, 0xfe1f}, 
            {0xfe6c, 0xfe6f}, {0xfefd, 0xff00}, {0xffbf, 0xffc1}, {0xffc8, 0xffc9}, 
            {0xffd0, 0xffd1}, {0xffd8, 0xffd9}, {0xffdd, 0xffdf}, {0xffef, 0xfffb}, 
            {0xfffe, 0xffff}, {0x1004e, 0x1004f}, {0x1005e, 0x1007f}, {0x100fb, 0x100ff}, 
            {0x10103, 0x10106}, {0x10134, 0x10136}, {0x1019d, 0x1019f}, {0x101a1, 0x101cf}, 
            {0x101fe, 0x1027f}, {0x1029d, 0x1029f}, {0x102d1, 0x102df}, {0x102fc, 0x102ff}, 
            {0x10324, 0x1032c}, {0x1034b, 0x1034f}, {0x1037b, 0x1037f}, {0x103c4, 0x103c7}, 
            {0x103d6, 0x103ff}, {0x1049e, 0x1049f}, {0x104aa, 0x104af}, {0x104d4, 0x104d7}, 
            {0x104fc, 0x104ff}, {0x10528, 0x1052f}, {0x10564, 0x1056e}, {0x105bd, 0x105bf}, 
            {0x105f4, 0x105ff}, {0x10737, 0x1073f}, {0x10756, 0x1075f}, {0x10768, 0x1077f}, 
            {0x107bb, 0x107ff}, {0x10806, 0x10807}, {0x10839, 0x1083b}, {0x1083d, 0x1083e}, 
            {0x1089f, 0x108a6}, {0x108b0, 0x108df}, {0x108f6, 0x108fa}, {0x1091c, 0x1091e}, 
            {0x1093a, 0x1093e}, {0x1095a, 0x1097f}, {0x109b8, 0x109bb}, {0x109d0, 0x109d1}, 
            {0x10a07, 0x10a0b}, {0x10a36, 0x10a37}, {0x10a3b, 0x10a3e}, {0x10a49, 0x10a4f}, 
            {0x10a59, 0x10a5f}, {0x10aa0, 0x10abf}, {0x10ae7, 0x10aea}, {0x10af7, 0x10aff}, 
            {0x10b36, 0x10b38}, {0x10b56, 0x10b57}, {0x10b73, 0x10b77}, {0x10b92, 0x10b98}, 
            {0x10b9d, 0x10ba8}, {0x10bb0, 0x10bff}, {0x10c49, 0x10c7f}, {0x10cb3, 0x10cbf}, 
            {0x10cf3, 0x10cf9}, {0x10d28, 0x10d2f}, {0x10d3a, 0x10d3f}, {0x10d66, 0x10d68}, 
            {0x10d86, 0x10d8d}, {0x10d90, 0x10e5f}, {0x10eae, 0x10eaf}, {0x10eb2, 0x10ec1}, 
            {0x10ec8, 0x10ecf}, {0x10ed9, 0x10ef9}, {0x10f28, 0x10f2f}, {0x10f5a, 0x10f6f}, 
            {0x10f8a, 0x10faf}, {0x10fcc, 0x10fdf}, {0x10ff7, 0x10fff}, {0x1104e, 0x11051}, 
            {0x11076, 0x1107e}, {0x110c3, 0x110cf}, {0x110e9, 0x110ef}, {0x110fa, 0x110ff}, 
            {0x11148, 0x1114f}, {0x11177, 0x1117f}, {0x111f5, 0x111ff}, {0x11242, 0x1127f}, 
            {0x112aa, 0x112af}, {0x112eb, 0x112ef}, {0x112fa, 0x112ff}, {0x1130d, 0x1130e}, 
            {0x11311, 0x11312}, {0x11345, 0x11346}, {0x11349, 0x1134a}, {0x1134e, 0x1134f}, 
            {0x11351, 0x11356}, {0x11358, 0x1135c}, {0x11364, 0x11365}, {0x1136d, 0x1136f}, 
            {0x11375, 0x1137f}, {0x1138c, 0x1138d}, {0x113c3, 0x113c4}, {0x113d9, 0x113e0}, 
            {0x113e3, 0x113ff}, {0x11462, 0x1147f}, {0x114c8, 0x114cf}, {0x114da, 0x1157f}, 
            {0x115b6, 0x115b7}, {0x115de, 0x115ff}, {0x11645, 0x1164f}, {0x1165a, 0x1165f}, 
            {0x1166d, 0x1167f}, {0x116ba, 0x116bf}, {0x116ca, 0x116cf}, {0x116e4, 0x116ff}, 
            {0x1171b, 0x1171c}, {0x1172c, 0x1172f}, {0x11747, 0x117ff}, {0x1183c, 0x1189f}, 
            {0x118f3, 0x118fe}, {0x11907, 0x11908}, {0x1190a, 0x1190b}, {0x11939, 0x1193a}, 
            {0x11947, 0x1194f}, {0x1195a, 0x1199f}, {0x119a8, 0x119a9}, {0x119d8, 0x119d9}, 
            {0x119e5, 0x119ff}, {0x11a48, 0x11a4f}, {0x11aa3, 0x11aaf}, {0x11af9, 0x11aff}, 
            {0x11b0a, 0x11b5f}, {0x11b68, 0x11bbf}, {0x11be2, 0x11bef}, {0x11bfa, 0x11bff}, 
            {0x11c46, 0x11c4f}, {0x11c6d, 0x11c6f}, {0x11c90, 0x11c91}, {0x11cb7, 0x11cff}, 
            {0x11d37, 0x11d39}, {0x11d48, 0x11d4f}, {0x11d5a, 0x11d5f}, {0x11d99, 0x11d9f}, 
            {0x11daa, 0x11daf}, {0x11ddc, 0x11ddf}, {0x11dea, 0x11edf}, {0x11ef9, 0x11eff}, 
            {0x11f3b, 0x11f3d}, {0x11f5b, 0x11faf}, {0x11fb1, 0x11fbf}, {0x11ff2, 0x11ffe}, 
            {0x1239a, 0x123ff}, {0x12475, 0x1247f}, {0x12544, 0x12f8f}, {0x12ff3, 0x12fff}, 
            {0x13430, 0x1343f}, {0x13456, 0x1345f}, {0x143fb, 0x143ff}, {0x14647, 0x160ff}, 
            {0x1613a, 0x167ff}, {0x16a39, 0x16a3f}, {0x16a6a, 0x16a6d}, {0x16aca, 0x16acf}, 
            {0x16aee, 0x16aef}, {0x16af6, 0x16aff}, {0x16b46, 0x16b4f}, {0x16b78, 0x16b7c}, 
            {0x16b90, 0x16d3f}, {0x16d7a, 0x16d7f}, {0x16d9e, 0x16d9f}, {0x16daa, 0x16e3f}, 
            {0x16e9b, 0x16e9f}, {0x16eb9, 0x16eba}, {0x16ed4, 0x16eff}, {0x16f4b, 0x16f4e}, 
            {0x16f88, 0x16f8e}, {0x16fa0, 0x16fdf}, {0x16fe5, 0x16fef}, {0x16ff7, 0x16fff}, 
            {0x18cd6, 0x18cfe}, {0x18d1f, 0x18d7f}, {0x18df3, 0x1afef}, {0x1b123, 0x1b131}, 
            {0x1b133, 0x1b14f}, {0x1b153, 0x1b154}, {0x1b156, 0x1b163}, {0x1b168, 0x1b16f}, 
            {0x1b2fc, 0x1bbff}, {0x1bc6b, 0x1bc6f}, {0x1bc7d, 0x1bc7f}, {0x1bc89, 0x1bc8f}, 
            {0x1bc9a, 0x1bc9b}, {0x1bca0, 0x1cbff}, {0x1ccfd, 0x1ccff}, {0x1ceb4, 0x1ceb9}, 
            {0x1ced1, 0x1cedf}, {0x1cef1, 0x1ceff}, {0x1cf2e, 0x1cf2f}, {0x1cf47, 0x1cf4f}, 
            {0x1cfc4, 0x1cfff}, {0x1d0f6, 0x1d0ff}, {0x1d127, 0x1d128}, {0x1d173, 0x1d17a}, 
            {0x1d1eb, 0x1d1ff}, {0x1d246, 0x1d2bf}, {0x1d2d4, 0x1d2df}, {0x1d2f4, 0x1d2ff}, 
            {0x1d357, 0x1d35f}, {0x1d379, 0x1d3ff}, {0x1d4a0, 0x1d4a1}, {0x1d4a3, 0x1d4a4}, 
            {0x1d4a7, 0x1d4a8}, {0x1d50b, 0x1d50c}, {0x1d547, 0x1d549}, {0x1d6a6, 0x1d6a7}, 
            {0x1d7cc, 0x1d7cd}, {0x1da8c, 0x1da9a}, {0x1dab0, 0x1deff}, {0x1df1f, 0x1df24}, 
            {0x1df2b, 0x1dfff}, {0x1e019, 0x1e01a}, {0x1e02b, 0x1e02f}, {0x1e06e, 0x1e08e}, 
            {0x1e090, 0x1e0ff}, {0x1e12d, 0x1e12f}, {0x1e13e, 0x1e13f}, {0x1e14a, 0x1e14d}, 
            {0x1e150, 0x1e28f}, {0x1e2af, 0x1e2bf}, {0x1e2fa, 0x1e2fe}, {0x1e300, 0x1e4cf}, 
            {0x1e4fa, 0x1e5cf}, {0x1e5fb, 0x1e5fe}, {0x1e600, 0x1e6bf}, {0x1e6f6, 0x1e6fd}, 
            {0x1e700, 0x1e7df}, {0x1e8c5, 0x1e8c6}, {0x1e8d7, 0x1e8ff}, {0x1e94c, 0x1e94f}, 
            {0x1e95a, 0x1e95d}, {0x1e960, 0x1ec70}, {0x1ecb5, 0x1ed00}, {0x1ed3e, 0x1edff}, 
            {0x1ee25, 0x1ee26}, {0x1ee3c, 0x1ee41}, {0x1ee43, 0x1ee46}, {0x1ee55, 0x1ee56}, 
            {0x1ee65, 0x1ee66}, {0x1ee9c, 0x1eea0}, {0x1eebc, 0x1eeef}, {0x1eef2, 0x1efff}, 
            {0x1f02c, 0x1f02f}, {0x1f094, 0x1f09f}, {0x1f0af, 0x1f0b0}, {0x1f0f6, 0x1f0ff}, 
            {0x1f1ae, 0x1f1e5}, {0x1f203, 0x1f20f}, {0x1f23c, 0x1f23f}, {0x1f249, 0x1f24f}, 
            {0x1f252, 0x1f25f}, {0x1f266, 0x1f2ff}, {0x1f6d9, 0x1f6db}, {0x1f6ed, 0x1f6ef}, 
            {0x1f6fd, 0x1f6ff}, {0x1f7da, 0x1f7df}, {0x1f7ec, 0x1f7ef}, {0x1f7f1, 0x1f7ff}, 
            {0x1f80c, 0x1f80f}, {0x1f848, 0x1f84f}, {0x1f85a, 0x1f85f}, {0x1f888, 0x1f88f}, 
            {0x1f8ae, 0x1f8af}, {0x1f8bc, 0x1f8bf}, {0x1f8c2, 0x1f8cf}, {0x1f8d9, 0x1f8ff}, 
            {0x1fa58, 0x1fa5f}, {0x1fa6e, 0x1fa6f}, {0x1fa7d, 0x1fa7f}, {0x1fa8b, 0x1fa8d}, 
            {0x1fac9, 0x1facc}, {0x1faeb, 0x1faee}, {0x1faf9, 0x1faff}, {0x1fbfb, 0x1ffff}, 
            {0x2a6e0, 0x2a6ff}, {0x2b81e, 0x2b81f}, {0x2ceae, 0x2ceaf}, {0x2ebe1, 0x2ebef}, 
            {0x2ee5e, 0x2f7ff}, {0x2fa1e, 0x2ffff}, {0x3134b, 0x3134f}, {0x3347a, 0xe00ff}, 
            {0xe01f0, 0x10ffff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass4()
{
    // Name = Unassigned, number of codePoints: 814686
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x038b, 0x038d, 0x03a2, 0x0530, 0x0590, 0x070e, 0x083f, 0x085f, 
            0x0984, 0x09a9, 0x09b1, 0x09de, 0x0a00, 0x0a04, 0x0a29, 0x0a31, 
            0x0a34, 0x0a37, 0x0a3d, 0x0a5d, 0x0a84, 0x0a8e, 0x0a92, 0x0aa9, 
            0x0ab1, 0x0ab4, 0x0ac6, 0x0aca, 0x0b00, 0x0b04, 0x0b29, 0x0b31, 
            0x0b34, 0x0b5e, 0x0b84, 0x0b91, 0x0b9b, 0x0b9d, 0x0bc9, 0x0c0d, 
            0x0c11, 0x0c29, 0x0c45, 0x0c49, 0x0c57, 0x0c5b, 0x0c8d, 0x0c91, 
            0x0ca9, 0x0cb4, 0x0cc5, 0x0cc9, 0x0cdf, 0x0cf0, 0x0d0d, 0x0d11, 
            0x0d45, 0x0d49, 0x0d80, 0x0d84, 0x0db2, 0x0dbc, 0x0dd5, 0x0dd7, 
            0x0e83, 0x0e85, 0x0e8b, 0x0ea4, 0x0ea6, 0x0ec5, 0x0ec7, 0x0ecf, 
            0x0f48, 0x0f98, 0x0fbd, 0x0fcd, 0x10c6, 0x1249, 0x1257, 0x1259, 
            0x1289, 0x12b1, 0x12bf, 0x12c1, 0x12d7, 0x1311, 0x176d, 0x1771, 
            0x191f, 0x1a5f, 0x1b4d, 0x1f58, 0x1f5a, 0x1f5c, 0x1f5e, 0x1fb5, 
            0x1fc5, 0x1fdc, 0x1ff5, 0x1fff, 0x2065, 0x208f, 0x2d26, 0x2da7, 
            0x2daf, 0x2db7, 0x2dbf, 0x2dc7, 0x2dcf, 0x2dd7, 0x2ddf, 0x2e9a, 
            0x3040, 0x3130, 0x318f, 0x321f, 0xa9ce, 0xa9ff, 0xab27, 0xab2f, 
            0xfb37, 0xfb3d, 0xfb3f, 0xfb42, 0xfb45, 0xfe53, 0xfe67, 0xfe75, 
            0xff00, 0xffe7, 0x1000c, 0x10027, 0x1003b, 0x1003e, 0x1018f, 0x1039e, 
            0x1057b, 0x1058b, 0x10593, 0x10596, 0x105a2, 0x105b2, 0x105ba, 0x10786, 
            0x107b1, 0x10809, 0x10836, 0x10856, 0x108f3, 0x10a04, 0x10a14, 0x10a18, 
            0x10e7f, 0x10eaa, 0x11135, 0x111e0, 0x11212, 0x11287, 0x11289, 0x1128e, 
            0x1129e, 0x11304, 0x11329, 0x11331, 0x11334, 0x1133a, 0x1138a, 0x1138f, 
            0x113b6, 0x113c1, 0x113c6, 0x113cb, 0x113d6, 0x1145c, 0x11914, 0x11917, 
            0x11936, 0x11c09, 0x11c37, 0x11ca8, 0x11d07, 0x11d0a, 0x11d3b, 0x11d3e, 
            0x11d66, 0x11d69, 0x11d8f, 0x11d92, 0x11f11, 0x1246f, 0x16a5f, 0x16abf, 
            0x16b5a, 0x16b62, 0x1aff4, 0x1affc, 0x1afff, 0x1d455, 0x1d49d, 0x1d4ad, 
            0x1d4ba, 0x1d4bc, 0x1d4c4, 0x1d506, 0x1d515, 0x1d51d, 0x1d53a, 0x1d53f, 
            0x1d545, 0x1d551, 0x1daa0, 0x1e007, 0x1e022, 0x1e025, 0x1e6df, 0x1e7e7, 
            0x1e7ec, 0x1e7ef, 0x1e7ff, 0x1ee04, 0x1ee20, 0x1ee23, 0x1ee28, 0x1ee33, 
            0x1ee38, 0x1ee3a, 0x1ee48, 0x1ee4a, 0x1ee4c, 0x1ee50, 0x1ee53, 0x1ee58, 
            0x1ee5a, 0x1ee5c, 0x1ee5e, 0x1ee60, 0x1ee63, 0x1ee6b, 0x1ee73, 0x1ee78, 
            0x1ee7d, 0x1ee7f, 0x1ee8a, 0x1eea4, 0x1eeaa, 0x1f0c0, 0x1f0d0, 0x1fac7, 
            0x1fade, 0x1fb93}),
        std::initializer_list<CharacterRange>({{0x0378, 0x0379}, {0x0380, 0x0383}, {0x0557, 0x0558}, {0x058b, 0x058c}, 
            {0x05c8, 0x05cf}, {0x05eb, 0x05ee}, {0x05f5, 0x05ff}, {0x074b, 0x074c}, 
            {0x07b2, 0x07bf}, {0x07fb, 0x07fc}, {0x082e, 0x082f}, {0x085c, 0x085d}, 
            {0x086b, 0x086f}, {0x0892, 0x0896}, {0x098d, 0x098e}, {0x0991, 0x0992}, 
            {0x09b3, 0x09b5}, {0x09ba, 0x09bb}, {0x09c5, 0x09c6}, {0x09c9, 0x09ca}, 
            {0x09cf, 0x09d6}, {0x09d8, 0x09db}, {0x09e4, 0x09e5}, {0x0a0b, 0x0a0e}, 
            {0x0a11, 0x0a12}, {0x0a3a, 0x0a3b}, {0x0a43, 0x0a46}, {0x0a49, 0x0a4a}, 
            {0x0a4e, 0x0a50}, {0x0a52, 0x0a58}, {0x0a5f, 0x0a65}, {0x0a77, 0x0a80}, 
            {0x0aba, 0x0abb}, {0x0ace, 0x0acf}, {0x0ad1, 0x0adf}, {0x0ae4, 0x0ae5}, 
            {0x0af2, 0x0af8}, {0x0b0d, 0x0b0e}, {0x0b11, 0x0b12}, {0x0b3a, 0x0b3b}, 
            {0x0b45, 0x0b46}, {0x0b49, 0x0b4a}, {0x0b4e, 0x0b52}, {0x0b58, 0x0b5b}, 
            {0x0b64, 0x0b65}, {0x0b78, 0x0b81}, {0x0b8b, 0x0b8d}, {0x0b96, 0x0b98}, 
            {0x0ba0, 0x0ba2}, {0x0ba5, 0x0ba7}, {0x0bab, 0x0bad}, {0x0bba, 0x0bbd}, 
            {0x0bc3, 0x0bc5}, {0x0bce, 0x0bcf}, {0x0bd1, 0x0bd6}, {0x0bd8, 0x0be5}, 
            {0x0bfb, 0x0bff}, {0x0c3a, 0x0c3b}, {0x0c4e, 0x0c54}, {0x0c5e, 0x0c5f}, 
            {0x0c64, 0x0c65}, {0x0c70, 0x0c76}, {0x0cba, 0x0cbb}, {0x0cce, 0x0cd4}, 
            {0x0cd7, 0x0cdb}, {0x0ce4, 0x0ce5}, {0x0cf4, 0x0cff}, {0x0d50, 0x0d53}, 
            {0x0d64, 0x0d65}, {0x0d97, 0x0d99}, {0x0dbe, 0x0dbf}, {0x0dc7, 0x0dc9}, 
            {0x0dcb, 0x0dce}, {0x0de0, 0x0de5}, {0x0df0, 0x0df1}, {0x0df5, 0x0e00}, 
            {0x0e3b, 0x0e3e}, {0x0e5c, 0x0e80}, {0x0ebe, 0x0ebf}, {0x0eda, 0x0edb}, 
            {0x0ee0, 0x0eff}, {0x0f6d, 0x0f70}, {0x0fdb, 0x0fff}, {0x10c8, 0x10cc}, 
            {0x10ce, 0x10cf}, {0x124e, 0x124f}, {0x125e, 0x125f}, {0x128e, 0x128f}, 
            {0x12b6, 0x12b7}, {0x12c6, 0x12c7}, {0x1316, 0x1317}, {0x135b, 0x135c}, 
            {0x137d, 0x137f}, {0x139a, 0x139f}, {0x13f6, 0x13f7}, {0x13fe, 0x13ff}, 
            {0x169d, 0x169f}, {0x16f9, 0x16ff}, {0x1716, 0x171e}, {0x1737, 0x173f}, 
            {0x1754, 0x175f}, {0x1774, 0x177f}, {0x17de, 0x17df}, {0x17ea, 0x17ef}, 
            {0x17fa, 0x17ff}, {0x181a, 0x181f}, {0x1879, 0x187f}, {0x18ab, 0x18af}, 
            {0x18f6, 0x18ff}, {0x192c, 0x192f}, {0x193c, 0x193f}, {0x1941, 0x1943}, 
            {0x196e, 0x196f}, {0x1975, 0x197f}, {0x19ac, 0x19af}, {0x19ca, 0x19cf}, 
            {0x19db, 0x19dd}, {0x1a1c, 0x1a1d}, {0x1a7d, 0x1a7e}, {0x1a8a, 0x1a8f}, 
            {0x1a9a, 0x1a9f}, {0x1aae, 0x1aaf}, {0x1ade, 0x1adf}, {0x1aec, 0x1aff}, 
            {0x1bf4, 0x1bfb}, {0x1c38, 0x1c3a}, {0x1c4a, 0x1c4c}, {0x1c8b, 0x1c8f}, 
            {0x1cbb, 0x1cbc}, {0x1cc8, 0x1ccf}, {0x1cfb, 0x1cff}, {0x1f16, 0x1f17}, 
            {0x1f1e, 0x1f1f}, {0x1f46, 0x1f47}, {0x1f4e, 0x1f4f}, {0x1f7e, 0x1f7f}, 
            {0x1fd4, 0x1fd5}, {0x1ff0, 0x1ff1}, {0x2072, 0x2073}, {0x209d, 0x209f}, 
            {0x20c2, 0x20cf}, {0x20f1, 0x20ff}, {0x218c, 0x218f}, {0x242a, 0x243f}, 
            {0x244b, 0x245f}, {0x2b74, 0x2b75}, {0x2cf4, 0x2cf8}, {0x2d28, 0x2d2c}, 
            {0x2d2e, 0x2d2f}, {0x2d68, 0x2d6e}, {0x2d71, 0x2d7e}, {0x2d97, 0x2d9f}, 
            {0x2e5e, 0x2e7f}, {0x2ef4, 0x2eff}, {0x2fd6, 0x2fef}, {0x3097, 0x3098}, 
            {0x3100, 0x3104}, {0x31e6, 0x31ee}, {0xa48d, 0xa48f}, {0xa4c7, 0xa4cf}, 
            {0xa62c, 0xa63f}, {0xa6f8, 0xa6ff}, {0xa7dd, 0xa7f0}, {0xa82d, 0xa82f}, 
            {0xa83a, 0xa83f}, {0xa878, 0xa87f}, {0xa8c6, 0xa8cd}, {0xa8da, 0xa8df}, 
            {0xa954, 0xa95e}, {0xa97d, 0xa97f}, {0xa9da, 0xa9dd}, {0xaa37, 0xaa3f}, 
            {0xaa4e, 0xaa4f}, {0xaa5a, 0xaa5b}, {0xaac3, 0xaada}, {0xaaf7, 0xab00}, 
            {0xab07, 0xab08}, {0xab0f, 0xab10}, {0xab17, 0xab1f}, {0xab6c, 0xab6f}, 
            {0xabee, 0xabef}, {0xabfa, 0xabff}, {0xd7a4, 0xd7af}, {0xd7c7, 0xd7ca}, 
            {0xd7fc, 0xd7ff}, {0xfa6e, 0xfa6f}, {0xfada, 0xfaff}, {0xfb07, 0xfb12}, 
            {0xfb18, 0xfb1c}, {0xfdd0, 0xfdef}, {0xfe1a, 0xfe1f}, {0xfe6c, 0xfe6f}, 
            {0xfefd, 0xfefe}, {0xffbf, 0xffc1}, {0xffc8, 0xffc9}, {0xffd0, 0xffd1}, 
            {0xffd8, 0xffd9}, {0xffdd, 0xffdf}, {0xffef, 0xfff8}, {0xfffe, 0xffff}, 
            {0x1004e, 0x1004f}, {0x1005e, 0x1007f}, {0x100fb, 0x100ff}, {0x10103, 0x10106}, 
            {0x10134, 0x10136}, {0x1019d, 0x1019f}, {0x101a1, 0x101cf}, {0x101fe, 0x1027f}, 
            {0x1029d, 0x1029f}, {0x102d1, 0x102df}, {0x102fc, 0x102ff}, {0x10324, 0x1032c}, 
            {0x1034b, 0x1034f}, {0x1037b, 0x1037f}, {0x103c4, 0x103c7}, {0x103d6, 0x103ff}, 
            {0x1049e, 0x1049f}, {0x104aa, 0x104af}, {0x104d4, 0x104d7}, {0x104fc, 0x104ff}, 
            {0x10528, 0x1052f}, {0x10564, 0x1056e}, {0x105bd, 0x105bf}, {0x105f4, 0x105ff}, 
            {0x10737, 0x1073f}, {0x10756, 0x1075f}, {0x10768, 0x1077f}, {0x107bb, 0x107ff}, 
            {0x10806, 0x10807}, {0x10839, 0x1083b}, {0x1083d, 0x1083e}, {0x1089f, 0x108a6}, 
            {0x108b0, 0x108df}, {0x108f6, 0x108fa}, {0x1091c, 0x1091e}, {0x1093a, 0x1093e}, 
            {0x1095a, 0x1097f}, {0x109b8, 0x109bb}, {0x109d0, 0x109d1}, {0x10a07, 0x10a0b}, 
            {0x10a36, 0x10a37}, {0x10a3b, 0x10a3e}, {0x10a49, 0x10a4f}, {0x10a59, 0x10a5f}, 
            {0x10aa0, 0x10abf}, {0x10ae7, 0x10aea}, {0x10af7, 0x10aff}, {0x10b36, 0x10b38}, 
            {0x10b56, 0x10b57}, {0x10b73, 0x10b77}, {0x10b92, 0x10b98}, {0x10b9d, 0x10ba8}, 
            {0x10bb0, 0x10bff}, {0x10c49, 0x10c7f}, {0x10cb3, 0x10cbf}, {0x10cf3, 0x10cf9}, 
            {0x10d28, 0x10d2f}, {0x10d3a, 0x10d3f}, {0x10d66, 0x10d68}, {0x10d86, 0x10d8d}, 
            {0x10d90, 0x10e5f}, {0x10eae, 0x10eaf}, {0x10eb2, 0x10ec1}, {0x10ec8, 0x10ecf}, 
            {0x10ed9, 0x10ef9}, {0x10f28, 0x10f2f}, {0x10f5a, 0x10f6f}, {0x10f8a, 0x10faf}, 
            {0x10fcc, 0x10fdf}, {0x10ff7, 0x10fff}, {0x1104e, 0x11051}, {0x11076, 0x1107e}, 
            {0x110c3, 0x110cc}, {0x110ce, 0x110cf}, {0x110e9, 0x110ef}, {0x110fa, 0x110ff}, 
            {0x11148, 0x1114f}, {0x11177, 0x1117f}, {0x111f5, 0x111ff}, {0x11242, 0x1127f}, 
            {0x112aa, 0x112af}, {0x112eb, 0x112ef}, {0x112fa, 0x112ff}, {0x1130d, 0x1130e}, 
            {0x11311, 0x11312}, {0x11345, 0x11346}, {0x11349, 0x1134a}, {0x1134e, 0x1134f}, 
            {0x11351, 0x11356}, {0x11358, 0x1135c}, {0x11364, 0x11365}, {0x1136d, 0x1136f}, 
            {0x11375, 0x1137f}, {0x1138c, 0x1138d}, {0x113c3, 0x113c4}, {0x113d9, 0x113e0}, 
            {0x113e3, 0x113ff}, {0x11462, 0x1147f}, {0x114c8, 0x114cf}, {0x114da, 0x1157f}, 
            {0x115b6, 0x115b7}, {0x115de, 0x115ff}, {0x11645, 0x1164f}, {0x1165a, 0x1165f}, 
            {0x1166d, 0x1167f}, {0x116ba, 0x116bf}, {0x116ca, 0x116cf}, {0x116e4, 0x116ff}, 
            {0x1171b, 0x1171c}, {0x1172c, 0x1172f}, {0x11747, 0x117ff}, {0x1183c, 0x1189f}, 
            {0x118f3, 0x118fe}, {0x11907, 0x11908}, {0x1190a, 0x1190b}, {0x11939, 0x1193a}, 
            {0x11947, 0x1194f}, {0x1195a, 0x1199f}, {0x119a8, 0x119a9}, {0x119d8, 0x119d9}, 
            {0x119e5, 0x119ff}, {0x11a48, 0x11a4f}, {0x11aa3, 0x11aaf}, {0x11af9, 0x11aff}, 
            {0x11b0a, 0x11b5f}, {0x11b68, 0x11bbf}, {0x11be2, 0x11bef}, {0x11bfa, 0x11bff}, 
            {0x11c46, 0x11c4f}, {0x11c6d, 0x11c6f}, {0x11c90, 0x11c91}, {0x11cb7, 0x11cff}, 
            {0x11d37, 0x11d39}, {0x11d48, 0x11d4f}, {0x11d5a, 0x11d5f}, {0x11d99, 0x11d9f}, 
            {0x11daa, 0x11daf}, {0x11ddc, 0x11ddf}, {0x11dea, 0x11edf}, {0x11ef9, 0x11eff}, 
            {0x11f3b, 0x11f3d}, {0x11f5b, 0x11faf}, {0x11fb1, 0x11fbf}, {0x11ff2, 0x11ffe}, 
            {0x1239a, 0x123ff}, {0x12475, 0x1247f}, {0x12544, 0x12f8f}, {0x12ff3, 0x12fff}, 
            {0x13456, 0x1345f}, {0x143fb, 0x143ff}, {0x14647, 0x160ff}, {0x1613a, 0x167ff}, 
            {0x16a39, 0x16a3f}, {0x16a6a, 0x16a6d}, {0x16aca, 0x16acf}, {0x16aee, 0x16aef}, 
            {0x16af6, 0x16aff}, {0x16b46, 0x16b4f}, {0x16b78, 0x16b7c}, {0x16b90, 0x16d3f}, 
            {0x16d7a, 0x16d7f}, {0x16d9e, 0x16d9f}, {0x16daa, 0x16e3f}, {0x16e9b, 0x16e9f}, 
            {0x16eb9, 0x16eba}, {0x16ed4, 0x16eff}, {0x16f4b, 0x16f4e}, {0x16f88, 0x16f8e}, 
            {0x16fa0, 0x16fdf}, {0x16fe5, 0x16fef}, {0x16ff7, 0x16fff}, {0x18cd6, 0x18cfe}, 
            {0x18d1f, 0x18d7f}, {0x18df3, 0x1afef}, {0x1b123, 0x1b131}, {0x1b133, 0x1b14f}, 
            {0x1b153, 0x1b154}, {0x1b156, 0x1b163}, {0x1b168, 0x1b16f}, {0x1b2fc, 0x1bbff}, 
            {0x1bc6b, 0x1bc6f}, {0x1bc7d, 0x1bc7f}, {0x1bc89, 0x1bc8f}, {0x1bc9a, 0x1bc9b}, 
            {0x1bca4, 0x1cbff}, {0x1ccfd, 0x1ccff}, {0x1ceb4, 0x1ceb9}, {0x1ced1, 0x1cedf}, 
            {0x1cef1, 0x1ceff}, {0x1cf2e, 0x1cf2f}, {0x1cf47, 0x1cf4f}, {0x1cfc4, 0x1cfff}, 
            {0x1d0f6, 0x1d0ff}, {0x1d127, 0x1d128}, {0x1d1eb, 0x1d1ff}, {0x1d246, 0x1d2bf}, 
            {0x1d2d4, 0x1d2df}, {0x1d2f4, 0x1d2ff}, {0x1d357, 0x1d35f}, {0x1d379, 0x1d3ff}, 
            {0x1d4a0, 0x1d4a1}, {0x1d4a3, 0x1d4a4}, {0x1d4a7, 0x1d4a8}, {0x1d50b, 0x1d50c}, 
            {0x1d547, 0x1d549}, {0x1d6a6, 0x1d6a7}, {0x1d7cc, 0x1d7cd}, {0x1da8c, 0x1da9a}, 
            {0x1dab0, 0x1deff}, {0x1df1f, 0x1df24}, {0x1df2b, 0x1dfff}, {0x1e019, 0x1e01a}, 
            {0x1e02b, 0x1e02f}, {0x1e06e, 0x1e08e}, {0x1e090, 0x1e0ff}, {0x1e12d, 0x1e12f}, 
            {0x1e13e, 0x1e13f}, {0x1e14a, 0x1e14d}, {0x1e150, 0x1e28f}, {0x1e2af, 0x1e2bf}, 
            {0x1e2fa, 0x1e2fe}, {0x1e300, 0x1e4cf}, {0x1e4fa, 0x1e5cf}, {0x1e5fb, 0x1e5fe}, 
            {0x1e600, 0x1e6bf}, {0x1e6f6, 0x1e6fd}, {0x1e700, 0x1e7df}, {0x1e8c5, 0x1e8c6}, 
            {0x1e8d7, 0x1e8ff}, {0x1e94c, 0x1e94f}, {0x1e95a, 0x1e95d}, {0x1e960, 0x1ec70}, 
            {0x1ecb5, 0x1ed00}, {0x1ed3e, 0x1edff}, {0x1ee25, 0x1ee26}, {0x1ee3c, 0x1ee41}, 
            {0x1ee43, 0x1ee46}, {0x1ee55, 0x1ee56}, {0x1ee65, 0x1ee66}, {0x1ee9c, 0x1eea0}, 
            {0x1eebc, 0x1eeef}, {0x1eef2, 0x1efff}, {0x1f02c, 0x1f02f}, {0x1f094, 0x1f09f}, 
            {0x1f0af, 0x1f0b0}, {0x1f0f6, 0x1f0ff}, {0x1f1ae, 0x1f1e5}, {0x1f203, 0x1f20f}, 
            {0x1f23c, 0x1f23f}, {0x1f249, 0x1f24f}, {0x1f252, 0x1f25f}, {0x1f266, 0x1f2ff}, 
            {0x1f6d9, 0x1f6db}, {0x1f6ed, 0x1f6ef}, {0x1f6fd, 0x1f6ff}, {0x1f7da, 0x1f7df}, 
            {0x1f7ec, 0x1f7ef}, {0x1f7f1, 0x1f7ff}, {0x1f80c, 0x1f80f}, {0x1f848, 0x1f84f}, 
            {0x1f85a, 0x1f85f}, {0x1f888, 0x1f88f}, {0x1f8ae, 0x1f8af}, {0x1f8bc, 0x1f8bf}, 
            {0x1f8c2, 0x1f8cf}, {0x1f8d9, 0x1f8ff}, {0x1fa58, 0x1fa5f}, {0x1fa6e, 0x1fa6f}, 
            {0x1fa7d, 0x1fa7f}, {0x1fa8b, 0x1fa8d}, {0x1fac9, 0x1facc}, {0x1faeb, 0x1faee}, 
            {0x1faf9, 0x1faff}, {0x1fbfb, 0x1ffff}, {0x2a6e0, 0x2a6ff}, {0x2b81e, 0x2b81f}, 
            {0x2ceae, 0x2ceaf}, {0x2ebe1, 0x2ebef}, {0x2ee5e, 0x2f7ff}, {0x2fa1e, 0x2ffff}, 
            {0x3134b, 0x3134f}, {0x3347a, 0xe0000}, {0xe0002, 0xe001f}, {0xe0080, 0xe00ff}, 
            {0xe01f0, 0xeffff}, {0xffffe, 0xfffff}, {0x10fffe, 0x10ffff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass5()
{
    // Name = Letter, number of codePoints: 145701
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<char32_t>({0x00aa, 0x00b5, 0x00ba, 0x02ec, 0x02ee, 0x037f, 0x0386, 0x038c, 
            0x0559, 0x06d5, 0x06ff, 0x0710, 0x07b1, 0x07fa, 0x081a, 0x0824, 
            0x0828, 0x093d, 0x0950, 0x09b2, 0x09bd, 0x09ce, 0x09fc, 0x09ff, 
            0x0a5e, 0x0abd, 0x0ad0, 0x0af9, 0x0b3d, 0x0b71, 0x0b83, 0x0b9c, 
            0x0bd0, 0x0c3d, 0x0c80, 0x0cbd, 0x0d3d, 0x0d4e, 0x0dbd, 0x0e84, 
            0x0ea5, 0x0ebd, 0x0ec6, 0x0f00, 0x103f, 0x1061, 0x108e, 0x10c7, 
            0x10cd, 0x1258, 0x12c0, 0x17d7, 0x17dc, 0x18aa, 0x1aa7, 0x1cfa, 
            0x1f59, 0x1f5b, 0x1f5d, 0x1fbe, 0x2071, 0x207f, 0x2102, 0x2107, 
            0x2115, 0x2124, 0x2126, 0x2128, 0x214e, 0x2d27, 0x2d2d, 0x2d6f, 
            0x2e2f, 0xa8fb, 0xa9cf, 0xaa7a, 0xaab1, 0xaac0, 0xaac2, 0xfb1d, 
            0xfb3e, 0x10808, 0x1083c, 0x10a00, 0x10f27, 0x11075, 0x11144, 0x11147, 
            0x11176, 0x111da, 0x111dc, 0x11288, 0x1133d, 0x11350, 0x1138b, 0x1138e, 
            0x113b7, 0x113d1, 0x113d3, 0x114c7, 0x11644, 0x116b8, 0x11909, 0x1193f, 
            0x11941, 0x119e1, 0x119e3, 0x11a00, 0x11a3a, 0x11a50, 0x11a9d, 0x11c40, 
            0x11d46, 0x11d98, 0x11f02, 0x11fb0, 0x16f50, 0x16fe3, 0x1b132, 0x1b155, 
            0x1d4a2, 0x1d4bb, 0x1d546, 0x1e14e, 0x1e5f0, 0x1e94b, 0x1ee24, 0x1ee27, 
            0x1ee39, 0x1ee3b, 0x1ee42, 0x1ee47, 0x1ee49, 0x1ee4b, 0x1ee54, 0x1ee57, 
            0x1ee59, 0x1ee5b, 0x1ee5d, 0x1ee5f, 0x1ee64, 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x02c1}, {0x02c6, 0x02d1}, 
            {0x02e0, 0x02e4}, {0x0370, 0x0374}, {0x0376, 0x0377}, {0x037a, 0x037d}, 
            {0x0388, 0x038a}, {0x038e, 0x03a1}, {0x03a3, 0x03f5}, {0x03f7, 0x0481}, 
            {0x048a, 0x052f}, {0x0531, 0x0556}, {0x0560, 0x0588}, {0x05d0, 0x05ea}, 
            {0x05ef, 0x05f2}, {0x0620, 0x064a}, {0x066e, 0x066f}, {0x0671, 0x06d3}, 
            {0x06e5, 0x06e6}, {0x06ee, 0x06ef}, {0x06fa, 0x06fc}, {0x0712, 0x072f}, 
            {0x074d, 0x07a5}, {0x07ca, 0x07ea}, {0x07f4, 0x07f5}, {0x0800, 0x0815}, 
            {0x0840, 0x0858}, {0x0860, 0x086a}, {0x0870, 0x0887}, {0x0889, 0x088f}, 
            {0x08a0, 0x08c9}, {0x0904, 0x0939}, {0x0958, 0x0961}, {0x0971, 0x0980}, 
            {0x0985, 0x098c}, {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0}, 
            {0x09b6, 0x09b9}, {0x09dc, 0x09dd}, {0x09df, 0x09e1}, {0x09f0, 0x09f1}, 
            {0x0a05, 0x0a0a}, {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, 
            {0x0a32, 0x0a33}, {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a59, 0x0a5c}, 
            {0x0a72, 0x0a74}, {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, 
            {0x0aaa, 0x0ab0}, {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0ae0, 0x0ae1}, 
            {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, 
            {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b61}, 
            {0x0b85, 0x0b8a}, {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, 
            {0x0b9e, 0x0b9f}, {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, 
            {0x0c05, 0x0c0c}, {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, 
            {0x0c58, 0x0c5a}, {0x0c5c, 0x0c5d}, {0x0c60, 0x0c61}, {0x0c85, 0x0c8c}, 
            {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, 
            {0x0cdc, 0x0cde}, {0x0ce0, 0x0ce1}, {0x0cf1, 0x0cf2}, {0x0d04, 0x0d0c}, 
            {0x0d0e, 0x0d10}, {0x0d12, 0x0d3a}, {0x0d54, 0x0d56}, {0x0d5f, 0x0d61}, 
            {0x0d7a, 0x0d7f}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, {0x0db3, 0x0dbb}, 
            {0x0dc0, 0x0dc6}, {0x0e01, 0x0e30}, {0x0e32, 0x0e33}, {0x0e40, 0x0e46}, 
            {0x0e81, 0x0e82}, {0x0e86, 0x0e8a}, {0x0e8c, 0x0ea3}, {0x0ea7, 0x0eb0}, 
            {0x0eb2, 0x0eb3}, {0x0ec0, 0x0ec4}, {0x0edc, 0x0edf}, {0x0f40, 0x0f47}, 
            {0x0f49, 0x0f6c}, {0x0f88, 0x0f8c}, {0x1000, 0x102a}, {0x1050, 0x1055}, 
            {0x105a, 0x105d}, {0x1065, 0x1066}, {0x106e, 0x1070}, {0x1075, 0x1081}, 
            {0x10a0, 0x10c5}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, 
            {0x1250, 0x1256}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, 
            {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c2, 0x12c5}, 
            {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, 
            {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, 
            {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16f1, 0x16f8}, 
            {0x1700, 0x1711}, {0x171f, 0x1731}, {0x1740, 0x1751}, {0x1760, 0x176c}, 
            {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x1820, 0x1878}, {0x1880, 0x1884}, 
            {0x1887, 0x18a8}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, 
            {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, 
            {0x1a20, 0x1a54}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, 
            {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f}, 
            {0x1c5a, 0x1c7d}, {0x1c80, 0x1c8a}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, 
            {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, {0x1d00, 0x1dbf}, 
            {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, 
            {0x1f50, 0x1f57}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, 
            {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, 
            {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2090, 0x209c}, 
            {0x210a, 0x2113}, {0x2119, 0x211d}, {0x212a, 0x212d}, {0x212f, 0x2139}, 
            {0x213c, 0x213f}, {0x2145, 0x2149}, {0x2183, 0x2184}, {0x2c00, 0x2ce4}, 
            {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d30, 0x2d67}, 
            {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, 
            {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, 
            {0x2dd8, 0x2dde}, {0x3005, 0x3006}, {0x3031, 0x3035}, {0x303b, 0x303c}, 
            {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, 
            {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, 
            {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, 
            {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e}, {0xa67f, 0xa69d}, 
            {0xa6a0, 0xa6e5}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7dc}, 
            {0xa7f1, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, 
            {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fd, 0xa8fe}, 
            {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, 
            {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef}, {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, 
            {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7e, 0xaaaf}, 
            {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea}, 
            {0xaaf2, 0xaaf4}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, 
            {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, 
            {0xab70, 0xabe2}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, 
            {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, 
            {0xfb1f, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb40, 0xfb41}, 
            {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfd3d}, {0xfd50, 0xfd8f}, 
            {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfb}, {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, 
            {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xffbe}, {0xffc2, 0xffc7}, 
            {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, 
            {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, 
            {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, 
            {0x10300, 0x1031f}, {0x1032d, 0x10340}, {0x10342, 0x10349}, {0x10350, 0x10375}, 
            {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x10400, 0x1049d}, 
            {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, 
            {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, 
            {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, 
            {0x105c0, 0x105f3}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, 
            {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, 
            {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083f, 0x10855}, {0x10860, 0x10876}, 
            {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, 
            {0x10920, 0x10939}, {0x10940, 0x10959}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, 
            {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a60, 0x10a7c}, 
            {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, 
            {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, 
            {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10d4a, 0x10d65}, 
            {0x10d6f, 0x10d85}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1}, {0x10ec2, 0x10ec7}, 
            {0x10f00, 0x10f1c}, {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, 
            {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072}, {0x11083, 0x110af}, 
            {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11150, 0x11172}, {0x11183, 0x111b2}, 
            {0x111c1, 0x111c4}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x1123f, 0x11240}, 
            {0x11280, 0x11286}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, 
            {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, 
            {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1135d, 0x11361}, 
            {0x11380, 0x11389}, {0x11390, 0x113b5}, {0x11400, 0x11434}, {0x11447, 0x1144a}, 
            {0x1145f, 0x11461}, {0x11480, 0x114af}, {0x114c4, 0x114c5}, {0x11580, 0x115ae}, 
            {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11680, 0x116aa}, {0x11700, 0x1171a}, 
            {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, 
            {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x1192f}, {0x119a0, 0x119a7}, 
            {0x119aa, 0x119d0}, {0x11a0b, 0x11a32}, {0x11a5c, 0x11a89}, {0x11ab0, 0x11af8}, 
            {0x11bc0, 0x11be0}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e}, {0x11c72, 0x11c8f}, 
            {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d60, 0x11d65}, 
            {0x11d67, 0x11d68}, {0x11d6a, 0x11d89}, {0x11db0, 0x11ddb}, {0x11ee0, 0x11ef2}, 
            {0x11f04, 0x11f10}, {0x11f12, 0x11f33}, {0x12000, 0x12399}, {0x12480, 0x12543}, 
            {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13441, 0x13446}, {0x13460, 0x143fa}, 
            {0x14400, 0x14646}, {0x16100, 0x1611d}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, 
            {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, 
            {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16d40, 0x16d6c}, {0x16d80, 0x16d97}, 
            {0x16d99, 0x16d9c}, {0x16e40, 0x16e7f}, {0x16ea0, 0x16eb8}, {0x16ebb, 0x16ed3}, 
            {0x16f00, 0x16f4a}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16ff2, 0x16ff3}, 
            {0x17000, 0x18cd5}, {0x18cff, 0x18d1e}, {0x18d80, 0x18df2}, {0x1aff0, 0x1aff3}, 
            {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b150, 0x1b152}, 
            {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, 
            {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, 
            {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, 
            {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, 
            {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, 
            {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, 
            {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, 
            {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, 
            {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e030, 0x1e06d}, 
            {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d}, {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, 
            {0x1e4d0, 0x1e4eb}, {0x1e5d0, 0x1e5ed}, {0x1e6c0, 0x1e6de}, {0x1e6e0, 0x1e6e2}, 
            {0x1e6e4, 0x1e6e5}, {0x1e6e7, 0x1e6ed}, {0x1e6f0, 0x1e6f4}, {0x1e6fe, 0x1e6ff}, 
            {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, 
            {0x1e800, 0x1e8c4}, {0x1e900, 0x1e943}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, 
            {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee4d, 0x1ee4f}, 
            {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, 
            {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, 
            {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, 
            {0x2a700, 0x2b81d}, {0x2b820, 0x2cead}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, 
            {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x33479}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass6()
{
    // Name = Cased_Letter, number of codePoints: 4200
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<char32_t>({0x00b5, 0x037f, 0x0386, 0x038c, 0x10c7, 0x10cd, 0x1f59, 0x1f5b, 
            0x1f5d, 0x1fbe, 0x2102, 0x2107, 0x2115, 0x2124, 0x2126, 0x2128, 
            0x2139, 0x214e, 0x2d27, 0x2d2d, 0xa7fa, 0x1d4a2, 0x1d4bb, 0x1d546}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x01ba}, {0x01bc, 0x01bf}, 
            {0x01c4, 0x0293}, {0x0296, 0x02af}, {0x0370, 0x0373}, {0x0376, 0x0377}, 
            {0x037b, 0x037d}, {0x0388, 0x038a}, {0x038e, 0x03a1}, {0x03a3, 0x03f5}, 
            {0x03f7, 0x0481}, {0x048a, 0x052f}, {0x0531, 0x0556}, {0x0560, 0x0588}, 
            {0x10a0, 0x10c5}, {0x10d0, 0x10fa}, {0x10fd, 0x10ff}, {0x13a0, 0x13f5}, 
            {0x13f8, 0x13fd}, {0x1c80, 0x1c8a}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, 
            {0x1d00, 0x1d2b}, {0x1d6b, 0x1d77}, {0x1d79, 0x1d9a}, {0x1e00, 0x1f15}, 
            {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, 
            {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fc2, 0x1fc4}, 
            {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, 
            {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x210a, 0x2113}, {0x2119, 0x211d}, 
            {0x212a, 0x212d}, {0x212f, 0x2134}, {0x213c, 0x213f}, {0x2145, 0x2149}, 
            {0x2183, 0x2184}, {0x2c00, 0x2c7b}, {0x2c7e, 0x2ce4}, {0x2ceb, 0x2cee}, 
            {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, {0xa640, 0xa66d}, {0xa680, 0xa69b}, 
            {0xa722, 0xa76f}, {0xa771, 0xa787}, {0xa78b, 0xa78e}, {0xa790, 0xa7dc}, 
            {0xa7f5, 0xa7f6}, {0xab30, 0xab5a}, {0xab60, 0xab68}, {0xab70, 0xabbf}, 
            {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, 
            {0x10400, 0x1044f}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10570, 0x1057a}, 
            {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, 
            {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10c80, 0x10cb2}, 
            {0x10cc0, 0x10cf2}, {0x10d50, 0x10d65}, {0x10d70, 0x10d85}, {0x118a0, 0x118df}, 
            {0x16e40, 0x16e7f}, {0x16ea0, 0x16eb8}, {0x16ebb, 0x16ed3}, {0x1d400, 0x1d454}, 
            {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, 
            {0x1d4ae, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, 
            {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, 
            {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, 
            {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, 
            {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, 
            {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df09}, {0x1df0b, 0x1df1e}, 
            {0x1df25, 0x1df2a}, {0x1e900, 0x1e943}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass7()
{
    // Name = Control, number of codePoints: 65
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x7f}),
        std::initializer_list<CharacterRange>({{0x00, 0x1f}}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0080, 0x009f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass8()
{
    // Name = Separator, number of codePoints: 19
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x20}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00a0, 0x1680, 0x202f, 0x205f, 0x3000}),
        std::initializer_list<CharacterRange>({{0x2000, 0x200a}, {0x2028, 0x2029}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass9()
{
    // Name = Space_Separator, number of codePoints: 17
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x20}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00a0, 0x1680, 0x202f, 0x205f, 0x3000}),
        std::initializer_list<CharacterRange>({{0x2000, 0x200a}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass10()
{
    // Name = Punctuation, number of codePoints: 856
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x5f, 0x7b, 0x7d}),
        std::initializer_list<CharacterRange>({{0x21, 0x23}, {0x25, 0x2a}, {0x2c, 0x2f}, {0x3a, 0x3b}, 
            {0x3f, 0x40}, {0x5b, 0x5d}}),
        std::initializer_list<char32_t>({0x00a1, 0x00a7, 0x00ab, 0x00bb, 0x00bf, 0x037e, 0x0387, 0x05be, 
            0x05c0, 0x05c3, 0x05c6, 0x061b, 0x06d4, 0x085e, 0x0970, 0x09fd, 
            0x0a76, 0x0af0, 0x0c77, 0x0c84, 0x0df4, 0x0e4f, 0x0f14, 0x0f85, 
            0x10fb, 0x1400, 0x166e, 0x1cd3, 0x2d70, 0x3030, 0x303d, 0x30a0, 
            0x30fb, 0xa673, 0xa67e, 0xa8fc, 0xa95f, 0xabeb, 0xfe63, 0xfe68, 
            0xff3f, 0xff5b, 0xff5d, 0x1039f, 0x103d0, 0x1056f, 0x10857, 0x1091f, 
            0x1093f, 0x10a7f, 0x10d6e, 0x10ead, 0x10ed0, 0x111cd, 0x111db, 0x112a9, 
            0x1145d, 0x114c6, 0x116b9, 0x1183b, 0x119e2, 0x11be1, 0x11fff, 0x16af5, 
            0x16b44, 0x16fe2, 0x1bc9f, 0x1e5ff}),
        std::initializer_list<CharacterRange>({{0x00b6, 0x00b7}, {0x055a, 0x055f}, {0x0589, 0x058a}, {0x05f3, 0x05f4}, 
            {0x0609, 0x060a}, {0x060c, 0x060d}, {0x061d, 0x061f}, {0x066a, 0x066d}, 
            {0x0700, 0x070d}, {0x07f7, 0x07f9}, {0x0830, 0x083e}, {0x0964, 0x0965}, 
            {0x0e5a, 0x0e5b}, {0x0f04, 0x0f12}, {0x0f3a, 0x0f3d}, {0x0fd0, 0x0fd4}, 
            {0x0fd9, 0x0fda}, {0x104a, 0x104f}, {0x1360, 0x1368}, {0x169b, 0x169c}, 
            {0x16eb, 0x16ed}, {0x1735, 0x1736}, {0x17d4, 0x17d6}, {0x17d8, 0x17da}, 
            {0x1800, 0x180a}, {0x1944, 0x1945}, {0x1a1e, 0x1a1f}, {0x1aa0, 0x1aa6}, 
            {0x1aa8, 0x1aad}, {0x1b4e, 0x1b4f}, {0x1b5a, 0x1b60}, {0x1b7d, 0x1b7f}, 
            {0x1bfc, 0x1bff}, {0x1c3b, 0x1c3f}, {0x1c7e, 0x1c7f}, {0x1cc0, 0x1cc7}, 
            {0x2010, 0x2027}, {0x2030, 0x2043}, {0x2045, 0x2051}, {0x2053, 0x205e}, 
            {0x207d, 0x207e}, {0x208d, 0x208e}, {0x2308, 0x230b}, {0x2329, 0x232a}, 
            {0x2768, 0x2775}, {0x27c5, 0x27c6}, {0x27e6, 0x27ef}, {0x2983, 0x2998}, 
            {0x29d8, 0x29db}, {0x29fc, 0x29fd}, {0x2cf9, 0x2cfc}, {0x2cfe, 0x2cff}, 
            {0x2e00, 0x2e2e}, {0x2e30, 0x2e4f}, {0x2e52, 0x2e5d}, {0x3001, 0x3003}, 
            {0x3008, 0x3011}, {0x3014, 0x301f}, {0xa4fe, 0xa4ff}, {0xa60d, 0xa60f}, 
            {0xa6f2, 0xa6f7}, {0xa874, 0xa877}, {0xa8ce, 0xa8cf}, {0xa8f8, 0xa8fa}, 
            {0xa92e, 0xa92f}, {0xa9c1, 0xa9cd}, {0xa9de, 0xa9df}, {0xaa5c, 0xaa5f}, 
            {0xaade, 0xaadf}, {0xaaf0, 0xaaf1}, {0xfd3e, 0xfd3f}, {0xfe10, 0xfe19}, 
            {0xfe30, 0xfe52}, {0xfe54, 0xfe61}, {0xfe6a, 0xfe6b}, {0xff01, 0xff03}, 
            {0xff05, 0xff0a}, {0xff0c, 0xff0f}, {0xff1a, 0xff1b}, {0xff1f, 0xff20}, 
            {0xff3b, 0xff3d}, {0xff5f, 0xff65}, {0x10100, 0x10102}, {0x10a50, 0x10a58}, 
            {0x10af0, 0x10af6}, {0x10b39, 0x10b3f}, {0x10b99, 0x10b9c}, {0x10f55, 0x10f59}, 
            {0x10f86, 0x10f89}, {0x11047, 0x1104d}, {0x110bb, 0x110bc}, {0x110be, 0x110c1}, 
            {0x11140, 0x11143}, {0x11174, 0x11175}, {0x111c5, 0x111c8}, {0x111dd, 0x111df}, 
            {0x11238, 0x1123d}, {0x113d4, 0x113d5}, {0x113d7, 0x113d8}, {0x1144b, 0x1144f}, 
            {0x1145a, 0x1145b}, {0x115c1, 0x115d7}, {0x11641, 0x11643}, {0x11660, 0x1166c}, 
            {0x1173c, 0x1173e}, {0x11944, 0x11946}, {0x11a3f, 0x11a46}, {0x11a9a, 0x11a9c}, 
            {0x11a9e, 0x11aa2}, {0x11b00, 0x11b09}, {0x11c41, 0x11c45}, {0x11c70, 0x11c71}, 
            {0x11ef7, 0x11ef8}, {0x11f43, 0x11f4f}, {0x12470, 0x12474}, {0x12ff1, 0x12ff2}, 
            {0x16a6e, 0x16a6f}, {0x16b37, 0x16b3b}, {0x16d6d, 0x16d6f}, {0x16e97, 0x16e9a}, 
            {0x1da87, 0x1da8b}, {0x1e95e, 0x1e95f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass11()
{
    // Name = Other_Punctuation, number of codePoints: 641
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x2a, 0x2c, 0x5c}),
        std::initializer_list<CharacterRange>({{0x21, 0x23}, {0x25, 0x27}, {0x2e, 0x2f}, {0x3a, 0x3b}, 
            {0x3f, 0x40}}),
        std::initializer_list<char32_t>({0x00a1, 0x00a7, 0x00bf, 0x037e, 0x0387, 0x0589, 0x05c0, 0x05c3, 
            0x05c6, 0x061b, 0x06d4, 0x085e, 0x0970, 0x09fd, 0x0a76, 0x0af0, 
            0x0c77, 0x0c84, 0x0df4, 0x0e4f, 0x0f14, 0x0f85, 0x10fb, 0x166e, 
            0x1cd3, 0x2053, 0x2d70, 0x2e0b, 0x2e1b, 0x2e41, 0x303d, 0x30fb, 
            0xa673, 0xa67e, 0xa8fc, 0xa95f, 0xabeb, 0xfe19, 0xfe30, 0xfe68, 
            0xff0a, 0xff0c, 0xff3c, 0xff61, 0x1039f, 0x103d0, 0x1056f, 0x10857, 
            0x1091f, 0x1093f, 0x10a7f, 0x10ed0, 0x111cd, 0x111db, 0x112a9, 0x1145d, 
            0x114c6, 0x116b9, 0x1183b, 0x119e2, 0x11be1, 0x11fff, 0x16af5, 0x16b44, 
            0x16fe2, 0x1bc9f, 0x1e5ff}),
        std::initializer_list<CharacterRange>({{0x00b6, 0x00b7}, {0x055a, 0x055f}, {0x05f3, 0x05f4}, {0x0609, 0x060a}, 
            {0x060c, 0x060d}, {0x061d, 0x061f}, {0x066a, 0x066d}, {0x0700, 0x070d}, 
            {0x07f7, 0x07f9}, {0x0830, 0x083e}, {0x0964, 0x0965}, {0x0e5a, 0x0e5b}, 
            {0x0f04, 0x0f12}, {0x0fd0, 0x0fd4}, {0x0fd9, 0x0fda}, {0x104a, 0x104f}, 
            {0x1360, 0x1368}, {0x16eb, 0x16ed}, {0x1735, 0x1736}, {0x17d4, 0x17d6}, 
            {0x17d8, 0x17da}, {0x1800, 0x1805}, {0x1807, 0x180a}, {0x1944, 0x1945}, 
            {0x1a1e, 0x1a1f}, {0x1aa0, 0x1aa6}, {0x1aa8, 0x1aad}, {0x1b4e, 0x1b4f}, 
            {0x1b5a, 0x1b60}, {0x1b7d, 0x1b7f}, {0x1bfc, 0x1bff}, {0x1c3b, 0x1c3f}, 
            {0x1c7e, 0x1c7f}, {0x1cc0, 0x1cc7}, {0x2016, 0x2017}, {0x2020, 0x2027}, 
            {0x2030, 0x2038}, {0x203b, 0x203e}, {0x2041, 0x2043}, {0x2047, 0x2051}, 
            {0x2055, 0x205e}, {0x2cf9, 0x2cfc}, {0x2cfe, 0x2cff}, {0x2e00, 0x2e01}, 
            {0x2e06, 0x2e08}, {0x2e0e, 0x2e16}, {0x2e18, 0x2e19}, {0x2e1e, 0x2e1f}, 
            {0x2e2a, 0x2e2e}, {0x2e30, 0x2e39}, {0x2e3c, 0x2e3f}, {0x2e43, 0x2e4f}, 
            {0x2e52, 0x2e54}, {0x3001, 0x3003}, {0xa4fe, 0xa4ff}, {0xa60d, 0xa60f}, 
            {0xa6f2, 0xa6f7}, {0xa874, 0xa877}, {0xa8ce, 0xa8cf}, {0xa8f8, 0xa8fa}, 
            {0xa92e, 0xa92f}, {0xa9c1, 0xa9cd}, {0xa9de, 0xa9df}, {0xaa5c, 0xaa5f}, 
            {0xaade, 0xaadf}, {0xaaf0, 0xaaf1}, {0xfe10, 0xfe16}, {0xfe45, 0xfe46}, 
            {0xfe49, 0xfe4c}, {0xfe50, 0xfe52}, {0xfe54, 0xfe57}, {0xfe5f, 0xfe61}, 
            {0xfe6a, 0xfe6b}, {0xff01, 0xff03}, {0xff05, 0xff07}, {0xff0e, 0xff0f}, 
            {0xff1a, 0xff1b}, {0xff1f, 0xff20}, {0xff64, 0xff65}, {0x10100, 0x10102}, 
            {0x10a50, 0x10a58}, {0x10af0, 0x10af6}, {0x10b39, 0x10b3f}, {0x10b99, 0x10b9c}, 
            {0x10f55, 0x10f59}, {0x10f86, 0x10f89}, {0x11047, 0x1104d}, {0x110bb, 0x110bc}, 
            {0x110be, 0x110c1}, {0x11140, 0x11143}, {0x11174, 0x11175}, {0x111c5, 0x111c8}, 
            {0x111dd, 0x111df}, {0x11238, 0x1123d}, {0x113d4, 0x113d5}, {0x113d7, 0x113d8}, 
            {0x1144b, 0x1144f}, {0x1145a, 0x1145b}, {0x115c1, 0x115d7}, {0x11641, 0x11643}, 
            {0x11660, 0x1166c}, {0x1173c, 0x1173e}, {0x11944, 0x11946}, {0x11a3f, 0x11a46}, 
            {0x11a9a, 0x11a9c}, {0x11a9e, 0x11aa2}, {0x11b00, 0x11b09}, {0x11c41, 0x11c45}, 
            {0x11c70, 0x11c71}, {0x11ef7, 0x11ef8}, {0x11f43, 0x11f4f}, {0x12470, 0x12474}, 
            {0x12ff1, 0x12ff2}, {0x16a6e, 0x16a6f}, {0x16b37, 0x16b3b}, {0x16d6d, 0x16d6f}, 
            {0x16e97, 0x16e9a}, {0x1da87, 0x1da8b}, {0x1e95e, 0x1e95f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass12()
{
    // Name = Symbol, number of codePoints: 8618
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x24, 0x2b, 0x5e, 0x60, 0x7c, 0x7e}),
        std::initializer_list<CharacterRange>({{0x3c, 0x3e}}),
        std::initializer_list<char32_t>({0x00ac, 0x00b4, 0x00b8, 0x00d7, 0x00f7, 0x02ed, 0x0375, 0x03f6, 
            0x0482, 0x060b, 0x06de, 0x06e9, 0x07f6, 0x0888, 0x0af1, 0x0b70, 
            0x0c7f, 0x0d4f, 0x0d79, 0x0e3f, 0x0f13, 0x0f34, 0x0f36, 0x0f38, 
            0x166d, 0x17db, 0x1940, 0x1fbd, 0x2044, 0x2052, 0x2114, 0x2125, 
            0x2127, 0x2129, 0x212e, 0x214f, 0x3004, 0x3020, 0x31ef, 0x3250, 
            0xab5b, 0xfb29, 0xfe62, 0xfe69, 0xff04, 0xff0b, 0xff3e, 0xff40, 
            0xff5c, 0xff5e, 0x101a0, 0x10ac8, 0x1173f, 0x16b45, 0x1bc9c, 0x1d245, 
            0x1d6c1, 0x1d6db, 0x1d6fb, 0x1d715, 0x1d735, 0x1d74f, 0x1d76f, 0x1d789, 
            0x1d7a9, 0x1d7c3, 0x1e14f, 0x1e2ff, 0x1ecac, 0x1ecb0, 0x1ed2e, 0x1f7f0, 
            0x1fac8, 0x1fbfa}),
        std::initializer_list<CharacterRange>({{0x00a2, 0x00a6}, {0x00a8, 0x00a9}, {0x00ae, 0x00b1}, {0x02c2, 0x02c5}, 
            {0x02d2, 0x02df}, {0x02e5, 0x02eb}, {0x02ef, 0x02ff}, {0x0384, 0x0385}, 
            {0x058d, 0x058f}, {0x0606, 0x0608}, {0x060e, 0x060f}, {0x06fd, 0x06fe}, 
            {0x07fe, 0x07ff}, {0x09f2, 0x09f3}, {0x09fa, 0x09fb}, {0x0bf3, 0x0bfa}, 
            {0x0f01, 0x0f03}, {0x0f15, 0x0f17}, {0x0f1a, 0x0f1f}, {0x0fbe, 0x0fc5}, 
            {0x0fc7, 0x0fcc}, {0x0fce, 0x0fcf}, {0x0fd5, 0x0fd8}, {0x109e, 0x109f}, 
            {0x1390, 0x1399}, {0x19de, 0x19ff}, {0x1b61, 0x1b6a}, {0x1b74, 0x1b7c}, 
            {0x1fbf, 0x1fc1}, {0x1fcd, 0x1fcf}, {0x1fdd, 0x1fdf}, {0x1fed, 0x1fef}, 
            {0x1ffd, 0x1ffe}, {0x207a, 0x207c}, {0x208a, 0x208c}, {0x20a0, 0x20c1}, 
            {0x2100, 0x2101}, {0x2103, 0x2106}, {0x2108, 0x2109}, {0x2116, 0x2118}, 
            {0x211e, 0x2123}, {0x213a, 0x213b}, {0x2140, 0x2144}, {0x214a, 0x214d}, 
            {0x218a, 0x218b}, {0x2190, 0x2307}, {0x230c, 0x2328}, {0x232b, 0x2429}, 
            {0x2440, 0x244a}, {0x249c, 0x24e9}, {0x2500, 0x2767}, {0x2794, 0x27c4}, 
            {0x27c7, 0x27e5}, {0x27f0, 0x2982}, {0x2999, 0x29d7}, {0x29dc, 0x29fb}, 
            {0x29fe, 0x2b73}, {0x2b76, 0x2bff}, {0x2ce5, 0x2cea}, {0x2e50, 0x2e51}, 
            {0x2e80, 0x2e99}, {0x2e9b, 0x2ef3}, {0x2f00, 0x2fd5}, {0x2ff0, 0x2fff}, 
            {0x3012, 0x3013}, {0x3036, 0x3037}, {0x303e, 0x303f}, {0x309b, 0x309c}, 
            {0x3190, 0x3191}, {0x3196, 0x319f}, {0x31c0, 0x31e5}, {0x3200, 0x321e}, 
            {0x322a, 0x3247}, {0x3260, 0x327f}, {0x328a, 0x32b0}, {0x32c0, 0x33ff}, 
            {0x4dc0, 0x4dff}, {0xa490, 0xa4c6}, {0xa700, 0xa716}, {0xa720, 0xa721}, 
            {0xa789, 0xa78a}, {0xa828, 0xa82b}, {0xa836, 0xa839}, {0xaa77, 0xaa79}, 
            {0xab6a, 0xab6b}, {0xfbb2, 0xfbd2}, {0xfd40, 0xfd4f}, {0xfd90, 0xfd91}, 
            {0xfdc8, 0xfdcf}, {0xfdfc, 0xfdff}, {0xfe64, 0xfe66}, {0xff1c, 0xff1e}, 
            {0xffe0, 0xffe6}, {0xffe8, 0xffee}, {0xfffc, 0xfffd}, {0x10137, 0x1013f}, 
            {0x10179, 0x10189}, {0x1018c, 0x1018e}, {0x10190, 0x1019c}, {0x101d0, 0x101fc}, 
            {0x10877, 0x10878}, {0x10d8e, 0x10d8f}, {0x10ed1, 0x10ed8}, {0x11fd5, 0x11ff1}, 
            {0x16b3c, 0x16b3f}, {0x1cc00, 0x1ccef}, {0x1ccfa, 0x1ccfc}, {0x1cd00, 0x1ceb3}, 
            {0x1ceba, 0x1ced0}, {0x1cee0, 0x1cef0}, {0x1cf50, 0x1cfc3}, {0x1d000, 0x1d0f5}, 
            {0x1d100, 0x1d126}, {0x1d129, 0x1d164}, {0x1d16a, 0x1d16c}, {0x1d183, 0x1d184}, 
            {0x1d18c, 0x1d1a9}, {0x1d1ae, 0x1d1ea}, {0x1d200, 0x1d241}, {0x1d300, 0x1d356}, 
            {0x1d800, 0x1d9ff}, {0x1da37, 0x1da3a}, {0x1da6d, 0x1da74}, {0x1da76, 0x1da83}, 
            {0x1da85, 0x1da86}, {0x1eef0, 0x1eef1}, {0x1f000, 0x1f02b}, {0x1f030, 0x1f093}, 
            {0x1f0a0, 0x1f0ae}, {0x1f0b1, 0x1f0bf}, {0x1f0c1, 0x1f0cf}, {0x1f0d1, 0x1f0f5}, 
            {0x1f10d, 0x1f1ad}, {0x1f1e6, 0x1f202}, {0x1f210, 0x1f23b}, {0x1f240, 0x1f248}, 
            {0x1f250, 0x1f251}, {0x1f260, 0x1f265}, {0x1f300, 0x1f6d8}, {0x1f6dc, 0x1f6ec}, 
            {0x1f6f0, 0x1f6fc}, {0x1f700, 0x1f7d9}, {0x1f7e0, 0x1f7eb}, {0x1f800, 0x1f80b}, 
            {0x1f810, 0x1f847}, {0x1f850, 0x1f859}, {0x1f860, 0x1f887}, {0x1f890, 0x1f8ad}, 
            {0x1f8b0, 0x1f8bb}, {0x1f8c0, 0x1f8c1}, {0x1f8d0, 0x1f8d8}, {0x1f900, 0x1fa57}, 
            {0x1fa60, 0x1fa6d}, {0x1fa70, 0x1fa7c}, {0x1fa80, 0x1fa8a}, {0x1fa8e, 0x1fac6}, 
            {0x1facd, 0x1fadd}, {0x1fadf, 0x1faea}, {0x1faef, 0x1faf8}, {0x1fb00, 0x1fb92}, 
            {0x1fb94, 0x1fbef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass13()
{
    // Name = Currency_Symbol, number of codePoints: 64
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x24}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x058f, 0x060b, 0x09fb, 0x0af1, 0x0bf9, 0x0e3f, 0x17db, 0xa838, 
            0xfdfc, 0xfe69, 0xff04, 0x1e2ff, 0x1ecb0}),
        std::initializer_list<CharacterRange>({{0x00a2, 0x00a5}, {0x07fe, 0x07ff}, {0x09f2, 0x09f3}, {0x20a0, 0x20c1}, 
            {0xffe0, 0xffe1}, {0xffe5, 0xffe6}, {0x11fdd, 0x11fe0}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass14()
{
    // Name = Open_Punctuation, number of codePoints: 79
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x28, 0x5b, 0x7b}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0f3a, 0x0f3c, 0x169b, 0x201a, 0x201e, 0x2045, 0x207d, 0x208d, 
            0x2308, 0x230a, 0x2329, 0x2768, 0x276a, 0x276c, 0x276e, 0x2770, 
            0x2772, 0x2774, 0x27c5, 0x27e6, 0x27e8, 0x27ea, 0x27ec, 0x27ee, 
            0x2983, 0x2985, 0x2987, 0x2989, 0x298b, 0x298d, 0x298f, 0x2991, 
            0x2993, 0x2995, 0x2997, 0x29d8, 0x29da, 0x29fc, 0x2e22, 0x2e24, 
            0x2e26, 0x2e28, 0x2e42, 0x2e55, 0x2e57, 0x2e59, 0x2e5b, 0x3008, 
            0x300a, 0x300c, 0x300e, 0x3010, 0x3014, 0x3016, 0x3018, 0x301a, 
            0x301d, 0xfd3f, 0xfe17, 0xfe35, 0xfe37, 0xfe39, 0xfe3b, 0xfe3d, 
            0xfe3f, 0xfe41, 0xfe43, 0xfe47, 0xfe59, 0xfe5b, 0xfe5d, 0xff08, 
            0xff3b, 0xff5b, 0xff5f, 0xff62}),
        std::initializer_list<CharacterRange>({}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass15()
{
    // Name = Close_Punctuation, number of codePoints: 77
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x29, 0x5d, 0x7d}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0f3b, 0x0f3d, 0x169c, 0x2046, 0x207e, 0x208e, 0x2309, 0x230b, 
            0x232a, 0x2769, 0x276b, 0x276d, 0x276f, 0x2771, 0x2773, 0x2775, 
            0x27c6, 0x27e7, 0x27e9, 0x27eb, 0x27ed, 0x27ef, 0x2984, 0x2986, 
            0x2988, 0x298a, 0x298c, 0x298e, 0x2990, 0x2992, 0x2994, 0x2996, 
            0x2998, 0x29d9, 0x29db, 0x29fd, 0x2e23, 0x2e25, 0x2e27, 0x2e29, 
            0x2e56, 0x2e58, 0x2e5a, 0x2e5c, 0x3009, 0x300b, 0x300d, 0x300f, 
            0x3011, 0x3015, 0x3017, 0x3019, 0x301b, 0xfd3e, 0xfe18, 0xfe36, 
            0xfe38, 0xfe3a, 0xfe3c, 0xfe3e, 0xfe40, 0xfe42, 0xfe44, 0xfe48, 
            0xfe5a, 0xfe5c, 0xfe5e, 0xff09, 0xff3d, 0xff5d, 0xff60, 0xff63}),
        std::initializer_list<CharacterRange>({{0x301e, 0x301f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass16()
{
    // Name = Math_Symbol, number of codePoints: 960
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x2b, 0x7c, 0x7e}),
        std::initializer_list<CharacterRange>({{0x3c, 0x3e}}),
        std::initializer_list<char32_t>({0x00ac, 0x00b1, 0x00d7, 0x00f7, 0x03f6, 0x2044, 0x2052, 0x2118, 
            0x214b, 0x21a0, 0x21a3, 0x21a6, 0x21ae, 0x21d2, 0x21d4, 0x237c, 
            0x25b7, 0x25c1, 0x266f, 0xfb29, 0xfe62, 0xff0b, 0xff5c, 0xff5e, 
            0xffe2, 0x1cef0, 0x1d6c1, 0x1d6db, 0x1d6fb, 0x1d715, 0x1d735, 0x1d74f, 
            0x1d76f, 0x1d789, 0x1d7a9, 0x1d7c3}),
        std::initializer_list<CharacterRange>({{0x0606, 0x0608}, {0x207a, 0x207c}, {0x208a, 0x208c}, {0x2140, 0x2144}, 
            {0x2190, 0x2194}, {0x219a, 0x219b}, {0x21ce, 0x21cf}, {0x21f4, 0x22ff}, 
            {0x2320, 0x2321}, {0x239b, 0x23b3}, {0x23dc, 0x23e1}, {0x25f8, 0x25ff}, 
            {0x27c0, 0x27c4}, {0x27c7, 0x27e5}, {0x27f0, 0x27ff}, {0x2900, 0x2982}, 
            {0x2999, 0x29d7}, {0x29dc, 0x29fb}, {0x29fe, 0x2aff}, {0x2b30, 0x2b44}, 
            {0x2b47, 0x2b4c}, {0xfe64, 0xfe66}, {0xff1c, 0xff1e}, {0xffe9, 0xffec}, 
            {0x10d8e, 0x10d8f}, {0x1eef0, 0x1eef1}, {0x1f8d0, 0x1f8d8}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass17()
{
    // Name = Dash_Punctuation, number of codePoints: 27
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x2d}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x058a, 0x05be, 0x1400, 0x1806, 0x2e17, 0x2e1a, 0x2e40, 0x2e5d, 
            0x301c, 0x3030, 0x30a0, 0xfe58, 0xfe63, 0xff0d, 0x10d6e, 0x10ead}),
        std::initializer_list<CharacterRange>({{0x2010, 0x2015}, {0x2e3a, 0x2e3b}, {0xfe31, 0xfe32}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass18()
{
    // Name = Number, number of codePoints: 1934
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x30, 0x39}}),
        std::initializer_list<char32_t>({0x00b9, 0x2070, 0x2cfd, 0x3007, 0x10341, 0x1034a}),
        std::initializer_list<CharacterRange>({{0x00b2, 0x00b3}, {0x00bc, 0x00be}, {0x0660, 0x0669}, {0x06f0, 0x06f9}, 
            {0x07c0, 0x07c9}, {0x0966, 0x096f}, {0x09e6, 0x09ef}, {0x09f4, 0x09f9}, 
            {0x0a66, 0x0a6f}, {0x0ae6, 0x0aef}, {0x0b66, 0x0b6f}, {0x0b72, 0x0b77}, 
            {0x0be6, 0x0bf2}, {0x0c66, 0x0c6f}, {0x0c78, 0x0c7e}, {0x0ce6, 0x0cef}, 
            {0x0d58, 0x0d5e}, {0x0d66, 0x0d78}, {0x0de6, 0x0def}, {0x0e50, 0x0e59}, 
            {0x0ed0, 0x0ed9}, {0x0f20, 0x0f33}, {0x1040, 0x1049}, {0x1090, 0x1099}, 
            {0x1369, 0x137c}, {0x16ee, 0x16f0}, {0x17e0, 0x17e9}, {0x17f0, 0x17f9}, 
            {0x1810, 0x1819}, {0x1946, 0x194f}, {0x19d0, 0x19da}, {0x1a80, 0x1a89}, 
            {0x1a90, 0x1a99}, {0x1b50, 0x1b59}, {0x1bb0, 0x1bb9}, {0x1c40, 0x1c49}, 
            {0x1c50, 0x1c59}, {0x2074, 0x2079}, {0x2080, 0x2089}, {0x2150, 0x2182}, 
            {0x2185, 0x2189}, {0x2460, 0x249b}, {0x24ea, 0x24ff}, {0x2776, 0x2793}, 
            {0x3021, 0x3029}, {0x3038, 0x303a}, {0x3192, 0x3195}, {0x3220, 0x3229}, 
            {0x3248, 0x324f}, {0x3251, 0x325f}, {0x3280, 0x3289}, {0x32b1, 0x32bf}, 
            {0xa620, 0xa629}, {0xa6e6, 0xa6ef}, {0xa830, 0xa835}, {0xa8d0, 0xa8d9}, 
            {0xa900, 0xa909}, {0xa9d0, 0xa9d9}, {0xa9f0, 0xa9f9}, {0xaa50, 0xaa59}, 
            {0xabf0, 0xabf9}, {0xff10, 0xff19}, {0x10107, 0x10133}, {0x10140, 0x10178}, 
            {0x1018a, 0x1018b}, {0x102e1, 0x102fb}, {0x10320, 0x10323}, {0x103d1, 0x103d5}, 
            {0x104a0, 0x104a9}, {0x10858, 0x1085f}, {0x10879, 0x1087f}, {0x108a7, 0x108af}, 
            {0x108fb, 0x108ff}, {0x10916, 0x1091b}, {0x109bc, 0x109bd}, {0x109c0, 0x109cf}, 
            {0x109d2, 0x109ff}, {0x10a40, 0x10a48}, {0x10a7d, 0x10a7e}, {0x10a9d, 0x10a9f}, 
            {0x10aeb, 0x10aef}, {0x10b58, 0x10b5f}, {0x10b78, 0x10b7f}, {0x10ba9, 0x10baf}, 
            {0x10cfa, 0x10cff}, {0x10d30, 0x10d39}, {0x10d40, 0x10d49}, {0x10e60, 0x10e7e}, 
            {0x10f1d, 0x10f26}, {0x10f51, 0x10f54}, {0x10fc5, 0x10fcb}, {0x11052, 0x1106f}, 
            {0x110f0, 0x110f9}, {0x11136, 0x1113f}, {0x111d0, 0x111d9}, {0x111e1, 0x111f4}, 
            {0x112f0, 0x112f9}, {0x11450, 0x11459}, {0x114d0, 0x114d9}, {0x11650, 0x11659}, 
            {0x116c0, 0x116c9}, {0x116d0, 0x116e3}, {0x11730, 0x1173b}, {0x118e0, 0x118f2}, 
            {0x11950, 0x11959}, {0x11bf0, 0x11bf9}, {0x11c50, 0x11c6c}, {0x11d50, 0x11d59}, 
            {0x11da0, 0x11da9}, {0x11de0, 0x11de9}, {0x11f50, 0x11f59}, {0x11fc0, 0x11fd4}, 
            {0x12400, 0x1246e}, {0x16130, 0x16139}, {0x16a60, 0x16a69}, {0x16ac0, 0x16ac9}, 
            {0x16b50, 0x16b59}, {0x16b5b, 0x16b61}, {0x16d70, 0x16d79}, {0x16da0, 0x16da9}, 
            {0x16e80, 0x16e96}, {0x16ff4, 0x16ff6}, {0x1ccf0, 0x1ccf9}, {0x1d2c0, 0x1d2d3}, 
            {0x1d2e0, 0x1d2f3}, {0x1d360, 0x1d378}, {0x1d7ce, 0x1d7ff}, {0x1e140, 0x1e149}, 
            {0x1e2f0, 0x1e2f9}, {0x1e4f0, 0x1e4f9}, {0x1e5f1, 0x1e5fa}, {0x1e8c7, 0x1e8cf}, 
            {0x1e950, 0x1e959}, {0x1ec71, 0x1ecab}, {0x1ecad, 0x1ecaf}, {0x1ecb1, 0x1ecb4}, 
            {0x1ed01, 0x1ed2d}, {0x1ed2f, 0x1ed3d}, {0x1f100, 0x1f10c}, {0x1fbf0, 0x1fbf9}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass19()
{
    // Name = Decimal_Number, number of codePoints: 780
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x30, 0x39}}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0660, 0x0669}, {0x06f0, 0x06f9}, {0x07c0, 0x07c9}, {0x0966, 0x096f}, 
            {0x09e6, 0x09ef}, {0x0a66, 0x0a6f}, {0x0ae6, 0x0aef}, {0x0b66, 0x0b6f}, 
            {0x0be6, 0x0bef}, {0x0c66, 0x0c6f}, {0x0ce6, 0x0cef}, {0x0d66, 0x0d6f}, 
            {0x0de6, 0x0def}, {0x0e50, 0x0e59}, {0x0ed0, 0x0ed9}, {0x0f20, 0x0f29}, 
            {0x1040, 0x1049}, {0x1090, 0x1099}, {0x17e0, 0x17e9}, {0x1810, 0x1819}, 
            {0x1946, 0x194f}, {0x19d0, 0x19d9}, {0x1a80, 0x1a89}, {0x1a90, 0x1a99}, 
            {0x1b50, 0x1b59}, {0x1bb0, 0x1bb9}, {0x1c40, 0x1c49}, {0x1c50, 0x1c59}, 
            {0xa620, 0xa629}, {0xa8d0, 0xa8d9}, {0xa900, 0xa909}, {0xa9d0, 0xa9d9}, 
            {0xa9f0, 0xa9f9}, {0xaa50, 0xaa59}, {0xabf0, 0xabf9}, {0xff10, 0xff19}, 
            {0x104a0, 0x104a9}, {0x10d30, 0x10d39}, {0x10d40, 0x10d49}, {0x11066, 0x1106f}, 
            {0x110f0, 0x110f9}, {0x11136, 0x1113f}, {0x111d0, 0x111d9}, {0x112f0, 0x112f9}, 
            {0x11450, 0x11459}, {0x114d0, 0x114d9}, {0x11650, 0x11659}, {0x116c0, 0x116c9}, 
            {0x116d0, 0x116e3}, {0x11730, 0x11739}, {0x118e0, 0x118e9}, {0x11950, 0x11959}, 
            {0x11bf0, 0x11bf9}, {0x11c50, 0x11c59}, {0x11d50, 0x11d59}, {0x11da0, 0x11da9}, 
            {0x11de0, 0x11de9}, {0x11f50, 0x11f59}, {0x16130, 0x16139}, {0x16a60, 0x16a69}, 
            {0x16ac0, 0x16ac9}, {0x16b50, 0x16b59}, {0x16d70, 0x16d79}, {0x16da0, 0x16da9}, 
            {0x1ccf0, 0x1ccf9}, {0x1d7ce, 0x1d7ff}, {0x1e140, 0x1e149}, {0x1e2f0, 0x1e2f9}, 
            {0x1e4f0, 0x1e4f9}, {0x1e5f1, 0x1e5fa}, {0x1e950, 0x1e959}, {0x1fbf0, 0x1fbf9}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass20()
{
    // Name = Uppercase_Letter, number of codePoints: 1886
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}}),
        std::initializer_list<char32_t>({0x0100, 0x0102, 0x0104, 0x0106, 0x0108, 0x010a, 0x010c, 0x010e, 
            0x0110, 0x0112, 0x0114, 0x0116, 0x0118, 0x011a, 0x011c, 0x011e, 
            0x0120, 0x0122, 0x0124, 0x0126, 0x0128, 0x012a, 0x012c, 0x012e, 
            0x0130, 0x0132, 0x0134, 0x0136, 0x0139, 0x013b, 0x013d, 0x013f, 
            0x0141, 0x0143, 0x0145, 0x0147, 0x014a, 0x014c, 0x014e, 0x0150, 
            0x0152, 0x0154, 0x0156, 0x0158, 0x015a, 0x015c, 0x015e, 0x0160, 
            0x0162, 0x0164, 0x0166, 0x0168, 0x016a, 0x016c, 0x016e, 0x0170, 
            0x0172, 0x0174, 0x0176, 0x017b, 0x017d, 0x0184, 0x01a2, 0x01a4, 
            0x01a9, 0x01ac, 0x01b5, 0x01bc, 0x01c4, 0x01c7, 0x01ca, 0x01cd, 
            0x01cf, 0x01d1, 0x01d3, 0x01d5, 0x01d7, 0x01d9, 0x01db, 0x01de, 
            0x01e0, 0x01e2, 0x01e4, 0x01e6, 0x01e8, 0x01ea, 0x01ec, 0x01ee, 
            0x01f1, 0x01f4, 0x01fa, 0x01fc, 0x01fe, 0x0200, 0x0202, 0x0204, 
            0x0206, 0x0208, 0x020a, 0x020c, 0x020e, 0x0210, 0x0212, 0x0214, 
            0x0216, 0x0218, 0x021a, 0x021c, 0x021e, 0x0220, 0x0222, 0x0224, 
            0x0226, 0x0228, 0x022a, 0x022c, 0x022e, 0x0230, 0x0232, 0x0241, 
            0x0248, 0x024a, 0x024c, 0x024e, 0x0370, 0x0372, 0x0376, 0x037f, 
            0x0386, 0x038c, 0x03cf, 0x03d8, 0x03da, 0x03dc, 0x03de, 0x03e0, 
            0x03e2, 0x03e4, 0x03e6, 0x03e8, 0x03ea, 0x03ec, 0x03ee, 0x03f4, 
            0x03f7, 0x0460, 0x0462, 0x0464, 0x0466, 0x0468, 0x046a, 0x046c, 
            0x046e, 0x0470, 0x0472, 0x0474, 0x0476, 0x0478, 0x047a, 0x047c, 
            0x047e, 0x0480, 0x048a, 0x048c, 0x048e, 0x0490, 0x0492, 0x0494, 
            0x0496, 0x0498, 0x049a, 0x049c, 0x049e, 0x04a0, 0x04a2, 0x04a4, 
            0x04a6, 0x04a8, 0x04aa, 0x04ac, 0x04ae, 0x04b0, 0x04b2, 0x04b4, 
            0x04b6, 0x04b8, 0x04ba, 0x04bc, 0x04be, 0x04c3, 0x04c5, 0x04c7, 
            0x04c9, 0x04cb, 0x04cd, 0x04d0, 0x04d2, 0x04d4, 0x04d6, 0x04d8, 
            0x04da, 0x04dc, 0x04de, 0x04e0, 0x04e2, 0x04e4, 0x04e6, 0x04e8, 
            0x04ea, 0x04ec, 0x04ee, 0x04f0, 0x04f2, 0x04f4, 0x04f6, 0x04f8, 
            0x04fa, 0x04fc, 0x04fe, 0x0500, 0x0502, 0x0504, 0x0506, 0x0508, 
            0x050a, 0x050c, 0x050e, 0x0510, 0x0512, 0x0514, 0x0516, 0x0518, 
            0x051a, 0x051c, 0x051e, 0x0520, 0x0522, 0x0524, 0x0526, 0x0528, 
            0x052a, 0x052c, 0x052e, 0x10c7, 0x10cd, 0x1c89, 0x1e00, 0x1e02, 
            0x1e04, 0x1e06, 0x1e08, 0x1e0a, 0x1e0c, 0x1e0e, 0x1e10, 0x1e12, 
            0x1e14, 0x1e16, 0x1e18, 0x1e1a, 0x1e1c, 0x1e1e, 0x1e20, 0x1e22, 
            0x1e24, 0x1e26, 0x1e28, 0x1e2a, 0x1e2c, 0x1e2e, 0x1e30, 0x1e32, 
            0x1e34, 0x1e36, 0x1e38, 0x1e3a, 0x1e3c, 0x1e3e, 0x1e40, 0x1e42, 
            0x1e44, 0x1e46, 0x1e48, 0x1e4a, 0x1e4c, 0x1e4e, 0x1e50, 0x1e52, 
            0x1e54, 0x1e56, 0x1e58, 0x1e5a, 0x1e5c, 0x1e5e, 0x1e60, 0x1e62, 
            0x1e64, 0x1e66, 0x1e68, 0x1e6a, 0x1e6c, 0x1e6e, 0x1e70, 0x1e72, 
            0x1e74, 0x1e76, 0x1e78, 0x1e7a, 0x1e7c, 0x1e7e, 0x1e80, 0x1e82, 
            0x1e84, 0x1e86, 0x1e88, 0x1e8a, 0x1e8c, 0x1e8e, 0x1e90, 0x1e92, 
            0x1e94, 0x1e9e, 0x1ea0, 0x1ea2, 0x1ea4, 0x1ea6, 0x1ea8, 0x1eaa, 
            0x1eac, 0x1eae, 0x1eb0, 0x1eb2, 0x1eb4, 0x1eb6, 0x1eb8, 0x1eba, 
            0x1ebc, 0x1ebe, 0x1ec0, 0x1ec2, 0x1ec4, 0x1ec6, 0x1ec8, 0x1eca, 
            0x1ecc, 0x1ece, 0x1ed0, 0x1ed2, 0x1ed4, 0x1ed6, 0x1ed8, 0x1eda, 
            0x1edc, 0x1ede, 0x1ee0, 0x1ee2, 0x1ee4, 0x1ee6, 0x1ee8, 0x1eea, 
            0x1eec, 0x1eee, 0x1ef0, 0x1ef2, 0x1ef4, 0x1ef6, 0x1ef8, 0x1efa, 
            0x1efc, 0x1efe, 0x1f59, 0x1f5b, 0x1f5d, 0x1f5f, 0x2102, 0x2107, 
            0x2115, 0x2124, 0x2126, 0x2128, 0x2145, 0x2183, 0x2c60, 0x2c67, 
            0x2c69, 0x2c6b, 0x2c72, 0x2c75, 0x2c82, 0x2c84, 0x2c86, 0x2c88, 
            0x2c8a, 0x2c8c, 0x2c8e, 0x2c90, 0x2c92, 0x2c94, 0x2c96, 0x2c98, 
            0x2c9a, 0x2c9c, 0x2c9e, 0x2ca0, 0x2ca2, 0x2ca4, 0x2ca6, 0x2ca8, 
            0x2caa, 0x2cac, 0x2cae, 0x2cb0, 0x2cb2, 0x2cb4, 0x2cb6, 0x2cb8, 
            0x2cba, 0x2cbc, 0x2cbe, 0x2cc0, 0x2cc2, 0x2cc4, 0x2cc6, 0x2cc8, 
            0x2cca, 0x2ccc, 0x2cce, 0x2cd0, 0x2cd2, 0x2cd4, 0x2cd6, 0x2cd8, 
            0x2cda, 0x2cdc, 0x2cde, 0x2ce0, 0x2ce2, 0x2ceb, 0x2ced, 0x2cf2, 
            0xa640, 0xa642, 0xa644, 0xa646, 0xa648, 0xa64a, 0xa64c, 0xa64e, 
            0xa650, 0xa652, 0xa654, 0xa656, 0xa658, 0xa65a, 0xa65c, 0xa65e, 
            0xa660, 0xa662, 0xa664, 0xa666, 0xa668, 0xa66a, 0xa66c, 0xa680, 
            0xa682, 0xa684, 0xa686, 0xa688, 0xa68a, 0xa68c, 0xa68e, 0xa690, 
            0xa692, 0xa694, 0xa696, 0xa698, 0xa69a, 0xa722, 0xa724, 0xa726, 
            0xa728, 0xa72a, 0xa72c, 0xa72e, 0xa732, 0xa734, 0xa736, 0xa738, 
            0xa73a, 0xa73c, 0xa73e, 0xa740, 0xa742, 0xa744, 0xa746, 0xa748, 
            0xa74a, 0xa74c, 0xa74e, 0xa750, 0xa752, 0xa754, 0xa756, 0xa758, 
            0xa75a, 0xa75c, 0xa75e, 0xa760, 0xa762, 0xa764, 0xa766, 0xa768, 
            0xa76a, 0xa76c, 0xa76e, 0xa779, 0xa77b, 0xa780, 0xa782, 0xa784, 
            0xa786, 0xa78b, 0xa78d, 0xa790, 0xa792, 0xa796, 0xa798, 0xa79a, 
            0xa79c, 0xa79e, 0xa7a0, 0xa7a2, 0xa7a4, 0xa7a6, 0xa7a8, 0xa7b6, 
            0xa7b8, 0xa7ba, 0xa7bc, 0xa7be, 0xa7c0, 0xa7c2, 0xa7c9, 0xa7ce, 
            0xa7d0, 0xa7d2, 0xa7d4, 0xa7d6, 0xa7d8, 0xa7da, 0xa7dc, 0xa7f5, 
            0x1d49c, 0x1d4a2, 0x1d546, 0x1d7ca}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00de}, {0x0178, 0x0179}, {0x0181, 0x0182}, 
            {0x0186, 0x0187}, {0x0189, 0x018b}, {0x018e, 0x0191}, {0x0193, 0x0194}, 
            {0x0196, 0x0198}, {0x019c, 0x019d}, {0x019f, 0x01a0}, {0x01a6, 0x01a7}, 
            {0x01ae, 0x01af}, {0x01b1, 0x01b3}, {0x01b7, 0x01b8}, {0x01f6, 0x01f8}, 
            {0x023a, 0x023b}, {0x023d, 0x023e}, {0x0243, 0x0246}, {0x0388, 0x038a}, 
            {0x038e, 0x038f}, {0x0391, 0x03a1}, {0x03a3, 0x03ab}, {0x03d2, 0x03d4}, 
            {0x03f9, 0x03fa}, {0x03fd, 0x042f}, {0x04c0, 0x04c1}, {0x0531, 0x0556}, 
            {0x10a0, 0x10c5}, {0x13a0, 0x13f5}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, 
            {0x1f08, 0x1f0f}, {0x1f18, 0x1f1d}, {0x1f28, 0x1f2f}, {0x1f38, 0x1f3f}, 
            {0x1f48, 0x1f4d}, {0x1f68, 0x1f6f}, {0x1fb8, 0x1fbb}, {0x1fc8, 0x1fcb}, 
            {0x1fd8, 0x1fdb}, {0x1fe8, 0x1fec}, {0x1ff8, 0x1ffb}, {0x210b, 0x210d}, 
            {0x2110, 0x2112}, {0x2119, 0x211d}, {0x212a, 0x212d}, {0x2130, 0x2133}, 
            {0x213e, 0x213f}, {0x2c00, 0x2c2f}, {0x2c62, 0x2c64}, {0x2c6d, 0x2c70}, 
            {0x2c7e, 0x2c80}, {0xa77d, 0xa77e}, {0xa7aa, 0xa7ae}, {0xa7b0, 0xa7b4}, 
            {0xa7c4, 0xa7c7}, {0xa7cb, 0xa7cc}, {0xff21, 0xff3a}, {0x10400, 0x10427}, 
            {0x104b0, 0x104d3}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, 
            {0x10594, 0x10595}, {0x10c80, 0x10cb2}, {0x10d50, 0x10d65}, {0x118a0, 0x118bf}, 
            {0x16e40, 0x16e5f}, {0x16ea0, 0x16eb8}, {0x1d400, 0x1d419}, {0x1d434, 0x1d44d}, 
            {0x1d468, 0x1d481}, {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, 
            {0x1d4ae, 0x1d4b5}, {0x1d4d0, 0x1d4e9}, {0x1d504, 0x1d505}, {0x1d507, 0x1d50a}, 
            {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d538, 0x1d539}, {0x1d53b, 0x1d53e}, 
            {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, {0x1d56c, 0x1d585}, {0x1d5a0, 0x1d5b9}, 
            {0x1d5d4, 0x1d5ed}, {0x1d608, 0x1d621}, {0x1d63c, 0x1d655}, {0x1d670, 0x1d689}, 
            {0x1d6a8, 0x1d6c0}, {0x1d6e2, 0x1d6fa}, {0x1d71c, 0x1d734}, {0x1d756, 0x1d76e}, 
            {0x1d790, 0x1d7a8}, {0x1e900, 0x1e921}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass21()
{
    // Name = Modifier_Symbol, number of codePoints: 125
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x5e, 0x60}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00a8, 0x00af, 0x00b4, 0x00b8, 0x02ed, 0x0375, 0x0888, 0x1fbd, 
            0xab5b, 0xff3e, 0xff40, 0xffe3}),
        std::initializer_list<CharacterRange>({{0x02c2, 0x02c5}, {0x02d2, 0x02df}, {0x02e5, 0x02eb}, {0x02ef, 0x02ff}, 
            {0x0384, 0x0385}, {0x1fbf, 0x1fc1}, {0x1fcd, 0x1fcf}, {0x1fdd, 0x1fdf}, 
            {0x1fed, 0x1fef}, {0x1ffd, 0x1ffe}, {0x309b, 0x309c}, {0xa700, 0xa716}, 
            {0xa720, 0xa721}, {0xa789, 0xa78a}, {0xab6a, 0xab6b}, {0xfbb2, 0xfbc2}, 
            {0x1f3fb, 0x1f3ff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass22()
{
    // Name = Connector_Punctuation, number of codePoints: 10
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x5f}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x2054, 0xff3f}),
        std::initializer_list<CharacterRange>({{0x203f, 0x2040}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass23()
{
    // Name = Lowercase_Letter, number of codePoints: 2283
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x61, 0x7a}}),
        std::initializer_list<char32_t>({0x00b5, 0x0101, 0x0103, 0x0105, 0x0107, 0x0109, 0x010b, 0x010d, 
            0x010f, 0x0111, 0x0113, 0x0115, 0x0117, 0x0119, 0x011b, 0x011d, 
            0x011f, 0x0121, 0x0123, 0x0125, 0x0127, 0x0129, 0x012b, 0x012d, 
            0x012f, 0x0131, 0x0133, 0x0135, 0x013a, 0x013c, 0x013e, 0x0140, 
            0x0142, 0x0144, 0x0146, 0x014b, 0x014d, 0x014f, 0x0151, 0x0153, 
            0x0155, 0x0157, 0x0159, 0x015b, 0x015d, 0x015f, 0x0161, 0x0163, 
            0x0165, 0x0167, 0x0169, 0x016b, 0x016d, 0x016f, 0x0171, 0x0173, 
            0x0175, 0x0177, 0x017a, 0x017c, 0x0183, 0x0185, 0x0188, 0x0192, 
            0x0195, 0x019e, 0x01a1, 0x01a3, 0x01a5, 0x01a8, 0x01ad, 0x01b0, 
            0x01b4, 0x01b6, 0x01c6, 0x01c9, 0x01cc, 0x01ce, 0x01d0, 0x01d2, 
            0x01d4, 0x01d6, 0x01d8, 0x01da, 0x01df, 0x01e1, 0x01e3, 0x01e5, 
            0x01e7, 0x01e9, 0x01eb, 0x01ed, 0x01f3, 0x01f5, 0x01f9, 0x01fb, 
            0x01fd, 0x01ff, 0x0201, 0x0203, 0x0205, 0x0207, 0x0209, 0x020b, 
            0x020d, 0x020f, 0x0211, 0x0213, 0x0215, 0x0217, 0x0219, 0x021b, 
            0x021d, 0x021f, 0x0221, 0x0223, 0x0225, 0x0227, 0x0229, 0x022b, 
            0x022d, 0x022f, 0x0231, 0x023c, 0x0242, 0x0247, 0x0249, 0x024b, 
            0x024d, 0x0371, 0x0373, 0x0377, 0x0390, 0x03d9, 0x03db, 0x03dd, 
            0x03df, 0x03e1, 0x03e3, 0x03e5, 0x03e7, 0x03e9, 0x03eb, 0x03ed, 
            0x03f5, 0x03f8, 0x0461, 0x0463, 0x0465, 0x0467, 0x0469, 0x046b, 
            0x046d, 0x046f, 0x0471, 0x0473, 0x0475, 0x0477, 0x0479, 0x047b, 
            0x047d, 0x047f, 0x0481, 0x048b, 0x048d, 0x048f, 0x0491, 0x0493, 
            0x0495, 0x0497, 0x0499, 0x049b, 0x049d, 0x049f, 0x04a1, 0x04a3, 
            0x04a5, 0x04a7, 0x04a9, 0x04ab, 0x04ad, 0x04af, 0x04b1, 0x04b3, 
            0x04b5, 0x04b7, 0x04b9, 0x04bb, 0x04bd, 0x04bf, 0x04c2, 0x04c4, 
            0x04c6, 0x04c8, 0x04ca, 0x04cc, 0x04d1, 0x04d3, 0x04d5, 0x04d7, 
            0x04d9, 0x04db, 0x04dd, 0x04df, 0x04e1, 0x04e3, 0x04e5, 0x04e7, 
            0x04e9, 0x04eb, 0x04ed, 0x04ef, 0x04f1, 0x04f3, 0x04f5, 0x04f7, 
            0x04f9, 0x04fb, 0x04fd, 0x04ff, 0x0501, 0x0503, 0x0505, 0x0507, 
            0x0509, 0x050b, 0x050d, 0x050f, 0x0511, 0x0513, 0x0515, 0x0517, 
            0x0519, 0x051b, 0x051d, 0x051f, 0x0521, 0x0523, 0x0525, 0x0527, 
            0x0529, 0x052b, 0x052d, 0x052f, 0x1c8a, 0x1e01, 0x1e03, 0x1e05, 
            0x1e07, 0x1e09, 0x1e0b, 0x1e0d, 0x1e0f, 0x1e11, 0x1e13, 0x1e15, 
            0x1e17, 0x1e19, 0x1e1b, 0x1e1d, 0x1e1f, 0x1e21, 0x1e23, 0x1e25, 
            0x1e27, 0x1e29, 0x1e2b, 0x1e2d, 0x1e2f, 0x1e31, 0x1e33, 0x1e35, 
            0x1e37, 0x1e39, 0x1e3b, 0x1e3d, 0x1e3f, 0x1e41, 0x1e43, 0x1e45, 
            0x1e47, 0x1e49, 0x1e4b, 0x1e4d, 0x1e4f, 0x1e51, 0x1e53, 0x1e55, 
            0x1e57, 0x1e59, 0x1e5b, 0x1e5d, 0x1e5f, 0x1e61, 0x1e63, 0x1e65, 
            0x1e67, 0x1e69, 0x1e6b, 0x1e6d, 0x1e6f, 0x1e71, 0x1e73, 0x1e75, 
            0x1e77, 0x1e79, 0x1e7b, 0x1e7d, 0x1e7f, 0x1e81, 0x1e83, 0x1e85, 
            0x1e87, 0x1e89, 0x1e8b, 0x1e8d, 0x1e8f, 0x1e91, 0x1e93, 0x1e9f, 
            0x1ea1, 0x1ea3, 0x1ea5, 0x1ea7, 0x1ea9, 0x1eab, 0x1ead, 0x1eaf, 
            0x1eb1, 0x1eb3, 0x1eb5, 0x1eb7, 0x1eb9, 0x1ebb, 0x1ebd, 0x1ebf, 
            0x1ec1, 0x1ec3, 0x1ec5, 0x1ec7, 0x1ec9, 0x1ecb, 0x1ecd, 0x1ecf, 
            0x1ed1, 0x1ed3, 0x1ed5, 0x1ed7, 0x1ed9, 0x1edb, 0x1edd, 0x1edf, 
            0x1ee1, 0x1ee3, 0x1ee5, 0x1ee7, 0x1ee9, 0x1eeb, 0x1eed, 0x1eef, 
            0x1ef1, 0x1ef3, 0x1ef5, 0x1ef7, 0x1ef9, 0x1efb, 0x1efd, 0x1fbe, 
            0x210a, 0x2113, 0x212f, 0x2134, 0x2139, 0x214e, 0x2184, 0x2c61, 
            0x2c68, 0x2c6a, 0x2c6c, 0x2c71, 0x2c81, 0x2c83, 0x2c85, 0x2c87, 
            0x2c89, 0x2c8b, 0x2c8d, 0x2c8f, 0x2c91, 0x2c93, 0x2c95, 0x2c97, 
            0x2c99, 0x2c9b, 0x2c9d, 0x2c9f, 0x2ca1, 0x2ca3, 0x2ca5, 0x2ca7, 
            0x2ca9, 0x2cab, 0x2cad, 0x2caf, 0x2cb1, 0x2cb3, 0x2cb5, 0x2cb7, 
            0x2cb9, 0x2cbb, 0x2cbd, 0x2cbf, 0x2cc1, 0x2cc3, 0x2cc5, 0x2cc7, 
            0x2cc9, 0x2ccb, 0x2ccd, 0x2ccf, 0x2cd1, 0x2cd3, 0x2cd5, 0x2cd7, 
            0x2cd9, 0x2cdb, 0x2cdd, 0x2cdf, 0x2ce1, 0x2cec, 0x2cee, 0x2cf3, 
            0x2d27, 0x2d2d, 0xa641, 0xa643, 0xa645, 0xa647, 0xa649, 0xa64b, 
            0xa64d, 0xa64f, 0xa651, 0xa653, 0xa655, 0xa657, 0xa659, 0xa65b, 
            0xa65d, 0xa65f, 0xa661, 0xa663, 0xa665, 0xa667, 0xa669, 0xa66b, 
            0xa66d, 0xa681, 0xa683, 0xa685, 0xa687, 0xa689, 0xa68b, 0xa68d, 
            0xa68f, 0xa691, 0xa693, 0xa695, 0xa697, 0xa699, 0xa69b, 0xa723, 
            0xa725, 0xa727, 0xa729, 0xa72b, 0xa72d, 0xa733, 0xa735, 0xa737, 
            0xa739, 0xa73b, 0xa73d, 0xa73f, 0xa741, 0xa743, 0xa745, 0xa747, 
            0xa749, 0xa74b, 0xa74d, 0xa74f, 0xa751, 0xa753, 0xa755, 0xa757, 
            0xa759, 0xa75b, 0xa75d, 0xa75f, 0xa761, 0xa763, 0xa765, 0xa767, 
            0xa769, 0xa76b, 0xa76d, 0xa76f, 0xa77a, 0xa77c, 0xa77f, 0xa781, 
            0xa783, 0xa785, 0xa787, 0xa78c, 0xa78e, 0xa791, 0xa797, 0xa799, 
            0xa79b, 0xa79d, 0xa79f, 0xa7a1, 0xa7a3, 0xa7a5, 0xa7a7, 0xa7a9, 
            0xa7af, 0xa7b5, 0xa7b7, 0xa7b9, 0xa7bb, 0xa7bd, 0xa7bf, 0xa7c1, 
            0xa7c3, 0xa7c8, 0xa7ca, 0xa7cd, 0xa7cf, 0xa7d1, 0xa7d3, 0xa7d5, 
            0xa7d7, 0xa7d9, 0xa7db, 0xa7f6, 0xa7fa, 0x1d4bb, 0x1d7cb}),
        std::initializer_list<CharacterRange>({{0x00df, 0x00f6}, {0x00f8, 0x00ff}, {0x0137, 0x0138}, {0x0148, 0x0149}, 
            {0x017e, 0x0180}, {0x018c, 0x018d}, {0x0199, 0x019b}, {0x01aa, 0x01ab}, 
            {0x01b9, 0x01ba}, {0x01bd, 0x01bf}, {0x01dc, 0x01dd}, {0x01ef, 0x01f0}, 
            {0x0233, 0x0239}, {0x023f, 0x0240}, {0x024f, 0x0293}, {0x0296, 0x02af}, 
            {0x037b, 0x037d}, {0x03ac, 0x03ce}, {0x03d0, 0x03d1}, {0x03d5, 0x03d7}, 
            {0x03ef, 0x03f3}, {0x03fb, 0x03fc}, {0x0430, 0x045f}, {0x04ce, 0x04cf}, 
            {0x0560, 0x0588}, {0x10d0, 0x10fa}, {0x10fd, 0x10ff}, {0x13f8, 0x13fd}, 
            {0x1c80, 0x1c88}, {0x1d00, 0x1d2b}, {0x1d6b, 0x1d77}, {0x1d79, 0x1d9a}, 
            {0x1e95, 0x1e9d}, {0x1eff, 0x1f07}, {0x1f10, 0x1f15}, {0x1f20, 0x1f27}, 
            {0x1f30, 0x1f37}, {0x1f40, 0x1f45}, {0x1f50, 0x1f57}, {0x1f60, 0x1f67}, 
            {0x1f70, 0x1f7d}, {0x1f80, 0x1f87}, {0x1f90, 0x1f97}, {0x1fa0, 0x1fa7}, 
            {0x1fb0, 0x1fb4}, {0x1fb6, 0x1fb7}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fc7}, 
            {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fd7}, {0x1fe0, 0x1fe7}, {0x1ff2, 0x1ff4}, 
            {0x1ff6, 0x1ff7}, {0x210e, 0x210f}, {0x213c, 0x213d}, {0x2146, 0x2149}, 
            {0x2c30, 0x2c5f}, {0x2c65, 0x2c66}, {0x2c73, 0x2c74}, {0x2c76, 0x2c7b}, 
            {0x2ce3, 0x2ce4}, {0x2d00, 0x2d25}, {0xa72f, 0xa731}, {0xa771, 0xa778}, 
            {0xa793, 0xa795}, {0xab30, 0xab5a}, {0xab60, 0xab68}, {0xab70, 0xabbf}, 
            {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xff41, 0xff5a}, {0x10428, 0x1044f}, 
            {0x104d8, 0x104fb}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, 
            {0x105bb, 0x105bc}, {0x10cc0, 0x10cf2}, {0x10d70, 0x10d85}, {0x118c0, 0x118df}, 
            {0x16e60, 0x16e7f}, {0x16ebb, 0x16ed3}, {0x1d41a, 0x1d433}, {0x1d44e, 0x1d454}, 
            {0x1d456, 0x1d467}, {0x1d482, 0x1d49b}, {0x1d4b6, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, 
            {0x1d4c5, 0x1d4cf}, {0x1d4ea, 0x1d503}, {0x1d51e, 0x1d537}, {0x1d552, 0x1d56b}, 
            {0x1d586, 0x1d59f}, {0x1d5ba, 0x1d5d3}, {0x1d5ee, 0x1d607}, {0x1d622, 0x1d63b}, 
            {0x1d656, 0x1d66f}, {0x1d68a, 0x1d6a5}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6e1}, 
            {0x1d6fc, 0x1d714}, {0x1d716, 0x1d71b}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d755}, 
            {0x1d770, 0x1d788}, {0x1d78a, 0x1d78f}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7c9}, 
            {0x1df00, 0x1df09}, {0x1df0b, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e922, 0x1e943}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass24()
{
    // Name = Other_Symbol, number of codePoints: 7469
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00a6, 0x00a9, 0x00ae, 0x00b0, 0x0482, 0x06de, 0x06e9, 0x07f6, 
            0x09fa, 0x0b70, 0x0bfa, 0x0c7f, 0x0d4f, 0x0d79, 0x0f13, 0x0f34, 
            0x0f36, 0x0f38, 0x166d, 0x1940, 0x2114, 0x2125, 0x2127, 0x2129, 
            0x212e, 0x214a, 0x214f, 0x21d3, 0x3004, 0x3020, 0x31ef, 0x3250, 
            0xa839, 0xffe4, 0xffe8, 0x101a0, 0x10ac8, 0x1173f, 0x16b45, 0x1bc9c, 
            0x1d245, 0x1e14f, 0x1ecac, 0x1ed2e, 0x1f7f0, 0x1fac8, 0x1fbfa}),
        std::initializer_list<CharacterRange>({{0x058d, 0x058e}, {0x060e, 0x060f}, {0x06fd, 0x06fe}, {0x0bf3, 0x0bf8}, 
            {0x0f01, 0x0f03}, {0x0f15, 0x0f17}, {0x0f1a, 0x0f1f}, {0x0fbe, 0x0fc5}, 
            {0x0fc7, 0x0fcc}, {0x0fce, 0x0fcf}, {0x0fd5, 0x0fd8}, {0x109e, 0x109f}, 
            {0x1390, 0x1399}, {0x19de, 0x19ff}, {0x1b61, 0x1b6a}, {0x1b74, 0x1b7c}, 
            {0x2100, 0x2101}, {0x2103, 0x2106}, {0x2108, 0x2109}, {0x2116, 0x2117}, 
            {0x211e, 0x2123}, {0x213a, 0x213b}, {0x214c, 0x214d}, {0x218a, 0x218b}, 
            {0x2195, 0x2199}, {0x219c, 0x219f}, {0x21a1, 0x21a2}, {0x21a4, 0x21a5}, 
            {0x21a7, 0x21ad}, {0x21af, 0x21cd}, {0x21d0, 0x21d1}, {0x21d5, 0x21f3}, 
            {0x2300, 0x2307}, {0x230c, 0x231f}, {0x2322, 0x2328}, {0x232b, 0x237b}, 
            {0x237d, 0x239a}, {0x23b4, 0x23db}, {0x23e2, 0x2429}, {0x2440, 0x244a}, 
            {0x249c, 0x24e9}, {0x2500, 0x25b6}, {0x25b8, 0x25c0}, {0x25c2, 0x25f7}, 
            {0x2600, 0x266e}, {0x2670, 0x2767}, {0x2794, 0x27bf}, {0x2800, 0x28ff}, 
            {0x2b00, 0x2b2f}, {0x2b45, 0x2b46}, {0x2b4d, 0x2b73}, {0x2b76, 0x2bff}, 
            {0x2ce5, 0x2cea}, {0x2e50, 0x2e51}, {0x2e80, 0x2e99}, {0x2e9b, 0x2ef3}, 
            {0x2f00, 0x2fd5}, {0x2ff0, 0x2fff}, {0x3012, 0x3013}, {0x3036, 0x3037}, 
            {0x303e, 0x303f}, {0x3190, 0x3191}, {0x3196, 0x319f}, {0x31c0, 0x31e5}, 
            {0x3200, 0x321e}, {0x322a, 0x3247}, {0x3260, 0x327f}, {0x328a, 0x32b0}, 
            {0x32c0, 0x33ff}, {0x4dc0, 0x4dff}, {0xa490, 0xa4c6}, {0xa828, 0xa82b}, 
            {0xa836, 0xa837}, {0xaa77, 0xaa79}, {0xfbc3, 0xfbd2}, {0xfd40, 0xfd4f}, 
            {0xfd90, 0xfd91}, {0xfdc8, 0xfdcf}, {0xfdfd, 0xfdff}, {0xffed, 0xffee}, 
            {0xfffc, 0xfffd}, {0x10137, 0x1013f}, {0x10179, 0x10189}, {0x1018c, 0x1018e}, 
            {0x10190, 0x1019c}, {0x101d0, 0x101fc}, {0x10877, 0x10878}, {0x10ed1, 0x10ed8}, 
            {0x11fd5, 0x11fdc}, {0x11fe1, 0x11ff1}, {0x16b3c, 0x16b3f}, {0x1cc00, 0x1ccef}, 
            {0x1ccfa, 0x1ccfc}, {0x1cd00, 0x1ceb3}, {0x1ceba, 0x1ced0}, {0x1cee0, 0x1ceef}, 
            {0x1cf50, 0x1cfc3}, {0x1d000, 0x1d0f5}, {0x1d100, 0x1d126}, {0x1d129, 0x1d164}, 
            {0x1d16a, 0x1d16c}, {0x1d183, 0x1d184}, {0x1d18c, 0x1d1a9}, {0x1d1ae, 0x1d1ea}, 
            {0x1d200, 0x1d241}, {0x1d300, 0x1d356}, {0x1d800, 0x1d9ff}, {0x1da37, 0x1da3a}, 
            {0x1da6d, 0x1da74}, {0x1da76, 0x1da83}, {0x1da85, 0x1da86}, {0x1f000, 0x1f02b}, 
            {0x1f030, 0x1f093}, {0x1f0a0, 0x1f0ae}, {0x1f0b1, 0x1f0bf}, {0x1f0c1, 0x1f0cf}, 
            {0x1f0d1, 0x1f0f5}, {0x1f10d, 0x1f1ad}, {0x1f1e6, 0x1f202}, {0x1f210, 0x1f23b}, 
            {0x1f240, 0x1f248}, {0x1f250, 0x1f251}, {0x1f260, 0x1f265}, {0x1f300, 0x1f3fa}, 
            {0x1f400, 0x1f6d8}, {0x1f6dc, 0x1f6ec}, {0x1f6f0, 0x1f6fc}, {0x1f700, 0x1f7d9}, 
            {0x1f7e0, 0x1f7eb}, {0x1f800, 0x1f80b}, {0x1f810, 0x1f847}, {0x1f850, 0x1f859}, 
            {0x1f860, 0x1f887}, {0x1f890, 0x1f8ad}, {0x1f8b0, 0x1f8bb}, {0x1f8c0, 0x1f8c1}, 
            {0x1f900, 0x1fa57}, {0x1fa60, 0x1fa6d}, {0x1fa70, 0x1fa7c}, {0x1fa80, 0x1fa8a}, 
            {0x1fa8e, 0x1fac6}, {0x1facd, 0x1fadd}, {0x1fadf, 0x1faea}, {0x1faef, 0x1faf8}, 
            {0x1fb00, 0x1fb92}, {0x1fb94, 0x1fbef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass25()
{
    // Name = Other_Letter, number of codePoints: 141091
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00aa, 0x00ba, 0x01bb, 0x06d5, 0x06ff, 0x0710, 0x07b1, 0x093d, 
            0x0950, 0x09b2, 0x09bd, 0x09ce, 0x09fc, 0x09ff, 0x0a5e, 0x0abd, 
            0x0ad0, 0x0af9, 0x0b3d, 0x0b71, 0x0b83, 0x0b9c, 0x0bd0, 0x0c3d, 
            0x0c80, 0x0cbd, 0x0d3d, 0x0d4e, 0x0dbd, 0x0e84, 0x0ea5, 0x0ebd, 
            0x0f00, 0x103f, 0x1061, 0x108e, 0x1258, 0x12c0, 0x17dc, 0x18aa, 
            0x1cfa, 0x3006, 0x303c, 0x309f, 0x30ff, 0xa66e, 0xa78f, 0xa7f7, 
            0xa8fb, 0xaa7a, 0xaab1, 0xaac0, 0xaac2, 0xaaf2, 0xfb1d, 0xfb3e, 
            0x10808, 0x1083c, 0x10a00, 0x10d4f, 0x10f27, 0x11075, 0x11144, 0x11147, 
            0x11176, 0x111da, 0x111dc, 0x11288, 0x1133d, 0x11350, 0x1138b, 0x1138e, 
            0x113b7, 0x113d1, 0x113d3, 0x114c7, 0x11644, 0x116b8, 0x11909, 0x1193f, 
            0x11941, 0x119e1, 0x119e3, 0x11a00, 0x11a3a, 0x11a50, 0x11a9d, 0x11c40, 
            0x11d46, 0x11d98, 0x11f02, 0x11fb0, 0x16f50, 0x1b132, 0x1b155, 0x1df0a, 
            0x1e14e, 0x1e5f0, 0x1e6fe, 0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 0x1ee42, 
            0x1ee47, 0x1ee49, 0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 0x1ee5d, 
            0x1ee5f, 0x1ee64, 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x01c0, 0x01c3}, {0x0294, 0x0295}, {0x05d0, 0x05ea}, {0x05ef, 0x05f2}, 
            {0x0620, 0x063f}, {0x0641, 0x064a}, {0x066e, 0x066f}, {0x0671, 0x06d3}, 
            {0x06ee, 0x06ef}, {0x06fa, 0x06fc}, {0x0712, 0x072f}, {0x074d, 0x07a5}, 
            {0x07ca, 0x07ea}, {0x0800, 0x0815}, {0x0840, 0x0858}, {0x0860, 0x086a}, 
            {0x0870, 0x0887}, {0x0889, 0x088f}, {0x08a0, 0x08c8}, {0x0904, 0x0939}, 
            {0x0958, 0x0961}, {0x0972, 0x0980}, {0x0985, 0x098c}, {0x098f, 0x0990}, 
            {0x0993, 0x09a8}, {0x09aa, 0x09b0}, {0x09b6, 0x09b9}, {0x09dc, 0x09dd}, 
            {0x09df, 0x09e1}, {0x09f0, 0x09f1}, {0x0a05, 0x0a0a}, {0x0a0f, 0x0a10}, 
            {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, {0x0a35, 0x0a36}, 
            {0x0a38, 0x0a39}, {0x0a59, 0x0a5c}, {0x0a72, 0x0a74}, {0x0a85, 0x0a8d}, 
            {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0}, {0x0ab2, 0x0ab3}, 
            {0x0ab5, 0x0ab9}, {0x0ae0, 0x0ae1}, {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10}, 
            {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, 
            {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b61}, {0x0b85, 0x0b8a}, {0x0b8e, 0x0b90}, 
            {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, {0x0b9e, 0x0b9f}, {0x0ba3, 0x0ba4}, 
            {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, {0x0c05, 0x0c0c}, {0x0c0e, 0x0c10}, 
            {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, {0x0c58, 0x0c5a}, {0x0c5c, 0x0c5d}, 
            {0x0c60, 0x0c61}, {0x0c85, 0x0c8c}, {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, 
            {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0cdc, 0x0cde}, {0x0ce0, 0x0ce1}, 
            {0x0cf1, 0x0cf2}, {0x0d04, 0x0d0c}, {0x0d0e, 0x0d10}, {0x0d12, 0x0d3a}, 
            {0x0d54, 0x0d56}, {0x0d5f, 0x0d61}, {0x0d7a, 0x0d7f}, {0x0d85, 0x0d96}, 
            {0x0d9a, 0x0db1}, {0x0db3, 0x0dbb}, {0x0dc0, 0x0dc6}, {0x0e01, 0x0e30}, 
            {0x0e32, 0x0e33}, {0x0e40, 0x0e45}, {0x0e81, 0x0e82}, {0x0e86, 0x0e8a}, 
            {0x0e8c, 0x0ea3}, {0x0ea7, 0x0eb0}, {0x0eb2, 0x0eb3}, {0x0ec0, 0x0ec4}, 
            {0x0edc, 0x0edf}, {0x0f40, 0x0f47}, {0x0f49, 0x0f6c}, {0x0f88, 0x0f8c}, 
            {0x1000, 0x102a}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1065, 0x1066}, 
            {0x106e, 0x1070}, {0x1075, 0x1081}, {0x1100, 0x1248}, {0x124a, 0x124d}, 
            {0x1250, 0x1256}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, 
            {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c2, 0x12c5}, 
            {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, 
            {0x1380, 0x138f}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, 
            {0x16a0, 0x16ea}, {0x16f1, 0x16f8}, {0x1700, 0x1711}, {0x171f, 0x1731}, 
            {0x1740, 0x1751}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, 
            {0x1820, 0x1842}, {0x1844, 0x1878}, {0x1880, 0x1884}, {0x1887, 0x18a8}, 
            {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, 
            {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, {0x1a20, 0x1a54}, 
            {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, 
            {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f}, {0x1c5a, 0x1c77}, 
            {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, {0x2135, 0x2138}, 
            {0x2d30, 0x2d67}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, 
            {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, 
            {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3041, 0x3096}, {0x30a1, 0x30fa}, 
            {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, 
            {0x3400, 0x4dbf}, {0x4e00, 0xa014}, {0xa016, 0xa48c}, {0xa4d0, 0xa4f7}, 
            {0xa500, 0xa60b}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa6a0, 0xa6e5}, 
            {0xa7fb, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, 
            {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fd, 0xa8fe}, 
            {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, 
            {0xa9e0, 0xa9e4}, {0xa9e7, 0xa9ef}, {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, 
            {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa6f}, {0xaa71, 0xaa76}, 
            {0xaa7e, 0xaaaf}, {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaadb, 0xaadc}, 
            {0xaae0, 0xaaea}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, 
            {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xabc0, 0xabe2}, {0xac00, 0xd7a3}, 
            {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, 
            {0xfb1f, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb40, 0xfb41}, 
            {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfd3d}, {0xfd50, 0xfd8f}, 
            {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfb}, {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, 
            {0xff66, 0xff6f}, {0xff71, 0xff9d}, {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, 
            {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, 
            {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, 
            {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, 
            {0x10300, 0x1031f}, {0x1032d, 0x10340}, {0x10342, 0x10349}, {0x10350, 0x10375}, 
            {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x10450, 0x1049d}, 
            {0x10500, 0x10527}, {0x10530, 0x10563}, {0x105c0, 0x105f3}, {0x10600, 0x10736}, 
            {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10800, 0x10805}, {0x1080a, 0x10835}, 
            {0x10837, 0x10838}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, 
            {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, 
            {0x10940, 0x10959}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a10, 0x10a13}, 
            {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, 
            {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, 
            {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, {0x10d00, 0x10d23}, 
            {0x10d4a, 0x10d4d}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1}, {0x10ec2, 0x10ec4}, 
            {0x10ec6, 0x10ec7}, {0x10f00, 0x10f1c}, {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, 
            {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072}, 
            {0x11083, 0x110af}, {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11150, 0x11172}, 
            {0x11183, 0x111b2}, {0x111c1, 0x111c4}, {0x11200, 0x11211}, {0x11213, 0x1122b}, 
            {0x1123f, 0x11240}, {0x11280, 0x11286}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, 
            {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, 
            {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, 
            {0x1135d, 0x11361}, {0x11380, 0x11389}, {0x11390, 0x113b5}, {0x11400, 0x11434}, 
            {0x11447, 0x1144a}, {0x1145f, 0x11461}, {0x11480, 0x114af}, {0x114c4, 0x114c5}, 
            {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11680, 0x116aa}, 
            {0x11700, 0x1171a}, {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118ff, 0x11906}, 
            {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x1192f}, {0x119a0, 0x119a7}, 
            {0x119aa, 0x119d0}, {0x11a0b, 0x11a32}, {0x11a5c, 0x11a89}, {0x11ab0, 0x11af8}, 
            {0x11bc0, 0x11be0}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e}, {0x11c72, 0x11c8f}, 
            {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d60, 0x11d65}, 
            {0x11d67, 0x11d68}, {0x11d6a, 0x11d89}, {0x11db0, 0x11dd8}, {0x11dda, 0x11ddb}, 
            {0x11ee0, 0x11ef2}, {0x11f04, 0x11f10}, {0x11f12, 0x11f33}, {0x12000, 0x12399}, 
            {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13441, 0x13446}, 
            {0x13460, 0x143fa}, {0x14400, 0x14646}, {0x16100, 0x1611d}, {0x16800, 0x16a38}, 
            {0x16a40, 0x16a5e}, {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, 
            {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16d43, 0x16d6a}, {0x16d80, 0x16d97}, 
            {0x16d99, 0x16d9c}, {0x16f00, 0x16f4a}, {0x17000, 0x18cd5}, {0x18cff, 0x18d1e}, 
            {0x18d80, 0x18df2}, {0x1b000, 0x1b122}, {0x1b150, 0x1b152}, {0x1b164, 0x1b167}, 
            {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, 
            {0x1bc90, 0x1bc99}, {0x1e100, 0x1e12c}, {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, 
            {0x1e4d0, 0x1e4ea}, {0x1e5d0, 0x1e5ed}, {0x1e6c0, 0x1e6de}, {0x1e6e0, 0x1e6e2}, 
            {0x1e6e4, 0x1e6e5}, {0x1e6e7, 0x1e6ed}, {0x1e6f0, 0x1e6f4}, {0x1e7e0, 0x1e7e6}, 
            {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, 
            {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, 
            {0x1ee34, 0x1ee37}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, 
            {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, 
            {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, 
            {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, {0x2a700, 0x2b81d}, {0x2b820, 0x2cead}, 
            {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, 
            {0x31350, 0x33479}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass26()
{
    // Name = Initial_Punctuation, number of codePoints: 12
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00ab, 0x2018, 0x201f, 0x2039, 0x2e02, 0x2e04, 0x2e09, 0x2e0c, 
            0x2e1c, 0x2e20}),
        std::initializer_list<CharacterRange>({{0x201b, 0x201c}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass27()
{
    // Name = Format, number of codePoints: 170
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00ad, 0x061c, 0x06dd, 0x070f, 0x08e2, 0x180e, 0xfeff, 0x110bd, 
            0x110cd, 0xe0001}),
        std::initializer_list<CharacterRange>({{0x0600, 0x0605}, {0x0890, 0x0891}, {0x200b, 0x200f}, {0x202a, 0x202e}, 
            {0x2060, 0x2064}, {0x2066, 0x206f}, {0xfff9, 0xfffb}, {0x13430, 0x1343f}, 
            {0x1bca0, 0x1bca3}, {0x1d173, 0x1d17a}, {0xe0020, 0xe007f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass28()
{
    // Name = Other_Number, number of codePoints: 915
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00b9, 0x19da, 0x2070, 0x2189, 0x2cfd}),
        std::initializer_list<CharacterRange>({{0x00b2, 0x00b3}, {0x00bc, 0x00be}, {0x09f4, 0x09f9}, {0x0b72, 0x0b77}, 
            {0x0bf0, 0x0bf2}, {0x0c78, 0x0c7e}, {0x0d58, 0x0d5e}, {0x0d70, 0x0d78}, 
            {0x0f2a, 0x0f33}, {0x1369, 0x137c}, {0x17f0, 0x17f9}, {0x2074, 0x2079}, 
            {0x2080, 0x2089}, {0x2150, 0x215f}, {0x2460, 0x249b}, {0x24ea, 0x24ff}, 
            {0x2776, 0x2793}, {0x3192, 0x3195}, {0x3220, 0x3229}, {0x3248, 0x324f}, 
            {0x3251, 0x325f}, {0x3280, 0x3289}, {0x32b1, 0x32bf}, {0xa830, 0xa835}, 
            {0x10107, 0x10133}, {0x10175, 0x10178}, {0x1018a, 0x1018b}, {0x102e1, 0x102fb}, 
            {0x10320, 0x10323}, {0x10858, 0x1085f}, {0x10879, 0x1087f}, {0x108a7, 0x108af}, 
            {0x108fb, 0x108ff}, {0x10916, 0x1091b}, {0x109bc, 0x109bd}, {0x109c0, 0x109cf}, 
            {0x109d2, 0x109ff}, {0x10a40, 0x10a48}, {0x10a7d, 0x10a7e}, {0x10a9d, 0x10a9f}, 
            {0x10aeb, 0x10aef}, {0x10b58, 0x10b5f}, {0x10b78, 0x10b7f}, {0x10ba9, 0x10baf}, 
            {0x10cfa, 0x10cff}, {0x10e60, 0x10e7e}, {0x10f1d, 0x10f26}, {0x10f51, 0x10f54}, 
            {0x10fc5, 0x10fcb}, {0x11052, 0x11065}, {0x111e1, 0x111f4}, {0x1173a, 0x1173b}, 
            {0x118ea, 0x118f2}, {0x11c5a, 0x11c6c}, {0x11fc0, 0x11fd4}, {0x16b5b, 0x16b61}, 
            {0x16e80, 0x16e96}, {0x1d2c0, 0x1d2d3}, {0x1d2e0, 0x1d2f3}, {0x1d360, 0x1d378}, 
            {0x1e8c7, 0x1e8cf}, {0x1ec71, 0x1ecab}, {0x1ecad, 0x1ecaf}, {0x1ecb1, 0x1ecb4}, 
            {0x1ed01, 0x1ed2d}, {0x1ed2f, 0x1ed3d}, {0x1f100, 0x1f10c}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass29()
{
    // Name = Final_Punctuation, number of codePoints: 10
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00bb, 0x2019, 0x201d, 0x203a, 0x2e03, 0x2e05, 0x2e0a, 0x2e0d, 
            0x2e1d, 0x2e21}),
        std::initializer_list<CharacterRange>({}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass30()
{
    // Name = Titlecase_Letter, number of codePoints: 31
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x01c5, 0x01c8, 0x01cb, 0x01f2, 0x1fbc, 0x1fcc, 0x1ffc}),
        std::initializer_list<CharacterRange>({{0x1f88, 0x1f8f}, {0x1f98, 0x1f9f}, {0x1fa8, 0x1faf}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass31()
{
    // Name = Modifier_Letter, number of codePoints: 410
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x02ec, 0x02ee, 0x0374, 0x037a, 0x0559, 0x0640, 0x07fa, 0x081a, 
            0x0824, 0x0828, 0x08c9, 0x0971, 0x0e46, 0x0ec6, 0x10fc, 0x17d7, 
            0x1843, 0x1aa7, 0x1d78, 0x2071, 0x207f, 0x2d6f, 0x2e2f, 0x3005, 
            0x303b, 0xa015, 0xa60c, 0xa67f, 0xa770, 0xa788, 0xa9cf, 0xa9e6, 
            0xaa70, 0xaadd, 0xab69, 0xff70, 0x10d4e, 0x10d6f, 0x10ec5, 0x11dd9, 
            0x16fe3, 0x1e4eb, 0x1e6ff, 0x1e94b}),
        std::initializer_list<CharacterRange>({{0x02b0, 0x02c1}, {0x02c6, 0x02d1}, {0x02e0, 0x02e4}, {0x06e5, 0x06e6}, 
            {0x07f4, 0x07f5}, {0x1c78, 0x1c7d}, {0x1d2c, 0x1d6a}, {0x1d9b, 0x1dbf}, 
            {0x2090, 0x209c}, {0x2c7c, 0x2c7d}, {0x3031, 0x3035}, {0x309d, 0x309e}, 
            {0x30fc, 0x30fe}, {0xa4f8, 0xa4fd}, {0xa69c, 0xa69d}, {0xa717, 0xa71f}, 
            {0xa7f1, 0xa7f4}, {0xa7f8, 0xa7f9}, {0xaaf3, 0xaaf4}, {0xab5c, 0xab5f}, 
            {0xff9e, 0xff9f}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, 
            {0x16b40, 0x16b43}, {0x16d40, 0x16d42}, {0x16d6b, 0x16d6c}, {0x16f93, 0x16f9f}, 
            {0x16fe0, 0x16fe1}, {0x16ff2, 0x16ff3}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, 
            {0x1affd, 0x1affe}, {0x1e030, 0x1e06d}, {0x1e137, 0x1e13d}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass32()
{
    // Name = Mark, number of codePoints: 2547
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x05bf, 0x05c7, 0x0670, 0x0711, 0x07fd, 0x09bc, 0x09d7, 0x09fe, 
            0x0a3c, 0x0a51, 0x0a75, 0x0abc, 0x0b3c, 0x0b82, 0x0bd7, 0x0c3c, 
            0x0cbc, 0x0cf3, 0x0d57, 0x0dca, 0x0dd6, 0x0e31, 0x0eb1, 0x0f35, 
            0x0f37, 0x0f39, 0x0fc6, 0x108f, 0x17dd, 0x180f, 0x18a9, 0x1a7f, 
            0x1ced, 0x1cf4, 0x2d7f, 0xa802, 0xa806, 0xa80b, 0xa82c, 0xa8ff, 
            0xa9e5, 0xaa43, 0xaab0, 0xaac1, 0xfb1e, 0x101fd, 0x102e0, 0x10a3f, 
            0x11070, 0x110c2, 0x11173, 0x1123e, 0x11241, 0x11357, 0x113c2, 0x113c5, 
            0x113d2, 0x1145e, 0x11940, 0x119e4, 0x11a47, 0x11d3a, 0x11d47, 0x11f03, 
            0x11f5a, 0x13440, 0x16d98, 0x16d9d, 0x16f4f, 0x16fe4, 0x1da75, 0x1da84, 
            0x1e08f, 0x1e2ae, 0x1e6e3, 0x1e6e6, 0x1e6f5}),
        std::initializer_list<CharacterRange>({{0x0300, 0x036f}, {0x0483, 0x0489}, {0x0591, 0x05bd}, {0x05c1, 0x05c2}, 
            {0x05c4, 0x05c5}, {0x0610, 0x061a}, {0x064b, 0x065f}, {0x06d6, 0x06dc}, 
            {0x06df, 0x06e4}, {0x06e7, 0x06e8}, {0x06ea, 0x06ed}, {0x0730, 0x074a}, 
            {0x07a6, 0x07b0}, {0x07eb, 0x07f3}, {0x0816, 0x0819}, {0x081b, 0x0823}, 
            {0x0825, 0x0827}, {0x0829, 0x082d}, {0x0859, 0x085b}, {0x0897, 0x089f}, 
            {0x08ca, 0x08e1}, {0x08e3, 0x0903}, {0x093a, 0x093c}, {0x093e, 0x094f}, 
            {0x0951, 0x0957}, {0x0962, 0x0963}, {0x0981, 0x0983}, {0x09be, 0x09c4}, 
            {0x09c7, 0x09c8}, {0x09cb, 0x09cd}, {0x09e2, 0x09e3}, {0x0a01, 0x0a03}, 
            {0x0a3e, 0x0a42}, {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a70, 0x0a71}, 
            {0x0a81, 0x0a83}, {0x0abe, 0x0ac5}, {0x0ac7, 0x0ac9}, {0x0acb, 0x0acd}, 
            {0x0ae2, 0x0ae3}, {0x0afa, 0x0aff}, {0x0b01, 0x0b03}, {0x0b3e, 0x0b44}, 
            {0x0b47, 0x0b48}, {0x0b4b, 0x0b4d}, {0x0b53, 0x0b57}, {0x0b62, 0x0b63}, 
            {0x0bbe, 0x0bc2}, {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcd}, {0x0c00, 0x0c04}, 
            {0x0c3e, 0x0c44}, {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56}, 
            {0x0c62, 0x0c63}, {0x0c81, 0x0c83}, {0x0cbe, 0x0cc4}, {0x0cc6, 0x0cc8}, 
            {0x0cca, 0x0ccd}, {0x0cd5, 0x0cd6}, {0x0ce2, 0x0ce3}, {0x0d00, 0x0d03}, 
            {0x0d3b, 0x0d3c}, {0x0d3e, 0x0d44}, {0x0d46, 0x0d48}, {0x0d4a, 0x0d4d}, 
            {0x0d62, 0x0d63}, {0x0d81, 0x0d83}, {0x0dcf, 0x0dd4}, {0x0dd8, 0x0ddf}, 
            {0x0df2, 0x0df3}, {0x0e34, 0x0e3a}, {0x0e47, 0x0e4e}, {0x0eb4, 0x0ebc}, 
            {0x0ec8, 0x0ece}, {0x0f18, 0x0f19}, {0x0f3e, 0x0f3f}, {0x0f71, 0x0f84}, 
            {0x0f86, 0x0f87}, {0x0f8d, 0x0f97}, {0x0f99, 0x0fbc}, {0x102b, 0x103e}, 
            {0x1056, 0x1059}, {0x105e, 0x1060}, {0x1062, 0x1064}, {0x1067, 0x106d}, 
            {0x1071, 0x1074}, {0x1082, 0x108d}, {0x109a, 0x109d}, {0x135d, 0x135f}, 
            {0x1712, 0x1715}, {0x1732, 0x1734}, {0x1752, 0x1753}, {0x1772, 0x1773}, 
            {0x17b4, 0x17d3}, {0x180b, 0x180d}, {0x1885, 0x1886}, {0x1920, 0x192b}, 
            {0x1930, 0x193b}, {0x1a17, 0x1a1b}, {0x1a55, 0x1a5e}, {0x1a60, 0x1a7c}, 
            {0x1ab0, 0x1add}, {0x1ae0, 0x1aeb}, {0x1b00, 0x1b04}, {0x1b34, 0x1b44}, 
            {0x1b6b, 0x1b73}, {0x1b80, 0x1b82}, {0x1ba1, 0x1bad}, {0x1be6, 0x1bf3}, 
            {0x1c24, 0x1c37}, {0x1cd0, 0x1cd2}, {0x1cd4, 0x1ce8}, {0x1cf7, 0x1cf9}, 
            {0x1dc0, 0x1dff}, {0x20d0, 0x20f0}, {0x2cef, 0x2cf1}, {0x2de0, 0x2dff}, 
            {0x302a, 0x302f}, {0x3099, 0x309a}, {0xa66f, 0xa672}, {0xa674, 0xa67d}, 
            {0xa69e, 0xa69f}, {0xa6f0, 0xa6f1}, {0xa823, 0xa827}, {0xa880, 0xa881}, 
            {0xa8b4, 0xa8c5}, {0xa8e0, 0xa8f1}, {0xa926, 0xa92d}, {0xa947, 0xa953}, 
            {0xa980, 0xa983}, {0xa9b3, 0xa9c0}, {0xaa29, 0xaa36}, {0xaa4c, 0xaa4d}, 
            {0xaa7b, 0xaa7d}, {0xaab2, 0xaab4}, {0xaab7, 0xaab8}, {0xaabe, 0xaabf}, 
            {0xaaeb, 0xaaef}, {0xaaf5, 0xaaf6}, {0xabe3, 0xabea}, {0xabec, 0xabed}, 
            {0xfe00, 0xfe0f}, {0xfe20, 0xfe2f}, {0x10376, 0x1037a}, {0x10a01, 0x10a03}, 
            {0x10a05, 0x10a06}, {0x10a0c, 0x10a0f}, {0x10a38, 0x10a3a}, {0x10ae5, 0x10ae6}, 
            {0x10d24, 0x10d27}, {0x10d69, 0x10d6d}, {0x10eab, 0x10eac}, {0x10efa, 0x10eff}, 
            {0x10f46, 0x10f50}, {0x10f82, 0x10f85}, {0x11000, 0x11002}, {0x11038, 0x11046}, 
            {0x11073, 0x11074}, {0x1107f, 0x11082}, {0x110b0, 0x110ba}, {0x11100, 0x11102}, 
            {0x11127, 0x11134}, {0x11145, 0x11146}, {0x11180, 0x11182}, {0x111b3, 0x111c0}, 
            {0x111c9, 0x111cc}, {0x111ce, 0x111cf}, {0x1122c, 0x11237}, {0x112df, 0x112ea}, 
            {0x11300, 0x11303}, {0x1133b, 0x1133c}, {0x1133e, 0x11344}, {0x11347, 0x11348}, 
            {0x1134b, 0x1134d}, {0x11362, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, 
            {0x113b8, 0x113c0}, {0x113c7, 0x113ca}, {0x113cc, 0x113d0}, {0x113e1, 0x113e2}, 
            {0x11435, 0x11446}, {0x114b0, 0x114c3}, {0x115af, 0x115b5}, {0x115b8, 0x115c0}, 
            {0x115dc, 0x115dd}, {0x11630, 0x11640}, {0x116ab, 0x116b7}, {0x1171d, 0x1172b}, 
            {0x1182c, 0x1183a}, {0x11930, 0x11935}, {0x11937, 0x11938}, {0x1193b, 0x1193e}, 
            {0x11942, 0x11943}, {0x119d1, 0x119d7}, {0x119da, 0x119e0}, {0x11a01, 0x11a0a}, 
            {0x11a33, 0x11a39}, {0x11a3b, 0x11a3e}, {0x11a51, 0x11a5b}, {0x11a8a, 0x11a99}, 
            {0x11b60, 0x11b67}, {0x11c2f, 0x11c36}, {0x11c38, 0x11c3f}, {0x11c92, 0x11ca7}, 
            {0x11ca9, 0x11cb6}, {0x11d31, 0x11d36}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d45}, 
            {0x11d8a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d97}, {0x11ef3, 0x11ef6}, 
            {0x11f00, 0x11f01}, {0x11f34, 0x11f3a}, {0x11f3e, 0x11f42}, {0x13447, 0x13455}, 
            {0x1611e, 0x1612f}, {0x16af0, 0x16af4}, {0x16b30, 0x16b36}, {0x16f51, 0x16f87}, 
            {0x16f8f, 0x16f92}, {0x16ff0, 0x16ff1}, {0x1bc9d, 0x1bc9e}, {0x1cf00, 0x1cf2d}, 
            {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, 
            {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1da00, 0x1da36}, 
            {0x1da3b, 0x1da6c}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1e000, 0x1e006}, 
            {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, 
            {0x1e130, 0x1e136}, {0x1e2ec, 0x1e2ef}, {0x1e4ec, 0x1e4ef}, {0x1e5ee, 0x1e5ef}, 
            {0x1e6ee, 0x1e6ef}, {0x1e8d0, 0x1e8d6}, {0x1e944, 0x1e94a}, {0xe0100, 0xe01ef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass33()
{
    // Name = Nonspacing_Mark, number of codePoints: 2063
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x05bf, 0x05c7, 0x0670, 0x0711, 0x07fd, 0x093a, 0x093c, 0x094d, 
            0x0981, 0x09bc, 0x09cd, 0x09fe, 0x0a3c, 0x0a51, 0x0a75, 0x0abc, 
            0x0acd, 0x0b01, 0x0b3c, 0x0b3f, 0x0b4d, 0x0b82, 0x0bc0, 0x0bcd, 
            0x0c00, 0x0c04, 0x0c3c, 0x0c81, 0x0cbc, 0x0cbf, 0x0cc6, 0x0d4d, 
            0x0d81, 0x0dca, 0x0dd6, 0x0e31, 0x0eb1, 0x0f35, 0x0f37, 0x0f39, 
            0x0fc6, 0x1082, 0x108d, 0x109d, 0x17c6, 0x17dd, 0x180f, 0x18a9, 
            0x1932, 0x1a1b, 0x1a56, 0x1a60, 0x1a62, 0x1a7f, 0x1b34, 0x1b3c, 
            0x1b42, 0x1be6, 0x1bed, 0x1ced, 0x1cf4, 0x20e1, 0x2d7f, 0xa66f, 
            0xa802, 0xa806, 0xa80b, 0xa82c, 0xa8ff, 0xa9b3, 0xa9e5, 0xaa43, 
            0xaa4c, 0xaa7c, 0xaab0, 0xaac1, 0xaaf6, 0xabe5, 0xabe8, 0xabed, 
            0xfb1e, 0x101fd, 0x102e0, 0x10a3f, 0x11001, 0x11070, 0x110c2, 0x11173, 
            0x111cf, 0x11234, 0x1123e, 0x11241, 0x112df, 0x11340, 0x113ce, 0x113d0, 
            0x113d2, 0x11446, 0x1145e, 0x114ba, 0x1163d, 0x116ab, 0x116ad, 0x116b7, 
            0x1171d, 0x1171f, 0x1193e, 0x11943, 0x119e0, 0x11a47, 0x11b60, 0x11b66, 
            0x11c3f, 0x11d3a, 0x11d47, 0x11d95, 0x11d97, 0x11f40, 0x11f42, 0x11f5a, 
            0x13440, 0x16d98, 0x16d9d, 0x16f4f, 0x16fe4, 0x1da75, 0x1da84, 0x1e08f, 
            0x1e2ae, 0x1e6e3, 0x1e6e6, 0x1e6f5}),
        std::initializer_list<CharacterRange>({{0x0300, 0x036f}, {0x0483, 0x0487}, {0x0591, 0x05bd}, {0x05c1, 0x05c2}, 
            {0x05c4, 0x05c5}, {0x0610, 0x061a}, {0x064b, 0x065f}, {0x06d6, 0x06dc}, 
            {0x06df, 0x06e4}, {0x06e7, 0x06e8}, {0x06ea, 0x06ed}, {0x0730, 0x074a}, 
            {0x07a6, 0x07b0}, {0x07eb, 0x07f3}, {0x0816, 0x0819}, {0x081b, 0x0823}, 
            {0x0825, 0x0827}, {0x0829, 0x082d}, {0x0859, 0x085b}, {0x0897, 0x089f}, 
            {0x08ca, 0x08e1}, {0x08e3, 0x0902}, {0x0941, 0x0948}, {0x0951, 0x0957}, 
            {0x0962, 0x0963}, {0x09c1, 0x09c4}, {0x09e2, 0x09e3}, {0x0a01, 0x0a02}, 
            {0x0a41, 0x0a42}, {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a70, 0x0a71}, 
            {0x0a81, 0x0a82}, {0x0ac1, 0x0ac5}, {0x0ac7, 0x0ac8}, {0x0ae2, 0x0ae3}, 
            {0x0afa, 0x0aff}, {0x0b41, 0x0b44}, {0x0b53, 0x0b56}, {0x0b62, 0x0b63}, 
            {0x0c3e, 0x0c40}, {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56}, 
            {0x0c62, 0x0c63}, {0x0ccc, 0x0ccd}, {0x0ce2, 0x0ce3}, {0x0d00, 0x0d01}, 
            {0x0d3b, 0x0d3c}, {0x0d41, 0x0d44}, {0x0d62, 0x0d63}, {0x0dd2, 0x0dd4}, 
            {0x0e34, 0x0e3a}, {0x0e47, 0x0e4e}, {0x0eb4, 0x0ebc}, {0x0ec8, 0x0ece}, 
            {0x0f18, 0x0f19}, {0x0f71, 0x0f7e}, {0x0f80, 0x0f84}, {0x0f86, 0x0f87}, 
            {0x0f8d, 0x0f97}, {0x0f99, 0x0fbc}, {0x102d, 0x1030}, {0x1032, 0x1037}, 
            {0x1039, 0x103a}, {0x103d, 0x103e}, {0x1058, 0x1059}, {0x105e, 0x1060}, 
            {0x1071, 0x1074}, {0x1085, 0x1086}, {0x135d, 0x135f}, {0x1712, 0x1714}, 
            {0x1732, 0x1733}, {0x1752, 0x1753}, {0x1772, 0x1773}, {0x17b4, 0x17b5}, 
            {0x17b7, 0x17bd}, {0x17c9, 0x17d3}, {0x180b, 0x180d}, {0x1885, 0x1886}, 
            {0x1920, 0x1922}, {0x1927, 0x1928}, {0x1939, 0x193b}, {0x1a17, 0x1a18}, 
            {0x1a58, 0x1a5e}, {0x1a65, 0x1a6c}, {0x1a73, 0x1a7c}, {0x1ab0, 0x1abd}, 
            {0x1abf, 0x1add}, {0x1ae0, 0x1aeb}, {0x1b00, 0x1b03}, {0x1b36, 0x1b3a}, 
            {0x1b6b, 0x1b73}, {0x1b80, 0x1b81}, {0x1ba2, 0x1ba5}, {0x1ba8, 0x1ba9}, 
            {0x1bab, 0x1bad}, {0x1be8, 0x1be9}, {0x1bef, 0x1bf1}, {0x1c2c, 0x1c33}, 
            {0x1c36, 0x1c37}, {0x1cd0, 0x1cd2}, {0x1cd4, 0x1ce0}, {0x1ce2, 0x1ce8}, 
            {0x1cf8, 0x1cf9}, {0x1dc0, 0x1dff}, {0x20d0, 0x20dc}, {0x20e5, 0x20f0}, 
            {0x2cef, 0x2cf1}, {0x2de0, 0x2dff}, {0x302a, 0x302d}, {0x3099, 0x309a}, 
            {0xa674, 0xa67d}, {0xa69e, 0xa69f}, {0xa6f0, 0xa6f1}, {0xa825, 0xa826}, 
            {0xa8c4, 0xa8c5}, {0xa8e0, 0xa8f1}, {0xa926, 0xa92d}, {0xa947, 0xa951}, 
            {0xa980, 0xa982}, {0xa9b6, 0xa9b9}, {0xa9bc, 0xa9bd}, {0xaa29, 0xaa2e}, 
            {0xaa31, 0xaa32}, {0xaa35, 0xaa36}, {0xaab2, 0xaab4}, {0xaab7, 0xaab8}, 
            {0xaabe, 0xaabf}, {0xaaec, 0xaaed}, {0xfe00, 0xfe0f}, {0xfe20, 0xfe2f}, 
            {0x10376, 0x1037a}, {0x10a01, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a0f}, 
            {0x10a38, 0x10a3a}, {0x10ae5, 0x10ae6}, {0x10d24, 0x10d27}, {0x10d69, 0x10d6d}, 
            {0x10eab, 0x10eac}, {0x10efa, 0x10eff}, {0x10f46, 0x10f50}, {0x10f82, 0x10f85}, 
            {0x11038, 0x11046}, {0x11073, 0x11074}, {0x1107f, 0x11081}, {0x110b3, 0x110b6}, 
            {0x110b9, 0x110ba}, {0x11100, 0x11102}, {0x11127, 0x1112b}, {0x1112d, 0x11134}, 
            {0x11180, 0x11181}, {0x111b6, 0x111be}, {0x111c9, 0x111cc}, {0x1122f, 0x11231}, 
            {0x11236, 0x11237}, {0x112e3, 0x112ea}, {0x11300, 0x11301}, {0x1133b, 0x1133c}, 
            {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x113bb, 0x113c0}, {0x113e1, 0x113e2}, 
            {0x11438, 0x1143f}, {0x11442, 0x11444}, {0x114b3, 0x114b8}, {0x114bf, 0x114c0}, 
            {0x114c2, 0x114c3}, {0x115b2, 0x115b5}, {0x115bc, 0x115bd}, {0x115bf, 0x115c0}, 
            {0x115dc, 0x115dd}, {0x11633, 0x1163a}, {0x1163f, 0x11640}, {0x116b0, 0x116b5}, 
            {0x11722, 0x11725}, {0x11727, 0x1172b}, {0x1182f, 0x11837}, {0x11839, 0x1183a}, 
            {0x1193b, 0x1193c}, {0x119d4, 0x119d7}, {0x119da, 0x119db}, {0x11a01, 0x11a0a}, 
            {0x11a33, 0x11a38}, {0x11a3b, 0x11a3e}, {0x11a51, 0x11a56}, {0x11a59, 0x11a5b}, 
            {0x11a8a, 0x11a96}, {0x11a98, 0x11a99}, {0x11b62, 0x11b64}, {0x11c30, 0x11c36}, 
            {0x11c38, 0x11c3d}, {0x11c92, 0x11ca7}, {0x11caa, 0x11cb0}, {0x11cb2, 0x11cb3}, 
            {0x11cb5, 0x11cb6}, {0x11d31, 0x11d36}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d45}, 
            {0x11d90, 0x11d91}, {0x11ef3, 0x11ef4}, {0x11f00, 0x11f01}, {0x11f36, 0x11f3a}, 
            {0x13447, 0x13455}, {0x1611e, 0x16129}, {0x1612d, 0x1612f}, {0x16af0, 0x16af4}, 
            {0x16b30, 0x16b36}, {0x16f8f, 0x16f92}, {0x1bc9d, 0x1bc9e}, {0x1cf00, 0x1cf2d}, 
            {0x1cf30, 0x1cf46}, {0x1d167, 0x1d169}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, 
            {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c}, 
            {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018}, 
            {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e130, 0x1e136}, 
            {0x1e2ec, 0x1e2ef}, {0x1e4ec, 0x1e4ef}, {0x1e5ee, 0x1e5ef}, {0x1e6ee, 0x1e6ef}, 
            {0x1e8d0, 0x1e8d6}, {0x1e944, 0x1e94a}, {0xe0100, 0xe01ef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass34()
{
    // Name = Enclosing_Mark, number of codePoints: 13
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1abe}),
        std::initializer_list<CharacterRange>({{0x0488, 0x0489}, {0x20dd, 0x20e0}, {0x20e2, 0x20e4}, {0xa670, 0xa672}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass35()
{
    // Name = Spacing_Mark, number of codePoints: 471
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0903, 0x093b, 0x09d7, 0x0a03, 0x0a83, 0x0ac9, 0x0b3e, 0x0b40, 
            0x0b57, 0x0bd7, 0x0cbe, 0x0cf3, 0x0d57, 0x0f7f, 0x1031, 0x1038, 
            0x108f, 0x1715, 0x1734, 0x17b6, 0x1a55, 0x1a57, 0x1a61, 0x1b04, 
            0x1b35, 0x1b3b, 0x1b82, 0x1ba1, 0x1baa, 0x1be7, 0x1bee, 0x1ce1, 
            0x1cf7, 0xa827, 0xa983, 0xaa4d, 0xaa7b, 0xaa7d, 0xaaeb, 0xaaf5, 
            0xabec, 0x11000, 0x11002, 0x11082, 0x1112c, 0x11182, 0x111ce, 0x11235, 
            0x11357, 0x113c2, 0x113c5, 0x113cf, 0x11445, 0x114b9, 0x114c1, 0x115be, 
            0x1163e, 0x116ac, 0x116b6, 0x1171e, 0x11726, 0x11838, 0x1193d, 0x11940, 
            0x11942, 0x119e4, 0x11a39, 0x11a97, 0x11b61, 0x11b65, 0x11b67, 0x11c2f, 
            0x11c3e, 0x11ca9, 0x11cb1, 0x11cb4, 0x11d96, 0x11f03, 0x11f41}),
        std::initializer_list<CharacterRange>({{0x093e, 0x0940}, {0x0949, 0x094c}, {0x094e, 0x094f}, {0x0982, 0x0983}, 
            {0x09be, 0x09c0}, {0x09c7, 0x09c8}, {0x09cb, 0x09cc}, {0x0a3e, 0x0a40}, 
            {0x0abe, 0x0ac0}, {0x0acb, 0x0acc}, {0x0b02, 0x0b03}, {0x0b47, 0x0b48}, 
            {0x0b4b, 0x0b4c}, {0x0bbe, 0x0bbf}, {0x0bc1, 0x0bc2}, {0x0bc6, 0x0bc8}, 
            {0x0bca, 0x0bcc}, {0x0c01, 0x0c03}, {0x0c41, 0x0c44}, {0x0c82, 0x0c83}, 
            {0x0cc0, 0x0cc4}, {0x0cc7, 0x0cc8}, {0x0cca, 0x0ccb}, {0x0cd5, 0x0cd6}, 
            {0x0d02, 0x0d03}, {0x0d3e, 0x0d40}, {0x0d46, 0x0d48}, {0x0d4a, 0x0d4c}, 
            {0x0d82, 0x0d83}, {0x0dcf, 0x0dd1}, {0x0dd8, 0x0ddf}, {0x0df2, 0x0df3}, 
            {0x0f3e, 0x0f3f}, {0x102b, 0x102c}, {0x103b, 0x103c}, {0x1056, 0x1057}, 
            {0x1062, 0x1064}, {0x1067, 0x106d}, {0x1083, 0x1084}, {0x1087, 0x108c}, 
            {0x109a, 0x109c}, {0x17be, 0x17c5}, {0x17c7, 0x17c8}, {0x1923, 0x1926}, 
            {0x1929, 0x192b}, {0x1930, 0x1931}, {0x1933, 0x1938}, {0x1a19, 0x1a1a}, 
            {0x1a63, 0x1a64}, {0x1a6d, 0x1a72}, {0x1b3d, 0x1b41}, {0x1b43, 0x1b44}, 
            {0x1ba6, 0x1ba7}, {0x1bea, 0x1bec}, {0x1bf2, 0x1bf3}, {0x1c24, 0x1c2b}, 
            {0x1c34, 0x1c35}, {0x302e, 0x302f}, {0xa823, 0xa824}, {0xa880, 0xa881}, 
            {0xa8b4, 0xa8c3}, {0xa952, 0xa953}, {0xa9b4, 0xa9b5}, {0xa9ba, 0xa9bb}, 
            {0xa9be, 0xa9c0}, {0xaa2f, 0xaa30}, {0xaa33, 0xaa34}, {0xaaee, 0xaaef}, 
            {0xabe3, 0xabe4}, {0xabe6, 0xabe7}, {0xabe9, 0xabea}, {0x110b0, 0x110b2}, 
            {0x110b7, 0x110b8}, {0x11145, 0x11146}, {0x111b3, 0x111b5}, {0x111bf, 0x111c0}, 
            {0x1122c, 0x1122e}, {0x11232, 0x11233}, {0x112e0, 0x112e2}, {0x11302, 0x11303}, 
            {0x1133e, 0x1133f}, {0x11341, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d}, 
            {0x11362, 0x11363}, {0x113b8, 0x113ba}, {0x113c7, 0x113ca}, {0x113cc, 0x113cd}, 
            {0x11435, 0x11437}, {0x11440, 0x11441}, {0x114b0, 0x114b2}, {0x114bb, 0x114be}, 
            {0x115af, 0x115b1}, {0x115b8, 0x115bb}, {0x11630, 0x11632}, {0x1163b, 0x1163c}, 
            {0x116ae, 0x116af}, {0x11720, 0x11721}, {0x1182c, 0x1182e}, {0x11930, 0x11935}, 
            {0x11937, 0x11938}, {0x119d1, 0x119d3}, {0x119dc, 0x119df}, {0x11a57, 0x11a58}, 
            {0x11d8a, 0x11d8e}, {0x11d93, 0x11d94}, {0x11ef5, 0x11ef6}, {0x11f34, 0x11f35}, 
            {0x11f3e, 0x11f3f}, {0x1612a, 0x1612c}, {0x16f51, 0x16f87}, {0x16ff0, 0x16ff1}, 
            {0x1d165, 0x1d166}, {0x1d16d, 0x1d172}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass36()
{
    // Name = Letter_Number, number of codePoints: 239
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x3007, 0x10341, 0x1034a}),
        std::initializer_list<CharacterRange>({{0x16ee, 0x16f0}, {0x2160, 0x2182}, {0x2185, 0x2188}, {0x3021, 0x3029}, 
            {0x3038, 0x303a}, {0xa6e6, 0xa6ef}, {0x10140, 0x10174}, {0x103d1, 0x103d5}, 
            {0x12400, 0x1246e}, {0x16ff4, 0x16ff6}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass37()
{
    // Name = Line_Separator, number of codePoints: 1
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x2028}),
        std::initializer_list<CharacterRange>({}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass38()
{
    // Name = Paragraph_Separator, number of codePoints: 1
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x2029}),
        std::initializer_list<CharacterRange>({}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass39()
{
    // Name = Surrogate, number of codePoints: 2048
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0xd800, 0xdfff}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass40()
{
    // Name = Private_Use, number of codePoints: 137468
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0xe000, 0xf8ff}, {0xf0000, 0xffffd}, {0x100000, 0x10fffd}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass41()
{
    // Name = Bidi_Mirrored, number of codePoints: 554
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x3c, 0x3e, 0x5b, 0x5d, 0x7b, 0x7d}),
        std::initializer_list<CharacterRange>({{0x28, 0x29}}),
        std::initializer_list<char32_t>({0x00ab, 0x00bb, 0x2140, 0x2211, 0x2224, 0x2226, 0x2239, 0x2262, 
            0x2298, 0x27c0, 0x29b8, 0x29c9, 0x29e1, 0x2a24, 0x2a26, 0x2a29, 
            0x2adc, 0x2ade, 0x2af3, 0x2afd, 0x2bfe, 0xff1c, 0xff1e, 0xff3b, 
            0xff3d, 0xff5b, 0xff5d, 0x1d6db, 0x1d715, 0x1d74f, 0x1d789, 0x1d7c3}),
        std::initializer_list<CharacterRange>({{0x0f3a, 0x0f3d}, {0x169b, 0x169c}, {0x2039, 0x203a}, {0x2045, 0x2046}, 
            {0x207d, 0x207e}, {0x208d, 0x208e}, {0x2201, 0x2204}, {0x2208, 0x220d}, 
            {0x2215, 0x2216}, {0x221a, 0x221d}, {0x221f, 0x2222}, {0x222b, 0x2233}, 
            {0x223b, 0x224c}, {0x2252, 0x2255}, {0x225f, 0x2260}, {0x2264, 0x226b}, 
            {0x226d, 0x228c}, {0x228f, 0x2292}, {0x22a2, 0x22a3}, {0x22a6, 0x22b8}, 
            {0x22be, 0x22bf}, {0x22c9, 0x22cd}, {0x22d0, 0x22d1}, {0x22d6, 0x22ed}, 
            {0x22f0, 0x22ff}, {0x2308, 0x230b}, {0x2320, 0x2321}, {0x2329, 0x232a}, 
            {0x2768, 0x2775}, {0x27c3, 0x27c6}, {0x27c8, 0x27c9}, {0x27cb, 0x27cd}, 
            {0x27d3, 0x27d6}, {0x27dc, 0x27de}, {0x27e2, 0x27ef}, {0x2983, 0x2998}, 
            {0x299b, 0x29a0}, {0x29a2, 0x29af}, {0x29c0, 0x29c5}, {0x29ce, 0x29d2}, 
            {0x29d4, 0x29d5}, {0x29d8, 0x29dc}, {0x29e3, 0x29e5}, {0x29e8, 0x29e9}, 
            {0x29f4, 0x29f9}, {0x29fc, 0x29fd}, {0x2a0a, 0x2a1c}, {0x2a1e, 0x2a21}, 
            {0x2a2b, 0x2a2e}, {0x2a34, 0x2a35}, {0x2a3c, 0x2a3e}, {0x2a57, 0x2a58}, 
            {0x2a64, 0x2a65}, {0x2a6a, 0x2a6d}, {0x2a6f, 0x2a70}, {0x2a73, 0x2a74}, 
            {0x2a79, 0x2aa3}, {0x2aa6, 0x2aad}, {0x2aaf, 0x2ad6}, {0x2ae2, 0x2ae6}, 
            {0x2aec, 0x2aee}, {0x2af7, 0x2afb}, {0x2e02, 0x2e05}, {0x2e09, 0x2e0a}, 
            {0x2e0c, 0x2e0d}, {0x2e1c, 0x2e1d}, {0x2e20, 0x2e29}, {0x2e55, 0x2e5c}, 
            {0x3008, 0x3011}, {0x3014, 0x301b}, {0xfe59, 0xfe5e}, {0xfe64, 0xfe65}, 
            {0xff08, 0xff09}, {0xff5f, 0xff60}, {0xff62, 0xff63}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass42()
{
    // Name = Math, number of codePoints: 2322
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x2b, 0x5e, 0x7c, 0x7e}),
        std::initializer_list<CharacterRange>({{0x3c, 0x3e}}),
        std::initializer_list<char32_t>({0x00ac, 0x00b1, 0x00d7, 0x00f7, 0x03d5, 0x2016, 0x2040, 0x2044, 
            0x2052, 0x20e1, 0x2102, 0x2107, 0x2115, 0x2124, 0x214b, 0x21dd, 
            0x237c, 0x23b7, 0x23d0, 0x25e2, 0x25e4, 0x2640, 0x2642, 0xfb29, 
            0xfe68, 0xff0b, 0xff3c, 0xff3e, 0xff5c, 0xff5e, 0xffe2, 0x1cef0, 
            0x1d4a2, 0x1d4bb, 0x1d546, 0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 0x1ee42, 
            0x1ee47, 0x1ee49, 0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 0x1ee5d, 
            0x1ee5f, 0x1ee64, 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x03d0, 0x03d2}, {0x03f0, 0x03f1}, {0x03f4, 0x03f6}, {0x0606, 0x0608}, 
            {0x2032, 0x2034}, {0x2061, 0x2064}, {0x207a, 0x207e}, {0x208a, 0x208e}, 
            {0x20d0, 0x20dc}, {0x20e5, 0x20e6}, {0x20eb, 0x20ef}, {0x210a, 0x2113}, 
            {0x2118, 0x211d}, {0x2128, 0x2129}, {0x212c, 0x212d}, {0x212f, 0x2131}, 
            {0x2133, 0x2138}, {0x213c, 0x2149}, {0x2190, 0x21a7}, {0x21a9, 0x21ae}, 
            {0x21b0, 0x21b1}, {0x21b6, 0x21b7}, {0x21bc, 0x21db}, {0x21e4, 0x21e5}, 
            {0x21f4, 0x22ff}, {0x2308, 0x230b}, {0x2320, 0x2321}, {0x239b, 0x23b5}, 
            {0x23dc, 0x23e2}, {0x25a0, 0x25a1}, {0x25ae, 0x25b7}, {0x25bc, 0x25c1}, 
            {0x25c6, 0x25c7}, {0x25ca, 0x25cb}, {0x25cf, 0x25d3}, {0x25e7, 0x25ec}, 
            {0x25f8, 0x25ff}, {0x2605, 0x2606}, {0x2660, 0x2663}, {0x266d, 0x266f}, 
            {0x27c0, 0x27ff}, {0x2900, 0x2aff}, {0x2b30, 0x2b44}, {0x2b47, 0x2b4c}, 
            {0xfe61, 0xfe66}, {0xff1c, 0xff1e}, {0xffe9, 0xffec}, {0x10d8e, 0x10d8f}, 
            {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, 
            {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, 
            {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, 
            {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, 
            {0x1d6a8, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, 
            {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee4d, 0x1ee4f}, 
            {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, 
            {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, 
            {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1eef0, 0x1eef1}, 
            {0x1f8d0, 0x1f8d8}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass43()
{
    // Name = Alphabetic, number of codePoints: 147451
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<char32_t>({0x00aa, 0x00b5, 0x00ba, 0x02ec, 0x02ee, 0x0345, 0x037f, 0x0386, 
            0x038c, 0x0559, 0x05bf, 0x05c7, 0x06ff, 0x07fa, 0x0897, 0x09b2, 
            0x09ce, 0x09d7, 0x09fc, 0x09ff, 0x0a51, 0x0a5e, 0x0ad0, 0x0b71, 
            0x0b9c, 0x0bd0, 0x0bd7, 0x0d4e, 0x0dbd, 0x0dd6, 0x0e4d, 0x0e84, 
            0x0ea5, 0x0ec6, 0x0ecd, 0x0f00, 0x1038, 0x10c7, 0x10cd, 0x1258, 
            0x12c0, 0x17d7, 0x17dc, 0x1aa7, 0x1cfa, 0x1f59, 0x1f5b, 0x1f5d, 
            0x1fbe, 0x2071, 0x207f, 0x2102, 0x2107, 0x2115, 0x2124, 0x2126, 
            0x2128, 0x214e, 0x2d27, 0x2d2d, 0x2d6f, 0x2e2f, 0xa8c5, 0xa8fb, 
            0xa9cf, 0xaac0, 0xaac2, 0xfb3e, 0x10808, 0x1083c, 0x10d69, 0x10f27, 
            0x110c2, 0x11176, 0x111da, 0x111dc, 0x11237, 0x11288, 0x11350, 0x11357, 
            0x1138b, 0x1138e, 0x113c2, 0x113c5, 0x113d1, 0x113d3, 0x114c7, 0x11640, 
            0x11644, 0x116b8, 0x11909, 0x119e1, 0x11a9d, 0x11c40, 0x11d3a, 0x11d43, 
            0x11d98, 0x11fb0, 0x16fe3, 0x1b132, 0x1b155, 0x1bc9e, 0x1d4a2, 0x1d4bb, 
            0x1d546, 0x1e08f, 0x1e14e, 0x1e5f0, 0x1e947, 0x1e94b, 0x1ee24, 0x1ee27, 
            0x1ee39, 0x1ee3b, 0x1ee42, 0x1ee47, 0x1ee49, 0x1ee4b, 0x1ee54, 0x1ee57, 
            0x1ee59, 0x1ee5b, 0x1ee5d, 0x1ee5f, 0x1ee64, 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x02c1}, {0x02c6, 0x02d1}, 
            {0x02e0, 0x02e4}, {0x0363, 0x0374}, {0x0376, 0x0377}, {0x037a, 0x037d}, 
            {0x0388, 0x038a}, {0x038e, 0x03a1}, {0x03a3, 0x03f5}, {0x03f7, 0x0481}, 
            {0x048a, 0x052f}, {0x0531, 0x0556}, {0x0560, 0x0588}, {0x05b0, 0x05bd}, 
            {0x05c1, 0x05c2}, {0x05c4, 0x05c5}, {0x05d0, 0x05ea}, {0x05ef, 0x05f2}, 
            {0x0610, 0x061a}, {0x0620, 0x0657}, {0x0659, 0x065f}, {0x066e, 0x06d3}, 
            {0x06d5, 0x06dc}, {0x06e1, 0x06e8}, {0x06ed, 0x06ef}, {0x06fa, 0x06fc}, 
            {0x0710, 0x073f}, {0x074d, 0x07b1}, {0x07ca, 0x07ea}, {0x07f4, 0x07f5}, 
            {0x0800, 0x0817}, {0x081a, 0x082c}, {0x0840, 0x0858}, {0x0860, 0x086a}, 
            {0x0870, 0x0887}, {0x0889, 0x088f}, {0x08a0, 0x08c9}, {0x08d4, 0x08df}, 
            {0x08e3, 0x08e9}, {0x08f0, 0x093b}, {0x093d, 0x094c}, {0x094e, 0x0950}, 
            {0x0955, 0x0963}, {0x0971, 0x0983}, {0x0985, 0x098c}, {0x098f, 0x0990}, 
            {0x0993, 0x09a8}, {0x09aa, 0x09b0}, {0x09b6, 0x09b9}, {0x09bd, 0x09c4}, 
            {0x09c7, 0x09c8}, {0x09cb, 0x09cc}, {0x09dc, 0x09dd}, {0x09df, 0x09e3}, 
            {0x09f0, 0x09f1}, {0x0a01, 0x0a03}, {0x0a05, 0x0a0a}, {0x0a0f, 0x0a10}, 
            {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, {0x0a35, 0x0a36}, 
            {0x0a38, 0x0a39}, {0x0a3e, 0x0a42}, {0x0a47, 0x0a48}, {0x0a4b, 0x0a4c}, 
            {0x0a59, 0x0a5c}, {0x0a70, 0x0a75}, {0x0a81, 0x0a83}, {0x0a85, 0x0a8d}, 
            {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0}, {0x0ab2, 0x0ab3}, 
            {0x0ab5, 0x0ab9}, {0x0abd, 0x0ac5}, {0x0ac7, 0x0ac9}, {0x0acb, 0x0acc}, 
            {0x0ae0, 0x0ae3}, {0x0af9, 0x0afc}, {0x0b01, 0x0b03}, {0x0b05, 0x0b0c}, 
            {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, 
            {0x0b35, 0x0b39}, {0x0b3d, 0x0b44}, {0x0b47, 0x0b48}, {0x0b4b, 0x0b4c}, 
            {0x0b56, 0x0b57}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b63}, {0x0b82, 0x0b83}, 
            {0x0b85, 0x0b8a}, {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, 
            {0x0b9e, 0x0b9f}, {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, 
            {0x0bbe, 0x0bc2}, {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcc}, {0x0c00, 0x0c0c}, 
            {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, {0x0c3d, 0x0c44}, 
            {0x0c46, 0x0c48}, {0x0c4a, 0x0c4c}, {0x0c55, 0x0c56}, {0x0c58, 0x0c5a}, 
            {0x0c5c, 0x0c5d}, {0x0c60, 0x0c63}, {0x0c80, 0x0c83}, {0x0c85, 0x0c8c}, 
            {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, 
            {0x0cbd, 0x0cc4}, {0x0cc6, 0x0cc8}, {0x0cca, 0x0ccc}, {0x0cd5, 0x0cd6}, 
            {0x0cdc, 0x0cde}, {0x0ce0, 0x0ce3}, {0x0cf1, 0x0cf3}, {0x0d00, 0x0d0c}, 
            {0x0d0e, 0x0d10}, {0x0d12, 0x0d3a}, {0x0d3d, 0x0d44}, {0x0d46, 0x0d48}, 
            {0x0d4a, 0x0d4c}, {0x0d54, 0x0d57}, {0x0d5f, 0x0d63}, {0x0d7a, 0x0d7f}, 
            {0x0d81, 0x0d83}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, {0x0db3, 0x0dbb}, 
            {0x0dc0, 0x0dc6}, {0x0dcf, 0x0dd4}, {0x0dd8, 0x0ddf}, {0x0df2, 0x0df3}, 
            {0x0e01, 0x0e3a}, {0x0e40, 0x0e46}, {0x0e81, 0x0e82}, {0x0e86, 0x0e8a}, 
            {0x0e8c, 0x0ea3}, {0x0ea7, 0x0eb9}, {0x0ebb, 0x0ebd}, {0x0ec0, 0x0ec4}, 
            {0x0edc, 0x0edf}, {0x0f40, 0x0f47}, {0x0f49, 0x0f6c}, {0x0f71, 0x0f83}, 
            {0x0f88, 0x0f97}, {0x0f99, 0x0fbc}, {0x1000, 0x1036}, {0x103b, 0x103f}, 
            {0x1050, 0x108f}, {0x109a, 0x109d}, {0x10a0, 0x10c5}, {0x10d0, 0x10fa}, 
            {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x125a, 0x125d}, 
            {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, 
            {0x12b8, 0x12be}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, 
            {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, 
            {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, 
            {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1713}, {0x171f, 0x1733}, 
            {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, 
            {0x1780, 0x17b3}, {0x17b6, 0x17c8}, {0x1820, 0x1878}, {0x1880, 0x18aa}, 
            {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x1938}, 
            {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, 
            {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e}, {0x1a61, 0x1a74}, {0x1abf, 0x1ac0}, 
            {0x1acc, 0x1ace}, {0x1b00, 0x1b33}, {0x1b35, 0x1b43}, {0x1b45, 0x1b4c}, 
            {0x1b80, 0x1ba9}, {0x1bac, 0x1baf}, {0x1bba, 0x1be5}, {0x1be7, 0x1bf1}, 
            {0x1c00, 0x1c36}, {0x1c4d, 0x1c4f}, {0x1c5a, 0x1c7d}, {0x1c80, 0x1c8a}, 
            {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, 
            {0x1cf5, 0x1cf6}, {0x1d00, 0x1dbf}, {0x1dd3, 0x1df4}, {0x1e00, 0x1f15}, 
            {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, 
            {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fc2, 0x1fc4}, 
            {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, 
            {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2090, 0x209c}, {0x210a, 0x2113}, 
            {0x2119, 0x211d}, {0x212a, 0x212d}, {0x212f, 0x2139}, {0x213c, 0x213f}, 
            {0x2145, 0x2149}, {0x2160, 0x2188}, {0x24b6, 0x24e9}, {0x2c00, 0x2ce4}, 
            {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d30, 0x2d67}, 
            {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, 
            {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, 
            {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, {0x3021, 0x3029}, 
            {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, 
            {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, 
            {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, 
            {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, 
            {0xa640, 0xa66e}, {0xa674, 0xa67b}, {0xa67f, 0xa6ef}, {0xa717, 0xa71f}, 
            {0xa722, 0xa788}, {0xa78b, 0xa7dc}, {0xa7f1, 0xa805}, {0xa807, 0xa827}, 
            {0xa840, 0xa873}, {0xa880, 0xa8c3}, {0xa8f2, 0xa8f7}, {0xa8fd, 0xa8ff}, 
            {0xa90a, 0xa92a}, {0xa930, 0xa952}, {0xa960, 0xa97c}, {0xa980, 0xa9b2}, 
            {0xa9b4, 0xa9bf}, {0xa9e0, 0xa9ef}, {0xa9fa, 0xa9fe}, {0xaa00, 0xaa36}, 
            {0xaa40, 0xaa4d}, {0xaa60, 0xaa76}, {0xaa7a, 0xaabe}, {0xaadb, 0xaadd}, 
            {0xaae0, 0xaaef}, {0xaaf2, 0xaaf5}, {0xab01, 0xab06}, {0xab09, 0xab0e}, 
            {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, 
            {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, 
            {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, 
            {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, 
            {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfd3d}, 
            {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfb}, {0xfe70, 0xfe74}, 
            {0xfe76, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xffbe}, 
            {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, 
            {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, 
            {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, 
            {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, 
            {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, 
            {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, 
            {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, 
            {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, 
            {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x105c0, 0x105f3}, {0x10600, 0x10736}, 
            {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, 
            {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x1080a, 0x10835}, {0x10837, 0x10838}, 
            {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, 
            {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10940, 0x10959}, 
            {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, 
            {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a60, 0x10a7c}, 
            {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, 
            {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, 
            {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d4a, 0x10d65}, 
            {0x10d6f, 0x10d85}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac}, {0x10eb0, 0x10eb1}, 
            {0x10ec2, 0x10ec7}, {0x10efa, 0x10efc}, {0x10f00, 0x10f1c}, {0x10f30, 0x10f45}, 
            {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11045}, 
            {0x11071, 0x11075}, {0x11080, 0x110b8}, {0x110d0, 0x110e8}, {0x11100, 0x11132}, 
            {0x11144, 0x11147}, {0x11150, 0x11172}, {0x11180, 0x111bf}, {0x111c1, 0x111c4}, 
            {0x111ce, 0x111cf}, {0x11200, 0x11211}, {0x11213, 0x11234}, {0x1123e, 0x11241}, 
            {0x11280, 0x11286}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, 
            {0x112b0, 0x112e8}, {0x11300, 0x11303}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, 
            {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, 
            {0x1133d, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134c}, {0x1135d, 0x11363}, 
            {0x11380, 0x11389}, {0x11390, 0x113b5}, {0x113b7, 0x113c0}, {0x113c7, 0x113ca}, 
            {0x113cc, 0x113cd}, {0x11400, 0x11441}, {0x11443, 0x11445}, {0x11447, 0x1144a}, 
            {0x1145f, 0x11461}, {0x11480, 0x114c1}, {0x114c4, 0x114c5}, {0x11580, 0x115b5}, 
            {0x115b8, 0x115be}, {0x115d8, 0x115dd}, {0x11600, 0x1163e}, {0x11680, 0x116b5}, 
            {0x11700, 0x1171a}, {0x1171d, 0x1172a}, {0x11740, 0x11746}, {0x11800, 0x11838}, 
            {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x1190c, 0x11913}, {0x11915, 0x11916}, 
            {0x11918, 0x11935}, {0x11937, 0x11938}, {0x1193b, 0x1193c}, {0x1193f, 0x11942}, 
            {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, {0x119da, 0x119df}, {0x119e3, 0x119e4}, 
            {0x11a00, 0x11a32}, {0x11a35, 0x11a3e}, {0x11a50, 0x11a97}, {0x11ab0, 0x11af8}, 
            {0x11b60, 0x11b67}, {0x11bc0, 0x11be0}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, 
            {0x11c38, 0x11c3e}, {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7}, {0x11ca9, 0x11cb6}, 
            {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3c, 0x11d3d}, 
            {0x11d3f, 0x11d41}, {0x11d46, 0x11d47}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, 
            {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d96}, {0x11db0, 0x11ddb}, 
            {0x11ee0, 0x11ef6}, {0x11f00, 0x11f10}, {0x11f12, 0x11f3a}, {0x11f3e, 0x11f40}, 
            {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, 
            {0x13000, 0x1342f}, {0x13441, 0x13446}, {0x13460, 0x143fa}, {0x14400, 0x14646}, 
            {0x16100, 0x1612e}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a70, 0x16abe}, 
            {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, 
            {0x16b7d, 0x16b8f}, {0x16d40, 0x16d6c}, {0x16d80, 0x16d9c}, {0x16e40, 0x16e7f}, 
            {0x16ea0, 0x16eb8}, {0x16ebb, 0x16ed3}, {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, 
            {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16ff0, 0x16ff6}, {0x17000, 0x18cd5}, 
            {0x18cff, 0x18d1e}, {0x18d80, 0x18df2}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, 
            {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b150, 0x1b152}, {0x1b164, 0x1b167}, 
            {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, 
            {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, 
            {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, 
            {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, 
            {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, 
            {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, 
            {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, 
            {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, 
            {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018}, 
            {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e030, 0x1e06d}, 
            {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d}, {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, 
            {0x1e4d0, 0x1e4eb}, {0x1e5d0, 0x1e5ed}, {0x1e6c0, 0x1e6de}, {0x1e6e0, 0x1e6f5}, 
            {0x1e6fe, 0x1e6ff}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, 
            {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, {0x1e900, 0x1e943}, {0x1ee00, 0x1ee03}, 
            {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, 
            {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, 
            {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, 
            {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, 
            {0x1f130, 0x1f149}, {0x1f150, 0x1f169}, {0x1f170, 0x1f189}, {0x20000, 0x2a6df}, 
            {0x2a700, 0x2b81d}, {0x2b820, 0x2cead}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, 
            {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x33479}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass44()
{
    // Name = Lowercase, number of codePoints: 2595
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x61, 0x7a}}),
        std::initializer_list<char32_t>({0x00aa, 0x00b5, 0x00ba, 0x0101, 0x0103, 0x0105, 0x0107, 0x0109, 
            0x010b, 0x010d, 0x010f, 0x0111, 0x0113, 0x0115, 0x0117, 0x0119, 
            0x011b, 0x011d, 0x011f, 0x0121, 0x0123, 0x0125, 0x0127, 0x0129, 
            0x012b, 0x012d, 0x012f, 0x0131, 0x0133, 0x0135, 0x013a, 0x013c, 
            0x013e, 0x0140, 0x0142, 0x0144, 0x0146, 0x014b, 0x014d, 0x014f, 
            0x0151, 0x0153, 0x0155, 0x0157, 0x0159, 0x015b, 0x015d, 0x015f, 
            0x0161, 0x0163, 0x0165, 0x0167, 0x0169, 0x016b, 0x016d, 0x016f, 
            0x0171, 0x0173, 0x0175, 0x0177, 0x017a, 0x017c, 0x0183, 0x0185, 
            0x0188, 0x0192, 0x0195, 0x019e, 0x01a1, 0x01a3, 0x01a5, 0x01a8, 
            0x01ad, 0x01b0, 0x01b4, 0x01b6, 0x01c6, 0x01c9, 0x01cc, 0x01ce, 
            0x01d0, 0x01d2, 0x01d4, 0x01d6, 0x01d8, 0x01da, 0x01df, 0x01e1, 
            0x01e3, 0x01e5, 0x01e7, 0x01e9, 0x01eb, 0x01ed, 0x01f3, 0x01f5, 
            0x01f9, 0x01fb, 0x01fd, 0x01ff, 0x0201, 0x0203, 0x0205, 0x0207, 
            0x0209, 0x020b, 0x020d, 0x020f, 0x0211, 0x0213, 0x0215, 0x0217, 
            0x0219, 0x021b, 0x021d, 0x021f, 0x0221, 0x0223, 0x0225, 0x0227, 
            0x0229, 0x022b, 0x022d, 0x022f, 0x0231, 0x023c, 0x0242, 0x0247, 
            0x0249, 0x024b, 0x024d, 0x0345, 0x0371, 0x0373, 0x0377, 0x0390, 
            0x03d9, 0x03db, 0x03dd, 0x03df, 0x03e1, 0x03e3, 0x03e5, 0x03e7, 
            0x03e9, 0x03eb, 0x03ed, 0x03f5, 0x03f8, 0x0461, 0x0463, 0x0465, 
            0x0467, 0x0469, 0x046b, 0x046d, 0x046f, 0x0471, 0x0473, 0x0475, 
            0x0477, 0x0479, 0x047b, 0x047d, 0x047f, 0x0481, 0x048b, 0x048d, 
            0x048f, 0x0491, 0x0493, 0x0495, 0x0497, 0x0499, 0x049b, 0x049d, 
            0x049f, 0x04a1, 0x04a3, 0x04a5, 0x04a7, 0x04a9, 0x04ab, 0x04ad, 
            0x04af, 0x04b1, 0x04b3, 0x04b5, 0x04b7, 0x04b9, 0x04bb, 0x04bd, 
            0x04bf, 0x04c2, 0x04c4, 0x04c6, 0x04c8, 0x04ca, 0x04cc, 0x04d1, 
            0x04d3, 0x04d5, 0x04d7, 0x04d9, 0x04db, 0x04dd, 0x04df, 0x04e1, 
            0x04e3, 0x04e5, 0x04e7, 0x04e9, 0x04eb, 0x04ed, 0x04ef, 0x04f1, 
            0x04f3, 0x04f5, 0x04f7, 0x04f9, 0x04fb, 0x04fd, 0x04ff, 0x0501, 
            0x0503, 0x0505, 0x0507, 0x0509, 0x050b, 0x050d, 0x050f, 0x0511, 
            0x0513, 0x0515, 0x0517, 0x0519, 0x051b, 0x051d, 0x051f, 0x0521, 
            0x0523, 0x0525, 0x0527, 0x0529, 0x052b, 0x052d, 0x052f, 0x1c8a, 
            0x1e01, 0x1e03, 0x1e05, 0x1e07, 0x1e09, 0x1e0b, 0x1e0d, 0x1e0f, 
            0x1e11, 0x1e13, 0x1e15, 0x1e17, 0x1e19, 0x1e1b, 0x1e1d, 0x1e1f, 
            0x1e21, 0x1e23, 0x1e25, 0x1e27, 0x1e29, 0x1e2b, 0x1e2d, 0x1e2f, 
            0x1e31, 0x1e33, 0x1e35, 0x1e37, 0x1e39, 0x1e3b, 0x1e3d, 0x1e3f, 
            0x1e41, 0x1e43, 0x1e45, 0x1e47, 0x1e49, 0x1e4b, 0x1e4d, 0x1e4f, 
            0x1e51, 0x1e53, 0x1e55, 0x1e57, 0x1e59, 0x1e5b, 0x1e5d, 0x1e5f, 
            0x1e61, 0x1e63, 0x1e65, 0x1e67, 0x1e69, 0x1e6b, 0x1e6d, 0x1e6f, 
            0x1e71, 0x1e73, 0x1e75, 0x1e77, 0x1e79, 0x1e7b, 0x1e7d, 0x1e7f, 
            0x1e81, 0x1e83, 0x1e85, 0x1e87, 0x1e89, 0x1e8b, 0x1e8d, 0x1e8f, 
            0x1e91, 0x1e93, 0x1e9f, 0x1ea1, 0x1ea3, 0x1ea5, 0x1ea7, 0x1ea9, 
            0x1eab, 0x1ead, 0x1eaf, 0x1eb1, 0x1eb3, 0x1eb5, 0x1eb7, 0x1eb9, 
            0x1ebb, 0x1ebd, 0x1ebf, 0x1ec1, 0x1ec3, 0x1ec5, 0x1ec7, 0x1ec9, 
            0x1ecb, 0x1ecd, 0x1ecf, 0x1ed1, 0x1ed3, 0x1ed5, 0x1ed7, 0x1ed9, 
            0x1edb, 0x1edd, 0x1edf, 0x1ee1, 0x1ee3, 0x1ee5, 0x1ee7, 0x1ee9, 
            0x1eeb, 0x1eed, 0x1eef, 0x1ef1, 0x1ef3, 0x1ef5, 0x1ef7, 0x1ef9, 
            0x1efb, 0x1efd, 0x1fbe, 0x2071, 0x207f, 0x210a, 0x2113, 0x212f, 
            0x2134, 0x2139, 0x214e, 0x2184, 0x2c61, 0x2c68, 0x2c6a, 0x2c6c, 
            0x2c71, 0x2c81, 0x2c83, 0x2c85, 0x2c87, 0x2c89, 0x2c8b, 0x2c8d, 
            0x2c8f, 0x2c91, 0x2c93, 0x2c95, 0x2c97, 0x2c99, 0x2c9b, 0x2c9d, 
            0x2c9f, 0x2ca1, 0x2ca3, 0x2ca5, 0x2ca7, 0x2ca9, 0x2cab, 0x2cad, 
            0x2caf, 0x2cb1, 0x2cb3, 0x2cb5, 0x2cb7, 0x2cb9, 0x2cbb, 0x2cbd, 
            0x2cbf, 0x2cc1, 0x2cc3, 0x2cc5, 0x2cc7, 0x2cc9, 0x2ccb, 0x2ccd, 
            0x2ccf, 0x2cd1, 0x2cd3, 0x2cd5, 0x2cd7, 0x2cd9, 0x2cdb, 0x2cdd, 
            0x2cdf, 0x2ce1, 0x2cec, 0x2cee, 0x2cf3, 0x2d27, 0x2d2d, 0xa641, 
            0xa643, 0xa645, 0xa647, 0xa649, 0xa64b, 0xa64d, 0xa64f, 0xa651, 
            0xa653, 0xa655, 0xa657, 0xa659, 0xa65b, 0xa65d, 0xa65f, 0xa661, 
            0xa663, 0xa665, 0xa667, 0xa669, 0xa66b, 0xa66d, 0xa681, 0xa683, 
            0xa685, 0xa687, 0xa689, 0xa68b, 0xa68d, 0xa68f, 0xa691, 0xa693, 
            0xa695, 0xa697, 0xa699, 0xa723, 0xa725, 0xa727, 0xa729, 0xa72b, 
            0xa72d, 0xa733, 0xa735, 0xa737, 0xa739, 0xa73b, 0xa73d, 0xa73f, 
            0xa741, 0xa743, 0xa745, 0xa747, 0xa749, 0xa74b, 0xa74d, 0xa74f, 
            0xa751, 0xa753, 0xa755, 0xa757, 0xa759, 0xa75b, 0xa75d, 0xa75f, 
            0xa761, 0xa763, 0xa765, 0xa767, 0xa769, 0xa76b, 0xa76d, 0xa77a, 
            0xa77c, 0xa77f, 0xa781, 0xa783, 0xa785, 0xa787, 0xa78c, 0xa78e, 
            0xa791, 0xa797, 0xa799, 0xa79b, 0xa79d, 0xa79f, 0xa7a1, 0xa7a3, 
            0xa7a5, 0xa7a7, 0xa7a9, 0xa7af, 0xa7b5, 0xa7b7, 0xa7b9, 0xa7bb, 
            0xa7bd, 0xa7bf, 0xa7c1, 0xa7c3, 0xa7c8, 0xa7ca, 0xa7cd, 0xa7cf, 
            0xa7d1, 0xa7d3, 0xa7d5, 0xa7d7, 0xa7d9, 0xa7db, 0xa7f6, 0x10780, 
            0x1d4bb, 0x1d7cb}),
        std::initializer_list<CharacterRange>({{0x00df, 0x00f6}, {0x00f8, 0x00ff}, {0x0137, 0x0138}, {0x0148, 0x0149}, 
            {0x017e, 0x0180}, {0x018c, 0x018d}, {0x0199, 0x019b}, {0x01aa, 0x01ab}, 
            {0x01b9, 0x01ba}, {0x01bd, 0x01bf}, {0x01dc, 0x01dd}, {0x01ef, 0x01f0}, 
            {0x0233, 0x0239}, {0x023f, 0x0240}, {0x024f, 0x0293}, {0x0296, 0x02b8}, 
            {0x02c0, 0x02c1}, {0x02e0, 0x02e4}, {0x037a, 0x037d}, {0x03ac, 0x03ce}, 
            {0x03d0, 0x03d1}, {0x03d5, 0x03d7}, {0x03ef, 0x03f3}, {0x03fb, 0x03fc}, 
            {0x0430, 0x045f}, {0x04ce, 0x04cf}, {0x0560, 0x0588}, {0x10d0, 0x10fa}, 
            {0x10fc, 0x10ff}, {0x13f8, 0x13fd}, {0x1c80, 0x1c88}, {0x1d00, 0x1dbf}, 
            {0x1e95, 0x1e9d}, {0x1eff, 0x1f07}, {0x1f10, 0x1f15}, {0x1f20, 0x1f27}, 
            {0x1f30, 0x1f37}, {0x1f40, 0x1f45}, {0x1f50, 0x1f57}, {0x1f60, 0x1f67}, 
            {0x1f70, 0x1f7d}, {0x1f80, 0x1f87}, {0x1f90, 0x1f97}, {0x1fa0, 0x1fa7}, 
            {0x1fb0, 0x1fb4}, {0x1fb6, 0x1fb7}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fc7}, 
            {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fd7}, {0x1fe0, 0x1fe7}, {0x1ff2, 0x1ff4}, 
            {0x1ff6, 0x1ff7}, {0x2090, 0x209c}, {0x210e, 0x210f}, {0x213c, 0x213d}, 
            {0x2146, 0x2149}, {0x2170, 0x217f}, {0x24d0, 0x24e9}, {0x2c30, 0x2c5f}, 
            {0x2c65, 0x2c66}, {0x2c73, 0x2c74}, {0x2c76, 0x2c7d}, {0x2ce3, 0x2ce4}, 
            {0x2d00, 0x2d25}, {0xa69b, 0xa69d}, {0xa72f, 0xa731}, {0xa76f, 0xa778}, 
            {0xa793, 0xa795}, {0xa7f1, 0xa7f4}, {0xa7f8, 0xa7fa}, {0xab30, 0xab5a}, 
            {0xab5c, 0xab69}, {0xab70, 0xabbf}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, 
            {0xff41, 0xff5a}, {0x10428, 0x1044f}, {0x104d8, 0x104fb}, {0x10597, 0x105a1}, 
            {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10783, 0x10785}, 
            {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10cc0, 0x10cf2}, {0x10d70, 0x10d85}, 
            {0x118c0, 0x118df}, {0x16e60, 0x16e7f}, {0x16ebb, 0x16ed3}, {0x1d41a, 0x1d433}, 
            {0x1d44e, 0x1d454}, {0x1d456, 0x1d467}, {0x1d482, 0x1d49b}, {0x1d4b6, 0x1d4b9}, 
            {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d4cf}, {0x1d4ea, 0x1d503}, {0x1d51e, 0x1d537}, 
            {0x1d552, 0x1d56b}, {0x1d586, 0x1d59f}, {0x1d5ba, 0x1d5d3}, {0x1d5ee, 0x1d607}, 
            {0x1d622, 0x1d63b}, {0x1d656, 0x1d66f}, {0x1d68a, 0x1d6a5}, {0x1d6c2, 0x1d6da}, 
            {0x1d6dc, 0x1d6e1}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d71b}, {0x1d736, 0x1d74e}, 
            {0x1d750, 0x1d755}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d78f}, {0x1d7aa, 0x1d7c2}, 
            {0x1d7c4, 0x1d7c9}, {0x1df00, 0x1df09}, {0x1df0b, 0x1df1e}, {0x1df25, 0x1df2a}, 
            {0x1e030, 0x1e06d}, {0x1e922, 0x1e943}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass45()
{
    // Name = Uppercase, number of codePoints: 2006
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}}),
        std::initializer_list<char32_t>({0x0100, 0x0102, 0x0104, 0x0106, 0x0108, 0x010a, 0x010c, 0x010e, 
            0x0110, 0x0112, 0x0114, 0x0116, 0x0118, 0x011a, 0x011c, 0x011e, 
            0x0120, 0x0122, 0x0124, 0x0126, 0x0128, 0x012a, 0x012c, 0x012e, 
            0x0130, 0x0132, 0x0134, 0x0136, 0x0139, 0x013b, 0x013d, 0x013f, 
            0x0141, 0x0143, 0x0145, 0x0147, 0x014a, 0x014c, 0x014e, 0x0150, 
            0x0152, 0x0154, 0x0156, 0x0158, 0x015a, 0x015c, 0x015e, 0x0160, 
            0x0162, 0x0164, 0x0166, 0x0168, 0x016a, 0x016c, 0x016e, 0x0170, 
            0x0172, 0x0174, 0x0176, 0x017b, 0x017d, 0x0184, 0x01a2, 0x01a4, 
            0x01a9, 0x01ac, 0x01b5, 0x01bc, 0x01c4, 0x01c7, 0x01ca, 0x01cd, 
            0x01cf, 0x01d1, 0x01d3, 0x01d5, 0x01d7, 0x01d9, 0x01db, 0x01de, 
            0x01e0, 0x01e2, 0x01e4, 0x01e6, 0x01e8, 0x01ea, 0x01ec, 0x01ee, 
            0x01f1, 0x01f4, 0x01fa, 0x01fc, 0x01fe, 0x0200, 0x0202, 0x0204, 
            0x0206, 0x0208, 0x020a, 0x020c, 0x020e, 0x0210, 0x0212, 0x0214, 
            0x0216, 0x0218, 0x021a, 0x021c, 0x021e, 0x0220, 0x0222, 0x0224, 
            0x0226, 0x0228, 0x022a, 0x022c, 0x022e, 0x0230, 0x0232, 0x0241, 
            0x0248, 0x024a, 0x024c, 0x024e, 0x0370, 0x0372, 0x0376, 0x037f, 
            0x0386, 0x038c, 0x03cf, 0x03d8, 0x03da, 0x03dc, 0x03de, 0x03e0, 
            0x03e2, 0x03e4, 0x03e6, 0x03e8, 0x03ea, 0x03ec, 0x03ee, 0x03f4, 
            0x03f7, 0x0460, 0x0462, 0x0464, 0x0466, 0x0468, 0x046a, 0x046c, 
            0x046e, 0x0470, 0x0472, 0x0474, 0x0476, 0x0478, 0x047a, 0x047c, 
            0x047e, 0x0480, 0x048a, 0x048c, 0x048e, 0x0490, 0x0492, 0x0494, 
            0x0496, 0x0498, 0x049a, 0x049c, 0x049e, 0x04a0, 0x04a2, 0x04a4, 
            0x04a6, 0x04a8, 0x04aa, 0x04ac, 0x04ae, 0x04b0, 0x04b2, 0x04b4, 
            0x04b6, 0x04b8, 0x04ba, 0x04bc, 0x04be, 0x04c3, 0x04c5, 0x04c7, 
            0x04c9, 0x04cb, 0x04cd, 0x04d0, 0x04d2, 0x04d4, 0x04d6, 0x04d8, 
            0x04da, 0x04dc, 0x04de, 0x04e0, 0x04e2, 0x04e4, 0x04e6, 0x04e8, 
            0x04ea, 0x04ec, 0x04ee, 0x04f0, 0x04f2, 0x04f4, 0x04f6, 0x04f8, 
            0x04fa, 0x04fc, 0x04fe, 0x0500, 0x0502, 0x0504, 0x0506, 0x0508, 
            0x050a, 0x050c, 0x050e, 0x0510, 0x0512, 0x0514, 0x0516, 0x0518, 
            0x051a, 0x051c, 0x051e, 0x0520, 0x0522, 0x0524, 0x0526, 0x0528, 
            0x052a, 0x052c, 0x052e, 0x10c7, 0x10cd, 0x1c89, 0x1e00, 0x1e02, 
            0x1e04, 0x1e06, 0x1e08, 0x1e0a, 0x1e0c, 0x1e0e, 0x1e10, 0x1e12, 
            0x1e14, 0x1e16, 0x1e18, 0x1e1a, 0x1e1c, 0x1e1e, 0x1e20, 0x1e22, 
            0x1e24, 0x1e26, 0x1e28, 0x1e2a, 0x1e2c, 0x1e2e, 0x1e30, 0x1e32, 
            0x1e34, 0x1e36, 0x1e38, 0x1e3a, 0x1e3c, 0x1e3e, 0x1e40, 0x1e42, 
            0x1e44, 0x1e46, 0x1e48, 0x1e4a, 0x1e4c, 0x1e4e, 0x1e50, 0x1e52, 
            0x1e54, 0x1e56, 0x1e58, 0x1e5a, 0x1e5c, 0x1e5e, 0x1e60, 0x1e62, 
            0x1e64, 0x1e66, 0x1e68, 0x1e6a, 0x1e6c, 0x1e6e, 0x1e70, 0x1e72, 
            0x1e74, 0x1e76, 0x1e78, 0x1e7a, 0x1e7c, 0x1e7e, 0x1e80, 0x1e82, 
            0x1e84, 0x1e86, 0x1e88, 0x1e8a, 0x1e8c, 0x1e8e, 0x1e90, 0x1e92, 
            0x1e94, 0x1e9e, 0x1ea0, 0x1ea2, 0x1ea4, 0x1ea6, 0x1ea8, 0x1eaa, 
            0x1eac, 0x1eae, 0x1eb0, 0x1eb2, 0x1eb4, 0x1eb6, 0x1eb8, 0x1eba, 
            0x1ebc, 0x1ebe, 0x1ec0, 0x1ec2, 0x1ec4, 0x1ec6, 0x1ec8, 0x1eca, 
            0x1ecc, 0x1ece, 0x1ed0, 0x1ed2, 0x1ed4, 0x1ed6, 0x1ed8, 0x1eda, 
            0x1edc, 0x1ede, 0x1ee0, 0x1ee2, 0x1ee4, 0x1ee6, 0x1ee8, 0x1eea, 
            0x1eec, 0x1eee, 0x1ef0, 0x1ef2, 0x1ef4, 0x1ef6, 0x1ef8, 0x1efa, 
            0x1efc, 0x1efe, 0x1f59, 0x1f5b, 0x1f5d, 0x1f5f, 0x2102, 0x2107, 
            0x2115, 0x2124, 0x2126, 0x2128, 0x2145, 0x2183, 0x2c60, 0x2c67, 
            0x2c69, 0x2c6b, 0x2c72, 0x2c75, 0x2c82, 0x2c84, 0x2c86, 0x2c88, 
            0x2c8a, 0x2c8c, 0x2c8e, 0x2c90, 0x2c92, 0x2c94, 0x2c96, 0x2c98, 
            0x2c9a, 0x2c9c, 0x2c9e, 0x2ca0, 0x2ca2, 0x2ca4, 0x2ca6, 0x2ca8, 
            0x2caa, 0x2cac, 0x2cae, 0x2cb0, 0x2cb2, 0x2cb4, 0x2cb6, 0x2cb8, 
            0x2cba, 0x2cbc, 0x2cbe, 0x2cc0, 0x2cc2, 0x2cc4, 0x2cc6, 0x2cc8, 
            0x2cca, 0x2ccc, 0x2cce, 0x2cd0, 0x2cd2, 0x2cd4, 0x2cd6, 0x2cd8, 
            0x2cda, 0x2cdc, 0x2cde, 0x2ce0, 0x2ce2, 0x2ceb, 0x2ced, 0x2cf2, 
            0xa640, 0xa642, 0xa644, 0xa646, 0xa648, 0xa64a, 0xa64c, 0xa64e, 
            0xa650, 0xa652, 0xa654, 0xa656, 0xa658, 0xa65a, 0xa65c, 0xa65e, 
            0xa660, 0xa662, 0xa664, 0xa666, 0xa668, 0xa66a, 0xa66c, 0xa680, 
            0xa682, 0xa684, 0xa686, 0xa688, 0xa68a, 0xa68c, 0xa68e, 0xa690, 
            0xa692, 0xa694, 0xa696, 0xa698, 0xa69a, 0xa722, 0xa724, 0xa726, 
            0xa728, 0xa72a, 0xa72c, 0xa72e, 0xa732, 0xa734, 0xa736, 0xa738, 
            0xa73a, 0xa73c, 0xa73e, 0xa740, 0xa742, 0xa744, 0xa746, 0xa748, 
            0xa74a, 0xa74c, 0xa74e, 0xa750, 0xa752, 0xa754, 0xa756, 0xa758, 
            0xa75a, 0xa75c, 0xa75e, 0xa760, 0xa762, 0xa764, 0xa766, 0xa768, 
            0xa76a, 0xa76c, 0xa76e, 0xa779, 0xa77b, 0xa780, 0xa782, 0xa784, 
            0xa786, 0xa78b, 0xa78d, 0xa790, 0xa792, 0xa796, 0xa798, 0xa79a, 
            0xa79c, 0xa79e, 0xa7a0, 0xa7a2, 0xa7a4, 0xa7a6, 0xa7a8, 0xa7b6, 
            0xa7b8, 0xa7ba, 0xa7bc, 0xa7be, 0xa7c0, 0xa7c2, 0xa7c9, 0xa7ce, 
            0xa7d0, 0xa7d2, 0xa7d4, 0xa7d6, 0xa7d8, 0xa7da, 0xa7dc, 0xa7f5, 
            0x1d49c, 0x1d4a2, 0x1d546, 0x1d7ca}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00de}, {0x0178, 0x0179}, {0x0181, 0x0182}, 
            {0x0186, 0x0187}, {0x0189, 0x018b}, {0x018e, 0x0191}, {0x0193, 0x0194}, 
            {0x0196, 0x0198}, {0x019c, 0x019d}, {0x019f, 0x01a0}, {0x01a6, 0x01a7}, 
            {0x01ae, 0x01af}, {0x01b1, 0x01b3}, {0x01b7, 0x01b8}, {0x01f6, 0x01f8}, 
            {0x023a, 0x023b}, {0x023d, 0x023e}, {0x0243, 0x0246}, {0x0388, 0x038a}, 
            {0x038e, 0x038f}, {0x0391, 0x03a1}, {0x03a3, 0x03ab}, {0x03d2, 0x03d4}, 
            {0x03f9, 0x03fa}, {0x03fd, 0x042f}, {0x04c0, 0x04c1}, {0x0531, 0x0556}, 
            {0x10a0, 0x10c5}, {0x13a0, 0x13f5}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, 
            {0x1f08, 0x1f0f}, {0x1f18, 0x1f1d}, {0x1f28, 0x1f2f}, {0x1f38, 0x1f3f}, 
            {0x1f48, 0x1f4d}, {0x1f68, 0x1f6f}, {0x1fb8, 0x1fbb}, {0x1fc8, 0x1fcb}, 
            {0x1fd8, 0x1fdb}, {0x1fe8, 0x1fec}, {0x1ff8, 0x1ffb}, {0x210b, 0x210d}, 
            {0x2110, 0x2112}, {0x2119, 0x211d}, {0x212a, 0x212d}, {0x2130, 0x2133}, 
            {0x213e, 0x213f}, {0x2160, 0x216f}, {0x24b6, 0x24cf}, {0x2c00, 0x2c2f}, 
            {0x2c62, 0x2c64}, {0x2c6d, 0x2c70}, {0x2c7e, 0x2c80}, {0xa77d, 0xa77e}, 
            {0xa7aa, 0xa7ae}, {0xa7b0, 0xa7b4}, {0xa7c4, 0xa7c7}, {0xa7cb, 0xa7cc}, 
            {0xff21, 0xff3a}, {0x10400, 0x10427}, {0x104b0, 0x104d3}, {0x10570, 0x1057a}, 
            {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10c80, 0x10cb2}, 
            {0x10d50, 0x10d65}, {0x118a0, 0x118bf}, {0x16e40, 0x16e5f}, {0x16ea0, 0x16eb8}, 
            {0x1d400, 0x1d419}, {0x1d434, 0x1d44d}, {0x1d468, 0x1d481}, {0x1d49e, 0x1d49f}, 
            {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b5}, {0x1d4d0, 0x1d4e9}, 
            {0x1d504, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, 
            {0x1d538, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, 
            {0x1d56c, 0x1d585}, {0x1d5a0, 0x1d5b9}, {0x1d5d4, 0x1d5ed}, {0x1d608, 0x1d621}, 
            {0x1d63c, 0x1d655}, {0x1d670, 0x1d689}, {0x1d6a8, 0x1d6c0}, {0x1d6e2, 0x1d6fa}, 
            {0x1d71c, 0x1d734}, {0x1d756, 0x1d76e}, {0x1d790, 0x1d7a8}, {0x1e900, 0x1e921}, 
            {0x1f130, 0x1f149}, {0x1f150, 0x1f169}, {0x1f170, 0x1f189}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass46()
{
    // Name = Cased, number of codePoints: 4632
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<char32_t>({0x00aa, 0x00b5, 0x00ba, 0x0345, 0x037f, 0x0386, 0x038c, 0x10c7, 
            0x10cd, 0x1f59, 0x1f5b, 0x1f5d, 0x1fbe, 0x2071, 0x207f, 0x2102, 
            0x2107, 0x2115, 0x2124, 0x2126, 0x2128, 0x2139, 0x214e, 0x2d27, 
            0x2d2d, 0x10780, 0x1d4a2, 0x1d4bb, 0x1d546}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x01ba}, {0x01bc, 0x01bf}, 
            {0x01c4, 0x0293}, {0x0296, 0x02b8}, {0x02c0, 0x02c1}, {0x02e0, 0x02e4}, 
            {0x0370, 0x0373}, {0x0376, 0x0377}, {0x037a, 0x037d}, {0x0388, 0x038a}, 
            {0x038e, 0x03a1}, {0x03a3, 0x03f5}, {0x03f7, 0x0481}, {0x048a, 0x052f}, 
            {0x0531, 0x0556}, {0x0560, 0x0588}, {0x10a0, 0x10c5}, {0x10d0, 0x10fa}, 
            {0x10fc, 0x10ff}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1c80, 0x1c8a}, 
            {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, 
            {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, 
            {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fc2, 0x1fc4}, 
            {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, 
            {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2090, 0x209c}, {0x210a, 0x2113}, 
            {0x2119, 0x211d}, {0x212a, 0x212d}, {0x212f, 0x2134}, {0x213c, 0x213f}, 
            {0x2145, 0x2149}, {0x2160, 0x217f}, {0x2183, 0x2184}, {0x24b6, 0x24e9}, 
            {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, 
            {0xa640, 0xa66d}, {0xa680, 0xa69d}, {0xa722, 0xa787}, {0xa78b, 0xa78e}, 
            {0xa790, 0xa7dc}, {0xa7f1, 0xa7f6}, {0xa7f8, 0xa7fa}, {0xab30, 0xab5a}, 
            {0xab5c, 0xab69}, {0xab70, 0xabbf}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, 
            {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0x10400, 0x1044f}, {0x104b0, 0x104d3}, 
            {0x104d8, 0x104fb}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, 
            {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, 
            {0x105bb, 0x105bc}, {0x10783, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, 
            {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d50, 0x10d65}, {0x10d70, 0x10d85}, 
            {0x118a0, 0x118df}, {0x16e40, 0x16e7f}, {0x16ea0, 0x16eb8}, {0x16ebb, 0x16ed3}, 
            {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, 
            {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, 
            {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, 
            {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, 
            {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, 
            {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, 
            {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df09}, 
            {0x1df0b, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e030, 0x1e06d}, {0x1e900, 0x1e943}, 
            {0x1f130, 0x1f149}, {0x1f150, 0x1f169}, {0x1f170, 0x1f189}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass47()
{
    // Name = Case_Ignorable, number of codePoints: 2798
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x27, 0x2e, 0x3a, 0x5e, 0x60}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00a8, 0x00ad, 0x00af, 0x00b4, 0x037a, 0x0387, 0x0559, 0x055f, 
            0x05bf, 0x05c7, 0x05f4, 0x061c, 0x0640, 0x0670, 0x070f, 0x0711, 
            0x07fa, 0x07fd, 0x0888, 0x093a, 0x093c, 0x094d, 0x0971, 0x0981, 
            0x09bc, 0x09cd, 0x09fe, 0x0a3c, 0x0a51, 0x0a75, 0x0abc, 0x0acd, 
            0x0b01, 0x0b3c, 0x0b3f, 0x0b4d, 0x0b82, 0x0bc0, 0x0bcd, 0x0c00, 
            0x0c04, 0x0c3c, 0x0c81, 0x0cbc, 0x0cbf, 0x0cc6, 0x0d4d, 0x0d81, 
            0x0dca, 0x0dd6, 0x0e31, 0x0eb1, 0x0ec6, 0x0f35, 0x0f37, 0x0f39, 
            0x0fc6, 0x1082, 0x108d, 0x109d, 0x10fc, 0x17c6, 0x17d7, 0x17dd, 
            0x1843, 0x18a9, 0x1932, 0x1a1b, 0x1a56, 0x1a60, 0x1a62, 0x1a7f, 
            0x1aa7, 0x1b34, 0x1b3c, 0x1b42, 0x1be6, 0x1bed, 0x1ced, 0x1cf4, 
            0x1d78, 0x1fbd, 0x2024, 0x2027, 0x2071, 0x207f, 0x2d6f, 0x2d7f, 
            0x2e2f, 0x3005, 0x303b, 0xa015, 0xa60c, 0xa67f, 0xa770, 0xa802, 
            0xa806, 0xa80b, 0xa82c, 0xa8ff, 0xa9b3, 0xa9cf, 0xaa43, 0xaa4c, 
            0xaa70, 0xaa7c, 0xaab0, 0xaac1, 0xaadd, 0xaaf6, 0xabe5, 0xabe8, 
            0xabed, 0xfb1e, 0xfe13, 0xfe52, 0xfe55, 0xfeff, 0xff07, 0xff0e, 
            0xff1a, 0xff3e, 0xff40, 0xff70, 0xffe3, 0x101fd, 0x102e0, 0x10a3f, 
            0x10d4e, 0x10d6f, 0x10ec5, 0x11001, 0x11070, 0x110bd, 0x110c2, 0x110cd, 
            0x11173, 0x111cf, 0x11234, 0x1123e, 0x11241, 0x112df, 0x11340, 0x113ce, 
            0x113d0, 0x113d2, 0x11446, 0x1145e, 0x114ba, 0x1163d, 0x116ab, 0x116ad, 
            0x116b7, 0x1171d, 0x1171f, 0x1193e, 0x11943, 0x119e0, 0x11a47, 0x11b60, 
            0x11b66, 0x11c3f, 0x11d3a, 0x11d47, 0x11d95, 0x11d97, 0x11dd9, 0x11f40, 
            0x11f42, 0x11f5a, 0x16d98, 0x16d9d, 0x16f4f, 0x1da75, 0x1da84, 0x1e08f, 
            0x1e2ae, 0x1e6e3, 0x1e6e6, 0x1e6f5, 0x1e6ff, 0xe0001}),
        std::initializer_list<CharacterRange>({{0x00b7, 0x00b8}, {0x02b0, 0x036f}, {0x0374, 0x0375}, {0x0384, 0x0385}, 
            {0x0483, 0x0489}, {0x0591, 0x05bd}, {0x05c1, 0x05c2}, {0x05c4, 0x05c5}, 
            {0x0600, 0x0605}, {0x0610, 0x061a}, {0x064b, 0x065f}, {0x06d6, 0x06dd}, 
            {0x06df, 0x06e8}, {0x06ea, 0x06ed}, {0x0730, 0x074a}, {0x07a6, 0x07b0}, 
            {0x07eb, 0x07f5}, {0x0816, 0x082d}, {0x0859, 0x085b}, {0x0890, 0x0891}, 
            {0x0897, 0x089f}, {0x08c9, 0x0902}, {0x0941, 0x0948}, {0x0951, 0x0957}, 
            {0x0962, 0x0963}, {0x09c1, 0x09c4}, {0x09e2, 0x09e3}, {0x0a01, 0x0a02}, 
            {0x0a41, 0x0a42}, {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a70, 0x0a71}, 
            {0x0a81, 0x0a82}, {0x0ac1, 0x0ac5}, {0x0ac7, 0x0ac8}, {0x0ae2, 0x0ae3}, 
            {0x0afa, 0x0aff}, {0x0b41, 0x0b44}, {0x0b53, 0x0b56}, {0x0b62, 0x0b63}, 
            {0x0c3e, 0x0c40}, {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56}, 
            {0x0c62, 0x0c63}, {0x0ccc, 0x0ccd}, {0x0ce2, 0x0ce3}, {0x0d00, 0x0d01}, 
            {0x0d3b, 0x0d3c}, {0x0d41, 0x0d44}, {0x0d62, 0x0d63}, {0x0dd2, 0x0dd4}, 
            {0x0e34, 0x0e3a}, {0x0e46, 0x0e4e}, {0x0eb4, 0x0ebc}, {0x0ec8, 0x0ece}, 
            {0x0f18, 0x0f19}, {0x0f71, 0x0f7e}, {0x0f80, 0x0f84}, {0x0f86, 0x0f87}, 
            {0x0f8d, 0x0f97}, {0x0f99, 0x0fbc}, {0x102d, 0x1030}, {0x1032, 0x1037}, 
            {0x1039, 0x103a}, {0x103d, 0x103e}, {0x1058, 0x1059}, {0x105e, 0x1060}, 
            {0x1071, 0x1074}, {0x1085, 0x1086}, {0x135d, 0x135f}, {0x1712, 0x1714}, 
            {0x1732, 0x1733}, {0x1752, 0x1753}, {0x1772, 0x1773}, {0x17b4, 0x17b5}, 
            {0x17b7, 0x17bd}, {0x17c9, 0x17d3}, {0x180b, 0x180f}, {0x1885, 0x1886}, 
            {0x1920, 0x1922}, {0x1927, 0x1928}, {0x1939, 0x193b}, {0x1a17, 0x1a18}, 
            {0x1a58, 0x1a5e}, {0x1a65, 0x1a6c}, {0x1a73, 0x1a7c}, {0x1ab0, 0x1add}, 
            {0x1ae0, 0x1aeb}, {0x1b00, 0x1b03}, {0x1b36, 0x1b3a}, {0x1b6b, 0x1b73}, 
            {0x1b80, 0x1b81}, {0x1ba2, 0x1ba5}, {0x1ba8, 0x1ba9}, {0x1bab, 0x1bad}, 
            {0x1be8, 0x1be9}, {0x1bef, 0x1bf1}, {0x1c2c, 0x1c33}, {0x1c36, 0x1c37}, 
            {0x1c78, 0x1c7d}, {0x1cd0, 0x1cd2}, {0x1cd4, 0x1ce0}, {0x1ce2, 0x1ce8}, 
            {0x1cf8, 0x1cf9}, {0x1d2c, 0x1d6a}, {0x1d9b, 0x1dff}, {0x1fbf, 0x1fc1}, 
            {0x1fcd, 0x1fcf}, {0x1fdd, 0x1fdf}, {0x1fed, 0x1fef}, {0x1ffd, 0x1ffe}, 
            {0x200b, 0x200f}, {0x2018, 0x2019}, {0x202a, 0x202e}, {0x2060, 0x2064}, 
            {0x2066, 0x206f}, {0x2090, 0x209c}, {0x20d0, 0x20f0}, {0x2c7c, 0x2c7d}, 
            {0x2cef, 0x2cf1}, {0x2de0, 0x2dff}, {0x302a, 0x302d}, {0x3031, 0x3035}, 
            {0x3099, 0x309e}, {0x30fc, 0x30fe}, {0xa4f8, 0xa4fd}, {0xa66f, 0xa672}, 
            {0xa674, 0xa67d}, {0xa69c, 0xa69f}, {0xa6f0, 0xa6f1}, {0xa700, 0xa721}, 
            {0xa788, 0xa78a}, {0xa7f1, 0xa7f4}, {0xa7f8, 0xa7f9}, {0xa825, 0xa826}, 
            {0xa8c4, 0xa8c5}, {0xa8e0, 0xa8f1}, {0xa926, 0xa92d}, {0xa947, 0xa951}, 
            {0xa980, 0xa982}, {0xa9b6, 0xa9b9}, {0xa9bc, 0xa9bd}, {0xa9e5, 0xa9e6}, 
            {0xaa29, 0xaa2e}, {0xaa31, 0xaa32}, {0xaa35, 0xaa36}, {0xaab2, 0xaab4}, 
            {0xaab7, 0xaab8}, {0xaabe, 0xaabf}, {0xaaec, 0xaaed}, {0xaaf3, 0xaaf4}, 
            {0xab5b, 0xab5f}, {0xab69, 0xab6b}, {0xfbb2, 0xfbc2}, {0xfe00, 0xfe0f}, 
            {0xfe20, 0xfe2f}, {0xff9e, 0xff9f}, {0xfff9, 0xfffb}, {0x10376, 0x1037a}, 
            {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10a01, 0x10a03}, 
            {0x10a05, 0x10a06}, {0x10a0c, 0x10a0f}, {0x10a38, 0x10a3a}, {0x10ae5, 0x10ae6}, 
            {0x10d24, 0x10d27}, {0x10d69, 0x10d6d}, {0x10eab, 0x10eac}, {0x10efa, 0x10eff}, 
            {0x10f46, 0x10f50}, {0x10f82, 0x10f85}, {0x11038, 0x11046}, {0x11073, 0x11074}, 
            {0x1107f, 0x11081}, {0x110b3, 0x110b6}, {0x110b9, 0x110ba}, {0x11100, 0x11102}, 
            {0x11127, 0x1112b}, {0x1112d, 0x11134}, {0x11180, 0x11181}, {0x111b6, 0x111be}, 
            {0x111c9, 0x111cc}, {0x1122f, 0x11231}, {0x11236, 0x11237}, {0x112e3, 0x112ea}, 
            {0x11300, 0x11301}, {0x1133b, 0x1133c}, {0x11366, 0x1136c}, {0x11370, 0x11374}, 
            {0x113bb, 0x113c0}, {0x113e1, 0x113e2}, {0x11438, 0x1143f}, {0x11442, 0x11444}, 
            {0x114b3, 0x114b8}, {0x114bf, 0x114c0}, {0x114c2, 0x114c3}, {0x115b2, 0x115b5}, 
            {0x115bc, 0x115bd}, {0x115bf, 0x115c0}, {0x115dc, 0x115dd}, {0x11633, 0x1163a}, 
            {0x1163f, 0x11640}, {0x116b0, 0x116b5}, {0x11722, 0x11725}, {0x11727, 0x1172b}, 
            {0x1182f, 0x11837}, {0x11839, 0x1183a}, {0x1193b, 0x1193c}, {0x119d4, 0x119d7}, 
            {0x119da, 0x119db}, {0x11a01, 0x11a0a}, {0x11a33, 0x11a38}, {0x11a3b, 0x11a3e}, 
            {0x11a51, 0x11a56}, {0x11a59, 0x11a5b}, {0x11a8a, 0x11a96}, {0x11a98, 0x11a99}, 
            {0x11b62, 0x11b64}, {0x11c30, 0x11c36}, {0x11c38, 0x11c3d}, {0x11c92, 0x11ca7}, 
            {0x11caa, 0x11cb0}, {0x11cb2, 0x11cb3}, {0x11cb5, 0x11cb6}, {0x11d31, 0x11d36}, 
            {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d45}, {0x11d90, 0x11d91}, {0x11ef3, 0x11ef4}, 
            {0x11f00, 0x11f01}, {0x11f36, 0x11f3a}, {0x13430, 0x13440}, {0x13447, 0x13455}, 
            {0x1611e, 0x16129}, {0x1612d, 0x1612f}, {0x16af0, 0x16af4}, {0x16b30, 0x16b36}, 
            {0x16b40, 0x16b43}, {0x16d40, 0x16d42}, {0x16d6b, 0x16d6c}, {0x16f8f, 0x16f9f}, 
            {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, {0x16ff2, 0x16ff3}, {0x1aff0, 0x1aff3}, 
            {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1bc9d, 0x1bc9e}, {0x1bca0, 0x1bca3}, 
            {0x1cf00, 0x1cf2d}, {0x1cf30, 0x1cf46}, {0x1d167, 0x1d169}, {0x1d173, 0x1d182}, 
            {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1da00, 0x1da36}, 
            {0x1da3b, 0x1da6c}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1e000, 0x1e006}, 
            {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, 
            {0x1e030, 0x1e06d}, {0x1e130, 0x1e13d}, {0x1e2ec, 0x1e2ef}, {0x1e4eb, 0x1e4ef}, 
            {0x1e5ee, 0x1e5ef}, {0x1e6ee, 0x1e6ef}, {0x1e8d0, 0x1e8d6}, {0x1e944, 0x1e94b}, 
            {0x1f3fb, 0x1f3ff}, {0xe0020, 0xe007f}, {0xe0100, 0xe01ef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass48()
{
    // Name = Changes_When_Lowercased, number of codePoints: 1488
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}}),
        std::initializer_list<char32_t>({0x0100, 0x0102, 0x0104, 0x0106, 0x0108, 0x010a, 0x010c, 0x010e, 
            0x0110, 0x0112, 0x0114, 0x0116, 0x0118, 0x011a, 0x011c, 0x011e, 
            0x0120, 0x0122, 0x0124, 0x0126, 0x0128, 0x012a, 0x012c, 0x012e, 
            0x0130, 0x0132, 0x0134, 0x0136, 0x0139, 0x013b, 0x013d, 0x013f, 
            0x0141, 0x0143, 0x0145, 0x0147, 0x014a, 0x014c, 0x014e, 0x0150, 
            0x0152, 0x0154, 0x0156, 0x0158, 0x015a, 0x015c, 0x015e, 0x0160, 
            0x0162, 0x0164, 0x0166, 0x0168, 0x016a, 0x016c, 0x016e, 0x0170, 
            0x0172, 0x0174, 0x0176, 0x017b, 0x017d, 0x0184, 0x01a2, 0x01a4, 
            0x01a9, 0x01ac, 0x01b5, 0x01bc, 0x01cd, 0x01cf, 0x01d1, 0x01d3, 
            0x01d5, 0x01d7, 0x01d9, 0x01db, 0x01de, 0x01e0, 0x01e2, 0x01e4, 
            0x01e6, 0x01e8, 0x01ea, 0x01ec, 0x01ee, 0x01f4, 0x01fa, 0x01fc, 
            0x01fe, 0x0200, 0x0202, 0x0204, 0x0206, 0x0208, 0x020a, 0x020c, 
            0x020e, 0x0210, 0x0212, 0x0214, 0x0216, 0x0218, 0x021a, 0x021c, 
            0x021e, 0x0220, 0x0222, 0x0224, 0x0226, 0x0228, 0x022a, 0x022c, 
            0x022e, 0x0230, 0x0232, 0x0241, 0x0248, 0x024a, 0x024c, 0x024e, 
            0x0370, 0x0372, 0x0376, 0x037f, 0x0386, 0x038c, 0x03cf, 0x03d8, 
            0x03da, 0x03dc, 0x03de, 0x03e0, 0x03e2, 0x03e4, 0x03e6, 0x03e8, 
            0x03ea, 0x03ec, 0x03ee, 0x03f4, 0x03f7, 0x0460, 0x0462, 0x0464, 
            0x0466, 0x0468, 0x046a, 0x046c, 0x046e, 0x0470, 0x0472, 0x0474, 
            0x0476, 0x0478, 0x047a, 0x047c, 0x047e, 0x0480, 0x048a, 0x048c, 
            0x048e, 0x0490, 0x0492, 0x0494, 0x0496, 0x0498, 0x049a, 0x049c, 
            0x049e, 0x04a0, 0x04a2, 0x04a4, 0x04a6, 0x04a8, 0x04aa, 0x04ac, 
            0x04ae, 0x04b0, 0x04b2, 0x04b4, 0x04b6, 0x04b8, 0x04ba, 0x04bc, 
            0x04be, 0x04c3, 0x04c5, 0x04c7, 0x04c9, 0x04cb, 0x04cd, 0x04d0, 
            0x04d2, 0x04d4, 0x04d6, 0x04d8, 0x04da, 0x04dc, 0x04de, 0x04e0, 
            0x04e2, 0x04e4, 0x04e6, 0x04e8, 0x04ea, 0x04ec, 0x04ee, 0x04f0, 
            0x04f2, 0x04f4, 0x04f6, 0x04f8, 0x04fa, 0x04fc, 0x04fe, 0x0500, 
            0x0502, 0x0504, 0x0506, 0x0508, 0x050a, 0x050c, 0x050e, 0x0510, 
            0x0512, 0x0514, 0x0516, 0x0518, 0x051a, 0x051c, 0x051e, 0x0520, 
            0x0522, 0x0524, 0x0526, 0x0528, 0x052a, 0x052c, 0x052e, 0x10c7, 
            0x10cd, 0x1c89, 0x1e00, 0x1e02, 0x1e04, 0x1e06, 0x1e08, 0x1e0a, 
            0x1e0c, 0x1e0e, 0x1e10, 0x1e12, 0x1e14, 0x1e16, 0x1e18, 0x1e1a, 
            0x1e1c, 0x1e1e, 0x1e20, 0x1e22, 0x1e24, 0x1e26, 0x1e28, 0x1e2a, 
            0x1e2c, 0x1e2e, 0x1e30, 0x1e32, 0x1e34, 0x1e36, 0x1e38, 0x1e3a, 
            0x1e3c, 0x1e3e, 0x1e40, 0x1e42, 0x1e44, 0x1e46, 0x1e48, 0x1e4a, 
            0x1e4c, 0x1e4e, 0x1e50, 0x1e52, 0x1e54, 0x1e56, 0x1e58, 0x1e5a, 
            0x1e5c, 0x1e5e, 0x1e60, 0x1e62, 0x1e64, 0x1e66, 0x1e68, 0x1e6a, 
            0x1e6c, 0x1e6e, 0x1e70, 0x1e72, 0x1e74, 0x1e76, 0x1e78, 0x1e7a, 
            0x1e7c, 0x1e7e, 0x1e80, 0x1e82, 0x1e84, 0x1e86, 0x1e88, 0x1e8a, 
            0x1e8c, 0x1e8e, 0x1e90, 0x1e92, 0x1e94, 0x1e9e, 0x1ea0, 0x1ea2, 
            0x1ea4, 0x1ea6, 0x1ea8, 0x1eaa, 0x1eac, 0x1eae, 0x1eb0, 0x1eb2, 
            0x1eb4, 0x1eb6, 0x1eb8, 0x1eba, 0x1ebc, 0x1ebe, 0x1ec0, 0x1ec2, 
            0x1ec4, 0x1ec6, 0x1ec8, 0x1eca, 0x1ecc, 0x1ece, 0x1ed0, 0x1ed2, 
            0x1ed4, 0x1ed6, 0x1ed8, 0x1eda, 0x1edc, 0x1ede, 0x1ee0, 0x1ee2, 
            0x1ee4, 0x1ee6, 0x1ee8, 0x1eea, 0x1eec, 0x1eee, 0x1ef0, 0x1ef2, 
            0x1ef4, 0x1ef6, 0x1ef8, 0x1efa, 0x1efc, 0x1efe, 0x1f59, 0x1f5b, 
            0x1f5d, 0x1f5f, 0x2126, 0x2132, 0x2183, 0x2c60, 0x2c67, 0x2c69, 
            0x2c6b, 0x2c72, 0x2c75, 0x2c82, 0x2c84, 0x2c86, 0x2c88, 0x2c8a, 
            0x2c8c, 0x2c8e, 0x2c90, 0x2c92, 0x2c94, 0x2c96, 0x2c98, 0x2c9a, 
            0x2c9c, 0x2c9e, 0x2ca0, 0x2ca2, 0x2ca4, 0x2ca6, 0x2ca8, 0x2caa, 
            0x2cac, 0x2cae, 0x2cb0, 0x2cb2, 0x2cb4, 0x2cb6, 0x2cb8, 0x2cba, 
            0x2cbc, 0x2cbe, 0x2cc0, 0x2cc2, 0x2cc4, 0x2cc6, 0x2cc8, 0x2cca, 
            0x2ccc, 0x2cce, 0x2cd0, 0x2cd2, 0x2cd4, 0x2cd6, 0x2cd8, 0x2cda, 
            0x2cdc, 0x2cde, 0x2ce0, 0x2ce2, 0x2ceb, 0x2ced, 0x2cf2, 0xa640, 
            0xa642, 0xa644, 0xa646, 0xa648, 0xa64a, 0xa64c, 0xa64e, 0xa650, 
            0xa652, 0xa654, 0xa656, 0xa658, 0xa65a, 0xa65c, 0xa65e, 0xa660, 
            0xa662, 0xa664, 0xa666, 0xa668, 0xa66a, 0xa66c, 0xa680, 0xa682, 
            0xa684, 0xa686, 0xa688, 0xa68a, 0xa68c, 0xa68e, 0xa690, 0xa692, 
            0xa694, 0xa696, 0xa698, 0xa69a, 0xa722, 0xa724, 0xa726, 0xa728, 
            0xa72a, 0xa72c, 0xa72e, 0xa732, 0xa734, 0xa736, 0xa738, 0xa73a, 
            0xa73c, 0xa73e, 0xa740, 0xa742, 0xa744, 0xa746, 0xa748, 0xa74a, 
            0xa74c, 0xa74e, 0xa750, 0xa752, 0xa754, 0xa756, 0xa758, 0xa75a, 
            0xa75c, 0xa75e, 0xa760, 0xa762, 0xa764, 0xa766, 0xa768, 0xa76a, 
            0xa76c, 0xa76e, 0xa779, 0xa77b, 0xa780, 0xa782, 0xa784, 0xa786, 
            0xa78b, 0xa78d, 0xa790, 0xa792, 0xa796, 0xa798, 0xa79a, 0xa79c, 
            0xa79e, 0xa7a0, 0xa7a2, 0xa7a4, 0xa7a6, 0xa7a8, 0xa7b6, 0xa7b8, 
            0xa7ba, 0xa7bc, 0xa7be, 0xa7c0, 0xa7c2, 0xa7c9, 0xa7ce, 0xa7d0, 
            0xa7d2, 0xa7d4, 0xa7d6, 0xa7d8, 0xa7da, 0xa7dc, 0xa7f5}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00de}, {0x0178, 0x0179}, {0x0181, 0x0182}, 
            {0x0186, 0x0187}, {0x0189, 0x018b}, {0x018e, 0x0191}, {0x0193, 0x0194}, 
            {0x0196, 0x0198}, {0x019c, 0x019d}, {0x019f, 0x01a0}, {0x01a6, 0x01a7}, 
            {0x01ae, 0x01af}, {0x01b1, 0x01b3}, {0x01b7, 0x01b8}, {0x01c4, 0x01c5}, 
            {0x01c7, 0x01c8}, {0x01ca, 0x01cb}, {0x01f1, 0x01f2}, {0x01f6, 0x01f8}, 
            {0x023a, 0x023b}, {0x023d, 0x023e}, {0x0243, 0x0246}, {0x0388, 0x038a}, 
            {0x038e, 0x038f}, {0x0391, 0x03a1}, {0x03a3, 0x03ab}, {0x03f9, 0x03fa}, 
            {0x03fd, 0x042f}, {0x04c0, 0x04c1}, {0x0531, 0x0556}, {0x10a0, 0x10c5}, 
            {0x13a0, 0x13f5}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1f08, 0x1f0f}, 
            {0x1f18, 0x1f1d}, {0x1f28, 0x1f2f}, {0x1f38, 0x1f3f}, {0x1f48, 0x1f4d}, 
            {0x1f68, 0x1f6f}, {0x1f88, 0x1f8f}, {0x1f98, 0x1f9f}, {0x1fa8, 0x1faf}, 
            {0x1fb8, 0x1fbc}, {0x1fc8, 0x1fcc}, {0x1fd8, 0x1fdb}, {0x1fe8, 0x1fec}, 
            {0x1ff8, 0x1ffc}, {0x212a, 0x212b}, {0x2160, 0x216f}, {0x24b6, 0x24cf}, 
            {0x2c00, 0x2c2f}, {0x2c62, 0x2c64}, {0x2c6d, 0x2c70}, {0x2c7e, 0x2c80}, 
            {0xa77d, 0xa77e}, {0xa7aa, 0xa7ae}, {0xa7b0, 0xa7b4}, {0xa7c4, 0xa7c7}, 
            {0xa7cb, 0xa7cc}, {0xff21, 0xff3a}, {0x10400, 0x10427}, {0x104b0, 0x104d3}, 
            {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, 
            {0x10c80, 0x10cb2}, {0x10d50, 0x10d65}, {0x118a0, 0x118bf}, {0x16e40, 0x16e5f}, 
            {0x16ea0, 0x16eb8}, {0x1e900, 0x1e921}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass49()
{
    // Name = Changes_When_Uppercased, number of codePoints: 1580
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x61, 0x7a}}),
        std::initializer_list<char32_t>({0x00b5, 0x0101, 0x0103, 0x0105, 0x0107, 0x0109, 0x010b, 0x010d, 
            0x010f, 0x0111, 0x0113, 0x0115, 0x0117, 0x0119, 0x011b, 0x011d, 
            0x011f, 0x0121, 0x0123, 0x0125, 0x0127, 0x0129, 0x012b, 0x012d, 
            0x012f, 0x0131, 0x0133, 0x0135, 0x0137, 0x013a, 0x013c, 0x013e, 
            0x0140, 0x0142, 0x0144, 0x0146, 0x014b, 0x014d, 0x014f, 0x0151, 
            0x0153, 0x0155, 0x0157, 0x0159, 0x015b, 0x015d, 0x015f, 0x0161, 
            0x0163, 0x0165, 0x0167, 0x0169, 0x016b, 0x016d, 0x016f, 0x0171, 
            0x0173, 0x0175, 0x0177, 0x017a, 0x017c, 0x0183, 0x0185, 0x0188, 
            0x018c, 0x0192, 0x0195, 0x019e, 0x01a1, 0x01a3, 0x01a5, 0x01a8, 
            0x01ad, 0x01b0, 0x01b4, 0x01b6, 0x01b9, 0x01bd, 0x01bf, 0x01ce, 
            0x01d0, 0x01d2, 0x01d4, 0x01d6, 0x01d8, 0x01da, 0x01df, 0x01e1, 
            0x01e3, 0x01e5, 0x01e7, 0x01e9, 0x01eb, 0x01ed, 0x01f5, 0x01f9, 
            0x01fb, 0x01fd, 0x01ff, 0x0201, 0x0203, 0x0205, 0x0207, 0x0209, 
            0x020b, 0x020d, 0x020f, 0x0211, 0x0213, 0x0215, 0x0217, 0x0219, 
            0x021b, 0x021d, 0x021f, 0x0223, 0x0225, 0x0227, 0x0229, 0x022b, 
            0x022d, 0x022f, 0x0231, 0x0233, 0x023c, 0x0242, 0x0247, 0x0249, 
            0x024b, 0x024d, 0x0259, 0x026f, 0x0275, 0x027d, 0x0280, 0x0292, 
            0x0345, 0x0371, 0x0373, 0x0377, 0x0390, 0x03d9, 0x03db, 0x03dd, 
            0x03df, 0x03e1, 0x03e3, 0x03e5, 0x03e7, 0x03e9, 0x03eb, 0x03ed, 
            0x03f5, 0x03f8, 0x03fb, 0x0461, 0x0463, 0x0465, 0x0467, 0x0469, 
            0x046b, 0x046d, 0x046f, 0x0471, 0x0473, 0x0475, 0x0477, 0x0479, 
            0x047b, 0x047d, 0x047f, 0x0481, 0x048b, 0x048d, 0x048f, 0x0491, 
            0x0493, 0x0495, 0x0497, 0x0499, 0x049b, 0x049d, 0x049f, 0x04a1, 
            0x04a3, 0x04a5, 0x04a7, 0x04a9, 0x04ab, 0x04ad, 0x04af, 0x04b1, 
            0x04b3, 0x04b5, 0x04b7, 0x04b9, 0x04bb, 0x04bd, 0x04bf, 0x04c2, 
            0x04c4, 0x04c6, 0x04c8, 0x04ca, 0x04cc, 0x04d1, 0x04d3, 0x04d5, 
            0x04d7, 0x04d9, 0x04db, 0x04dd, 0x04df, 0x04e1, 0x04e3, 0x04e5, 
            0x04e7, 0x04e9, 0x04eb, 0x04ed, 0x04ef, 0x04f1, 0x04f3, 0x04f5, 
            0x04f7, 0x04f9, 0x04fb, 0x04fd, 0x04ff, 0x0501, 0x0503, 0x0505, 
            0x0507, 0x0509, 0x050b, 0x050d, 0x050f, 0x0511, 0x0513, 0x0515, 
            0x0517, 0x0519, 0x051b, 0x051d, 0x051f, 0x0521, 0x0523, 0x0525, 
            0x0527, 0x0529, 0x052b, 0x052d, 0x052f, 0x1c8a, 0x1d79, 0x1d7d, 
            0x1d8e, 0x1e01, 0x1e03, 0x1e05, 0x1e07, 0x1e09, 0x1e0b, 0x1e0d, 
            0x1e0f, 0x1e11, 0x1e13, 0x1e15, 0x1e17, 0x1e19, 0x1e1b, 0x1e1d, 
            0x1e1f, 0x1e21, 0x1e23, 0x1e25, 0x1e27, 0x1e29, 0x1e2b, 0x1e2d, 
            0x1e2f, 0x1e31, 0x1e33, 0x1e35, 0x1e37, 0x1e39, 0x1e3b, 0x1e3d, 
            0x1e3f, 0x1e41, 0x1e43, 0x1e45, 0x1e47, 0x1e49, 0x1e4b, 0x1e4d, 
            0x1e4f, 0x1e51, 0x1e53, 0x1e55, 0x1e57, 0x1e59, 0x1e5b, 0x1e5d, 
            0x1e5f, 0x1e61, 0x1e63, 0x1e65, 0x1e67, 0x1e69, 0x1e6b, 0x1e6d, 
            0x1e6f, 0x1e71, 0x1e73, 0x1e75, 0x1e77, 0x1e79, 0x1e7b, 0x1e7d, 
            0x1e7f, 0x1e81, 0x1e83, 0x1e85, 0x1e87, 0x1e89, 0x1e8b, 0x1e8d, 
            0x1e8f, 0x1e91, 0x1e93, 0x1ea1, 0x1ea3, 0x1ea5, 0x1ea7, 0x1ea9, 
            0x1eab, 0x1ead, 0x1eaf, 0x1eb1, 0x1eb3, 0x1eb5, 0x1eb7, 0x1eb9, 
            0x1ebb, 0x1ebd, 0x1ebf, 0x1ec1, 0x1ec3, 0x1ec5, 0x1ec7, 0x1ec9, 
            0x1ecb, 0x1ecd, 0x1ecf, 0x1ed1, 0x1ed3, 0x1ed5, 0x1ed7, 0x1ed9, 
            0x1edb, 0x1edd, 0x1edf, 0x1ee1, 0x1ee3, 0x1ee5, 0x1ee7, 0x1ee9, 
            0x1eeb, 0x1eed, 0x1eef, 0x1ef1, 0x1ef3, 0x1ef5, 0x1ef7, 0x1ef9, 
            0x1efb, 0x1efd, 0x1fbc, 0x1fbe, 0x1fcc, 0x1ffc, 0x214e, 0x2184, 
            0x2c61, 0x2c68, 0x2c6a, 0x2c6c, 0x2c73, 0x2c76, 0x2c81, 0x2c83, 
            0x2c85, 0x2c87, 0x2c89, 0x2c8b, 0x2c8d, 0x2c8f, 0x2c91, 0x2c93, 
            0x2c95, 0x2c97, 0x2c99, 0x2c9b, 0x2c9d, 0x2c9f, 0x2ca1, 0x2ca3, 
            0x2ca5, 0x2ca7, 0x2ca9, 0x2cab, 0x2cad, 0x2caf, 0x2cb1, 0x2cb3, 
            0x2cb5, 0x2cb7, 0x2cb9, 0x2cbb, 0x2cbd, 0x2cbf, 0x2cc1, 0x2cc3, 
            0x2cc5, 0x2cc7, 0x2cc9, 0x2ccb, 0x2ccd, 0x2ccf, 0x2cd1, 0x2cd3, 
            0x2cd5, 0x2cd7, 0x2cd9, 0x2cdb, 0x2cdd, 0x2cdf, 0x2ce1, 0x2ce3, 
            0x2cec, 0x2cee, 0x2cf3, 0x2d27, 0x2d2d, 0xa641, 0xa643, 0xa645, 
            0xa647, 0xa649, 0xa64b, 0xa64d, 0xa64f, 0xa651, 0xa653, 0xa655, 
            0xa657, 0xa659, 0xa65b, 0xa65d, 0xa65f, 0xa661, 0xa663, 0xa665, 
            0xa667, 0xa669, 0xa66b, 0xa66d, 0xa681, 0xa683, 0xa685, 0xa687, 
            0xa689, 0xa68b, 0xa68d, 0xa68f, 0xa691, 0xa693, 0xa695, 0xa697, 
            0xa699, 0xa69b, 0xa723, 0xa725, 0xa727, 0xa729, 0xa72b, 0xa72d, 
            0xa72f, 0xa733, 0xa735, 0xa737, 0xa739, 0xa73b, 0xa73d, 0xa73f, 
            0xa741, 0xa743, 0xa745, 0xa747, 0xa749, 0xa74b, 0xa74d, 0xa74f, 
            0xa751, 0xa753, 0xa755, 0xa757, 0xa759, 0xa75b, 0xa75d, 0xa75f, 
            0xa761, 0xa763, 0xa765, 0xa767, 0xa769, 0xa76b, 0xa76d, 0xa76f, 
            0xa77a, 0xa77c, 0xa77f, 0xa781, 0xa783, 0xa785, 0xa787, 0xa78c, 
            0xa791, 0xa797, 0xa799, 0xa79b, 0xa79d, 0xa79f, 0xa7a1, 0xa7a3, 
            0xa7a5, 0xa7a7, 0xa7a9, 0xa7b5, 0xa7b7, 0xa7b9, 0xa7bb, 0xa7bd, 
            0xa7bf, 0xa7c1, 0xa7c3, 0xa7c8, 0xa7ca, 0xa7cd, 0xa7cf, 0xa7d1, 
            0xa7d3, 0xa7d5, 0xa7d7, 0xa7d9, 0xa7db, 0xa7f6, 0xab53}),
        std::initializer_list<CharacterRange>({{0x00df, 0x00f6}, {0x00f8, 0x00ff}, {0x0148, 0x0149}, {0x017e, 0x0180}, 
            {0x0199, 0x019b}, {0x01c5, 0x01c6}, {0x01c8, 0x01c9}, {0x01cb, 0x01cc}, 
            {0x01dc, 0x01dd}, {0x01ef, 0x01f0}, {0x01f2, 0x01f3}, {0x023f, 0x0240}, 
            {0x024f, 0x0254}, {0x0256, 0x0257}, {0x025b, 0x025c}, {0x0260, 0x0261}, 
            {0x0263, 0x0266}, {0x0268, 0x026c}, {0x0271, 0x0272}, {0x0282, 0x0283}, 
            {0x0287, 0x028c}, {0x029d, 0x029e}, {0x037b, 0x037d}, {0x03ac, 0x03ce}, 
            {0x03d0, 0x03d1}, {0x03d5, 0x03d7}, {0x03ef, 0x03f3}, {0x0430, 0x045f}, 
            {0x04ce, 0x04cf}, {0x0561, 0x0587}, {0x10d0, 0x10fa}, {0x10fd, 0x10ff}, 
            {0x13f8, 0x13fd}, {0x1c80, 0x1c88}, {0x1e95, 0x1e9b}, {0x1eff, 0x1f07}, 
            {0x1f10, 0x1f15}, {0x1f20, 0x1f27}, {0x1f30, 0x1f37}, {0x1f40, 0x1f45}, 
            {0x1f50, 0x1f57}, {0x1f60, 0x1f67}, {0x1f70, 0x1f7d}, {0x1f80, 0x1fb4}, 
            {0x1fb6, 0x1fb7}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fc7}, {0x1fd0, 0x1fd3}, 
            {0x1fd6, 0x1fd7}, {0x1fe0, 0x1fe7}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ff7}, 
            {0x2170, 0x217f}, {0x24d0, 0x24e9}, {0x2c30, 0x2c5f}, {0x2c65, 0x2c66}, 
            {0x2d00, 0x2d25}, {0xa793, 0xa794}, {0xab70, 0xabbf}, {0xfb00, 0xfb06}, 
            {0xfb13, 0xfb17}, {0xff41, 0xff5a}, {0x10428, 0x1044f}, {0x104d8, 0x104fb}, 
            {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, 
            {0x10cc0, 0x10cf2}, {0x10d70, 0x10d85}, {0x118c0, 0x118df}, {0x16e60, 0x16e7f}, 
            {0x16ebb, 0x16ed3}, {0x1e922, 0x1e943}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass50()
{
    // Name = Changes_When_Titlecased, number of codePoints: 1507
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x61, 0x7a}}),
        std::initializer_list<char32_t>({0x00b5, 0x0101, 0x0103, 0x0105, 0x0107, 0x0109, 0x010b, 0x010d, 
            0x010f, 0x0111, 0x0113, 0x0115, 0x0117, 0x0119, 0x011b, 0x011d, 
            0x011f, 0x0121, 0x0123, 0x0125, 0x0127, 0x0129, 0x012b, 0x012d, 
            0x012f, 0x0131, 0x0133, 0x0135, 0x0137, 0x013a, 0x013c, 0x013e, 
            0x0140, 0x0142, 0x0144, 0x0146, 0x014b, 0x014d, 0x014f, 0x0151, 
            0x0153, 0x0155, 0x0157, 0x0159, 0x015b, 0x015d, 0x015f, 0x0161, 
            0x0163, 0x0165, 0x0167, 0x0169, 0x016b, 0x016d, 0x016f, 0x0171, 
            0x0173, 0x0175, 0x0177, 0x017a, 0x017c, 0x0183, 0x0185, 0x0188, 
            0x018c, 0x0192, 0x0195, 0x019e, 0x01a1, 0x01a3, 0x01a5, 0x01a8, 
            0x01ad, 0x01b0, 0x01b4, 0x01b6, 0x01b9, 0x01bd, 0x01bf, 0x01c4, 
            0x01cc, 0x01ce, 0x01d0, 0x01d2, 0x01d4, 0x01d6, 0x01d8, 0x01da, 
            0x01df, 0x01e1, 0x01e3, 0x01e5, 0x01e7, 0x01e9, 0x01eb, 0x01ed, 
            0x01f3, 0x01f5, 0x01f9, 0x01fb, 0x01fd, 0x01ff, 0x0201, 0x0203, 
            0x0205, 0x0207, 0x0209, 0x020b, 0x020d, 0x020f, 0x0211, 0x0213, 
            0x0215, 0x0217, 0x0219, 0x021b, 0x021d, 0x021f, 0x0223, 0x0225, 
            0x0227, 0x0229, 0x022b, 0x022d, 0x022f, 0x0231, 0x0233, 0x023c, 
            0x0242, 0x0247, 0x0249, 0x024b, 0x024d, 0x0259, 0x026f, 0x0275, 
            0x027d, 0x0280, 0x0292, 0x0345, 0x0371, 0x0373, 0x0377, 0x0390, 
            0x03d9, 0x03db, 0x03dd, 0x03df, 0x03e1, 0x03e3, 0x03e5, 0x03e7, 
            0x03e9, 0x03eb, 0x03ed, 0x03f5, 0x03f8, 0x03fb, 0x0461, 0x0463, 
            0x0465, 0x0467, 0x0469, 0x046b, 0x046d, 0x046f, 0x0471, 0x0473, 
            0x0475, 0x0477, 0x0479, 0x047b, 0x047d, 0x047f, 0x0481, 0x048b, 
            0x048d, 0x048f, 0x0491, 0x0493, 0x0495, 0x0497, 0x0499, 0x049b, 
            0x049d, 0x049f, 0x04a1, 0x04a3, 0x04a5, 0x04a7, 0x04a9, 0x04ab, 
            0x04ad, 0x04af, 0x04b1, 0x04b3, 0x04b5, 0x04b7, 0x04b9, 0x04bb, 
            0x04bd, 0x04bf, 0x04c2, 0x04c4, 0x04c6, 0x04c8, 0x04ca, 0x04cc, 
            0x04d1, 0x04d3, 0x04d5, 0x04d7, 0x04d9, 0x04db, 0x04dd, 0x04df, 
            0x04e1, 0x04e3, 0x04e5, 0x04e7, 0x04e9, 0x04eb, 0x04ed, 0x04ef, 
            0x04f1, 0x04f3, 0x04f5, 0x04f7, 0x04f9, 0x04fb, 0x04fd, 0x04ff, 
            0x0501, 0x0503, 0x0505, 0x0507, 0x0509, 0x050b, 0x050d, 0x050f, 
            0x0511, 0x0513, 0x0515, 0x0517, 0x0519, 0x051b, 0x051d, 0x051f, 
            0x0521, 0x0523, 0x0525, 0x0527, 0x0529, 0x052b, 0x052d, 0x052f, 
            0x1c8a, 0x1d79, 0x1d7d, 0x1d8e, 0x1e01, 0x1e03, 0x1e05, 0x1e07, 
            0x1e09, 0x1e0b, 0x1e0d, 0x1e0f, 0x1e11, 0x1e13, 0x1e15, 0x1e17, 
            0x1e19, 0x1e1b, 0x1e1d, 0x1e1f, 0x1e21, 0x1e23, 0x1e25, 0x1e27, 
            0x1e29, 0x1e2b, 0x1e2d, 0x1e2f, 0x1e31, 0x1e33, 0x1e35, 0x1e37, 
            0x1e39, 0x1e3b, 0x1e3d, 0x1e3f, 0x1e41, 0x1e43, 0x1e45, 0x1e47, 
            0x1e49, 0x1e4b, 0x1e4d, 0x1e4f, 0x1e51, 0x1e53, 0x1e55, 0x1e57, 
            0x1e59, 0x1e5b, 0x1e5d, 0x1e5f, 0x1e61, 0x1e63, 0x1e65, 0x1e67, 
            0x1e69, 0x1e6b, 0x1e6d, 0x1e6f, 0x1e71, 0x1e73, 0x1e75, 0x1e77, 
            0x1e79, 0x1e7b, 0x1e7d, 0x1e7f, 0x1e81, 0x1e83, 0x1e85, 0x1e87, 
            0x1e89, 0x1e8b, 0x1e8d, 0x1e8f, 0x1e91, 0x1e93, 0x1ea1, 0x1ea3, 
            0x1ea5, 0x1ea7, 0x1ea9, 0x1eab, 0x1ead, 0x1eaf, 0x1eb1, 0x1eb3, 
            0x1eb5, 0x1eb7, 0x1eb9, 0x1ebb, 0x1ebd, 0x1ebf, 0x1ec1, 0x1ec3, 
            0x1ec5, 0x1ec7, 0x1ec9, 0x1ecb, 0x1ecd, 0x1ecf, 0x1ed1, 0x1ed3, 
            0x1ed5, 0x1ed7, 0x1ed9, 0x1edb, 0x1edd, 0x1edf, 0x1ee1, 0x1ee3, 
            0x1ee5, 0x1ee7, 0x1ee9, 0x1eeb, 0x1eed, 0x1eef, 0x1ef1, 0x1ef3, 
            0x1ef5, 0x1ef7, 0x1ef9, 0x1efb, 0x1efd, 0x1fbe, 0x214e, 0x2184, 
            0x2c61, 0x2c68, 0x2c6a, 0x2c6c, 0x2c73, 0x2c76, 0x2c81, 0x2c83, 
            0x2c85, 0x2c87, 0x2c89, 0x2c8b, 0x2c8d, 0x2c8f, 0x2c91, 0x2c93, 
            0x2c95, 0x2c97, 0x2c99, 0x2c9b, 0x2c9d, 0x2c9f, 0x2ca1, 0x2ca3, 
            0x2ca5, 0x2ca7, 0x2ca9, 0x2cab, 0x2cad, 0x2caf, 0x2cb1, 0x2cb3, 
            0x2cb5, 0x2cb7, 0x2cb9, 0x2cbb, 0x2cbd, 0x2cbf, 0x2cc1, 0x2cc3, 
            0x2cc5, 0x2cc7, 0x2cc9, 0x2ccb, 0x2ccd, 0x2ccf, 0x2cd1, 0x2cd3, 
            0x2cd5, 0x2cd7, 0x2cd9, 0x2cdb, 0x2cdd, 0x2cdf, 0x2ce1, 0x2ce3, 
            0x2cec, 0x2cee, 0x2cf3, 0x2d27, 0x2d2d, 0xa641, 0xa643, 0xa645, 
            0xa647, 0xa649, 0xa64b, 0xa64d, 0xa64f, 0xa651, 0xa653, 0xa655, 
            0xa657, 0xa659, 0xa65b, 0xa65d, 0xa65f, 0xa661, 0xa663, 0xa665, 
            0xa667, 0xa669, 0xa66b, 0xa66d, 0xa681, 0xa683, 0xa685, 0xa687, 
            0xa689, 0xa68b, 0xa68d, 0xa68f, 0xa691, 0xa693, 0xa695, 0xa697, 
            0xa699, 0xa69b, 0xa723, 0xa725, 0xa727, 0xa729, 0xa72b, 0xa72d, 
            0xa72f, 0xa733, 0xa735, 0xa737, 0xa739, 0xa73b, 0xa73d, 0xa73f, 
            0xa741, 0xa743, 0xa745, 0xa747, 0xa749, 0xa74b, 0xa74d, 0xa74f, 
            0xa751, 0xa753, 0xa755, 0xa757, 0xa759, 0xa75b, 0xa75d, 0xa75f, 
            0xa761, 0xa763, 0xa765, 0xa767, 0xa769, 0xa76b, 0xa76d, 0xa76f, 
            0xa77a, 0xa77c, 0xa77f, 0xa781, 0xa783, 0xa785, 0xa787, 0xa78c, 
            0xa791, 0xa797, 0xa799, 0xa79b, 0xa79d, 0xa79f, 0xa7a1, 0xa7a3, 
            0xa7a5, 0xa7a7, 0xa7a9, 0xa7b5, 0xa7b7, 0xa7b9, 0xa7bb, 0xa7bd, 
            0xa7bf, 0xa7c1, 0xa7c3, 0xa7c8, 0xa7ca, 0xa7cd, 0xa7cf, 0xa7d1, 
            0xa7d3, 0xa7d5, 0xa7d7, 0xa7d9, 0xa7db, 0xa7f6, 0xab53}),
        std::initializer_list<CharacterRange>({{0x00df, 0x00f6}, {0x00f8, 0x00ff}, {0x0148, 0x0149}, {0x017e, 0x0180}, 
            {0x0199, 0x019b}, {0x01c6, 0x01c7}, {0x01c9, 0x01ca}, {0x01dc, 0x01dd}, 
            {0x01ef, 0x01f1}, {0x023f, 0x0240}, {0x024f, 0x0254}, {0x0256, 0x0257}, 
            {0x025b, 0x025c}, {0x0260, 0x0261}, {0x0263, 0x0266}, {0x0268, 0x026c}, 
            {0x0271, 0x0272}, {0x0282, 0x0283}, {0x0287, 0x028c}, {0x029d, 0x029e}, 
            {0x037b, 0x037d}, {0x03ac, 0x03ce}, {0x03d0, 0x03d1}, {0x03d5, 0x03d7}, 
            {0x03ef, 0x03f3}, {0x0430, 0x045f}, {0x04ce, 0x04cf}, {0x0561, 0x0587}, 
            {0x13f8, 0x13fd}, {0x1c80, 0x1c88}, {0x1e95, 0x1e9b}, {0x1eff, 0x1f07}, 
            {0x1f10, 0x1f15}, {0x1f20, 0x1f27}, {0x1f30, 0x1f37}, {0x1f40, 0x1f45}, 
            {0x1f50, 0x1f57}, {0x1f60, 0x1f67}, {0x1f70, 0x1f7d}, {0x1f80, 0x1f87}, 
            {0x1f90, 0x1f97}, {0x1fa0, 0x1fa7}, {0x1fb0, 0x1fb4}, {0x1fb6, 0x1fb7}, 
            {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fc7}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fd7}, 
            {0x1fe0, 0x1fe7}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ff7}, {0x2170, 0x217f}, 
            {0x24d0, 0x24e9}, {0x2c30, 0x2c5f}, {0x2c65, 0x2c66}, {0x2d00, 0x2d25}, 
            {0xa793, 0xa794}, {0xab70, 0xabbf}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, 
            {0xff41, 0xff5a}, {0x10428, 0x1044f}, {0x104d8, 0x104fb}, {0x10597, 0x105a1}, 
            {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10cc0, 0x10cf2}, 
            {0x10d70, 0x10d85}, {0x118c0, 0x118df}, {0x16e60, 0x16e7f}, {0x16ebb, 0x16ed3}, 
            {0x1e922, 0x1e943}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass51()
{
    // Name = Changes_When_Casefolded, number of codePoints: 1561
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}}),
        std::initializer_list<char32_t>({0x00b5, 0x0100, 0x0102, 0x0104, 0x0106, 0x0108, 0x010a, 0x010c, 
            0x010e, 0x0110, 0x0112, 0x0114, 0x0116, 0x0118, 0x011a, 0x011c, 
            0x011e, 0x0120, 0x0122, 0x0124, 0x0126, 0x0128, 0x012a, 0x012c, 
            0x012e, 0x0130, 0x0132, 0x0134, 0x0136, 0x0139, 0x013b, 0x013d, 
            0x013f, 0x0141, 0x0143, 0x0145, 0x0147, 0x014c, 0x014e, 0x0150, 
            0x0152, 0x0154, 0x0156, 0x0158, 0x015a, 0x015c, 0x015e, 0x0160, 
            0x0162, 0x0164, 0x0166, 0x0168, 0x016a, 0x016c, 0x016e, 0x0170, 
            0x0172, 0x0174, 0x0176, 0x017b, 0x017d, 0x017f, 0x0184, 0x01a2, 
            0x01a4, 0x01a9, 0x01ac, 0x01b5, 0x01bc, 0x01cd, 0x01cf, 0x01d1, 
            0x01d3, 0x01d5, 0x01d7, 0x01d9, 0x01db, 0x01de, 0x01e0, 0x01e2, 
            0x01e4, 0x01e6, 0x01e8, 0x01ea, 0x01ec, 0x01ee, 0x01f4, 0x01fa, 
            0x01fc, 0x01fe, 0x0200, 0x0202, 0x0204, 0x0206, 0x0208, 0x020a, 
            0x020c, 0x020e, 0x0210, 0x0212, 0x0214, 0x0216, 0x0218, 0x021a, 
            0x021c, 0x021e, 0x0220, 0x0222, 0x0224, 0x0226, 0x0228, 0x022a, 
            0x022c, 0x022e, 0x0230, 0x0232, 0x0241, 0x0248, 0x024a, 0x024c, 
            0x024e, 0x0345, 0x0370, 0x0372, 0x0376, 0x037f, 0x0386, 0x038c, 
            0x03c2, 0x03d8, 0x03da, 0x03dc, 0x03de, 0x03e0, 0x03e2, 0x03e4, 
            0x03e6, 0x03e8, 0x03ea, 0x03ec, 0x03ee, 0x03f7, 0x0460, 0x0462, 
            0x0464, 0x0466, 0x0468, 0x046a, 0x046c, 0x046e, 0x0470, 0x0472, 
            0x0474, 0x0476, 0x0478, 0x047a, 0x047c, 0x047e, 0x0480, 0x048a, 
            0x048c, 0x048e, 0x0490, 0x0492, 0x0494, 0x0496, 0x0498, 0x049a, 
            0x049c, 0x049e, 0x04a0, 0x04a2, 0x04a4, 0x04a6, 0x04a8, 0x04aa, 
            0x04ac, 0x04ae, 0x04b0, 0x04b2, 0x04b4, 0x04b6, 0x04b8, 0x04ba, 
            0x04bc, 0x04be, 0x04c3, 0x04c5, 0x04c7, 0x04c9, 0x04cb, 0x04cd, 
            0x04d0, 0x04d2, 0x04d4, 0x04d6, 0x04d8, 0x04da, 0x04dc, 0x04de, 
            0x04e0, 0x04e2, 0x04e4, 0x04e6, 0x04e8, 0x04ea, 0x04ec, 0x04ee, 
            0x04f0, 0x04f2, 0x04f4, 0x04f6, 0x04f8, 0x04fa, 0x04fc, 0x04fe, 
            0x0500, 0x0502, 0x0504, 0x0506, 0x0508, 0x050a, 0x050c, 0x050e, 
            0x0510, 0x0512, 0x0514, 0x0516, 0x0518, 0x051a, 0x051c, 0x051e, 
            0x0520, 0x0522, 0x0524, 0x0526, 0x0528, 0x052a, 0x052c, 0x052e, 
            0x0587, 0x10c7, 0x10cd, 0x1e00, 0x1e02, 0x1e04, 0x1e06, 0x1e08, 
            0x1e0a, 0x1e0c, 0x1e0e, 0x1e10, 0x1e12, 0x1e14, 0x1e16, 0x1e18, 
            0x1e1a, 0x1e1c, 0x1e1e, 0x1e20, 0x1e22, 0x1e24, 0x1e26, 0x1e28, 
            0x1e2a, 0x1e2c, 0x1e2e, 0x1e30, 0x1e32, 0x1e34, 0x1e36, 0x1e38, 
            0x1e3a, 0x1e3c, 0x1e3e, 0x1e40, 0x1e42, 0x1e44, 0x1e46, 0x1e48, 
            0x1e4a, 0x1e4c, 0x1e4e, 0x1e50, 0x1e52, 0x1e54, 0x1e56, 0x1e58, 
            0x1e5a, 0x1e5c, 0x1e5e, 0x1e60, 0x1e62, 0x1e64, 0x1e66, 0x1e68, 
            0x1e6a, 0x1e6c, 0x1e6e, 0x1e70, 0x1e72, 0x1e74, 0x1e76, 0x1e78, 
            0x1e7a, 0x1e7c, 0x1e7e, 0x1e80, 0x1e82, 0x1e84, 0x1e86, 0x1e88, 
            0x1e8a, 0x1e8c, 0x1e8e, 0x1e90, 0x1e92, 0x1e94, 0x1e9e, 0x1ea0, 
            0x1ea2, 0x1ea4, 0x1ea6, 0x1ea8, 0x1eaa, 0x1eac, 0x1eae, 0x1eb0, 
            0x1eb2, 0x1eb4, 0x1eb6, 0x1eb8, 0x1eba, 0x1ebc, 0x1ebe, 0x1ec0, 
            0x1ec2, 0x1ec4, 0x1ec6, 0x1ec8, 0x1eca, 0x1ecc, 0x1ece, 0x1ed0, 
            0x1ed2, 0x1ed4, 0x1ed6, 0x1ed8, 0x1eda, 0x1edc, 0x1ede, 0x1ee0, 
            0x1ee2, 0x1ee4, 0x1ee6, 0x1ee8, 0x1eea, 0x1eec, 0x1eee, 0x1ef0, 
            0x1ef2, 0x1ef4, 0x1ef6, 0x1ef8, 0x1efa, 0x1efc, 0x1efe, 0x1f59, 
            0x1f5b, 0x1f5d, 0x1f5f, 0x2126, 0x2132, 0x2183, 0x2c60, 0x2c67, 
            0x2c69, 0x2c6b, 0x2c72, 0x2c75, 0x2c82, 0x2c84, 0x2c86, 0x2c88, 
            0x2c8a, 0x2c8c, 0x2c8e, 0x2c90, 0x2c92, 0x2c94, 0x2c96, 0x2c98, 
            0x2c9a, 0x2c9c, 0x2c9e, 0x2ca0, 0x2ca2, 0x2ca4, 0x2ca6, 0x2ca8, 
            0x2caa, 0x2cac, 0x2cae, 0x2cb0, 0x2cb2, 0x2cb4, 0x2cb6, 0x2cb8, 
            0x2cba, 0x2cbc, 0x2cbe, 0x2cc0, 0x2cc2, 0x2cc4, 0x2cc6, 0x2cc8, 
            0x2cca, 0x2ccc, 0x2cce, 0x2cd0, 0x2cd2, 0x2cd4, 0x2cd6, 0x2cd8, 
            0x2cda, 0x2cdc, 0x2cde, 0x2ce0, 0x2ce2, 0x2ceb, 0x2ced, 0x2cf2, 
            0xa640, 0xa642, 0xa644, 0xa646, 0xa648, 0xa64a, 0xa64c, 0xa64e, 
            0xa650, 0xa652, 0xa654, 0xa656, 0xa658, 0xa65a, 0xa65c, 0xa65e, 
            0xa660, 0xa662, 0xa664, 0xa666, 0xa668, 0xa66a, 0xa66c, 0xa680, 
            0xa682, 0xa684, 0xa686, 0xa688, 0xa68a, 0xa68c, 0xa68e, 0xa690, 
            0xa692, 0xa694, 0xa696, 0xa698, 0xa69a, 0xa722, 0xa724, 0xa726, 
            0xa728, 0xa72a, 0xa72c, 0xa72e, 0xa732, 0xa734, 0xa736, 0xa738, 
            0xa73a, 0xa73c, 0xa73e, 0xa740, 0xa742, 0xa744, 0xa746, 0xa748, 
            0xa74a, 0xa74c, 0xa74e, 0xa750, 0xa752, 0xa754, 0xa756, 0xa758, 
            0xa75a, 0xa75c, 0xa75e, 0xa760, 0xa762, 0xa764, 0xa766, 0xa768, 
            0xa76a, 0xa76c, 0xa76e, 0xa779, 0xa77b, 0xa780, 0xa782, 0xa784, 
            0xa786, 0xa78b, 0xa78d, 0xa790, 0xa792, 0xa796, 0xa798, 0xa79a, 
            0xa79c, 0xa79e, 0xa7a0, 0xa7a2, 0xa7a4, 0xa7a6, 0xa7a8, 0xa7b6, 
            0xa7b8, 0xa7ba, 0xa7bc, 0xa7be, 0xa7c0, 0xa7c2, 0xa7c9, 0xa7ce, 
            0xa7d0, 0xa7d2, 0xa7d4, 0xa7d6, 0xa7d8, 0xa7da, 0xa7dc, 0xa7f5}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00df}, {0x0149, 0x014a}, {0x0178, 0x0179}, 
            {0x0181, 0x0182}, {0x0186, 0x0187}, {0x0189, 0x018b}, {0x018e, 0x0191}, 
            {0x0193, 0x0194}, {0x0196, 0x0198}, {0x019c, 0x019d}, {0x019f, 0x01a0}, 
            {0x01a6, 0x01a7}, {0x01ae, 0x01af}, {0x01b1, 0x01b3}, {0x01b7, 0x01b8}, 
            {0x01c4, 0x01c5}, {0x01c7, 0x01c8}, {0x01ca, 0x01cb}, {0x01f1, 0x01f2}, 
            {0x01f6, 0x01f8}, {0x023a, 0x023b}, {0x023d, 0x023e}, {0x0243, 0x0246}, 
            {0x0388, 0x038a}, {0x038e, 0x038f}, {0x0391, 0x03a1}, {0x03a3, 0x03ab}, 
            {0x03cf, 0x03d1}, {0x03d5, 0x03d6}, {0x03f0, 0x03f1}, {0x03f4, 0x03f5}, 
            {0x03f9, 0x03fa}, {0x03fd, 0x042f}, {0x04c0, 0x04c1}, {0x0531, 0x0556}, 
            {0x10a0, 0x10c5}, {0x13f8, 0x13fd}, {0x1c80, 0x1c89}, {0x1c90, 0x1cba}, 
            {0x1cbd, 0x1cbf}, {0x1e9a, 0x1e9b}, {0x1f08, 0x1f0f}, {0x1f18, 0x1f1d}, 
            {0x1f28, 0x1f2f}, {0x1f38, 0x1f3f}, {0x1f48, 0x1f4d}, {0x1f68, 0x1f6f}, 
            {0x1f80, 0x1faf}, {0x1fb2, 0x1fb4}, {0x1fb7, 0x1fbc}, {0x1fc2, 0x1fc4}, 
            {0x1fc7, 0x1fcc}, {0x1fd8, 0x1fdb}, {0x1fe8, 0x1fec}, {0x1ff2, 0x1ff4}, 
            {0x1ff7, 0x1ffc}, {0x212a, 0x212b}, {0x2160, 0x216f}, {0x24b6, 0x24cf}, 
            {0x2c00, 0x2c2f}, {0x2c62, 0x2c64}, {0x2c6d, 0x2c70}, {0x2c7e, 0x2c80}, 
            {0xa77d, 0xa77e}, {0xa7aa, 0xa7ae}, {0xa7b0, 0xa7b4}, {0xa7c4, 0xa7c7}, 
            {0xa7cb, 0xa7cc}, {0xab70, 0xabbf}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, 
            {0xff21, 0xff3a}, {0x10400, 0x10427}, {0x104b0, 0x104d3}, {0x10570, 0x1057a}, 
            {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10c80, 0x10cb2}, 
            {0x10d50, 0x10d65}, {0x118a0, 0x118bf}, {0x16e40, 0x16e5f}, {0x16ea0, 0x16eb8}, 
            {0x1e900, 0x1e921}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass52()
{
    // Name = Changes_When_Casemapped, number of codePoints: 3037
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<char32_t>({0x00b5, 0x01bf, 0x0259, 0x026f, 0x0275, 0x027d, 0x0280, 0x0292, 
            0x0345, 0x037f, 0x0386, 0x038c, 0x10c7, 0x10cd, 0x1d79, 0x1d7d, 
            0x1d8e, 0x1e9e, 0x1f59, 0x1f5b, 0x1f5d, 0x1fbe, 0x2126, 0x2132, 
            0x214e, 0x2d27, 0x2d2d, 0xab53}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x0137}, {0x0139, 0x018c}, 
            {0x018e, 0x01a9}, {0x01ac, 0x01b9}, {0x01bc, 0x01bd}, {0x01c4, 0x0220}, 
            {0x0222, 0x0233}, {0x023a, 0x0254}, {0x0256, 0x0257}, {0x025b, 0x025c}, 
            {0x0260, 0x0261}, {0x0263, 0x0266}, {0x0268, 0x026c}, {0x0271, 0x0272}, 
            {0x0282, 0x0283}, {0x0287, 0x028c}, {0x029d, 0x029e}, {0x0370, 0x0373}, 
            {0x0376, 0x0377}, {0x037b, 0x037d}, {0x0388, 0x038a}, {0x038e, 0x03a1}, 
            {0x03a3, 0x03d1}, {0x03d5, 0x03f5}, {0x03f7, 0x03fb}, {0x03fd, 0x0481}, 
            {0x048a, 0x052f}, {0x0531, 0x0556}, {0x0561, 0x0587}, {0x10a0, 0x10c5}, 
            {0x10d0, 0x10fa}, {0x10fd, 0x10ff}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, 
            {0x1c80, 0x1c8a}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1e00, 0x1e9b}, 
            {0x1ea0, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, 
            {0x1f50, 0x1f57}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, 
            {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, 
            {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x212a, 0x212b}, 
            {0x2160, 0x217f}, {0x2183, 0x2184}, {0x24b6, 0x24e9}, {0x2c00, 0x2c70}, 
            {0x2c72, 0x2c73}, {0x2c75, 0x2c76}, {0x2c7e, 0x2ce3}, {0x2ceb, 0x2cee}, 
            {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, {0xa640, 0xa66d}, {0xa680, 0xa69b}, 
            {0xa722, 0xa72f}, {0xa732, 0xa76f}, {0xa779, 0xa787}, {0xa78b, 0xa78d}, 
            {0xa790, 0xa794}, {0xa796, 0xa7ae}, {0xa7b0, 0xa7dc}, {0xa7f5, 0xa7f6}, 
            {0xab70, 0xabbf}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xff21, 0xff3a}, 
            {0xff41, 0xff5a}, {0x10400, 0x1044f}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, 
            {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, 
            {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, 
            {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d50, 0x10d65}, {0x10d70, 0x10d85}, 
            {0x118a0, 0x118df}, {0x16e40, 0x16e7f}, {0x16ea0, 0x16eb8}, {0x16ebb, 0x16ed3}, 
            {0x1e900, 0x1e943}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass53()
{
    // Name = ID_Start, number of codePoints: 145945
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<char32_t>({0x00aa, 0x00b5, 0x00ba, 0x02ec, 0x02ee, 0x037f, 0x0386, 0x038c, 
            0x0559, 0x06d5, 0x06ff, 0x0710, 0x07b1, 0x07fa, 0x081a, 0x0824, 
            0x0828, 0x093d, 0x0950, 0x09b2, 0x09bd, 0x09ce, 0x09fc, 0x09ff, 
            0x0a5e, 0x0abd, 0x0ad0, 0x0af9, 0x0b3d, 0x0b71, 0x0b83, 0x0b9c, 
            0x0bd0, 0x0c3d, 0x0c80, 0x0cbd, 0x0d3d, 0x0d4e, 0x0dbd, 0x0e84, 
            0x0ea5, 0x0ebd, 0x0ec6, 0x0f00, 0x103f, 0x1061, 0x108e, 0x10c7, 
            0x10cd, 0x1258, 0x12c0, 0x17d7, 0x17dc, 0x18aa, 0x1aa7, 0x1cfa, 
            0x1f59, 0x1f5b, 0x1f5d, 0x1fbe, 0x2071, 0x207f, 0x2102, 0x2107, 
            0x2115, 0x2124, 0x2126, 0x2128, 0x214e, 0x2d27, 0x2d2d, 0x2d6f, 
            0xa8fb, 0xa9cf, 0xaa7a, 0xaab1, 0xaac0, 0xaac2, 0xfb1d, 0xfb3e, 
            0x10808, 0x1083c, 0x10a00, 0x10f27, 0x11075, 0x11144, 0x11147, 0x11176, 
            0x111da, 0x111dc, 0x11288, 0x1133d, 0x11350, 0x1138b, 0x1138e, 0x113b7, 
            0x113d1, 0x113d3, 0x114c7, 0x11644, 0x116b8, 0x11909, 0x1193f, 0x11941, 
            0x119e1, 0x119e3, 0x11a00, 0x11a3a, 0x11a50, 0x11a9d, 0x11c40, 0x11d46, 
            0x11d98, 0x11f02, 0x11fb0, 0x16f50, 0x16fe3, 0x1b132, 0x1b155, 0x1d4a2, 
            0x1d4bb, 0x1d546, 0x1e14e, 0x1e5f0, 0x1e94b, 0x1ee24, 0x1ee27, 0x1ee39, 
            0x1ee3b, 0x1ee42, 0x1ee47, 0x1ee49, 0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 
            0x1ee5b, 0x1ee5d, 0x1ee5f, 0x1ee64, 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x02c1}, {0x02c6, 0x02d1}, 
            {0x02e0, 0x02e4}, {0x0370, 0x0374}, {0x0376, 0x0377}, {0x037a, 0x037d}, 
            {0x0388, 0x038a}, {0x038e, 0x03a1}, {0x03a3, 0x03f5}, {0x03f7, 0x0481}, 
            {0x048a, 0x052f}, {0x0531, 0x0556}, {0x0560, 0x0588}, {0x05d0, 0x05ea}, 
            {0x05ef, 0x05f2}, {0x0620, 0x064a}, {0x066e, 0x066f}, {0x0671, 0x06d3}, 
            {0x06e5, 0x06e6}, {0x06ee, 0x06ef}, {0x06fa, 0x06fc}, {0x0712, 0x072f}, 
            {0x074d, 0x07a5}, {0x07ca, 0x07ea}, {0x07f4, 0x07f5}, {0x0800, 0x0815}, 
            {0x0840, 0x0858}, {0x0860, 0x086a}, {0x0870, 0x0887}, {0x0889, 0x088f}, 
            {0x08a0, 0x08c9}, {0x0904, 0x0939}, {0x0958, 0x0961}, {0x0971, 0x0980}, 
            {0x0985, 0x098c}, {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0}, 
            {0x09b6, 0x09b9}, {0x09dc, 0x09dd}, {0x09df, 0x09e1}, {0x09f0, 0x09f1}, 
            {0x0a05, 0x0a0a}, {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, 
            {0x0a32, 0x0a33}, {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a59, 0x0a5c}, 
            {0x0a72, 0x0a74}, {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, 
            {0x0aaa, 0x0ab0}, {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0ae0, 0x0ae1}, 
            {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, 
            {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b61}, 
            {0x0b85, 0x0b8a}, {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, 
            {0x0b9e, 0x0b9f}, {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, 
            {0x0c05, 0x0c0c}, {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, 
            {0x0c58, 0x0c5a}, {0x0c5c, 0x0c5d}, {0x0c60, 0x0c61}, {0x0c85, 0x0c8c}, 
            {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, 
            {0x0cdc, 0x0cde}, {0x0ce0, 0x0ce1}, {0x0cf1, 0x0cf2}, {0x0d04, 0x0d0c}, 
            {0x0d0e, 0x0d10}, {0x0d12, 0x0d3a}, {0x0d54, 0x0d56}, {0x0d5f, 0x0d61}, 
            {0x0d7a, 0x0d7f}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, {0x0db3, 0x0dbb}, 
            {0x0dc0, 0x0dc6}, {0x0e01, 0x0e30}, {0x0e32, 0x0e33}, {0x0e40, 0x0e46}, 
            {0x0e81, 0x0e82}, {0x0e86, 0x0e8a}, {0x0e8c, 0x0ea3}, {0x0ea7, 0x0eb0}, 
            {0x0eb2, 0x0eb3}, {0x0ec0, 0x0ec4}, {0x0edc, 0x0edf}, {0x0f40, 0x0f47}, 
            {0x0f49, 0x0f6c}, {0x0f88, 0x0f8c}, {0x1000, 0x102a}, {0x1050, 0x1055}, 
            {0x105a, 0x105d}, {0x1065, 0x1066}, {0x106e, 0x1070}, {0x1075, 0x1081}, 
            {0x10a0, 0x10c5}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, 
            {0x1250, 0x1256}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, 
            {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c2, 0x12c5}, 
            {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, 
            {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, 
            {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, 
            {0x1700, 0x1711}, {0x171f, 0x1731}, {0x1740, 0x1751}, {0x1760, 0x176c}, 
            {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x1820, 0x1878}, {0x1880, 0x18a8}, 
            {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, 
            {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, {0x1a20, 0x1a54}, 
            {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, 
            {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f}, {0x1c5a, 0x1c7d}, 
            {0x1c80, 0x1c8a}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, 
            {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, 
            {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, 
            {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fc2, 0x1fc4}, 
            {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, 
            {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2090, 0x209c}, {0x210a, 0x2113}, 
            {0x2118, 0x211d}, {0x212a, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149}, 
            {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, 
            {0x2d00, 0x2d25}, {0x2d30, 0x2d67}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, 
            {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, 
            {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007}, 
            {0x3021, 0x3029}, {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096}, 
            {0x309b, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, 
            {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, 
            {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f}, 
            {0xa62a, 0xa62b}, {0xa640, 0xa66e}, {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, 
            {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7dc}, {0xa7f1, 0xa801}, 
            {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873}, 
            {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, 
            {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9e0, 0xa9e4}, 
            {0xa9e6, 0xa9ef}, {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, 
            {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7e, 0xaaaf}, {0xaab5, 0xaab6}, 
            {0xaab9, 0xaabd}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, 
            {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, 
            {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabe2}, 
            {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, 
            {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1f, 0xfb28}, 
            {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, 
            {0xfb46, 0xfbb1}, {0xfbd3, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, 
            {0xfdf0, 0xfdfb}, {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, {0xff21, 0xff3a}, 
            {0xff41, 0xff5a}, {0xff66, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, 
            {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, 
            {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d}, 
            {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, 
            {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x10375}, {0x10380, 0x1039d}, 
            {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, 
            {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, 
            {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, 
            {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, 
            {0x105c0, 0x105f3}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, 
            {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, 
            {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083f, 0x10855}, {0x10860, 0x10876}, 
            {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, 
            {0x10920, 0x10939}, {0x10940, 0x10959}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, 
            {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a60, 0x10a7c}, 
            {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, 
            {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, 
            {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10d4a, 0x10d65}, 
            {0x10d6f, 0x10d85}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1}, {0x10ec2, 0x10ec7}, 
            {0x10f00, 0x10f1c}, {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, 
            {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072}, {0x11083, 0x110af}, 
            {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11150, 0x11172}, {0x11183, 0x111b2}, 
            {0x111c1, 0x111c4}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x1123f, 0x11240}, 
            {0x11280, 0x11286}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, 
            {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, 
            {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1135d, 0x11361}, 
            {0x11380, 0x11389}, {0x11390, 0x113b5}, {0x11400, 0x11434}, {0x11447, 0x1144a}, 
            {0x1145f, 0x11461}, {0x11480, 0x114af}, {0x114c4, 0x114c5}, {0x11580, 0x115ae}, 
            {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11680, 0x116aa}, {0x11700, 0x1171a}, 
            {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, 
            {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x1192f}, {0x119a0, 0x119a7}, 
            {0x119aa, 0x119d0}, {0x11a0b, 0x11a32}, {0x11a5c, 0x11a89}, {0x11ab0, 0x11af8}, 
            {0x11bc0, 0x11be0}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e}, {0x11c72, 0x11c8f}, 
            {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d60, 0x11d65}, 
            {0x11d67, 0x11d68}, {0x11d6a, 0x11d89}, {0x11db0, 0x11ddb}, {0x11ee0, 0x11ef2}, 
            {0x11f04, 0x11f10}, {0x11f12, 0x11f33}, {0x12000, 0x12399}, {0x12400, 0x1246e}, 
            {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13441, 0x13446}, 
            {0x13460, 0x143fa}, {0x14400, 0x14646}, {0x16100, 0x1611d}, {0x16800, 0x16a38}, 
            {0x16a40, 0x16a5e}, {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, 
            {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16d40, 0x16d6c}, 
            {0x16d80, 0x16d97}, {0x16d99, 0x16d9c}, {0x16e40, 0x16e7f}, {0x16ea0, 0x16eb8}, 
            {0x16ebb, 0x16ed3}, {0x16f00, 0x16f4a}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, 
            {0x16ff2, 0x16ff6}, {0x17000, 0x18cd5}, {0x18cff, 0x18d1e}, {0x18d80, 0x18df2}, 
            {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, 
            {0x1b150, 0x1b152}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, 
            {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, 
            {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, 
            {0x1d4ae, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, 
            {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, 
            {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, 
            {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, 
            {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, 
            {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, 
            {0x1e030, 0x1e06d}, {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d}, {0x1e290, 0x1e2ad}, 
            {0x1e2c0, 0x1e2eb}, {0x1e4d0, 0x1e4eb}, {0x1e5d0, 0x1e5ed}, {0x1e6c0, 0x1e6de}, 
            {0x1e6e0, 0x1e6e2}, {0x1e6e4, 0x1e6e5}, {0x1e6e7, 0x1e6ed}, {0x1e6f0, 0x1e6f4}, 
            {0x1e6fe, 0x1e6ff}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, 
            {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, {0x1e900, 0x1e943}, {0x1ee00, 0x1ee03}, 
            {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, 
            {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, 
            {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, 
            {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, 
            {0x20000, 0x2a6df}, {0x2a700, 0x2b81d}, {0x2b820, 0x2cead}, {0x2ceb0, 0x2ebe0}, 
            {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x33479}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass54()
{
    // Name = ID_Continue, number of codePoints: 149283
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x5f}),
        std::initializer_list<CharacterRange>({{0x30, 0x39}, {0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<char32_t>({0x00aa, 0x00b5, 0x00b7, 0x00ba, 0x02ec, 0x02ee, 0x037f, 0x038c, 
            0x0559, 0x05bf, 0x05c7, 0x06ff, 0x07fa, 0x07fd, 0x09b2, 0x09d7, 
            0x09fc, 0x0a3c, 0x0a51, 0x0a5e, 0x0ad0, 0x0b71, 0x0b9c, 0x0bd0, 
            0x0bd7, 0x0dbd, 0x0dca, 0x0dd6, 0x0e84, 0x0ea5, 0x0ec6, 0x0f00, 
            0x0f35, 0x0f37, 0x0f39, 0x0fc6, 0x10c7, 0x10cd, 0x1258, 0x12c0, 
            0x17d7, 0x1aa7, 0x1f59, 0x1f5b, 0x1f5d, 0x1fbe, 0x2054, 0x2071, 
            0x207f, 0x20e1, 0x2102, 0x2107, 0x2115, 0x2124, 0x2126, 0x2128, 
            0x214e, 0x2d27, 0x2d2d, 0x2d6f, 0xa82c, 0xa8fb, 0xfb3e, 0xff3f, 
            0x101fd, 0x102e0, 0x10808, 0x1083c, 0x10a3f, 0x10f27, 0x110c2, 0x11176, 
            0x111dc, 0x11288, 0x11350, 0x11357, 0x1138b, 0x1138e, 0x113c2, 0x113c5, 
            0x114c7, 0x11644, 0x11909, 0x11a47, 0x11a9d, 0x11d3a, 0x11fb0, 0x1b132, 
            0x1b155, 0x1d4a2, 0x1d4bb, 0x1d546, 0x1da75, 0x1da84, 0x1e08f, 0x1e14e, 
            0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 0x1ee42, 0x1ee47, 0x1ee49, 0x1ee4b, 
            0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 0x1ee5d, 0x1ee5f, 0x1ee64, 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x02c1}, {0x02c6, 0x02d1}, 
            {0x02e0, 0x02e4}, {0x0300, 0x0374}, {0x0376, 0x0377}, {0x037a, 0x037d}, 
            {0x0386, 0x038a}, {0x038e, 0x03a1}, {0x03a3, 0x03f5}, {0x03f7, 0x0481}, 
            {0x0483, 0x0487}, {0x048a, 0x052f}, {0x0531, 0x0556}, {0x0560, 0x0588}, 
            {0x0591, 0x05bd}, {0x05c1, 0x05c2}, {0x05c4, 0x05c5}, {0x05d0, 0x05ea}, 
            {0x05ef, 0x05f2}, {0x0610, 0x061a}, {0x0620, 0x0669}, {0x066e, 0x06d3}, 
            {0x06d5, 0x06dc}, {0x06df, 0x06e8}, {0x06ea, 0x06fc}, {0x0710, 0x074a}, 
            {0x074d, 0x07b1}, {0x07c0, 0x07f5}, {0x0800, 0x082d}, {0x0840, 0x085b}, 
            {0x0860, 0x086a}, {0x0870, 0x0887}, {0x0889, 0x088f}, {0x0897, 0x08e1}, 
            {0x08e3, 0x0963}, {0x0966, 0x096f}, {0x0971, 0x0983}, {0x0985, 0x098c}, 
            {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0}, {0x09b6, 0x09b9}, 
            {0x09bc, 0x09c4}, {0x09c7, 0x09c8}, {0x09cb, 0x09ce}, {0x09dc, 0x09dd}, 
            {0x09df, 0x09e3}, {0x09e6, 0x09f1}, {0x09fe, 0x09ff}, {0x0a01, 0x0a03}, 
            {0x0a05, 0x0a0a}, {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, 
            {0x0a32, 0x0a33}, {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a3e, 0x0a42}, 
            {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a59, 0x0a5c}, {0x0a66, 0x0a75}, 
            {0x0a81, 0x0a83}, {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, 
            {0x0aaa, 0x0ab0}, {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0abc, 0x0ac5}, 
            {0x0ac7, 0x0ac9}, {0x0acb, 0x0acd}, {0x0ae0, 0x0ae3}, {0x0ae6, 0x0aef}, 
            {0x0af9, 0x0aff}, {0x0b01, 0x0b03}, {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10}, 
            {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, 
            {0x0b3c, 0x0b44}, {0x0b47, 0x0b48}, {0x0b4b, 0x0b4d}, {0x0b53, 0x0b57}, 
            {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b63}, {0x0b66, 0x0b6f}, {0x0b82, 0x0b83}, 
            {0x0b85, 0x0b8a}, {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, 
            {0x0b9e, 0x0b9f}, {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, 
            {0x0bbe, 0x0bc2}, {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcd}, {0x0be6, 0x0bef}, 
            {0x0c00, 0x0c0c}, {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, 
            {0x0c3c, 0x0c44}, {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56}, 
            {0x0c58, 0x0c5a}, {0x0c5c, 0x0c5d}, {0x0c60, 0x0c63}, {0x0c66, 0x0c6f}, 
            {0x0c80, 0x0c83}, {0x0c85, 0x0c8c}, {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, 
            {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0cbc, 0x0cc4}, {0x0cc6, 0x0cc8}, 
            {0x0cca, 0x0ccd}, {0x0cd5, 0x0cd6}, {0x0cdc, 0x0cde}, {0x0ce0, 0x0ce3}, 
            {0x0ce6, 0x0cef}, {0x0cf1, 0x0cf3}, {0x0d00, 0x0d0c}, {0x0d0e, 0x0d10}, 
            {0x0d12, 0x0d44}, {0x0d46, 0x0d48}, {0x0d4a, 0x0d4e}, {0x0d54, 0x0d57}, 
            {0x0d5f, 0x0d63}, {0x0d66, 0x0d6f}, {0x0d7a, 0x0d7f}, {0x0d81, 0x0d83}, 
            {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, {0x0db3, 0x0dbb}, {0x0dc0, 0x0dc6}, 
            {0x0dcf, 0x0dd4}, {0x0dd8, 0x0ddf}, {0x0de6, 0x0def}, {0x0df2, 0x0df3}, 
            {0x0e01, 0x0e3a}, {0x0e40, 0x0e4e}, {0x0e50, 0x0e59}, {0x0e81, 0x0e82}, 
            {0x0e86, 0x0e8a}, {0x0e8c, 0x0ea3}, {0x0ea7, 0x0ebd}, {0x0ec0, 0x0ec4}, 
            {0x0ec8, 0x0ece}, {0x0ed0, 0x0ed9}, {0x0edc, 0x0edf}, {0x0f18, 0x0f19}, 
            {0x0f20, 0x0f29}, {0x0f3e, 0x0f47}, {0x0f49, 0x0f6c}, {0x0f71, 0x0f84}, 
            {0x0f86, 0x0f97}, {0x0f99, 0x0fbc}, {0x1000, 0x1049}, {0x1050, 0x109d}, 
            {0x10a0, 0x10c5}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, 
            {0x1250, 0x1256}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, 
            {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c2, 0x12c5}, 
            {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, 
            {0x135d, 0x135f}, {0x1369, 0x1371}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, 
            {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, 
            {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1715}, {0x171f, 0x1734}, 
            {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, 
            {0x1780, 0x17d3}, {0x17dc, 0x17dd}, {0x17e0, 0x17e9}, {0x180b, 0x180d}, 
            {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, 
            {0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x193b}, {0x1946, 0x196d}, 
            {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, 
            {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e}, {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, 
            {0x1a90, 0x1a99}, {0x1ab0, 0x1abd}, {0x1abf, 0x1add}, {0x1ae0, 0x1aeb}, 
            {0x1b00, 0x1b4c}, {0x1b50, 0x1b59}, {0x1b6b, 0x1b73}, {0x1b80, 0x1bf3}, 
            {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c8a}, 
            {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1cd0, 0x1cd2}, {0x1cd4, 0x1cfa}, 
            {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, 
            {0x1f50, 0x1f57}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, 
            {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, 
            {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x200c, 0x200d}, 
            {0x203f, 0x2040}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, {0x20e5, 0x20f0}, 
            {0x210a, 0x2113}, {0x2118, 0x211d}, {0x212a, 0x2139}, {0x213c, 0x213f}, 
            {0x2145, 0x2149}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, 
            {0x2d00, 0x2d25}, {0x2d30, 0x2d67}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, 
            {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, 
            {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, 
            {0x3005, 0x3007}, {0x3021, 0x302f}, {0x3031, 0x3035}, {0x3038, 0x303c}, 
            {0x3041, 0x3096}, {0x3099, 0x309f}, {0x30a1, 0x30ff}, {0x3105, 0x312f}, 
            {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, 
            {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b}, 
            {0xa640, 0xa66f}, {0xa674, 0xa67d}, {0xa67f, 0xa6f1}, {0xa717, 0xa71f}, 
            {0xa722, 0xa788}, {0xa78b, 0xa7dc}, {0xa7f1, 0xa827}, {0xa840, 0xa873}, 
            {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, {0xa8fd, 0xa92d}, 
            {0xa930, 0xa953}, {0xa960, 0xa97c}, {0xa980, 0xa9c0}, {0xa9cf, 0xa9d9}, 
            {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, 
            {0xaa60, 0xaa76}, {0xaa7a, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaef}, 
            {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, 
            {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, 
            {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, 
            {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, 
            {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, 
            {0xfb38, 0xfb3c}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, 
            {0xfbd3, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfb}, 
            {0xfe00, 0xfe0f}, {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, 
            {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, {0xff10, 0xff19}, {0xff21, 0xff3a}, 
            {0xff41, 0xff5a}, {0xff65, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, 
            {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, 
            {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d}, 
            {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, 
            {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, 
            {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, 
            {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, 
            {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, 
            {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, 
            {0x105bb, 0x105bc}, {0x105c0, 0x105f3}, {0x10600, 0x10736}, {0x10740, 0x10755}, 
            {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, 
            {0x10800, 0x10805}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083f, 0x10855}, 
            {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, 
            {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10940, 0x10959}, {0x10980, 0x109b7}, 
            {0x109be, 0x109bf}, {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, 
            {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a60, 0x10a7c}, 
            {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, 
            {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, 
            {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, 
            {0x10d40, 0x10d65}, {0x10d69, 0x10d6d}, {0x10d6f, 0x10d85}, {0x10e80, 0x10ea9}, 
            {0x10eab, 0x10eac}, {0x10eb0, 0x10eb1}, {0x10ec2, 0x10ec7}, {0x10efa, 0x10f1c}, 
            {0x10f30, 0x10f50}, {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, 
            {0x11000, 0x11046}, {0x11066, 0x11075}, {0x1107f, 0x110ba}, {0x110d0, 0x110e8}, 
            {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147}, 
            {0x11150, 0x11173}, {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111ce, 0x111da}, 
            {0x11200, 0x11211}, {0x11213, 0x11237}, {0x1123e, 0x11241}, {0x11280, 0x11286}, 
            {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, 
            {0x112f0, 0x112f9}, {0x11300, 0x11303}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, 
            {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, 
            {0x1133b, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d}, {0x1135d, 0x11363}, 
            {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11380, 0x11389}, {0x11390, 0x113b5}, 
            {0x113b7, 0x113c0}, {0x113c7, 0x113ca}, {0x113cc, 0x113d3}, {0x113e1, 0x113e2}, 
            {0x11400, 0x1144a}, {0x11450, 0x11459}, {0x1145e, 0x11461}, {0x11480, 0x114c5}, 
            {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd}, 
            {0x11600, 0x11640}, {0x11650, 0x11659}, {0x11680, 0x116b8}, {0x116c0, 0x116c9}, 
            {0x116d0, 0x116e3}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739}, 
            {0x11740, 0x11746}, {0x11800, 0x1183a}, {0x118a0, 0x118e9}, {0x118ff, 0x11906}, 
            {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, {0x11937, 0x11938}, 
            {0x1193b, 0x11943}, {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, 
            {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e}, {0x11a50, 0x11a99}, 
            {0x11ab0, 0x11af8}, {0x11b60, 0x11b67}, {0x11bc0, 0x11be0}, {0x11bf0, 0x11bf9}, 
            {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59}, 
            {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7}, {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, 
            {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47}, 
            {0x11d50, 0x11d59}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, 
            {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11db0, 0x11ddb}, 
            {0x11de0, 0x11de9}, {0x11ee0, 0x11ef6}, {0x11f00, 0x11f10}, {0x11f12, 0x11f3a}, 
            {0x11f3e, 0x11f42}, {0x11f50, 0x11f5a}, {0x12000, 0x12399}, {0x12400, 0x1246e}, 
            {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13440, 0x13455}, 
            {0x13460, 0x143fa}, {0x14400, 0x14646}, {0x16100, 0x16139}, {0x16800, 0x16a38}, 
            {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a70, 0x16abe}, {0x16ac0, 0x16ac9}, 
            {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, 
            {0x16b50, 0x16b59}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16d40, 0x16d6c}, 
            {0x16d70, 0x16d79}, {0x16d80, 0x16d9d}, {0x16da0, 0x16da9}, {0x16e40, 0x16e7f}, 
            {0x16ea0, 0x16eb8}, {0x16ebb, 0x16ed3}, {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, 
            {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, {0x16ff0, 0x16ff6}, 
            {0x17000, 0x18cd5}, {0x18cff, 0x18d1e}, {0x18d80, 0x18df2}, {0x1aff0, 0x1aff3}, 
            {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b150, 0x1b152}, 
            {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, 
            {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1bc9d, 0x1bc9e}, {0x1ccf0, 0x1ccf9}, 
            {0x1cf00, 0x1cf2d}, {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, 
            {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, 
            {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, 
            {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, 
            {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, 
            {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, 
            {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, 
            {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, 
            {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, 
            {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, 
            {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018}, 
            {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e030, 0x1e06d}, 
            {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d}, {0x1e140, 0x1e149}, {0x1e290, 0x1e2ae}, 
            {0x1e2c0, 0x1e2f9}, {0x1e4d0, 0x1e4f9}, {0x1e5d0, 0x1e5fa}, {0x1e6c0, 0x1e6de}, 
            {0x1e6e0, 0x1e6f5}, {0x1e6fe, 0x1e6ff}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, 
            {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6}, 
            {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, 
            {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee4d, 0x1ee4f}, 
            {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, 
            {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, 
            {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1fbf0, 0x1fbf9}, 
            {0x20000, 0x2a6df}, {0x2a700, 0x2b81d}, {0x2b820, 0x2cead}, {0x2ceb0, 0x2ebe0}, 
            {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x33479}, 
            {0xe0100, 0xe01ef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass55()
{
    // Name = XID_Start, number of codePoints: 145922
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<char32_t>({0x00aa, 0x00b5, 0x00ba, 0x02ec, 0x02ee, 0x037f, 0x0386, 0x038c, 
            0x0559, 0x06d5, 0x06ff, 0x0710, 0x07b1, 0x07fa, 0x081a, 0x0824, 
            0x0828, 0x093d, 0x0950, 0x09b2, 0x09bd, 0x09ce, 0x09fc, 0x09ff, 
            0x0a5e, 0x0abd, 0x0ad0, 0x0af9, 0x0b3d, 0x0b71, 0x0b83, 0x0b9c, 
            0x0bd0, 0x0c3d, 0x0c80, 0x0cbd, 0x0d3d, 0x0d4e, 0x0dbd, 0x0e32, 
            0x0e84, 0x0ea5, 0x0eb2, 0x0ebd, 0x0ec6, 0x0f00, 0x103f, 0x1061, 
            0x108e, 0x10c7, 0x10cd, 0x1258, 0x12c0, 0x17d7, 0x17dc, 0x18aa, 
            0x1aa7, 0x1cfa, 0x1f59, 0x1f5b, 0x1f5d, 0x1fbe, 0x2071, 0x207f, 
            0x2102, 0x2107, 0x2115, 0x2124, 0x2126, 0x2128, 0x214e, 0x2d27, 
            0x2d2d, 0x2d6f, 0xa8fb, 0xa9cf, 0xaa7a, 0xaab1, 0xaac0, 0xaac2, 
            0xfb1d, 0xfb3e, 0xfe71, 0xfe73, 0xfe77, 0xfe79, 0xfe7b, 0xfe7d, 
            0x10808, 0x1083c, 0x10a00, 0x10f27, 0x11075, 0x11144, 0x11147, 0x11176, 
            0x111da, 0x111dc, 0x11288, 0x1133d, 0x11350, 0x1138b, 0x1138e, 0x113b7, 
            0x113d1, 0x113d3, 0x114c7, 0x11644, 0x116b8, 0x11909, 0x1193f, 0x11941, 
            0x119e1, 0x119e3, 0x11a00, 0x11a3a, 0x11a50, 0x11a9d, 0x11c40, 0x11d46, 
            0x11d98, 0x11f02, 0x11fb0, 0x16f50, 0x16fe3, 0x1b132, 0x1b155, 0x1d4a2, 
            0x1d4bb, 0x1d546, 0x1e14e, 0x1e5f0, 0x1e94b, 0x1ee24, 0x1ee27, 0x1ee39, 
            0x1ee3b, 0x1ee42, 0x1ee47, 0x1ee49, 0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 
            0x1ee5b, 0x1ee5d, 0x1ee5f, 0x1ee64, 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x02c1}, {0x02c6, 0x02d1}, 
            {0x02e0, 0x02e4}, {0x0370, 0x0374}, {0x0376, 0x0377}, {0x037b, 0x037d}, 
            {0x0388, 0x038a}, {0x038e, 0x03a1}, {0x03a3, 0x03f5}, {0x03f7, 0x0481}, 
            {0x048a, 0x052f}, {0x0531, 0x0556}, {0x0560, 0x0588}, {0x05d0, 0x05ea}, 
            {0x05ef, 0x05f2}, {0x0620, 0x064a}, {0x066e, 0x066f}, {0x0671, 0x06d3}, 
            {0x06e5, 0x06e6}, {0x06ee, 0x06ef}, {0x06fa, 0x06fc}, {0x0712, 0x072f}, 
            {0x074d, 0x07a5}, {0x07ca, 0x07ea}, {0x07f4, 0x07f5}, {0x0800, 0x0815}, 
            {0x0840, 0x0858}, {0x0860, 0x086a}, {0x0870, 0x0887}, {0x0889, 0x088f}, 
            {0x08a0, 0x08c9}, {0x0904, 0x0939}, {0x0958, 0x0961}, {0x0971, 0x0980}, 
            {0x0985, 0x098c}, {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0}, 
            {0x09b6, 0x09b9}, {0x09dc, 0x09dd}, {0x09df, 0x09e1}, {0x09f0, 0x09f1}, 
            {0x0a05, 0x0a0a}, {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, 
            {0x0a32, 0x0a33}, {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a59, 0x0a5c}, 
            {0x0a72, 0x0a74}, {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, 
            {0x0aaa, 0x0ab0}, {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0ae0, 0x0ae1}, 
            {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, 
            {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b61}, 
            {0x0b85, 0x0b8a}, {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, 
            {0x0b9e, 0x0b9f}, {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, 
            {0x0c05, 0x0c0c}, {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, 
            {0x0c58, 0x0c5a}, {0x0c5c, 0x0c5d}, {0x0c60, 0x0c61}, {0x0c85, 0x0c8c}, 
            {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, 
            {0x0cdc, 0x0cde}, {0x0ce0, 0x0ce1}, {0x0cf1, 0x0cf2}, {0x0d04, 0x0d0c}, 
            {0x0d0e, 0x0d10}, {0x0d12, 0x0d3a}, {0x0d54, 0x0d56}, {0x0d5f, 0x0d61}, 
            {0x0d7a, 0x0d7f}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, {0x0db3, 0x0dbb}, 
            {0x0dc0, 0x0dc6}, {0x0e01, 0x0e30}, {0x0e40, 0x0e46}, {0x0e81, 0x0e82}, 
            {0x0e86, 0x0e8a}, {0x0e8c, 0x0ea3}, {0x0ea7, 0x0eb0}, {0x0ec0, 0x0ec4}, 
            {0x0edc, 0x0edf}, {0x0f40, 0x0f47}, {0x0f49, 0x0f6c}, {0x0f88, 0x0f8c}, 
            {0x1000, 0x102a}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1065, 0x1066}, 
            {0x106e, 0x1070}, {0x1075, 0x1081}, {0x10a0, 0x10c5}, {0x10d0, 0x10fa}, 
            {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x125a, 0x125d}, 
            {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, 
            {0x12b8, 0x12be}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, 
            {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, 
            {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, 
            {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1711}, {0x171f, 0x1731}, 
            {0x1740, 0x1751}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, 
            {0x1820, 0x1878}, {0x1880, 0x18a8}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, 
            {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, 
            {0x1a00, 0x1a16}, {0x1a20, 0x1a54}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, 
            {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, 
            {0x1c4d, 0x1c4f}, {0x1c5a, 0x1c7d}, {0x1c80, 0x1c8a}, {0x1c90, 0x1cba}, 
            {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, 
            {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, 
            {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, 
            {0x1fb6, 0x1fbc}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, 
            {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, 
            {0x2090, 0x209c}, {0x210a, 0x2113}, {0x2118, 0x211d}, {0x212a, 0x2139}, 
            {0x213c, 0x213f}, {0x2145, 0x2149}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, 
            {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d30, 0x2d67}, 
            {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, 
            {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, 
            {0x2dd8, 0x2dde}, {0x3005, 0x3007}, {0x3021, 0x3029}, {0x3031, 0x3035}, 
            {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, 
            {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf}, 
            {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, 
            {0xa500, 0xa60c}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e}, 
            {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, 
            {0xa78b, 0xa7dc}, {0xa7f1, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, 
            {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, 
            {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, 
            {0xa984, 0xa9b2}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef}, {0xa9fa, 0xa9fe}, 
            {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, 
            {0xaa7e, 0xaaaf}, {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaadb, 0xaadd}, 
            {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06}, {0xab09, 0xab0e}, 
            {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, 
            {0xab5c, 0xab69}, {0xab70, 0xabe2}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, 
            {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, 
            {0xfb13, 0xfb17}, {0xfb1f, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, 
            {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, 
            {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, 
            {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d}, 
            {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, 
            {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, 
            {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, 
            {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, 
            {0x1032d, 0x1034a}, {0x10350, 0x10375}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, 
            {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, 
            {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, 
            {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, 
            {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x105c0, 0x105f3}, 
            {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, 
            {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x1080a, 0x10835}, 
            {0x10837, 0x10838}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, 
            {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, 
            {0x10940, 0x10959}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a10, 0x10a13}, 
            {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, 
            {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, 
            {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, 
            {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10d4a, 0x10d65}, {0x10d6f, 0x10d85}, 
            {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1}, {0x10ec2, 0x10ec7}, {0x10f00, 0x10f1c}, 
            {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, 
            {0x11003, 0x11037}, {0x11071, 0x11072}, {0x11083, 0x110af}, {0x110d0, 0x110e8}, 
            {0x11103, 0x11126}, {0x11150, 0x11172}, {0x11183, 0x111b2}, {0x111c1, 0x111c4}, 
            {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x1123f, 0x11240}, {0x11280, 0x11286}, 
            {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112de}, 
            {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, 
            {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1135d, 0x11361}, {0x11380, 0x11389}, 
            {0x11390, 0x113b5}, {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x1145f, 0x11461}, 
            {0x11480, 0x114af}, {0x114c4, 0x114c5}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, 
            {0x11600, 0x1162f}, {0x11680, 0x116aa}, {0x11700, 0x1171a}, {0x11740, 0x11746}, 
            {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x1190c, 0x11913}, 
            {0x11915, 0x11916}, {0x11918, 0x1192f}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, 
            {0x11a0b, 0x11a32}, {0x11a5c, 0x11a89}, {0x11ab0, 0x11af8}, {0x11bc0, 0x11be0}, 
            {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, 
            {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, 
            {0x11d6a, 0x11d89}, {0x11db0, 0x11ddb}, {0x11ee0, 0x11ef2}, {0x11f04, 0x11f10}, 
            {0x11f12, 0x11f33}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, 
            {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13441, 0x13446}, {0x13460, 0x143fa}, 
            {0x14400, 0x14646}, {0x16100, 0x1611d}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, 
            {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, 
            {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16d40, 0x16d6c}, {0x16d80, 0x16d97}, 
            {0x16d99, 0x16d9c}, {0x16e40, 0x16e7f}, {0x16ea0, 0x16eb8}, {0x16ebb, 0x16ed3}, 
            {0x16f00, 0x16f4a}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16ff2, 0x16ff6}, 
            {0x17000, 0x18cd5}, {0x18cff, 0x18d1e}, {0x18d80, 0x18df2}, {0x1aff0, 0x1aff3}, 
            {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b150, 0x1b152}, 
            {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, 
            {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, 
            {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, 
            {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, 
            {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, 
            {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, 
            {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, 
            {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, 
            {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e030, 0x1e06d}, 
            {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d}, {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, 
            {0x1e4d0, 0x1e4eb}, {0x1e5d0, 0x1e5ed}, {0x1e6c0, 0x1e6de}, {0x1e6e0, 0x1e6e2}, 
            {0x1e6e4, 0x1e6e5}, {0x1e6e7, 0x1e6ed}, {0x1e6f0, 0x1e6f4}, {0x1e6fe, 0x1e6ff}, 
            {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, 
            {0x1e800, 0x1e8c4}, {0x1e900, 0x1e943}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, 
            {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee4d, 0x1ee4f}, 
            {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, 
            {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, 
            {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, 
            {0x2a700, 0x2b81d}, {0x2b820, 0x2cead}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, 
            {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x33479}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass56()
{
    // Name = XID_Continue, number of codePoints: 149264
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x5f}),
        std::initializer_list<CharacterRange>({{0x30, 0x39}, {0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<char32_t>({0x00aa, 0x00b5, 0x00b7, 0x00ba, 0x02ec, 0x02ee, 0x037f, 0x038c, 
            0x0559, 0x05bf, 0x05c7, 0x06ff, 0x07fa, 0x07fd, 0x09b2, 0x09d7, 
            0x09fc, 0x0a3c, 0x0a51, 0x0a5e, 0x0ad0, 0x0b71, 0x0b9c, 0x0bd0, 
            0x0bd7, 0x0dbd, 0x0dca, 0x0dd6, 0x0e84, 0x0ea5, 0x0ec6, 0x0f00, 
            0x0f35, 0x0f37, 0x0f39, 0x0fc6, 0x10c7, 0x10cd, 0x1258, 0x12c0, 
            0x17d7, 0x1aa7, 0x1f59, 0x1f5b, 0x1f5d, 0x1fbe, 0x2054, 0x2071, 
            0x207f, 0x20e1, 0x2102, 0x2107, 0x2115, 0x2124, 0x2126, 0x2128, 
            0x214e, 0x2d27, 0x2d2d, 0x2d6f, 0xa82c, 0xa8fb, 0xfb3e, 0xfe71, 
            0xfe73, 0xfe77, 0xfe79, 0xfe7b, 0xfe7d, 0xff3f, 0x101fd, 0x102e0, 
            0x10808, 0x1083c, 0x10a3f, 0x10f27, 0x110c2, 0x11176, 0x111dc, 0x11288, 
            0x11350, 0x11357, 0x1138b, 0x1138e, 0x113c2, 0x113c5, 0x114c7, 0x11644, 
            0x11909, 0x11a47, 0x11a9d, 0x11d3a, 0x11fb0, 0x1b132, 0x1b155, 0x1d4a2, 
            0x1d4bb, 0x1d546, 0x1da75, 0x1da84, 0x1e08f, 0x1e14e, 0x1ee24, 0x1ee27, 
            0x1ee39, 0x1ee3b, 0x1ee42, 0x1ee47, 0x1ee49, 0x1ee4b, 0x1ee54, 0x1ee57, 
            0x1ee59, 0x1ee5b, 0x1ee5d, 0x1ee5f, 0x1ee64, 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x02c1}, {0x02c6, 0x02d1}, 
            {0x02e0, 0x02e4}, {0x0300, 0x0374}, {0x0376, 0x0377}, {0x037b, 0x037d}, 
            {0x0386, 0x038a}, {0x038e, 0x03a1}, {0x03a3, 0x03f5}, {0x03f7, 0x0481}, 
            {0x0483, 0x0487}, {0x048a, 0x052f}, {0x0531, 0x0556}, {0x0560, 0x0588}, 
            {0x0591, 0x05bd}, {0x05c1, 0x05c2}, {0x05c4, 0x05c5}, {0x05d0, 0x05ea}, 
            {0x05ef, 0x05f2}, {0x0610, 0x061a}, {0x0620, 0x0669}, {0x066e, 0x06d3}, 
            {0x06d5, 0x06dc}, {0x06df, 0x06e8}, {0x06ea, 0x06fc}, {0x0710, 0x074a}, 
            {0x074d, 0x07b1}, {0x07c0, 0x07f5}, {0x0800, 0x082d}, {0x0840, 0x085b}, 
            {0x0860, 0x086a}, {0x0870, 0x0887}, {0x0889, 0x088f}, {0x0897, 0x08e1}, 
            {0x08e3, 0x0963}, {0x0966, 0x096f}, {0x0971, 0x0983}, {0x0985, 0x098c}, 
            {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0}, {0x09b6, 0x09b9}, 
            {0x09bc, 0x09c4}, {0x09c7, 0x09c8}, {0x09cb, 0x09ce}, {0x09dc, 0x09dd}, 
            {0x09df, 0x09e3}, {0x09e6, 0x09f1}, {0x09fe, 0x09ff}, {0x0a01, 0x0a03}, 
            {0x0a05, 0x0a0a}, {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, 
            {0x0a32, 0x0a33}, {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a3e, 0x0a42}, 
            {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a59, 0x0a5c}, {0x0a66, 0x0a75}, 
            {0x0a81, 0x0a83}, {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, 
            {0x0aaa, 0x0ab0}, {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0abc, 0x0ac5}, 
            {0x0ac7, 0x0ac9}, {0x0acb, 0x0acd}, {0x0ae0, 0x0ae3}, {0x0ae6, 0x0aef}, 
            {0x0af9, 0x0aff}, {0x0b01, 0x0b03}, {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10}, 
            {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, 
            {0x0b3c, 0x0b44}, {0x0b47, 0x0b48}, {0x0b4b, 0x0b4d}, {0x0b53, 0x0b57}, 
            {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b63}, {0x0b66, 0x0b6f}, {0x0b82, 0x0b83}, 
            {0x0b85, 0x0b8a}, {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, 
            {0x0b9e, 0x0b9f}, {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, 
            {0x0bbe, 0x0bc2}, {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcd}, {0x0be6, 0x0bef}, 
            {0x0c00, 0x0c0c}, {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, 
            {0x0c3c, 0x0c44}, {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56}, 
            {0x0c58, 0x0c5a}, {0x0c5c, 0x0c5d}, {0x0c60, 0x0c63}, {0x0c66, 0x0c6f}, 
            {0x0c80, 0x0c83}, {0x0c85, 0x0c8c}, {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, 
            {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0cbc, 0x0cc4}, {0x0cc6, 0x0cc8}, 
            {0x0cca, 0x0ccd}, {0x0cd5, 0x0cd6}, {0x0cdc, 0x0cde}, {0x0ce0, 0x0ce3}, 
            {0x0ce6, 0x0cef}, {0x0cf1, 0x0cf3}, {0x0d00, 0x0d0c}, {0x0d0e, 0x0d10}, 
            {0x0d12, 0x0d44}, {0x0d46, 0x0d48}, {0x0d4a, 0x0d4e}, {0x0d54, 0x0d57}, 
            {0x0d5f, 0x0d63}, {0x0d66, 0x0d6f}, {0x0d7a, 0x0d7f}, {0x0d81, 0x0d83}, 
            {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, {0x0db3, 0x0dbb}, {0x0dc0, 0x0dc6}, 
            {0x0dcf, 0x0dd4}, {0x0dd8, 0x0ddf}, {0x0de6, 0x0def}, {0x0df2, 0x0df3}, 
            {0x0e01, 0x0e3a}, {0x0e40, 0x0e4e}, {0x0e50, 0x0e59}, {0x0e81, 0x0e82}, 
            {0x0e86, 0x0e8a}, {0x0e8c, 0x0ea3}, {0x0ea7, 0x0ebd}, {0x0ec0, 0x0ec4}, 
            {0x0ec8, 0x0ece}, {0x0ed0, 0x0ed9}, {0x0edc, 0x0edf}, {0x0f18, 0x0f19}, 
            {0x0f20, 0x0f29}, {0x0f3e, 0x0f47}, {0x0f49, 0x0f6c}, {0x0f71, 0x0f84}, 
            {0x0f86, 0x0f97}, {0x0f99, 0x0fbc}, {0x1000, 0x1049}, {0x1050, 0x109d}, 
            {0x10a0, 0x10c5}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, 
            {0x1250, 0x1256}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, 
            {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c2, 0x12c5}, 
            {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, 
            {0x135d, 0x135f}, {0x1369, 0x1371}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, 
            {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, 
            {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1715}, {0x171f, 0x1734}, 
            {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, 
            {0x1780, 0x17d3}, {0x17dc, 0x17dd}, {0x17e0, 0x17e9}, {0x180b, 0x180d}, 
            {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, 
            {0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x193b}, {0x1946, 0x196d}, 
            {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, 
            {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e}, {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, 
            {0x1a90, 0x1a99}, {0x1ab0, 0x1abd}, {0x1abf, 0x1add}, {0x1ae0, 0x1aeb}, 
            {0x1b00, 0x1b4c}, {0x1b50, 0x1b59}, {0x1b6b, 0x1b73}, {0x1b80, 0x1bf3}, 
            {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c8a}, 
            {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1cd0, 0x1cd2}, {0x1cd4, 0x1cfa}, 
            {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, 
            {0x1f50, 0x1f57}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, 
            {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, 
            {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x200c, 0x200d}, 
            {0x203f, 0x2040}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, {0x20e5, 0x20f0}, 
            {0x210a, 0x2113}, {0x2118, 0x211d}, {0x212a, 0x2139}, {0x213c, 0x213f}, 
            {0x2145, 0x2149}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, 
            {0x2d00, 0x2d25}, {0x2d30, 0x2d67}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, 
            {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, 
            {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, 
            {0x3005, 0x3007}, {0x3021, 0x302f}, {0x3031, 0x3035}, {0x3038, 0x303c}, 
            {0x3041, 0x3096}, {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30ff}, 
            {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, 
            {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, 
            {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d}, {0xa67f, 0xa6f1}, 
            {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7dc}, {0xa7f1, 0xa827}, 
            {0xa840, 0xa873}, {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, 
            {0xa8fd, 0xa92d}, {0xa930, 0xa953}, {0xa960, 0xa97c}, {0xa980, 0xa9c0}, 
            {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, 
            {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaac2}, {0xaadb, 0xaadd}, 
            {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, 
            {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, 
            {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, 
            {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, 
            {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, 
            {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, 
            {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, 
            {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe00, 0xfe0f}, {0xfe20, 0xfe2f}, 
            {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, {0xfe7f, 0xfefc}, {0xff10, 0xff19}, 
            {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff65, 0xffbe}, {0xffc2, 0xffc7}, 
            {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, 
            {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, 
            {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, 
            {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x1037a}, 
            {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, 
            {0x10400, 0x1049d}, {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, 
            {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, 
            {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, 
            {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x105c0, 0x105f3}, {0x10600, 0x10736}, 
            {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, 
            {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x1080a, 0x10835}, {0x10837, 0x10838}, 
            {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, 
            {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10940, 0x10959}, 
            {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, 
            {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, 
            {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, 
            {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, 
            {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, 
            {0x10d30, 0x10d39}, {0x10d40, 0x10d65}, {0x10d69, 0x10d6d}, {0x10d6f, 0x10d85}, 
            {0x10e80, 0x10ea9}, {0x10eab, 0x10eac}, {0x10eb0, 0x10eb1}, {0x10ec2, 0x10ec7}, 
            {0x10efa, 0x10f1c}, {0x10f30, 0x10f50}, {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, 
            {0x10fe0, 0x10ff6}, {0x11000, 0x11046}, {0x11066, 0x11075}, {0x1107f, 0x110ba}, 
            {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, 
            {0x11144, 0x11147}, {0x11150, 0x11173}, {0x11180, 0x111c4}, {0x111c9, 0x111cc}, 
            {0x111ce, 0x111da}, {0x11200, 0x11211}, {0x11213, 0x11237}, {0x1123e, 0x11241}, 
            {0x11280, 0x11286}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, 
            {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303}, {0x11305, 0x1130c}, 
            {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, 
            {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d}, 
            {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11380, 0x11389}, 
            {0x11390, 0x113b5}, {0x113b7, 0x113c0}, {0x113c7, 0x113ca}, {0x113cc, 0x113d3}, 
            {0x113e1, 0x113e2}, {0x11400, 0x1144a}, {0x11450, 0x11459}, {0x1145e, 0x11461}, 
            {0x11480, 0x114c5}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, 
            {0x115d8, 0x115dd}, {0x11600, 0x11640}, {0x11650, 0x11659}, {0x11680, 0x116b8}, 
            {0x116c0, 0x116c9}, {0x116d0, 0x116e3}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, 
            {0x11730, 0x11739}, {0x11740, 0x11746}, {0x11800, 0x1183a}, {0x118a0, 0x118e9}, 
            {0x118ff, 0x11906}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, 
            {0x11937, 0x11938}, {0x1193b, 0x11943}, {0x11950, 0x11959}, {0x119a0, 0x119a7}, 
            {0x119aa, 0x119d7}, {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e}, 
            {0x11a50, 0x11a99}, {0x11ab0, 0x11af8}, {0x11b60, 0x11b67}, {0x11bc0, 0x11be0}, 
            {0x11bf0, 0x11bf9}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, 
            {0x11c50, 0x11c59}, {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7}, {0x11ca9, 0x11cb6}, 
            {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3c, 0x11d3d}, 
            {0x11d3f, 0x11d47}, {0x11d50, 0x11d59}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, 
            {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, 
            {0x11db0, 0x11ddb}, {0x11de0, 0x11de9}, {0x11ee0, 0x11ef6}, {0x11f00, 0x11f10}, 
            {0x11f12, 0x11f3a}, {0x11f3e, 0x11f42}, {0x11f50, 0x11f5a}, {0x12000, 0x12399}, 
            {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, 
            {0x13440, 0x13455}, {0x13460, 0x143fa}, {0x14400, 0x14646}, {0x16100, 0x16139}, 
            {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a70, 0x16abe}, 
            {0x16ac0, 0x16ac9}, {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, 
            {0x16b40, 0x16b43}, {0x16b50, 0x16b59}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, 
            {0x16d40, 0x16d6c}, {0x16d70, 0x16d79}, {0x16d80, 0x16d9d}, {0x16da0, 0x16da9}, 
            {0x16e40, 0x16e7f}, {0x16ea0, 0x16eb8}, {0x16ebb, 0x16ed3}, {0x16f00, 0x16f4a}, 
            {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, 
            {0x16ff0, 0x16ff6}, {0x17000, 0x18cd5}, {0x18cff, 0x18d1e}, {0x18d80, 0x18df2}, 
            {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, 
            {0x1b150, 0x1b152}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, 
            {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1bc9d, 0x1bc9e}, 
            {0x1ccf0, 0x1ccf9}, {0x1cf00, 0x1cf2d}, {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, 
            {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, 
            {0x1d242, 0x1d244}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, 
            {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, 
            {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, 
            {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, 
            {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, 
            {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, 
            {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, 
            {0x1d7ce, 0x1d7ff}, {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c}, {0x1da9b, 0x1da9f}, 
            {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e000, 0x1e006}, 
            {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, 
            {0x1e030, 0x1e06d}, {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d}, {0x1e140, 0x1e149}, 
            {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e4d0, 0x1e4f9}, {0x1e5d0, 0x1e5fa}, 
            {0x1e6c0, 0x1e6de}, {0x1e6e0, 0x1e6f5}, {0x1e6fe, 0x1e6ff}, {0x1e7e0, 0x1e7e6}, 
            {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, 
            {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, 
            {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, 
            {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, 
            {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, 
            {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, 
            {0x1fbf0, 0x1fbf9}, {0x20000, 0x2a6df}, {0x2a700, 0x2b81d}, {0x2b820, 0x2cead}, 
            {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, 
            {0x31350, 0x33479}, {0xe0100, 0xe01ef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass57()
{
    // Name = Default_Ignorable_Code_Point, number of codePoints: 4174
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00ad, 0x034f, 0x061c, 0x3164, 0xfeff, 0xffa0}),
        std::initializer_list<CharacterRange>({{0x115f, 0x1160}, {0x17b4, 0x17b5}, {0x180b, 0x180f}, {0x200b, 0x200f}, 
            {0x202a, 0x202e}, {0x2060, 0x206f}, {0xfe00, 0xfe0f}, {0xfff0, 0xfff8}, 
            {0x1bca0, 0x1bca3}, {0x1d173, 0x1d17a}, {0xe0000, 0xe0fff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass58()
{
    // Name = Grapheme_Extend, number of codePoints: 2236
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x05bf, 0x05c7, 0x0670, 0x0711, 0x07fd, 0x093a, 0x093c, 0x094d, 
            0x0981, 0x09bc, 0x09be, 0x09cd, 0x09d7, 0x09fe, 0x0a3c, 0x0a51, 
            0x0a75, 0x0abc, 0x0acd, 0x0b01, 0x0b3c, 0x0b4d, 0x0b82, 0x0bbe, 
            0x0bc0, 0x0bcd, 0x0bd7, 0x0c00, 0x0c04, 0x0c3c, 0x0c81, 0x0cbc, 
            0x0cc2, 0x0d3e, 0x0d4d, 0x0d57, 0x0d81, 0x0dca, 0x0dcf, 0x0dd6, 
            0x0ddf, 0x0e31, 0x0eb1, 0x0f35, 0x0f37, 0x0f39, 0x0fc6, 0x1082, 
            0x108d, 0x109d, 0x17c6, 0x17dd, 0x180f, 0x18a9, 0x1932, 0x1a1b, 
            0x1a56, 0x1a60, 0x1a62, 0x1a7f, 0x1be6, 0x1bed, 0x1ced, 0x1cf4, 
            0x200c, 0x2d7f, 0xa802, 0xa806, 0xa80b, 0xa82c, 0xa8ff, 0xa953, 
            0xa9b3, 0xa9c0, 0xa9e5, 0xaa43, 0xaa4c, 0xaa7c, 0xaab0, 0xaac1, 
            0xaaf6, 0xabe5, 0xabe8, 0xabed, 0xfb1e, 0x101fd, 0x102e0, 0x10a3f, 
            0x11001, 0x11070, 0x110c2, 0x11173, 0x111c0, 0x111cf, 0x1123e, 0x11241, 
            0x112df, 0x1133e, 0x11340, 0x1134d, 0x11357, 0x113b8, 0x113c2, 0x113c5, 
            0x113d2, 0x11446, 0x1145e, 0x114b0, 0x114ba, 0x114bd, 0x115af, 0x1163d, 
            0x116ab, 0x116ad, 0x1171d, 0x1171f, 0x11930, 0x11943, 0x119e0, 0x11a47, 
            0x11b60, 0x11b66, 0x11c3f, 0x11d3a, 0x11d47, 0x11d95, 0x11d97, 0x11f5a, 
            0x13440, 0x16d98, 0x16d9d, 0x16f4f, 0x16fe4, 0x1da75, 0x1da84, 0x1e08f, 
            0x1e2ae, 0x1e6e3, 0x1e6e6, 0x1e6f5}),
        std::initializer_list<CharacterRange>({{0x0300, 0x036f}, {0x0483, 0x0489}, {0x0591, 0x05bd}, {0x05c1, 0x05c2}, 
            {0x05c4, 0x05c5}, {0x0610, 0x061a}, {0x064b, 0x065f}, {0x06d6, 0x06dc}, 
            {0x06df, 0x06e4}, {0x06e7, 0x06e8}, {0x06ea, 0x06ed}, {0x0730, 0x074a}, 
            {0x07a6, 0x07b0}, {0x07eb, 0x07f3}, {0x0816, 0x0819}, {0x081b, 0x0823}, 
            {0x0825, 0x0827}, {0x0829, 0x082d}, {0x0859, 0x085b}, {0x0897, 0x089f}, 
            {0x08ca, 0x08e1}, {0x08e3, 0x0902}, {0x0941, 0x0948}, {0x0951, 0x0957}, 
            {0x0962, 0x0963}, {0x09c1, 0x09c4}, {0x09e2, 0x09e3}, {0x0a01, 0x0a02}, 
            {0x0a41, 0x0a42}, {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a70, 0x0a71}, 
            {0x0a81, 0x0a82}, {0x0ac1, 0x0ac5}, {0x0ac7, 0x0ac8}, {0x0ae2, 0x0ae3}, 
            {0x0afa, 0x0aff}, {0x0b3e, 0x0b3f}, {0x0b41, 0x0b44}, {0x0b53, 0x0b57}, 
            {0x0b62, 0x0b63}, {0x0c3e, 0x0c40}, {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d}, 
            {0x0c55, 0x0c56}, {0x0c62, 0x0c63}, {0x0cbf, 0x0cc0}, {0x0cc6, 0x0cc8}, 
            {0x0cca, 0x0ccd}, {0x0cd5, 0x0cd6}, {0x0ce2, 0x0ce3}, {0x0d00, 0x0d01}, 
            {0x0d3b, 0x0d3c}, {0x0d41, 0x0d44}, {0x0d62, 0x0d63}, {0x0dd2, 0x0dd4}, 
            {0x0e34, 0x0e3a}, {0x0e47, 0x0e4e}, {0x0eb4, 0x0ebc}, {0x0ec8, 0x0ece}, 
            {0x0f18, 0x0f19}, {0x0f71, 0x0f7e}, {0x0f80, 0x0f84}, {0x0f86, 0x0f87}, 
            {0x0f8d, 0x0f97}, {0x0f99, 0x0fbc}, {0x102d, 0x1030}, {0x1032, 0x1037}, 
            {0x1039, 0x103a}, {0x103d, 0x103e}, {0x1058, 0x1059}, {0x105e, 0x1060}, 
            {0x1071, 0x1074}, {0x1085, 0x1086}, {0x135d, 0x135f}, {0x1712, 0x1715}, 
            {0x1732, 0x1734}, {0x1752, 0x1753}, {0x1772, 0x1773}, {0x17b4, 0x17b5}, 
            {0x17b7, 0x17bd}, {0x17c9, 0x17d3}, {0x180b, 0x180d}, {0x1885, 0x1886}, 
            {0x1920, 0x1922}, {0x1927, 0x1928}, {0x1939, 0x193b}, {0x1a17, 0x1a18}, 
            {0x1a58, 0x1a5e}, {0x1a65, 0x1a6c}, {0x1a73, 0x1a7c}, {0x1ab0, 0x1add}, 
            {0x1ae0, 0x1aeb}, {0x1b00, 0x1b03}, {0x1b34, 0x1b3d}, {0x1b42, 0x1b44}, 
            {0x1b6b, 0x1b73}, {0x1b80, 0x1b81}, {0x1ba2, 0x1ba5}, {0x1ba8, 0x1bad}, 
            {0x1be8, 0x1be9}, {0x1bef, 0x1bf3}, {0x1c2c, 0x1c33}, {0x1c36, 0x1c37}, 
            {0x1cd0, 0x1cd2}, {0x1cd4, 0x1ce0}, {0x1ce2, 0x1ce8}, {0x1cf8, 0x1cf9}, 
            {0x1dc0, 0x1dff}, {0x20d0, 0x20f0}, {0x2cef, 0x2cf1}, {0x2de0, 0x2dff}, 
            {0x302a, 0x302f}, {0x3099, 0x309a}, {0xa66f, 0xa672}, {0xa674, 0xa67d}, 
            {0xa69e, 0xa69f}, {0xa6f0, 0xa6f1}, {0xa825, 0xa826}, {0xa8c4, 0xa8c5}, 
            {0xa8e0, 0xa8f1}, {0xa926, 0xa92d}, {0xa947, 0xa951}, {0xa980, 0xa982}, 
            {0xa9b6, 0xa9b9}, {0xa9bc, 0xa9bd}, {0xaa29, 0xaa2e}, {0xaa31, 0xaa32}, 
            {0xaa35, 0xaa36}, {0xaab2, 0xaab4}, {0xaab7, 0xaab8}, {0xaabe, 0xaabf}, 
            {0xaaec, 0xaaed}, {0xfe00, 0xfe0f}, {0xfe20, 0xfe2f}, {0xff9e, 0xff9f}, 
            {0x10376, 0x1037a}, {0x10a01, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a0f}, 
            {0x10a38, 0x10a3a}, {0x10ae5, 0x10ae6}, {0x10d24, 0x10d27}, {0x10d69, 0x10d6d}, 
            {0x10eab, 0x10eac}, {0x10efa, 0x10eff}, {0x10f46, 0x10f50}, {0x10f82, 0x10f85}, 
            {0x11038, 0x11046}, {0x11073, 0x11074}, {0x1107f, 0x11081}, {0x110b3, 0x110b6}, 
            {0x110b9, 0x110ba}, {0x11100, 0x11102}, {0x11127, 0x1112b}, {0x1112d, 0x11134}, 
            {0x11180, 0x11181}, {0x111b6, 0x111be}, {0x111c9, 0x111cc}, {0x1122f, 0x11231}, 
            {0x11234, 0x11237}, {0x112e3, 0x112ea}, {0x11300, 0x11301}, {0x1133b, 0x1133c}, 
            {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x113bb, 0x113c0}, {0x113c7, 0x113c9}, 
            {0x113ce, 0x113d0}, {0x113e1, 0x113e2}, {0x11438, 0x1143f}, {0x11442, 0x11444}, 
            {0x114b3, 0x114b8}, {0x114bf, 0x114c0}, {0x114c2, 0x114c3}, {0x115b2, 0x115b5}, 
            {0x115bc, 0x115bd}, {0x115bf, 0x115c0}, {0x115dc, 0x115dd}, {0x11633, 0x1163a}, 
            {0x1163f, 0x11640}, {0x116b0, 0x116b7}, {0x11722, 0x11725}, {0x11727, 0x1172b}, 
            {0x1182f, 0x11837}, {0x11839, 0x1183a}, {0x1193b, 0x1193e}, {0x119d4, 0x119d7}, 
            {0x119da, 0x119db}, {0x11a01, 0x11a0a}, {0x11a33, 0x11a38}, {0x11a3b, 0x11a3e}, 
            {0x11a51, 0x11a56}, {0x11a59, 0x11a5b}, {0x11a8a, 0x11a96}, {0x11a98, 0x11a99}, 
            {0x11b62, 0x11b64}, {0x11c30, 0x11c36}, {0x11c38, 0x11c3d}, {0x11c92, 0x11ca7}, 
            {0x11caa, 0x11cb0}, {0x11cb2, 0x11cb3}, {0x11cb5, 0x11cb6}, {0x11d31, 0x11d36}, 
            {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d45}, {0x11d90, 0x11d91}, {0x11ef3, 0x11ef4}, 
            {0x11f00, 0x11f01}, {0x11f36, 0x11f3a}, {0x11f40, 0x11f42}, {0x13447, 0x13455}, 
            {0x1611e, 0x16129}, {0x1612d, 0x1612f}, {0x16af0, 0x16af4}, {0x16b30, 0x16b36}, 
            {0x16f8f, 0x16f92}, {0x16ff0, 0x16ff1}, {0x1bc9d, 0x1bc9e}, {0x1cf00, 0x1cf2d}, 
            {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, 
            {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1da00, 0x1da36}, 
            {0x1da3b, 0x1da6c}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1e000, 0x1e006}, 
            {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, 
            {0x1e130, 0x1e136}, {0x1e2ec, 0x1e2ef}, {0x1e4ec, 0x1e4ef}, {0x1e5ee, 0x1e5ef}, 
            {0x1e6ee, 0x1e6ef}, {0x1e8d0, 0x1e8d6}, {0x1e944, 0x1e94a}, {0xe0020, 0xe007f}, 
            {0xe0100, 0xe01ef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass59()
{
    // Name = Grapheme_Base, number of codePoints: 157534
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x20, 0x7e}}),
        std::initializer_list<char32_t>({0x038c, 0x05be, 0x05c0, 0x05c3, 0x05c6, 0x061b, 0x06de, 0x06e9, 
            0x0710, 0x07b1, 0x081a, 0x0824, 0x0828, 0x085e, 0x093b, 0x09b2, 
            0x09bd, 0x09ce, 0x09ff, 0x0a03, 0x0a5e, 0x0a76, 0x0a83, 0x0ac9, 
            0x0ad0, 0x0af9, 0x0b3d, 0x0b40, 0x0b83, 0x0b9c, 0x0bbf, 0x0bd0, 
            0x0c3d, 0x0cc1, 0x0d3d, 0x0dbd, 0x0e84, 0x0ea5, 0x0ebd, 0x0ec6, 
            0x0f36, 0x0f38, 0x0f7f, 0x0f85, 0x1031, 0x1038, 0x10c7, 0x10cd, 
            0x1258, 0x12c0, 0x17b6, 0x18aa, 0x1940, 0x1a57, 0x1a61, 0x1be7, 
            0x1bee, 0x1cd3, 0x1ce1, 0x1cfa, 0x1f59, 0x1f5b, 0x1f5d, 0x2d27, 
            0x2d2d, 0xa673, 0xa952, 0xaa4d, 0xaab1, 0xaac0, 0xaac2, 0xfb1d, 
            0xfb3e, 0x101a0, 0x10808, 0x1083c, 0x10ead, 0x11000, 0x11075, 0x1112c, 
            0x111bf, 0x11288, 0x1133d, 0x1133f, 0x11350, 0x1138b, 0x1138e, 0x113b7, 
            0x113ca, 0x113d1, 0x11445, 0x1145d, 0x114b9, 0x114be, 0x114c1, 0x115be, 
            0x1163e, 0x116ac, 0x1171e, 0x11726, 0x11838, 0x1183b, 0x11909, 0x11a00, 
            0x11a50, 0x11a97, 0x11b61, 0x11b65, 0x11b67, 0x11c3e, 0x11ca9, 0x11cb1, 
            0x11cb4, 0x11d46, 0x11d96, 0x11d98, 0x11fb0, 0x16af5, 0x1b132, 0x1b155, 
            0x1bc9c, 0x1bc9f, 0x1d245, 0x1d4a2, 0x1d4bb, 0x1d546, 0x1e2ff, 0x1e5ff, 
            0x1e94b, 0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 0x1ee42, 0x1ee47, 0x1ee49, 
            0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 0x1ee5d, 0x1ee5f, 0x1ee64, 
            0x1ee7e, 0x1f7f0, 0x1fac8}),
        std::initializer_list<CharacterRange>({{0x00a0, 0x00ac}, {0x00ae, 0x02ff}, {0x0370, 0x0377}, {0x037a, 0x037f}, 
            {0x0384, 0x038a}, {0x038e, 0x03a1}, {0x03a3, 0x0482}, {0x048a, 0x052f}, 
            {0x0531, 0x0556}, {0x0559, 0x058a}, {0x058d, 0x058f}, {0x05d0, 0x05ea}, 
            {0x05ef, 0x05f4}, {0x0606, 0x060f}, {0x061d, 0x064a}, {0x0660, 0x066f}, 
            {0x0671, 0x06d5}, {0x06e5, 0x06e6}, {0x06ee, 0x070d}, {0x0712, 0x072f}, 
            {0x074d, 0x07a5}, {0x07c0, 0x07ea}, {0x07f4, 0x07fa}, {0x07fe, 0x0815}, 
            {0x0830, 0x083e}, {0x0840, 0x0858}, {0x0860, 0x086a}, {0x0870, 0x088f}, 
            {0x08a0, 0x08c9}, {0x0903, 0x0939}, {0x093d, 0x0940}, {0x0949, 0x094c}, 
            {0x094e, 0x0950}, {0x0958, 0x0961}, {0x0964, 0x0980}, {0x0982, 0x0983}, 
            {0x0985, 0x098c}, {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0}, 
            {0x09b6, 0x09b9}, {0x09bf, 0x09c0}, {0x09c7, 0x09c8}, {0x09cb, 0x09cc}, 
            {0x09dc, 0x09dd}, {0x09df, 0x09e1}, {0x09e6, 0x09fd}, {0x0a05, 0x0a0a}, 
            {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, 
            {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a3e, 0x0a40}, {0x0a59, 0x0a5c}, 
            {0x0a66, 0x0a6f}, {0x0a72, 0x0a74}, {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, 
            {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0}, {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, 
            {0x0abd, 0x0ac0}, {0x0acb, 0x0acc}, {0x0ae0, 0x0ae1}, {0x0ae6, 0x0af1}, 
            {0x0b02, 0x0b03}, {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, 
            {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, {0x0b47, 0x0b48}, 
            {0x0b4b, 0x0b4c}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b61}, {0x0b66, 0x0b77}, 
            {0x0b85, 0x0b8a}, {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, 
            {0x0b9e, 0x0b9f}, {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, 
            {0x0bc1, 0x0bc2}, {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcc}, {0x0be6, 0x0bfa}, 
            {0x0c01, 0x0c03}, {0x0c05, 0x0c0c}, {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, 
            {0x0c2a, 0x0c39}, {0x0c41, 0x0c44}, {0x0c58, 0x0c5a}, {0x0c5c, 0x0c5d}, 
            {0x0c60, 0x0c61}, {0x0c66, 0x0c6f}, {0x0c77, 0x0c80}, {0x0c82, 0x0c8c}, 
            {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, 
            {0x0cbd, 0x0cbe}, {0x0cc3, 0x0cc4}, {0x0cdc, 0x0cde}, {0x0ce0, 0x0ce1}, 
            {0x0ce6, 0x0cef}, {0x0cf1, 0x0cf3}, {0x0d02, 0x0d0c}, {0x0d0e, 0x0d10}, 
            {0x0d12, 0x0d3a}, {0x0d3f, 0x0d40}, {0x0d46, 0x0d48}, {0x0d4a, 0x0d4c}, 
            {0x0d4e, 0x0d4f}, {0x0d54, 0x0d56}, {0x0d58, 0x0d61}, {0x0d66, 0x0d7f}, 
            {0x0d82, 0x0d83}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, {0x0db3, 0x0dbb}, 
            {0x0dc0, 0x0dc6}, {0x0dd0, 0x0dd1}, {0x0dd8, 0x0dde}, {0x0de6, 0x0def}, 
            {0x0df2, 0x0df4}, {0x0e01, 0x0e30}, {0x0e32, 0x0e33}, {0x0e3f, 0x0e46}, 
            {0x0e4f, 0x0e5b}, {0x0e81, 0x0e82}, {0x0e86, 0x0e8a}, {0x0e8c, 0x0ea3}, 
            {0x0ea7, 0x0eb0}, {0x0eb2, 0x0eb3}, {0x0ec0, 0x0ec4}, {0x0ed0, 0x0ed9}, 
            {0x0edc, 0x0edf}, {0x0f00, 0x0f17}, {0x0f1a, 0x0f34}, {0x0f3a, 0x0f47}, 
            {0x0f49, 0x0f6c}, {0x0f88, 0x0f8c}, {0x0fbe, 0x0fc5}, {0x0fc7, 0x0fcc}, 
            {0x0fce, 0x0fda}, {0x1000, 0x102c}, {0x103b, 0x103c}, {0x103f, 0x1057}, 
            {0x105a, 0x105d}, {0x1061, 0x1070}, {0x1075, 0x1081}, {0x1083, 0x1084}, 
            {0x1087, 0x108c}, {0x108e, 0x109c}, {0x109e, 0x10c5}, {0x10d0, 0x1248}, 
            {0x124a, 0x124d}, {0x1250, 0x1256}, {0x125a, 0x125d}, {0x1260, 0x1288}, 
            {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, 
            {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, 
            {0x1318, 0x135a}, {0x1360, 0x137c}, {0x1380, 0x1399}, {0x13a0, 0x13f5}, 
            {0x13f8, 0x13fd}, {0x1400, 0x169c}, {0x16a0, 0x16f8}, {0x1700, 0x1711}, 
            {0x171f, 0x1731}, {0x1735, 0x1736}, {0x1740, 0x1751}, {0x1760, 0x176c}, 
            {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17be, 0x17c5}, {0x17c7, 0x17c8}, 
            {0x17d4, 0x17dc}, {0x17e0, 0x17e9}, {0x17f0, 0x17f9}, {0x1800, 0x180a}, 
            {0x1810, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x1884}, {0x1887, 0x18a8}, 
            {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1923, 0x1926}, {0x1929, 0x192b}, 
            {0x1930, 0x1931}, {0x1933, 0x1938}, {0x1944, 0x196d}, {0x1970, 0x1974}, 
            {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x19de, 0x1a16}, 
            {0x1a19, 0x1a1a}, {0x1a1e, 0x1a55}, {0x1a63, 0x1a64}, {0x1a6d, 0x1a72}, 
            {0x1a80, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa0, 0x1aad}, {0x1b04, 0x1b33}, 
            {0x1b3e, 0x1b41}, {0x1b45, 0x1b4c}, {0x1b4e, 0x1b6a}, {0x1b74, 0x1b7f}, 
            {0x1b82, 0x1ba1}, {0x1ba6, 0x1ba7}, {0x1bae, 0x1be5}, {0x1bea, 0x1bec}, 
            {0x1bfc, 0x1c2b}, {0x1c34, 0x1c35}, {0x1c3b, 0x1c49}, {0x1c4d, 0x1c8a}, 
            {0x1c90, 0x1cba}, {0x1cbd, 0x1cc7}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, 
            {0x1cf5, 0x1cf7}, {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, 
            {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f5f, 0x1f7d}, 
            {0x1f80, 0x1fb4}, {0x1fb6, 0x1fc4}, {0x1fc6, 0x1fd3}, {0x1fd6, 0x1fdb}, 
            {0x1fdd, 0x1fef}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffe}, {0x2000, 0x200a}, 
            {0x2010, 0x2027}, {0x202f, 0x205f}, {0x2070, 0x2071}, {0x2074, 0x208e}, 
            {0x2090, 0x209c}, {0x20a0, 0x20c1}, {0x2100, 0x218b}, {0x2190, 0x2429}, 
            {0x2440, 0x244a}, {0x2460, 0x2b73}, {0x2b76, 0x2cee}, {0x2cf2, 0x2cf3}, 
            {0x2cf9, 0x2d25}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d70}, {0x2d80, 0x2d96}, 
            {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, 
            {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, 
            {0x2e00, 0x2e5d}, {0x2e80, 0x2e99}, {0x2e9b, 0x2ef3}, {0x2f00, 0x2fd5}, 
            {0x2ff0, 0x3029}, {0x3030, 0x303f}, {0x3041, 0x3096}, {0x309b, 0x30ff}, 
            {0x3105, 0x312f}, {0x3131, 0x318e}, {0x3190, 0x31e5}, {0x31ef, 0x321e}, 
            {0x3220, 0xa48c}, {0xa490, 0xa4c6}, {0xa4d0, 0xa62b}, {0xa640, 0xa66e}, 
            {0xa67e, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa6f2, 0xa6f7}, {0xa700, 0xa7dc}, 
            {0xa7f1, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa824}, 
            {0xa827, 0xa82b}, {0xa830, 0xa839}, {0xa840, 0xa877}, {0xa880, 0xa8c3}, 
            {0xa8ce, 0xa8d9}, {0xa8f2, 0xa8fe}, {0xa900, 0xa925}, {0xa92e, 0xa946}, 
            {0xa95f, 0xa97c}, {0xa983, 0xa9b2}, {0xa9b4, 0xa9b5}, {0xa9ba, 0xa9bb}, 
            {0xa9be, 0xa9bf}, {0xa9c1, 0xa9cd}, {0xa9cf, 0xa9d9}, {0xa9de, 0xa9e4}, 
            {0xa9e6, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa2f, 0xaa30}, {0xaa33, 0xaa34}, 
            {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa50, 0xaa59}, {0xaa5c, 0xaa7b}, 
            {0xaa7d, 0xaaaf}, {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaadb, 0xaaeb}, 
            {0xaaee, 0xaaf5}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, 
            {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab6b}, {0xab70, 0xabe4}, 
            {0xabe6, 0xabe7}, {0xabe9, 0xabec}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, 
            {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, 
            {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1f, 0xfb36}, {0xfb38, 0xfb3c}, 
            {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfdcf}, {0xfdf0, 0xfdff}, 
            {0xfe10, 0xfe19}, {0xfe30, 0xfe52}, {0xfe54, 0xfe66}, {0xfe68, 0xfe6b}, 
            {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, {0xff01, 0xff9d}, {0xffa0, 0xffbe}, 
            {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, 
            {0xffe0, 0xffe6}, {0xffe8, 0xffee}, {0xfffc, 0xfffd}, {0x10000, 0x1000b}, 
            {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, 
            {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10100, 0x10102}, {0x10107, 0x10133}, 
            {0x10137, 0x1018e}, {0x10190, 0x1019c}, {0x101d0, 0x101fc}, {0x10280, 0x1029c}, 
            {0x102a0, 0x102d0}, {0x102e1, 0x102fb}, {0x10300, 0x10323}, {0x1032d, 0x1034a}, 
            {0x10350, 0x10375}, {0x10380, 0x1039d}, {0x1039f, 0x103c3}, {0x103c8, 0x103d5}, 
            {0x10400, 0x1049d}, {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, 
            {0x10500, 0x10527}, {0x10530, 0x10563}, {0x1056f, 0x1057a}, {0x1057c, 0x1058a}, 
            {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, 
            {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x105c0, 0x105f3}, {0x10600, 0x10736}, 
            {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, 
            {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x1080a, 0x10835}, {0x10837, 0x10838}, 
            {0x1083f, 0x10855}, {0x10857, 0x1089e}, {0x108a7, 0x108af}, {0x108e0, 0x108f2}, 
            {0x108f4, 0x108f5}, {0x108fb, 0x1091b}, {0x1091f, 0x10939}, {0x1093f, 0x10959}, 
            {0x10980, 0x109b7}, {0x109bc, 0x109cf}, {0x109d2, 0x10a00}, {0x10a10, 0x10a13}, 
            {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a40, 0x10a48}, {0x10a50, 0x10a58}, 
            {0x10a60, 0x10a9f}, {0x10ac0, 0x10ae4}, {0x10aeb, 0x10af6}, {0x10b00, 0x10b35}, 
            {0x10b39, 0x10b55}, {0x10b58, 0x10b72}, {0x10b78, 0x10b91}, {0x10b99, 0x10b9c}, 
            {0x10ba9, 0x10baf}, {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, 
            {0x10cfa, 0x10d23}, {0x10d30, 0x10d39}, {0x10d40, 0x10d65}, {0x10d6e, 0x10d85}, 
            {0x10d8e, 0x10d8f}, {0x10e60, 0x10e7e}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1}, 
            {0x10ec2, 0x10ec7}, {0x10ed0, 0x10ed8}, {0x10f00, 0x10f27}, {0x10f30, 0x10f45}, 
            {0x10f51, 0x10f59}, {0x10f70, 0x10f81}, {0x10f86, 0x10f89}, {0x10fb0, 0x10fcb}, 
            {0x10fe0, 0x10ff6}, {0x11002, 0x11037}, {0x11047, 0x1104d}, {0x11052, 0x1106f}, 
            {0x11071, 0x11072}, {0x11082, 0x110b2}, {0x110b7, 0x110b8}, {0x110bb, 0x110bc}, 
            {0x110be, 0x110c1}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11103, 0x11126}, 
            {0x11136, 0x11147}, {0x11150, 0x11172}, {0x11174, 0x11176}, {0x11182, 0x111b5}, 
            {0x111c1, 0x111c8}, {0x111cd, 0x111ce}, {0x111d0, 0x111df}, {0x111e1, 0x111f4}, 
            {0x11200, 0x11211}, {0x11213, 0x1122e}, {0x11232, 0x11233}, {0x11238, 0x1123d}, 
            {0x1123f, 0x11240}, {0x11280, 0x11286}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, 
            {0x1129f, 0x112a9}, {0x112b0, 0x112de}, {0x112e0, 0x112e2}, {0x112f0, 0x112f9}, 
            {0x11302, 0x11303}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, 
            {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x11341, 0x11344}, 
            {0x11347, 0x11348}, {0x1134b, 0x1134c}, {0x1135d, 0x11363}, {0x11380, 0x11389}, 
            {0x11390, 0x113b5}, {0x113b9, 0x113ba}, {0x113cc, 0x113cd}, {0x113d3, 0x113d5}, 
            {0x113d7, 0x113d8}, {0x11400, 0x11437}, {0x11440, 0x11441}, {0x11447, 0x1145b}, 
            {0x1145f, 0x11461}, {0x11480, 0x114af}, {0x114b1, 0x114b2}, {0x114bb, 0x114bc}, 
            {0x114c4, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115ae}, {0x115b0, 0x115b1}, 
            {0x115b8, 0x115bb}, {0x115c1, 0x115db}, {0x11600, 0x11632}, {0x1163b, 0x1163c}, 
            {0x11641, 0x11644}, {0x11650, 0x11659}, {0x11660, 0x1166c}, {0x11680, 0x116aa}, 
            {0x116ae, 0x116af}, {0x116b8, 0x116b9}, {0x116c0, 0x116c9}, {0x116d0, 0x116e3}, 
            {0x11700, 0x1171a}, {0x11720, 0x11721}, {0x11730, 0x11746}, {0x11800, 0x1182e}, 
            {0x118a0, 0x118f2}, {0x118ff, 0x11906}, {0x1190c, 0x11913}, {0x11915, 0x11916}, 
            {0x11918, 0x1192f}, {0x11931, 0x11935}, {0x11937, 0x11938}, {0x1193f, 0x11942}, 
            {0x11944, 0x11946}, {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d3}, 
            {0x119dc, 0x119df}, {0x119e1, 0x119e4}, {0x11a0b, 0x11a32}, {0x11a39, 0x11a3a}, 
            {0x11a3f, 0x11a46}, {0x11a57, 0x11a58}, {0x11a5c, 0x11a89}, {0x11a9a, 0x11aa2}, 
            {0x11ab0, 0x11af8}, {0x11b00, 0x11b09}, {0x11bc0, 0x11be1}, {0x11bf0, 0x11bf9}, 
            {0x11c00, 0x11c08}, {0x11c0a, 0x11c2f}, {0x11c40, 0x11c45}, {0x11c50, 0x11c6c}, 
            {0x11c70, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, 
            {0x11d50, 0x11d59}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, 
            {0x11d93, 0x11d94}, {0x11da0, 0x11da9}, {0x11db0, 0x11ddb}, {0x11de0, 0x11de9}, 
            {0x11ee0, 0x11ef2}, {0x11ef5, 0x11ef8}, {0x11f02, 0x11f10}, {0x11f12, 0x11f35}, 
            {0x11f3e, 0x11f3f}, {0x11f43, 0x11f59}, {0x11fc0, 0x11ff1}, {0x11fff, 0x12399}, 
            {0x12400, 0x1246e}, {0x12470, 0x12474}, {0x12480, 0x12543}, {0x12f90, 0x12ff2}, 
            {0x13000, 0x1342f}, {0x13441, 0x13446}, {0x13460, 0x143fa}, {0x14400, 0x14646}, 
            {0x16100, 0x1611d}, {0x1612a, 0x1612c}, {0x16130, 0x16139}, {0x16800, 0x16a38}, 
            {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a6e, 0x16abe}, {0x16ac0, 0x16ac9}, 
            {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b37, 0x16b45}, {0x16b50, 0x16b59}, 
            {0x16b5b, 0x16b61}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16d40, 0x16d79}, 
            {0x16d80, 0x16d97}, {0x16d99, 0x16d9c}, {0x16da0, 0x16da9}, {0x16e40, 0x16e9a}, 
            {0x16ea0, 0x16eb8}, {0x16ebb, 0x16ed3}, {0x16f00, 0x16f4a}, {0x16f50, 0x16f87}, 
            {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe3}, {0x16ff2, 0x16ff6}, {0x17000, 0x18cd5}, 
            {0x18cff, 0x18d1e}, {0x18d80, 0x18df2}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, 
            {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b150, 0x1b152}, {0x1b164, 0x1b167}, 
            {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, 
            {0x1bc90, 0x1bc99}, {0x1cc00, 0x1ccfc}, {0x1cd00, 0x1ceb3}, {0x1ceba, 0x1ced0}, 
            {0x1cee0, 0x1cef0}, {0x1cf50, 0x1cfc3}, {0x1d000, 0x1d0f5}, {0x1d100, 0x1d126}, 
            {0x1d129, 0x1d164}, {0x1d16a, 0x1d16c}, {0x1d183, 0x1d184}, {0x1d18c, 0x1d1a9}, 
            {0x1d1ae, 0x1d1ea}, {0x1d200, 0x1d241}, {0x1d2c0, 0x1d2d3}, {0x1d2e0, 0x1d2f3}, 
            {0x1d300, 0x1d356}, {0x1d360, 0x1d378}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, 
            {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, 
            {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, 
            {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, 
            {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d7cb}, {0x1d7ce, 0x1d9ff}, 
            {0x1da37, 0x1da3a}, {0x1da6d, 0x1da74}, {0x1da76, 0x1da83}, {0x1da85, 0x1da8b}, 
            {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e030, 0x1e06d}, {0x1e100, 0x1e12c}, 
            {0x1e137, 0x1e13d}, {0x1e140, 0x1e149}, {0x1e14e, 0x1e14f}, {0x1e290, 0x1e2ad}, 
            {0x1e2c0, 0x1e2eb}, {0x1e2f0, 0x1e2f9}, {0x1e4d0, 0x1e4eb}, {0x1e4f0, 0x1e4f9}, 
            {0x1e5d0, 0x1e5ed}, {0x1e5f0, 0x1e5fa}, {0x1e6c0, 0x1e6de}, {0x1e6e0, 0x1e6e2}, 
            {0x1e6e4, 0x1e6e5}, {0x1e6e7, 0x1e6ed}, {0x1e6f0, 0x1e6f4}, {0x1e6fe, 0x1e6ff}, 
            {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, 
            {0x1e800, 0x1e8c4}, {0x1e8c7, 0x1e8cf}, {0x1e900, 0x1e943}, {0x1e950, 0x1e959}, 
            {0x1e95e, 0x1e95f}, {0x1ec71, 0x1ecb4}, {0x1ed01, 0x1ed3d}, {0x1ee00, 0x1ee03}, 
            {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, 
            {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, 
            {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, 
            {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, 
            {0x1eef0, 0x1eef1}, {0x1f000, 0x1f02b}, {0x1f030, 0x1f093}, {0x1f0a0, 0x1f0ae}, 
            {0x1f0b1, 0x1f0bf}, {0x1f0c1, 0x1f0cf}, {0x1f0d1, 0x1f0f5}, {0x1f100, 0x1f1ad}, 
            {0x1f1e6, 0x1f202}, {0x1f210, 0x1f23b}, {0x1f240, 0x1f248}, {0x1f250, 0x1f251}, 
            {0x1f260, 0x1f265}, {0x1f300, 0x1f6d8}, {0x1f6dc, 0x1f6ec}, {0x1f6f0, 0x1f6fc}, 
            {0x1f700, 0x1f7d9}, {0x1f7e0, 0x1f7eb}, {0x1f800, 0x1f80b}, {0x1f810, 0x1f847}, 
            {0x1f850, 0x1f859}, {0x1f860, 0x1f887}, {0x1f890, 0x1f8ad}, {0x1f8b0, 0x1f8bb}, 
            {0x1f8c0, 0x1f8c1}, {0x1f8d0, 0x1f8d8}, {0x1f900, 0x1fa57}, {0x1fa60, 0x1fa6d}, 
            {0x1fa70, 0x1fa7c}, {0x1fa80, 0x1fa8a}, {0x1fa8e, 0x1fac6}, {0x1facd, 0x1fadd}, 
            {0x1fadf, 0x1faea}, {0x1faef, 0x1faf8}, {0x1fb00, 0x1fb92}, {0x1fb94, 0x1fbfa}, 
            {0x20000, 0x2a6df}, {0x2a700, 0x2b81d}, {0x2b820, 0x2cead}, {0x2ceb0, 0x2ebe0}, 
            {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x33479}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass60()
{
    // Name = Changes_When_NFKC_Casefolded, number of codePoints: 10583
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}}),
        std::initializer_list<char32_t>({0x00a0, 0x00a8, 0x00aa, 0x00ad, 0x00af, 0x0100, 0x0102, 0x0104, 
            0x0106, 0x0108, 0x010a, 0x010c, 0x010e, 0x0110, 0x0112, 0x0114, 
            0x0116, 0x0118, 0x011a, 0x011c, 0x011e, 0x0120, 0x0122, 0x0124, 
            0x0126, 0x0128, 0x012a, 0x012c, 0x012e, 0x0130, 0x0136, 0x0139, 
            0x013b, 0x013d, 0x0143, 0x0145, 0x0147, 0x014c, 0x014e, 0x0150, 
            0x0152, 0x0154, 0x0156, 0x0158, 0x015a, 0x015c, 0x015e, 0x0160, 
            0x0162, 0x0164, 0x0166, 0x0168, 0x016a, 0x016c, 0x016e, 0x0170, 
            0x0172, 0x0174, 0x0176, 0x017b, 0x017d, 0x017f, 0x0184, 0x01a2, 
            0x01a4, 0x01a9, 0x01ac, 0x01b5, 0x01bc, 0x01cf, 0x01d1, 0x01d3, 
            0x01d5, 0x01d7, 0x01d9, 0x01db, 0x01de, 0x01e0, 0x01e2, 0x01e4, 
            0x01e6, 0x01e8, 0x01ea, 0x01ec, 0x01ee, 0x01fa, 0x01fc, 0x01fe, 
            0x0200, 0x0202, 0x0204, 0x0206, 0x0208, 0x020a, 0x020c, 0x020e, 
            0x0210, 0x0212, 0x0214, 0x0216, 0x0218, 0x021a, 0x021c, 0x021e, 
            0x0220, 0x0222, 0x0224, 0x0226, 0x0228, 0x022a, 0x022c, 0x022e, 
            0x0230, 0x0232, 0x0241, 0x0248, 0x024a, 0x024c, 0x024e, 0x034f, 
            0x0370, 0x0372, 0x0374, 0x0376, 0x037a, 0x038c, 0x03c2, 0x03d8, 
            0x03da, 0x03dc, 0x03de, 0x03e0, 0x03e2, 0x03e4, 0x03e6, 0x03e8, 
            0x03ea, 0x03ec, 0x03ee, 0x03f7, 0x0460, 0x0462, 0x0464, 0x0466, 
            0x0468, 0x046a, 0x046c, 0x046e, 0x0470, 0x0472, 0x0474, 0x0476, 
            0x0478, 0x047a, 0x047c, 0x047e, 0x0480, 0x048a, 0x048c, 0x048e, 
            0x0490, 0x0492, 0x0494, 0x0496, 0x0498, 0x049a, 0x049c, 0x049e, 
            0x04a0, 0x04a2, 0x04a4, 0x04a6, 0x04a8, 0x04aa, 0x04ac, 0x04ae, 
            0x04b0, 0x04b2, 0x04b4, 0x04b6, 0x04b8, 0x04ba, 0x04bc, 0x04be, 
            0x04c3, 0x04c5, 0x04c7, 0x04c9, 0x04cb, 0x04cd, 0x04d0, 0x04d2, 
            0x04d4, 0x04d6, 0x04d8, 0x04da, 0x04dc, 0x04de, 0x04e0, 0x04e2, 
            0x04e4, 0x04e6, 0x04e8, 0x04ea, 0x04ec, 0x04ee, 0x04f0, 0x04f2, 
            0x04f4, 0x04f6, 0x04f8, 0x04fa, 0x04fc, 0x04fe, 0x0500, 0x0502, 
            0x0504, 0x0506, 0x0508, 0x050a, 0x050c, 0x050e, 0x0510, 0x0512, 
            0x0514, 0x0516, 0x0518, 0x051a, 0x051c, 0x051e, 0x0520, 0x0522, 
            0x0524, 0x0526, 0x0528, 0x052a, 0x052c, 0x052e, 0x0587, 0x061c, 
            0x09df, 0x0a33, 0x0a36, 0x0a5e, 0x0e33, 0x0eb3, 0x0f0c, 0x0f43, 
            0x0f4d, 0x0f52, 0x0f57, 0x0f5c, 0x0f69, 0x0f73, 0x0f81, 0x0f93, 
            0x0f9d, 0x0fa2, 0x0fa7, 0x0fac, 0x0fb9, 0x10c7, 0x10cd, 0x10fc, 
            0x1d78, 0x1e00, 0x1e02, 0x1e04, 0x1e06, 0x1e08, 0x1e0a, 0x1e0c, 
            0x1e0e, 0x1e10, 0x1e12, 0x1e14, 0x1e16, 0x1e18, 0x1e1a, 0x1e1c, 
            0x1e1e, 0x1e20, 0x1e22, 0x1e24, 0x1e26, 0x1e28, 0x1e2a, 0x1e2c, 
            0x1e2e, 0x1e30, 0x1e32, 0x1e34, 0x1e36, 0x1e38, 0x1e3a, 0x1e3c, 
            0x1e3e, 0x1e40, 0x1e42, 0x1e44, 0x1e46, 0x1e48, 0x1e4a, 0x1e4c, 
            0x1e4e, 0x1e50, 0x1e52, 0x1e54, 0x1e56, 0x1e58, 0x1e5a, 0x1e5c, 
            0x1e5e, 0x1e60, 0x1e62, 0x1e64, 0x1e66, 0x1e68, 0x1e6a, 0x1e6c, 
            0x1e6e, 0x1e70, 0x1e72, 0x1e74, 0x1e76, 0x1e78, 0x1e7a, 0x1e7c, 
            0x1e7e, 0x1e80, 0x1e82, 0x1e84, 0x1e86, 0x1e88, 0x1e8a, 0x1e8c, 
            0x1e8e, 0x1e90, 0x1e92, 0x1e94, 0x1e9e, 0x1ea0, 0x1ea2, 0x1ea4, 
            0x1ea6, 0x1ea8, 0x1eaa, 0x1eac, 0x1eae, 0x1eb0, 0x1eb2, 0x1eb4, 
            0x1eb6, 0x1eb8, 0x1eba, 0x1ebc, 0x1ebe, 0x1ec0, 0x1ec2, 0x1ec4, 
            0x1ec6, 0x1ec8, 0x1eca, 0x1ecc, 0x1ece, 0x1ed0, 0x1ed2, 0x1ed4, 
            0x1ed6, 0x1ed8, 0x1eda, 0x1edc, 0x1ede, 0x1ee0, 0x1ee2, 0x1ee4, 
            0x1ee6, 0x1ee8, 0x1eea, 0x1eec, 0x1eee, 0x1ef0, 0x1ef2, 0x1ef4, 
            0x1ef6, 0x1ef8, 0x1efa, 0x1efc, 0x1efe, 0x1f59, 0x1f5b, 0x1f5d, 
            0x1f5f, 0x1f71, 0x1f73, 0x1f75, 0x1f77, 0x1f79, 0x1f7b, 0x1f7d, 
            0x1fd3, 0x1fe3, 0x2011, 0x2017, 0x203c, 0x203e, 0x2057, 0x20a8, 
            0x2124, 0x2126, 0x2128, 0x2183, 0x2189, 0x2a0c, 0x2adc, 0x2c60, 
            0x2c67, 0x2c69, 0x2c6b, 0x2c72, 0x2c75, 0x2c82, 0x2c84, 0x2c86, 
            0x2c88, 0x2c8a, 0x2c8c, 0x2c8e, 0x2c90, 0x2c92, 0x2c94, 0x2c96, 
            0x2c98, 0x2c9a, 0x2c9c, 0x2c9e, 0x2ca0, 0x2ca2, 0x2ca4, 0x2ca6, 
            0x2ca8, 0x2caa, 0x2cac, 0x2cae, 0x2cb0, 0x2cb2, 0x2cb4, 0x2cb6, 
            0x2cb8, 0x2cba, 0x2cbc, 0x2cbe, 0x2cc0, 0x2cc2, 0x2cc4, 0x2cc6, 
            0x2cc8, 0x2cca, 0x2ccc, 0x2cce, 0x2cd0, 0x2cd2, 0x2cd4, 0x2cd6, 
            0x2cd8, 0x2cda, 0x2cdc, 0x2cde, 0x2ce0, 0x2ce2, 0x2ceb, 0x2ced, 
            0x2cf2, 0x2d6f, 0x2e9f, 0x2ef3, 0x3000, 0x3036, 0x309f, 0x30ff, 
            0xa640, 0xa642, 0xa644, 0xa646, 0xa648, 0xa64a, 0xa64c, 0xa64e, 
            0xa650, 0xa652, 0xa654, 0xa656, 0xa658, 0xa65a, 0xa65c, 0xa65e, 
            0xa660, 0xa662, 0xa664, 0xa666, 0xa668, 0xa66a, 0xa66c, 0xa680, 
            0xa682, 0xa684, 0xa686, 0xa688, 0xa68a, 0xa68c, 0xa68e, 0xa690, 
            0xa692, 0xa694, 0xa696, 0xa698, 0xa69a, 0xa722, 0xa724, 0xa726, 
            0xa728, 0xa72a, 0xa72c, 0xa72e, 0xa732, 0xa734, 0xa736, 0xa738, 
            0xa73a, 0xa73c, 0xa73e, 0xa740, 0xa742, 0xa744, 0xa746, 0xa748, 
            0xa74a, 0xa74c, 0xa74e, 0xa750, 0xa752, 0xa754, 0xa756, 0xa758, 
            0xa75a, 0xa75c, 0xa75e, 0xa760, 0xa762, 0xa764, 0xa766, 0xa768, 
            0xa76a, 0xa76c, 0xa76e, 0xa770, 0xa779, 0xa77b, 0xa780, 0xa782, 
            0xa784, 0xa786, 0xa78b, 0xa78d, 0xa790, 0xa792, 0xa796, 0xa798, 
            0xa79a, 0xa79c, 0xa79e, 0xa7a0, 0xa7a2, 0xa7a4, 0xa7a6, 0xa7a8, 
            0xa7b6, 0xa7b8, 0xa7ba, 0xa7bc, 0xa7be, 0xa7c0, 0xa7c2, 0xa7c9, 
            0xa7ce, 0xa7d0, 0xa7d2, 0xa7d4, 0xa7d6, 0xa7d8, 0xa7da, 0xa7dc, 
            0xab69, 0xfa10, 0xfa12, 0xfa20, 0xfa22, 0xfb1d, 0xfb3e, 0xfe74, 
            0xfeff, 0x1d4a2, 0x1d4bb, 0x1d546, 0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 
            0x1ee42, 0x1ee47, 0x1ee49, 0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 
            0x1ee5d, 0x1ee5f, 0x1ee64, 0x1ee7e, 0x1f190}),
        std::initializer_list<CharacterRange>({{0x00b2, 0x00b5}, {0x00b8, 0x00ba}, {0x00bc, 0x00be}, {0x00c0, 0x00d6}, 
            {0x00d8, 0x00df}, {0x0132, 0x0134}, {0x013f, 0x0141}, {0x0149, 0x014a}, 
            {0x0178, 0x0179}, {0x0181, 0x0182}, {0x0186, 0x0187}, {0x0189, 0x018b}, 
            {0x018e, 0x0191}, {0x0193, 0x0194}, {0x0196, 0x0198}, {0x019c, 0x019d}, 
            {0x019f, 0x01a0}, {0x01a6, 0x01a7}, {0x01ae, 0x01af}, {0x01b1, 0x01b3}, 
            {0x01b7, 0x01b8}, {0x01c4, 0x01cd}, {0x01f1, 0x01f4}, {0x01f6, 0x01f8}, 
            {0x023a, 0x023b}, {0x023d, 0x023e}, {0x0243, 0x0246}, {0x02b0, 0x02b8}, 
            {0x02d8, 0x02dd}, {0x02e0, 0x02e4}, {0x0340, 0x0341}, {0x0343, 0x0345}, 
            {0x037e, 0x037f}, {0x0384, 0x038a}, {0x038e, 0x038f}, {0x0391, 0x03a1}, 
            {0x03a3, 0x03ab}, {0x03cf, 0x03d6}, {0x03f0, 0x03f2}, {0x03f4, 0x03f5}, 
            {0x03f9, 0x03fa}, {0x03fd, 0x042f}, {0x04c0, 0x04c1}, {0x0531, 0x0556}, 
            {0x0675, 0x0678}, {0x0958, 0x095f}, {0x09dc, 0x09dd}, {0x0a59, 0x0a5b}, 
            {0x0b5c, 0x0b5d}, {0x0edc, 0x0edd}, {0x0f75, 0x0f79}, {0x10a0, 0x10c5}, 
            {0x115f, 0x1160}, {0x13f8, 0x13fd}, {0x17b4, 0x17b5}, {0x180b, 0x180f}, 
            {0x1c80, 0x1c89}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1d2c, 0x1d2e}, 
            {0x1d30, 0x1d3a}, {0x1d3c, 0x1d4d}, {0x1d4f, 0x1d6a}, {0x1d9b, 0x1dbf}, 
            {0x1e9a, 0x1e9b}, {0x1f08, 0x1f0f}, {0x1f18, 0x1f1d}, {0x1f28, 0x1f2f}, 
            {0x1f38, 0x1f3f}, {0x1f48, 0x1f4d}, {0x1f68, 0x1f6f}, {0x1f80, 0x1faf}, 
            {0x1fb2, 0x1fb4}, {0x1fb7, 0x1fc4}, {0x1fc7, 0x1fcf}, {0x1fd8, 0x1fdb}, 
            {0x1fdd, 0x1fdf}, {0x1fe8, 0x1fef}, {0x1ff2, 0x1ff4}, {0x1ff7, 0x1ffe}, 
            {0x2000, 0x200f}, {0x2024, 0x2026}, {0x202a, 0x202f}, {0x2033, 0x2034}, 
            {0x2036, 0x2037}, {0x2047, 0x2049}, {0x205f, 0x2071}, {0x2074, 0x208e}, 
            {0x2090, 0x209c}, {0x2100, 0x2103}, {0x2105, 0x2107}, {0x2109, 0x2113}, 
            {0x2115, 0x2116}, {0x2119, 0x211d}, {0x2120, 0x2122}, {0x212a, 0x212d}, 
            {0x212f, 0x2139}, {0x213b, 0x2140}, {0x2145, 0x2149}, {0x2150, 0x217f}, 
            {0x222c, 0x222d}, {0x222f, 0x2230}, {0x2329, 0x232a}, {0x2460, 0x24ea}, 
            {0x2a74, 0x2a76}, {0x2c00, 0x2c2f}, {0x2c62, 0x2c64}, {0x2c6d, 0x2c70}, 
            {0x2c7c, 0x2c80}, {0x2f00, 0x2fd5}, {0x3038, 0x303a}, {0x309b, 0x309c}, 
            {0x3131, 0x318e}, {0x3192, 0x319f}, {0x3200, 0x321e}, {0x3220, 0x3247}, 
            {0x3250, 0x327e}, {0x3280, 0x33ff}, {0xa69c, 0xa69d}, {0xa77d, 0xa77e}, 
            {0xa7aa, 0xa7ae}, {0xa7b0, 0xa7b4}, {0xa7c4, 0xa7c7}, {0xa7cb, 0xa7cc}, 
            {0xa7f1, 0xa7f5}, {0xa7f8, 0xa7f9}, {0xab5c, 0xab5f}, {0xab70, 0xabbf}, 
            {0xf900, 0xfa0d}, {0xfa15, 0xfa1e}, {0xfa25, 0xfa26}, {0xfa2a, 0xfa6d}, 
            {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1f, 0xfb36}, 
            {0xfb38, 0xfb3c}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, 
            {0xfbd3, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfc}, 
            {0xfe00, 0xfe19}, {0xfe30, 0xfe44}, {0xfe47, 0xfe52}, {0xfe54, 0xfe66}, 
            {0xfe68, 0xfe6b}, {0xfe70, 0xfe72}, {0xfe76, 0xfefc}, {0xff01, 0xffbe}, 
            {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, 
            {0xffe0, 0xffe6}, {0xffe8, 0xffee}, {0xfff0, 0xfff8}, {0x10400, 0x10427}, 
            {0x104b0, 0x104d3}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, 
            {0x10594, 0x10595}, {0x10781, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, 
            {0x10c80, 0x10cb2}, {0x10d50, 0x10d65}, {0x118a0, 0x118bf}, {0x16e40, 0x16e5f}, 
            {0x16ea0, 0x16eb8}, {0x1bca0, 0x1bca3}, {0x1ccd6, 0x1ccf9}, {0x1d15e, 0x1d164}, 
            {0x1d173, 0x1d17a}, {0x1d1bb, 0x1d1c0}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, 
            {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, 
            {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, 
            {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, 
            {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, 
            {0x1e030, 0x1e06d}, {0x1e900, 0x1e921}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, 
            {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee4d, 0x1ee4f}, 
            {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, 
            {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, 
            {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1f100, 0x1f10a}, 
            {0x1f110, 0x1f12e}, {0x1f130, 0x1f14f}, {0x1f16a, 0x1f16c}, {0x1f200, 0x1f202}, 
            {0x1f210, 0x1f23b}, {0x1f240, 0x1f248}, {0x1f250, 0x1f251}, {0x1fbf0, 0x1fbf9}, 
            {0x2f800, 0x2fa1d}, {0xe0000, 0xe0fff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass61()
{
    // Name = White_Space, number of codePoints: 25
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x20}),
        std::initializer_list<CharacterRange>({{0x09, 0x0d}}),
        std::initializer_list<char32_t>({0x0085, 0x00a0, 0x1680, 0x202f, 0x205f, 0x3000}),
        std::initializer_list<CharacterRange>({{0x2000, 0x200a}, {0x2028, 0x2029}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass62()
{
    // Name = Bidi_Control, number of codePoints: 12
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x061c}),
        std::initializer_list<CharacterRange>({{0x200e, 0x200f}, {0x202a, 0x202e}, {0x2066, 0x2069}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass63()
{
    // Name = Join_Control, number of codePoints: 2
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x200c, 0x200d}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass64()
{
    // Name = Dash, number of codePoints: 31
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x2d}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x058a, 0x05be, 0x1400, 0x1806, 0x2053, 0x207b, 0x208b, 0x2212, 
            0x2e17, 0x2e1a, 0x2e40, 0x2e5d, 0x301c, 0x3030, 0x30a0, 0xfe58, 
            0xfe63, 0xff0d, 0x10d6e, 0x10ead}),
        std::initializer_list<CharacterRange>({{0x2010, 0x2015}, {0x2e3a, 0x2e3b}, {0xfe31, 0xfe32}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass65()
{
    // Name = Quotation_Mark, number of codePoints: 30
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x22, 0x27}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00ab, 0x00bb, 0x2e42, 0xff02, 0xff07}),
        std::initializer_list<CharacterRange>({{0x2018, 0x201f}, {0x2039, 0x203a}, {0x300c, 0x300f}, {0x301d, 0x301f}, 
            {0xfe41, 0xfe44}, {0xff62, 0xff63}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass66()
{
    // Name = Terminal_Punctuation, number of codePoints: 291
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x21, 0x2c, 0x2e, 0x3f}),
        std::initializer_list<CharacterRange>({{0x3a, 0x3b}}),
        std::initializer_list<char32_t>({0x037e, 0x0387, 0x0589, 0x05c3, 0x060c, 0x061b, 0x06d4, 0x070c, 
            0x085e, 0x0f08, 0x166e, 0x17da, 0x2024, 0x2e2e, 0x2e3c, 0x2e41, 
            0x2e4c, 0xa92f, 0xaadf, 0xabeb, 0xfe12, 0xff01, 0xff0c, 0xff0e, 
            0xff1f, 0xff61, 0xff64, 0x1039f, 0x103d0, 0x10857, 0x1091f, 0x111cd, 
            0x112a9, 0x11944, 0x11946, 0x11c71, 0x16af5, 0x16b44, 0x1bc9f}),
        std::initializer_list<CharacterRange>({{0x061d, 0x061f}, {0x0700, 0x070a}, {0x07f8, 0x07f9}, {0x0830, 0x0835}, 
            {0x0837, 0x083e}, {0x0964, 0x0965}, {0x0e5a, 0x0e5b}, {0x0f0d, 0x0f12}, 
            {0x104a, 0x104b}, {0x1361, 0x1368}, {0x16eb, 0x16ed}, {0x1735, 0x1736}, 
            {0x17d4, 0x17d6}, {0x1802, 0x1805}, {0x1808, 0x1809}, {0x1944, 0x1945}, 
            {0x1aa8, 0x1aab}, {0x1b4e, 0x1b4f}, {0x1b5a, 0x1b5b}, {0x1b5d, 0x1b5f}, 
            {0x1b7d, 0x1b7f}, {0x1c3b, 0x1c3f}, {0x1c7e, 0x1c7f}, {0x203c, 0x203d}, 
            {0x2047, 0x2049}, {0x2cf9, 0x2cfb}, {0x2e4e, 0x2e4f}, {0x2e53, 0x2e54}, 
            {0x3001, 0x3002}, {0xa4fe, 0xa4ff}, {0xa60d, 0xa60f}, {0xa6f3, 0xa6f7}, 
            {0xa876, 0xa877}, {0xa8ce, 0xa8cf}, {0xa9c7, 0xa9c9}, {0xaa5d, 0xaa5f}, 
            {0xaaf0, 0xaaf1}, {0xfe15, 0xfe16}, {0xfe50, 0xfe52}, {0xfe54, 0xfe57}, 
            {0xff1a, 0xff1b}, {0x10a56, 0x10a57}, {0x10af0, 0x10af5}, {0x10b3a, 0x10b3f}, 
            {0x10b99, 0x10b9c}, {0x10f55, 0x10f59}, {0x10f86, 0x10f89}, {0x11047, 0x1104d}, 
            {0x110be, 0x110c1}, {0x11141, 0x11143}, {0x111c5, 0x111c6}, {0x111de, 0x111df}, 
            {0x11238, 0x1123c}, {0x113d4, 0x113d5}, {0x1144b, 0x1144d}, {0x1145a, 0x1145b}, 
            {0x115c2, 0x115c5}, {0x115c9, 0x115d7}, {0x11641, 0x11642}, {0x1173c, 0x1173e}, 
            {0x11a42, 0x11a43}, {0x11a9b, 0x11a9c}, {0x11aa1, 0x11aa2}, {0x11c41, 0x11c43}, 
            {0x11ef7, 0x11ef8}, {0x11f43, 0x11f44}, {0x12470, 0x12474}, {0x16a6e, 0x16a6f}, 
            {0x16b37, 0x16b39}, {0x16d6e, 0x16d6f}, {0x16e97, 0x16e98}, {0x1da87, 0x1da8a}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass67()
{
    // Name = Hex_Digit, number of codePoints: 44
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x30, 0x39}, {0x41, 0x46}, {0x61, 0x66}}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0xff10, 0xff19}, {0xff21, 0xff26}, {0xff41, 0xff46}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass68()
{
    // Name = ASCII_Hex_Digit, number of codePoints: 22
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x30, 0x39}, {0x41, 0x46}, {0x61, 0x66}}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass69()
{
    // Name = Ideographic, number of codePoints: 110943
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x16fe4}),
        std::initializer_list<CharacterRange>({{0x3006, 0x3007}, {0x3021, 0x3029}, {0x3038, 0x303a}, {0x3400, 0x4dbf}, 
            {0x4e00, 0x9fff}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0x16ff2, 0x16ff6}, 
            {0x17000, 0x18cd5}, {0x18cff, 0x18d1e}, {0x18d80, 0x18df2}, {0x1b170, 0x1b2fb}, 
            {0x20000, 0x2a6df}, {0x2a700, 0x2b81d}, {0x2b820, 0x2cead}, {0x2ceb0, 0x2ebe0}, 
            {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x33479}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass70()
{
    // Name = Diacritic, number of codePoints: 1250
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x5e, 0x60}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00a8, 0x00af, 0x00b4, 0x037a, 0x0559, 0x05bf, 0x05c7, 0x093c, 
            0x094d, 0x0971, 0x09bc, 0x09cd, 0x0a3c, 0x0a4d, 0x0abc, 0x0acd, 
            0x0b3c, 0x0b4d, 0x0bcd, 0x0c3c, 0x0c4d, 0x0cbc, 0x0ccd, 0x0d4d, 
            0x0dca, 0x0e3a, 0x0e4e, 0x0eba, 0x0f35, 0x0f37, 0x0f39, 0x0fc6, 
            0x1037, 0x108f, 0x1734, 0x17dd, 0x1a60, 0x1a7f, 0x1b34, 0x1b44, 
            0x1be6, 0x1ced, 0x1cf4, 0x1fbd, 0x2e2f, 0x30fc, 0xa66f, 0xa67f, 
            0xa7f1, 0xa806, 0xa82c, 0xa8c4, 0xa953, 0xa9b3, 0xa9c0, 0xa9e5, 
            0xaaf6, 0xfb1e, 0xff3e, 0xff40, 0xff70, 0xffe3, 0x102e0, 0x10a3f, 
            0x10d4e, 0x10efa, 0x11046, 0x11070, 0x11173, 0x111c0, 0x1134d, 0x11442, 
            0x11446, 0x1163f, 0x1172b, 0x11943, 0x119e0, 0x11a34, 0x11a47, 0x11a99, 
            0x11c3f, 0x11d42, 0x11d97, 0x11dd9, 0x11f5a, 0x1612f, 0x16d9d, 0x1e2ae}),
        std::initializer_list<CharacterRange>({{0x00b7, 0x00b8}, {0x02b0, 0x034e}, {0x0350, 0x0357}, {0x035d, 0x0362}, 
            {0x0374, 0x0375}, {0x0384, 0x0385}, {0x0483, 0x0487}, {0x0591, 0x05bd}, 
            {0x05c1, 0x05c2}, {0x05c4, 0x05c5}, {0x064b, 0x0652}, {0x0657, 0x0658}, 
            {0x06df, 0x06e0}, {0x06e5, 0x06e6}, {0x06ea, 0x06ec}, {0x0730, 0x074a}, 
            {0x07a6, 0x07b0}, {0x07eb, 0x07f5}, {0x0818, 0x0819}, {0x0898, 0x089f}, 
            {0x08c9, 0x08d2}, {0x08e3, 0x08fe}, {0x0951, 0x0954}, {0x0afd, 0x0aff}, 
            {0x0b53, 0x0b55}, {0x0d3b, 0x0d3c}, {0x0e47, 0x0e4c}, {0x0ec8, 0x0ecc}, 
            {0x0f18, 0x0f19}, {0x0f3e, 0x0f3f}, {0x0f82, 0x0f84}, {0x0f86, 0x0f87}, 
            {0x1039, 0x103a}, {0x1063, 0x1064}, {0x1069, 0x106d}, {0x1087, 0x108d}, 
            {0x109a, 0x109b}, {0x135d, 0x135f}, {0x1714, 0x1715}, {0x17c9, 0x17d3}, 
            {0x1939, 0x193b}, {0x1a75, 0x1a7c}, {0x1ab0, 0x1abe}, {0x1ac1, 0x1acb}, 
            {0x1acf, 0x1add}, {0x1ae0, 0x1aeb}, {0x1b6b, 0x1b73}, {0x1baa, 0x1bab}, 
            {0x1bf2, 0x1bf3}, {0x1c36, 0x1c37}, {0x1c78, 0x1c7d}, {0x1cd0, 0x1ce8}, 
            {0x1cf7, 0x1cf9}, {0x1d2c, 0x1d6a}, {0x1d9b, 0x1dbe}, {0x1dc4, 0x1dcf}, 
            {0x1df5, 0x1dff}, {0x1fbf, 0x1fc1}, {0x1fcd, 0x1fcf}, {0x1fdd, 0x1fdf}, 
            {0x1fed, 0x1fef}, {0x1ffd, 0x1ffe}, {0x2cef, 0x2cf1}, {0x302a, 0x302f}, 
            {0x3099, 0x309c}, {0xa67c, 0xa67d}, {0xa69c, 0xa69d}, {0xa6f0, 0xa6f1}, 
            {0xa700, 0xa721}, {0xa788, 0xa78a}, {0xa7f8, 0xa7f9}, {0xa8e0, 0xa8f1}, 
            {0xa92b, 0xa92e}, {0xaa7b, 0xaa7d}, {0xaabf, 0xaac2}, {0xab5b, 0xab5f}, 
            {0xab69, 0xab6b}, {0xabec, 0xabed}, {0xfe20, 0xfe2f}, {0xff9e, 0xff9f}, 
            {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10a38, 0x10a3a}, 
            {0x10ae5, 0x10ae6}, {0x10d22, 0x10d27}, {0x10d69, 0x10d6d}, {0x10efd, 0x10eff}, 
            {0x10f46, 0x10f50}, {0x10f82, 0x10f85}, {0x110b9, 0x110ba}, {0x11133, 0x11134}, 
            {0x111ca, 0x111cc}, {0x11235, 0x11236}, {0x112e9, 0x112ea}, {0x1133b, 0x1133c}, 
            {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x113ce, 0x113d0}, {0x113d2, 0x113d3}, 
            {0x113e1, 0x113e2}, {0x114c2, 0x114c3}, {0x115bf, 0x115c0}, {0x116b6, 0x116b7}, 
            {0x11839, 0x1183a}, {0x1193d, 0x1193e}, {0x11d44, 0x11d45}, {0x11f41, 0x11f42}, 
            {0x13447, 0x13455}, {0x16af0, 0x16af4}, {0x16b30, 0x16b36}, {0x16d6b, 0x16d6c}, 
            {0x16f8f, 0x16f9f}, {0x16ff0, 0x16ff1}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, 
            {0x1affd, 0x1affe}, {0x1cf00, 0x1cf2d}, {0x1cf30, 0x1cf46}, {0x1d167, 0x1d169}, 
            {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, 
            {0x1e030, 0x1e06d}, {0x1e130, 0x1e136}, {0x1e2ec, 0x1e2ef}, {0x1e5ee, 0x1e5ef}, 
            {0x1e8d0, 0x1e8d6}, {0x1e944, 0x1e946}, {0x1e948, 0x1e94a}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass71()
{
    // Name = Extender, number of codePoints: 63
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00b7, 0x0640, 0x07fa, 0x0a71, 0x0afb, 0x0e46, 0x0ec6, 0x180a, 
            0x1843, 0x1aa7, 0x1c36, 0x1c7b, 0x3005, 0xa015, 0xa60c, 0xa9cf, 
            0xa9e6, 0xaa70, 0xaadd, 0xff70, 0x10d4e, 0x10d6a, 0x10d6f, 0x11237, 
            0x1135d, 0x11a98, 0x11dd9, 0x16fe3, 0x1e5ef}),
        std::initializer_list<CharacterRange>({{0x02d0, 0x02d1}, {0x0b54, 0x0b55}, {0x3031, 0x3035}, {0x309d, 0x309e}, 
            {0x30fc, 0x30fe}, {0xaaf3, 0xaaf4}, {0x10781, 0x10782}, {0x113d2, 0x113d3}, 
            {0x115c6, 0x115c8}, {0x16b42, 0x16b43}, {0x16fe0, 0x16fe1}, {0x16ff2, 0x16ff3}, 
            {0x1e13c, 0x1e13d}, {0x1e944, 0x1e946}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass72()
{
    // Name = Noncharacter_Code_Point, number of codePoints: 66
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0xfdd0, 0xfdef}, {0xfffe, 0xffff}, {0x1fffe, 0x1ffff}, {0x2fffe, 0x2ffff}, 
            {0x3fffe, 0x3ffff}, {0x4fffe, 0x4ffff}, {0x5fffe, 0x5ffff}, {0x6fffe, 0x6ffff}, 
            {0x7fffe, 0x7ffff}, {0x8fffe, 0x8ffff}, {0x9fffe, 0x9ffff}, {0xafffe, 0xaffff}, 
            {0xbfffe, 0xbffff}, {0xcfffe, 0xcffff}, {0xdfffe, 0xdffff}, {0xefffe, 0xeffff}, 
            {0xffffe, 0xfffff}, {0x10fffe, 0x10ffff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass73()
{
    // Name = IDS_Binary_Operator, number of codePoints: 13
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x31ef}),
        std::initializer_list<CharacterRange>({{0x2ff0, 0x2ff1}, {0x2ff4, 0x2ffd}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass74()
{
    // Name = IDS_Trinary_Operator, number of codePoints: 2
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x2ff2, 0x2ff3}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass75()
{
    // Name = Radical, number of codePoints: 329
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x2e80, 0x2e99}, {0x2e9b, 0x2ef3}, {0x2f00, 0x2fd5}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass76()
{
    // Name = Unified_Ideograph, number of codePoints: 101996
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0xfa11, 0xfa1f, 0xfa21}),
        std::initializer_list<CharacterRange>({{0x3400, 0x4dbf}, {0x4e00, 0x9fff}, {0xfa0e, 0xfa0f}, {0xfa13, 0xfa14}, 
            {0xfa23, 0xfa24}, {0xfa27, 0xfa29}, {0x20000, 0x2a6df}, {0x2a700, 0x2b81d}, 
            {0x2b820, 0x2cead}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, {0x30000, 0x3134a}, 
            {0x31350, 0x33479}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass77()
{
    // Name = Deprecated, number of codePoints: 15
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0149, 0x0673, 0x0f77, 0x0f79, 0xe0001}),
        std::initializer_list<CharacterRange>({{0x17a3, 0x17a4}, {0x206a, 0x206f}, {0x2329, 0x232a}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass78()
{
    // Name = Soft_Dotted, number of codePoints: 50
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x69, 0x6a}}),
        std::initializer_list<char32_t>({0x012f, 0x0249, 0x0268, 0x029d, 0x02b2, 0x03f3, 0x0456, 0x0458, 
            0x1d62, 0x1d96, 0x1da4, 0x1da8, 0x1e2d, 0x1ecb, 0x2071, 0x2c7c, 
            0x1df1a, 0x1e068}),
        std::initializer_list<CharacterRange>({{0x2148, 0x2149}, {0x1d422, 0x1d423}, {0x1d456, 0x1d457}, {0x1d48a, 0x1d48b}, 
            {0x1d4be, 0x1d4bf}, {0x1d4f2, 0x1d4f3}, {0x1d526, 0x1d527}, {0x1d55a, 0x1d55b}, 
            {0x1d58e, 0x1d58f}, {0x1d5c2, 0x1d5c3}, {0x1d5f6, 0x1d5f7}, {0x1d62a, 0x1d62b}, 
            {0x1d65e, 0x1d65f}, {0x1d692, 0x1d693}, {0x1e04c, 0x1e04d}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass79()
{
    // Name = Logical_Order_Exception, number of codePoints: 19
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x19ba, 0xaab9}),
        std::initializer_list<CharacterRange>({{0x0e40, 0x0e44}, {0x0ec0, 0x0ec4}, {0x19b5, 0x19b7}, {0xaab5, 0xaab6}, 
            {0xaabb, 0xaabc}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass80()
{
    // Name = Sentence_Terminal, number of codePoints: 170
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x21, 0x2e, 0x3f}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0589, 0x06d4, 0x07f9, 0x0837, 0x0839, 0x1362, 0x166e, 0x1803, 
            0x1809, 0x2024, 0x2e2e, 0x2e3c, 0x3002, 0xa4ff, 0xa6f3, 0xa6f7, 
            0xa92f, 0xabeb, 0xfe12, 0xfe52, 0xff01, 0xff0e, 0xff1f, 0xff61, 
            0x111cd, 0x112a9, 0x11944, 0x11946, 0x16af5, 0x16b44, 0x16e98, 0x1bc9f, 
            0x1da88}),
        std::initializer_list<CharacterRange>({{0x061d, 0x061f}, {0x0700, 0x0702}, {0x083d, 0x083e}, {0x0964, 0x0965}, 
            {0x104a, 0x104b}, {0x1367, 0x1368}, {0x1735, 0x1736}, {0x17d4, 0x17d5}, 
            {0x1944, 0x1945}, {0x1aa8, 0x1aab}, {0x1b4e, 0x1b4f}, {0x1b5a, 0x1b5b}, 
            {0x1b5e, 0x1b5f}, {0x1b7d, 0x1b7f}, {0x1c3b, 0x1c3c}, {0x1c7e, 0x1c7f}, 
            {0x203c, 0x203d}, {0x2047, 0x2049}, {0x2cf9, 0x2cfb}, {0x2e53, 0x2e54}, 
            {0xa60e, 0xa60f}, {0xa876, 0xa877}, {0xa8ce, 0xa8cf}, {0xa9c8, 0xa9c9}, 
            {0xaa5d, 0xaa5f}, {0xaaf0, 0xaaf1}, {0xfe15, 0xfe16}, {0xfe56, 0xfe57}, 
            {0x10a56, 0x10a57}, {0x10f55, 0x10f59}, {0x10f86, 0x10f89}, {0x11047, 0x11048}, 
            {0x110be, 0x110c1}, {0x11141, 0x11143}, {0x111c5, 0x111c6}, {0x111de, 0x111df}, 
            {0x11238, 0x11239}, {0x1123b, 0x1123c}, {0x113d4, 0x113d5}, {0x1144b, 0x1144c}, 
            {0x115c2, 0x115c3}, {0x115c9, 0x115d7}, {0x11641, 0x11642}, {0x1173c, 0x1173e}, 
            {0x11a42, 0x11a43}, {0x11a9b, 0x11a9c}, {0x11c41, 0x11c42}, {0x11ef7, 0x11ef8}, 
            {0x11f43, 0x11f44}, {0x16a6e, 0x16a6f}, {0x16b37, 0x16b38}, {0x16d6e, 0x16d6f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass81()
{
    // Name = Variation_Selector, number of codePoints: 260
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x180f}),
        std::initializer_list<CharacterRange>({{0x180b, 0x180d}, {0xfe00, 0xfe0f}, {0xe0100, 0xe01ef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass82()
{
    // Name = Pattern_White_Space, number of codePoints: 11
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x20}),
        std::initializer_list<CharacterRange>({{0x09, 0x0d}}),
        std::initializer_list<char32_t>({0x0085}),
        std::initializer_list<CharacterRange>({{0x200e, 0x200f}, {0x2028, 0x2029}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass83()
{
    // Name = Pattern_Syntax, number of codePoints: 2760
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x60}),
        std::initializer_list<CharacterRange>({{0x21, 0x2f}, {0x3a, 0x40}, {0x5b, 0x5e}, {0x7b, 0x7e}}),
        std::initializer_list<char32_t>({0x00a9, 0x00ae, 0x00b6, 0x00bb, 0x00bf, 0x00d7, 0x00f7, 0x3030}),
        std::initializer_list<CharacterRange>({{0x00a1, 0x00a7}, {0x00ab, 0x00ac}, {0x00b0, 0x00b1}, {0x2010, 0x2027}, 
            {0x2030, 0x203e}, {0x2041, 0x2053}, {0x2055, 0x205e}, {0x2190, 0x245f}, 
            {0x2500, 0x2775}, {0x2794, 0x2bff}, {0x2e00, 0x2e7f}, {0x3001, 0x3003}, 
            {0x3008, 0x3020}, {0xfd3e, 0xfd3f}, {0xfe45, 0xfe46}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass84()
{
    // Name = Regional_Indicator, number of codePoints: 26
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1f1e6, 0x1f1ff}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass85()
{
    // Name = Emoji, number of codePoints: 1439
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x23, 0x2a}),
        std::initializer_list<CharacterRange>({{0x30, 0x39}}),
        std::initializer_list<char32_t>({0x00a9, 0x00ae, 0x203c, 0x2049, 0x2122, 0x2139, 0x2328, 0x23cf, 
            0x24c2, 0x25b6, 0x25c0, 0x260e, 0x2611, 0x2618, 0x261d, 0x2620, 
            0x2626, 0x262a, 0x2640, 0x2642, 0x2663, 0x2668, 0x267b, 0x2699, 
            0x26a7, 0x26c8, 0x26d1, 0x26fd, 0x2702, 0x2705, 0x270f, 0x2712, 
            0x2714, 0x2716, 0x271d, 0x2721, 0x2728, 0x2744, 0x2747, 0x274c, 
            0x274e, 0x2757, 0x27a1, 0x27b0, 0x27bf, 0x2b50, 0x2b55, 0x3030, 
            0x303d, 0x3297, 0x3299, 0x1f004, 0x1f0cf, 0x1f18e, 0x1f21a, 0x1f22f, 
            0x1f587, 0x1f590, 0x1f5a8, 0x1f5bc, 0x1f5e1, 0x1f5e3, 0x1f5e8, 0x1f5ef, 
            0x1f5f3, 0x1f6e9, 0x1f6f0, 0x1f7f0, 0x1fac8}),
        std::initializer_list<CharacterRange>({{0x2194, 0x2199}, {0x21a9, 0x21aa}, {0x231a, 0x231b}, {0x23e9, 0x23f3}, 
            {0x23f8, 0x23fa}, {0x25aa, 0x25ab}, {0x25fb, 0x25fe}, {0x2600, 0x2604}, 
            {0x2614, 0x2615}, {0x2622, 0x2623}, {0x262e, 0x262f}, {0x2638, 0x263a}, 
            {0x2648, 0x2653}, {0x265f, 0x2660}, {0x2665, 0x2666}, {0x267e, 0x267f}, 
            {0x2692, 0x2697}, {0x269b, 0x269c}, {0x26a0, 0x26a1}, {0x26aa, 0x26ab}, 
            {0x26b0, 0x26b1}, {0x26bd, 0x26be}, {0x26c4, 0x26c5}, {0x26ce, 0x26cf}, 
            {0x26d3, 0x26d4}, {0x26e9, 0x26ea}, {0x26f0, 0x26f5}, {0x26f7, 0x26fa}, 
            {0x2708, 0x270d}, {0x2733, 0x2734}, {0x2753, 0x2755}, {0x2763, 0x2764}, 
            {0x2795, 0x2797}, {0x2934, 0x2935}, {0x2b05, 0x2b07}, {0x2b1b, 0x2b1c}, 
            {0x1f170, 0x1f171}, {0x1f17e, 0x1f17f}, {0x1f191, 0x1f19a}, {0x1f1e6, 0x1f1ff}, 
            {0x1f201, 0x1f202}, {0x1f232, 0x1f23a}, {0x1f250, 0x1f251}, {0x1f300, 0x1f321}, 
            {0x1f324, 0x1f393}, {0x1f396, 0x1f397}, {0x1f399, 0x1f39b}, {0x1f39e, 0x1f3f0}, 
            {0x1f3f3, 0x1f3f5}, {0x1f3f7, 0x1f4fd}, {0x1f4ff, 0x1f53d}, {0x1f549, 0x1f54e}, 
            {0x1f550, 0x1f567}, {0x1f56f, 0x1f570}, {0x1f573, 0x1f57a}, {0x1f58a, 0x1f58d}, 
            {0x1f595, 0x1f596}, {0x1f5a4, 0x1f5a5}, {0x1f5b1, 0x1f5b2}, {0x1f5c2, 0x1f5c4}, 
            {0x1f5d1, 0x1f5d3}, {0x1f5dc, 0x1f5de}, {0x1f5fa, 0x1f64f}, {0x1f680, 0x1f6c5}, 
            {0x1f6cb, 0x1f6d2}, {0x1f6d5, 0x1f6d8}, {0x1f6dc, 0x1f6e5}, {0x1f6eb, 0x1f6ec}, 
            {0x1f6f3, 0x1f6fc}, {0x1f7e0, 0x1f7eb}, {0x1f90c, 0x1f93a}, {0x1f93c, 0x1f945}, 
            {0x1f947, 0x1f9ff}, {0x1fa70, 0x1fa7c}, {0x1fa80, 0x1fa8a}, {0x1fa8e, 0x1fac6}, 
            {0x1facd, 0x1fadd}, {0x1fadf, 0x1faea}, {0x1faef, 0x1faf8}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass86()
{
    // Name = Emoji_Presentation, number of codePoints: 1220
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x23f0, 0x23f3, 0x267f, 0x2693, 0x26a1, 0x26ce, 0x26d4, 0x26ea, 
            0x26f5, 0x26fa, 0x26fd, 0x2705, 0x2728, 0x274c, 0x274e, 0x2757, 
            0x27b0, 0x27bf, 0x2b50, 0x2b55, 0x1f004, 0x1f0cf, 0x1f18e, 0x1f201, 
            0x1f21a, 0x1f22f, 0x1f3f4, 0x1f440, 0x1f57a, 0x1f5a4, 0x1f6cc, 0x1f7f0, 
            0x1fac8}),
        std::initializer_list<CharacterRange>({{0x231a, 0x231b}, {0x23e9, 0x23ec}, {0x25fd, 0x25fe}, {0x2614, 0x2615}, 
            {0x2648, 0x2653}, {0x26aa, 0x26ab}, {0x26bd, 0x26be}, {0x26c4, 0x26c5}, 
            {0x26f2, 0x26f3}, {0x270a, 0x270b}, {0x2753, 0x2755}, {0x2795, 0x2797}, 
            {0x2b1b, 0x2b1c}, {0x1f191, 0x1f19a}, {0x1f1e6, 0x1f1ff}, {0x1f232, 0x1f236}, 
            {0x1f238, 0x1f23a}, {0x1f250, 0x1f251}, {0x1f300, 0x1f320}, {0x1f32d, 0x1f335}, 
            {0x1f337, 0x1f37c}, {0x1f37e, 0x1f393}, {0x1f3a0, 0x1f3ca}, {0x1f3cf, 0x1f3d3}, 
            {0x1f3e0, 0x1f3f0}, {0x1f3f8, 0x1f43e}, {0x1f442, 0x1f4fc}, {0x1f4ff, 0x1f53d}, 
            {0x1f54b, 0x1f54e}, {0x1f550, 0x1f567}, {0x1f595, 0x1f596}, {0x1f5fb, 0x1f64f}, 
            {0x1f680, 0x1f6c5}, {0x1f6d0, 0x1f6d2}, {0x1f6d5, 0x1f6d8}, {0x1f6dc, 0x1f6df}, 
            {0x1f6eb, 0x1f6ec}, {0x1f6f4, 0x1f6fc}, {0x1f7e0, 0x1f7eb}, {0x1f90c, 0x1f93a}, 
            {0x1f93c, 0x1f945}, {0x1f947, 0x1f9ff}, {0x1fa70, 0x1fa7c}, {0x1fa80, 0x1fa8a}, 
            {0x1fa8e, 0x1fac6}, {0x1facd, 0x1fadd}, {0x1fadf, 0x1faea}, {0x1faef, 0x1faf8}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass87()
{
    // Name = Emoji_Modifier, number of codePoints: 5
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1f3fb, 0x1f3ff}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass88()
{
    // Name = Emoji_Modifier_Base, number of codePoints: 134
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x261d, 0x26f9, 0x1f385, 0x1f3c7, 0x1f47c, 0x1f48f, 0x1f491, 0x1f4aa, 
            0x1f57a, 0x1f590, 0x1f6a3, 0x1f6c0, 0x1f6cc, 0x1f90c, 0x1f90f, 0x1f926, 
            0x1f977, 0x1f9bb}),
        std::initializer_list<CharacterRange>({{0x270a, 0x270d}, {0x1f3c2, 0x1f3c4}, {0x1f3ca, 0x1f3cc}, {0x1f442, 0x1f443}, 
            {0x1f446, 0x1f450}, {0x1f466, 0x1f478}, {0x1f481, 0x1f483}, {0x1f485, 0x1f487}, 
            {0x1f574, 0x1f575}, {0x1f595, 0x1f596}, {0x1f645, 0x1f647}, {0x1f64b, 0x1f64f}, 
            {0x1f6b4, 0x1f6b6}, {0x1f918, 0x1f91f}, {0x1f930, 0x1f939}, {0x1f93c, 0x1f93e}, 
            {0x1f9b5, 0x1f9b6}, {0x1f9b8, 0x1f9b9}, {0x1f9cd, 0x1f9cf}, {0x1f9d1, 0x1f9dd}, 
            {0x1fac3, 0x1fac5}, {0x1faf0, 0x1faf8}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass89()
{
    // Name = Emoji_Component, number of codePoints: 146
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({0x23, 0x2a}),
        std::initializer_list<CharacterRange>({{0x30, 0x39}}),
        std::initializer_list<char32_t>({0x200d, 0x20e3, 0xfe0f}),
        std::initializer_list<CharacterRange>({{0x1f1e6, 0x1f1ff}, {0x1f3fb, 0x1f3ff}, {0x1f9b0, 0x1f9b3}, {0xe0020, 0xe007f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass90()
{
    // Name = Extended_Pictographic, number of codePoints: 2848
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00a9, 0x00ae, 0x203c, 0x2049, 0x2122, 0x2139, 0x2328, 0x23cf, 
            0x24c2, 0x25b6, 0x25c0, 0x260e, 0x2611, 0x2618, 0x261d, 0x2620, 
            0x2626, 0x262a, 0x2640, 0x2642, 0x2663, 0x2668, 0x267b, 0x2699, 
            0x26a7, 0x26c8, 0x26d1, 0x26fd, 0x2702, 0x2705, 0x270f, 0x2712, 
            0x2714, 0x2716, 0x271d, 0x2721, 0x2728, 0x2744, 0x2747, 0x274c, 
            0x274e, 0x2757, 0x27a1, 0x27b0, 0x27bf, 0x2b50, 0x2b55, 0x3030, 
            0x303d, 0x3297, 0x3299, 0x1f004, 0x1f0c0, 0x1f18e, 0x1f21a, 0x1f22f, 
            0x1f587, 0x1f590, 0x1f5a8, 0x1f5bc, 0x1f5e1, 0x1f5e3, 0x1f5e8, 0x1f5ef, 
            0x1f5f3, 0x1f6e9}),
        std::initializer_list<CharacterRange>({{0x2194, 0x2199}, {0x21a9, 0x21aa}, {0x231a, 0x231b}, {0x23e9, 0x23f3}, 
            {0x23f8, 0x23fa}, {0x25aa, 0x25ab}, {0x25fb, 0x25fe}, {0x2600, 0x2604}, 
            {0x2614, 0x2615}, {0x2622, 0x2623}, {0x262e, 0x262f}, {0x2638, 0x263a}, 
            {0x2648, 0x2653}, {0x265f, 0x2660}, {0x2665, 0x2666}, {0x267e, 0x267f}, 
            {0x2692, 0x2697}, {0x269b, 0x269c}, {0x26a0, 0x26a1}, {0x26aa, 0x26ab}, 
            {0x26b0, 0x26b1}, {0x26bd, 0x26be}, {0x26c4, 0x26c5}, {0x26ce, 0x26cf}, 
            {0x26d3, 0x26d4}, {0x26e9, 0x26ea}, {0x26f0, 0x26f5}, {0x26f7, 0x26fa}, 
            {0x2708, 0x270d}, {0x2733, 0x2734}, {0x2753, 0x2755}, {0x2763, 0x2764}, 
            {0x2795, 0x2797}, {0x2934, 0x2935}, {0x2b05, 0x2b07}, {0x2b1b, 0x2b1c}, 
            {0x1f02c, 0x1f02f}, {0x1f094, 0x1f09f}, {0x1f0af, 0x1f0b0}, {0x1f0cf, 0x1f0d0}, 
            {0x1f0f6, 0x1f0ff}, {0x1f170, 0x1f171}, {0x1f17e, 0x1f17f}, {0x1f191, 0x1f19a}, 
            {0x1f1ae, 0x1f1e5}, {0x1f201, 0x1f20f}, {0x1f232, 0x1f23a}, {0x1f23c, 0x1f23f}, 
            {0x1f249, 0x1f25f}, {0x1f266, 0x1f321}, {0x1f324, 0x1f393}, {0x1f396, 0x1f397}, 
            {0x1f399, 0x1f39b}, {0x1f39e, 0x1f3f0}, {0x1f3f3, 0x1f3f5}, {0x1f3f7, 0x1f3fa}, 
            {0x1f400, 0x1f4fd}, {0x1f4ff, 0x1f53d}, {0x1f549, 0x1f54e}, {0x1f550, 0x1f567}, 
            {0x1f56f, 0x1f570}, {0x1f573, 0x1f57a}, {0x1f58a, 0x1f58d}, {0x1f595, 0x1f596}, 
            {0x1f5a4, 0x1f5a5}, {0x1f5b1, 0x1f5b2}, {0x1f5c2, 0x1f5c4}, {0x1f5d1, 0x1f5d3}, 
            {0x1f5dc, 0x1f5de}, {0x1f5fa, 0x1f64f}, {0x1f680, 0x1f6c5}, {0x1f6cb, 0x1f6d2}, 
            {0x1f6d5, 0x1f6e5}, {0x1f6eb, 0x1f6f0}, {0x1f6f3, 0x1f6ff}, {0x1f7da, 0x1f7ff}, 
            {0x1f80c, 0x1f80f}, {0x1f848, 0x1f84f}, {0x1f85a, 0x1f85f}, {0x1f888, 0x1f88f}, 
            {0x1f8ae, 0x1f8af}, {0x1f8bc, 0x1f8bf}, {0x1f8c2, 0x1f8cf}, {0x1f8d9, 0x1f8ff}, 
            {0x1f90c, 0x1f93a}, {0x1f93c, 0x1f945}, {0x1f947, 0x1f9ff}, {0x1fa58, 0x1fa5f}, 
            {0x1fa6e, 0x1faff}, {0x1fc00, 0x1fffd}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass91()
{
    // Name = Unknown, number of codePoints: 954202
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x038b, 0x038d, 0x03a2, 0x0530, 0x0590, 0x070e, 0x083f, 0x085f, 
            0x0984, 0x09a9, 0x09b1, 0x09de, 0x0a00, 0x0a04, 0x0a29, 0x0a31, 
            0x0a34, 0x0a37, 0x0a3d, 0x0a5d, 0x0a84, 0x0a8e, 0x0a92, 0x0aa9, 
            0x0ab1, 0x0ab4, 0x0ac6, 0x0aca, 0x0b00, 0x0b04, 0x0b29, 0x0b31, 
            0x0b34, 0x0b5e, 0x0b84, 0x0b91, 0x0b9b, 0x0b9d, 0x0bc9, 0x0c0d, 
            0x0c11, 0x0c29, 0x0c45, 0x0c49, 0x0c57, 0x0c5b, 0x0c8d, 0x0c91, 
            0x0ca9, 0x0cb4, 0x0cc5, 0x0cc9, 0x0cdf, 0x0cf0, 0x0d0d, 0x0d11, 
            0x0d45, 0x0d49, 0x0d80, 0x0d84, 0x0db2, 0x0dbc, 0x0dd5, 0x0dd7, 
            0x0e83, 0x0e85, 0x0e8b, 0x0ea4, 0x0ea6, 0x0ec5, 0x0ec7, 0x0ecf, 
            0x0f48, 0x0f98, 0x0fbd, 0x0fcd, 0x10c6, 0x1249, 0x1257, 0x1259, 
            0x1289, 0x12b1, 0x12bf, 0x12c1, 0x12d7, 0x1311, 0x176d, 0x1771, 
            0x191f, 0x1a5f, 0x1b4d, 0x1f58, 0x1f5a, 0x1f5c, 0x1f5e, 0x1fb5, 
            0x1fc5, 0x1fdc, 0x1ff5, 0x1fff, 0x2065, 0x208f, 0x2d26, 0x2da7, 
            0x2daf, 0x2db7, 0x2dbf, 0x2dc7, 0x2dcf, 0x2dd7, 0x2ddf, 0x2e9a, 
            0x3040, 0x3130, 0x318f, 0x321f, 0xa9ce, 0xa9ff, 0xab27, 0xab2f, 
            0xfb37, 0xfb3d, 0xfb3f, 0xfb42, 0xfb45, 0xfe53, 0xfe67, 0xfe75, 
            0xff00, 0xffe7, 0x1000c, 0x10027, 0x1003b, 0x1003e, 0x1018f, 0x1039e, 
            0x1057b, 0x1058b, 0x10593, 0x10596, 0x105a2, 0x105b2, 0x105ba, 0x10786, 
            0x107b1, 0x10809, 0x10836, 0x10856, 0x108f3, 0x10a04, 0x10a14, 0x10a18, 
            0x10e7f, 0x10eaa, 0x11135, 0x111e0, 0x11212, 0x11287, 0x11289, 0x1128e, 
            0x1129e, 0x11304, 0x11329, 0x11331, 0x11334, 0x1133a, 0x1138a, 0x1138f, 
            0x113b6, 0x113c1, 0x113c6, 0x113cb, 0x113d6, 0x1145c, 0x11914, 0x11917, 
            0x11936, 0x11c09, 0x11c37, 0x11ca8, 0x11d07, 0x11d0a, 0x11d3b, 0x11d3e, 
            0x11d66, 0x11d69, 0x11d8f, 0x11d92, 0x11f11, 0x1246f, 0x16a5f, 0x16abf, 
            0x16b5a, 0x16b62, 0x1aff4, 0x1affc, 0x1afff, 0x1d455, 0x1d49d, 0x1d4ad, 
            0x1d4ba, 0x1d4bc, 0x1d4c4, 0x1d506, 0x1d515, 0x1d51d, 0x1d53a, 0x1d53f, 
            0x1d545, 0x1d551, 0x1daa0, 0x1e007, 0x1e022, 0x1e025, 0x1e6df, 0x1e7e7, 
            0x1e7ec, 0x1e7ef, 0x1e7ff, 0x1ee04, 0x1ee20, 0x1ee23, 0x1ee28, 0x1ee33, 
            0x1ee38, 0x1ee3a, 0x1ee48, 0x1ee4a, 0x1ee4c, 0x1ee50, 0x1ee53, 0x1ee58, 
            0x1ee5a, 0x1ee5c, 0x1ee5e, 0x1ee60, 0x1ee63, 0x1ee6b, 0x1ee73, 0x1ee78, 
            0x1ee7d, 0x1ee7f, 0x1ee8a, 0x1eea4, 0x1eeaa, 0x1f0c0, 0x1f0d0, 0x1fac7, 
            0x1fade, 0x1fb93}),
        std::initializer_list<CharacterRange>({{0x0378, 0x0379}, {0x0380, 0x0383}, {0x0557, 0x0558}, {0x058b, 0x058c}, 
            {0x05c8, 0x05cf}, {0x05eb, 0x05ee}, {0x05f5, 0x05ff}, {0x074b, 0x074c}, 
            {0x07b2, 0x07bf}, {0x07fb, 0x07fc}, {0x082e, 0x082f}, {0x085c, 0x085d}, 
            {0x086b, 0x086f}, {0x0892, 0x0896}, {0x098d, 0x098e}, {0x0991, 0x0992}, 
            {0x09b3, 0x09b5}, {0x09ba, 0x09bb}, {0x09c5, 0x09c6}, {0x09c9, 0x09ca}, 
            {0x09cf, 0x09d6}, {0x09d8, 0x09db}, {0x09e4, 0x09e5}, {0x0a0b, 0x0a0e}, 
            {0x0a11, 0x0a12}, {0x0a3a, 0x0a3b}, {0x0a43, 0x0a46}, {0x0a49, 0x0a4a}, 
            {0x0a4e, 0x0a50}, {0x0a52, 0x0a58}, {0x0a5f, 0x0a65}, {0x0a77, 0x0a80}, 
            {0x0aba, 0x0abb}, {0x0ace, 0x0acf}, {0x0ad1, 0x0adf}, {0x0ae4, 0x0ae5}, 
            {0x0af2, 0x0af8}, {0x0b0d, 0x0b0e}, {0x0b11, 0x0b12}, {0x0b3a, 0x0b3b}, 
            {0x0b45, 0x0b46}, {0x0b49, 0x0b4a}, {0x0b4e, 0x0b52}, {0x0b58, 0x0b5b}, 
            {0x0b64, 0x0b65}, {0x0b78, 0x0b81}, {0x0b8b, 0x0b8d}, {0x0b96, 0x0b98}, 
            {0x0ba0, 0x0ba2}, {0x0ba5, 0x0ba7}, {0x0bab, 0x0bad}, {0x0bba, 0x0bbd}, 
            {0x0bc3, 0x0bc5}, {0x0bce, 0x0bcf}, {0x0bd1, 0x0bd6}, {0x0bd8, 0x0be5}, 
            {0x0bfb, 0x0bff}, {0x0c3a, 0x0c3b}, {0x0c4e, 0x0c54}, {0x0c5e, 0x0c5f}, 
            {0x0c64, 0x0c65}, {0x0c70, 0x0c76}, {0x0cba, 0x0cbb}, {0x0cce, 0x0cd4}, 
            {0x0cd7, 0x0cdb}, {0x0ce4, 0x0ce5}, {0x0cf4, 0x0cff}, {0x0d50, 0x0d53}, 
            {0x0d64, 0x0d65}, {0x0d97, 0x0d99}, {0x0dbe, 0x0dbf}, {0x0dc7, 0x0dc9}, 
            {0x0dcb, 0x0dce}, {0x0de0, 0x0de5}, {0x0df0, 0x0df1}, {0x0df5, 0x0e00}, 
            {0x0e3b, 0x0e3e}, {0x0e5c, 0x0e80}, {0x0ebe, 0x0ebf}, {0x0eda, 0x0edb}, 
            {0x0ee0, 0x0eff}, {0x0f6d, 0x0f70}, {0x0fdb, 0x0fff}, {0x10c8, 0x10cc}, 
            {0x10ce, 0x10cf}, {0x124e, 0x124f}, {0x125e, 0x125f}, {0x128e, 0x128f}, 
            {0x12b6, 0x12b7}, {0x12c6, 0x12c7}, {0x1316, 0x1317}, {0x135b, 0x135c}, 
            {0x137d, 0x137f}, {0x139a, 0x139f}, {0x13f6, 0x13f7}, {0x13fe, 0x13ff}, 
            {0x169d, 0x169f}, {0x16f9, 0x16ff}, {0x1716, 0x171e}, {0x1737, 0x173f}, 
            {0x1754, 0x175f}, {0x1774, 0x177f}, {0x17de, 0x17df}, {0x17ea, 0x17ef}, 
            {0x17fa, 0x17ff}, {0x181a, 0x181f}, {0x1879, 0x187f}, {0x18ab, 0x18af}, 
            {0x18f6, 0x18ff}, {0x192c, 0x192f}, {0x193c, 0x193f}, {0x1941, 0x1943}, 
            {0x196e, 0x196f}, {0x1975, 0x197f}, {0x19ac, 0x19af}, {0x19ca, 0x19cf}, 
            {0x19db, 0x19dd}, {0x1a1c, 0x1a1d}, {0x1a7d, 0x1a7e}, {0x1a8a, 0x1a8f}, 
            {0x1a9a, 0x1a9f}, {0x1aae, 0x1aaf}, {0x1ade, 0x1adf}, {0x1aec, 0x1aff}, 
            {0x1bf4, 0x1bfb}, {0x1c38, 0x1c3a}, {0x1c4a, 0x1c4c}, {0x1c8b, 0x1c8f}, 
            {0x1cbb, 0x1cbc}, {0x1cc8, 0x1ccf}, {0x1cfb, 0x1cff}, {0x1f16, 0x1f17}, 
            {0x1f1e, 0x1f1f}, {0x1f46, 0x1f47}, {0x1f4e, 0x1f4f}, {0x1f7e, 0x1f7f}, 
            {0x1fd4, 0x1fd5}, {0x1ff0, 0x1ff1}, {0x2072, 0x2073}, {0x209d, 0x209f}, 
            {0x20c2, 0x20cf}, {0x20f1, 0x20ff}, {0x218c, 0x218f}, {0x242a, 0x243f}, 
            {0x244b, 0x245f}, {0x2b74, 0x2b75}, {0x2cf4, 0x2cf8}, {0x2d28, 0x2d2c}, 
            {0x2d2e, 0x2d2f}, {0x2d68, 0x2d6e}, {0x2d71, 0x2d7e}, {0x2d97, 0x2d9f}, 
            {0x2e5e, 0x2e7f}, {0x2ef4, 0x2eff}, {0x2fd6, 0x2fef}, {0x3097, 0x3098}, 
            {0x3100, 0x3104}, {0x31e6, 0x31ee}, {0xa48d, 0xa48f}, {0xa4c7, 0xa4cf}, 
            {0xa62c, 0xa63f}, {0xa6f8, 0xa6ff}, {0xa7dd, 0xa7f0}, {0xa82d, 0xa82f}, 
            {0xa83a, 0xa83f}, {0xa878, 0xa87f}, {0xa8c6, 0xa8cd}, {0xa8da, 0xa8df}, 
            {0xa954, 0xa95e}, {0xa97d, 0xa97f}, {0xa9da, 0xa9dd}, {0xaa37, 0xaa3f}, 
            {0xaa4e, 0xaa4f}, {0xaa5a, 0xaa5b}, {0xaac3, 0xaada}, {0xaaf7, 0xab00}, 
            {0xab07, 0xab08}, {0xab0f, 0xab10}, {0xab17, 0xab1f}, {0xab6c, 0xab6f}, 
            {0xabee, 0xabef}, {0xabfa, 0xabff}, {0xd7a4, 0xd7af}, {0xd7c7, 0xd7ca}, 
            {0xd7fc, 0xf8ff}, {0xfa6e, 0xfa6f}, {0xfada, 0xfaff}, {0xfb07, 0xfb12}, 
            {0xfb18, 0xfb1c}, {0xfdd0, 0xfdef}, {0xfe1a, 0xfe1f}, {0xfe6c, 0xfe6f}, 
            {0xfefd, 0xfefe}, {0xffbf, 0xffc1}, {0xffc8, 0xffc9}, {0xffd0, 0xffd1}, 
            {0xffd8, 0xffd9}, {0xffdd, 0xffdf}, {0xffef, 0xfff8}, {0xfffe, 0xffff}, 
            {0x1004e, 0x1004f}, {0x1005e, 0x1007f}, {0x100fb, 0x100ff}, {0x10103, 0x10106}, 
            {0x10134, 0x10136}, {0x1019d, 0x1019f}, {0x101a1, 0x101cf}, {0x101fe, 0x1027f}, 
            {0x1029d, 0x1029f}, {0x102d1, 0x102df}, {0x102fc, 0x102ff}, {0x10324, 0x1032c}, 
            {0x1034b, 0x1034f}, {0x1037b, 0x1037f}, {0x103c4, 0x103c7}, {0x103d6, 0x103ff}, 
            {0x1049e, 0x1049f}, {0x104aa, 0x104af}, {0x104d4, 0x104d7}, {0x104fc, 0x104ff}, 
            {0x10528, 0x1052f}, {0x10564, 0x1056e}, {0x105bd, 0x105bf}, {0x105f4, 0x105ff}, 
            {0x10737, 0x1073f}, {0x10756, 0x1075f}, {0x10768, 0x1077f}, {0x107bb, 0x107ff}, 
            {0x10806, 0x10807}, {0x10839, 0x1083b}, {0x1083d, 0x1083e}, {0x1089f, 0x108a6}, 
            {0x108b0, 0x108df}, {0x108f6, 0x108fa}, {0x1091c, 0x1091e}, {0x1093a, 0x1093e}, 
            {0x1095a, 0x1097f}, {0x109b8, 0x109bb}, {0x109d0, 0x109d1}, {0x10a07, 0x10a0b}, 
            {0x10a36, 0x10a37}, {0x10a3b, 0x10a3e}, {0x10a49, 0x10a4f}, {0x10a59, 0x10a5f}, 
            {0x10aa0, 0x10abf}, {0x10ae7, 0x10aea}, {0x10af7, 0x10aff}, {0x10b36, 0x10b38}, 
            {0x10b56, 0x10b57}, {0x10b73, 0x10b77}, {0x10b92, 0x10b98}, {0x10b9d, 0x10ba8}, 
            {0x10bb0, 0x10bff}, {0x10c49, 0x10c7f}, {0x10cb3, 0x10cbf}, {0x10cf3, 0x10cf9}, 
            {0x10d28, 0x10d2f}, {0x10d3a, 0x10d3f}, {0x10d66, 0x10d68}, {0x10d86, 0x10d8d}, 
            {0x10d90, 0x10e5f}, {0x10eae, 0x10eaf}, {0x10eb2, 0x10ec1}, {0x10ec8, 0x10ecf}, 
            {0x10ed9, 0x10ef9}, {0x10f28, 0x10f2f}, {0x10f5a, 0x10f6f}, {0x10f8a, 0x10faf}, 
            {0x10fcc, 0x10fdf}, {0x10ff7, 0x10fff}, {0x1104e, 0x11051}, {0x11076, 0x1107e}, 
            {0x110c3, 0x110cc}, {0x110ce, 0x110cf}, {0x110e9, 0x110ef}, {0x110fa, 0x110ff}, 
            {0x11148, 0x1114f}, {0x11177, 0x1117f}, {0x111f5, 0x111ff}, {0x11242, 0x1127f}, 
            {0x112aa, 0x112af}, {0x112eb, 0x112ef}, {0x112fa, 0x112ff}, {0x1130d, 0x1130e}, 
            {0x11311, 0x11312}, {0x11345, 0x11346}, {0x11349, 0x1134a}, {0x1134e, 0x1134f}, 
            {0x11351, 0x11356}, {0x11358, 0x1135c}, {0x11364, 0x11365}, {0x1136d, 0x1136f}, 
            {0x11375, 0x1137f}, {0x1138c, 0x1138d}, {0x113c3, 0x113c4}, {0x113d9, 0x113e0}, 
            {0x113e3, 0x113ff}, {0x11462, 0x1147f}, {0x114c8, 0x114cf}, {0x114da, 0x1157f}, 
            {0x115b6, 0x115b7}, {0x115de, 0x115ff}, {0x11645, 0x1164f}, {0x1165a, 0x1165f}, 
            {0x1166d, 0x1167f}, {0x116ba, 0x116bf}, {0x116ca, 0x116cf}, {0x116e4, 0x116ff}, 
            {0x1171b, 0x1171c}, {0x1172c, 0x1172f}, {0x11747, 0x117ff}, {0x1183c, 0x1189f}, 
            {0x118f3, 0x118fe}, {0x11907, 0x11908}, {0x1190a, 0x1190b}, {0x11939, 0x1193a}, 
            {0x11947, 0x1194f}, {0x1195a, 0x1199f}, {0x119a8, 0x119a9}, {0x119d8, 0x119d9}, 
            {0x119e5, 0x119ff}, {0x11a48, 0x11a4f}, {0x11aa3, 0x11aaf}, {0x11af9, 0x11aff}, 
            {0x11b0a, 0x11b5f}, {0x11b68, 0x11bbf}, {0x11be2, 0x11bef}, {0x11bfa, 0x11bff}, 
            {0x11c46, 0x11c4f}, {0x11c6d, 0x11c6f}, {0x11c90, 0x11c91}, {0x11cb7, 0x11cff}, 
            {0x11d37, 0x11d39}, {0x11d48, 0x11d4f}, {0x11d5a, 0x11d5f}, {0x11d99, 0x11d9f}, 
            {0x11daa, 0x11daf}, {0x11ddc, 0x11ddf}, {0x11dea, 0x11edf}, {0x11ef9, 0x11eff}, 
            {0x11f3b, 0x11f3d}, {0x11f5b, 0x11faf}, {0x11fb1, 0x11fbf}, {0x11ff2, 0x11ffe}, 
            {0x1239a, 0x123ff}, {0x12475, 0x1247f}, {0x12544, 0x12f8f}, {0x12ff3, 0x12fff}, 
            {0x13456, 0x1345f}, {0x143fb, 0x143ff}, {0x14647, 0x160ff}, {0x1613a, 0x167ff}, 
            {0x16a39, 0x16a3f}, {0x16a6a, 0x16a6d}, {0x16aca, 0x16acf}, {0x16aee, 0x16aef}, 
            {0x16af6, 0x16aff}, {0x16b46, 0x16b4f}, {0x16b78, 0x16b7c}, {0x16b90, 0x16d3f}, 
            {0x16d7a, 0x16d7f}, {0x16d9e, 0x16d9f}, {0x16daa, 0x16e3f}, {0x16e9b, 0x16e9f}, 
            {0x16eb9, 0x16eba}, {0x16ed4, 0x16eff}, {0x16f4b, 0x16f4e}, {0x16f88, 0x16f8e}, 
            {0x16fa0, 0x16fdf}, {0x16fe5, 0x16fef}, {0x16ff7, 0x16fff}, {0x18cd6, 0x18cfe}, 
            {0x18d1f, 0x18d7f}, {0x18df3, 0x1afef}, {0x1b123, 0x1b131}, {0x1b133, 0x1b14f}, 
            {0x1b153, 0x1b154}, {0x1b156, 0x1b163}, {0x1b168, 0x1b16f}, {0x1b2fc, 0x1bbff}, 
            {0x1bc6b, 0x1bc6f}, {0x1bc7d, 0x1bc7f}, {0x1bc89, 0x1bc8f}, {0x1bc9a, 0x1bc9b}, 
            {0x1bca4, 0x1cbff}, {0x1ccfd, 0x1ccff}, {0x1ceb4, 0x1ceb9}, {0x1ced1, 0x1cedf}, 
            {0x1cef1, 0x1ceff}, {0x1cf2e, 0x1cf2f}, {0x1cf47, 0x1cf4f}, {0x1cfc4, 0x1cfff}, 
            {0x1d0f6, 0x1d0ff}, {0x1d127, 0x1d128}, {0x1d1eb, 0x1d1ff}, {0x1d246, 0x1d2bf}, 
            {0x1d2d4, 0x1d2df}, {0x1d2f4, 0x1d2ff}, {0x1d357, 0x1d35f}, {0x1d379, 0x1d3ff}, 
            {0x1d4a0, 0x1d4a1}, {0x1d4a3, 0x1d4a4}, {0x1d4a7, 0x1d4a8}, {0x1d50b, 0x1d50c}, 
            {0x1d547, 0x1d549}, {0x1d6a6, 0x1d6a7}, {0x1d7cc, 0x1d7cd}, {0x1da8c, 0x1da9a}, 
            {0x1dab0, 0x1deff}, {0x1df1f, 0x1df24}, {0x1df2b, 0x1dfff}, {0x1e019, 0x1e01a}, 
            {0x1e02b, 0x1e02f}, {0x1e06e, 0x1e08e}, {0x1e090, 0x1e0ff}, {0x1e12d, 0x1e12f}, 
            {0x1e13e, 0x1e13f}, {0x1e14a, 0x1e14d}, {0x1e150, 0x1e28f}, {0x1e2af, 0x1e2bf}, 
            {0x1e2fa, 0x1e2fe}, {0x1e300, 0x1e4cf}, {0x1e4fa, 0x1e5cf}, {0x1e5fb, 0x1e5fe}, 
            {0x1e600, 0x1e6bf}, {0x1e6f6, 0x1e6fd}, {0x1e700, 0x1e7df}, {0x1e8c5, 0x1e8c6}, 
            {0x1e8d7, 0x1e8ff}, {0x1e94c, 0x1e94f}, {0x1e95a, 0x1e95d}, {0x1e960, 0x1ec70}, 
            {0x1ecb5, 0x1ed00}, {0x1ed3e, 0x1edff}, {0x1ee25, 0x1ee26}, {0x1ee3c, 0x1ee41}, 
            {0x1ee43, 0x1ee46}, {0x1ee55, 0x1ee56}, {0x1ee65, 0x1ee66}, {0x1ee9c, 0x1eea0}, 
            {0x1eebc, 0x1eeef}, {0x1eef2, 0x1efff}, {0x1f02c, 0x1f02f}, {0x1f094, 0x1f09f}, 
            {0x1f0af, 0x1f0b0}, {0x1f0f6, 0x1f0ff}, {0x1f1ae, 0x1f1e5}, {0x1f203, 0x1f20f}, 
            {0x1f23c, 0x1f23f}, {0x1f249, 0x1f24f}, {0x1f252, 0x1f25f}, {0x1f266, 0x1f2ff}, 
            {0x1f6d9, 0x1f6db}, {0x1f6ed, 0x1f6ef}, {0x1f6fd, 0x1f6ff}, {0x1f7da, 0x1f7df}, 
            {0x1f7ec, 0x1f7ef}, {0x1f7f1, 0x1f7ff}, {0x1f80c, 0x1f80f}, {0x1f848, 0x1f84f}, 
            {0x1f85a, 0x1f85f}, {0x1f888, 0x1f88f}, {0x1f8ae, 0x1f8af}, {0x1f8bc, 0x1f8bf}, 
            {0x1f8c2, 0x1f8cf}, {0x1f8d9, 0x1f8ff}, {0x1fa58, 0x1fa5f}, {0x1fa6e, 0x1fa6f}, 
            {0x1fa7d, 0x1fa7f}, {0x1fa8b, 0x1fa8d}, {0x1fac9, 0x1facc}, {0x1faeb, 0x1faee}, 
            {0x1faf9, 0x1faff}, {0x1fbfb, 0x1ffff}, {0x2a6e0, 0x2a6ff}, {0x2b81e, 0x2b81f}, 
            {0x2ceae, 0x2ceaf}, {0x2ebe1, 0x2ebef}, {0x2ee5e, 0x2f7ff}, {0x2fa1e, 0x2ffff}, 
            {0x3134b, 0x3134f}, {0x3347a, 0xe0000}, {0xe0002, 0xe001f}, {0xe0080, 0xe00ff}, 
            {0xe01f0, 0x10ffff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass92()
{
    // Name = Common, number of codePoints: 9124
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x00, 0x40}, {0x5b, 0x60}, {0x7b, 0x7f}}),
        std::initializer_list<char32_t>({0x00d7, 0x00f7, 0x0374, 0x037e, 0x0385, 0x0387, 0x0605, 0x060c, 
            0x061b, 0x061f, 0x0640, 0x06dd, 0x08e2, 0x0e3f, 0x10fb, 0x1805, 
            0x1cd3, 0x1ce1, 0x1cfa, 0x3006, 0x30a0, 0x31ef, 0x32ff, 0xa92e, 
            0xa9cf, 0xab5b, 0xfeff, 0xff70, 0x1d4a2, 0x1d4bb, 0x1d546, 0x1f7f0, 
            0x1fac8, 0xe0001}),
        std::initializer_list<CharacterRange>({{0x0080, 0x00a9}, {0x00ab, 0x00b9}, {0x00bb, 0x00bf}, {0x02b9, 0x02df}, 
            {0x02e5, 0x02e9}, {0x02ec, 0x02ff}, {0x0964, 0x0965}, {0x0fd5, 0x0fd8}, 
            {0x16eb, 0x16ed}, {0x1735, 0x1736}, {0x1802, 0x1803}, {0x1ce9, 0x1cec}, 
            {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf7}, {0x2000, 0x200b}, {0x200e, 0x2064}, 
            {0x2066, 0x2070}, {0x2074, 0x207e}, {0x2080, 0x208e}, {0x20a0, 0x20c1}, 
            {0x2100, 0x2125}, {0x2127, 0x2129}, {0x212c, 0x2131}, {0x2133, 0x214d}, 
            {0x214f, 0x215f}, {0x2189, 0x218b}, {0x2190, 0x2429}, {0x2440, 0x244a}, 
            {0x2460, 0x27ff}, {0x2900, 0x2b73}, {0x2b76, 0x2bff}, {0x2e00, 0x2e5d}, 
            {0x2ff0, 0x3004}, {0x3008, 0x3020}, {0x3030, 0x3037}, {0x303c, 0x303f}, 
            {0x309b, 0x309c}, {0x30fb, 0x30fc}, {0x3190, 0x319f}, {0x31c0, 0x31e5}, 
            {0x3220, 0x325f}, {0x327f, 0x32cf}, {0x3358, 0x33ff}, {0x4dc0, 0x4dff}, 
            {0xa700, 0xa721}, {0xa788, 0xa78a}, {0xa830, 0xa839}, {0xab6a, 0xab6b}, 
            {0xfd3e, 0xfd3f}, {0xfe10, 0xfe19}, {0xfe30, 0xfe52}, {0xfe54, 0xfe66}, 
            {0xfe68, 0xfe6b}, {0xff01, 0xff20}, {0xff3b, 0xff40}, {0xff5b, 0xff65}, 
            {0xff9e, 0xff9f}, {0xffe0, 0xffe6}, {0xffe8, 0xffee}, {0xfff9, 0xfffd}, 
            {0x10100, 0x10102}, {0x10107, 0x10133}, {0x10137, 0x1013f}, {0x10190, 0x1019c}, 
            {0x101d0, 0x101fc}, {0x102e1, 0x102fb}, {0x1bca0, 0x1bca3}, {0x1cc00, 0x1ccfc}, 
            {0x1cd00, 0x1ceb3}, {0x1ceba, 0x1ced0}, {0x1cee0, 0x1cef0}, {0x1cf50, 0x1cfc3}, 
            {0x1d000, 0x1d0f5}, {0x1d100, 0x1d126}, {0x1d129, 0x1d166}, {0x1d16a, 0x1d17a}, 
            {0x1d183, 0x1d184}, {0x1d18c, 0x1d1a9}, {0x1d1ae, 0x1d1ea}, {0x1d2c0, 0x1d2d3}, 
            {0x1d2e0, 0x1d2f3}, {0x1d300, 0x1d356}, {0x1d360, 0x1d378}, {0x1d400, 0x1d454}, 
            {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, 
            {0x1d4ae, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, 
            {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, 
            {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d7cb}, 
            {0x1d7ce, 0x1d7ff}, {0x1ec71, 0x1ecb4}, {0x1ed01, 0x1ed3d}, {0x1f000, 0x1f02b}, 
            {0x1f030, 0x1f093}, {0x1f0a0, 0x1f0ae}, {0x1f0b1, 0x1f0bf}, {0x1f0c1, 0x1f0cf}, 
            {0x1f0d1, 0x1f0f5}, {0x1f100, 0x1f1ad}, {0x1f1e6, 0x1f1ff}, {0x1f201, 0x1f202}, 
            {0x1f210, 0x1f23b}, {0x1f240, 0x1f248}, {0x1f250, 0x1f251}, {0x1f260, 0x1f265}, 
            {0x1f300, 0x1f6d8}, {0x1f6dc, 0x1f6ec}, {0x1f6f0, 0x1f6fc}, {0x1f700, 0x1f7d9}, 
            {0x1f7e0, 0x1f7eb}, {0x1f800, 0x1f80b}, {0x1f810, 0x1f847}, {0x1f850, 0x1f859}, 
            {0x1f860, 0x1f887}, {0x1f890, 0x1f8ad}, {0x1f8b0, 0x1f8bb}, {0x1f8c0, 0x1f8c1}, 
            {0x1f8d0, 0x1f8d8}, {0x1f900, 0x1fa57}, {0x1fa60, 0x1fa6d}, {0x1fa70, 0x1fa7c}, 
            {0x1fa80, 0x1fa8a}, {0x1fa8e, 0x1fac6}, {0x1facd, 0x1fadd}, {0x1fadf, 0x1faea}, 
            {0x1faef, 0x1faf8}, {0x1fb00, 0x1fb92}, {0x1fb94, 0x1fbfa}, {0xe0020, 0xe007f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass93()
{
    // Name = Latin, number of codePoints: 1492
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<char32_t>({0x00aa, 0x00ba, 0x2071, 0x207f, 0x2132, 0x214e}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x02b8}, {0x02e0, 0x02e4}, 
            {0x1d00, 0x1d25}, {0x1d2c, 0x1d5c}, {0x1d62, 0x1d65}, {0x1d6b, 0x1d77}, 
            {0x1d79, 0x1dbe}, {0x1e00, 0x1eff}, {0x2090, 0x209c}, {0x212a, 0x212b}, 
            {0x2160, 0x2188}, {0x2c60, 0x2c7f}, {0xa722, 0xa787}, {0xa78b, 0xa7dc}, 
            {0xa7f1, 0xa7ff}, {0xab30, 0xab5a}, {0xab5c, 0xab64}, {0xab66, 0xab69}, 
            {0xfb00, 0xfb06}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0x10780, 0x10785}, 
            {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass94()
{
    // Name = Greek, number of codePoints: 518
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x037f, 0x0384, 0x0386, 0x038c, 0x1dbf, 0x1f59, 0x1f5b, 0x1f5d, 
            0x2126, 0xab65, 0x101a0}),
        std::initializer_list<CharacterRange>({{0x0370, 0x0373}, {0x0375, 0x0377}, {0x037a, 0x037d}, {0x0388, 0x038a}, 
            {0x038e, 0x03a1}, {0x03a3, 0x03e1}, {0x03f0, 0x03ff}, {0x1d26, 0x1d2a}, 
            {0x1d5d, 0x1d61}, {0x1d66, 0x1d6a}, {0x1f00, 0x1f15}, {0x1f18, 0x1f1d}, 
            {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f5f, 0x1f7d}, 
            {0x1f80, 0x1fb4}, {0x1fb6, 0x1fc4}, {0x1fc6, 0x1fd3}, {0x1fd6, 0x1fdb}, 
            {0x1fdd, 0x1fef}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffe}, {0x10140, 0x1018e}, 
            {0x1d200, 0x1d245}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass95()
{
    // Name = Cyrillic, number of codePoints: 508
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1d2b, 0x1d78, 0x1e08f}),
        std::initializer_list<CharacterRange>({{0x0400, 0x0484}, {0x0487, 0x052f}, {0x1c80, 0x1c8a}, {0x2de0, 0x2dff}, 
            {0xa640, 0xa69f}, {0xfe2e, 0xfe2f}, {0x1e030, 0x1e06d}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass96()
{
    // Name = Armenian, number of codePoints: 96
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0531, 0x0556}, {0x0559, 0x058a}, {0x058d, 0x058f}, {0xfb13, 0xfb17}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass97()
{
    // Name = Hebrew, number of codePoints: 134
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0xfb3e}),
        std::initializer_list<CharacterRange>({{0x0591, 0x05c7}, {0x05d0, 0x05ea}, {0x05ef, 0x05f4}, {0xfb1d, 0xfb36}, 
            {0xfb38, 0xfb3c}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfb4f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass98()
{
    // Name = Arabic, number of codePoints: 1413
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 0x1ee42, 0x1ee47, 0x1ee49, 0x1ee4b, 
            0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 0x1ee5d, 0x1ee5f, 0x1ee64, 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x0600, 0x0604}, {0x0606, 0x060b}, {0x060d, 0x061a}, {0x061c, 0x061e}, 
            {0x0620, 0x063f}, {0x0641, 0x064a}, {0x0656, 0x066f}, {0x0671, 0x06dc}, 
            {0x06de, 0x06ff}, {0x0750, 0x077f}, {0x0870, 0x0891}, {0x0897, 0x08e1}, 
            {0x08e3, 0x08ff}, {0xfb50, 0xfd3d}, {0xfd40, 0xfdcf}, {0xfdf0, 0xfdff}, 
            {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, {0x10e60, 0x10e7e}, {0x10ec2, 0x10ec7}, 
            {0x10ed0, 0x10ed8}, {0x10efa, 0x10eff}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, 
            {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee4d, 0x1ee4f}, 
            {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, 
            {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, 
            {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1eef0, 0x1eef1}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass99()
{
    // Name = Syriac, number of codePoints: 88
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0700, 0x070d}, {0x070f, 0x074a}, {0x074d, 0x074f}, {0x0860, 0x086a}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass100()
{
    // Name = Thaana, number of codePoints: 50
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0780, 0x07b1}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass101()
{
    // Name = Devanagari, number of codePoints: 164
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0900, 0x0950}, {0x0955, 0x0963}, {0x0966, 0x097f}, {0xa8e0, 0xa8ff}, 
            {0x11b00, 0x11b09}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass102()
{
    // Name = Bengali, number of codePoints: 97
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x09b2, 0x09d7}),
        std::initializer_list<CharacterRange>({{0x0980, 0x0983}, {0x0985, 0x098c}, {0x098f, 0x0990}, {0x0993, 0x09a8}, 
            {0x09aa, 0x09b0}, {0x09b6, 0x09b9}, {0x09bc, 0x09c4}, {0x09c7, 0x09c8}, 
            {0x09cb, 0x09ce}, {0x09dc, 0x09dd}, {0x09df, 0x09e3}, {0x09e6, 0x09ff}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass103()
{
    // Name = Gurmukhi, number of codePoints: 80
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0a3c, 0x0a51, 0x0a5e}),
        std::initializer_list<CharacterRange>({{0x0a01, 0x0a03}, {0x0a05, 0x0a0a}, {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, 
            {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, 
            {0x0a3e, 0x0a42}, {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a59, 0x0a5c}, 
            {0x0a66, 0x0a76}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass104()
{
    // Name = Gujarati, number of codePoints: 91
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0ad0}),
        std::initializer_list<CharacterRange>({{0x0a81, 0x0a83}, {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, 
            {0x0aaa, 0x0ab0}, {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0abc, 0x0ac5}, 
            {0x0ac7, 0x0ac9}, {0x0acb, 0x0acd}, {0x0ae0, 0x0ae3}, {0x0ae6, 0x0af1}, 
            {0x0af9, 0x0aff}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass105()
{
    // Name = Oriya, number of codePoints: 93
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0b01, 0x0b03}, {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, 
            {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, {0x0b3c, 0x0b44}, 
            {0x0b47, 0x0b48}, {0x0b4b, 0x0b4d}, {0x0b53, 0x0b57}, {0x0b5c, 0x0b5d}, 
            {0x0b5f, 0x0b63}, {0x0b66, 0x0b77}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass106()
{
    // Name = Tamil, number of codePoints: 123
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0b9c, 0x0bd0, 0x0bd7, 0x11fff}),
        std::initializer_list<CharacterRange>({{0x0b82, 0x0b83}, {0x0b85, 0x0b8a}, {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, 
            {0x0b99, 0x0b9a}, {0x0b9e, 0x0b9f}, {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, 
            {0x0bae, 0x0bb9}, {0x0bbe, 0x0bc2}, {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcd}, 
            {0x0be6, 0x0bfa}, {0x11fc0, 0x11ff1}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass107()
{
    // Name = Telugu, number of codePoints: 101
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0c00, 0x0c0c}, {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, 
            {0x0c3c, 0x0c44}, {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56}, 
            {0x0c58, 0x0c5a}, {0x0c5c, 0x0c5d}, {0x0c60, 0x0c63}, {0x0c66, 0x0c6f}, 
            {0x0c77, 0x0c7f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass108()
{
    // Name = Kannada, number of codePoints: 92
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0c80, 0x0c8c}, {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, 
            {0x0cb5, 0x0cb9}, {0x0cbc, 0x0cc4}, {0x0cc6, 0x0cc8}, {0x0cca, 0x0ccd}, 
            {0x0cd5, 0x0cd6}, {0x0cdc, 0x0cde}, {0x0ce0, 0x0ce3}, {0x0ce6, 0x0cef}, 
            {0x0cf1, 0x0cf3}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass109()
{
    // Name = Malayalam, number of codePoints: 118
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0d00, 0x0d0c}, {0x0d0e, 0x0d10}, {0x0d12, 0x0d44}, {0x0d46, 0x0d48}, 
            {0x0d4a, 0x0d4f}, {0x0d54, 0x0d63}, {0x0d66, 0x0d7f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass110()
{
    // Name = Sinhala, number of codePoints: 111
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0dbd, 0x0dca, 0x0dd6}),
        std::initializer_list<CharacterRange>({{0x0d81, 0x0d83}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, {0x0db3, 0x0dbb}, 
            {0x0dc0, 0x0dc6}, {0x0dcf, 0x0dd4}, {0x0dd8, 0x0ddf}, {0x0de6, 0x0def}, 
            {0x0df2, 0x0df4}, {0x111e1, 0x111f4}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass111()
{
    // Name = Thai, number of codePoints: 86
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0e01, 0x0e3a}, {0x0e40, 0x0e5b}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass112()
{
    // Name = Lao, number of codePoints: 83
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0e84, 0x0ea5, 0x0ec6}),
        std::initializer_list<CharacterRange>({{0x0e81, 0x0e82}, {0x0e86, 0x0e8a}, {0x0e8c, 0x0ea3}, {0x0ea7, 0x0ebd}, 
            {0x0ec0, 0x0ec4}, {0x0ec8, 0x0ece}, {0x0ed0, 0x0ed9}, {0x0edc, 0x0edf}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass113()
{
    // Name = Tibetan, number of codePoints: 207
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0f00, 0x0f47}, {0x0f49, 0x0f6c}, {0x0f71, 0x0f97}, {0x0f99, 0x0fbc}, 
            {0x0fbe, 0x0fcc}, {0x0fce, 0x0fd4}, {0x0fd9, 0x0fda}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass114()
{
    // Name = Myanmar, number of codePoints: 243
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1000, 0x109f}, {0xa9e0, 0xa9fe}, {0xaa60, 0xaa7f}, {0x116d0, 0x116e3}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass115()
{
    // Name = Georgian, number of codePoints: 173
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x10c7, 0x10cd, 0x2d27, 0x2d2d}),
        std::initializer_list<CharacterRange>({{0x10a0, 0x10c5}, {0x10d0, 0x10fa}, {0x10fc, 0x10ff}, {0x1c90, 0x1cba}, 
            {0x1cbd, 0x1cbf}, {0x2d00, 0x2d25}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass116()
{
    // Name = Hangul, number of codePoints: 11739
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1100, 0x11ff}, {0x302e, 0x302f}, {0x3131, 0x318e}, {0x3200, 0x321e}, 
            {0x3260, 0x327e}, {0xa960, 0xa97c}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, 
            {0xd7cb, 0xd7fb}, {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, 
            {0xffd2, 0xffd7}, {0xffda, 0xffdc}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass117()
{
    // Name = Ethiopic, number of codePoints: 523
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1258, 0x12c0}),
        std::initializer_list<CharacterRange>({{0x1200, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x125a, 0x125d}, 
            {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, 
            {0x12b8, 0x12be}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, 
            {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x137c}, {0x1380, 0x1399}, 
            {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, 
            {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, 
            {0x2dd8, 0x2dde}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, 
            {0xab20, 0xab26}, {0xab28, 0xab2e}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, 
            {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass118()
{
    // Name = Cherokee, number of codePoints: 172
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0xab70, 0xabbf}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass119()
{
    // Name = Canadian_Aboriginal, number of codePoints: 726
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1400, 0x167f}, {0x18b0, 0x18f5}, {0x11ab0, 0x11abf}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass120()
{
    // Name = Ogham, number of codePoints: 29
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1680, 0x169c}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass121()
{
    // Name = Runic, number of codePoints: 86
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x16a0, 0x16ea}, {0x16ee, 0x16f8}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass122()
{
    // Name = Khmer, number of codePoints: 146
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1780, 0x17dd}, {0x17e0, 0x17e9}, {0x17f0, 0x17f9}, {0x19e0, 0x19ff}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass123()
{
    // Name = Mongolian, number of codePoints: 168
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1804}),
        std::initializer_list<CharacterRange>({{0x1800, 0x1801}, {0x1806, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, 
            {0x11660, 0x1166c}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass124()
{
    // Name = Hiragana, number of codePoints: 381
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1b132, 0x1f200}),
        std::initializer_list<CharacterRange>({{0x3041, 0x3096}, {0x309d, 0x309f}, {0x1b001, 0x1b11f}, {0x1b150, 0x1b152}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass125()
{
    // Name = Katakana, number of codePoints: 321
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1b000, 0x1b155}),
        std::initializer_list<CharacterRange>({{0x30a1, 0x30fa}, {0x30fd, 0x30ff}, {0x31f0, 0x31ff}, {0x32d0, 0x32fe}, 
            {0x3300, 0x3357}, {0xff66, 0xff6f}, {0xff71, 0xff9d}, {0x1aff0, 0x1aff3}, 
            {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b120, 0x1b122}, {0x1b164, 0x1b167}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass126()
{
    // Name = Bopomofo, number of codePoints: 77
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x02ea, 0x02eb}, {0x3105, 0x312f}, {0x31a0, 0x31bf}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass127()
{
    // Name = Han, number of codePoints: 103351
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x3005, 0x3007}),
        std::initializer_list<CharacterRange>({{0x2e80, 0x2e99}, {0x2e9b, 0x2ef3}, {0x2f00, 0x2fd5}, {0x3021, 0x3029}, 
            {0x3038, 0x303b}, {0x3400, 0x4dbf}, {0x4e00, 0x9fff}, {0xf900, 0xfa6d}, 
            {0xfa70, 0xfad9}, {0x16fe2, 0x16fe3}, {0x16ff0, 0x16ff6}, {0x20000, 0x2a6df}, 
            {0x2a700, 0x2b81d}, {0x2b820, 0x2cead}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, 
            {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x33479}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass128()
{
    // Name = Yi, number of codePoints: 1220
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0xa000, 0xa48c}, {0xa490, 0xa4c6}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass129()
{
    // Name = Old_Italic, number of codePoints: 39
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10300, 0x10323}, {0x1032d, 0x1032f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass130()
{
    // Name = Gothic, number of codePoints: 27
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10330, 0x1034a}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass131()
{
    // Name = Deseret, number of codePoints: 80
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10400, 0x1044f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass132()
{
    // Name = Inherited, number of codePoints: 684
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0670, 0x1ced, 0x1cf4, 0x101fd, 0x102e0, 0x1133b}),
        std::initializer_list<CharacterRange>({{0x0300, 0x036f}, {0x0485, 0x0486}, {0x064b, 0x0655}, {0x0951, 0x0954}, 
            {0x1ab0, 0x1add}, {0x1ae0, 0x1aeb}, {0x1cd0, 0x1cd2}, {0x1cd4, 0x1ce0}, 
            {0x1ce2, 0x1ce8}, {0x1cf8, 0x1cf9}, {0x1dc0, 0x1dff}, {0x200c, 0x200d}, 
            {0x20d0, 0x20f0}, {0x302a, 0x302d}, {0x3099, 0x309a}, {0xfe00, 0xfe0f}, 
            {0xfe20, 0xfe2d}, {0x1cf00, 0x1cf2d}, {0x1cf30, 0x1cf46}, {0x1d167, 0x1d169}, 
            {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0xe0100, 0xe01ef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass133()
{
    // Name = Tagalog, number of codePoints: 23
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x171f}),
        std::initializer_list<CharacterRange>({{0x1700, 0x1715}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass134()
{
    // Name = Hanunoo, number of codePoints: 21
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1720, 0x1734}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass135()
{
    // Name = Buhid, number of codePoints: 20
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1740, 0x1753}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass136()
{
    // Name = Tagbanwa, number of codePoints: 18
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass137()
{
    // Name = Limbu, number of codePoints: 68
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1940}),
        std::initializer_list<CharacterRange>({{0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x193b}, {0x1944, 0x194f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass138()
{
    // Name = Tai_Le, number of codePoints: 35
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1950, 0x196d}, {0x1970, 0x1974}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass139()
{
    // Name = Linear_B, number of codePoints: 211
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, 
            {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass140()
{
    // Name = Ugaritic, number of codePoints: 31
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1039f}),
        std::initializer_list<CharacterRange>({{0x10380, 0x1039d}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass141()
{
    // Name = Shavian, number of codePoints: 48
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10450, 0x1047f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass142()
{
    // Name = Osmanya, number of codePoints: 40
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10480, 0x1049d}, {0x104a0, 0x104a9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass143()
{
    // Name = Cypriot, number of codePoints: 55
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x10808, 0x1083c, 0x1083f}),
        std::initializer_list<CharacterRange>({{0x10800, 0x10805}, {0x1080a, 0x10835}, {0x10837, 0x10838}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass144()
{
    // Name = Braille, number of codePoints: 256
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x2800, 0x28ff}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass145()
{
    // Name = Buginese, number of codePoints: 30
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1a00, 0x1a1b}, {0x1a1e, 0x1a1f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass146()
{
    // Name = Coptic, number of codePoints: 137
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x03e2, 0x03ef}, {0x2c80, 0x2cf3}, {0x2cf9, 0x2cff}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass147()
{
    // Name = New_Tai_Lue, number of codePoints: 83
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x19de, 0x19df}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass148()
{
    // Name = Glagolitic, number of codePoints: 134
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x2c00, 0x2c5f}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, 
            {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass149()
{
    // Name = Tifinagh, number of codePoints: 59
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x2d7f}),
        std::initializer_list<CharacterRange>({{0x2d30, 0x2d67}, {0x2d6f, 0x2d70}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass150()
{
    // Name = Syloti_Nagri, number of codePoints: 45
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0xa800, 0xa82c}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass151()
{
    // Name = Old_Persian, number of codePoints: 50
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x103a0, 0x103c3}, {0x103c8, 0x103d5}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass152()
{
    // Name = Kharoshthi, number of codePoints: 68
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, 
            {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a48}, {0x10a50, 0x10a58}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass153()
{
    // Name = Balinese, number of codePoints: 127
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1b00, 0x1b4c}, {0x1b4e, 0x1b7f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass154()
{
    // Name = Cuneiform, number of codePoints: 1234
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12470, 0x12474}, {0x12480, 0x12543}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass155()
{
    // Name = Phoenician, number of codePoints: 29
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1091f}),
        std::initializer_list<CharacterRange>({{0x10900, 0x1091b}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass156()
{
    // Name = Phags_Pa, number of codePoints: 56
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0xa840, 0xa877}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass157()
{
    // Name = Nko, number of codePoints: 62
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x07c0, 0x07fa}, {0x07fd, 0x07ff}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass158()
{
    // Name = Sundanese, number of codePoints: 72
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1b80, 0x1bbf}, {0x1cc0, 0x1cc7}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass159()
{
    // Name = Lepcha, number of codePoints: 74
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1c00, 0x1c37}, {0x1c3b, 0x1c49}, {0x1c4d, 0x1c4f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass160()
{
    // Name = Ol_Chiki, number of codePoints: 48
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1c50, 0x1c7f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass161()
{
    // Name = Vai, number of codePoints: 300
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0xa500, 0xa62b}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass162()
{
    // Name = Saurashtra, number of codePoints: 82
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0xa880, 0xa8c5}, {0xa8ce, 0xa8d9}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass163()
{
    // Name = Kayah_Li, number of codePoints: 47
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0xa92f}),
        std::initializer_list<CharacterRange>({{0xa900, 0xa92d}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass164()
{
    // Name = Rejang, number of codePoints: 37
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0xa95f}),
        std::initializer_list<CharacterRange>({{0xa930, 0xa953}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass165()
{
    // Name = Lycian, number of codePoints: 29
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10280, 0x1029c}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass166()
{
    // Name = Carian, number of codePoints: 49
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x102a0, 0x102d0}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass167()
{
    // Name = Lydian, number of codePoints: 27
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1093f}),
        std::initializer_list<CharacterRange>({{0x10920, 0x10939}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass168()
{
    // Name = Cham, number of codePoints: 83
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa5c, 0xaa5f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass169()
{
    // Name = Tai_Tham, number of codePoints: 127
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1a20, 0x1a5e}, {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, 
            {0x1aa0, 0x1aad}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass170()
{
    // Name = Tai_Viet, number of codePoints: 72
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0xaa80, 0xaac2}, {0xaadb, 0xaadf}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass171()
{
    // Name = Avestan, number of codePoints: 61
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10b00, 0x10b35}, {0x10b39, 0x10b3f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass172()
{
    // Name = Egyptian_Hieroglyphs, number of codePoints: 5105
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x13000, 0x13455}, {0x13460, 0x143fa}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass173()
{
    // Name = Samaritan, number of codePoints: 61
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0800, 0x082d}, {0x0830, 0x083e}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass174()
{
    // Name = Lisu, number of codePoints: 49
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x11fb0}),
        std::initializer_list<CharacterRange>({{0xa4d0, 0xa4ff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass175()
{
    // Name = Bamum, number of codePoints: 657
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0xa6a0, 0xa6f7}, {0x16800, 0x16a38}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass176()
{
    // Name = Javanese, number of codePoints: 90
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0xa980, 0xa9cd}, {0xa9d0, 0xa9d9}, {0xa9de, 0xa9df}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass177()
{
    // Name = Meetei_Mayek, number of codePoints: 79
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0xaae0, 0xaaf6}, {0xabc0, 0xabed}, {0xabf0, 0xabf9}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass178()
{
    // Name = Imperial_Aramaic, number of codePoints: 31
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10840, 0x10855}, {0x10857, 0x1085f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass179()
{
    // Name = Old_South_Arabian, number of codePoints: 32
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10a60, 0x10a7f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass180()
{
    // Name = Inscriptional_Parthian, number of codePoints: 30
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10b40, 0x10b55}, {0x10b58, 0x10b5f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass181()
{
    // Name = Inscriptional_Pahlavi, number of codePoints: 27
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10b60, 0x10b72}, {0x10b78, 0x10b7f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass182()
{
    // Name = Old_Turkic, number of codePoints: 73
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10c00, 0x10c48}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass183()
{
    // Name = Kaithi, number of codePoints: 68
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x110cd}),
        std::initializer_list<CharacterRange>({{0x11080, 0x110c2}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass184()
{
    // Name = Batak, number of codePoints: 56
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1bc0, 0x1bf3}, {0x1bfc, 0x1bff}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass185()
{
    // Name = Brahmi, number of codePoints: 115
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1107f}),
        std::initializer_list<CharacterRange>({{0x11000, 0x1104d}, {0x11052, 0x11075}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass186()
{
    // Name = Mandaic, number of codePoints: 29
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x085e}),
        std::initializer_list<CharacterRange>({{0x0840, 0x085b}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass187()
{
    // Name = Chakma, number of codePoints: 71
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11100, 0x11134}, {0x11136, 0x11147}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass188()
{
    // Name = Meroitic_Cursive, number of codePoints: 90
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x109a0, 0x109b7}, {0x109bc, 0x109cf}, {0x109d2, 0x109ff}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass189()
{
    // Name = Meroitic_Hieroglyphs, number of codePoints: 32
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10980, 0x1099f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass190()
{
    // Name = Miao, number of codePoints: 149
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass191()
{
    // Name = Sharada, number of codePoints: 104
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11180, 0x111df}, {0x11b60, 0x11b67}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass192()
{
    // Name = Sora_Sompeng, number of codePoints: 35
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x110d0, 0x110e8}, {0x110f0, 0x110f9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass193()
{
    // Name = Takri, number of codePoints: 68
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11680, 0x116b9}, {0x116c0, 0x116c9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass194()
{
    // Name = Caucasian_Albanian, number of codePoints: 53
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1056f}),
        std::initializer_list<CharacterRange>({{0x10530, 0x10563}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass195()
{
    // Name = Bassa_Vah, number of codePoints: 36
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x16ad0, 0x16aed}, {0x16af0, 0x16af5}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass196()
{
    // Name = Duployan, number of codePoints: 143
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, 
            {0x1bc9c, 0x1bc9f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass197()
{
    // Name = Elbasan, number of codePoints: 40
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10500, 0x10527}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass198()
{
    // Name = Grantha, number of codePoints: 85
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x11350, 0x11357}),
        std::initializer_list<CharacterRange>({{0x11300, 0x11303}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, 
            {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133c, 0x11344}, 
            {0x11347, 0x11348}, {0x1134b, 0x1134d}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, 
            {0x11370, 0x11374}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass199()
{
    // Name = Pahawh_Hmong, number of codePoints: 127
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x16b00, 0x16b45}, {0x16b50, 0x16b59}, {0x16b5b, 0x16b61}, {0x16b63, 0x16b77}, 
            {0x16b7d, 0x16b8f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass200()
{
    // Name = Khojki, number of codePoints: 65
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11200, 0x11211}, {0x11213, 0x11241}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass201()
{
    // Name = Linear_A, number of codePoints: 341
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass202()
{
    // Name = Mahajani, number of codePoints: 39
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11150, 0x11176}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass203()
{
    // Name = Manichaean, number of codePoints: 51
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10ac0, 0x10ae6}, {0x10aeb, 0x10af6}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass204()
{
    // Name = Mende_Kikakui, number of codePoints: 213
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1e800, 0x1e8c4}, {0x1e8c7, 0x1e8d6}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass205()
{
    // Name = Modi, number of codePoints: 79
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11600, 0x11644}, {0x11650, 0x11659}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass206()
{
    // Name = Mro, number of codePoints: 43
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a6e, 0x16a6f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass207()
{
    // Name = Old_North_Arabian, number of codePoints: 32
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10a80, 0x10a9f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass208()
{
    // Name = Nabataean, number of codePoints: 40
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10880, 0x1089e}, {0x108a7, 0x108af}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass209()
{
    // Name = Palmyrene, number of codePoints: 32
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10860, 0x1087f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass210()
{
    // Name = Pau_Cin_Hau, number of codePoints: 57
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11ac0, 0x11af8}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass211()
{
    // Name = Old_Permic, number of codePoints: 43
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10350, 0x1037a}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass212()
{
    // Name = Psalter_Pahlavi, number of codePoints: 29
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10b80, 0x10b91}, {0x10b99, 0x10b9c}, {0x10ba9, 0x10baf}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass213()
{
    // Name = Siddham, number of codePoints: 92
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11580, 0x115b5}, {0x115b8, 0x115dd}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass214()
{
    // Name = Khudawadi, number of codePoints: 69
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x112b0, 0x112ea}, {0x112f0, 0x112f9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass215()
{
    // Name = Tirhuta, number of codePoints: 82
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11480, 0x114c7}, {0x114d0, 0x114d9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass216()
{
    // Name = Warang_Citi, number of codePoints: 84
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x118ff}),
        std::initializer_list<CharacterRange>({{0x118a0, 0x118f2}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass217()
{
    // Name = Ahom, number of codePoints: 65
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11746}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass218()
{
    // Name = Anatolian_Hieroglyphs, number of codePoints: 583
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x14400, 0x14646}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass219()
{
    // Name = Hatran, number of codePoints: 26
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x108fb, 0x108ff}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass220()
{
    // Name = Multani, number of codePoints: 38
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x11288}),
        std::initializer_list<CharacterRange>({{0x11280, 0x11286}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass221()
{
    // Name = Old_Hungarian, number of codePoints: 108
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10cfa, 0x10cff}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass222()
{
    // Name = SignWriting, number of codePoints: 672
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1d800, 0x1da8b}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass223()
{
    // Name = Adlam, number of codePoints: 88
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1e95e, 0x1e95f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass224()
{
    // Name = Bhaiksuki, number of codePoints: 97
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c45}, {0x11c50, 0x11c6c}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass225()
{
    // Name = Marchen, number of codePoints: 68
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11c70, 0x11c8f}, {0x11c92, 0x11ca7}, {0x11ca9, 0x11cb6}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass226()
{
    // Name = Newa, number of codePoints: 97
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11400, 0x1145b}, {0x1145d, 0x11461}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass227()
{
    // Name = Osage, number of codePoints: 72
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x104b0, 0x104d3}, {0x104d8, 0x104fb}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass228()
{
    // Name = Tangut, number of codePoints: 7059
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x16fe0}),
        std::initializer_list<CharacterRange>({{0x17000, 0x18aff}, {0x18d00, 0x18d1e}, {0x18d80, 0x18df2}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass229()
{
    // Name = Masaram_Gondi, number of codePoints: 75
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x11d3a}),
        std::initializer_list<CharacterRange>({{0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3c, 0x11d3d}, 
            {0x11d3f, 0x11d47}, {0x11d50, 0x11d59}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass230()
{
    // Name = Nushu, number of codePoints: 397
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x16fe1}),
        std::initializer_list<CharacterRange>({{0x1b170, 0x1b2fb}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass231()
{
    // Name = Soyombo, number of codePoints: 83
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11a50, 0x11aa2}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass232()
{
    // Name = Zanabazar_Square, number of codePoints: 72
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11a00, 0x11a47}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass233()
{
    // Name = Dogra, number of codePoints: 60
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11800, 0x1183b}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass234()
{
    // Name = Gunjala_Gondi, number of codePoints: 63
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, 
            {0x11d93, 0x11d98}, {0x11da0, 0x11da9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass235()
{
    // Name = Makasar, number of codePoints: 25
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11ee0, 0x11ef8}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass236()
{
    // Name = Medefaidrin, number of codePoints: 91
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x16e40, 0x16e9a}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass237()
{
    // Name = Hanifi_Rohingya, number of codePoints: 50
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10d00, 0x10d27}, {0x10d30, 0x10d39}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass238()
{
    // Name = Sogdian, number of codePoints: 42
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10f30, 0x10f59}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass239()
{
    // Name = Old_Sogdian, number of codePoints: 40
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10f00, 0x10f27}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass240()
{
    // Name = Elymaic, number of codePoints: 23
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10fe0, 0x10ff6}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass241()
{
    // Name = Nandinagari, number of codePoints: 65
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x119a0, 0x119a7}, {0x119aa, 0x119d7}, {0x119da, 0x119e4}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass242()
{
    // Name = Nyiakeng_Puachue_Hmong, number of codePoints: 71
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1e100, 0x1e12c}, {0x1e130, 0x1e13d}, {0x1e140, 0x1e149}, {0x1e14e, 0x1e14f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass243()
{
    // Name = Wancho, number of codePoints: 59
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1e2ff}),
        std::initializer_list<CharacterRange>({{0x1e2c0, 0x1e2f9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass244()
{
    // Name = Chorasmian, number of codePoints: 28
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10fb0, 0x10fcb}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass245()
{
    // Name = Dives_Akuru, number of codePoints: 72
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x11909}),
        std::initializer_list<CharacterRange>({{0x11900, 0x11906}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, 
            {0x11937, 0x11938}, {0x1193b, 0x11946}, {0x11950, 0x11959}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass246()
{
    // Name = Khitan_Small_Script, number of codePoints: 472
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x16fe4, 0x18cff}),
        std::initializer_list<CharacterRange>({{0x18b00, 0x18cd5}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass247()
{
    // Name = Yezidi, number of codePoints: 47
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10e80, 0x10ea9}, {0x10eab, 0x10ead}, {0x10eb0, 0x10eb1}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass248()
{
    // Name = Cypro_Minoan, number of codePoints: 99
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x12f90, 0x12ff2}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass249()
{
    // Name = Old_Uyghur, number of codePoints: 26
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10f70, 0x10f89}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass250()
{
    // Name = Tangsa, number of codePoints: 89
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x16a70, 0x16abe}, {0x16ac0, 0x16ac9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass251()
{
    // Name = Toto, number of codePoints: 31
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1e290, 0x1e2ae}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass252()
{
    // Name = Vithkuqi, number of codePoints: 70
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, 
            {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass253()
{
    // Name = Kawi, number of codePoints: 87
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11f00, 0x11f10}, {0x11f12, 0x11f3a}, {0x11f3e, 0x11f5a}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass254()
{
    // Name = Nag_Mundari, number of codePoints: 42
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1e4d0, 0x1e4f9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass255()
{
    // Name = Garay, number of codePoints: 69
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10d40, 0x10d65}, {0x10d69, 0x10d85}, {0x10d8e, 0x10d8f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass256()
{
    // Name = Gurung_Khema, number of codePoints: 58
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x16100, 0x16139}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass257()
{
    // Name = Kirat_Rai, number of codePoints: 58
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x16d40, 0x16d79}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass258()
{
    // Name = Ol_Onal, number of codePoints: 44
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1e5ff}),
        std::initializer_list<CharacterRange>({{0x1e5d0, 0x1e5fa}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass259()
{
    // Name = Sunuwar, number of codePoints: 44
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11bc0, 0x11be1}, {0x11bf0, 0x11bf9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass260()
{
    // Name = Todhri, number of codePoints: 52
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x105c0, 0x105f3}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass261()
{
    // Name = Tulu_Tigalari, number of codePoints: 80
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1138b, 0x1138e, 0x113c2, 0x113c5}),
        std::initializer_list<CharacterRange>({{0x11380, 0x11389}, {0x11390, 0x113b5}, {0x113b7, 0x113c0}, {0x113c7, 0x113ca}, 
            {0x113cc, 0x113d5}, {0x113d7, 0x113d8}, {0x113e1, 0x113e2}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass262()
{
    // Name = Chisoi, number of codePoints: 40
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x16d80, 0x16d9d}, {0x16da0, 0x16da9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass263()
{
    // Name = Sidetic, number of codePoints: 26
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10940, 0x10959}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass264()
{
    // Name = Tai_Yo, number of codePoints: 55
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1e6c0, 0x1e6de}, {0x1e6e0, 0x1e6f5}, {0x1e6fe, 0x1e6ff}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass265()
{
    // Name = Tolong_Siki, number of codePoints: 54
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x11db0, 0x11ddb}, {0x11de0, 0x11de9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass266()
{
    // Name = Beria_Erfe, number of codePoints: 50
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x16ea0, 0x16eb8}, {0x16ebb, 0x16ed3}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass267()
{
    // Name = Common, number of codePoints: 8689
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x00, 0x40}, {0x5b, 0x60}, {0x7b, 0x7f}}),
        std::initializer_list<char32_t>({0x00d7, 0x00f7, 0x02c8, 0x02cc, 0x02d8, 0x037e, 0x0385, 0x0387, 
            0x0605, 0x06dd, 0x08e2, 0x0e3f, 0x2e42, 0x3000, 0x3004, 0x3012, 
            0x3020, 0x3036, 0x327f, 0x33ff, 0xab5b, 0xfeff, 0x1d4a2, 0x1d4bb, 
            0x1d546, 0x1f7f0, 0x1fac8, 0xe0001}),
        std::initializer_list<CharacterRange>({{0x0080, 0x00a9}, {0x00ab, 0x00b6}, {0x00b8, 0x00b9}, {0x00bb, 0x00bf}, 
            {0x02b9, 0x02bb}, {0x02bd, 0x02c6}, {0x02ce, 0x02d6}, {0x02da, 0x02df}, 
            {0x02e5, 0x02e9}, {0x02ec, 0x02ff}, {0x0fd5, 0x0fd8}, {0x2000, 0x200b}, 
            {0x200e, 0x202e}, {0x2030, 0x204e}, {0x2050, 0x2059}, {0x205b, 0x205c}, 
            {0x205e, 0x2064}, {0x2066, 0x2070}, {0x2074, 0x207e}, {0x2080, 0x208e}, 
            {0x20a0, 0x20c1}, {0x2100, 0x2125}, {0x2127, 0x2129}, {0x212c, 0x2131}, 
            {0x2133, 0x214d}, {0x214f, 0x215f}, {0x2189, 0x218b}, {0x2190, 0x2429}, 
            {0x2440, 0x244a}, {0x2460, 0x27ff}, {0x2900, 0x2b73}, {0x2b76, 0x2bff}, 
            {0x2e00, 0x2e16}, {0x2e18, 0x2e2f}, {0x2e32, 0x2e3b}, {0x2e3d, 0x2e40}, 
            {0x2e44, 0x2e5d}, {0x3248, 0x325f}, {0x32b1, 0x32bf}, {0x32cc, 0x32cf}, 
            {0x3371, 0x337a}, {0x3380, 0x33df}, {0x4dc0, 0x4dff}, {0xa708, 0xa721}, 
            {0xa788, 0xa78a}, {0xab6a, 0xab6b}, {0xfe10, 0xfe19}, {0xfe30, 0xfe44}, 
            {0xfe47, 0xfe52}, {0xfe54, 0xfe66}, {0xfe68, 0xfe6b}, {0xff01, 0xff20}, 
            {0xff3b, 0xff40}, {0xff5b, 0xff60}, {0xffe0, 0xffe6}, {0xffe8, 0xffee}, 
            {0xfff9, 0xfffd}, {0x10190, 0x1019c}, {0x101d0, 0x101fc}, {0x1cc00, 0x1ccfc}, 
            {0x1cd00, 0x1ceb3}, {0x1ceba, 0x1ced0}, {0x1cee0, 0x1cef0}, {0x1cf50, 0x1cfc3}, 
            {0x1d000, 0x1d0f5}, {0x1d100, 0x1d126}, {0x1d129, 0x1d166}, {0x1d16a, 0x1d17a}, 
            {0x1d183, 0x1d184}, {0x1d18c, 0x1d1a9}, {0x1d1ae, 0x1d1ea}, {0x1d2c0, 0x1d2d3}, 
            {0x1d2e0, 0x1d2f3}, {0x1d300, 0x1d356}, {0x1d372, 0x1d378}, {0x1d400, 0x1d454}, 
            {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, 
            {0x1d4ae, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, 
            {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, 
            {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d7cb}, 
            {0x1d7ce, 0x1d7ff}, {0x1ec71, 0x1ecb4}, {0x1ed01, 0x1ed3d}, {0x1f000, 0x1f02b}, 
            {0x1f030, 0x1f093}, {0x1f0a0, 0x1f0ae}, {0x1f0b1, 0x1f0bf}, {0x1f0c1, 0x1f0cf}, 
            {0x1f0d1, 0x1f0f5}, {0x1f100, 0x1f1ad}, {0x1f1e6, 0x1f1ff}, {0x1f201, 0x1f202}, 
            {0x1f210, 0x1f23b}, {0x1f240, 0x1f248}, {0x1f260, 0x1f265}, {0x1f300, 0x1f6d8}, 
            {0x1f6dc, 0x1f6ec}, {0x1f6f0, 0x1f6fc}, {0x1f700, 0x1f7d9}, {0x1f7e0, 0x1f7eb}, 
            {0x1f800, 0x1f80b}, {0x1f810, 0x1f847}, {0x1f850, 0x1f859}, {0x1f860, 0x1f887}, 
            {0x1f890, 0x1f8ad}, {0x1f8b0, 0x1f8bb}, {0x1f8c0, 0x1f8c1}, {0x1f8d0, 0x1f8d8}, 
            {0x1f900, 0x1fa57}, {0x1fa60, 0x1fa6d}, {0x1fa70, 0x1fa7c}, {0x1fa80, 0x1fa8a}, 
            {0x1fa8e, 0x1fac6}, {0x1facd, 0x1fadd}, {0x1fadf, 0x1faea}, {0x1faef, 0x1faf8}, 
            {0x1fb00, 0x1fb92}, {0x1fb94, 0x1fbfa}, {0xe0020, 0xe007f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass268()
{
    // Name = Inherited, number of codePoints: 598
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x030f, 0x0312, 0x032f, 0x1df9, 0x101fd}),
        std::initializer_list<CharacterRange>({{0x0314, 0x031f}, {0x0321, 0x0322}, {0x0326, 0x032c}, {0x0332, 0x0341}, 
            {0x0343, 0x0344}, {0x0346, 0x0357}, {0x0359, 0x035d}, {0x035f, 0x0362}, 
            {0x0953, 0x0954}, {0x1ab0, 0x1add}, {0x1ae0, 0x1aeb}, {0x1dc2, 0x1df7}, 
            {0x1dfb, 0x1dff}, {0x200c, 0x200d}, {0x20d0, 0x20ef}, {0xfe00, 0xfe0f}, 
            {0xfe20, 0xfe2d}, {0x1cf00, 0x1cf2d}, {0x1cf30, 0x1cf46}, {0x1d167, 0x1d169}, 
            {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0xe0100, 0xe01ef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass269()
{
    // Name = Avestan, number of codePoints: 64
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00b7}),
        std::initializer_list<CharacterRange>({{0x2e30, 0x2e31}, {0x10b00, 0x10b35}, {0x10b39, 0x10b3f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass270()
{
    // Name = Carian, number of codePoints: 53
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00b7, 0x205a, 0x205d, 0x2e31}),
        std::initializer_list<CharacterRange>({{0x102a0, 0x102d0}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass271()
{
    // Name = Coptic, number of codePoints: 173
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00b7, 0x0300, 0x0307, 0x2e17}),
        std::initializer_list<CharacterRange>({{0x0304, 0x0305}, {0x0374, 0x0375}, {0x03e2, 0x03ef}, {0x2c80, 0x2cf3}, 
            {0x2cf9, 0x2cff}, {0x102e0, 0x102fb}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass272()
{
    // Name = Duployan, number of codePoints: 154
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00b7, 0x030a, 0x2e3c}),
        std::initializer_list<CharacterRange>({{0x0307, 0x0308}, {0x0323, 0x0324}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, 
            {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1bc9c, 0x1bca3}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass273()
{
    // Name = Elbasan, number of codePoints: 42
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00b7, 0x0305}),
        std::initializer_list<CharacterRange>({{0x10500, 0x10527}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass274()
{
    // Name = Georgian, number of codePoints: 178
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00b7, 0x0589, 0x10c7, 0x10cd, 0x205a, 0x2d27, 0x2d2d, 0x2e31}),
        std::initializer_list<CharacterRange>({{0x10a0, 0x10c5}, {0x10d0, 0x10ff}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, 
            {0x2d00, 0x2d25}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass275()
{
    // Name = Glagolitic, number of codePoints: 144
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00b7, 0x0303, 0x0305, 0x0484, 0x0487, 0x0589, 0x10fb, 0x205a, 
            0x2e43, 0xa66f}),
        std::initializer_list<CharacterRange>({{0x2c00, 0x2c5f}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, 
            {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass276()
{
    // Name = Gunjala_Gondi, number of codePoints: 66
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00b7}),
        std::initializer_list<CharacterRange>({{0x0964, 0x0965}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, 
            {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass277()
{
    // Name = Gothic, number of codePoints: 32
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00b7, 0x0308, 0x0331}),
        std::initializer_list<CharacterRange>({{0x0304, 0x0305}, {0x10330, 0x1034a}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass278()
{
    // Name = Greek, number of codePoints: 531
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00b7, 0x0304, 0x0306, 0x0308, 0x0313, 0x0342, 0x0345, 0x037f, 
            0x0384, 0x0386, 0x038c, 0x1f59, 0x1f5b, 0x1f5d, 0x205d, 0x2126, 
            0xab65, 0x101a0}),
        std::initializer_list<CharacterRange>({{0x0300, 0x0301}, {0x0370, 0x0377}, {0x037a, 0x037d}, {0x0388, 0x038a}, 
            {0x038e, 0x03a1}, {0x03a3, 0x03e1}, {0x03f0, 0x03ff}, {0x1d26, 0x1d2a}, 
            {0x1d5d, 0x1d61}, {0x1d66, 0x1d6a}, {0x1dbf, 0x1dc1}, {0x1f00, 0x1f15}, 
            {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, 
            {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fc4}, {0x1fc6, 0x1fd3}, 
            {0x1fd6, 0x1fdb}, {0x1fdd, 0x1fef}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffe}, 
            {0x10140, 0x1018e}, {0x1d200, 0x1d245}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass279()
{
    // Name = Han, number of codePoints: 103659
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00b7, 0x3030, 0x30fb, 0x31ef, 0x32ff}),
        std::initializer_list<CharacterRange>({{0x2e80, 0x2e99}, {0x2e9b, 0x2ef3}, {0x2f00, 0x2fd5}, {0x2ff0, 0x2fff}, 
            {0x3001, 0x3003}, {0x3005, 0x3011}, {0x3013, 0x301f}, {0x3021, 0x302d}, 
            {0x3037, 0x303f}, {0x3190, 0x319f}, {0x31c0, 0x31e5}, {0x3220, 0x3247}, 
            {0x3280, 0x32b0}, {0x32c0, 0x32cb}, {0x3358, 0x3370}, {0x337b, 0x337f}, 
            {0x33e0, 0x33fe}, {0x3400, 0x4dbf}, {0x4e00, 0x9fff}, {0xa700, 0xa707}, 
            {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfe45, 0xfe46}, {0xff61, 0xff65}, 
            {0x16fe2, 0x16fe3}, {0x16ff0, 0x16ff6}, {0x1d360, 0x1d371}, {0x1f250, 0x1f251}, 
            {0x20000, 0x2a6df}, {0x2a700, 0x2b81d}, {0x2b820, 0x2cead}, {0x2ceb0, 0x2ebe0}, 
            {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x33479}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass280()
{
    // Name = Latin, number of codePoints: 1560
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<char32_t>({0x00aa, 0x00b7, 0x00ba, 0x02bc, 0x02c7, 0x02cd, 0x02d7, 0x02d9, 
            0x0313, 0x0320, 0x0358, 0x035e, 0x10fb, 0x1df8, 0x202f, 0x2071, 
            0x207f, 0x20f0, 0x2132, 0x214e, 0x2e17, 0xa92e}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x02b8}, {0x02c9, 0x02cb}, 
            {0x02e0, 0x02e4}, {0x0300, 0x030e}, {0x0310, 0x0311}, {0x0323, 0x0325}, 
            {0x032d, 0x032e}, {0x0330, 0x0331}, {0x0363, 0x036f}, {0x0485, 0x0486}, 
            {0x0951, 0x0952}, {0x1d00, 0x1d25}, {0x1d2c, 0x1d5c}, {0x1d62, 0x1d65}, 
            {0x1d6b, 0x1d77}, {0x1d79, 0x1dbe}, {0x1e00, 0x1eff}, {0x2090, 0x209c}, 
            {0x212a, 0x212b}, {0x2160, 0x2188}, {0x2c60, 0x2c7f}, {0xa700, 0xa707}, 
            {0xa722, 0xa787}, {0xa78b, 0xa7dc}, {0xa7f1, 0xa7ff}, {0xab30, 0xab5a}, 
            {0xab5c, 0xab64}, {0xab66, 0xab69}, {0xfb00, 0xfb06}, {0xff21, 0xff3a}, 
            {0xff41, 0xff5a}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, 
            {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass281()
{
    // Name = Lydian, number of codePoints: 29
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00b7, 0x2e31, 0x1093f}),
        std::initializer_list<CharacterRange>({{0x10920, 0x10939}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass282()
{
    // Name = Mahajani, number of codePoints: 62
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00b7}),
        std::initializer_list<CharacterRange>({{0x0964, 0x096f}, {0xa830, 0xa839}, {0x11150, 0x11176}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass283()
{
    // Name = Old_Permic, number of codePoints: 50
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00b7, 0x0300, 0x0313, 0x0483}),
        std::initializer_list<CharacterRange>({{0x0306, 0x0308}, {0x10350, 0x1037a}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass284()
{
    // Name = Shavian, number of codePoints: 49
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x00b7}),
        std::initializer_list<CharacterRange>({{0x10450, 0x1047f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass285()
{
    // Name = Bengali, number of codePoints: 115
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x02bc, 0x09b2, 0x09d7, 0x1cd0, 0x1cd2, 0x1cd8, 0x1ce1, 0x1cea, 
            0x1ced, 0x1cf2, 0xa8f1}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0x0980, 0x0983}, {0x0985, 0x098c}, 
            {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0}, {0x09b6, 0x09b9}, 
            {0x09bc, 0x09c4}, {0x09c7, 0x09c8}, {0x09cb, 0x09ce}, {0x09dc, 0x09dd}, 
            {0x09df, 0x09e3}, {0x09e6, 0x09ff}, {0x1cd5, 0x1cd6}, {0x1cf5, 0x1cf7}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass286()
{
    // Name = Cyrillic, number of codePoints: 521
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x02bc, 0x0304, 0x0306, 0x0308, 0x030b, 0x0311, 0x1d2b, 0x1d78, 
            0x1df8, 0x2e43, 0x1e08f}),
        std::initializer_list<CharacterRange>({{0x0300, 0x0302}, {0x0400, 0x052f}, {0x1c80, 0x1c8a}, {0x2de0, 0x2dff}, 
            {0xa640, 0xa69f}, {0xfe2e, 0xfe2f}, {0x1e030, 0x1e06d}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass287()
{
    // Name = Devanagari, number of codePoints: 221
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x02bc, 0x20f0}),
        std::initializer_list<CharacterRange>({{0x0900, 0x0952}, {0x0955, 0x097f}, {0x1cd0, 0x1cf6}, {0x1cf8, 0x1cf9}, 
            {0xa830, 0xa839}, {0xa8e0, 0xa8ff}, {0x11b00, 0x11b09}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass288()
{
    // Name = Lisu, number of codePoints: 53
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x02bc, 0x02cd, 0x11fb0}),
        std::initializer_list<CharacterRange>({{0x300a, 0x300b}, {0xa4d0, 0xa4ff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass289()
{
    // Name = Thai, number of codePoints: 90
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x02bc, 0x02d7, 0x0303, 0x0331}),
        std::initializer_list<CharacterRange>({{0x0e01, 0x0e3a}, {0x0e40, 0x0e5b}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass290()
{
    // Name = Toto, number of codePoints: 32
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x02bc}),
        std::initializer_list<CharacterRange>({{0x1e290, 0x1e2ae}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass291()
{
    // Name = Bopomofo, number of codePoints: 122
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x02c7, 0x02d9, 0x3030, 0x3037, 0x30fb}),
        std::initializer_list<CharacterRange>({{0x02c9, 0x02cb}, {0x02ea, 0x02eb}, {0x3001, 0x3003}, {0x3008, 0x3011}, 
            {0x3013, 0x301f}, {0x302a, 0x302d}, {0x3105, 0x312f}, {0x31a0, 0x31bf}, 
            {0xfe45, 0xfe46}, {0xff61, 0xff65}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass292()
{
    // Name = Cherokee, number of codePoints: 182
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0304}),
        std::initializer_list<CharacterRange>({{0x0300, 0x0302}, {0x030b, 0x030c}, {0x0323, 0x0324}, {0x0330, 0x0331}, 
            {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0xab70, 0xabbf}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass293()
{
    // Name = Sunuwar, number of codePoints: 51
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0303, 0x030d, 0x0310, 0x032d, 0x0331}),
        std::initializer_list<CharacterRange>({{0x0300, 0x0301}, {0x11bc0, 0x11be1}, {0x11bf0, 0x11bf9}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass294()
{
    // Name = Tai_Le, number of codePoints: 50
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x030c}),
        std::initializer_list<CharacterRange>({{0x0300, 0x0301}, {0x0307, 0x0308}, {0x1040, 0x1049}, {0x1950, 0x196d}, 
            {0x1970, 0x1974}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass295()
{
    // Name = Osage, number of codePoints: 76
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0301, 0x0304, 0x030b, 0x0358}),
        std::initializer_list<CharacterRange>({{0x104b0, 0x104d3}, {0x104d8, 0x104fb}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass296()
{
    // Name = Todhri, number of codePoints: 58
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0301, 0x0304, 0x0307, 0x0311, 0x0313, 0x035e}),
        std::initializer_list<CharacterRange>({{0x105c0, 0x105f3}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass297()
{
    // Name = Tifinagh, number of codePoints: 66
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0302, 0x0304, 0x0323, 0x2d7f}),
        std::initializer_list<CharacterRange>({{0x0306, 0x0309}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d70}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass298()
{
    // Name = Syriac, number of codePoints: 119
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x030a, 0x0320, 0x0330, 0x060c, 0x061f, 0x0640, 0x0670, 0x1df8, 
            0x1dfa}),
        std::initializer_list<CharacterRange>({{0x0303, 0x0304}, {0x0307, 0x0308}, {0x0323, 0x0325}, {0x032d, 0x032e}, 
            {0x061b, 0x061c}, {0x064b, 0x0655}, {0x0700, 0x070d}, {0x070f, 0x074a}, 
            {0x074d, 0x074f}, {0x0860, 0x086a}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass299()
{
    // Name = Caucasian_Albanian, number of codePoints: 56
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0304, 0x0331, 0x035e, 0x1056f}),
        std::initializer_list<CharacterRange>({{0x10530, 0x10563}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass300()
{
    // Name = Katakana, number of codePoints: 375
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0305, 0x0323, 0x3037, 0x1b000, 0x1b155}),
        std::initializer_list<CharacterRange>({{0x3001, 0x3003}, {0x3008, 0x3011}, {0x3013, 0x301f}, {0x3030, 0x3035}, 
            {0x303c, 0x303d}, {0x3099, 0x309c}, {0x30a0, 0x30ff}, {0x31f0, 0x31ff}, 
            {0x32d0, 0x32fe}, {0x3300, 0x3357}, {0xfe45, 0xfe46}, {0xff61, 0xff9f}, 
            {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b120, 0x1b122}, 
            {0x1b164, 0x1b167}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass301()
{
    // Name = Hebrew, number of codePoints: 136
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0xfb3e}),
        std::initializer_list<CharacterRange>({{0x0307, 0x0308}, {0x0591, 0x05c7}, {0x05d0, 0x05ea}, {0x05ef, 0x05f4}, 
            {0xfb1d, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, 
            {0xfb46, 0xfb4f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass302()
{
    // Name = Armenian, number of codePoints: 97
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0308}),
        std::initializer_list<CharacterRange>({{0x0531, 0x0556}, {0x0559, 0x058a}, {0x058d, 0x058f}, {0xfb13, 0xfb17}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass303()
{
    // Name = Ethiopic, number of codePoints: 524
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x030e, 0x1258, 0x12c0}),
        std::initializer_list<CharacterRange>({{0x1200, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x125a, 0x125d}, 
            {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, 
            {0x12b8, 0x12be}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, 
            {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x137c}, {0x1380, 0x1399}, 
            {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, 
            {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, 
            {0x2dd8, 0x2dde}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, 
            {0xab20, 0xab26}, {0xab28, 0xab2e}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, 
            {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass304()
{
    // Name = Arabic, number of codePoints: 1461
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x204f, 0x2e41, 0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 0x1ee42, 0x1ee47, 
            0x1ee49, 0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 0x1ee5d, 0x1ee5f, 
            0x1ee64, 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x0600, 0x0604}, {0x0606, 0x06dc}, {0x06de, 0x06ff}, {0x0750, 0x077f}, 
            {0x0870, 0x0891}, {0x0897, 0x08e1}, {0x08e3, 0x08ff}, {0xfb50, 0xfdcf}, 
            {0xfdf0, 0xfdff}, {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, {0x102e0, 0x102fb}, 
            {0x10e60, 0x10e7e}, {0x10ec2, 0x10ec7}, {0x10ed0, 0x10ed8}, {0x10efa, 0x10eff}, 
            {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, 
            {0x1ee34, 0x1ee37}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, 
            {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, 
            {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, 
            {0x1eeab, 0x1eebb}, {0x1eef0, 0x1eef1}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass305()
{
    // Name = Garay, number of codePoints: 72
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x060c, 0x061b, 0x061f}),
        std::initializer_list<CharacterRange>({{0x10d40, 0x10d65}, {0x10d69, 0x10d85}, {0x10d8e, 0x10d8f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass306()
{
    // Name = Nko, number of codePoints: 67
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x060c, 0x061b, 0x061f}),
        std::initializer_list<CharacterRange>({{0x07c0, 0x07fa}, {0x07fd, 0x07ff}, {0xfd3e, 0xfd3f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass307()
{
    // Name = Hanifi_Rohingya, number of codePoints: 55
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x060c, 0x061b, 0x061f, 0x0640, 0x06d4}),
        std::initializer_list<CharacterRange>({{0x10d00, 0x10d27}, {0x10d30, 0x10d39}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass308()
{
    // Name = Thaana, number of codePoints: 66
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x060c, 0x061f, 0xfdf2, 0xfdfd}),
        std::initializer_list<CharacterRange>({{0x061b, 0x061c}, {0x0660, 0x0669}, {0x0780, 0x07b1}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass309()
{
    // Name = Yezidi, number of codePoints: 60
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x060c, 0x061b, 0x061f}),
        std::initializer_list<CharacterRange>({{0x0660, 0x0669}, {0x10e80, 0x10ea9}, {0x10eab, 0x10ead}, {0x10eb0, 0x10eb1}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass310()
{
    // Name = Adlam, number of codePoints: 92
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x061f, 0x0640, 0x204f, 0x2e41}),
        std::initializer_list<CharacterRange>({{0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1e95e, 0x1e95f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass311()
{
    // Name = Mandaic, number of codePoints: 30
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0640, 0x085e}),
        std::initializer_list<CharacterRange>({{0x0840, 0x085b}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass312()
{
    // Name = Manichaean, number of codePoints: 52
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0640}),
        std::initializer_list<CharacterRange>({{0x10ac0, 0x10ae6}, {0x10aeb, 0x10af6}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass313()
{
    // Name = Old_Uyghur, number of codePoints: 28
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0640, 0x10af2}),
        std::initializer_list<CharacterRange>({{0x10f70, 0x10f89}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass314()
{
    // Name = Psalter_Pahlavi, number of codePoints: 30
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0640}),
        std::initializer_list<CharacterRange>({{0x10b80, 0x10b91}, {0x10b99, 0x10b9c}, {0x10ba9, 0x10baf}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass315()
{
    // Name = Sogdian, number of codePoints: 43
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0640}),
        std::initializer_list<CharacterRange>({{0x10f30, 0x10f59}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass316()
{
    // Name = Grantha, number of codePoints: 116
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1cd0, 0x20f0, 0x11350, 0x11357, 0x11fd3}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0x0be6, 0x0bf3}, {0x1cd2, 0x1cd3}, 
            {0x1cf2, 0x1cf4}, {0x1cf8, 0x1cf9}, {0x11300, 0x11303}, {0x11305, 0x1130c}, 
            {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, 
            {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d}, 
            {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11fd0, 0x11fd1}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass317()
{
    // Name = Gujarati, number of codePoints: 105
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0ad0}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0x0a81, 0x0a83}, {0x0a85, 0x0a8d}, 
            {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0}, {0x0ab2, 0x0ab3}, 
            {0x0ab5, 0x0ab9}, {0x0abc, 0x0ac5}, {0x0ac7, 0x0ac9}, {0x0acb, 0x0acd}, 
            {0x0ae0, 0x0ae3}, {0x0ae6, 0x0af1}, {0x0af9, 0x0aff}, {0xa830, 0xa839}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass318()
{
    // Name = Gurmukhi, number of codePoints: 94
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0a3c, 0x0a51, 0x0a5e}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0x0a01, 0x0a03}, {0x0a05, 0x0a0a}, 
            {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, 
            {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a3e, 0x0a42}, {0x0a47, 0x0a48}, 
            {0x0a4b, 0x0a4d}, {0x0a59, 0x0a5c}, {0x0a66, 0x0a76}, {0xa830, 0xa839}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass319()
{
    // Name = Kannada, number of codePoints: 108
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1cd0, 0x1cda, 0x1cf2, 0x1cf4}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0x0c80, 0x0c8c}, {0x0c8e, 0x0c90}, 
            {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0cbc, 0x0cc4}, 
            {0x0cc6, 0x0cc8}, {0x0cca, 0x0ccd}, {0x0cd5, 0x0cd6}, {0x0cdc, 0x0cde}, 
            {0x0ce0, 0x0ce3}, {0x0ce6, 0x0cef}, {0x0cf1, 0x0cf3}, {0x1cd2, 0x1cd3}, 
            {0xa830, 0xa835}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass320()
{
    // Name = Malayalam, number of codePoints: 127
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1cda, 0x1cf2}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0x0d00, 0x0d0c}, {0x0d0e, 0x0d10}, 
            {0x0d12, 0x0d44}, {0x0d46, 0x0d48}, {0x0d4a, 0x0d4f}, {0x0d54, 0x0d63}, 
            {0x0d66, 0x0d7f}, {0xa830, 0xa832}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass321()
{
    // Name = Oriya, number of codePoints: 99
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1cda, 0x1cf2}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0x0b01, 0x0b03}, {0x0b05, 0x0b0c}, 
            {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, 
            {0x0b35, 0x0b39}, {0x0b3c, 0x0b44}, {0x0b47, 0x0b48}, {0x0b4b, 0x0b4d}, 
            {0x0b53, 0x0b57}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b63}, {0x0b66, 0x0b77}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass322()
{
    // Name = Sharada, number of codePoints: 117
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0951, 0x1cd7, 0x1cd9, 0x1ce0, 0xa838}),
        std::initializer_list<CharacterRange>({{0x1cdc, 0x1cdd}, {0xa830, 0xa835}, {0x11180, 0x111df}, {0x11b60, 0x11b67}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass323()
{
    // Name = Tamil, number of codePoints: 133
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0b9c, 0x0bd0, 0x0bd7, 0x1cda, 0xa8f3, 0x11301, 0x11303, 0x11fff}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0x0b82, 0x0b83}, {0x0b85, 0x0b8a}, 
            {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, {0x0b9e, 0x0b9f}, 
            {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, {0x0bbe, 0x0bc2}, 
            {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcd}, {0x0be6, 0x0bfa}, {0x1133b, 0x1133c}, 
            {0x11fc0, 0x11ff1}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass324()
{
    // Name = Telugu, number of codePoints: 107
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1cda, 0x1cf2}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0x0c00, 0x0c0c}, {0x0c0e, 0x0c10}, 
            {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, {0x0c3c, 0x0c44}, {0x0c46, 0x0c48}, 
            {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56}, {0x0c58, 0x0c5a}, {0x0c5c, 0x0c5d}, 
            {0x0c60, 0x0c63}, {0x0c66, 0x0c6f}, {0x0c77, 0x0c7f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass325()
{
    // Name = Tirhuta, number of codePoints: 97
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1cf2}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0xa830, 0xa839}, {0x11480, 0x114c7}, 
            {0x114d0, 0x114d9}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass326()
{
    // Name = Chisoi, number of codePoints: 42
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0964, 0x0965}, {0x16d80, 0x16d9d}, {0x16da0, 0x16da9}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass327()
{
    // Name = Dogra, number of codePoints: 82
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0964, 0x096f}, {0xa830, 0xa839}, {0x11800, 0x1183b}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass328()
{
    // Name = Masaram_Gondi, number of codePoints: 77
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x11d3a}),
        std::initializer_list<CharacterRange>({{0x0964, 0x0965}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, 
            {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47}, {0x11d50, 0x11d59}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass329()
{
    // Name = Nandinagari, number of codePoints: 86
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1ce9, 0x1cf2, 0x1cfa}),
        std::initializer_list<CharacterRange>({{0x0964, 0x0965}, {0x0ce6, 0x0cef}, {0xa830, 0xa835}, {0x119a0, 0x119a7}, 
            {0x119aa, 0x119d7}, {0x119da, 0x119e4}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass330()
{
    // Name = Ol_Onal, number of codePoints: 46
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1e5ff}),
        std::initializer_list<CharacterRange>({{0x0964, 0x0965}, {0x1e5d0, 0x1e5fa}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass331()
{
    // Name = Khudawadi, number of codePoints: 81
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0964, 0x0965}, {0xa830, 0xa839}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass332()
{
    // Name = Sinhala, number of codePoints: 114
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0dbd, 0x0dca, 0x0dd6, 0x1cf2}),
        std::initializer_list<CharacterRange>({{0x0964, 0x0965}, {0x0d81, 0x0d83}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, 
            {0x0db3, 0x0dbb}, {0x0dc0, 0x0dc6}, {0x0dcf, 0x0dd4}, {0x0dd8, 0x0ddf}, 
            {0x0de6, 0x0def}, {0x0df2, 0x0df4}, {0x111e1, 0x111f4}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass333()
{
    // Name = Syloti_Nagri, number of codePoints: 57
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0964, 0x0965}, {0x09e6, 0x09ef}, {0xa800, 0xa82c}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass334()
{
    // Name = Takri, number of codePoints: 80
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0964, 0x0965}, {0xa830, 0xa839}, {0x11680, 0x116b9}, {0x116c0, 0x116c9}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass335()
{
    // Name = Gurung_Khema, number of codePoints: 59
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0965}),
        std::initializer_list<CharacterRange>({{0x16100, 0x16139}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass336()
{
    // Name = Limbu, number of codePoints: 69
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x0965, 0x1940}),
        std::initializer_list<CharacterRange>({{0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x193b}, {0x1944, 0x194f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass337()
{
    // Name = Kaithi, number of codePoints: 89
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x2e31, 0x110cd}),
        std::initializer_list<CharacterRange>({{0x0966, 0x096f}, {0xa830, 0xa839}, {0x11080, 0x110c2}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass338()
{
    // Name = Chakma, number of codePoints: 91
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x09e6, 0x09ef}, {0x1040, 0x1049}, {0x11100, 0x11134}, {0x11136, 0x11147}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass339()
{
    // Name = Multani, number of codePoints: 48
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x11288}),
        std::initializer_list<CharacterRange>({{0x0a66, 0x0a6f}, {0x11280, 0x11286}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, 
            {0x1129f, 0x112a9}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass340()
{
    // Name = Khojki, number of codePoints: 85
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0ae6, 0x0aef}, {0xa830, 0xa839}, {0x11200, 0x11211}, {0x11213, 0x11241}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass341()
{
    // Name = Tulu_Tigalari, number of codePoints: 99
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1cf2, 0x1cf4, 0xa8f1, 0x1138b, 0x1138e, 0x113c2, 0x113c5}),
        std::initializer_list<CharacterRange>({{0x0ce6, 0x0cef}, {0xa830, 0xa835}, {0x11380, 0x11389}, {0x11390, 0x113b5}, 
            {0x113b7, 0x113c0}, {0x113c7, 0x113ca}, {0x113cc, 0x113d5}, {0x113d7, 0x113d8}, 
            {0x113e1, 0x113e2}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass342()
{
    // Name = Myanmar, number of codePoints: 244
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0xa92e}),
        std::initializer_list<CharacterRange>({{0x1000, 0x109f}, {0xa9e0, 0xa9fe}, {0xaa60, 0xaa7f}, {0x116d0, 0x116e3}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass343()
{
    // Name = Runic, number of codePoints: 89
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x16a0, 0x16f8}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass344()
{
    // Name = Buhid, number of codePoints: 22
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1735, 0x1736}, {0x1740, 0x1753}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass345()
{
    // Name = Hanunoo, number of codePoints: 23
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1720, 0x1736}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass346()
{
    // Name = Tagbanwa, number of codePoints: 20
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x1735, 0x1736}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass347()
{
    // Name = Tagalog, number of codePoints: 25
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x171f}),
        std::initializer_list<CharacterRange>({{0x1700, 0x1715}, {0x1735, 0x1736}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass348()
{
    // Name = Mongolian, number of codePoints: 178
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x202f}),
        std::initializer_list<CharacterRange>({{0x1800, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x3001, 0x3002}, 
            {0x3008, 0x300b}, {0x11660, 0x1166c}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass349()
{
    // Name = Phags_Pa, number of codePoints: 61
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x1805, 0x202f, 0x3002}),
        std::initializer_list<CharacterRange>({{0x1802, 0x1803}, {0xa840, 0xa877}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass350()
{
    // Name = Old_Hungarian, number of codePoints: 112
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x205a, 0x205d, 0x2e31, 0x2e41}),
        std::initializer_list<CharacterRange>({{0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10cfa, 0x10cff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass351()
{
    // Name = Lycian, number of codePoints: 30
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x205a}),
        std::initializer_list<CharacterRange>({{0x10280, 0x1029c}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass352()
{
    // Name = Old_Turkic, number of codePoints: 75
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x205a, 0x2e30}),
        std::initializer_list<CharacterRange>({{0x10c00, 0x10c48}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass353()
{
    // Name = Meroitic_Hieroglyphs, number of codePoints: 33
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x205d}),
        std::initializer_list<CharacterRange>({{0x10980, 0x1099f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass354()
{
    // Name = Samaritan, number of codePoints: 62
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x2e31}),
        std::initializer_list<CharacterRange>({{0x0800, 0x082d}, {0x0830, 0x083e}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass355()
{
    // Name = Tangut, number of codePoints: 7076
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x31ef, 0x16fe0}),
        std::initializer_list<CharacterRange>({{0x2ff0, 0x2fff}, {0x17000, 0x18aff}, {0x18d00, 0x18d1e}, {0x18d80, 0x18df2}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass356()
{
    // Name = Hangul, number of codePoints: 11775
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x3037, 0x30fb}),
        std::initializer_list<CharacterRange>({{0x1100, 0x11ff}, {0x3001, 0x3003}, {0x3008, 0x3011}, {0x3013, 0x301f}, 
            {0x302e, 0x3030}, {0x3131, 0x318e}, {0x3200, 0x321e}, {0x3260, 0x327e}, 
            {0xa960, 0xa97c}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, 
            {0xfe45, 0xfe46}, {0xff61, 0xff65}, {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, 
            {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass357()
{
    // Name = Hiragana, number of codePoints: 433
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x3037, 0xff70, 0x1b132, 0x1f200}),
        std::initializer_list<CharacterRange>({{0x3001, 0x3003}, {0x3008, 0x3011}, {0x3013, 0x301f}, {0x3030, 0x3035}, 
            {0x303c, 0x303d}, {0x3041, 0x3096}, {0x3099, 0x30a0}, {0x30fb, 0x30fc}, 
            {0xfe45, 0xfe46}, {0xff61, 0xff65}, {0xff9e, 0xff9f}, {0x1b001, 0x1b11f}, 
            {0x1b150, 0x1b152}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass358()
{
    // Name = Yi, number of codePoints: 1246
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x30fb}),
        std::initializer_list<CharacterRange>({{0x3001, 0x3002}, {0x3008, 0x3011}, {0x3014, 0x301b}, {0xa000, 0xa48c}, 
            {0xa490, 0xa4c6}, {0xff61, 0xff65}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass359()
{
    // Name = Tibetan, number of codePoints: 211
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x0f00, 0x0f47}, {0x0f49, 0x0f6c}, {0x0f71, 0x0f97}, {0x0f99, 0x0fbc}, 
            {0x0fbe, 0x0fcc}, {0x0fce, 0x0fd4}, {0x0fd9, 0x0fda}, {0x3008, 0x300b}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass360()
{
    // Name = Modi, number of codePoints: 89
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0xa830, 0xa839}, {0x11600, 0x11644}, {0x11650, 0x11659}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass361()
{
    // Name = Kayah_Li, number of codePoints: 48
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0xa900, 0xa92f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass362()
{
    // Name = Buginese, number of codePoints: 31
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0xa9cf}),
        std::initializer_list<CharacterRange>({{0x1a00, 0x1a1b}, {0x1a1e, 0x1a1f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass363()
{
    // Name = Javanese, number of codePoints: 91
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0xa980, 0xa9cd}, {0xa9cf, 0xa9d9}, {0xa9de, 0xa9df}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass364()
{
    // Name = Cypro_Minoan, number of codePoints: 101
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10100, 0x10101}, {0x12f90, 0x12ff2}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass365()
{
    // Name = Cypriot, number of codePoints: 112
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x10808, 0x1083c, 0x1083f}),
        std::initializer_list<CharacterRange>({{0x10100, 0x10102}, {0x10107, 0x10133}, {0x10137, 0x1013f}, {0x10800, 0x10805}, 
            {0x1080a, 0x10835}, {0x10837, 0x10838}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass366()
{
    // Name = Linear_B, number of codePoints: 268
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, 
            {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10100, 0x10102}, 
            {0x10107, 0x10133}, {0x10137, 0x1013f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass367()
{
    // Name = Linear_A, number of codePoints: 386
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({{0x10107, 0x10133}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass368()
{
    // Name = RGI_Emoji, number of strings: 2760 number of codePoints: 1194
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<Vector<char32_t>>({{ std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fb\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fb\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fc\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fc\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fd\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fd\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fe\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fe\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3ff\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3ff\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f469\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f469\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f469\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f469\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f469\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f469\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f469\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f469\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f469\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f469\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f469\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f469\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f469\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f469\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f469\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f469\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f469\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f469\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f469\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f469\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f469\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f469\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f469\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f469\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f469\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fb\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fb\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fc\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fc\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fd\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fd\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fe\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fe\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3ff\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3ff\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fb\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fb\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fc\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fc\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fd\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fd\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fe\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fe\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3ff\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3ff\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3f4\xe0067\xe0062\xe0065\xe006e\xe0067\xe007f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3f4\xe0067\xe0062\xe0073\xe0063\xe0074\xe007f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3f4\xe0067\xe0062\xe0077\xe006c\xe0073\xe007f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f468\x200d\x1f466\x200d\x1f466"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f468\x200d\x1f467\x200d\x1f466"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f468\x200d\x1f467\x200d\x1f467"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f469\x200d\x1f466\x200d\x1f466"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f469\x200d\x1f467\x200d\x1f466"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f469\x200d\x1f467\x200d\x1f467"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f430\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f430\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f430\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f430\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f91d\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f91d\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f91d\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f91d\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1faef\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1faef\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1faef\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1faef\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f430\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f430\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f430\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f430\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f91d\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f91d\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f91d\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f91d\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1faef\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1faef\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1faef\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1faef\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f430\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f430\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f430\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f430\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f91d\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f91d\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f91d\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f91d\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1faef\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1faef\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1faef\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1faef\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f430\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f430\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f430\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f430\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f91d\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f91d\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f91d\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f91d\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1faef\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1faef\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1faef\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1faef\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f430\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f430\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f430\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f430\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f91d\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f91d\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f91d\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f91d\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1faef\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1faef\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1faef\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1faef\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f469\x200d\x1f466\x200d\x1f466"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f469\x200d\x1f467\x200d\x1f466"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f469\x200d\x1f467\x200d\x1f467"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f430\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f430\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f430\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f430\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f91d\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f91d\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f91d\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f91d\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f91d\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f91d\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f91d\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f91d\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1faef\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1faef\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1faef\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1faef\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f430\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f430\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f430\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f430\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f91d\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f91d\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f91d\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f91d\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f91d\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f91d\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f91d\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f91d\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1faef\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1faef\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1faef\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1faef\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f430\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f430\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f430\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f430\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f91d\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f91d\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f91d\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f91d\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f91d\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f91d\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f91d\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f91d\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1faef\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1faef\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1faef\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1faef\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f430\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f430\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f430\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f430\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f91d\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f91d\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f91d\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f91d\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f91d\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f91d\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f91d\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f91d\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1faef\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1faef\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1faef\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1faef\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f430\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f430\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f430\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f430\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f91d\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f91d\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f91d\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f91d\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f91d\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f91d\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f91d\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f91d\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1faef\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1faef\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1faef\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1faef\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9d1\x200d\x1f9d2\x200d\x1f9d2"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f430\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f430\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f430\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f430\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f91d\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f91d\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f91d\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f91d\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f91d\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1faef\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1faef\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1faef\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1faef\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f430\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f430\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f430\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f430\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f91d\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f91d\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f91d\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f91d\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f91d\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1faef\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1faef\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1faef\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1faef\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f430\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f430\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f430\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f430\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f91d\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f91d\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f91d\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f91d\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f91d\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1faef\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1faef\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1faef\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1faef\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f430\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f430\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f430\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f430\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f91d\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f91d\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f91d\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f91d\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f91d\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1faef\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1faef\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1faef\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1faef\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f430\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f430\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f430\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f430\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f91d\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f91d\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f91d\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f91d\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f91d\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1faef\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1faef\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1faef\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1faef\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x2764\xfe0f\x200d\x1f468"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f9af\x200d\x27a1\xfe0f"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f9bc\x200d\x27a1\xfe0f"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f9bd\x200d\x27a1\xfe0f"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x2764\xfe0f\x200d\x1f468"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x2764\xfe0f\x200d\x1f469"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f9af\x200d\x27a1\xfe0f"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f9bc\x200d\x27a1\xfe0f"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f9bd\x200d\x27a1\xfe0f"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9af\x200d\x27a1\xfe0f"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9bc\x200d\x27a1\xfe0f"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9bd\x200d\x27a1\xfe0f"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\xfe0f\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\xfe0f\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fb\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fc\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fd\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fe\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3ff\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\xfe0f\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\xfe0f\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\xfe0f\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\xfe0f\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3f3\xfe0f\x200d\x26a7\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f441\xfe0f\x200d\x1f5e8\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f466\x200d\x1f466"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f467\x200d\x1f466"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f467\x200d\x1f467"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f468\x200d\x1f466"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f468\x200d\x1f467"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f469\x200d\x1f466"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f469\x200d\x1f467"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f466\x200d\x1f466"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f467\x200d\x1f466"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f467\x200d\x1f467"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f469\x200d\x1f466"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f469\x200d\x1f467"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\xfe0f\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\xfe0f\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fb\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fc\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fd\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fe\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3ff\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fb\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fc\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fd\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fe\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3ff\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f91d\x200d\x1f9d1"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9d1\x200d\x1f9d2"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9d2\x200d\x1f9d2"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fb\x200d\x1faf2\x1f3fc"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fb\x200d\x1faf2\x1f3fd"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fb\x200d\x1faf2\x1f3fe"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fb\x200d\x1faf2\x1f3ff"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fc\x200d\x1faf2\x1f3fb"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fc\x200d\x1faf2\x1f3fd"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fc\x200d\x1faf2\x1f3fe"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fc\x200d\x1faf2\x1f3ff"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fd\x200d\x1faf2\x1f3fb"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fd\x200d\x1faf2\x1f3fc"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fd\x200d\x1faf2\x1f3fe"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fd\x200d\x1faf2\x1f3ff"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fe\x200d\x1faf2\x1f3fb"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fe\x200d\x1faf2\x1f3fc"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fe\x200d\x1faf2\x1f3fd"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fe\x200d\x1faf2\x1f3ff"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3ff\x200d\x1faf2\x1f3fb"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3ff\x200d\x1faf2\x1f3fc"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3ff\x200d\x1faf2\x1f3fd"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3ff\x200d\x1faf2\x1f3fe"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26d3\xfe0f\x200d\x1f4a5"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x2764\xfe0f\x200d\x1f525"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x2764\xfe0f\x200d\x1fa79"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x200d\x27a1\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3f3\xfe0f\x200d\x1f308"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3f4\x200d\x2620\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f43b\x200d\x2744\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x2695\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x2696\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x2708\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x2695\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x2696\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x2708\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f636\x200d\x1f32b\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f642\x200d\x2194\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f642\x200d\x2195\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x200d\x27a1\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x200d\x27a1\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x2695\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x2696\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x2708\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f384"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1fa70"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f384"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1fa70"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f384"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1fa70"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f384"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1fa70"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f384"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1fa70"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9de\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9de\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9df\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9df\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"#\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"*\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"0\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"1\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"2\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"3\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"4\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"5\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"6\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"7\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"8\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"9\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f344\x200d\x1f7eb"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f34b\x200d\x1f7e9"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f408\x200d\x2b1b"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f415\x200d\x1f9ba"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f426\x200d\x2b1b"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f426\x200d\x1f525"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f33e"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f373"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f37c"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f393"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f3a4"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f3a8"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f3eb"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f3ed"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f466"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f467"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f4bb"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f4bc"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f527"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f52c"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f680"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f692"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f9af"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f9b0"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f9b1"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f9b2"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f9b3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f9bc"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f9bd"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f33e"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f373"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f37c"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f393"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f3a4"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f3a8"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f3eb"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f3ed"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f466"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f467"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f4bb"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f4bc"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f527"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f52c"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f680"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f692"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f9af"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f9b0"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f9b1"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f9b2"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f9b3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f9bc"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f9bd"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f62e\x200d\x1f4a8"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f635\x200d\x1f4ab"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f33e"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f373"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f37c"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f384"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f393"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f3a4"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f3a8"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f3eb"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f3ed"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f4bb"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f4bc"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f527"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f52c"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f680"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f692"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9af"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9b0"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9b1"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9b2"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9b3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9bc"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9bd"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9d2"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1fa70"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"©\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"®\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x203c\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2049\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2122\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2139\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2194\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2195\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2196\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2197\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2198\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2199\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x21a9\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x21aa\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2328\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x23cf\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x23ed\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x23ee\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x23ef\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x23f1\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x23f2\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x23f8\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x23f9\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x23fa\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x24c2\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x25aa\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x25ab\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x25b6\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x25c0\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x25fb\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x25fc\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2600\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2601\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2602\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2603\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2604\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x260e\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2611\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2618\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x261d\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x261d\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x261d\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x261d\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x261d\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x261d\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2620\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2622\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2623\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2626\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x262a\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x262e\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x262f\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2638\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2639\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x263a\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2640\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2642\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x265f\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2660\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2663\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2665\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2666\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2668\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x267b\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x267e\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2692\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2694\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2695\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2696\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2697\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2699\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x269b\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x269c\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26a0\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26a7\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26b0\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26b1\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26c8\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26cf\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26d1\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26d3\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26e9\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f0\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f1\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f4\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f7\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f8\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2702\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2708\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2709\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270a\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270a\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270a\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270a\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270a\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270b\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270b\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270b\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270b\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270b\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270c\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270c\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270c\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270c\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270c\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270c\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270d\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270d\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270d\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270d\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270d\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270d\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270f\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2712\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2714\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2716\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x271d\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2721\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2733\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2734\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2744\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2747\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2763\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2764\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x27a1\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2934\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2935\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2b05\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2b06\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2b07\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x3030\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x303d\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x3297\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x3299\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f170\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f171\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f17e\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f17f\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1e9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1eb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1f6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1e7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1e9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1eb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1ed"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1ef"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1f6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1e9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1eb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1ed"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1f5"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1f6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e9\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e9\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e9\x1f1ef"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e9\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e9\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e9\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e9\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ea\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ea\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ea\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ea\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ea\x1f1ed"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ea\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ea\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ea\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ea\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1eb\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1eb\x1f1ef"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1eb\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1eb\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1eb\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1eb\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1e7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1e9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1eb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1ed"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1f5"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1f6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ed\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ed\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ed\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ed\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ed\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ed\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1e9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1f6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ef\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ef\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ef\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ef\x1f1f5"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1ed"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1f5"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1e7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1e9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1eb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1ed"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f5"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1eb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1f5"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f4\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1eb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1ed"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f6\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f7\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f7\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f7\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f7\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f7\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1e7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1e9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1ed"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1ef"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1e9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1eb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1ed"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1ef"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fa\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fa\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fa\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fa\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fa\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fa\x1f1fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fa\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fb\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fb\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fb\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fb\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fb\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fb\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fb\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fc\x1f1eb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fc\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fd\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fe\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fe\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ff\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ff\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ff\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f202\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f237\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f321\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f324\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f325\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f326\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f327\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f328\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f329\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f32a\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f32b\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f32c\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f336\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f37d\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f385\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f385\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f385\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f385\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f385\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f396\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f397\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f399\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f39a\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f39b\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f39e\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f39f\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c2\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c2\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c2\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c2\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c2\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c7\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c7\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c7\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c7\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c7\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cd\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ce\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3d4\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3d5\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3d6\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3d7\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3d8\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3d9\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3da\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3db\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3dc\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3dd\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3de\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3df\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3f3\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3f5\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3f7\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f43f\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f441\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f442\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f442\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f442\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f442\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f442\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f443\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f443\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f443\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f443\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f443\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f446\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f446\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f446\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f446\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f446\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f447\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f447\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f447\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f447\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f447\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f448\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f448\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f448\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f448\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f448\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f449\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f449\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f449\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f449\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f449\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44a\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44a\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44a\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44a\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44a\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44b\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44b\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44b\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44b\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44b\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44c\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44c\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44c\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44c\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44c\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44d\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44d\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44d\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44d\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44d\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44e\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44e\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44e\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44e\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44e\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44f\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44f\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44f\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44f\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44f\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f450\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f450\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f450\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f450\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f450\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f466\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f466\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f466\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f466\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f466\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f467\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f467\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f467\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f467\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f467\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46b\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46b\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46b\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46b\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46b\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46c\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46c\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46c\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46c\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46c\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46d\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46d\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46d\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46d\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46d\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f472\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f472\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f472\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f472\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f472\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f474\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f474\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f474\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f474\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f474\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f475\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f475\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f475\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f475\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f475\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f476\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f476\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f476\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f476\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f476\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f478\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f478\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f478\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f478\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f478\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f47c\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f47c\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f47c\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f47c\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f47c\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f483\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f483\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f483\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f483\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f483\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f485\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f485\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f485\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f485\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f485\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f48f\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f48f\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f48f\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f48f\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f48f\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f491\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f491\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f491\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f491\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f491\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f4aa\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f4aa\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f4aa\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f4aa\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f4aa\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f4fd\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f549\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f54a\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f56f\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f570\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f573\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f574\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f574\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f574\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f574\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f574\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f574\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f576\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f577\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f578\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f579\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f57a\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f57a\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f57a\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f57a\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f57a\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f587\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f58a\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f58b\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f58c\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f58d\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f590\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f590\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f590\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f590\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f590\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f590\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f595\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f595\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f595\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f595\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f595\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f596\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f596\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f596\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f596\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f596\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5a5\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5a8\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5b1\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5b2\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5bc\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5c2\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5c3\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5c4\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5d1\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5d2\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5d3\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5dc\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5dd\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5de\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5e1\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5e3\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5e8\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5ef\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5f3\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5fa\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64c\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64c\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64c\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64c\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64c\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64f\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64f\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64f\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64f\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64f\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6c0\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6c0\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6c0\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6c0\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6c0\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6cb\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6cc\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6cc\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6cc\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6cc\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6cc\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6cd\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6ce\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6cf\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6e0\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6e1\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6e2\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6e3\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6e4\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6e5\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6e9\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6f0\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6f3\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90c\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90c\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90c\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90c\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90c\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90f\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90f\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90f\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90f\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90f\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f918\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f918\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f918\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f918\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f918\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f919\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f919\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f919\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f919\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f919\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91a\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91a\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91a\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91a\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91a\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91b\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91b\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91b\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91b\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91b\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91c\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91c\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91c\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91c\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91c\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91d\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91d\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91d\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91d\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91d\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91e\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91e\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91e\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91e\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91e\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91f\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91f\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91f\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91f\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91f\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f930\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f930\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f930\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f930\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f930\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f931\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f931\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f931\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f931\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f931\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f932\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f932\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f932\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f932\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f932\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f933\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f933\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f933\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f933\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f933\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f934\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f934\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f934\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f934\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f934\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f936\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f936\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f936\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f936\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f936\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f977\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f977\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f977\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f977\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f977\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b5\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b5\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b5\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b5\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b5\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b6\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b6\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b6\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b6\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b6\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9bb\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9bb\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9bb\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9bb\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9bb\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d2\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d2\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d2\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d2\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d2\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d3\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d3\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d3\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d3\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d3\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d5\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d5\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d5\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d5\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d5\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac3\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac3\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac3\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac3\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac3\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac4\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac4\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac4\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac4\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac4\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac5\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac5\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac5\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac5\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac5\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf0\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf0\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf0\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf0\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf0\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf2\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf2\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf2\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf2\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf2\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf3\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf3\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf3\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf3\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf3\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf4\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf4\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf4\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf4\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf4\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf5\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf5\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf5\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf5\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf5\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf6\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf6\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf6\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf6\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf6\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf7\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf7\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf7\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf7\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf7\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf8\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf8\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf8\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf8\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf8\x1f3ff"), 2 }}}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x23f0, 0x23f3, 0x267f, 0x2693, 0x26a1, 0x26ce, 0x26d4, 0x26ea, 
            0x26f5, 0x26fa, 0x26fd, 0x2705, 0x2728, 0x274c, 0x274e, 0x2757, 
            0x27b0, 0x27bf, 0x2b50, 0x2b55, 0x1f004, 0x1f0cf, 0x1f18e, 0x1f201, 
            0x1f21a, 0x1f22f, 0x1f3f4, 0x1f440, 0x1f57a, 0x1f5a4, 0x1f6cc, 0x1f7f0, 
            0x1fac8}),
        std::initializer_list<CharacterRange>({{0x231a, 0x231b}, {0x23e9, 0x23ec}, {0x25fd, 0x25fe}, {0x2614, 0x2615}, 
            {0x2648, 0x2653}, {0x26aa, 0x26ab}, {0x26bd, 0x26be}, {0x26c4, 0x26c5}, 
            {0x26f2, 0x26f3}, {0x270a, 0x270b}, {0x2753, 0x2755}, {0x2795, 0x2797}, 
            {0x2b1b, 0x2b1c}, {0x1f191, 0x1f19a}, {0x1f232, 0x1f236}, {0x1f238, 0x1f23a}, 
            {0x1f250, 0x1f251}, {0x1f300, 0x1f320}, {0x1f32d, 0x1f335}, {0x1f337, 0x1f37c}, 
            {0x1f37e, 0x1f393}, {0x1f3a0, 0x1f3ca}, {0x1f3cf, 0x1f3d3}, {0x1f3e0, 0x1f3f0}, 
            {0x1f3f8, 0x1f43e}, {0x1f442, 0x1f4fc}, {0x1f4ff, 0x1f53d}, {0x1f54b, 0x1f54e}, 
            {0x1f550, 0x1f567}, {0x1f595, 0x1f596}, {0x1f5fb, 0x1f64f}, {0x1f680, 0x1f6c5}, 
            {0x1f6d0, 0x1f6d2}, {0x1f6d5, 0x1f6d8}, {0x1f6dc, 0x1f6df}, {0x1f6eb, 0x1f6ec}, 
            {0x1f6f4, 0x1f6fc}, {0x1f7e0, 0x1f7eb}, {0x1f90c, 0x1f93a}, {0x1f93c, 0x1f945}, 
            {0x1f947, 0x1f9ff}, {0x1fa70, 0x1fa7c}, {0x1fa80, 0x1fa8a}, {0x1fa8e, 0x1fac6}, 
            {0x1facd, 0x1fadd}, {0x1fadf, 0x1faea}, {0x1faef, 0x1faf8}}),
        CharacterClassWidths::HasBothBMPAndNonBMP,
        true);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass369()
{
    // Name = Basic_Emoji, number of strings: 207 number of codePoints: 1194
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<Vector<char32_t>>({{ std::span { const_cast<char32_t*>(U"©\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"®\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x203c\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2049\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2122\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2139\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2194\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2195\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2196\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2197\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2198\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2199\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x21a9\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x21aa\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2328\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x23cf\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x23ed\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x23ee\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x23ef\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x23f1\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x23f2\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x23f8\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x23f9\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x23fa\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x24c2\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x25aa\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x25ab\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x25b6\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x25c0\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x25fb\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x25fc\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2600\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2601\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2602\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2603\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2604\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x260e\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2611\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2618\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x261d\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2620\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2622\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2623\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2626\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x262a\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x262e\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x262f\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2638\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2639\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x263a\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2640\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2642\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x265f\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2660\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2663\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2665\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2666\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2668\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x267b\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x267e\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2692\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2694\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2695\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2696\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2697\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2699\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x269b\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x269c\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26a0\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26a7\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26b0\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26b1\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26c8\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26cf\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26d1\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26d3\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26e9\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f0\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f1\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f4\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f7\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f8\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2702\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2708\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2709\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270c\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270d\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270f\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2712\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2714\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2716\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x271d\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2721\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2733\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2734\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2744\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2747\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2763\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2764\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x27a1\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2934\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2935\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2b05\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2b06\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x2b07\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x3030\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x303d\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x3297\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x3299\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f170\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f171\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f17e\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f17f\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f202\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f237\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f321\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f324\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f325\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f326\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f327\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f328\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f329\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f32a\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f32b\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f32c\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f336\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f37d\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f396\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f397\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f399\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f39a\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f39b\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f39e\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f39f\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cd\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ce\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3d4\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3d5\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3d6\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3d7\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3d8\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3d9\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3da\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3db\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3dc\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3dd\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3de\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3df\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3f3\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3f5\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3f7\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f43f\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f441\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f4fd\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f549\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f54a\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f56f\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f570\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f573\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f574\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f576\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f577\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f578\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f579\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f587\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f58a\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f58b\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f58c\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f58d\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f590\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5a5\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5a8\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5b1\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5b2\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5bc\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5c2\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5c3\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5c4\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5d1\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5d2\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5d3\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5dc\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5dd\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5de\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5e1\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5e3\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5e8\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5ef\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5f3\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f5fa\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6cb\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6cd\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6ce\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6cf\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6e0\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6e1\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6e2\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6e3\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6e4\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6e5\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6e9\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6f0\xfe0f"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6f3\xfe0f"), 2 }}}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({0x23f0, 0x23f3, 0x267f, 0x2693, 0x26a1, 0x26ce, 0x26d4, 0x26ea, 
            0x26f5, 0x26fa, 0x26fd, 0x2705, 0x2728, 0x274c, 0x274e, 0x2757, 
            0x27b0, 0x27bf, 0x2b50, 0x2b55, 0x1f004, 0x1f0cf, 0x1f18e, 0x1f201, 
            0x1f21a, 0x1f22f, 0x1f3f4, 0x1f440, 0x1f57a, 0x1f5a4, 0x1f6cc, 0x1f7f0, 
            0x1fac8}),
        std::initializer_list<CharacterRange>({{0x231a, 0x231b}, {0x23e9, 0x23ec}, {0x25fd, 0x25fe}, {0x2614, 0x2615}, 
            {0x2648, 0x2653}, {0x26aa, 0x26ab}, {0x26bd, 0x26be}, {0x26c4, 0x26c5}, 
            {0x26f2, 0x26f3}, {0x270a, 0x270b}, {0x2753, 0x2755}, {0x2795, 0x2797}, 
            {0x2b1b, 0x2b1c}, {0x1f191, 0x1f19a}, {0x1f232, 0x1f236}, {0x1f238, 0x1f23a}, 
            {0x1f250, 0x1f251}, {0x1f300, 0x1f320}, {0x1f32d, 0x1f335}, {0x1f337, 0x1f37c}, 
            {0x1f37e, 0x1f393}, {0x1f3a0, 0x1f3ca}, {0x1f3cf, 0x1f3d3}, {0x1f3e0, 0x1f3f0}, 
            {0x1f3f8, 0x1f43e}, {0x1f442, 0x1f4fc}, {0x1f4ff, 0x1f53d}, {0x1f54b, 0x1f54e}, 
            {0x1f550, 0x1f567}, {0x1f595, 0x1f596}, {0x1f5fb, 0x1f64f}, {0x1f680, 0x1f6c5}, 
            {0x1f6d0, 0x1f6d2}, {0x1f6d5, 0x1f6d8}, {0x1f6dc, 0x1f6df}, {0x1f6eb, 0x1f6ec}, 
            {0x1f6f4, 0x1f6fc}, {0x1f7e0, 0x1f7eb}, {0x1f90c, 0x1f93a}, {0x1f93c, 0x1f945}, 
            {0x1f947, 0x1f9ff}, {0x1fa70, 0x1fa7c}, {0x1fa80, 0x1fa8a}, {0x1fa8e, 0x1fac6}, 
            {0x1facd, 0x1fadd}, {0x1fadf, 0x1faea}, {0x1faef, 0x1faf8}}),
        CharacterClassWidths::HasBothBMPAndNonBMP,
        true);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass370()
{
    // Name = Emoji_Keycap_Sequence, number of strings: 12
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<Vector<char32_t>>({{ std::span { const_cast<char32_t*>(U"#\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"*\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"0\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"1\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"2\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"3\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"4\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"5\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"6\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"7\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"8\xfe0f\x20e3"), 3 }}, 
            { std::span { const_cast<char32_t*>(U"9\xfe0f\x20e3"), 3 }}}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        CharacterClassWidths::Unknown,
        true);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass371()
{
    // Name = RGI_Emoji_Flag_Sequence, number of strings: 259
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<Vector<char32_t>>({{ std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1e9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1eb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1f6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e6\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1e7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1e9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1eb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1ed"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1ef"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1f6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e7\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1e9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1eb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1ed"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1f5"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1f6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e8\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e9\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e9\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e9\x1f1ef"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e9\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e9\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e9\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1e9\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ea\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ea\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ea\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ea\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ea\x1f1ed"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ea\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ea\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ea\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ea\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1eb\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1eb\x1f1ef"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1eb\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1eb\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1eb\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1eb\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1e7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1e9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1eb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1ed"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1f5"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1f6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ec\x1f1fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ed\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ed\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ed\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ed\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ed\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ed\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1e9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1f6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ee\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ef\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ef\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ef\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ef\x1f1f5"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1ed"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1f5"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f0\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1e7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f1\x1f1fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1e9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1eb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1ed"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f5"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f2\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1eb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1f5"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f3\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f4\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1eb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1ed"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f5\x1f1fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f6\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f7\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f7\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f7\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f7\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f7\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1e7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1e9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1ed"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1ef"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f8\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1e9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1eb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1ed"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1ef"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1f1"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1f4"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1f7"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1f9\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fa\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fa\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fa\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fa\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fa\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fa\x1f1fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fa\x1f1ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fb\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fb\x1f1e8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fb\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fb\x1f1ec"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fb\x1f1ee"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fb\x1f1f3"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fb\x1f1fa"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fc\x1f1eb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fc\x1f1f8"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fd\x1f1f0"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fe\x1f1ea"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1fe\x1f1f9"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ff\x1f1e6"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ff\x1f1f2"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f1ff\x1f1fc"), 2 }}}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        CharacterClassWidths::Unknown,
        true);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass372()
{
    // Name = RGI_Emoji_Tag_Sequence, number of strings: 3
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<Vector<char32_t>>({{ std::span { const_cast<char32_t*>(U"\x1f3f4\xe0067\xe0062\xe0065\xe006e\xe0067\xe007f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3f4\xe0067\xe0062\xe0073\xe0063\xe0074\xe007f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3f4\xe0067\xe0062\xe0077\xe006c\xe0073\xe007f"), 7 }}}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        CharacterClassWidths::Unknown,
        true);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass373()
{
    // Name = RGI_Emoji_Modifier_Sequence, number of strings: 665
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<Vector<char32_t>>({{ std::span { const_cast<char32_t*>(U"\x261d\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x261d\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x261d\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x261d\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x261d\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270a\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270a\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270a\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270a\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270a\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270b\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270b\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270b\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270b\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270b\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270c\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270c\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270c\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270c\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270c\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270d\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270d\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270d\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270d\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x270d\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f385\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f385\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f385\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f385\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f385\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c2\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c2\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c2\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c2\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c2\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c7\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c7\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c7\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c7\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c7\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f442\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f442\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f442\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f442\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f442\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f443\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f443\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f443\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f443\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f443\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f446\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f446\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f446\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f446\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f446\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f447\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f447\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f447\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f447\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f447\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f448\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f448\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f448\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f448\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f448\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f449\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f449\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f449\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f449\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f449\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44a\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44a\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44a\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44a\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44a\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44b\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44b\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44b\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44b\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44b\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44c\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44c\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44c\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44c\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44c\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44d\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44d\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44d\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44d\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44d\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44e\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44e\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44e\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44e\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44e\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44f\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44f\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44f\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44f\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f44f\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f450\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f450\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f450\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f450\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f450\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f466\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f466\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f466\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f466\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f466\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f467\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f467\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f467\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f467\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f467\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46b\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46b\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46b\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46b\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46b\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46c\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46c\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46c\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46c\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46c\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46d\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46d\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46d\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46d\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46d\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f472\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f472\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f472\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f472\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f472\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f474\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f474\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f474\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f474\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f474\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f475\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f475\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f475\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f475\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f475\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f476\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f476\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f476\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f476\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f476\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f478\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f478\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f478\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f478\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f478\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f47c\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f47c\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f47c\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f47c\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f47c\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f483\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f483\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f483\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f483\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f483\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f485\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f485\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f485\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f485\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f485\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f48f\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f48f\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f48f\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f48f\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f48f\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f491\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f491\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f491\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f491\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f491\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f4aa\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f4aa\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f4aa\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f4aa\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f4aa\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f574\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f574\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f574\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f574\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f574\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f57a\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f57a\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f57a\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f57a\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f57a\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f590\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f590\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f590\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f590\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f590\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f595\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f595\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f595\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f595\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f595\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f596\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f596\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f596\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f596\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f596\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64c\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64c\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64c\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64c\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64c\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64f\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64f\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64f\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64f\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64f\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6c0\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6c0\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6c0\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6c0\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6c0\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6cc\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6cc\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6cc\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6cc\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6cc\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90c\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90c\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90c\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90c\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90c\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90f\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90f\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90f\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90f\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f90f\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f918\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f918\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f918\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f918\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f918\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f919\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f919\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f919\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f919\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f919\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91a\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91a\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91a\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91a\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91a\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91b\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91b\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91b\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91b\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91b\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91c\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91c\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91c\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91c\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91c\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91d\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91d\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91d\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91d\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91d\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91e\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91e\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91e\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91e\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91e\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91f\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91f\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91f\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91f\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f91f\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f930\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f930\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f930\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f930\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f930\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f931\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f931\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f931\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f931\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f931\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f932\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f932\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f932\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f932\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f932\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f933\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f933\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f933\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f933\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f933\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f934\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f934\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f934\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f934\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f934\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f936\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f936\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f936\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f936\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f936\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f977\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f977\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f977\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f977\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f977\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b5\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b5\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b5\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b5\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b5\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b6\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b6\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b6\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b6\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b6\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9bb\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9bb\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9bb\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9bb\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9bb\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d2\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d2\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d2\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d2\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d2\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d3\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d3\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d3\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d3\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d3\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d5\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d5\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d5\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d5\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d5\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac3\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac3\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac3\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac3\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac3\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac4\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac4\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac4\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac4\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac4\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac5\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac5\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac5\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac5\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1fac5\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf0\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf0\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf0\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf0\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf0\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf2\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf2\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf2\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf2\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf2\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf3\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf3\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf3\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf3\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf3\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf4\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf4\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf4\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf4\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf4\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf5\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf5\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf5\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf5\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf5\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf6\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf6\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf6\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf6\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf6\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf7\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf7\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf7\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf7\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf7\x1f3ff"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf8\x1f3fb"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf8\x1f3fc"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf8\x1f3fd"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf8\x1f3fe"), 2 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf8\x1f3ff"), 2 }}}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<char32_t>({}),
        std::initializer_list<CharacterRange>({}),
        CharacterClassWidths::Unknown,
        true);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass374()
{
    // Name = RGI_Emoji_ZWJ_Sequence, number of strings: 1614
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<Vector<char32_t>>({{ std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3ff"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fb"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fc"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fd"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f9d1\x1f3fe"), 10 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fb\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fb\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fc\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fc\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fd\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fd\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fe\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fe\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3ff\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3ff\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f468"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x2764\xfe0f\x200d\x1f48b\x200d\x1f469"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f469\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f469\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f469\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f469\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2764\xfe0f\x200d\x1f469\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f469\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f469\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f469\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f469\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2764\xfe0f\x200d\x1f469\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f469\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f469\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f469\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f469\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2764\xfe0f\x200d\x1f469\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f469\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f469\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f469\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f469\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2764\xfe0f\x200d\x1f469\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f468\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f469\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f469\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f469\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f469\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2764\xfe0f\x200d\x1f469\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fb\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fb\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fc\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fc\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fd\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fd\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fe\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fe\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3ff\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3ff\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fb\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fb\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fc\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fc\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fd\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fd\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fe\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fe\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3ff\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3ff\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3ff"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fb"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fc"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fd"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2764\xfe0f\x200d\x1f9d1\x1f3fe"), 8 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f468\x200d\x1f466\x200d\x1f466"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f468\x200d\x1f467\x200d\x1f466"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f468\x200d\x1f467\x200d\x1f467"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f469\x200d\x1f466\x200d\x1f466"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f469\x200d\x1f467\x200d\x1f466"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f469\x200d\x1f467\x200d\x1f467"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f430\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f430\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f430\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f430\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f91d\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f91d\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f91d\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f91d\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1faef\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1faef\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1faef\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1faef\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f430\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f430\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f430\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f430\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f91d\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f91d\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f91d\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f91d\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1faef\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1faef\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1faef\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1faef\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f430\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f430\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f430\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f430\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f91d\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f91d\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f91d\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f91d\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1faef\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1faef\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1faef\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1faef\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f430\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f430\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f430\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f430\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f91d\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f91d\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f91d\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f91d\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1faef\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1faef\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1faef\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1faef\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f430\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f430\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f430\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f430\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f91d\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f91d\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f91d\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f91d\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1faef\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1faef\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1faef\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1faef\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f469\x200d\x1f466\x200d\x1f466"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f469\x200d\x1f467\x200d\x1f466"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f469\x200d\x1f467\x200d\x1f467"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f430\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f430\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f430\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f430\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f91d\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f91d\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f91d\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f91d\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f91d\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f91d\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f91d\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f91d\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1faef\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1faef\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1faef\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1faef\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f430\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f430\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f430\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f430\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f91d\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f91d\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f91d\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f91d\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f91d\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f91d\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f91d\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f91d\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1faef\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1faef\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1faef\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1faef\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f430\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f430\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f430\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f430\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f91d\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f91d\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f91d\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f91d\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f91d\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f91d\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f91d\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f91d\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1faef\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1faef\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1faef\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1faef\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f430\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f430\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f430\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f430\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f91d\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f91d\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f91d\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f91d\x200d\x1f468\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f91d\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f91d\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f91d\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f91d\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1faef\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1faef\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1faef\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1faef\x200d\x1f469\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f430\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f430\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f430\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f430\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f91d\x200d\x1f468\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f91d\x200d\x1f468\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f91d\x200d\x1f468\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f91d\x200d\x1f468\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f91d\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f91d\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f91d\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f91d\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1faef\x200d\x1f469\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1faef\x200d\x1f469\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1faef\x200d\x1f469\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1faef\x200d\x1f469\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x200d\x2640\xfe0f\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x200d\x2642\xfe0f\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9d1\x200d\x1f9d2\x200d\x1f9d2"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f430\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f430\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f430\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f430\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f91d\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f91d\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f91d\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f91d\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f91d\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1faef\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1faef\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1faef\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x1faef\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f430\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f430\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f430\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f430\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f91d\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f91d\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f91d\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f91d\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f91d\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1faef\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1faef\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1faef\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x1faef\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f430\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f430\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f430\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f430\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f91d\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f91d\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f91d\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f91d\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f91d\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1faef\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1faef\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1faef\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x1faef\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f430\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f430\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f430\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f430\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f91d\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f91d\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f91d\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f91d\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f91d\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1faef\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1faef\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1faef\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x1faef\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f430\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f430\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f430\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f430\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f91d\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f91d\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f91d\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f91d\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f91d\x200d\x1f9d1\x1f3ff"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f9af\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f9bc\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1f9bd\x200d\x27a1\xfe0f"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1faef\x200d\x1f9d1\x1f3fb"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1faef\x200d\x1f9d1\x1f3fc"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1faef\x200d\x1f9d1\x1f3fd"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x1faef\x200d\x1f9d1\x1f3fe"), 7 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x2764\xfe0f\x200d\x1f468"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f9af\x200d\x27a1\xfe0f"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f9bc\x200d\x27a1\xfe0f"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f9bd\x200d\x27a1\xfe0f"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x2764\xfe0f\x200d\x1f468"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x2764\xfe0f\x200d\x1f469"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f9af\x200d\x27a1\xfe0f"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f9bc\x200d\x27a1\xfe0f"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f9bd\x200d\x27a1\xfe0f"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9af\x200d\x27a1\xfe0f"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9bc\x200d\x27a1\xfe0f"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9bd\x200d\x27a1\xfe0f"), 6 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\xfe0f\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\xfe0f\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26f9\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fb\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fc\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fd\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3fe\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x1f3ff\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\xfe0f\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\xfe0f\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cb\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\xfe0f\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\xfe0f\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3cc\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3f3\xfe0f\x200d\x26a7\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f441\xfe0f\x200d\x1f5e8\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f466\x200d\x1f466"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f467\x200d\x1f466"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f467\x200d\x1f467"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f468\x200d\x1f466"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f468\x200d\x1f467"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f469\x200d\x1f466"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x1f469\x200d\x1f467"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f466\x200d\x1f466"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f467\x200d\x1f466"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f467\x200d\x1f467"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f469\x200d\x1f466"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x1f469\x200d\x1f467"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46e\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f46f\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f470\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f471\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f473\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f477\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f481\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f482\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f486\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f487\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\xfe0f\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\xfe0f\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f575\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f645\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f646\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f647\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64b\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64d\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f64e\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6a3\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b4\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b5\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fb\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fc\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fd\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3fe\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f6b6\x1f3ff\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f926\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f935\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f937\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f938\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f939\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93c\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93d\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f93e\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b8\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9b9\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cd\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fb\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fc\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fd\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3fe\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9ce\x1f3ff\x200d\x27a1\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9cf\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f91d\x200d\x1f9d1"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9d1\x200d\x1f9d2"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x200d\x1f9d2\x200d\x1f9d2"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fb\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fc\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fd\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3fe\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2695\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2696\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d1\x1f3ff\x200d\x2708\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d4\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d6\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d7\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d8\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9d9\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9da\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9db\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dc\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fb\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fb\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fc\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fc\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fd\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fd\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fe\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3fe\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3ff\x200d\x2640\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f9dd\x1f3ff\x200d\x2642\xfe0f"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fb\x200d\x1faf2\x1f3fc"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fb\x200d\x1faf2\x1f3fd"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fb\x200d\x1faf2\x1f3fe"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fb\x200d\x1faf2\x1f3ff"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fc\x200d\x1faf2\x1f3fb"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fc\x200d\x1faf2\x1f3fd"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fc\x200d\x1faf2\x1f3fe"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fc\x200d\x1faf2\x1f3ff"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fd\x200d\x1faf2\x1f3fb"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fd\x200d\x1faf2\x1f3fc"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fd\x200d\x1faf2\x1f3fe"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fd\x200d\x1faf2\x1f3ff"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fe\x200d\x1faf2\x1f3fb"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fe\x200d\x1faf2\x1f3fc"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fe\x200d\x1faf2\x1f3fd"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3fe\x200d\x1faf2\x1f3ff"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3ff\x200d\x1faf2\x1f3fb"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3ff\x200d\x1faf2\x1f3fc"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3ff\x200d\x1faf2\x1f3fd"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x1faf1\x1f3ff\x200d\x1faf2\x1f3fe"), 5 }}, 
            { std::span { const_cast<char32_t*>(U"\x26d3\xfe0f\x200d\x1f4a5"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x2764\xfe0f\x200d\x1f525"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x2764\xfe0f\x200d\x1fa79"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c3\x200d\x27a1\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3c4\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x200d\x2640\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3ca\x200d\x2642\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3f3\xfe0f\x200d\x1f308"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f3f4\x200d\x2620\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f43b\x200d\x2744\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x2695\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x2696\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x200d\x2708\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fb\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fc\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fd\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3fe\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f468\x1f3ff\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x2695\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x2696\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x200d\x2708\xfe0f"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fb\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fc\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fd\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9b2"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9b3"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3fe\x200d\x1f9bd"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f33e"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f373"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f37c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f393"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f3a4"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f3a8"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f3eb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f3ed"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f4bb"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f4bc"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f527"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f52c"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f680"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f692"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f9af"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f9b0"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469\x1f3ff\x200d\x1f9b1"), 4 }}, 
            { std::span { const_cast<char32_t*>(U"\x1f469