/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMediaCapabilitiesDecodingInfo.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMGlobalObject.h"
#include "JSMediaDecodingConfiguration.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>



namespace WebCore {
using namespace JSC;

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const MediaCapabilitiesDecodingInfo& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto powerEfficientValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.powerEfficient);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "powerEfficient"_s), powerEfficientValue);
    auto smoothValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.smooth);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "smooth"_s), smoothValue);
    auto supportedValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.supported);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "supported"_s), supportedValue);
    if (jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext()->settingsValues().mediaCapabilitiesExtensionsEnabled) {
        auto configurationValue = toJS<IDLDictionary<MediaDecodingConfiguration>>(lexicalGlobalObject, globalObject, throwScope, dictionary.configuration);
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "configuration"_s), configurationValue);
    }
    return result;
}

} // namespace WebCore

