﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mwaa/MWAA_EXPORTS.h>

namespace Aws {
namespace MWAA {
namespace Model {
enum class Unit {
  NOT_SET,
  Seconds,
  Microseconds,
  Milliseconds,
  Bytes,
  Kilobytes,
  Megabytes,
  Gigabytes,
  Terabytes,
  Bits,
  Kilobits,
  Megabits,
  Gigabits,
  Terabits,
  Percent,
  Count,
  Bytes_Second,
  Kilobytes_Second,
  Megabytes_Second,
  Gigabytes_Second,
  Terabytes_Second,
  Bits_Second,
  Kilobits_Second,
  Megabits_Second,
  Gigabits_Second,
  Terabits_Second,
  Count_Second,
  None
};

namespace UnitMapper {
AWS_MWAA_API Unit GetUnitForName(const Aws::String& name);

AWS_MWAA_API Aws::String GetNameForUnit(Unit value);
}  // namespace UnitMapper
}  // namespace Model
}  // namespace MWAA
}  // namespace Aws
