/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.net.URISyntaxException;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;

public class URIHelper {
    private static final String PLATFORM_SCHEMA = "platform:/";
    private static final String BUNDLECLASS_SCHEMA = "bundleclass://";
    private static final String PLATFORM_SCHEMA_EMF = "platform";
    private static final String PLUGIN_SEGMENT = "plugin/";
    private static final String FRAGMENT_SEGMENT = "fragment/";

    public static String constructPlatformURI(Bundle bundle) {
        BundleRevision bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        if (bundleRevision == null) {
            return null;
        }
        StringBuilder tmp = new StringBuilder();
        tmp.append(PLATFORM_SCHEMA);
        if ((bundleRevision.getTypes() & 1) == 1) {
            tmp.append(FRAGMENT_SEGMENT);
        } else {
            tmp.append(PLUGIN_SEGMENT);
        }
        tmp.append(bundle.getSymbolicName());
        return tmp.toString();
    }

    public static String constructPlatformURI(IContributor contributor) {
        String bundleName = contributor instanceof RegistryContributor ? ((RegistryContributor)contributor).getActualName() : contributor.getName();
        Bundle bundle = Activator.getDefault().getBundleForName(bundleName);
        return URIHelper.constructPlatformURI(bundle);
    }

    public static Bundle getBundle(String contributorURI) {
        java.net.URI uri;
        try {
            uri = new java.net.URI(contributorURI);
        }
        catch (URISyntaxException e) {
            ILog.get().error("Invalid contributor URI: " + contributorURI);
            return null;
        }
        if (!PLATFORM_SCHEMA.equals(uri.getScheme())) {
            return null;
        }
        return Activator.getDefault().getBundleForName(uri.getPath());
    }

    public static String EMFtoPlatform(URI uri) {
        if (!PLATFORM_SCHEMA_EMF.equals(uri.scheme())) {
            return null;
        }
        int segments = uri.segmentCount();
        if (segments > 2) {
            uri = uri.trimSegments(segments - 2);
        }
        return uri.toString();
    }

    public static boolean isPlatformURI(String uri) {
        return uri != null && uri.startsWith(PLATFORM_SCHEMA);
    }

    public static boolean isBundleClassUri(String uri) {
        String[] split;
        return uri != null && uri.startsWith(BUNDLECLASS_SCHEMA) && (split = uri.substring(BUNDLECLASS_SCHEMA.length()).split("/")).length == 2;
    }
}

