/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.time;

import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jkiss.code.NotNull;

public class ExtendedDateFormat
extends SimpleDateFormat {
    private static final String NINE_ZEROES = "000000000";
    private static final int MAX_NANO_LENGTH = 8;
    private int nanoStart = -1;
    private int nanoLength;
    private boolean nanoOptional;
    private String nanoPrefix;
    private String nanoPostfix;

    public ExtendedDateFormat(@NotNull String pattern) {
        this(pattern, Locale.getDefault());
    }

    public ExtendedDateFormat(@NotNull String pattern, @NotNull Locale locale) {
        super(ExtendedDateFormat.stripNanos(pattern), locale);
        int quoteCount = 0;
        block0: for (int i = 0; i < pattern.length(); ++i) {
            int k;
            char c = pattern.charAt(i);
            if (c == '\'') {
                ++quoteCount;
                for (k = i + 1; k < pattern.length(); ++k) {
                    if (pattern.charAt(k) != '\'') continue;
                    if (k != i + 1) {
                        ++quoteCount;
                    }
                    i = k;
                    continue block0;
                }
                continue;
            }
            if (c == '[') {
                this.nanoStart = i;
                this.nanoOptional = true;
                for (k = i + 1; k < pattern.length(); ++k) {
                    if (pattern.charAt(k) == 'f' || pattern.charAt(k) == 'S') {
                        ++this.nanoLength;
                        if (this.nanoPrefix == null) {
                            this.nanoPrefix = pattern.substring(i + 1, k);
                        }
                    }
                    if (pattern.charAt(k) != ']') continue;
                    if (this.nanoPrefix == null) continue block0;
                    this.nanoPostfix = pattern.substring(i + 1 + this.nanoPrefix.length() + this.nanoLength, k);
                    i = k + 1;
                    continue block0;
                }
                continue;
            }
            if (c != 'f' && c != 'S') continue;
            this.nanoStart = i - quoteCount;
            this.nanoOptional = false;
            for (k = i + 1; k < pattern.length() && (pattern.charAt(k) == 'f' || pattern.charAt(k) == 'S'); ++k) {
                ++this.nanoLength;
            }
            ++this.nanoLength;
            i += this.nanoLength;
        }
    }

    @Override
    public StringBuffer format(@NotNull Date date, @NotNull StringBuffer toAppendTo, @NotNull FieldPosition pos) {
        StringBuffer result = super.format(date, toAppendTo, pos);
        if (this.nanoStart >= 0) {
            long nanos;
            if (date instanceof Timestamp) {
                nanos = ((Timestamp)date).getNanos();
            } else {
                nanos = date.getTime() % 1000L * 1000000L;
                if (nanos < 0L) {
                    nanos += 1000000000L;
                }
            }
            if (!this.nanoOptional || nanos > 0L) {
                Object nanoStr;
                int nbZeroesToPad;
                StringBuilder nanosRes = new StringBuilder(this.nanoLength);
                if (this.nanoPrefix != null) {
                    nanosRes.append(this.nanoPrefix);
                }
                if ((nbZeroesToPad = 9 - ((String)(nanoStr = String.valueOf(nanos))).length()) > 0) {
                    nanoStr = NINE_ZEROES.substring(0, nbZeroesToPad) + (String)nanoStr;
                }
                if (this.nanoLength < ((String)nanoStr).length()) {
                    nanoStr = ((String)nanoStr).substring(0, this.nanoLength);
                } else {
                    int padLength = this.nanoLength - ((String)nanoStr).length();
                    if (padLength > 0) {
                        nanosRes.append("0".repeat(padLength));
                    }
                }
                nanosRes.append((String)nanoStr);
                if (this.nanoPostfix != null) {
                    nanosRes.append(this.nanoPostfix);
                }
                result.insert(this.nanoStart, nanosRes);
            }
        }
        return result;
    }

    @Override
    public Date parse(@NotNull String text, @NotNull ParsePosition pos) {
        Date date = super.parse(text, pos);
        if (date == null) {
            return null;
        }
        int index = pos.getIndex();
        if (index < text.length() && this.nanoStart >= 0) {
            int digitPos;
            long nanos = 0L;
            if (this.nanoPrefix != null) {
                index += this.nanoPrefix.length();
            }
            for (int i = 0; i < this.nanoLength && (digitPos = index + i) != text.length(); ++i) {
                char c = text.charAt(digitPos);
                if (!Character.isDigit(c)) {
                    pos.setErrorIndex(index);
                    pos.setIndex(index);
                    return null;
                }
                long digit = c - 48;
                for (int k = 8 - i; k > 0; --k) {
                    digit *= 10L;
                }
                nanos += digit;
            }
            if (nanos > 0L) {
                Timestamp ts = new Timestamp(date.getTime());
                ts.setNanos((int)nanos);
                return ts;
            }
        }
        return date;
    }

    @NotNull
    private static String stripNanos(@NotNull String pattern) {
        block0: for (int i = 0; i < pattern.length(); ++i) {
            int k;
            char c = pattern.charAt(i);
            if (c == '\'') {
                for (k = i + 1; k < pattern.length(); ++k) {
                    if (pattern.charAt(k) != '\'') continue;
                    i = k;
                    continue block0;
                }
                continue;
            }
            if (c == '[') {
                for (k = i + 1; k < pattern.length(); ++k) {
                    if (pattern.charAt(k) != ']') continue;
                    return pattern.substring(0, i) + pattern.substring(k + 1);
                }
                continue;
            }
            if (c != 'f' && c != 'S') continue;
            for (k = i + 1; k < pattern.length(); ++k) {
                if (pattern.charAt(k) == 'f' || pattern.charAt(k) == 'S') continue;
                return pattern.substring(0, i) + pattern.substring(k);
            }
            return pattern.substring(0, i);
        }
        return pattern;
    }
}

