/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.label;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.label.LabelMgrPlugin;
import javax.swing.KeyStroke;

class AddLabelAction
extends ListingContextAction {
    private LabelMgrPlugin plugin;
    private static final String[] POPUP_PATH = new String[]{"Add Label..."};
    private static final KeyStroke KEYBINDING = KeyStroke.getKeyStroke(76, 0);

    AddLabelAction(LabelMgrPlugin plugin) {
        super("Add Label", plugin.getName());
        this.setPopupMenuData(new MenuData(POPUP_PATH, null, "Label"));
        this.setKeyBindingData(new KeyBindingData(KEYBINDING));
        this.plugin = plugin;
        this.setEnabled(true);
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        if (context.getAddress().isExternalAddress()) {
            return false;
        }
        int[] componentPath = context.getLocation().getComponentPath();
        if (componentPath != null && componentPath.length != 0) {
            return false;
        }
        return !this.plugin.isOnVariableReference(context) && !this.plugin.isOnSymbol(context) && !this.plugin.isOnFunction(context);
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        this.plugin.addLabelCallback(context);
    }
}

