/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype.microsoft;

import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;

public abstract class RTTIDataType
extends DynamicDataType {
    protected RTTIDataType(String name, DataTypeManager dtm) {
        super(name, dtm);
    }

    @Deprecated
    public boolean isValid(Program program, Address startAddress, boolean overwriteInstructions, boolean overwriteDefinedData) {
        return this.isValid(program, startAddress, this.convertValidationOptions(overwriteInstructions, overwriteDefinedData));
    }

    protected DataValidationOptions convertValidationOptions(boolean overwriteInstructions, boolean overwriteDefinedData) {
        DataValidationOptions validationOptions = new DataValidationOptions();
        validationOptions.setValidateReferredToData(true);
        validationOptions.setIgnoreInstructions(overwriteInstructions);
        validationOptions.setIgnoreDefinedData(overwriteDefinedData);
        return validationOptions;
    }

    public abstract boolean isValid(Program var1, Address var2, DataValidationOptions var3);

    boolean containsDefinedData(Listing listing, Address startAddress, Address endAddress) {
        Data data = listing.getDefinedDataAt(startAddress);
        if (data != null) {
            return true;
        }
        data = listing.getDefinedDataAfter(startAddress);
        return data != null && data.getMinAddress().compareTo((Object)endAddress) <= 0;
    }

    boolean containsInstruction(Listing listing, Address startAddress, Address endAddress) {
        Instruction instruction = listing.getInstructionAt(startAddress);
        if (instruction != null) {
            return true;
        }
        instruction = listing.getInstructionAfter(startAddress);
        return instruction != null && instruction.getMinAddress().compareTo((Object)endAddress) <= 0;
    }
}

