/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.format;

import docking.widgets.fieldpanel.support.RowLayout;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.SpacerFieldFactory;
import ghidra.app.util.viewer.format.FieldFactoryNameMapper;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.format.Row;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class FieldFormatModel {
    private static final Comparator<FieldFactory> COMPARATOR = new FieldFactoryComparator();
    public static final int DIVIDER = 0;
    public static final int PLATE = 1;
    public static final int FUNCTION = 2;
    public static final int FUNCTION_VARS = 3;
    public static final int INSTRUCTION_OR_DATA = 4;
    public static final int OPEN_DATA = 5;
    public static final int ARRAY = 6;
    private int baseRowID = 0;
    private FormatManager formatMgr;
    private String name;
    private int width;
    private List<Row> rows;
    protected FieldFactory[] factories;

    FieldFormatModel(FormatManager formatMgr, String name, int categoryID, Class<?> proxyObjectClass, FieldFactory[] factorys) {
        this.formatMgr = formatMgr;
        this.name = name;
        ArrayList<FieldFactory> list = new ArrayList<FieldFactory>(factorys.length);
        for (FieldFactory factory : factorys) {
            if (!factory.acceptsType(categoryID, proxyObjectClass)) continue;
            list.add(factory);
        }
        this.factories = new FieldFactory[list.size()];
        list.toArray(this.factories);
        this.rows = new ArrayList<Row>();
        this.rows.add(new Row());
    }

    public void setBaseRowID(int id) {
        this.baseRowID = id;
    }

    public void update() {
        this.formatMgr.update();
    }

    public FormatManager getFormatManager() {
        return this.formatMgr;
    }

    public void addLayouts(List<RowLayout> list, int index, ProxyObj<?> proxy) {
        int n = this.rows.size();
        for (int i = 0; i < n; ++i) {
            Row row = this.rows.get(i);
            RowLayout l = row.getLayout(index, proxy, this.baseRowID + i);
            if (l == null) continue;
            list.add(l);
        }
    }

    public void addRow(int index) {
        if (this.rows.size() <= 11) {
            this.rows.add(index, new Row());
            this.findWidth();
            this.formatMgr.modelChanged(this);
        } else {
            Msg.showWarn((Object)this, null, (String)"Too Many Rows", (Object)"Too Many Rows");
        }
    }

    public void removeRow(int index) {
        this.rows.remove(index);
        if (this.rows.isEmpty()) {
            this.rows.add(new Row());
        }
        this.findWidth();
        this.formatMgr.modelChanged(this);
    }

    private void findWidth() {
        this.width = 0;
        for (int i = 0; i < this.rows.size(); ++i) {
            this.width = Math.max(this.width, this.rows.get((int)i).width);
        }
    }

    public void addFactory(FieldFactory factory, int rowIndex, int colIndex) {
        ListingHighlightProvider hsProvider = this.formatMgr.getFormatHighlightProvider();
        ToolOptions displayOptions = this.formatMgr.getDisplayOptions();
        ToolOptions fieldOptions = this.formatMgr.getFieldOptions();
        FieldFactory ff = factory.newInstance(this, hsProvider, displayOptions, fieldOptions);
        if (rowIndex == this.rows.size()) {
            this.rows.add(new Row());
        }
        Row row = this.rows.get(rowIndex);
        row.insertField(ff, colIndex);
        this.findWidth();
        this.formatMgr.modelChanged(this);
    }

    public void removeFactory(int rowIndex, int colIndex) {
        Row row = this.rows.get(rowIndex);
        row.removeField(colIndex);
        this.findWidth();
        this.formatMgr.modelChanged(this);
    }

    public void modelChanged() {
        this.formatMgr.modelChanged(this);
    }

    public int getNumRows() {
        return this.rows.size();
    }

    public String getName() {
        return this.name;
    }

    public int getNumFactorys(int row) {
        if (row < 0 || row >= this.rows.size()) {
            return 0;
        }
        return this.rows.get(row).size();
    }

    public FieldFactory[] getFactorys(int row) {
        return this.rows.get(row).getFactorys();
    }

    public FieldFactory[] getFactorys() {
        return (FieldFactory[])this.factories.clone();
    }

    public void moveFactory(int oldRowIndex, int oldColIndex, int newRowIndex, int newColIndex) {
        if (oldRowIndex < 0 || oldRowIndex >= this.rows.size() || newRowIndex < 0 || newRowIndex >= this.rows.size()) {
            return;
        }
        Row oldRow = this.rows.get(oldRowIndex);
        Row newRow = this.rows.get(newRowIndex);
        if (oldColIndex < 0 || oldColIndex > oldRow.size() - 1 || newColIndex < 0 || newColIndex > newRow.size()) {
            return;
        }
        FieldFactory ff = oldRow.removeField(oldColIndex);
        newRow.insertField(ff, newColIndex);
        this.findWidth();
        this.formatMgr.modelChanged(this);
    }

    public int getWidth() {
        return this.width;
    }

    public void updateRow(int index) {
        Row row = this.rows.get(index);
        row.layoutFields();
        this.findWidth();
        this.formatMgr.modelChanged(this);
    }

    public void servicesChanged() {
        for (int i = 0; i < this.rows.size(); ++i) {
            Row row = this.rows.get(i);
            row.servicesChanged();
        }
    }

    public Element saveToXml() {
        Element root = new Element("FORMAT");
        for (int i = 0; i < this.rows.size(); ++i) {
            FieldFactory[] rowFactorys;
            Element rowElem = new Element("ROW");
            Row row = this.rows.get(i);
            for (FieldFactory ff : rowFactorys = row.getFactorys()) {
                Element colElem = new Element("FIELD");
                if (ff instanceof SpacerFieldFactory) {
                    SpacerFieldFactory sff = (SpacerFieldFactory)ff;
                    String text = sff.getText();
                    if (text != null) {
                        colElem.setAttribute("TEXT", text);
                    }
                } else {
                    colElem.setAttribute("NAME", ff.getFieldName());
                }
                colElem.setAttribute("WIDTH", "" + ff.getWidth());
                colElem.setAttribute("ENABLED", "" + ff.isEnabled());
                rowElem.addContent((Content)colElem);
            }
            root.addContent((Content)rowElem);
        }
        return root;
    }

    public void restoreFromXml(Element root) {
        List list = root.getChildren("ROW");
        Iterator rowIter = list.iterator();
        this.rows = new ArrayList<Row>(list.size());
        while (rowIter.hasNext()) {
            Row row = this.createRow((Element)rowIter.next());
            this.rows.add(row);
        }
        this.findWidth();
        this.formatMgr.modelChanged(this);
    }

    private Row createRow(Element rowElement) {
        Row row = new Row();
        for (Element colElem : rowElement.getChildren("FIELD")) {
            String fieldName = colElem.getAttributeValue("NAME");
            String text = colElem.getAttributeValue("TEXT");
            String fieldWidth = colElem.getAttributeValue("WIDTH");
            String enabled = colElem.getAttributeValue("ENABLED");
            FieldFactory factoryPrototype = FieldFactoryNameMapper.getFactoryPrototype(fieldName, this.factories);
            FieldFactory newInstance = this.getNewFieldFactoryInstance(factoryPrototype, text);
            try {
                newInstance.setWidth(Integer.parseInt(fieldWidth));
            }
            catch (Exception exc) {
                Msg.error((Object)this, (Object)("Unparsable format for element 'fieldWidth' - '" + fieldWidth + "': " + exc.getMessage()), (Throwable)exc);
            }
            try {
                newInstance.setEnabled(Boolean.valueOf(enabled));
            }
            catch (Exception exc) {
                Msg.error((Object)this, (Object)("Unparsable format for element 'enabled' - '" + enabled + "': " + exc.getMessage()), (Throwable)exc);
            }
            row.addField(newInstance);
        }
        return row;
    }

    private FieldFactory getNewFieldFactoryInstance(FieldFactory factoryPrototype, String text) {
        if (factoryPrototype != null) {
            return factoryPrototype.newInstance(this, this.formatMgr.getFormatHighlightProvider(), this.formatMgr.getDisplayOptions(), this.formatMgr.getFieldOptions());
        }
        return new SpacerFieldFactory(text, this, this.formatMgr.getFormatHighlightProvider(), (Options)this.formatMgr.getDisplayOptions(), (Options)this.formatMgr.getFieldOptions());
    }

    public void addAllFactories() {
        FieldFactory[] unusedFactorys;
        for (FieldFactory unusedFactory : unusedFactorys = this.getUnusedFactories()) {
            this.addFactory(unusedFactory, 0, 0);
        }
        this.findWidth();
        this.formatMgr.modelChanged(this);
    }

    public FieldFactory[] getUnusedFactories() {
        ArrayList<FieldFactory> list = new ArrayList<FieldFactory>(Arrays.asList(this.factories));
        for (int i = 0; i < this.rows.size(); ++i) {
            FieldFactory[] rowFactorys;
            Row row = this.rows.get(i);
            block1: for (FieldFactory rowFactory : rowFactorys = row.getFactorys()) {
                Class<?> c = rowFactory.getClass();
                for (int k = 0; k < list.size(); ++k) {
                    if (!c.equals(((FieldFactory)list.get(k)).getClass())) continue;
                    list.remove(k);
                    continue block1;
                }
            }
        }
        return list.toArray(new FieldFactory[list.size()]);
    }

    public FieldFactory[] getAllFactories() {
        ArrayList<FieldFactory> arrayBackedList = new ArrayList<FieldFactory>(Arrays.asList(this.factories));
        Collections.sort(arrayBackedList, COMPARATOR);
        return arrayBackedList.toArray(new FieldFactory[this.factories.length]);
    }

    public void removeAllFactories() {
        for (int i = 0; i < this.rows.size(); ++i) {
            Row row = this.rows.get(i);
            while (row.size() > 0) {
                row.removeField(0);
            }
        }
        this.findWidth();
        this.formatMgr.modelChanged(this);
    }

    public void displayOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        for (Row row : this.rows) {
            row.displayOptionsChanged(options, optionName, oldValue, newValue);
        }
    }

    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        for (Row row : this.rows) {
            row.fieldOptionsChanged(options, optionName, oldValue, newValue);
        }
    }

    private static class FieldFactoryComparator
    implements Comparator<FieldFactory> {
        private FieldFactoryComparator() {
        }

        @Override
        public int compare(FieldFactory f1, FieldFactory f2) {
            return f1.getFieldName().compareTo(f2.getFieldName());
        }
    }
}

