/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.dialogs;

import docking.DialogComponentProvider;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GHtmlLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;

public class InputWithChoicesDialog
extends DialogComponentProvider {
    private boolean isCanceled;
    private GhidraComboBox<String> combo;
    private boolean allowEdits;

    public InputWithChoicesDialog(String dialogTitle, String label, String[] optionValues, String initialValue, Icon messageIcon) {
        super(dialogTitle, true, false, true, false);
        this.setTransient(true);
        this.addOKButton();
        this.addCancelButton();
        this.setRememberSize(false);
        this.setRememberLocation(false);
        this.buildMainPanel(label, optionValues, initialValue, messageIcon);
        this.setFocusComponent(this.combo);
    }

    public InputWithChoicesDialog(String dialogTitle, String label, String[] optionValues, String initialValue, boolean allowEdits, Icon messageIcon) {
        super(dialogTitle, true, false, true, false);
        this.addOKButton();
        this.addCancelButton();
        this.setRememberSize(false);
        this.setRememberLocation(false);
        this.allowEdits = allowEdits;
        this.buildMainPanel(label, optionValues, initialValue, messageIcon);
        this.setFocusComponent(this.combo);
    }

    @Override
    protected void dialogShown() {
        this.combo.requestFocusInWindow();
    }

    private void buildMainPanel(String labelText, String[] optionValues, String initialValue, Icon messageIcon) {
        JPanel workPanel = new JPanel(new BorderLayout());
        workPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GHtmlLabel messageLabel = new GHtmlLabel(labelText);
        messageLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        messageLabel.getAccessibleContext().setAccessibleName("Message");
        this.combo = this.createComboBox(optionValues, initialValue);
        this.combo.getAccessibleContext().setAccessibleName("Options");
        JPanel dataPanel = new JPanel(new BorderLayout());
        dataPanel.add((Component)messageLabel, "North");
        dataPanel.add(this.combo, "South");
        dataPanel.getAccessibleContext().setAccessibleName("Data");
        workPanel.add((Component)dataPanel, "Center");
        if (messageIcon != null) {
            GDLabel iconLabel = new GDLabel();
            iconLabel.setIcon(messageIcon);
            iconLabel.setVerticalAlignment(1);
            iconLabel.getAccessibleContext().setAccessibleName("Icon");
            JPanel separatorPanel = new JPanel();
            separatorPanel.setPreferredSize(new Dimension(15, 1));
            separatorPanel.getAccessibleContext().setAccessibleName("Separator");
            JPanel iconPanel = new JPanel(new BorderLayout());
            iconPanel.add((Component)iconLabel, "Center");
            iconPanel.add((Component)separatorPanel, "East");
            iconPanel.getAccessibleContext().setAccessibleName("Icon");
            workPanel.add((Component)iconPanel, "West");
        }
        workPanel.getAccessibleContext().setAccessibleName("Input With Choices");
        this.addWorkPanel(workPanel);
    }

    private GhidraComboBox<String> createComboBox(String[] optionValues, String initialValue) {
        GhidraComboBox<String> newComboBox = new GhidraComboBox<String>(optionValues);
        newComboBox.setEditable(this.allowEdits);
        newComboBox.addActionListener(e -> this.okCallback());
        if (initialValue != null) {
            newComboBox.setSelectedItem(initialValue);
        }
        newComboBox.getAccessibleContext().setAccessibleName("Options");
        return newComboBox;
    }

    @Override
    protected void okCallback() {
        this.isCanceled = false;
        this.close();
    }

    @Override
    protected void cancelCallback() {
        this.isCanceled = true;
        this.close();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public String getValue() {
        if (this.isCanceled) {
            return null;
        }
        if (this.allowEdits) {
            return this.combo.getText();
        }
        Object selectedItem = this.combo.getSelectedItem();
        return selectedItem == null ? null : selectedItem.toString();
    }

    public void setValue(String value) {
        this.combo.setSelectedItem(value);
        if (!this.combo.isEditable() && !this.combo.getSelectedItem().equals(value)) {
            throw new NoSuchElementException();
        }
    }
}

