/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.numberformat;

import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.NumberFormatter;

class BoundedRangeDecimalFormatter
extends NumberFormatter {
    private DocumentFilter myDocumentFilter = null;
    private final Double upperRangeValue;
    private final Double lowerRangeValue;

    BoundedRangeDecimalFormatter(Double upperRangeValue, Double lowerRangeValue, String numberFormat) {
        this.upperRangeValue = upperRangeValue;
        this.lowerRangeValue = lowerRangeValue;
        DecimalFormat decimalFormat = new DecimalFormat(numberFormat);
        this.setFormat(decimalFormat);
        this.setValueClass(Double.class);
        this.setAllowsInvalid(true);
    }

    @Override
    protected DocumentFilter getDocumentFilter() {
        if (this.myDocumentFilter == null) {
            this.myDocumentFilter = new BoundedRangeDocumentFilterWrapper(super.getDocumentFilter());
        }
        return this.myDocumentFilter;
    }

    private class BoundedRangeDocumentFilterWrapper
    extends DocumentFilter {
        private final DocumentFilter wrappedFilter;

        BoundedRangeDocumentFilterWrapper(DocumentFilter wrappedFilter) {
            this.wrappedFilter = wrappedFilter;
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            StringBuilder buildy = new StringBuilder();
            Document document = fb.getDocument();
            buildy.append(document.getText(0, document.getLength()));
            buildy.delete(offset, offset + length);
            if (!this.isValidText(buildy.toString())) {
                this.warn();
                return;
            }
            this.wrappedFilter.remove(fb, offset, length);
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            StringBuilder buildy = new StringBuilder();
            Document document = fb.getDocument();
            buildy.append(document.getText(0, document.getLength()));
            buildy.insert(offset, string);
            if (!this.isValidText(buildy.toString())) {
                this.warn();
                return;
            }
            this.wrappedFilter.insertString(fb, offset, string, attr);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attr) throws BadLocationException {
            StringBuilder buildy = new StringBuilder();
            Document document = fb.getDocument();
            buildy.append(document.getText(0, document.getLength()));
            buildy.replace(offset, offset + length, text);
            if (!this.isValidText(buildy.toString())) {
                this.warn();
                return;
            }
            this.wrappedFilter.replace(fb, offset, length, text, attr);
        }

        private boolean isValidText(String text) {
            if (".".equals(text) || "".equals(text)) {
                return true;
            }
            if (text.equals("-") && BoundedRangeDecimalFormatter.this.lowerRangeValue < 0.0) {
                return true;
            }
            if (this.containsNonNumericCharacters(text)) {
                return false;
            }
            Format format = BoundedRangeDecimalFormatter.this.getFormat();
            try {
                Object parseObject = format.parseObject(text);
                if (!(parseObject instanceof Number)) {
                    return false;
                }
                Number number = (Number)parseObject;
                Double doubleValue = number.doubleValue();
                return doubleValue.compareTo(BoundedRangeDecimalFormatter.this.upperRangeValue) <= 0 && doubleValue.compareTo(BoundedRangeDecimalFormatter.this.lowerRangeValue) >= 0;
            }
            catch (ParseException e) {
                return false;
            }
        }

        private boolean containsNonNumericCharacters(String text) {
            int length = text.length();
            boolean seenDot = false;
            for (int i = 0; i < length; ++i) {
                char theChar = text.charAt(i);
                if ('.' == theChar && !seenDot) {
                    seenDot = true;
                    continue;
                }
                if (this.isDigit(theChar) || this.isNegative(i, theChar)) continue;
                return true;
            }
            return false;
        }

        private boolean isNegative(int i, char theChar) {
            if (i != 0) {
                return false;
            }
            return theChar == '-';
        }

        protected boolean isDigit(char character) {
            return Character.isDigit(character);
        }

        private void warn() {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

