/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.trace.database.data.DBTraceDataSettingsOperations;
import ghidra.trace.database.listing.DBTraceCodeUnitAdapter;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.symbol.TraceReference;
import ghidra.trace.util.DataAdapterFromDataType;
import ghidra.trace.util.DataAdapterFromSettings;
import ghidra.trace.util.DataAdapterMinimal;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import java.util.Collection;

public interface DBTraceDataAdapter
extends DBTraceCodeUnitAdapter,
DataAdapterMinimal,
DataAdapterFromDataType,
DataAdapterFromSettings,
TraceData {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public DBTraceDataAdapter getRoot();

    @Override
    default public TraceReference[] getValueReferences() {
        try (LockHold hold = this.getTrace().lockRead();){
            TraceReference[] traceReferenceArray = (TraceReference[])DataAdapterMinimal.super.getValueReferences();
            return traceReferenceArray;
        }
    }

    default public void addValueReference(Address refAddr, RefType type) {
        try (LockHold hold = this.getTrace().lockWrite();){
            this.getTrace().getReferenceManager().addMemoryReference(this.getLifespan(), this.getAddress(), refAddr, type, SourceType.USER_DEFINED, 0);
        }
    }

    default public void removeValueReference(Address refAddr) {
        try (LockHold hold = this.getTrace().lockWrite();){
            TraceReference ref = this.getTrace().getReferenceManager().getReference(this.getStartSnap(), this.getAddress(), refAddr, 0);
            if (ref == null) {
                return;
            }
            ref.delete();
        }
    }

    public DBTraceDataSettingsOperations getSettingsSpace(boolean var1);

    default public boolean isChangeAllowed(SettingsDefinition settingsDefinition) {
        if (settingsDefinition instanceof TypeDefSettingsDefinition) {
            return false;
        }
        return this.getDefaultSettings().isChangeAllowed(settingsDefinition);
    }

    default public void setLong(String name, long value) {
        try (LockHold hold = this.getTrace().lockWrite();){
            this.getSettingsSpace(true).setLong(this.getLifespan(), this.getAddress(), name, value);
        }
        this.getTrace().setChanged(new TraceChangeRecord<TraceAddressSnapRange, Object>(TraceEvents.CODE_DATA_SETTINGS_CHANGED, this.getAddressSpace(), this.getBounds(), null, null));
    }

    default public Long getLong(String name) {
        try (LockHold hold = this.getTrace().lockRead();){
            Long value;
            DBTraceDataSettingsOperations space = this.getSettingsSpace(false);
            if (space != null && (value = space.getLong(this.getStartSnap(), this.getAddress(), name)) != null) {
                Long l = value;
                return l;
            }
            Settings defaultSettings = this.getDefaultSettings();
            Long l = defaultSettings == null ? null : defaultSettings.getLong(name);
            return l;
        }
    }

    default public void setString(String name, String value) {
        try (LockHold hold = this.getTrace().lockWrite();){
            this.getSettingsSpace(true).setString(this.getLifespan(), this.getAddress(), name, value);
        }
        this.getTrace().setChanged(new TraceChangeRecord<TraceAddressSnapRange, Object>(TraceEvents.CODE_DATA_SETTINGS_CHANGED, this.getAddressSpace(), this.getBounds(), null, null));
    }

    default public String getString(String name) {
        try (LockHold hold = this.getTrace().lockRead();){
            String value;
            DBTraceDataSettingsOperations space = this.getSettingsSpace(false);
            if (space != null && (value = space.getString(this.getStartSnap(), this.getAddress(), name)) != null) {
                String string = value;
                return string;
            }
            Settings defaultSettings = this.getDefaultSettings();
            String string = defaultSettings == null ? null : defaultSettings.getString(name);
            return string;
        }
    }

    default public void setValue(String name, Object value) {
        try (LockHold hold = this.getTrace().lockWrite();){
            this.getSettingsSpace(true).setValue(this.getLifespan(), this.getAddress(), name, value);
        }
        this.getTrace().setChanged(new TraceChangeRecord<TraceAddressSnapRange, Object>(TraceEvents.CODE_DATA_SETTINGS_CHANGED, this.getAddressSpace(), this.getBounds(), null, null));
    }

    default public Object getValue(String name) {
        try (LockHold hold = this.getTrace().lockRead();){
            Object value;
            DBTraceDataSettingsOperations space = this.getSettingsSpace(false);
            if (space != null && (value = space.getValue(this.getStartSnap(), this.getAddress(), name)) != null) {
                Object object = value;
                return object;
            }
            Settings defaultSettings = this.getDefaultSettings();
            Object object = defaultSettings == null ? null : defaultSettings.getValue(name);
            return object;
        }
    }

    default public void clearSetting(String name) {
        try (LockHold hold = this.getTrace().lockWrite();){
            DBTraceDataSettingsOperations space = this.getSettingsSpace(false);
            if (space == null) {
                return;
            }
            space.clear(this.getLifespan(), this.getAddress(), name);
        }
        this.getTrace().setChanged(new TraceChangeRecord<TraceAddressSnapRange, Object>(TraceEvents.CODE_DATA_SETTINGS_CHANGED, this.getAddressSpace(), this.getBounds(), null, null));
    }

    default public void clearAllSettings() {
        try (LockHold hold = this.getTrace().lockWrite();){
            DBTraceDataSettingsOperations space = this.getSettingsSpace(false);
            if (space == null) {
                return;
            }
            space.clear(this.getLifespan(), this.getAddress(), null);
        }
        this.getTrace().setChanged(new TraceChangeRecord<TraceAddressSnapRange, Object>(TraceEvents.CODE_DATA_SETTINGS_CHANGED, this.getAddressSpace(), this.getBounds(), null, null));
    }

    default public String[] getNames() {
        try (LockHold hold = this.getTrace().lockRead();){
            DBTraceDataSettingsOperations space = this.getSettingsSpace(false);
            if (space == null) {
                String[] stringArray = EMPTY_STRING_ARRAY;
                return stringArray;
            }
            Collection<String> names = space.getSettingNames(this.getLifespan(), this.getAddress());
            String[] stringArray = names.toArray(new String[names.size()]);
            return stringArray;
        }
    }

    default public boolean isEmpty() {
        try (LockHold hold = this.getTrace().lockRead();){
            DBTraceDataSettingsOperations space = this.getSettingsSpace(false);
            if (space == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = space.isEmpty(this.getLifespan(), this.getAddress());
            return bl;
        }
    }

    @Override
    default public <T extends SettingsDefinition> T getSettingsDefinition(Class<T> settingsDefinitionClass) {
        try (LockHold hold = this.getTrace().lockRead();){
            T t = DataAdapterFromSettings.super.getSettingsDefinition(settingsDefinitionClass);
            return t;
        }
    }

    @Override
    default public boolean hasMutability(int mutabilityType) {
        try (LockHold hold = this.getTrace().lockRead();){
            boolean bl = DataAdapterFromSettings.super.hasMutability(mutabilityType);
            return bl;
        }
    }

    @Override
    public DBTraceDataAdapter getPrimitiveAt(int var1);
}

