/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.subLayout;

import com.google.common.base.Preconditions;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Collection;
import java.util.logging.Logger;

public class GraphCollapser {
    private static final Logger logger = Logger.getLogger(GraphCollapser.class.getClass().getName());
    private Graph originalGraph;

    public GraphCollapser(Graph originalGraph) {
        this.originalGraph = originalGraph;
    }

    Graph createGraph() throws InstantiationException, IllegalAccessException {
        return (Graph)this.originalGraph.getClass().newInstance();
    }

    public Graph collapse(Graph inGraph, Graph clusterGraph) {
        if (clusterGraph.getVertexCount() < 2) {
            return inGraph;
        }
        Graph graph = inGraph;
        try {
            graph = this.createGraph();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Collection cluster = clusterGraph.getVertices();
        for (Object v : inGraph.getVertices()) {
            if (cluster.contains(v)) continue;
            graph.addVertex(v);
        }
        graph.addVertex(clusterGraph);
        for (Object e : inGraph.getEdges()) {
            Pair endpoints = inGraph.getEndpoints(e);
            if (cluster.containsAll(endpoints)) continue;
            if (cluster.contains(endpoints.getFirst())) {
                graph.addEdge(e, clusterGraph, endpoints.getSecond(), inGraph.getEdgeType(e));
                continue;
            }
            if (cluster.contains(endpoints.getSecond())) {
                graph.addEdge(e, endpoints.getFirst(), clusterGraph, inGraph.getEdgeType(e));
                continue;
            }
            graph.addEdge(e, endpoints.getFirst(), endpoints.getSecond(), inGraph.getEdgeType(e));
        }
        return graph;
    }

    public Graph expand(Graph inGraph, Graph clusterGraph) {
        Pair endpoints;
        Graph graph = inGraph;
        try {
            graph = this.createGraph();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Collection cluster = clusterGraph.getVertices();
        logger.fine("cluster to expand is " + cluster);
        for (Object v : cluster) {
            graph.addVertex(v);
            for (Object edge : clusterGraph.getIncidentEdges(v)) {
                endpoints = clusterGraph.getEndpoints(edge);
                graph.addEdge(edge, endpoints.getFirst(), endpoints.getSecond(), clusterGraph.getEdgeType(edge));
            }
        }
        for (Object v : inGraph.getVertices()) {
            if (v.equals(clusterGraph)) continue;
            graph.addVertex(v);
        }
        for (Object v : inGraph.getVertices()) {
            if (v.equals(clusterGraph)) continue;
            for (Object edge : inGraph.getIncidentEdges(v)) {
                endpoints = inGraph.getEndpoints(edge);
                Object v1 = endpoints.getFirst();
                Object v2 = endpoints.getSecond();
                if (cluster.containsAll(endpoints)) continue;
                if (clusterGraph.equals(v1)) {
                    Object originalV1 = this.originalGraph.getEndpoints(edge).getFirst();
                    Object newV1 = this.findVertex(graph, originalV1);
                    Preconditions.checkState((newV1 != null ? 1 : 0) != 0, (Object)("newV1 for " + originalV1 + " was not found!"));
                    graph.addEdge(edge, newV1, v2, inGraph.getEdgeType(edge));
                    continue;
                }
                if (clusterGraph.equals(v2)) {
                    Object originalV2 = this.originalGraph.getEndpoints(edge).getSecond();
                    Object newV2 = this.findVertex(graph, originalV2);
                    Preconditions.checkState((newV2 != null ? 1 : 0) != 0, (Object)("newV2 for " + originalV2 + " was not found!"));
                    graph.addEdge(edge, v1, newV2, inGraph.getEdgeType(edge));
                    continue;
                }
                graph.addEdge(edge, v1, v2, inGraph.getEdgeType(edge));
            }
        }
        return graph;
    }

    Object findVertex(Graph inGraph, Object vertex) {
        Collection vertices = inGraph.getVertices();
        if (vertices.contains(vertex)) {
            return vertex;
        }
        for (Object v : vertices) {
            Graph g;
            if (!(v instanceof Graph) || !this.contains(g = (Graph)v, vertex)) continue;
            return v;
        }
        return null;
    }

    private boolean contains(Graph inGraph, Object vertex) {
        boolean contained = false;
        if (inGraph.getVertices().contains(vertex)) {
            return true;
        }
        for (Object v : inGraph.getVertices()) {
            if (!(v instanceof Graph)) continue;
            contained |= this.contains((Graph)v, vertex);
        }
        return contained;
    }

    public Graph getClusterGraph(Graph inGraph, Collection picked) {
        Graph clusterGraph;
        try {
            clusterGraph = this.createGraph();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        for (Object v : picked) {
            clusterGraph.addVertex(v);
            Collection edges = inGraph.getIncidentEdges(v);
            for (Object edge : edges) {
                Pair endpoints = inGraph.getEndpoints(edge);
                Object v1 = endpoints.getFirst();
                Object v2 = endpoints.getSecond();
                if (!picked.containsAll(endpoints)) continue;
                clusterGraph.addEdge(edge, v1, v2, inGraph.getEdgeType(edge));
            }
        }
        return clusterGraph;
    }
}

