/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validator;

import java.util.List;
import org.keycloak.models.RealmModel;
import org.keycloak.services.validation.Validation;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class RegistrationEmailAsUsernameUsernameValueValidator
implements SimpleValidator {
    public static final String ID = "up-registration-email-as-username-username-value";

    public String getId() {
        return ID;
    }

    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        RealmModel realm = context.getSession().getContext().getRealm();
        if (!realm.isRegistrationEmailAsUsername()) {
            return context;
        }
        List values = (List)input;
        if (values == null || values.isEmpty()) {
            return context;
        }
        String value = (String)values.get(0);
        if (value != null && Validation.isBlank(value)) {
            context.addError(new ValidationError(ID, inputHint, "missingUsernameMessage"));
        }
        return context;
    }
}

