/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.test;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;

public class AssertionHelper {
    static void shouldHaveCompleted(boolean completed, Throwable failure, List<?> items) {
        if (completed) {
            return;
        }
        if (failure != null) {
            AssertionHelper.fail("%nExpected a completion event, but received a failure event <%s>:%n<%s>", failure, AssertionHelper.getStackTrace(failure));
        } else if (items != null && !items.isEmpty()) {
            AssertionHelper.fail("%nExpected a completion event, but didn't received it.%nThe subscriber received item events:%n<%s>", AssertionHelper.getItemList(items));
        } else {
            AssertionHelper.fail("%nExpected a completion event, but didn't received it.", new Object[0]);
        }
    }

    static void shouldHaveFailed(boolean completed, Throwable failure, Class<?> expectedFailureType, String expectedMessage) {
        if (completed) {
            AssertionHelper.fail("%nExpected a failure event, but instead got a completion event.", new Object[0]);
        } else if (failure == null) {
            AssertionHelper.fail("%nExpected a failure event, but didn't received it. It didn't receive a completion event either.", new Object[0]);
        }
        if (expectedFailureType != null && !expectedFailureType.isInstance(failure)) {
            AssertionHelper.fail("%nReceived a failure event, but expecting:%n  <%s>%nto be an instance of:%n  <%s>%nbut was:%n  <%s>", failure, expectedFailureType, AssertionHelper.getStackTrace(failure));
        }
        if (expectedMessage != null) {
            String msg = failure.getMessage();
            if (msg == null) {
                AssertionHelper.fail("%nReceived a failure event, but expecting:%n  <%s>%nto contain:%n  <%s>%nbut was:%n  <%s>", msg, expectedMessage, AssertionHelper.getStackTrace(failure));
            } else if (!msg.contains(expectedMessage)) {
                AssertionHelper.fail("%nReceived a failure event, but expecting:%n  <%s>%nto contain:%n  <%s>%nbut was:%n  <%s>", msg, expectedMessage, AssertionHelper.getStackTrace(failure));
            }
        }
    }

    static void shouldHaveReceivedNoItems(List<?> items) {
        if (!items.isEmpty()) {
            AssertionHelper.fail("%nExpected no item events but received %d items:%n<%s>", items.size(), AssertionHelper.getItemList(items));
        }
    }

    static void shouldBeSubscribed(int numberOfSubscriptions) {
        if (numberOfSubscriptions == 0) {
            AssertionHelper.fail("%nExpected having a subscription, but didn't received it.", new Object[0]);
        }
        if (numberOfSubscriptions > 1) {
            AssertionHelper.fail("%nExpected a single subscription, but received %d subscriptions.", numberOfSubscriptions);
        }
    }

    static void shouldNotBeSubscribed(int numberOfSubscriptions) {
        if (numberOfSubscriptions != 0) {
            AssertionHelper.fail("%nExpected no subscription, but received %d subscriptions.", numberOfSubscriptions);
        }
    }

    static void shouldNotBeTerminated(boolean completed, Throwable failure) {
        if (completed) {
            AssertionHelper.fail("%nExpected no terminal event, but received a completion event.", new Object[0]);
        } else if (failure != null) {
            AssertionHelper.fail("%nExpected no terminal event, but received a failure event: <%s>:%n<%s>", failure, AssertionHelper.getStackTrace(failure));
        }
    }

    static void shouldNotBeTerminatedUni(boolean completed, Throwable failure) {
        if (completed) {
            AssertionHelper.fail("%nExpected no terminal event, but received a completion event.", new Object[0]);
        } else if (failure != null && !(failure instanceof CancellationException)) {
            AssertionHelper.fail("%nExpected no terminal event, but received a failure event: <%s>:%n<%s>", failure, AssertionHelper.getStackTrace(failure));
        }
    }

    static void shouldBeTerminated(boolean completed, Throwable failure) {
        if (!completed && failure == null) {
            AssertionHelper.fail("%nExpected a terminal event (either a completion or failure event), but didn't received any.", new Object[0]);
        }
    }

    static void shouldHaveReceived(Object item, Object expected) {
        if (item != null && expected == null) {
            AssertionHelper.fail("%nExpected `null` but received <%s>", item);
        } else if (item == null && expected != null) {
            AssertionHelper.fail("%nExpected <%s> but received `null`", expected);
        } else if (item != null && !item.equals(expected)) {
            AssertionHelper.fail("%nExpected <%s> but received <%s>", expected, item);
        }
    }

    static void shouldHaveReceivedExactly(List<?> items, Object[] expected) {
        LinkedHashMap<Object, Object> missed = new LinkedHashMap<Object, Object>();
        ArrayList extra = new ArrayList();
        Iterator<?> iterator = items.iterator();
        for (Object o : expected) {
            if (!iterator.hasNext()) {
                missed.put(o, null);
                continue;
            }
            Object received = iterator.next();
            if (received.equals(o)) continue;
            missed.put(o, received);
        }
        while (iterator.hasNext()) {
            extra.add(iterator.next());
        }
        if (missed.isEmpty() && extra.isEmpty()) {
            return;
        }
        if (!missed.isEmpty()) {
            AssertionHelper.fail("%nExpected to have received exactly:%n<%s>%nbut received:%n<%s>.%nMismatches are:%n%s", AssertionHelper.getItemList(expected), AssertionHelper.getItemList(items), AssertionHelper.getMismatches(missed));
        }
        AssertionHelper.fail("%nExpected to have received exactly%n<%s>%nbut received%n<%s>.%nThe following items were not expected:%n<%s>", AssertionHelper.getItemList(expected), AssertionHelper.getItemList(items), AssertionHelper.getItemList(extra));
    }

    private static void fail(String msg, Object ... params) {
        throw new AssertionError((Object)String.format(msg, params));
    }

    private static String getItemList(List<?> items) {
        List strings = items.stream().map(Object::toString).collect(Collectors.toList());
        return String.join((CharSequence)",", strings);
    }

    private static String getItemList(Object[] items) {
        List strings = Arrays.stream(items).map(Object::toString).collect(Collectors.toList());
        return String.join((CharSequence)",", strings);
    }

    private static String getMismatches(Map<Object, Object> mismatches) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : mismatches.entrySet()) {
            if (!builder.isEmpty()) {
                builder.append("\n");
            }
            if (entry.getValue() == null) {
                builder.append("\t").append("- Missing expected item <").append(entry.getKey()).append(">");
                continue;
            }
            builder.append("\t").append("- Expected <").append(entry.getValue()).append("> to be equal to <").append(entry.getKey()).append(">");
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStackTrace(Throwable throwable) {
        String result;
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter((Writer)sw, true);
            throwable.printStackTrace(pw);
            result = sw.getBuffer().toString();
        }
        catch (Throwable throwable2) {
            AssertionHelper.closeQuietly(sw);
            AssertionHelper.closeQuietly(pw);
            throw throwable2;
        }
        AssertionHelper.closeQuietly(sw);
        AssertionHelper.closeQuietly(pw);
        return result;
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

