@echo off
@setlocal EnableDelayedExpansion

@set arg=%~1

if [%arg%] == [] (
	echo Argument Missing:
	echo You must provide a directory that contains
	echo all the Windows patches in *.msu format.
	echo To Download patches manually, please go:
	echo http://mybulletins.technet.microsoft.com/BulletinPages/Dashboard
	exit /B
)

if not "!arg:~-1,1!" == "\" (
	@set arg=!arg!\
)


for /f %%f in ('dir /B %arg%') DO (
	@set fname=%%f
	@set lastfourchars=!fname:~-4,4!
	if "!lastfourchars!" == ".msu" (
		rem The -15 length is specific to filenames generated by msu_finder, and filters out the following things:
		rem * The time stamp: "_xxxxxxxxxx"
		rem * The extension name: ".msu"
		rem To make this script generic (no time stamp in the filename), instead of -15, you should do -4.
		@set newname=!fname:~0,-15!

		rem This is the destination path that contains the time stamp.
		rem The use of time stamp allows the patches to avoid filename collision,
		rem because sometimes even though the patches are different, they might have the
		rem same name.
		@set newdest=!fname:~0,-4!

		mkdir %arg%!newdest!
		mkdir %arg%!newdest!\extracted
		expand /F:* %arg%!fname! %arg%!newdest!
		expand /F:* %arg%!newdest!\!newname!.cab %arg%!newdest!\extracted
	)

)

echo Done!
echo Now go to %arg%,
echo and then use the search feature from Windows to
echo find the files you're interested in.