/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

public class MovingAverage {
    private final int windowSize;
    private final long[] observations;
    private volatile long count = 0L;
    private volatile long sum = 0L;
    private volatile double average = 0.0;

    public MovingAverage(int windowSize) {
        this.checkWindowSize(windowSize);
        this.windowSize = windowSize;
        this.observations = new long[windowSize];
    }

    public MovingAverage copyWithSize(int newWindowSize) {
        MovingAverage copy = new MovingAverage(newWindowSize);
        long end = this.count;
        long start = !this.isReady() ? 0L : end - (long)this.windowSize;
        if (end - start > (long)newWindowSize) {
            start = end - (long)newWindowSize;
        }
        int i = (int)start;
        while ((long)i < end) {
            copy.record(this.observations[i % this.observations.length]);
            ++i;
        }
        return copy;
    }

    private void checkWindowSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("window size must be greater than zero");
        }
    }

    public synchronized double record(long value) {
        long delta = value - this.observations[(int)(this.count % (long)this.observations.length)];
        this.observations[(int)(this.count % (long)this.observations.length)] = value;
        ++this.count;
        this.sum += delta;
        this.average = (double)this.sum / (double)Math.min(this.count, (long)this.observations.length);
        return this.average;
    }

    public double getAverage() {
        return this.average;
    }

    public long getCount() {
        return this.count;
    }

    public boolean isReady() {
        return this.count >= (long)this.windowSize;
    }
}

