/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.core5.function.Factory;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.opensearch.common.settings.SecureSetting;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.ssl.SslConfiguration;
import org.opensearch.common.ssl.SslConfigurationKeys;
import org.opensearch.common.ssl.SslConfigurationLoader;
import org.opensearch.core.common.settings.SecureString;
import org.opensearch.env.Environment;
import org.opensearch.watcher.FileChangesListener;
import org.opensearch.watcher.FileWatcher;
import org.opensearch.watcher.ResourceWatcher;
import org.opensearch.watcher.ResourceWatcherService;

class ReindexSslConfig {
    private static final Map<String, Setting<?>> SETTINGS;
    private static final Map<String, Setting<SecureString>> SECURE_SETTINGS;
    private final SslConfiguration configuration;
    private volatile SSLContext context;

    public static List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.addAll(SETTINGS.values());
        settings.addAll(SECURE_SETTINGS.values());
        return settings;
    }

    ReindexSslConfig(final Settings settings, Environment environment, ResourceWatcherService resourceWatcher) {
        SslConfigurationLoader loader = new SslConfigurationLoader(this, "reindex.ssl."){

            protected String getSettingAsString(String key) {
                return settings.get(key);
            }

            protected char[] getSecureSetting(String key) {
                Setting<SecureString> setting = SECURE_SETTINGS.get(key);
                if (setting == null) {
                    throw new IllegalArgumentException("The secure setting [" + key + "] is not registered");
                }
                return ((SecureString)setting.get(settings)).getChars();
            }

            protected List<String> getSettingAsList(String key) throws Exception {
                return settings.getAsList(key);
            }
        };
        this.configuration = loader.load(environment.configDir());
        this.reload();
        FileChangesListener listener = new FileChangesListener(){

            public void onFileCreated(Path file) {
                this.onFileChanged(file);
            }

            public void onFileDeleted(Path file) {
                this.onFileChanged(file);
            }

            public void onFileChanged(Path file) {
                ReindexSslConfig.this.reload();
            }
        };
        for (Path file : this.configuration.getDependentFiles()) {
            try {
                FileWatcher watcher = new FileWatcher(file);
                watcher.addListener((Object)listener);
                resourceWatcher.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.HIGH);
            }
            catch (IOException e) {
                throw new UncheckedIOException("cannot watch file [" + String.valueOf(file) + "]", e);
            }
        }
    }

    private void reload() {
        this.context = this.configuration.createSslContext();
    }

    TlsStrategy getStrategy() {
        DefaultHostnameVerifier hostnameVerifier = this.configuration.getVerificationMode().isHostnameVerificationEnabled() ? new DefaultHostnameVerifier() : new NoopHostnameVerifier();
        String[] protocols = this.configuration.getSupportedProtocols().toArray(new String[0]);
        String[] cipherSuites = this.configuration.getCipherSuites().toArray(new String[0]);
        return ClientTlsStrategyBuilder.create().setSslContext(this.context).setHostnameVerifier((HostnameVerifier)hostnameVerifier).setCiphers(cipherSuites).setTlsVersions(protocols).setTlsDetailsFactory((Factory)new Factory<SSLEngine, TlsDetails>(this){

            public TlsDetails create(SSLEngine sslEngine) {
                return new TlsDetails(sslEngine.getSession(), sslEngine.getApplicationProtocol());
            }
        }).build();
    }

    static {
        Setting.Property[] properties;
        String settingName;
        SETTINGS = new HashMap();
        SECURE_SETTINGS = new HashMap<String, Setting<SecureString>>();
        Setting.Property[] defaultProperties = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered};
        Setting.Property[] deprecatedProperties = new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.NodeScope, Setting.Property.Filtered};
        for (String key : SslConfigurationKeys.getStringKeys()) {
            settingName = "reindex.ssl." + key;
            properties = SslConfigurationKeys.isDeprecated((String)key) ? deprecatedProperties : defaultProperties;
            SETTINGS.put(settingName, Setting.simpleString((String)settingName, (Setting.Property[])properties));
        }
        for (String key : SslConfigurationKeys.getListKeys()) {
            settingName = "reindex.ssl." + key;
            properties = SslConfigurationKeys.isDeprecated((String)key) ? deprecatedProperties : defaultProperties;
            SETTINGS.put(settingName, Setting.listSetting((String)settingName, Collections.emptyList(), Function.identity(), (Setting.Property[])properties));
        }
        for (String key : SslConfigurationKeys.getSecureStringKeys()) {
            settingName = "reindex.ssl." + key;
            SECURE_SETTINGS.put(settingName, (Setting<SecureString>)SecureSetting.secureString((String)settingName, null, (Setting.Property[])new Setting.Property[0]));
        }
    }
}

