const _excluded = ["content"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from 'react';
import PropTypes from 'prop-types';
import _ from 'lodash';
import { KuiListingTableToolBar } from './listing_table_tool_bar';
import { KuiListingTableToolBarFooter } from './listing_table_tool_bar_footer';
import { KuiListingTableRow } from './listing_table_row';
import { KuiControlledTable, KuiTableHeaderCheckBoxCell, KuiTableBody, KuiTableHeader, KuiTable, KuiTableHeaderCell } from '../../index';
import { LEFT_ALIGNMENT, RIGHT_ALIGNMENT } from '../../../services';
export function KuiListingTable(_ref) {
  let {
    rows,
    header,
    pager,
    toolBarActions,
    onFilter,
    onItemSelectionChanged,
    enableSelection,
    selectedRowIds,
    filter,
    prompt
  } = _ref;
  function areAllRowsSelected() {
    return rows.length > 0 && rows.length === selectedRowIds.length;
  }
  function toggleAll() {
    if (areAllRowsSelected()) {
      onItemSelectionChanged([]);
    } else {
      onItemSelectionChanged(rows.map(row => row.id));
    }
  }
  function toggleRow(rowId) {
    const selectedRowIndex = selectedRowIds.indexOf(rowId);
    if (selectedRowIndex >= 0) {
      onItemSelectionChanged(selectedRowIds.filter((item, index) => index !== selectedRowIndex));
    } else {
      onItemSelectionChanged([...selectedRowIds, rowId]);
    }
  }
  function renderTableRows(enableSelection) {
    return rows.map((row, rowIndex) => {
      return /*#__PURE__*/React.createElement(KuiListingTableRow, {
        key: rowIndex,
        enableSelection: enableSelection,
        isSelected: selectedRowIds.indexOf(row.id) >= 0,
        onSelectionChanged: toggleRow,
        row: row
      });
    });
  }
  function renderHeader() {
    return header.map((cell, index) => {
      let {
          content
        } = cell,
        props = _objectWithoutProperties(cell, _excluded);
      if ( /*#__PURE__*/React.isValidElement(cell) || !_.isObject(cell)) {
        props = [];
        content = cell;
      }
      return /*#__PURE__*/React.createElement(KuiTableHeaderCell, _extends({
        key: index
      }, props), content);
    });
  }
  function renderInnerTable() {
    return /*#__PURE__*/React.createElement(KuiTable, null, /*#__PURE__*/React.createElement(KuiTableHeader, null, enableSelection && /*#__PURE__*/React.createElement(KuiTableHeaderCheckBoxCell, {
      isChecked: areAllRowsSelected(),
      onChange: toggleAll
    }), renderHeader()), /*#__PURE__*/React.createElement(KuiTableBody, null, renderTableRows(enableSelection)));
  }
  return /*#__PURE__*/React.createElement(KuiControlledTable, null, /*#__PURE__*/React.createElement(KuiListingTableToolBar, {
    actions: toolBarActions,
    pager: pager,
    onFilter: onFilter,
    filter: filter
  }), prompt ? prompt : renderInnerTable(), /*#__PURE__*/React.createElement(KuiListingTableToolBarFooter, {
    itemsSelectedCount: selectedRowIds.length,
    pager: pager
  }));
}
KuiListingTable.propTypes = {
  header: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.node, PropTypes.shape({
    content: PropTypes.node,
    align: PropTypes.oneOf([LEFT_ALIGNMENT, RIGHT_ALIGNMENT]),
    onSort: PropTypes.func,
    isSortAscending: PropTypes.bool,
    isSorted: PropTypes.bool
  })])),
  rows: PropTypes.arrayOf(PropTypes.shape({
    id: PropTypes.string,
    cells: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.node, PropTypes.shape({
      content: PropTypes.node,
      align: PropTypes.oneOf([LEFT_ALIGNMENT, RIGHT_ALIGNMENT])
    })]))
  })),
  pager: PropTypes.node,
  onItemSelectionChanged: PropTypes.func.isRequired,
  enableSelection: PropTypes.bool,
  selectedRowIds: PropTypes.array,
  prompt: PropTypes.node,
  // If given, will be shown instead of a table with rows.
  onFilter: PropTypes.func,
  toolBarActions: PropTypes.node,
  filter: PropTypes.string
};
KuiListingTable.defaultProps = {
  rows: [],
  selectedRowIds: [],
  enableSelection: true
};
