"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requestor = void 0;
var _wreck = _interopRequireDefault(require("@hapi/wreck"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const requestor = async function (requestType, url, wreckOptions) {
  const promise = _wreck.default.request(requestType, url, wreckOptions);
  const res = await promise;
  const body = await _wreck.default.read(res, wreckOptions);
  return body;
};
exports.requestor = requestor;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfd3JlY2siLCJfaW50ZXJvcFJlcXVpcmVEZWZhdWx0IiwicmVxdWlyZSIsImUiLCJfX2VzTW9kdWxlIiwiZGVmYXVsdCIsInJlcXVlc3RvciIsInJlcXVlc3RUeXBlIiwidXJsIiwid3JlY2tPcHRpb25zIiwicHJvbWlzZSIsIldyZWNrIiwicmVxdWVzdCIsInJlcyIsImJvZHkiLCJyZWFkIiwiZXhwb3J0cyJdLCJzb3VyY2VzIjpbIndyZWNrX3JlcXVlc3RzLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuaW1wb3J0IFdyZWNrIGZyb20gJ0BoYXBpL3dyZWNrJztcbmltcG9ydCB7IE9wdGlvbnNUeXBlIH0gZnJvbSAnLi4vLi4vLi4vLi4vY29tbW9uL3R5cGVzL25vdGVib29rcyc7XG5cbmV4cG9ydCBjb25zdCByZXF1ZXN0b3IgPSBhc3luYyBmdW5jdGlvbiAoXG4gIHJlcXVlc3RUeXBlOiBzdHJpbmcsXG4gIHVybDogc3RyaW5nLFxuICB3cmVja09wdGlvbnM6IE9wdGlvbnNUeXBlXG4pIHtcbiAgY29uc3QgcHJvbWlzZSA9IFdyZWNrLnJlcXVlc3QocmVxdWVzdFR5cGUsIHVybCwgd3JlY2tPcHRpb25zKTtcbiAgY29uc3QgcmVzID0gYXdhaXQgcHJvbWlzZTtcbiAgY29uc3QgYm9keSA9IGF3YWl0IFdyZWNrLnJlYWQocmVzLCB3cmVja09wdGlvbnMpO1xuICByZXR1cm4gYm9keTtcbn07XG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUtBLElBQUFBLE1BQUEsR0FBQUMsc0JBQUEsQ0FBQUMsT0FBQTtBQUFnQyxTQUFBRCx1QkFBQUUsQ0FBQSxXQUFBQSxDQUFBLElBQUFBLENBQUEsQ0FBQUMsVUFBQSxHQUFBRCxDQUFBLEtBQUFFLE9BQUEsRUFBQUYsQ0FBQTtBQUxoQztBQUNBO0FBQ0E7QUFDQTs7QUFLTyxNQUFNRyxTQUFTLEdBQUcsZUFBQUEsQ0FDdkJDLFdBQW1CLEVBQ25CQyxHQUFXLEVBQ1hDLFlBQXlCLEVBQ3pCO0VBQ0EsTUFBTUMsT0FBTyxHQUFHQyxjQUFLLENBQUNDLE9BQU8sQ0FBQ0wsV0FBVyxFQUFFQyxHQUFHLEVBQUVDLFlBQVksQ0FBQztFQUM3RCxNQUFNSSxHQUFHLEdBQUcsTUFBTUgsT0FBTztFQUN6QixNQUFNSSxJQUFJLEdBQUcsTUFBTUgsY0FBSyxDQUFDSSxJQUFJLENBQUNGLEdBQUcsRUFBRUosWUFBWSxDQUFDO0VBQ2hELE9BQU9LLElBQUk7QUFDYixDQUFDO0FBQUNFLE9BQUEsQ0FBQVYsU0FBQSxHQUFBQSxTQUFBIn0=