/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.info;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.nodes.info.NodeInfoJvmMemory;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodeJvmInfo
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, NodeJvmInfo> {
    private final boolean bundledJdk;
    @Nonnull
    private final List<String> gcCollectors;
    @Nonnull
    private final List<String> inputArguments;
    @Nonnull
    private final NodeInfoJvmMemory mem;
    @Nonnull
    private final List<String> memoryPools;
    private final int pid;
    @Nullable
    private final String startTime;
    private final long startTimeInMillis;
    @Nullable
    private final Boolean usingBundledJdk;
    @Nullable
    private final Boolean usingCompressedOrdinaryObjectPointers;
    @Nullable
    private final String version;
    @Nullable
    private final String vmName;
    @Nullable
    private final String vmVendor;
    @Nullable
    private final String vmVersion;
    public static final JsonpDeserializer<NodeJvmInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeJvmInfo::setupNodeJvmInfoDeserializer);

    private NodeJvmInfo(Builder builder) {
        this.bundledJdk = ApiTypeHelper.requireNonNull(builder.bundledJdk, this, "bundledJdk");
        this.gcCollectors = ApiTypeHelper.unmodifiable(builder.gcCollectors);
        this.inputArguments = ApiTypeHelper.unmodifiable(builder.inputArguments);
        this.mem = ApiTypeHelper.requireNonNull(builder.mem, this, "mem");
        this.memoryPools = ApiTypeHelper.unmodifiable(builder.memoryPools);
        this.pid = ApiTypeHelper.requireNonNull(builder.pid, this, "pid");
        this.startTime = builder.startTime;
        this.startTimeInMillis = ApiTypeHelper.requireNonNull(builder.startTimeInMillis, this, "startTimeInMillis");
        this.usingBundledJdk = builder.usingBundledJdk;
        this.usingCompressedOrdinaryObjectPointers = builder.usingCompressedOrdinaryObjectPointers;
        this.version = builder.version;
        this.vmName = builder.vmName;
        this.vmVendor = builder.vmVendor;
        this.vmVersion = builder.vmVersion;
    }

    public static NodeJvmInfo of(Function<Builder, ObjectBuilder<NodeJvmInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean bundledJdk() {
        return this.bundledJdk;
    }

    @Nonnull
    public final List<String> gcCollectors() {
        return this.gcCollectors;
    }

    @Nonnull
    public final List<String> inputArguments() {
        return this.inputArguments;
    }

    @Nonnull
    public final NodeInfoJvmMemory mem() {
        return this.mem;
    }

    @Nonnull
    public final List<String> memoryPools() {
        return this.memoryPools;
    }

    public final int pid() {
        return this.pid;
    }

    @Nullable
    public final String startTime() {
        return this.startTime;
    }

    public final long startTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Nullable
    public final Boolean usingBundledJdk() {
        return this.usingBundledJdk;
    }

    @Nullable
    public final Boolean usingCompressedOrdinaryObjectPointers() {
        return this.usingCompressedOrdinaryObjectPointers;
    }

    @Nullable
    public final String version() {
        return this.version;
    }

    @Nullable
    public final String vmName() {
        return this.vmName;
    }

    @Nullable
    public final String vmVendor() {
        return this.vmVendor;
    }

    @Nullable
    public final String vmVersion() {
        return this.vmVersion;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bundled_jdk");
        generator.write(this.bundledJdk);
        if (ApiTypeHelper.isDefined(this.gcCollectors)) {
            generator.writeKey("gc_collectors");
            generator.writeStartArray();
            for (String item0 : this.gcCollectors) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.inputArguments)) {
            generator.writeKey("input_arguments");
            generator.writeStartArray();
            for (String item0 : this.inputArguments) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("mem");
        this.mem.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.memoryPools)) {
            generator.writeKey("memory_pools");
            generator.writeStartArray();
            for (String item0 : this.memoryPools) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("pid");
        generator.write(this.pid);
        if (this.startTime != null) {
            generator.writeKey("start_time");
            generator.write(this.startTime);
        }
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
        if (this.usingBundledJdk != null) {
            generator.writeKey("using_bundled_jdk");
            generator.write(this.usingBundledJdk.booleanValue());
        }
        if (this.usingCompressedOrdinaryObjectPointers != null) {
            generator.writeKey("using_compressed_ordinary_object_pointers");
            generator.write(this.usingCompressedOrdinaryObjectPointers.booleanValue());
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
        if (this.vmName != null) {
            generator.writeKey("vm_name");
            generator.write(this.vmName);
        }
        if (this.vmVendor != null) {
            generator.writeKey("vm_vendor");
            generator.write(this.vmVendor);
        }
        if (this.vmVersion != null) {
            generator.writeKey("vm_version");
            generator.write(this.vmVersion);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodeJvmInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bundledJdk, JsonpDeserializer.booleanDeserializer(), "bundled_jdk");
        op.add(Builder::gcCollectors, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "gc_collectors");
        op.add(Builder::inputArguments, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "input_arguments");
        op.add(Builder::mem, NodeInfoJvmMemory._DESERIALIZER, "mem");
        op.add(Builder::memoryPools, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "memory_pools");
        op.add(Builder::pid, JsonpDeserializer.integerDeserializer(), "pid");
        op.add(Builder::startTime, JsonpDeserializer.stringDeserializer(), "start_time");
        op.add(Builder::startTimeInMillis, JsonpDeserializer.longDeserializer(), "start_time_in_millis");
        op.add(Builder::usingBundledJdk, JsonpDeserializer.booleanDeserializer(), "using_bundled_jdk");
        op.add(Builder::usingCompressedOrdinaryObjectPointers, JsonpDeserializer.booleanDeserializer(), "using_compressed_ordinary_object_pointers");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::vmName, JsonpDeserializer.stringDeserializer(), "vm_name");
        op.add(Builder::vmVendor, JsonpDeserializer.stringDeserializer(), "vm_vendor");
        op.add(Builder::vmVersion, JsonpDeserializer.stringDeserializer(), "vm_version");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Boolean.hashCode(this.bundledJdk);
        result = 31 * result + Objects.hashCode(this.gcCollectors);
        result = 31 * result + Objects.hashCode(this.inputArguments);
        result = 31 * result + this.mem.hashCode();
        result = 31 * result + Objects.hashCode(this.memoryPools);
        result = 31 * result + Integer.hashCode(this.pid);
        result = 31 * result + Objects.hashCode(this.startTime);
        result = 31 * result + Long.hashCode(this.startTimeInMillis);
        result = 31 * result + Objects.hashCode(this.usingBundledJdk);
        result = 31 * result + Objects.hashCode(this.usingCompressedOrdinaryObjectPointers);
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + Objects.hashCode(this.vmName);
        result = 31 * result + Objects.hashCode(this.vmVendor);
        result = 31 * result + Objects.hashCode(this.vmVersion);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeJvmInfo other = (NodeJvmInfo)o;
        return this.bundledJdk == other.bundledJdk && Objects.equals(this.gcCollectors, other.gcCollectors) && Objects.equals(this.inputArguments, other.inputArguments) && this.mem.equals(other.mem) && Objects.equals(this.memoryPools, other.memoryPools) && this.pid == other.pid && Objects.equals(this.startTime, other.startTime) && this.startTimeInMillis == other.startTimeInMillis && Objects.equals(this.usingBundledJdk, other.usingBundledJdk) && Objects.equals(this.usingCompressedOrdinaryObjectPointers, other.usingCompressedOrdinaryObjectPointers) && Objects.equals(this.version, other.version) && Objects.equals(this.vmName, other.vmName) && Objects.equals(this.vmVendor, other.vmVendor) && Objects.equals(this.vmVersion, other.vmVersion);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NodeJvmInfo> {
        private Boolean bundledJdk;
        @Nullable
        private List<String> gcCollectors;
        @Nullable
        private List<String> inputArguments;
        private NodeInfoJvmMemory mem;
        @Nullable
        private List<String> memoryPools;
        private Integer pid;
        @Nullable
        private String startTime;
        private Long startTimeInMillis;
        @Nullable
        private Boolean usingBundledJdk;
        @Nullable
        private Boolean usingCompressedOrdinaryObjectPointers;
        @Nullable
        private String version;
        @Nullable
        private String vmName;
        @Nullable
        private String vmVendor;
        @Nullable
        private String vmVersion;

        public Builder() {
        }

        private Builder(NodeJvmInfo o) {
            this.bundledJdk = o.bundledJdk;
            this.gcCollectors = Builder._listCopy(o.gcCollectors);
            this.inputArguments = Builder._listCopy(o.inputArguments);
            this.mem = o.mem;
            this.memoryPools = Builder._listCopy(o.memoryPools);
            this.pid = o.pid;
            this.startTime = o.startTime;
            this.startTimeInMillis = o.startTimeInMillis;
            this.usingBundledJdk = o.usingBundledJdk;
            this.usingCompressedOrdinaryObjectPointers = o.usingCompressedOrdinaryObjectPointers;
            this.version = o.version;
            this.vmName = o.vmName;
            this.vmVendor = o.vmVendor;
            this.vmVersion = o.vmVersion;
        }

        private Builder(Builder o) {
            this.bundledJdk = o.bundledJdk;
            this.gcCollectors = Builder._listCopy(o.gcCollectors);
            this.inputArguments = Builder._listCopy(o.inputArguments);
            this.mem = o.mem;
            this.memoryPools = Builder._listCopy(o.memoryPools);
            this.pid = o.pid;
            this.startTime = o.startTime;
            this.startTimeInMillis = o.startTimeInMillis;
            this.usingBundledJdk = o.usingBundledJdk;
            this.usingCompressedOrdinaryObjectPointers = o.usingCompressedOrdinaryObjectPointers;
            this.version = o.version;
            this.vmName = o.vmName;
            this.vmVendor = o.vmVendor;
            this.vmVersion = o.vmVersion;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder bundledJdk(boolean value) {
            this.bundledJdk = value;
            return this;
        }

        @Nonnull
        public final Builder gcCollectors(List<String> list) {
            this.gcCollectors = Builder._listAddAll(this.gcCollectors, list);
            return this;
        }

        @Nonnull
        public final Builder gcCollectors(String value, String ... values) {
            this.gcCollectors = Builder._listAdd(this.gcCollectors, value, values);
            return this;
        }

        @Nonnull
        public final Builder inputArguments(List<String> list) {
            this.inputArguments = Builder._listAddAll(this.inputArguments, list);
            return this;
        }

        @Nonnull
        public final Builder inputArguments(String value, String ... values) {
            this.inputArguments = Builder._listAdd(this.inputArguments, value, values);
            return this;
        }

        @Nonnull
        public final Builder mem(NodeInfoJvmMemory value) {
            this.mem = value;
            return this;
        }

        @Nonnull
        public final Builder mem(Function<NodeInfoJvmMemory.Builder, ObjectBuilder<NodeInfoJvmMemory>> fn) {
            return this.mem(fn.apply(new NodeInfoJvmMemory.Builder()).build());
        }

        @Nonnull
        public final Builder memoryPools(List<String> list) {
            this.memoryPools = Builder._listAddAll(this.memoryPools, list);
            return this;
        }

        @Nonnull
        public final Builder memoryPools(String value, String ... values) {
            this.memoryPools = Builder._listAdd(this.memoryPools, value, values);
            return this;
        }

        @Nonnull
        public final Builder pid(int value) {
            this.pid = value;
            return this;
        }

        @Nonnull
        public final Builder startTime(@Nullable String value) {
            this.startTime = value;
            return this;
        }

        @Nonnull
        public final Builder startTimeInMillis(long value) {
            this.startTimeInMillis = value;
            return this;
        }

        @Nonnull
        public final Builder usingBundledJdk(@Nullable Boolean value) {
            this.usingBundledJdk = value;
            return this;
        }

        @Nonnull
        public final Builder usingCompressedOrdinaryObjectPointers(@Nullable Boolean value) {
            this.usingCompressedOrdinaryObjectPointers = value;
            return this;
        }

        @Nonnull
        public final Builder version(@Nullable String value) {
            this.version = value;
            return this;
        }

        @Nonnull
        public final Builder vmName(@Nullable String value) {
            this.vmName = value;
            return this;
        }

        @Nonnull
        public final Builder vmVendor(@Nullable String value) {
            this.vmVendor = value;
            return this;
        }

        @Nonnull
        public final Builder vmVersion(@Nullable String value) {
            this.vmVersion = value;
            return this;
        }

        @Override
        @Nonnull
        public NodeJvmInfo build() {
            this._checkSingleUse();
            return new NodeJvmInfo(this);
        }
    }
}

