/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.UIManager;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.ISourceFileReader;
import net.sourceforge.plantuml.Pipe;
import net.sourceforge.plantuml.ProgressBar;
import net.sourceforge.plantuml.SourceFileReader;
import net.sourceforge.plantuml.SourceFileReaderAbstract;
import net.sourceforge.plantuml.SourceFileReaderCopyCat;
import net.sourceforge.plantuml.Splash;
import net.sourceforge.plantuml.Stdrpt;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cli.CliAction;
import net.sourceforge.plantuml.cli.CliFlag;
import net.sourceforge.plantuml.cli.CliOptions;
import net.sourceforge.plantuml.cli.CliParser;
import net.sourceforge.plantuml.cli.CliParsingException;
import net.sourceforge.plantuml.cli.ErrorStatus;
import net.sourceforge.plantuml.cli.Exit;
import net.sourceforge.plantuml.cli.GlobalConfig;
import net.sourceforge.plantuml.cli.GlobalConfigKey;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.dot.GraphvizRuntimeEnvironment;
import net.sourceforge.plantuml.file.FileGroup;
import net.sourceforge.plantuml.file.SuggestedFile;
import net.sourceforge.plantuml.ftp.FtpServer;
import net.sourceforge.plantuml.klimt.sprite.SpriteGrayLevel;
import net.sourceforge.plantuml.klimt.sprite.SpriteUtils;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.picoweb.PicoWebServer;
import net.sourceforge.plantuml.png.MetadataTag;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.swing.MainWindow;
import net.sourceforge.plantuml.syntax.LanguageDescriptor;
import net.sourceforge.plantuml.utils.Log;
import net.sourceforge.plantuml.utils.Obfuscate;
import net.sourceforge.plantuml.version.Version;

public class Run {
    private final CliOptions option;
    private final ErrorStatus errorStatus;
    private final String charset;
    private final List<File> files = new ArrayList<File>();
    private static final String httpProtocol = "http://";
    private static final String httpsProtocol = "https://";
    private static final String META_HEADER_NEW = "<?plantuml-src ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argsArray) throws NoPlantumlCompressionException, IOException, InterruptedException {
        String javaAwtHeadless;
        System.setProperty("log4j.debug", "false");
        long start = System.currentTimeMillis();
        if (argsArray.length > 0 && argsArray[0].equalsIgnoreCase("-headless")) {
            System.setProperty("java.awt.headless", "true");
        }
        String display = System.getenv("DISPLAY");
        String waylandDisplay = System.getenv("WAYLAND_DISPLAY");
        if (display == null && waylandDisplay != null) {
            Log.info(() -> "Wayland detected; X11 compatibility may be required via XWayland.");
        } else if (display != null) {
            Log.info(() -> "X11 display available: " + display);
        } else {
            Log.info(() -> "No display detected; you may need the -headless flag.");
        }
        if (GraphicsEnvironment.isHeadless()) {
            Log.info(() -> "Forcing -Djava.awt.headless=true");
            System.setProperty("java.awt.headless", "true");
        }
        if ((javaAwtHeadless = System.getProperty("java.awt.headless")) == null) {
            Log.info(() -> "java.awt.headless not set");
        } else {
            Log.info(() -> "java.awt.headless set as '" + javaAwtHeadless + "'");
        }
        ErrorStatus errorStatus = ErrorStatus.init();
        CliOptions option = null;
        try {
            option = CliParser.parse(argsArray);
            String timeout = option.getString(CliFlag.TIMEOUT);
            if (timeout != null && timeout.matches("\\d+")) {
                GlobalConfig.getInstance().put(GlobalConfigKey.TIMEOUT_MS, (long)Integer.parseInt(timeout) * 1000L);
            }
            String charset = option.getString(CliFlag.CHARSET);
            Log.info(() -> "Using charset " + charset);
            option.flags.triggerNonImmediateCliAction();
            CliAction action = option.flags.getImmediateAction();
            if (action != null) {
                action.runAction();
                return;
            }
            if (option.isTrue(CliFlag.GRAPHVIZ_DOT)) {
                String v = option.flags.getString(CliFlag.GRAPHVIZ_DOT);
                GraphvizRuntimeEnvironment.getInstance().setDotExecutable(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(v));
            }
            if (option.flags.isTrue(CliFlag.FTP)) {
                Run.goFtp(option);
                return;
            }
            List<String> remainingArgs = option.flags.getRemainingArgs();
            ProgressBar.setEnable(option.isTrue(CliFlag.PROGRESS));
            Log.info(() -> "SecurityProfile " + (Object)((Object)SecurityUtils.getSecurityProfile()));
            if (GlobalConfig.getInstance().boolValue(GlobalConfigKey.VERBOSE)) {
                Log.info(() -> "PlantUML Version " + Version.versionString());
                Log.info(() -> "GraphicsEnvironment.isHeadless() " + GraphicsEnvironment.isHeadless());
            }
            if (option.isTrue(CliFlag.ENCODE_SPRITE)) {
                Run.encodeSprite(remainingArgs);
                return;
            }
            if (option.isTrue(CliFlag.PICOWEB) && option.getPicowebPort() != -1) {
                Run.goPicoweb(option);
                return;
            }
            Run.forceOpenJdkResourceLoad();
            if (GlobalConfig.getInstance().boolValue(GlobalConfigKey.GUI)) {
                Run.runGui(option);
                return;
            }
            if (option.isTrue(CliFlag.PIPE) || option.isTrue(CliFlag.PIPEMAP) || option.isTrue(CliFlag.SYNTAX)) {
                new Pipe(option, System.out, System.in, charset).managePipe(errorStatus);
                if (errorStatus.hasError()) {
                    Exit.exit(errorStatus.getExitCode());
                }
                return;
            }
            if (option.isTrue(CliFlag.DECODE_URL)) {
                for (String s : option.getRemainingArgs()) {
                    Transcoder transcoder = TranscoderUtil.getDefaultTranscoder();
                    System.out.println("@startuml");
                    System.out.println(transcoder.decode(s));
                    System.out.println("@enduml");
                }
                return;
            }
            if (option.isTrue(CliFlag.RETRIEVE_METADATA)) {
                ArrayList<File> files = new ArrayList<File>();
                for (String s : option.getRemainingArgs()) {
                    FileGroup group = new FileGroup(s, option.getExcludes());
                    Run.incTotal(group.getFiles().size());
                    files.addAll(group.getFiles());
                }
                for (File f : files) {
                    Run.extractMetadata(f);
                }
                return;
            }
            if (option.isTrue(CliFlag.SPLASH)) {
                Splash.createSplash();
            }
            Run runner = new Run(option, errorStatus, charset);
            Run.incTotal(runner.size());
            if (option.isTrue(CliFlag.COMPUTE_URL)) {
                runner.computeUrl();
            } else if (option.isTrue(CliFlag.FAIL_FAST2) && runner.checkError()) {
                errorStatus.incError();
            } else {
                runner.processInputsInParallel();
            }
        }
        catch (CliParsingException e) {
            System.err.println(e.getMessage());
            Exit.exit(42);
        }
        finally {
            if (option != null && option.isTrue(CliFlag.DURATION)) {
                double duration = (double)(System.currentTimeMillis() - start) / 1000.0;
                Log.error("Duration = " + duration + " seconds");
            }
        }
        if (option != null && (errorStatus.hasError() || errorStatus.isEmpty())) {
            option.getStdrpt().finalMessage(errorStatus);
        }
        if (errorStatus.hasError()) {
            Exit.exit(errorStatus.getExitCode());
        }
    }

    public Run(CliOptions option, ErrorStatus errorStatus, String charset) {
        this.option = option;
        this.errorStatus = errorStatus;
        this.charset = charset;
        for (String s : option.getRemainingArgs()) {
            FileGroup group = new FileGroup(s, option.getExcludes());
            for (File f : group.getFiles()) {
                this.files.add(f);
            }
        }
        Log.info(() -> "Found " + this.size() + " files");
    }

    public int size() {
        return this.files.size();
    }

    private boolean checkError() throws InterruptedException {
        AtomicBoolean hasError = new AtomicBoolean();
        this.processInParallel(file -> {
            if (hasError.get()) {
                return;
            }
            ISourceFileReader sourceFileReader = Run.getSourceFileReader(file, this.option, this.charset);
            if (sourceFileReader.hasError()) {
                hasError.set(true);
                this.errorStatus.incError();
            }
        });
        return hasError.get();
    }

    private void computeUrl() throws IOException {
        for (File f : this.files) {
            ISourceFileReader sourceFileReader = Run.getSourceFileReader(f, this.option, this.charset);
            for (BlockUml s : sourceFileReader.getBlocks()) {
                System.out.println(s.getEncodedUrl());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInputsInParallel() throws InterruptedException {
        SFile lockFile = null;
        try {
            if (GlobalConfig.getInstance().boolValue(GlobalConfigKey.WORD)) {
                SFile dir = new SFile(this.option.getRemainingArgs().get(0));
                SFile javaIsRunningFile = dir.file("javaisrunning.tmp");
                javaIsRunningFile.delete();
                lockFile = dir.file("javaumllock.tmp");
            }
            this.processInParallel(file -> {
                if (this.errorStatus.hasError() && this.option.isFailfastOrFailfast2()) {
                    return;
                }
                this.manageFileInternal(file);
                Run.incDone(this.errorStatus.hasError());
            });
        }
        finally {
            if (lockFile != null) {
                lockFile.delete();
            }
        }
    }

    private void processInParallel(FileTask task) throws InterruptedException {
        Log.info(() -> "Using several threads: " + this.option.getNbThreads());
        ExecutorService executor = Executors.newFixedThreadPool(this.option.getNbThreads());
        for (File f : this.files) {
            executor.submit(() -> {
                try {
                    task.processFile(f);
                }
                catch (IOException | InterruptedException e) {
                    Logme.error(e);
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    private void manageFileInternal(File f) throws IOException, InterruptedException {
        Log.info(() -> "Working on " + f.getPath());
        ISourceFileReader sourceFileReader = Run.getSourceFileReader(f, this.option, this.charset);
        if (sourceFileReader.hasError()) {
            this.errorStatus.incError();
        } else {
            this.errorStatus.incOk();
        }
        if (this.option.isTrue(CliFlag.CHECK_ONLY)) {
            return;
        }
        if (this.option.getFileFormatOption().getFileFormat() == FileFormat.PREPROC || this.option.getFileFormatOption().getFileFormat() == FileFormat.OBFUSCATE) {
            this.extractPreprocessingSource(sourceFileReader);
            return;
        }
        List<GeneratedImage> result = sourceFileReader.getGeneratedImages();
        Stdrpt rpt = this.option.getStdrpt();
        if (result.size() == 0) {
            Log.error("Warning: no image in " + f.getPath());
            rpt.printInfo(System.err, null);
            return;
        }
        for (BlockUml s : sourceFileReader.getBlocks()) {
            rpt.printInfo(System.err, s.getDiagram());
        }
        if (result.size() != 0) {
            for (GeneratedImage image : result) {
                int lineError = image.lineErrorRaw();
                if (lineError == -1) continue;
                rpt.errorLine(lineError, f);
                this.errorStatus.incError();
                return;
            }
            this.errorStatus.incOk();
        }
    }

    private static void runGui(CliOptions option) {
        File f;
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<String> list = option.getRemainingArgs();
        File dir = null;
        if (list.size() == 1 && (f = new File(list.get(0))).exists() && f.isDirectory()) {
            dir = f;
        }
        try {
            new MainWindow(option, dir);
        }
        catch (HeadlessException e) {
            System.err.println("There is an issue with your server. You will find some tips here:");
            System.err.println("https://forum.plantuml.net/3399/problem-with-x11-and-headless-exception");
            System.err.println("https://plantuml.com/en/faq#239d64f675c3e515");
            throw e;
        }
    }

    public static void forceOpenJdkResourceLoad() {
        if (Run.isOpenJdkRunning()) {
            Log.info(() -> "Forcing resource load on OpenJdk");
            BufferedImage imDummy = new BufferedImage(10, 10, 1);
            Graphics2D gg = imDummy.createGraphics();
            String text = "Alice";
            Font font = new Font("SansSerif", 0, 12);
            FontMetrics fm = gg.getFontMetrics(font);
            Rectangle2D rectangle2D = fm.getStringBounds("Alice", gg);
        }
    }

    public static boolean isOpenJdkRunning() {
        String jvmName = System.getProperty("java.vm.name");
        return jvmName != null && jvmName.toLowerCase().contains("openjdk");
    }

    private static void encodeSprite(List<String> remainingArgs) throws IOException {
        BufferedImage im;
        String fileName;
        URL source;
        String path;
        SpriteGrayLevel level = SpriteGrayLevel.GRAY_16;
        boolean compressed = false;
        if (remainingArgs.size() > 1 && remainingArgs.get(0).matches("(4|8|16)z?")) {
            if (remainingArgs.get(0).startsWith("8")) {
                level = SpriteGrayLevel.GRAY_8;
            }
            if (remainingArgs.get(0).startsWith("4")) {
                level = SpriteGrayLevel.GRAY_4;
            }
            compressed = StringUtils.goLowerCase(remainingArgs.get(0)).endsWith("z");
            path = remainingArgs.get(1);
        } else {
            path = remainingArgs.get(0);
        }
        String lowerPath = StringUtils.goLowerCase(path);
        if (lowerPath.startsWith(httpProtocol) || lowerPath.startsWith(httpsProtocol)) {
            source = new URL(path);
            String p = source.getPath();
            fileName = p.substring(p.lastIndexOf(47) + 1, p.length());
        } else {
            SFile f = new SFile(path);
            source = f.toURI().toURL();
            fileName = f.getName();
        }
        if (source == null) {
            return;
        }
        try (InputStream stream = source.openStream();){
            im = SImageIO.read(stream);
        }
        String name = Run.getSpriteName(fileName);
        String s = compressed ? SpriteUtils.encodeCompressed(im, name, level) : SpriteUtils.encode(im, name, level);
        System.out.println(s);
    }

    private static String getSpriteName(String fileName) {
        String s = Run.getSpriteNameInternal(fileName);
        if (s.length() == 0) {
            return "test";
        }
        return s;
    }

    private static String getSpriteNameInternal(String fileName) {
        StringBuilder sb = new StringBuilder();
        for (char c : fileName.toCharArray()) {
            if (!("" + c).matches("[\\p{L}0-9_]")) {
                return sb.toString();
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void goFtp(CliOptions option) throws IOException {
        int ftpPort = option.getFtpPort();
        System.err.println("ftpPort=" + ftpPort);
        FtpServer ftpServer = new FtpServer(ftpPort, option.getFileFormatOption().getFileFormat());
        ftpServer.go();
    }

    private static void goPicoweb(CliOptions option) throws IOException {
        PicoWebServer.startServer(option.getPicowebPort(), option.getPicowebBindAddress(), option.getPicowebEnableStop());
    }

    public static void printFonts() {
        String[] name;
        Font[] fonts;
        for (Font f : fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            System.out.println("f=" + f + "/" + f.getPSName() + "/" + f.getName() + "/" + f.getFontName() + "/" + f.getFamily());
        }
        for (String n : name = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            System.out.println("n=" + n);
        }
    }

    private static void incDone(boolean error) {
        Splash.incDone(error);
        ProgressBar.incDone(error);
    }

    private static void incTotal(int nb) {
        Splash.incTotal(nb);
        ProgressBar.incTotal(nb);
    }

    private static ISourceFileReader getSourceFileReader(File f, CliOptions option, String charset) throws IOException {
        SourceFileReaderAbstract sourceFileReader;
        FileFormatOption fileFormatOption = option.getFileFormatOption();
        File outputDir = option.getOutputDir();
        if (outputDir != null && outputDir.getPath().endsWith("$")) {
            String path = outputDir.getPath();
            outputDir = new File(path.substring(0, path.length() - 1)).getAbsoluteFile();
            sourceFileReader = new SourceFileReaderCopyCat(option.getDefaultDefines(f), f, outputDir, option.getConfig(), charset, fileFormatOption);
        } else {
            sourceFileReader = new SourceFileReader(option.getDefaultDefines(f), f, outputDir, option.getConfig(), charset, fileFormatOption);
        }
        sourceFileReader.setCheckMetadata(option.isTrue(CliFlag.CHECK_METADATA));
        ((SourceFileReaderAbstract)sourceFileReader).setNoErrorImage(option.isTrue(CliFlag.NO_ERROR_IMAGE));
        return sourceFileReader;
    }

    private void extractPreprocessingSource(ISourceFileReader sourceFileReader) throws IOException {
        FileFormat format = this.option.getFileFormatOption().getFileFormat();
        Obfuscate obfuscate = format == FileFormat.OBFUSCATE ? new LanguageDescriptor().getObfuscate() : null;
        for (BlockUml blockUml : sourceFileReader.getBlocks()) {
            SuggestedFile suggested = ((SourceFileReaderAbstract)sourceFileReader).getSuggestedFile(blockUml).withPreprocFormat(this.option.getFileFormatOption().getFileFormat());
            SFile file = suggested.getFile(0);
            Log.info(() -> "Export preprocessing source to " + file.getPrintablePath());
            PrintWriter pw = this.charset == null ? file.createPrintWriter() : file.createPrintWriter(this.charset);
            try {
                int level = 0;
                for (CharSequence charSequence : blockUml.getDefinition(true)) {
                    String s = charSequence.toString();
                    if (obfuscate != null) {
                        if (s.contains("skinparam") && s.contains("{")) {
                            ++level;
                        }
                        if (level == 0 && !s.contains("skinparam")) {
                            s = obfuscate.obfuscate(s);
                        }
                        if (level > 0 && s.contains("}")) {
                            --level;
                        }
                    }
                    pw.println(s);
                }
            }
            finally {
                if (pw == null) continue;
                pw.close();
            }
        }
    }

    private static void extractMetadata(File f) throws IOException {
        System.out.println("------------------------");
        System.out.println(f);
        System.out.println();
        if (f.getName().endsWith(".svg")) {
            SFile file = SFile.fromFile(f);
            String svg = FileUtils.readFile(file);
            String decoded = Run.extractMetadataFromSvg(svg);
            if (decoded != null) {
                System.out.println(decoded);
            }
        } else {
            String data = new MetadataTag(f, "plantuml").getData();
            System.out.println(data);
        }
        System.out.println("------------------------");
    }

    private static String extractMetadataFromSvg(String svg) throws NoPlantumlCompressionException {
        String part;
        int idxEnd;
        String part2;
        int idxEnd2;
        int idxNew = svg.lastIndexOf(META_HEADER_NEW);
        if (idxNew > 0 && (idxEnd2 = (part2 = svg.substring(idxNew + META_HEADER_NEW.length())).indexOf("?>")) > 0) {
            part2 = part2.substring(0, idxEnd2);
            return TranscoderUtil.getDefaultTranscoderProtected().decode(part2);
        }
        int idxOld = svg.lastIndexOf("<!--SRC=[");
        if (idxOld > 0 && (idxEnd = (part = svg.substring(idxOld + "<!--SRC=[".length())).indexOf("]")) > 0) {
            part = part.substring(0, idxEnd);
            part = part.replace("- -", "--");
            return TranscoderUtil.getDefaultTranscoderProtected().decode(part);
        }
        return null;
    }

    @FunctionalInterface
    static interface FileTask {
        public void processFile(File var1) throws IOException, InterruptedException;
    }
}

