/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class PartitionMidprocessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph lGraph, IElkProgressMonitor monitor) {
        monitor.begin("Partition midprocessing", 1.0f);
        HashMultimap partitionToNodesMap = HashMultimap.create();
        lGraph.getLayerlessNodes().stream().filter(node -> node.hasProperty(LayeredOptions.PARTITIONING_PARTITION)).forEach(node -> {
            boolean bl = partitionToNodesMap.put(node.getProperty(LayeredOptions.PARTITIONING_PARTITION), node);
        });
        if (partitionToNodesMap.isEmpty()) {
            return;
        }
        List sortedPartitionIDs = partitionToNodesMap.keySet().stream().sorted().collect(Collectors.toList());
        Iterator idIterator = sortedPartitionIDs.iterator();
        Integer firstId = (Integer)idIterator.next();
        while (idIterator.hasNext()) {
            Integer secondId = (Integer)idIterator.next();
            this.connectNodes(partitionToNodesMap.get(firstId), partitionToNodesMap.get(secondId));
            firstId = secondId;
        }
        monitor.done();
    }

    private void connectNodes(Collection<LNode> firstPartition, Collection<LNode> secondPartition) {
        for (LNode node : firstPartition) {
            LPort sourcePort = new LPort();
            sourcePort.setNode(node);
            sourcePort.setSide(PortSide.EAST);
            sourcePort.setProperty(InternalProperties.PARTITION_DUMMY, (Object)true);
            for (LNode otherNode : secondPartition) {
                LPort targetPort = new LPort();
                targetPort.setNode(otherNode);
                targetPort.setSide(PortSide.WEST);
                targetPort.setProperty(InternalProperties.PARTITION_DUMMY, (Object)true);
                LEdge edge = new LEdge();
                edge.setProperty(InternalProperties.PARTITION_DUMMY, (Object)true);
                edge.setSource(sourcePort);
                edge.setTarget(targetPort);
            }
        }
    }
}

