
use builtin;
use str;

set edit:completion:arg-completer[qsv] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'qsv'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'qsv'= {
            cand --list 'list'
            cand --envlist 'envlist'
            cand --update 'update'
            cand --updatenow 'updatenow'
            cand -V 'V'
            cand --version 'version'
            cand -h 'Print help'
            cand --help 'Print help'
            cand apply 'apply'
            cand behead 'behead'
            cand cat 'cat'
            cand clipboard 'clipboard'
            cand color 'color'
            cand count 'count'
            cand datefmt 'datefmt'
            cand dedup 'dedup'
            cand describegpt 'describegpt'
            cand diff 'diff'
            cand edit 'edit'
            cand enum 'enum'
            cand excel 'excel'
            cand exclude 'exclude'
            cand explode 'explode'
            cand extdedup 'extdedup'
            cand extsort 'extsort'
            cand fetch 'fetch'
            cand fetchpost 'fetchpost'
            cand fill 'fill'
            cand fixlengths 'fixlengths'
            cand flatten 'flatten'
            cand fmt 'fmt'
            cand foreach 'foreach'
            cand frequency 'frequency'
            cand geocode 'geocode'
            cand geoconvert 'geoconvert'
            cand headers 'headers'
            cand index 'index'
            cand input 'input'
            cand join 'join'
            cand joinp 'joinp'
            cand json 'json'
            cand jsonl 'jsonl'
            cand lens 'lens'
            cand log 'log'
            cand luau 'luau'
            cand moarstats 'moarstats'
            cand partition 'partition'
            cand pivotp 'pivotp'
            cand pragmastat 'pragmastat'
            cand pro 'pro'
            cand prompt 'prompt'
            cand pseudo 'pseudo'
            cand py 'py'
            cand rename 'rename'
            cand replace 'replace'
            cand reverse 'reverse'
            cand safenames 'safenames'
            cand sample 'sample'
            cand schema 'schema'
            cand search 'search'
            cand searchset 'searchset'
            cand select 'select'
            cand slice 'slice'
            cand snappy 'snappy'
            cand sniff 'sniff'
            cand sort 'sort'
            cand sortcheck 'sortcheck'
            cand split 'split'
            cand sqlp 'sqlp'
            cand stats 'stats'
            cand table 'table'
            cand template 'template'
            cand to 'to'
            cand tojsonl 'tojsonl'
            cand transpose 'transpose'
            cand validate 'validate'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;apply'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -b 'b'
            cand --batch 'batch'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -o 'o'
            cand --output 'output'
            cand -c 'c'
            cand --new-column 'new-column'
            cand -R 'R'
            cand --replacement 'replacement'
            cand -r 'r'
            cand --rename 'rename'
            cand -C 'C'
            cand --comparand 'comparand'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
            cand calcconv 'calcconv'
            cand dynfmt 'dynfmt'
            cand emptyreplace 'emptyreplace'
            cand operations 'operations'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;apply;calcconv'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -b 'b'
            cand --batch 'batch'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -o 'o'
            cand --output 'output'
            cand -c 'c'
            cand --new-column 'new-column'
            cand -R 'R'
            cand --replacement 'replacement'
            cand -r 'r'
            cand --rename 'rename'
            cand -C 'C'
            cand --comparand 'comparand'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;apply;dynfmt'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -b 'b'
            cand --batch 'batch'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -o 'o'
            cand --output 'output'
            cand -c 'c'
            cand --new-column 'new-column'
            cand -R 'R'
            cand --replacement 'replacement'
            cand -r 'r'
            cand --rename 'rename'
            cand -C 'C'
            cand --comparand 'comparand'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;apply;emptyreplace'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -b 'b'
            cand --batch 'batch'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -o 'o'
            cand --output 'output'
            cand -c 'c'
            cand --new-column 'new-column'
            cand -R 'R'
            cand --replacement 'replacement'
            cand -r 'r'
            cand --rename 'rename'
            cand -C 'C'
            cand --comparand 'comparand'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;apply;operations'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -b 'b'
            cand --batch 'batch'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -o 'o'
            cand --output 'output'
            cand -c 'c'
            cand --new-column 'new-column'
            cand -R 'R'
            cand --replacement 'replacement'
            cand -r 'r'
            cand --rename 'rename'
            cand -C 'C'
            cand --comparand 'comparand'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;apply;help'= {
            cand calcconv 'calcconv'
            cand dynfmt 'dynfmt'
            cand emptyreplace 'emptyreplace'
            cand operations 'operations'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;apply;help;calcconv'= {
        }
        &'qsv;apply;help;dynfmt'= {
        }
        &'qsv;apply;help;emptyreplace'= {
        }
        &'qsv;apply;help;operations'= {
        }
        &'qsv;apply;help;help'= {
        }
        &'qsv;behead'= {
            cand -o 'o'
            cand --output 'output'
            cand -f 'f'
            cand --flexible 'flexible'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;cat'= {
            cand -N 'N'
            cand --group-name 'group-name'
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -g 'g'
            cand --group 'group'
            cand -p 'p'
            cand --pad 'pad'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --flexible 'flexible'
            cand -h 'Print help'
            cand --help 'Print help'
            cand columns 'columns'
            cand rows 'rows'
            cand rowskey 'rowskey'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;cat;columns'= {
            cand -N 'N'
            cand --group-name 'group-name'
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -g 'g'
            cand --group 'group'
            cand -p 'p'
            cand --pad 'pad'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --flexible 'flexible'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;cat;rows'= {
            cand -N 'N'
            cand --group-name 'group-name'
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -g 'g'
            cand --group 'group'
            cand -p 'p'
            cand --pad 'pad'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --flexible 'flexible'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;cat;rowskey'= {
            cand -N 'N'
            cand --group-name 'group-name'
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -g 'g'
            cand --group 'group'
            cand -p 'p'
            cand --pad 'pad'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --flexible 'flexible'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;cat;help'= {
            cand columns 'columns'
            cand rows 'rows'
            cand rowskey 'rowskey'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;cat;help;columns'= {
        }
        &'qsv;cat;help;rows'= {
        }
        &'qsv;cat;help;rowskey'= {
        }
        &'qsv;cat;help;help'= {
        }
        &'qsv;clipboard'= {
            cand -s 's'
            cand --save 'save'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;color'= {
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -t 't'
            cand --title 'title'
            cand -C 'C'
            cand --color 'color'
            cand -n 'n'
            cand --row-numbers 'row-numbers'
            cand --memcheck 'memcheck'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;count'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --low-memory 'low-memory'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --width-no-delims 'width-no-delims'
            cand -f 'f'
            cand --flexible 'flexible'
            cand --no-polars 'no-polars'
            cand -H 'H'
            cand --human-readable 'human-readable'
            cand --width 'width'
            cand --json 'json'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;datefmt'= {
            cand -b 'b'
            cand --batch 'batch'
            cand -o 'o'
            cand --output 'output'
            cand -c 'c'
            cand --new-column 'new-column'
            cand -R 'R'
            cand --ts-resolution 'ts-resolution'
            cand --output-tz 'output-tz'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --input-tz 'input-tz'
            cand --default-tz 'default-tz'
            cand --formatstr 'formatstr'
            cand -r 'r'
            cand --rename 'rename'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --zulu 'zulu'
            cand --utc 'utc'
            cand --prefer-dmy 'prefer-dmy'
            cand --keep-zero-time 'keep-zero-time'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;dedup'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -s 's'
            cand --select 'select'
            cand -o 'o'
            cand --output 'output'
            cand -D 'D'
            cand --dupes-output 'dupes-output'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand --sorted 'sorted'
            cand --memcheck 'memcheck'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -H 'H'
            cand --human-readable 'human-readable'
            cand -N 'N'
            cand --numeric 'numeric'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;describegpt'= {
            cand -t 't'
            cand --max-tokens 'max-tokens'
            cand --enum-threshold 'enum-threshold'
            cand --prompt-file 'prompt-file'
            cand --ckan-token 'ckan-token'
            cand --sql-results 'sql-results'
            cand --session 'session'
            cand --num-tags 'num-tags'
            cand --export-prompt 'export-prompt'
            cand -p 'p'
            cand --prompt 'prompt'
            cand --freq-options 'freq-options'
            cand --session-len 'session-len'
            cand --addl-props 'addl-props'
            cand -u 'u'
            cand --base-url 'base-url'
            cand --language 'language'
            cand --disk-cache-dir 'disk-cache-dir'
            cand --stats-options 'stats-options'
            cand --sample-size 'sample-size'
            cand --num-examples 'num-examples'
            cand -k 'k'
            cand --api-key 'api-key'
            cand --addl-cols-list 'addl-cols-list'
            cand -m 'm'
            cand --model 'model'
            cand --ckan-api 'ckan-api'
            cand --tag-vocab 'tag-vocab'
            cand --format 'format'
            cand -o 'o'
            cand --output 'output'
            cand --cache-dir 'cache-dir'
            cand --user-agent 'user-agent'
            cand --timeout 'timeout'
            cand --truncate-str 'truncate-str'
            cand -A 'A'
            cand --all 'all'
            cand --dictionary 'dictionary'
            cand --forget 'forget'
            cand --fewshot-examples 'fewshot-examples'
            cand --tags 'tags'
            cand --description 'description'
            cand --addl-cols 'addl-cols'
            cand --redis-cache 'redis-cache'
            cand --fresh 'fresh'
            cand --no-cache 'no-cache'
            cand --flush-cache 'flush-cache'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;diff'= {
            cand --delimiter-right 'delimiter-right'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -k 'k'
            cand --key 'key'
            cand -o 'o'
            cand --output 'output'
            cand --delimiter-output 'delimiter-output'
            cand --delimiter-left 'delimiter-left'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --sort-columns 'sort-columns'
            cand --no-headers-left 'no-headers-left'
            cand --drop-equal-fields 'drop-equal-fields'
            cand --no-headers-output 'no-headers-output'
            cand --no-headers-right 'no-headers-right'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;edit'= {
            cand -o 'o'
            cand --output 'output'
            cand -i 'i'
            cand --in-place 'in-place'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;enum'= {
            cand --copy 'copy'
            cand --constant 'constant'
            cand -o 'o'
            cand --output 'output'
            cand --increment 'increment'
            cand --hash 'hash'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --start 'start'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --uuid7 'uuid7'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --uuid4 'uuid4'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;excel'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand -s 's'
            cand --sheet 'sheet'
            cand --date-format 'date-format'
            cand --metadata 'metadata'
            cand --range 'range'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --header-row 'header-row'
            cand -o 'o'
            cand --output 'output'
            cand --cell 'cell'
            cand --error-format 'error-format'
            cand --table 'table'
            cand --keep-zero-time 'keep-zero-time'
            cand -q 'q'
            cand --quiet 'quiet'
            cand --trim 'trim'
            cand --flexible 'flexible'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;exclude'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -o 'o'
            cand --output 'output'
            cand -v 'v'
            cand --invert 'invert'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;explode'= {
            cand -r 'r'
            cand --rename 'rename'
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;extdedup'= {
            cand --memory-limit 'memory-limit'
            cand --temp-dir 'temp-dir'
            cand -D 'D'
            cand --dupes-output 'dupes-output'
            cand -s 's'
            cand --select 'select'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -q 'q'
            cand --quiet 'quiet'
            cand --no-output 'no-output'
            cand -H 'H'
            cand --human-readable 'human-readable'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;extsort'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand -s 's'
            cand --select 'select'
            cand --tmp-dir 'tmp-dir'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --memory-limit 'memory-limit'
            cand -R 'R'
            cand --reverse 'reverse'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;fetch'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -H 'H'
            cand --http-header 'http-header'
            cand --report 'report'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --user-agent 'user-agent'
            cand -o 'o'
            cand --output 'output'
            cand --mem-cache-size 'mem-cache-size'
            cand --max-errors 'max-errors'
            cand --jaqfile 'jaqfile'
            cand --rate-limit 'rate-limit'
            cand --max-retries 'max-retries'
            cand --disk-cache-dir 'disk-cache-dir'
            cand --timeout 'timeout'
            cand --jaq 'jaq'
            cand --url-template 'url-template'
            cand --flush-cache 'flush-cache'
            cand --redis-cache 'redis-cache'
            cand --cookies 'cookies'
            cand --store-error 'store-error'
            cand --pretty 'pretty'
            cand --disk-cache 'disk-cache'
            cand --no-cache 'no-cache'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --cache-error 'cache-error'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;fetchpost'= {
            cand --jaqfile 'jaqfile'
            cand -t 't'
            cand --payload-tpl 'payload-tpl'
            cand --user-agent 'user-agent'
            cand --content-type 'content-type'
            cand --rate-limit 'rate-limit'
            cand --max-retries 'max-retries'
            cand -j 'j'
            cand --globals-json 'globals-json'
            cand --disk-cache-dir 'disk-cache-dir'
            cand --jaq 'jaq'
            cand --mem-cache-size 'mem-cache-size'
            cand --report 'report'
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --new-column 'new-column'
            cand -H 'H'
            cand --http-header 'http-header'
            cand --max-errors 'max-errors'
            cand --timeout 'timeout'
            cand --cookies 'cookies'
            cand --store-error 'store-error'
            cand --no-cache 'no-cache'
            cand --pretty 'pretty'
            cand --flush-cache 'flush-cache'
            cand --cache-error 'cache-error'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --compress 'compress'
            cand --redis-cache 'redis-cache'
            cand --disk-cache 'disk-cache'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;fill'= {
            cand -g 'g'
            cand --groupby 'groupby'
            cand -o 'o'
            cand --output 'output'
            cand -v 'v'
            cand --default 'default'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -f 'f'
            cand --first 'first'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -b 'b'
            cand --backfill 'backfill'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;fixlengths'= {
            cand -i 'i'
            cand --insert 'insert'
            cand -l 'l'
            cand --length 'length'
            cand -o 'o'
            cand --output 'output'
            cand --quote 'quote'
            cand --escape 'escape'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -r 'r'
            cand --remove-empty 'remove-empty'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;flatten'= {
            cand -c 'c'
            cand --condense 'condense'
            cand -s 's'
            cand --separator 'separator'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -f 'f'
            cand --field-separator 'field-separator'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;fmt'= {
            cand --escape 'escape'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --quote 'quote'
            cand -o 'o'
            cand --output 'output'
            cand -t 't'
            cand --out-delimiter 'out-delimiter'
            cand --ascii 'ascii'
            cand --quote-always 'quote-always'
            cand --no-final-newline 'no-final-newline'
            cand --quote-never 'quote-never'
            cand --crlf 'crlf'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;foreach'= {
            cand -c 'c'
            cand --new-column 'new-column'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --dry-run 'dry-run'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -u 'u'
            cand --unify 'unify'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;frequency'= {
            cand -o 'o'
            cand --output 'output'
            cand --high-card-threshold 'high-card-threshold'
            cand -u 'u'
            cand --unq-limit 'unq-limit'
            cand --all-unique-text 'all-unique-text'
            cand --lmt-threshold 'lmt-threshold'
            cand -r 'r'
            cand --rank-strategy 'rank-strategy'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --null-text 'null-text'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -s 's'
            cand --select 'select'
            cand --weight 'weight'
            cand --other-text 'other-text'
            cand --no-float 'no-float'
            cand --stats-filter 'stats-filter'
            cand --high-card-pct 'high-card-pct'
            cand --pct-dec-places 'pct-dec-places'
            cand -l 'l'
            cand --limit 'limit'
            cand --no-trim 'no-trim'
            cand --pct-nulls 'pct-nulls'
            cand --null-sorted 'null-sorted'
            cand --vis-whitespace 'vis-whitespace'
            cand --no-nulls 'no-nulls'
            cand --toon 'toon'
            cand --pretty-json 'pretty-json'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand --json 'json'
            cand --no-stats 'no-stats'
            cand -a 'a'
            cand --asc 'asc'
            cand --force 'force'
            cand --frequency-jsonl 'frequency-jsonl'
            cand --no-other 'no-other'
            cand --memcheck 'memcheck'
            cand --other-sorted 'other-sorted'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --languages 'languages'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --admin1 'admin1'
            cand -r 'r'
            cand --rename 'rename'
            cand -b 'b'
            cand --batch 'batch'
            cand --timeout 'timeout'
            cand --invalid-result 'invalid-result'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -o 'o'
            cand --output 'output'
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --min-score 'min-score'
            cand --force 'force'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
            cand countryinfo 'countryinfo'
            cand countryinfonow 'countryinfonow'
            cand index-check 'index-check'
            cand index-load 'index-load'
            cand index-reset 'index-reset'
            cand index-update 'index-update'
            cand iplookup 'iplookup'
            cand iplookupnow 'iplookupnow'
            cand reverse 'reverse'
            cand reversenow 'reversenow'
            cand suggest 'suggest'
            cand suggestnow 'suggestnow'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;geocode;countryinfo'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --languages 'languages'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --admin1 'admin1'
            cand -r 'r'
            cand --rename 'rename'
            cand -b 'b'
            cand --batch 'batch'
            cand --timeout 'timeout'
            cand --invalid-result 'invalid-result'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -o 'o'
            cand --output 'output'
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --min-score 'min-score'
            cand --force 'force'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;countryinfonow'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --languages 'languages'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --admin1 'admin1'
            cand -r 'r'
            cand --rename 'rename'
            cand -b 'b'
            cand --batch 'batch'
            cand --timeout 'timeout'
            cand --invalid-result 'invalid-result'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -o 'o'
            cand --output 'output'
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --min-score 'min-score'
            cand --force 'force'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;index-check'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --languages 'languages'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --admin1 'admin1'
            cand -r 'r'
            cand --rename 'rename'
            cand -b 'b'
            cand --batch 'batch'
            cand --timeout 'timeout'
            cand --invalid-result 'invalid-result'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -o 'o'
            cand --output 'output'
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --min-score 'min-score'
            cand --force 'force'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;index-load'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --languages 'languages'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --admin1 'admin1'
            cand -r 'r'
            cand --rename 'rename'
            cand -b 'b'
            cand --batch 'batch'
            cand --timeout 'timeout'
            cand --invalid-result 'invalid-result'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -o 'o'
            cand --output 'output'
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --min-score 'min-score'
            cand --force 'force'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;index-reset'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --languages 'languages'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --admin1 'admin1'
            cand -r 'r'
            cand --rename 'rename'
            cand -b 'b'
            cand --batch 'batch'
            cand --timeout 'timeout'
            cand --invalid-result 'invalid-result'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -o 'o'
            cand --output 'output'
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --min-score 'min-score'
            cand --force 'force'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;index-update'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --languages 'languages'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --admin1 'admin1'
            cand -r 'r'
            cand --rename 'rename'
            cand -b 'b'
            cand --batch 'batch'
            cand --timeout 'timeout'
            cand --invalid-result 'invalid-result'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -o 'o'
            cand --output 'output'
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --min-score 'min-score'
            cand --force 'force'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;iplookup'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --languages 'languages'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --admin1 'admin1'
            cand -r 'r'
            cand --rename 'rename'
            cand -b 'b'
            cand --batch 'batch'
            cand --timeout 'timeout'
            cand --invalid-result 'invalid-result'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -o 'o'
            cand --output 'output'
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --min-score 'min-score'
            cand --force 'force'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;iplookupnow'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --languages 'languages'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --admin1 'admin1'
            cand -r 'r'
            cand --rename 'rename'
            cand -b 'b'
            cand --batch 'batch'
            cand --timeout 'timeout'
            cand --invalid-result 'invalid-result'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -o 'o'
            cand --output 'output'
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --min-score 'min-score'
            cand --force 'force'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;reverse'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --languages 'languages'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --admin1 'admin1'
            cand -r 'r'
            cand --rename 'rename'
            cand -b 'b'
            cand --batch 'batch'
            cand --timeout 'timeout'
            cand --invalid-result 'invalid-result'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -o 'o'
            cand --output 'output'
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --min-score 'min-score'
            cand --force 'force'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;reversenow'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --languages 'languages'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --admin1 'admin1'
            cand -r 'r'
            cand --rename 'rename'
            cand -b 'b'
            cand --batch 'batch'
            cand --timeout 'timeout'
            cand --invalid-result 'invalid-result'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -o 'o'
            cand --output 'output'
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --min-score 'min-score'
            cand --force 'force'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;suggest'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --languages 'languages'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --admin1 'admin1'
            cand -r 'r'
            cand --rename 'rename'
            cand -b 'b'
            cand --batch 'batch'
            cand --timeout 'timeout'
            cand --invalid-result 'invalid-result'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -o 'o'
            cand --output 'output'
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --min-score 'min-score'
            cand --force 'force'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;suggestnow'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --languages 'languages'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --admin1 'admin1'
            cand -r 'r'
            cand --rename 'rename'
            cand -b 'b'
            cand --batch 'batch'
            cand --timeout 'timeout'
            cand --invalid-result 'invalid-result'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -o 'o'
            cand --output 'output'
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --min-score 'min-score'
            cand --force 'force'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;help'= {
            cand countryinfo 'countryinfo'
            cand countryinfonow 'countryinfonow'
            cand index-check 'index-check'
            cand index-load 'index-load'
            cand index-reset 'index-reset'
            cand index-update 'index-update'
            cand iplookup 'iplookup'
            cand iplookupnow 'iplookupnow'
            cand reverse 'reverse'
            cand reversenow 'reversenow'
            cand suggest 'suggest'
            cand suggestnow 'suggestnow'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;geocode;help;countryinfo'= {
        }
        &'qsv;geocode;help;countryinfonow'= {
        }
        &'qsv;geocode;help;index-check'= {
        }
        &'qsv;geocode;help;index-load'= {
        }
        &'qsv;geocode;help;index-reset'= {
        }
        &'qsv;geocode;help;index-update'= {
        }
        &'qsv;geocode;help;iplookup'= {
        }
        &'qsv;geocode;help;iplookupnow'= {
        }
        &'qsv;geocode;help;reverse'= {
        }
        &'qsv;geocode;help;reversenow'= {
        }
        &'qsv;geocode;help;suggest'= {
        }
        &'qsv;geocode;help;suggestnow'= {
        }
        &'qsv;geocode;help;help'= {
        }
        &'qsv;geoconvert'= {
            cand -g 'g'
            cand --geometry 'geometry'
            cand -l 'l'
            cand --max-length 'max-length'
            cand -o 'o'
            cand --output 'output'
            cand -x 'x'
            cand --longitude 'longitude'
            cand -y 'y'
            cand --latitude 'latitude'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;headers'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -J 'J'
            cand --just-count 'just-count'
            cand --intersect 'intersect'
            cand -j 'j'
            cand --just-names 'just-names'
            cand --trim 'trim'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;index'= {
            cand -o 'o'
            cand --output 'output'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;input'= {
            cand --skip-lastlines 'skip-lastlines'
            cand --quote-style 'quote-style'
            cand --quote 'quote'
            cand --encoding-errors 'encoding-errors'
            cand --skip-lines 'skip-lines'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --escape 'escape'
            cand --comment 'comment'
            cand -o 'o'
            cand --output 'output'
            cand --auto-skip 'auto-skip'
            cand --trim-fields 'trim-fields'
            cand --trim-headers 'trim-headers'
            cand --no-quoting 'no-quoting'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;join'= {
            cand -o 'o'
            cand --output 'output'
            cand --keys-output 'keys-output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --nulls 'nulls'
            cand --full 'full'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --right-semi 'right-semi'
            cand --right-anti 'right-anti'
            cand -z 'z'
            cand --ignore-leading-zeros 'ignore-leading-zeros'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand --left-anti 'left-anti'
            cand --right 'right'
            cand --left-semi 'left-semi'
            cand --cross 'cross'
            cand --left 'left'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;joinp'= {
            cand --time-format 'time-format'
            cand --left_by 'left_by'
            cand --maintain-order 'maintain-order'
            cand --strategy 'strategy'
            cand --float-precision 'float-precision'
            cand --tolerance 'tolerance'
            cand -N 'N'
            cand --norm-unicode 'norm-unicode'
            cand --infer-len 'infer-len'
            cand --datetime-format 'datetime-format'
            cand --non-equi 'non-equi'
            cand --filter-right 'filter-right'
            cand --right_by 'right_by'
            cand --filter-left 'filter-left'
            cand --cache-schema 'cache-schema'
            cand --validate 'validate'
            cand --date-format 'date-format'
            cand --sql-filter 'sql-filter'
            cand --null-value 'null-value'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -o 'o'
            cand --output 'output'
            cand --coalesce 'coalesce'
            cand -z 'z'
            cand --ignore-leading-zeros 'ignore-leading-zeros'
            cand --low-memory 'low-memory'
            cand --right-semi 'right-semi'
            cand --left 'left'
            cand --full 'full'
            cand --right-anti 'right-anti'
            cand --decimal-comma 'decimal-comma'
            cand --asof 'asof'
            cand -q 'q'
            cand --quiet 'quiet'
            cand --nulls 'nulls'
            cand --streaming 'streaming'
            cand --left-semi 'left-semi'
            cand --no-sort 'no-sort'
            cand -X 'X'
            cand --allow-exact-matches 'allow-exact-matches'
            cand --right 'right'
            cand --cross 'cross'
            cand --left-anti 'left-anti'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand --try-parsedates 'try-parsedates'
            cand --ignore-errors 'ignore-errors'
            cand --no-optimizations 'no-optimizations'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;json'= {
            cand -o 'o'
            cand --output 'output'
            cand --jaq 'jaq'
            cand -s 's'
            cand --select 'select'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;jsonl'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -b 'b'
            cand --batch 'batch'
            cand -o 'o'
            cand --output 'output'
            cand --ignore-errors 'ignore-errors'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;lens'= {
            cand --columns 'columns'
            cand --filter 'filter'
            cand -W 'W'
            cand --wrap-mode 'wrap-mode'
            cand --echo-column 'echo-column'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -P 'P'
            cand --prompt 'prompt'
            cand --find 'find'
            cand -f 'f'
            cand --freeze-columns 'freeze-columns'
            cand --debug 'debug'
            cand -m 'm'
            cand --monochrome 'monochrome'
            cand -A 'A'
            cand --auto-reload 'auto-reload'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand -t 't'
            cand --tab-separated 'tab-separated'
            cand --no-headers 'no-headers'
            cand -S 'S'
            cand --streaming-stdin 'streaming-stdin'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;log'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;luau'= {
            cand --timeout 'timeout'
            cand --ckan-token 'ckan-token'
            cand -E 'E'
            cand --end 'end'
            cand -B 'B'
            cand --begin 'begin'
            cand -o 'o'
            cand --output 'output'
            cand --max-errors 'max-errors'
            cand --ckan-api 'ckan-api'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --cache-dir 'cache-dir'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -r 'r'
            cand --remap 'remap'
            cand --colindex 'colindex'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -g 'g'
            cand --no-globals 'no-globals'
            cand -h 'Print help'
            cand --help 'Print help'
            cand filter 'filter'
            cand map 'map'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;luau;filter'= {
            cand --timeout 'timeout'
            cand --ckan-token 'ckan-token'
            cand -E 'E'
            cand --end 'end'
            cand -B 'B'
            cand --begin 'begin'
            cand -o 'o'
            cand --output 'output'
            cand --max-errors 'max-errors'
            cand --ckan-api 'ckan-api'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --cache-dir 'cache-dir'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -r 'r'
            cand --remap 'remap'
            cand --colindex 'colindex'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -g 'g'
            cand --no-globals 'no-globals'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;luau;map'= {
            cand --timeout 'timeout'
            cand --ckan-token 'ckan-token'
            cand -E 'E'
            cand --end 'end'
            cand -B 'B'
            cand --begin 'begin'
            cand -o 'o'
            cand --output 'output'
            cand --max-errors 'max-errors'
            cand --ckan-api 'ckan-api'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --cache-dir 'cache-dir'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -r 'r'
            cand --remap 'remap'
            cand --colindex 'colindex'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -g 'g'
            cand --no-globals 'no-globals'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;luau;help'= {
            cand filter 'filter'
            cand map 'map'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;luau;help;filter'= {
        }
        &'qsv;luau;help;map'= {
        }
        &'qsv;luau;help;help'= {
        }
        &'qsv;moarstats'= {
            cand -K 'K'
            cand --join-keys 'join-keys'
            cand -C 'C'
            cand --cardinality-threshold 'cardinality-threshold'
            cand -J 'J'
            cand --join-inputs 'join-inputs'
            cand --pct-thresholds 'pct-thresholds'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -T 'T'
            cand --join-type 'join-type'
            cand --round 'round'
            cand -S 'S'
            cand --bivariate-stats 'bivariate-stats'
            cand -o 'o'
            cand --output 'output'
            cand --stats-options 'stats-options'
            cand -e 'e'
            cand --epsilon 'epsilon'
            cand --xsd-gdate-scan 'xsd-gdate-scan'
            cand --use-percentiles 'use-percentiles'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --force 'force'
            cand --advanced 'advanced'
            cand -B 'B'
            cand --bivariate 'bivariate'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;partition'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --filename 'filename'
            cand -p 'p'
            cand --prefix-length 'prefix-length'
            cand --limit 'limit'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --drop 'drop'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;pivotp'= {
            cand -v 'v'
            cand --values 'values'
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --infer-len 'infer-len'
            cand -a 'a'
            cand --agg 'agg'
            cand -i 'i'
            cand --index 'index'
            cand --col-separator 'col-separator'
            cand --try-parsedates 'try-parsedates'
            cand --sort-columns 'sort-columns'
            cand --maintain-order 'maintain-order'
            cand --decimal-comma 'decimal-comma'
            cand --validate 'validate'
            cand --ignore-errors 'ignore-errors'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;pragmastat'= {
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -s 's'
            cand --select 'select'
            cand -m 'm'
            cand --misrate 'misrate'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -t 't'
            cand --twosample 'twosample'
            cand --memcheck 'memcheck'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;pro'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand lens 'lens'
            cand workflow 'workflow'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;pro;lens'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;pro;workflow'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;pro;help'= {
            cand lens 'lens'
            cand workflow 'workflow'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;pro;help;lens'= {
        }
        &'qsv;pro;help;workflow'= {
        }
        &'qsv;pro;help;help'= {
        }
        &'qsv;prompt'= {
            cand -F 'F'
            cand --filters 'filters'
            cand -m 'm'
            cand --msg 'msg'
            cand --base-delay-ms 'base-delay-ms'
            cand -d 'd'
            cand --workdir 'workdir'
            cand --save-fname 'save-fname'
            cand -o 'o'
            cand --output 'output'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -f 'f'
            cand --fd-output 'fd-output'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;pseudo'= {
            cand --formatstr 'formatstr'
            cand --increment 'increment'
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --start 'start'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;py'= {
            cand -f 'f'
            cand --helper 'helper'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -o 'o'
            cand --output 'output'
            cand -b 'b'
            cand --batch 'batch'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
            cand filter 'filter'
            cand map 'map'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;py;filter'= {
            cand -f 'f'
            cand --helper 'helper'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -o 'o'
            cand --output 'output'
            cand -b 'b'
            cand --batch 'batch'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;py;map'= {
            cand -f 'f'
            cand --helper 'helper'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -o 'o'
            cand --output 'output'
            cand -b 'b'
            cand --batch 'batch'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;py;help'= {
            cand filter 'filter'
            cand map 'map'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;py;help;filter'= {
        }
        &'qsv;py;help;map'= {
        }
        &'qsv;py;help;help'= {
        }
        &'qsv;rename'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -o 'o'
            cand --output 'output'
            cand --pairwise 'pairwise'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;replace'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --size-limit 'size-limit'
            cand --dfa-size-limit 'dfa-size-limit'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -o 'o'
            cand --output 'output'
            cand -s 's'
            cand --select 'select'
            cand --exact 'exact'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --not-one 'not-one'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -u 'u'
            cand --unicode 'unicode'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand --literal 'literal'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;reverse'= {
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --memcheck 'memcheck'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;safenames'= {
            cand --reserved 'reserved'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -o 'o'
            cand --output 'output'
            cand --mode 'mode'
            cand --prefix 'prefix'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;sample'= {
            cand --timeseries 'timeseries'
            cand --ts-adaptive 'ts-adaptive'
            cand --cluster 'cluster'
            cand --timeout 'timeout'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --seed 'seed'
            cand --ts-start 'ts-start'
            cand --ts-aggregate 'ts-aggregate'
            cand --user-agent 'user-agent'
            cand --rng 'rng'
            cand --ts-interval 'ts-interval'
            cand --weighted 'weighted'
            cand --systematic 'systematic'
            cand --max-size 'max-size'
            cand -o 'o'
            cand --output 'output'
            cand --ts-input-tz 'ts-input-tz'
            cand --stratified 'stratified'
            cand --bernoulli 'bernoulli'
            cand --force 'force'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --ts-prefer-dmy 'ts-prefer-dmy'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;schema'= {
            cand --enum-threshold 'enum-threshold'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --pattern-columns 'pattern-columns'
            cand -o 'o'
            cand --output 'output'
            cand --dates-whitelist 'dates-whitelist'
            cand --strict-formats 'strict-formats'
            cand --strict-dates 'strict-dates'
            cand --prefer-dmy 'prefer-dmy'
            cand --polars 'polars'
            cand --memcheck 'memcheck'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --force 'force'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand --stdout 'stdout'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;search'= {
            cand -f 'f'
            cand --flag 'flag'
            cand -s 's'
            cand --select 'select'
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --size-limit 'size-limit'
            cand --dfa-size-limit 'dfa-size-limit'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --preview-match 'preview-match'
            cand --literal 'literal'
            cand -u 'u'
            cand --unicode 'unicode'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -Q 'Q'
            cand --quick 'quick'
            cand --not-one 'not-one'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -v 'v'
            cand --invert-match 'invert-match'
            cand -q 'q'
            cand --quiet 'quiet'
            cand --exact 'exact'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand --json 'json'
            cand -c 'c'
            cand --count 'count'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;searchset'= {
            cand --unmatched-output 'unmatched-output'
            cand -s 's'
            cand --select 'select'
            cand --jobs 'jobs'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -f 'f'
            cand --flag 'flag'
            cand --size-limit 'size-limit'
            cand --dfa-size-limit 'dfa-size-limit'
            cand -o 'o'
            cand --output 'output'
            cand --not-one 'not-one'
            cand --exact 'exact'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand --flag-matches-only 'flag-matches-only'
            cand -Q 'Q'
            cand --quick 'quick'
            cand --literal 'literal'
            cand -c 'c'
            cand --count 'count'
            cand -v 'v'
            cand --invert-match 'invert-match'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -j 'j'
            cand --json 'json'
            cand -u 'u'
            cand --unicode 'unicode'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;select'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -o 'o'
            cand --output 'output'
            cand --seed 'seed'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -S 'S'
            cand --sort 'sort'
            cand -R 'R'
            cand --random 'random'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;slice'= {
            cand -o 'o'
            cand --output 'output'
            cand -s 's'
            cand --start 'start'
            cand -e 'e'
            cand --end 'end'
            cand -l 'l'
            cand --len 'len'
            cand -i 'i'
            cand --index 'index'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --invert 'invert'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --json 'json'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;snappy'= {
            cand -o 'o'
            cand --output 'output'
            cand --user-agent 'user-agent'
            cand --timeout 'timeout'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
            cand check 'check'
            cand compress 'compress'
            cand decompress 'decompress'
            cand validate 'validate'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;snappy;check'= {
            cand -o 'o'
            cand --output 'output'
            cand --user-agent 'user-agent'
            cand --timeout 'timeout'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;snappy;compress'= {
            cand -o 'o'
            cand --output 'output'
            cand --user-agent 'user-agent'
            cand --timeout 'timeout'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;snappy;decompress'= {
            cand -o 'o'
            cand --output 'output'
            cand --user-agent 'user-agent'
            cand --timeout 'timeout'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;snappy;validate'= {
            cand -o 'o'
            cand --output 'output'
            cand --user-agent 'user-agent'
            cand --timeout 'timeout'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;snappy;help'= {
            cand check 'check'
            cand compress 'compress'
            cand decompress 'decompress'
            cand validate 'validate'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;snappy;help;check'= {
        }
        &'qsv;snappy;help;compress'= {
        }
        &'qsv;snappy;help;decompress'= {
        }
        &'qsv;snappy;help;validate'= {
        }
        &'qsv;snappy;help;help'= {
        }
        &'qsv;sniff'= {
            cand --quote 'quote'
            cand --user-agent 'user-agent'
            cand --sample 'sample'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --timeout 'timeout'
            cand --save-urlsample 'save-urlsample'
            cand --harvest-mode 'harvest-mode'
            cand --stats-types 'stats-types'
            cand --json 'json'
            cand --pretty-json 'pretty-json'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --prefer-dmy 'prefer-dmy'
            cand -Q 'Q'
            cand --quick 'quick'
            cand --no-infer 'no-infer'
            cand --just-mime 'just-mime'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;sort'= {
            cand -s 's'
            cand --select 'select'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -o 'o'
            cand --output 'output'
            cand --seed 'seed'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --rng 'rng'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand -N 'N'
            cand --numeric 'numeric'
            cand --natural 'natural'
            cand --memcheck 'memcheck'
            cand -u 'u'
            cand --unique 'unique'
            cand --random 'random'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -R 'R'
            cand --reverse 'reverse'
            cand --faster 'faster'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;sortcheck'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -s 's'
            cand --select 'select'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --json 'json'
            cand --all 'all'
            cand --pretty-json 'pretty-json'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;split'= {
            cand -k 'k'
            cand --kb-size 'kb-size'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --chunks 'chunks'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --pad 'pad'
            cand --filename 'filename'
            cand --filter 'filter'
            cand -s 's'
            cand --size 'size'
            cand -q 'q'
            cand --quiet 'quiet'
            cand --filter-cleanup 'filter-cleanup'
            cand --filter-ignore-errors 'filter-ignore-errors'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;sqlp'= {
            cand --infer-len 'infer-len'
            cand --time-format 'time-format'
            cand --float-precision 'float-precision'
            cand --wnull-value 'wnull-value'
            cand --date-format 'date-format'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --compress-level 'compress-level'
            cand --rnull-values 'rnull-values'
            cand -o 'o'
            cand --output 'output'
            cand --format 'format'
            cand --datetime-format 'datetime-format'
            cand --compression 'compression'
            cand --statistics 'statistics'
            cand --streaming 'streaming'
            cand --try-parsedates 'try-parsedates'
            cand --decimal-comma 'decimal-comma'
            cand --low-memory 'low-memory'
            cand --no-optimizations 'no-optimizations'
            cand --truncate-ragged-lines 'truncate-ragged-lines'
            cand --cache-schema 'cache-schema'
            cand -q 'q'
            cand --quiet 'quiet'
            cand --ignore-errors 'ignore-errors'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;stats'= {
            cand --boolean-patterns 'boolean-patterns'
            cand --percentile-list 'percentile-list'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --cache-threshold 'cache-threshold'
            cand --round 'round'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -s 's'
            cand --select 'select'
            cand --weight 'weight'
            cand -o 'o'
            cand --output 'output'
            cand --dates-whitelist 'dates-whitelist'
            cand -E 'E'
            cand --everything 'everything'
            cand --infer-dates 'infer-dates'
            cand --stats-jsonl 'stats-jsonl'
            cand --prefer-dmy 'prefer-dmy'
            cand --vis-whitespace 'vis-whitespace'
            cand --memcheck 'memcheck'
            cand --nulls 'nulls'
            cand --typesonly 'typesonly'
            cand --cardinality 'cardinality'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --mode 'mode'
            cand --percentiles 'percentiles'
            cand --force 'force'
            cand --quartiles 'quartiles'
            cand --infer-boolean 'infer-boolean'
            cand --median 'median'
            cand --mad 'mad'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;table'= {
            cand -c 'c'
            cand --condense 'condense'
            cand -p 'p'
            cand --pad 'pad'
            cand -w 'w'
            cand --width 'width'
            cand -o 'o'
            cand --output 'output'
            cand -a 'a'
            cand --align 'align'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --memcheck 'memcheck'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;template'= {
            cand --customfilter-error 'customfilter-error'
            cand --cache-dir 'cache-dir'
            cand -j 'j'
            cand --globals-json 'globals-json'
            cand -o 'o'
            cand --output 'output'
            cand --template 'template'
            cand --delimiter 'delimiter'
            cand -t 't'
            cand --template-file 'template-file'
            cand -b 'b'
            cand --batch 'batch'
            cand --timeout 'timeout'
            cand --ckan-api 'ckan-api'
            cand --ckan-token 'ckan-token'
            cand --outfilename 'outfilename'
            cand --outsubdir-size 'outsubdir-size'
            cand --jobs 'jobs'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;to'= {
            cand -s 's'
            cand --schema 'schema'
            cand -p 'p'
            cand --separator 'separator'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --stats-csv 'stats-csv'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -a 'a'
            cand --stats 'stats'
            cand --drop 'drop'
            cand -u 'u'
            cand --dump 'dump'
            cand -A 'A'
            cand --all-strings 'all-strings'
            cand -k 'k'
            cand --print-package 'print-package'
            cand -e 'e'
            cand --evolve 'evolve'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -i 'i'
            cand --pipe 'pipe'
            cand -h 'Print help'
            cand --help 'Print help'
            cand datapackage 'datapackage'
            cand ods 'ods'
            cand postgres 'postgres'
            cand sqlite 'sqlite'
            cand xlsx 'xlsx'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;to;datapackage'= {
            cand -s 's'
            cand --schema 'schema'
            cand -p 'p'
            cand --separator 'separator'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --stats-csv 'stats-csv'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -a 'a'
            cand --stats 'stats'
            cand --drop 'drop'
            cand -u 'u'
            cand --dump 'dump'
            cand -A 'A'
            cand --all-strings 'all-strings'
            cand -k 'k'
            cand --print-package 'print-package'
            cand -e 'e'
            cand --evolve 'evolve'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -i 'i'
            cand --pipe 'pipe'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;to;ods'= {
            cand -s 's'
            cand --schema 'schema'
            cand -p 'p'
            cand --separator 'separator'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --stats-csv 'stats-csv'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -a 'a'
            cand --stats 'stats'
            cand --drop 'drop'
            cand -u 'u'
            cand --dump 'dump'
            cand -A 'A'
            cand --all-strings 'all-strings'
            cand -k 'k'
            cand --print-package 'print-package'
            cand -e 'e'
            cand --evolve 'evolve'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -i 'i'
            cand --pipe 'pipe'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;to;postgres'= {
            cand -s 's'
            cand --schema 'schema'
            cand -p 'p'
            cand --separator 'separator'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --stats-csv 'stats-csv'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -a 'a'
            cand --stats 'stats'
            cand --drop 'drop'
            cand -u 'u'
            cand --dump 'dump'
            cand -A 'A'
            cand --all-strings 'all-strings'
            cand -k 'k'
            cand --print-package 'print-package'
            cand -e 'e'
            cand --evolve 'evolve'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -i 'i'
            cand --pipe 'pipe'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;to;sqlite'= {
            cand -s 's'
            cand --schema 'schema'
            cand -p 'p'
            cand --separator 'separator'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --stats-csv 'stats-csv'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -a 'a'
            cand --stats 'stats'
            cand --drop 'drop'
            cand -u 'u'
            cand --dump 'dump'
            cand -A 'A'
            cand --all-strings 'all-strings'
            cand -k 'k'
            cand --print-package 'print-package'
            cand -e 'e'
            cand --evolve 'evolve'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -i 'i'
            cand --pipe 'pipe'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;to;xlsx'= {
            cand -s 's'
            cand --schema 'schema'
            cand -p 'p'
            cand --separator 'separator'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --stats-csv 'stats-csv'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -a 'a'
            cand --stats 'stats'
            cand --drop 'drop'
            cand -u 'u'
            cand --dump 'dump'
            cand -A 'A'
            cand --all-strings 'all-strings'
            cand -k 'k'
            cand --print-package 'print-package'
            cand -e 'e'
            cand --evolve 'evolve'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -i 'i'
            cand --pipe 'pipe'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;to;help'= {
            cand datapackage 'datapackage'
            cand ods 'ods'
            cand postgres 'postgres'
            cand sqlite 'sqlite'
            cand xlsx 'xlsx'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;to;help;datapackage'= {
        }
        &'qsv;to;help;ods'= {
        }
        &'qsv;to;help;postgres'= {
        }
        &'qsv;to;help;sqlite'= {
        }
        &'qsv;to;help;xlsx'= {
        }
        &'qsv;to;help;help'= {
        }
        &'qsv;tojsonl'= {
            cand -b 'b'
            cand --batch 'batch'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -o 'o'
            cand --output 'output'
            cand --no-boolean 'no-boolean'
            cand --trim 'trim'
            cand --memcheck 'memcheck'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;transpose'= {
            cand -s 's'
            cand --select 'select'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -o 'o'
            cand --output 'output'
            cand --long 'long'
            cand --memcheck 'memcheck'
            cand -m 'm'
            cand --multipass 'multipass'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;validate'= {
            cand --ckan-api 'ckan-api'
            cand --backtrack-limit 'backtrack-limit'
            cand --invalid 'invalid'
            cand --email-min-subdomains 'email-min-subdomains'
            cand --valid 'valid'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --ckan-token 'ckan-token'
            cand --valid-output 'valid-output'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --timeout 'timeout'
            cand -b 'b'
            cand --batch 'batch'
            cand --size-limit 'size-limit'
            cand --dfa-size-limit 'dfa-size-limit'
            cand --cache-dir 'cache-dir'
            cand --email-display-text 'email-display-text'
            cand --email-domain-literal 'email-domain-literal'
            cand --trim 'trim'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --fail-fast 'fail-fast'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --email-required-tld 'email-required-tld'
            cand --no-format-validation 'no-format-validation'
            cand --fancy-regex 'fancy-regex'
            cand --json 'json'
            cand --pretty-json 'pretty-json'
            cand -h 'Print help'
            cand --help 'Print help'
            cand schema 'schema'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;validate;schema'= {
            cand --ckan-api 'ckan-api'
            cand --backtrack-limit 'backtrack-limit'
            cand --invalid 'invalid'
            cand --email-min-subdomains 'email-min-subdomains'
            cand --valid 'valid'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --ckan-token 'ckan-token'
            cand --valid-output 'valid-output'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --timeout 'timeout'
            cand -b 'b'
            cand --batch 'batch'
            cand --size-limit 'size-limit'
            cand --dfa-size-limit 'dfa-size-limit'
            cand --cache-dir 'cache-dir'
            cand --email-display-text 'email-display-text'
            cand --email-domain-literal 'email-domain-literal'
            cand --trim 'trim'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --fail-fast 'fail-fast'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --email-required-tld 'email-required-tld'
            cand --no-format-validation 'no-format-validation'
            cand --fancy-regex 'fancy-regex'
            cand --json 'json'
            cand --pretty-json 'pretty-json'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;validate;help'= {
            cand schema 'schema'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;validate;help;schema'= {
        }
        &'qsv;validate;help;help'= {
        }
        &'qsv;help'= {
            cand apply 'apply'
            cand behead 'behead'
            cand cat 'cat'
            cand clipboard 'clipboard'
            cand color 'color'
            cand count 'count'
            cand datefmt 'datefmt'
            cand dedup 'dedup'
            cand describegpt 'describegpt'
            cand diff 'diff'
            cand edit 'edit'
            cand enum 'enum'
            cand excel 'excel'
            cand exclude 'exclude'
            cand explode 'explode'
            cand extdedup 'extdedup'
            cand extsort 'extsort'
            cand fetch 'fetch'
            cand fetchpost 'fetchpost'
            cand fill 'fill'
            cand fixlengths 'fixlengths'
            cand flatten 'flatten'
            cand fmt 'fmt'
            cand foreach 'foreach'
            cand frequency 'frequency'
            cand geocode 'geocode'
            cand geoconvert 'geoconvert'
            cand headers 'headers'
            cand index 'index'
            cand input 'input'
            cand join 'join'
            cand joinp 'joinp'
            cand json 'json'
            cand jsonl 'jsonl'
            cand lens 'lens'
            cand log 'log'
            cand luau 'luau'
            cand moarstats 'moarstats'
            cand partition 'partition'
            cand pivotp 'pivotp'
            cand pragmastat 'pragmastat'
            cand pro 'pro'
            cand prompt 'prompt'
            cand pseudo 'pseudo'
            cand py 'py'
            cand rename 'rename'
            cand replace 'replace'
            cand reverse 'reverse'
            cand safenames 'safenames'
            cand sample 'sample'
            cand schema 'schema'
            cand search 'search'
            cand searchset 'searchset'
            cand select 'select'
            cand slice 'slice'
            cand snappy 'snappy'
            cand sniff 'sniff'
            cand sort 'sort'
            cand sortcheck 'sortcheck'
            cand split 'split'
            cand sqlp 'sqlp'
            cand stats 'stats'
            cand table 'table'
            cand template 'template'
            cand to 'to'
            cand tojsonl 'tojsonl'
            cand transpose 'transpose'
            cand validate 'validate'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;help;apply'= {
            cand calcconv 'calcconv'
            cand dynfmt 'dynfmt'
            cand emptyreplace 'emptyreplace'
            cand operations 'operations'
        }
        &'qsv;help;apply;calcconv'= {
        }
        &'qsv;help;apply;dynfmt'= {
        }
        &'qsv;help;apply;emptyreplace'= {
        }
        &'qsv;help;apply;operations'= {
        }
        &'qsv;help;behead'= {
        }
        &'qsv;help;cat'= {
            cand columns 'columns'
            cand rows 'rows'
            cand rowskey 'rowskey'
        }
        &'qsv;help;cat;columns'= {
        }
        &'qsv;help;cat;rows'= {
        }
        &'qsv;help;cat;rowskey'= {
        }
        &'qsv;help;clipboard'= {
        }
        &'qsv;help;color'= {
        }
        &'qsv;help;count'= {
        }
        &'qsv;help;datefmt'= {
        }
        &'qsv;help;dedup'= {
        }
        &'qsv;help;describegpt'= {
        }
        &'qsv;help;diff'= {
        }
        &'qsv;help;edit'= {
        }
        &'qsv;help;enum'= {
        }
        &'qsv;help;excel'= {
        }
        &'qsv;help;exclude'= {
        }
        &'qsv;help;explode'= {
        }
        &'qsv;help;extdedup'= {
        }
        &'qsv;help;extsort'= {
        }
        &'qsv;help;fetch'= {
        }
        &'qsv;help;fetchpost'= {
        }
        &'qsv;help;fill'= {
        }
        &'qsv;help;fixlengths'= {
        }
        &'qsv;help;flatten'= {
        }
        &'qsv;help;fmt'= {
        }
        &'qsv;help;foreach'= {
        }
        &'qsv;help;frequency'= {
        }
        &'qsv;help;geocode'= {
            cand countryinfo 'countryinfo'
            cand countryinfonow 'countryinfonow'
            cand index-check 'index-check'
            cand index-load 'index-load'
            cand index-reset 'index-reset'
            cand index-update 'index-update'
            cand iplookup 'iplookup'
            cand iplookupnow 'iplookupnow'
            cand reverse 'reverse'
            cand reversenow 'reversenow'
            cand suggest 'suggest'
            cand suggestnow 'suggestnow'
        }
        &'qsv;help;geocode;countryinfo'= {
        }
        &'qsv;help;geocode;countryinfonow'= {
        }
        &'qsv;help;geocode;index-check'= {
        }
        &'qsv;help;geocode;index-load'= {
        }
        &'qsv;help;geocode;index-reset'= {
        }
        &'qsv;help;geocode;index-update'= {
        }
        &'qsv;help;geocode;iplookup'= {
        }
        &'qsv;help;geocode;iplookupnow'= {
        }
        &'qsv;help;geocode;reverse'= {
        }
        &'qsv;help;geocode;reversenow'= {
        }
        &'qsv;help;geocode;suggest'= {
        }
        &'qsv;help;geocode;suggestnow'= {
        }
        &'qsv;help;geoconvert'= {
        }
        &'qsv;help;headers'= {
        }
        &'qsv;help;index'= {
        }
        &'qsv;help;input'= {
        }
        &'qsv;help;join'= {
        }
        &'qsv;help;joinp'= {
        }
        &'qsv;help;json'= {
        }
        &'qsv;help;jsonl'= {
        }
        &'qsv;help;lens'= {
        }
        &'qsv;help;log'= {
        }
        &'qsv;help;luau'= {
            cand filter 'filter'
            cand map 'map'
        }
        &'qsv;help;luau;filter'= {
        }
        &'qsv;help;luau;map'= {
        }
        &'qsv;help;moarstats'= {
        }
        &'qsv;help;partition'= {
        }
        &'qsv;help;pivotp'= {
        }
        &'qsv;help;pragmastat'= {
        }
        &'qsv;help;pro'= {
            cand lens 'lens'
            cand workflow 'workflow'
        }
        &'qsv;help;pro;lens'= {
        }
        &'qsv;help;pro;workflow'= {
        }
        &'qsv;help;prompt'= {
        }
        &'qsv;help;pseudo'= {
        }
        &'qsv;help;py'= {
            cand filter 'filter'
            cand map 'map'
        }
        &'qsv;help;py;filter'= {
        }
        &'qsv;help;py;map'= {
        }
        &'qsv;help;rename'= {
        }
        &'qsv;help;replace'= {
        }
        &'qsv;help;reverse'= {
        }
        &'qsv;help;safenames'= {
        }
        &'qsv;help;sample'= {
        }
        &'qsv;help;schema'= {
        }
        &'qsv;help;search'= {
        }
        &'qsv;help;searchset'= {
        }
        &'qsv;help;select'= {
        }
        &'qsv;help;slice'= {
        }
        &'qsv;help;snappy'= {
            cand check 'check'
            cand compress 'compress'
            cand decompress 'decompress'
            cand validate 'validate'
        }
        &'qsv;help;snappy;check'= {
        }
        &'qsv;help;snappy;compress'= {
        }
        &'qsv;help;snappy;decompress'= {
        }
        &'qsv;help;snappy;validate'= {
        }
        &'qsv;help;sniff'= {
        }
        &'qsv;help;sort'= {
        }
        &'qsv;help;sortcheck'= {
        }
        &'qsv;help;split'= {
        }
        &'qsv;help;sqlp'= {
        }
        &'qsv;help;stats'= {
        }
        &'qsv;help;table'= {
        }
        &'qsv;help;template'= {
        }
        &'qsv;help;to'= {
            cand datapackage 'datapackage'
            cand ods 'ods'
            cand postgres 'postgres'
            cand sqlite 'sqlite'
            cand xlsx 'xlsx'
        }
        &'qsv;help;to;datapackage'= {
        }
        &'qsv;help;to;ods'= {
        }
        &'qsv;help;to;postgres'= {
        }
        &'qsv;help;to;sqlite'= {
        }
        &'qsv;help;to;xlsx'= {
        }
        &'qsv;help;tojsonl'= {
        }
        &'qsv;help;transpose'= {
        }
        &'qsv;help;validate'= {
            cand schema 'schema'
        }
        &'qsv;help;validate;schema'= {
        }
        &'qsv;help;help'= {
        }
    ]
    $completions[$command]
}
