/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public final class UnpickleContext {
    byte[] image;
    int absoluteOffset;
    int beginOffset;
    int markedOffset;
    Vector patches;
    long[] ldsOffsets;
    boolean[] nullIndicators;
    boolean bigEndian;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;

    public UnpickleContext() {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, UnpickleContext.class, $$$methodRef$$$20, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, UnpickleContext.class, $$$methodRef$$$20, null);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, UnpickleContext.class, $$$methodRef$$$20, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, UnpickleContext.class, $$$methodRef$$$20, null, throwable2);
            }
            throw throwable;
        }
    }

    public UnpickleContext(byte[] image, int begin_offset, boolean[] null_bytes, long[] lds_offset_array, boolean big_endian) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, UnpickleContext.class, $$$methodRef$$$21, null, image, begin_offset, null_bytes, lds_offset_array, big_endian);
            }
            this.image = image;
            this.beginOffset = begin_offset;
            this.absoluteOffset = begin_offset;
            this.bigEndian = big_endian;
            this.nullIndicators = null_bytes;
            this.patches = null;
            this.ldsOffsets = lds_offset_array;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, UnpickleContext.class, $$$methodRef$$$21, null);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, UnpickleContext.class, $$$methodRef$$$21, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, UnpickleContext.class, $$$methodRef$$$21, null, throwable2);
            }
            throw throwable;
        }
    }

    public byte readByte() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            byte by;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, UnpickleContext.class, $$$methodRef$$$0, this, new Object[0]);
                }
                try {
                    byte by2 = this.image[this.absoluteOffset];
                    ++this.absoluteOffset;
                    by = by2;
                    if (!bl) break block7;
                }
                catch (Throwable throwable) {
                    ++this.absoluteOffset;
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, UnpickleContext.class, $$$methodRef$$$0, this, throwable2);
                    }
                    throw throwable2;
                }
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, UnpickleContext.class, $$$methodRef$$$0, this, by);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, UnpickleContext.class, $$$methodRef$$$0, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, UnpickleContext.class, $$$methodRef$$$0, this, throwable3);
            }
            throw throwable;
        }
    }

    public byte[] readVarNumBytes() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, UnpickleContext.class, $$$methodRef$$$1, this, new Object[0]);
            }
            byte[] varNumBytes = new byte[this.image[this.absoluteOffset] & 0xFF];
            try {
                System.arraycopy(this.image, this.absoluteOffset + 1, varNumBytes, 0, varNumBytes.length);
                this.absoluteOffset += 22;
            }
            catch (Throwable throwable) {
                this.absoluteOffset += 22;
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, UnpickleContext.class, $$$methodRef$$$1, this, throwable2);
                }
                throw throwable2;
            }
            byte[] byArray = varNumBytes;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, UnpickleContext.class, $$$methodRef$$$1, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, UnpickleContext.class, $$$methodRef$$$1, this, null);
            }
            return varNumBytes;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, UnpickleContext.class, $$$methodRef$$$1, this, throwable3);
            }
            throw throwable;
        }
    }

    public byte[] readPtrBytes() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, UnpickleContext.class, $$$methodRef$$$2, this, new Object[0]);
            }
            byte[] bytes = new byte[(this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF) + 2];
            System.arraycopy(this.image, this.absoluteOffset, bytes, 0, bytes.length);
            this.absoluteOffset += bytes.length;
            byte[] byArray = bytes;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, UnpickleContext.class, $$$methodRef$$$2, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, UnpickleContext.class, $$$methodRef$$$2, this, null);
            }
            return bytes;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, UnpickleContext.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    public void skipPtrBytes() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, UnpickleContext.class, $$$methodRef$$$3, this, new Object[0]);
            }
            this.absoluteOffset += (this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF) + 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, UnpickleContext.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, UnpickleContext.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, UnpickleContext.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public byte[] readBytes(int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] byArray;
            block7: {
                byte[] byArray2;
                void n3;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, UnpickleContext.class, $$$methodRef$$$4, this, n2);
                }
                try {
                    byte[] bytes = new byte[n3];
                    System.arraycopy(this.image, this.absoluteOffset, bytes, 0, (int)n3);
                    byArray = bytes;
                    this.absoluteOffset += n3;
                    byArray2 = byArray;
                    if (!bl) break block7;
                }
                catch (Throwable throwable) {
                    this.absoluteOffset += n3;
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, UnpickleContext.class, $$$methodRef$$$4, this, throwable2);
                    }
                    throw throwable2;
                }
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, UnpickleContext.class, $$$methodRef$$$4, this, byArray2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, UnpickleContext.class, $$$methodRef$$$4, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, UnpickleContext.class, $$$methodRef$$$4, this, throwable3);
            }
            throw throwable;
        }
    }

    public long readLong() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            long l2;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, UnpickleContext.class, $$$methodRef$$$5, this, new Object[0]);
                }
                try {
                    long l3 = (((this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF)) * 256 + (this.image[this.absoluteOffset + 2] & 0xFF)) * 256 + (this.image[this.absoluteOffset + 3] & 0xFF);
                    this.absoluteOffset += 4;
                    l2 = l3;
                    if (!bl) break block7;
                }
                catch (Throwable throwable) {
                    this.absoluteOffset += 4;
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, UnpickleContext.class, $$$methodRef$$$5, this, throwable2);
                    }
                    throw throwable2;
                }
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, UnpickleContext.class, $$$methodRef$$$5, this, l2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, UnpickleContext.class, $$$methodRef$$$5, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, UnpickleContext.class, $$$methodRef$$$5, this, throwable3);
            }
            throw throwable;
        }
    }

    public short readShort() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            short s2;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, UnpickleContext.class, $$$methodRef$$$6, this, new Object[0]);
                }
                try {
                    short s3 = (short)((this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF));
                    this.absoluteOffset += 2;
                    s2 = s3;
                    if (!bl) break block7;
                }
                catch (Throwable throwable) {
                    this.absoluteOffset += 2;
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, UnpickleContext.class, $$$methodRef$$$6, this, throwable2);
                    }
                    throw throwable2;
                }
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, UnpickleContext.class, $$$methodRef$$$6, this, s2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, UnpickleContext.class, $$$methodRef$$$6, this, null);
            }
            return s2;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, UnpickleContext.class, $$$methodRef$$$6, this, throwable3);
            }
            throw throwable;
        }
    }

    public byte[] readLengthBytes() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, UnpickleContext.class, $$$methodRef$$$7, this, new Object[0]);
            }
            long variable_length = this.readLong();
            byte[] byArray = this.readBytes((int)variable_length);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, UnpickleContext.class, $$$methodRef$$$7, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, UnpickleContext.class, $$$methodRef$$$7, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, UnpickleContext.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    public void skipLengthBytes() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, UnpickleContext.class, $$$methodRef$$$8, this, new Object[0]);
            }
            long variable_length = this.readLong();
            this.absoluteOffset = (int)((long)this.absoluteOffset + variable_length);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, UnpickleContext.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, UnpickleContext.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, UnpickleContext.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void skipTo(long l2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, UnpickleContext.class, $$$methodRef$$$9, this, l2);
            }
            if (offset > (long)(this.absoluteOffset - this.beginOffset)) {
                this.absoluteOffset = this.beginOffset + (int)offset;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, UnpickleContext.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, UnpickleContext.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, UnpickleContext.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void skipTo(int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, UnpickleContext.class, $$$methodRef$$$10, this, n2);
            }
            if (offset > this.absoluteOffset - this.beginOffset) {
                this.absoluteOffset = this.beginOffset + offset;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, UnpickleContext.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, UnpickleContext.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, UnpickleContext.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    public void mark() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, UnpickleContext.class, $$$methodRef$$$11, this, new Object[0]);
            }
            this.markedOffset = this.absoluteOffset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, UnpickleContext.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, UnpickleContext.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, UnpickleContext.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    public void reset() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, UnpickleContext.class, $$$methodRef$$$12, this, new Object[0]);
            }
            this.absoluteOffset = this.markedOffset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, UnpickleContext.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, UnpickleContext.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, UnpickleContext.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    public void markAndSkip() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, UnpickleContext.class, $$$methodRef$$$13, this, new Object[0]);
            }
            this.markedOffset = this.absoluteOffset + 4;
            this.absoluteOffset = this.beginOffset + (int)this.readLong();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, UnpickleContext.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, UnpickleContext.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, UnpickleContext.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void markAndSkip(long l2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, UnpickleContext.class, $$$methodRef$$$14, this, l2);
            }
            this.markedOffset = this.absoluteOffset;
            this.absoluteOffset = this.beginOffset + (int)offset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, UnpickleContext.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, UnpickleContext.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, UnpickleContext.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void skipBytes(int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, UnpickleContext.class, $$$methodRef$$$15, this, n2);
            }
            if (n3 >= 0) {
                this.absoluteOffset += n3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, UnpickleContext.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, UnpickleContext.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, UnpickleContext.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isNull(int n2) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void idx;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, UnpickleContext.class, $$$methodRef$$$16, this, n2);
            }
            boolean bl2 = this.nullIndicators[idx];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, UnpickleContext.class, $$$methodRef$$$16, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, UnpickleContext.class, $$$methodRef$$$16, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, UnpickleContext.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    public int absoluteOffset() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, UnpickleContext.class, $$$methodRef$$$17, this, new Object[0]);
            }
            int n2 = this.absoluteOffset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, UnpickleContext.class, $$$methodRef$$$17, this, n2);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, UnpickleContext.class, $$$methodRef$$$17, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, UnpickleContext.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    public int offset() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, UnpickleContext.class, $$$methodRef$$$18, this, new Object[0]);
            }
            int n2 = this.absoluteOffset - this.beginOffset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, UnpickleContext.class, $$$methodRef$$$18, this, n2);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, UnpickleContext.class, $$$methodRef$$$18, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, UnpickleContext.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    public byte[] image() throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, UnpickleContext.class, $$$methodRef$$$19, this, new Object[0]);
            }
            byte[] byArray = this.image;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, UnpickleContext.class, $$$methodRef$$$19, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, UnpickleContext.class, $$$methodRef$$$19, this, null);
            }
            return this.image;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, UnpickleContext.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$21 = UnpickleContext.class.getDeclaredConstructor(byte[].class, Integer.TYPE, boolean[].class, long[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = UnpickleContext.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = UnpickleContext.class.getDeclaredMethod("image", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = UnpickleContext.class.getDeclaredMethod("offset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = UnpickleContext.class.getDeclaredMethod("absoluteOffset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = UnpickleContext.class.getDeclaredMethod("isNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = UnpickleContext.class.getDeclaredMethod("skipBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = UnpickleContext.class.getDeclaredMethod("markAndSkip", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = UnpickleContext.class.getDeclaredMethod("markAndSkip", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = UnpickleContext.class.getDeclaredMethod("reset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = UnpickleContext.class.getDeclaredMethod("mark", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = UnpickleContext.class.getDeclaredMethod("skipTo", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = UnpickleContext.class.getDeclaredMethod("skipTo", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = UnpickleContext.class.getDeclaredMethod("skipLengthBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = UnpickleContext.class.getDeclaredMethod("readLengthBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = UnpickleContext.class.getDeclaredMethod("readShort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = UnpickleContext.class.getDeclaredMethod("readLong", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = UnpickleContext.class.getDeclaredMethod("readBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = UnpickleContext.class.getDeclaredMethod("skipPtrBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = UnpickleContext.class.getDeclaredMethod("readPtrBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = UnpickleContext.class.getDeclaredMethod("readVarNumBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = UnpickleContext.class.getDeclaredMethod("readByte", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

