/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.function;

import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;

public final class Signature {
    public static final Signature EMPTY = new Signature(-1, false, -1, PythonUtils.EMPTY_TRUFFLESTRING_ARRAY, PythonUtils.EMPTY_TRUFFLESTRING_ARRAY);
    public static final Signature GENERIC_VARARGS = new Signature(-1, true, 0, null, null);
    private final int varArgIndex;
    private final int positionalOnlyArgIndex;
    private final boolean takesVarKeywordArgs;
    private final boolean checkEnclosingType;
    private final boolean hidden;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final TruffleString[] positionalParameterNames;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final TruffleString[] keywordOnlyNames;
    private final TruffleString raiseErrorName;

    public Signature(boolean takesVarKeywordArgs, int takesVarArgs, TruffleString[] parameterIds, TruffleString[] keywordNames) {
        this(-1, takesVarKeywordArgs, takesVarArgs, parameterIds, keywordNames);
    }

    public Signature(int positionOnlyArgIndex, boolean takesVarKeywordArgs, int takesVarArgs, TruffleString[] parameterIds, TruffleString[] keywordNames) {
        this(positionOnlyArgIndex, takesVarKeywordArgs, takesVarArgs, parameterIds, keywordNames, false);
    }

    public Signature(int positionOnlyArgIndex, boolean takesVarKeywordArgs, int takesVarArgs, TruffleString[] parameterIds, TruffleString[] keywordNames, boolean checkEnclosingType) {
        this(positionOnlyArgIndex, takesVarKeywordArgs, takesVarArgs, parameterIds, keywordNames, checkEnclosingType, StringLiterals.T_EMPTY_STRING);
    }

    public Signature(int positionOnlyArgIndex, boolean takesVarKeywordArgs, int takesVarArgs, TruffleString[] parameterIds, TruffleString[] keywordNames, boolean checkEnclosingType, TruffleString raiseErrorName) {
        this(positionOnlyArgIndex, takesVarKeywordArgs, takesVarArgs, parameterIds, keywordNames, checkEnclosingType, raiseErrorName, false);
    }

    public Signature(int positionOnlyArgIndex, boolean takesVarKeywordArgs, int takesVarArgs, TruffleString[] parameterIds, TruffleString[] keywordNames, boolean checkEnclosingType, TruffleString raiseErrorName, boolean hidden) {
        this.positionalOnlyArgIndex = positionOnlyArgIndex;
        this.takesVarKeywordArgs = takesVarKeywordArgs;
        this.varArgIndex = takesVarArgs;
        this.positionalParameterNames = parameterIds != null ? parameterIds : PythonUtils.EMPTY_TRUFFLESTRING_ARRAY;
        this.keywordOnlyNames = keywordNames != null ? keywordNames : PythonUtils.EMPTY_TRUFFLESTRING_ARRAY;
        this.checkEnclosingType = checkEnclosingType;
        this.raiseErrorName = raiseErrorName;
        this.hidden = hidden;
    }

    public int getNumOfRequiredKeywords() {
        return this.keywordOnlyNames.length;
    }

    public int getMaxNumOfPositionalArgs() {
        return this.positionalParameterNames.length;
    }

    public int getPositionalOnlyArgIndex() {
        return this.positionalOnlyArgIndex;
    }

    public boolean takesVarArgs() {
        return this.varArgIndex != -1;
    }

    public boolean takesVarKeywordArgs() {
        return this.takesVarKeywordArgs;
    }

    public TruffleString[] getParameterIds() {
        return this.positionalParameterNames;
    }

    public TruffleString[] getKeywordNames() {
        return this.keywordOnlyNames;
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString[] getVisibleKeywordNames() {
        ArrayList<TruffleString> visibleKeywordNames = new ArrayList<TruffleString>(this.keywordOnlyNames.length);
        for (TruffleString k : this.keywordOnlyNames) {
            if (k.byteLength(PythonUtils.TS_ENCODING) <= 0 || k.codePointAtByteIndexUncached(0, PythonUtils.TS_ENCODING) == 36) continue;
            visibleKeywordNames.add(k);
        }
        return (TruffleString[])visibleKeywordNames.toArray(TruffleString[]::new);
    }

    public boolean takesKeywordArgs() {
        return this.keywordOnlyNames.length > 0 || this.takesVarKeywordArgs;
    }

    public boolean takesPositionalOnly() {
        return !this.takesVarArgs() && !this.takesVarKeywordArgs && this.keywordOnlyNames.length == 0;
    }

    public boolean takesNoArguments() {
        return this.positionalParameterNames.length == 0 && this.takesPositionalOnly();
    }

    public boolean checkEnclosingType() {
        return this.checkEnclosingType;
    }

    public TruffleString getRaiseErrorName() {
        return this.raiseErrorName;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public static Signature fromCallTarget(RootCallTarget callTarget) {
        Signature signature;
        RootNode rootNode = callTarget.getRootNode();
        if (rootNode instanceof PRootNode) {
            PRootNode rootNode2 = (PRootNode)rootNode;
            signature = rootNode2.getSignature();
        } else {
            signature = GENERIC_VARARGS;
        }
        return signature;
    }
}

