/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ItertoolsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.itertools.AccumulateBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.AccumulateBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.itertools.PAccumulate;
import com.oracle.graal.python.builtins.objects.itertools.PChain;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.PyNumberAddNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PAccumulate})
public final class AccumulateBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = AccumulateBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return AccumulateBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object setState(PAccumulate self, Object state) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            self.setTotal(state);
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduceNoFunc(VirtualFrame frame, PAccumulate self, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Cached InlinedBranchProfile hasInitialProfile, @Cached InlinedBranchProfile totalNoneProfile, @Cached InlinedBranchProfile totalMarkerProfile, @Cached InlinedBranchProfile elseProfile, @Cached PyObjectGetIter getIter, @Bind PythonLanguage language) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            Object func = self.getFunc();
            if (func == null) {
                func = PNone.NONE;
            }
            if (self.getInitial() != null) {
                hasInitialProfile.enter(inliningTarget);
                Object type = getClassNode.execute(inliningTarget, self);
                PChain chain = PFactory.createChain(language);
                chain.setSource(getIter.execute((Frame)frame, inliningTarget, PFactory.createList(language, new Object[]{self.getIterable()})));
                PTuple initialTuple = PFactory.createTuple(language, new Object[]{self.getInitial()});
                chain.setActive(getIter.execute((Frame)frame, inliningTarget, initialTuple));
                PTuple tuple = PFactory.createTuple(language, new Object[]{chain, func});
                return PFactory.createTuple(language, new Object[]{type, tuple, PNone.NONE});
            }
            if (self.getTotal() == PNone.NONE) {
                totalNoneProfile.enter(inliningTarget);
                PChain chain = PFactory.createChain(language);
                PList noneList = PFactory.createList(language, new Object[]{PNone.NONE});
                Object noneIter = getIter.execute((Frame)frame, inliningTarget, noneList);
                chain.setSource(getIter.execute((Frame)frame, inliningTarget, PFactory.createList(language, new Object[]{noneIter, self.getIterable()})));
                chain.setActive(PNone.NONE);
                PAccumulate accumulate = PFactory.createAccumulate(language);
                accumulate.setIterable(chain);
                accumulate.setFunc(func);
                PTuple tuple = PFactory.createTuple(language, new Object[]{accumulate, 1, PNone.NONE});
                return PFactory.createTuple(language, new Object[]{PythonBuiltinClassType.PIslice, tuple});
            }
            if (self.getTotal() != null) {
                totalMarkerProfile.enter(inliningTarget);
                Object type = getClassNode.execute(inliningTarget, self);
                PTuple tuple = PFactory.createTuple(language, new Object[]{self.getIterable(), func});
                return PFactory.createTuple(language, new Object[]{type, tuple, self.getTotal()});
            }
            elseProfile.enter(inliningTarget);
            Object type = getClassNode.execute(inliningTarget, self);
            PTuple tuple = PFactory.createTuple(language, new Object[]{self.getIterable(), func});
            return PFactory.createTuple(language, new Object[]{type, tuple});
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization
        static Object next(VirtualFrame frame, PAccumulate self, @Bind Node inliningTarget, @Cached TpSlots.GetObjectSlotsNode getSlots, @Cached TpSlotIterNext.CallSlotTpIterNextNode callIterNext, @Cached PyNumberAddNode addNode, @Cached CallNode callNode, @Cached InlinedBranchProfile hasInitialProfile, @Cached InlinedBranchProfile markerProfile, @Cached InlinedConditionProfile hasFuncProfile) {
            if (self.getInitial() != null) {
                hasInitialProfile.enter(inliningTarget);
                self.setTotal(self.getInitial());
                self.setInitial(null);
                return self.getTotal();
            }
            Object it = self.getIterable();
            Object value = callIterNext.execute(frame, inliningTarget, getSlots.execute(inliningTarget, it).tp_iternext(), it);
            if (self.getTotal() == null) {
                markerProfile.enter(inliningTarget);
                self.setTotal(value);
                return value;
            }
            if (hasFuncProfile.profile(inliningTarget, self.getFunc() == null)) {
                self.setTotal(addNode.execute(frame, self.getTotal(), value));
            } else {
                self.setTotal(callNode.execute((Frame)frame, self.getFunc(), self.getTotal(), value));
            }
            return self.getTotal();
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PAccumulate self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="accumulate", minNumOfPositionalArgs=2, parameterNames={"cls", "iterable", "func"}, keywordOnlyNames={"initial"})
    @GenerateNodeFactory
    public static abstract class AccumulateNode
    extends PythonBuiltinNode {
        @Specialization
        protected static PAccumulate construct(VirtualFrame frame, Object cls, Object iterable, Object func, Object initial, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PyObjectGetIter getIter) {
            PAccumulate self = PFactory.createAccumulate(language, cls, getInstanceShape.execute(cls));
            self.setIterable(getIter.execute((Frame)frame, inliningTarget, iterable));
            self.setFunc(func instanceof PNone ? null : func);
            self.setTotal(null);
            self.setInitial(initial instanceof PNone ? null : initial);
            return self;
        }
    }
}

