/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.wire;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.crypto.Cipher;
import org.firebirdsql.gds.JaybirdSystemProperties;
import org.firebirdsql.gds.impl.wire.EncryptedStreamSupport;
import org.firebirdsql.gds.impl.wire.FbCipherInputStream;

class FbInflaterInputStream
extends InflaterInputStream
implements EncryptedStreamSupport {
    private static final System.Logger log = System.getLogger(FbInflaterInputStream.class.getName());
    private static final int BUF_SIZE = Math.max(512, JaybirdSystemProperties.getWireInflateBufferSize(8192));
    private boolean encrypted;

    public FbInflaterInputStream(InputStream in) {
        super(in, new Inflater(), BUF_SIZE);
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (Throwable throwable) {
            this.buf = new byte[1];
            if (log.isLoggable(System.Logger.Level.TRACE)) {
                log.log(System.Logger.Level.TRACE, "FbInflaterInputStream: Compressed bytes: {0} to uncompressed bytes: {1}", this.inf.getBytesRead(), this.inf.getBytesWritten());
            }
            this.inf.end();
            throw throwable;
        }
        this.buf = new byte[1];
        if (log.isLoggable(System.Logger.Level.TRACE)) {
            log.log(System.Logger.Level.TRACE, "FbInflaterInputStream: Compressed bytes: {0} to uncompressed bytes: {1}", this.inf.getBytesRead(), this.inf.getBytesWritten());
        }
        this.inf.end();
    }

    @Override
    public void setCipher(Cipher cipher) throws IOException {
        if (this.encrypted) {
            throw new IOException("Input stream already encrypted");
        }
        this.in = new FbCipherInputStream(this.in, cipher);
        this.encrypted = true;
    }
}

